# Jabber Namespaces

module Jabber
  
  module NS
    # stream 
    NS_CLIENT     = 'jabber:client'
    NS_SERVER     = 'jabber:server'
    NS_ACCEPT     = 'jabber:component:accept'
    
    # iq 
    NS_AUTH       = 'jabber:iq:auth'
    NS_REGISTER   = 'jabber:iq:register'
    NS_ROSTER     = 'jabber:iq:roster'
    NS_AGENT      = 'jabber:iq:agent'
    NS_AGENTS     = 'jabber:iq:agents'
    NS_VERSION    = 'jabber:iq:version'
    NS_TIME       = 'jabber:iq:time'
    NS_PRIVATE    = 'jabber:iq:private'
    NS_SEARCH     = 'jabber:iq:search'
    NS_OOB        = 'jabber:iq:oob'
    NS_ADMIN      = 'jabber:iq:admin'
    NS_FILTER     = 'jabber:iq:filter'
    NS_AUTH_0K    = 'jabber:iq:auth:0k'
    NS_BROWSE     = 'jabber:iq:browse'
    NS_CONFERENCE = 'jabber:iq:conference'
    NS_GATEWAY    = 'jabber:iq:gateway'
    NS_LAST       = 'jabber:iq:last'
    NS_RPC        = 'jabber:iq:rpc'
    
    # x
    NS_OFFLINE    = 'jabber:x:offline'
    NS_DELAY      = 'jabber:x:delay'
    NS_XOOB       = 'jabber:x:oob'
    NS_EVENT      = 'jabber:x:event'
    NS_SIGNED     = 'jabber:x:signed'
    NS_ENCRYPTED  = 'jabber:x:encrypted'
    NS_ENVELOPE   = 'jabber:x:envelope'
    NS_EXPIRE     = 'jabber:x:expire'
    
    # misc
    NS_VCARD      = 'vcard-temp'
    NS_XHTML      = 'http://www.w3.org/1999/xhtml'
    
    IQ_GET        = 'get'
    IQ_SET        = 'set'
    IQ_ERROR      = 'error'
    IQ_RESULT     = 'result'
    
    # other non-namespace constants
    #STREAM_HEAD   = "<?xml version=\'1.0\'?><stream:stream to=\'#{@server}\' xmlns=\'jabber:client\' xmlns:stream=\'http://etherx.jabber.org/streams\'>"
    STREAM_END    = "</stream:stream>"

  end # Module: NS

end # Module: Jabber
