# TODO: 
#  - proper method security
#  - clean up instance variables
#  - general code clean up
#  - abstract Connnection object and subclass it into
#  Connection::Client and Connection::Component
# 

require 'sha1'
require 'socket'

require 'rjab/conn/node'
require 'rjab/conn/ns'
require 'rjab/conn/xmllistener'

module Jabber

class Connection
  include Jabber::NS
  include Jabber::XMLListener

  def initialize(server, port, ns, localname, log=nil)
    # instance vars instantiated at object creation
    @server, @port = server, port || 5222
    @ns = ns || NS_CLIENT
    @localname = localname
    @log = log
    
    # instance vars instantiated later in program
    @answer, @ask_id = nil
    @beatcount = 0
    @connected = false
    @handlers = []
    
    # vars for XMLListener
    @depth = 1
    @currnode = nil
    @streamerror = false
    @confirmedhost, @streamid, @errortext  = ""
  end
  
  def connect
    # FIXME: wrap in begin / rescue block
    @socket = TCPSocket.open(@server, @port)
    self.write(stream_header)
    self.read
    @connected = true
  end

  def disconnect
    self.write(STREAM_END)
    @socket.shutdown
  end
  
  def process(time)
    if IO.select([@socket], nil, nil, time)
      return self.read
    end
  end

  def parse_data(source)                        # TODO?: subclass REXML::Source    
    REXML::Document.parse_stream(source, self)  #  so that it works properly with
  end                                           #  sockets

  def auth(*args)
    # FIXME: wrap in begin/rescue block
    if @ns == NS_CLIENT
      @user, @pass = args[0], args[1]
      @resource = args[2]

      auth_node = Node.new('iq')
      auth_node.root.attributes['type'] = IQ_GET
      query = auth_node.root.add_element('query')
      query.attributes['xmlns'] = NS_AUTH
      query.add_element('username').text = @user

      get_result = ask(auth_node)

      auth_node.root.attributes['type'] = IQ_SET
      auth_node.root.attributes['id'] = get_id
      
      if get_result.root.elements['token']
	hash = SHA1.new(@pass).hexdigest
	seq = get_result.root.elements['sequence'].text.to_i
	token = get_result.root.elements['token'].text
	hash = SHA1.new(hash + token).hexdigest
	seq.downto(1) { hash = SHA1.new(hash).hexdigest }
	query.add_element('hash').text = hash
      elsif get_result.root.elements['digest']
	query.add_element('digest').text = SHA1.new(@streamid + @pass).hexdigest
      elsif get_result.root.elements['password']
	debug("auth: plaintext supported")
	query.add_element('password').text = @pass
      else
	debug("auth: no authentication methods supported...")
	raise
      end
      
      query.add_element('resource').text = @resource
     
      set_result = ask(auth_node)
      unless (set_result.root.attributes['type'] == IQ_RESULT)
	puts "AUTH FAILED!!!"
	disconnect
	raise
      else
	puts "Auth succeeded!!!"
      end
    elsif @ns == NS_ACCEPT
      @secret = args[0]
    end
  end

  def stream_header
    # FIXME: find a way to move this crap into Jabber::NS and still allow for 
    #  variable substitution
    header = "<?xml version=\'1.0\'?><stream:stream to=\'#{@server}\' xmlns=\'jabber:client\' xmlns:stream=\'http://etherx.jabber.org/streams\'>"
  end

  def send(data)
    # FIXME: compact method
    if data.instance_of? Node
      str = ""
      data.write str, -1
      self.write str
    else
      self.write data
    end
  end

  def write(data)
    debug("Write: #{data}") 
    @socket.write(data)
  end
  
  def read
    recieved = ""
    while data = @socket.recv(1024)
      recieved += data
      break if data != 1024
    end
    
    debug("Read: #{recieved}")
    
    # ewww... grotesque
    if recieved =~ /<stream/ 
      debug("Read: munging so REXML is happy")
      recieved.chop!.concat('/>')
    end

    parse_data(recieved)
    return recieved
  end

  def log(log_string)
    if @log then puts "LOG: #{log_string}" end
  end
  
  def debug(debug_string)
    if $DEBUG then puts "DEBUG: #{debug_string}" end
  end
 
  def last_error; end

  def dispatch(node)
    debug("dispatching: #{node.root.name}")

    if @ask_id != nil
      @ask_id = nil
      @answer = node
    end
    
    @handlers.each do |name, obj|
      if name == node.root.name
	obj.call(node)
      end
    end
  end
  
  def ask(node)
    unless @ask_id = node.root.attributes['id']
      debug("Ask: no ID - getting one")
      @ask_id = get_id
      node.root.attributes['id'] = @ask_id
    end
    debug("Ask: id = #{@ask_id}")

    str = ""
    node.write str, -1
    self.write str
    
    while (@answer == nil)
      debug("Ask: waiting for answer")
      process(1)
    end

    answer = @answer
    @answer = nil
    debug("Ask: got answer") # FIXME: write out XML of answer
    return answer
  end
  
  def register_handler(tag, &handler)
    debug("Register_handler: tag type: #{tag}")
    @handlers << [tag, handler]
  end

  def register_beat; end

  def start; end

  def connected; end

  def check_connected; end

  def get_id
    "rjab_#{Time.now.tv_sec}" # "rjab_seconds_since_epoch"
  end
  
  def heartbeat; end

end # Class: Connection

end # Module: Jabber
