require "test/unit/testcase"
require "rexml/document"

class StreamTester < Test::Unit::TestCase
  # Submitted by Han Holl
  def test_listener
    data = %Q{<session1 user="han" password="rootWeiler" />\n<session2 user="han" password="rootWeiler" />}

    b = RequestReader.new( data )
    b = RequestReader.new( data )
  end
end

# For test_listener
class RequestReader
  attr_reader :doc
  def initialize(io)
    @stack = []
    @doc = nil
    catch(:fini) do
      REXML::Document.parse_stream(io, self)
      raise IOError
    end
  end
  def tag_start(name, args)
    if @doc
      @stack.push(REXML::Element.new(name, @stack.last))
    else
      @doc = REXML::Document.new("<#{name}/>")
      @stack.push(@doc.root)
    end
    args.each do |attr,val|
      @stack.last.add_attribute(attr, val)
    end
  end
  def tag_end(name, *args)
    @stack.pop
    throw(:fini) if @stack.empty?
  end
  def text(str)
    @stack.last.text = str
  end
  def comment(str)
  end
end
