#!/bin/env ruby
require 'ftools'
require 'nfsstore.rb'

STDOUT.sync = true
STDERR.sync = true


def timestamp t
  usec = t.usec
  t.strftime("%Y-%m-%d %H:%M:%S") << ".#{ usec }"
end


div = '=' * 79 
line = '-' * 79 


path = ARGV[0] || 'nfs.db'
sleeptime = Integer(ARGV[1] || 2)
db = NFSStore.new path 

loop do
  puts div, div 
#
# load data using snapshot
#
  puts "loading..."
  at = Time.now
  snapshot = db.snapshot
  bt = Time.now
  list = snapshot['list']
  puts "elapsed <#{ bt - at }s>", line

  puts "list.size <#{ list.size }>", line
#
# compute some stats 
#
  puts "computing stats..."
  at = Time.now

  hostlists = Hash.new{|h,k| h[k] = Array.new} 
  list.each do |entry|
    n, host, time = entry
    hostlists[host.strip.chomp] << entry if host
  end

  stats = 
    Hash.new{|h,k| h[k] = Hash[:total=>0,:max=>0.0,:min=>0.0,:avg=>0.0,:recent=>nil]}

  hostlists.each do |host,hostlist|
    hostlist.sort!
    stats[host][:total] = hostlist.size
    #stats[host][:recent] = Time.at hostlist[-1][-1].to_i
    stats[host][:recent] = timestamp(Time.at hostlist[-1][-1])

    while a = hostlist.shift and b = hostlist.shift
      elapsed = b[-1] - a[-1]
      stats[host][:min] = elapsed if stats[host][:min] > elapsed 
      stats[host][:max] = elapsed if stats[host][:max] < elapsed 
      stats[host][:avg] = (stats[host][:avg] + elapsed) / 2 
    end  
  end 

  bt = Time.now
#
# display summary
#
  puts "elapsed <#{ bt - at}>", line

  puts "last 16 list elements...", line
  list.last(16).each{|row| p row}
  puts line

  puts "summary", line
  stats.each do |host,stat|
    printf "%s\n\tmax : %s\n\tmin : %s\n\tavg : %s\n\ttotal : %s\n\trecent : %s\n", 
      host, stat[:max], stat[:min], stat[:avg], stat[:total], stat[:recent] 
  end
  puts line

  sleep sleeptime 
  sleep rand
  puts
end
