
$:.unshift 'lib'
$:.unshift '../lib'
require 'nfsstore'

#
# opts are passed through to lockfile
#

db = NFSStore.new 'nfs.db', 'max_age' => 300, 'refresh' => 10 

db.transaction do
  list = (db.root?('list') ? db['list'] : db['list'] = [])
  list << [list.size, NFSStore::HOSTNAME, Time.now.to_f]
  db['list'] = list
end

#
# a read only snapshot of the db can be taken - this tries hard not to get a
# lock, but eventually will if nolock attempts fail - see src for details
#

snapshot = db.snapshot
snapshot['list'].each{|item| p item}
