#######################################
# tc_pingtcp.rb
#
# Test case for the Net::PingTCP class
#######################################
require "ftools"

if caller.first =~ /test\.rb/
   base_dir = Dir.pwd
else
   base_dir = File.dirname(Dir.pwd)
end

net_dir = base_dir + "/net"
ping_file = net_dir + "/pingsimple.rb"

$:.unshift base_dir
$:.unshift Dir.pwd

require "test/unit"
require "net/pingsimple"
include Net

class TC_PingTCP < Test::Unit::TestCase
   def setup
      @host = "www.ruby-lang.org"
   end

   def test_01_version
      assert_equal("0.3.0",PingTCP::VERSION,"Bad version constant")
   end

   def test_02_ping_standard
      PingTCP.ecr = false
      @tcp = PingTCP.new(@host)
      assert_equal(false,@tcp.ping?,"Bad ping")
      assert_equal(false,@tcp.exception.nil?,"Bad exception data")
   end

   def test_03_ecr_type
      assert_raises(RuntimeError){ PingTCP.ecr = "blah" }
   end

   # Change econnrefused setting
   def test_04_ping_ecr_true
      PingTCP.ecr = true
      @ltcp = Net::PingTCP.new(@host)
      assert_equal(true,@ltcp.ping?,"Invalid ping: " + @ltcp.exception.to_s)
   end

   def teardown
      @host = nil
      @tcp  = nil
      @ltcp = nil
   end
end
