############################################
# tc_pingext.rb
#
# Test case for the Net::PingExternal class
############################################
require "ftools"

Dir.chdir ".." if File.basename(Dir.pwd) == "test"
$:.unshift Dir.pwd

=begin
if caller.first =~ /test\.rb/
   base_dir = Dir.pwd
else
   base_dir = File.dirname(Dir.pwd)
end

net_dir = base_dir + "/net"
ping_file = net_dir + "/pingsimple.rb"

$:.unshift base_dir
$:.unshift Dir.pwd
=end

require "test/unit"
require "net/pingsimple"
include Net

class TC_PingTCP < Test::Unit::TestCase
   def setup
      @host = "www.ruby-lang.org"
      @bogus = "www.blahblahblahblahblah.com"
      @ext = nil
   end

   def test_01_version
      assert_equal("0.3.0",PingExternal::VERSION,"Bad version constant")
   end

   def test_02_good_ping
      @ext = PingExternal.new(@host)
      assert_equal(true,@ext.ping?,"Bad ping")
   end

   def test_03_bad_ping
      @ext = PingExternal.new(@bogus)
      assert_equal(false,@ext.ping?,"Bad ping")
      assert_equal(false,@ext.exception.nil?,"Bad exception data")
   end

   def teardown
      @host = nil
      @ext  = nil
      @lext = nil
   end
end
