require 'mindi'

class Transformer
  def transform string
    string.gsub(pattern, &replacement)
  end
end

class TransformerContainer
  include MinDI::InjectableContainer

  pattern     { /foo/ }
  replacement { proc {|match| match.upcase } }
  transformer { Transformer.new }
  transform   { |str| transformer.transform(str) }
end

cont = TransformerContainer.new
s1 = cont.transform("fo foo fee")
s2 = cont.transform("fo foo fee")
p s1              # ==> "fo FOO fee"
p s1.equal?(s2)   # ==> true
