require 'drb/drb'
require 'singleton'

class RWikiToDo
  include Singleton

  RWIKI_URI = 'druby://localhost:8470'

  def initialize
    @ro = DRbObject.new(nil, RWIKI_URI)
  end

  def latest_todo(links)
    ary = links.find_all {|nm| /^ToDo\d\d\d$/ =~ nm}    
    ary.max
  end

  def next_todo(name)
    name.succ #FIXME
  end

  def try_add(summary)
    index = @ro.page('ToDo')
    revision = index.revision
    latest = latest_todo(index.links)
    curr = next_todo(latest)
    
    newline = "* ((<#{curr}>)) ... #{summary}\n"
    ary = []
    index.src.each do |ln|
      if newline && /^\* / =~ ln
	ary.push newline
	newline = nil
      end
      ary.push ln
    end

    index.set_src(ary.join, revision)
    @ro.page(curr).src = new_todo(curr, summary)
    curr
  end

  def add(summary)
    count = 3
    begin
      return try_add(summary)
    rescue
      count -= 1
      retry if count >= 0
      return 'ToDo'
    end
  end
  
  def new_todo(name, summary)
    <<EOP
= #{name}

#{summary}

== comment

== status

* : ((<open>))
* ʬ: ((<misc>)) {RWiki, WEBrick, Div, dRuby, SOAP4R, Ruby, misc}
* ô: ((<who>))

== history

* #{Time.now.strftime("%Y-%m-%d")} who: open
EOP
  end
end

class RWikiToDoDiv < Div::Div
  set_erb('rwtodo.erb')

  VIEW_URL = 'http://rrr.jin.gr.jp/rwiki?cmd=view;name='
  # VIEW_URL = 'http://192.168.1.11/cgi-bin/rw-cgi.rb?cmd=view;name='

  def initialize(session)
    super(session)
    @model = RWikiToDo.instance
  end

  def div_id
    'rwtodo'
  end

  def do_add(context, params)
    summary ,= params['summary']
    return unless summary && summary.length > 0
    name = @model.add(summary)
    return unless name

    context.res_header('status', '302')
    context.res_header('location', VIEW_URL + name)
    context.res_body('')
    context.done
  end
end
