require 'webrick'
require 'tofu/tofulet'
require 'drb/drb'
require 'rinda/ring'
require 'tofu/ring'

def main
  DRb.start_service

  logger = WEBrick::Log::new($stderr, WEBrick::Log::DEBUG)

  s = WEBrick::HTTPServer.new(:Port => 2000,
			      :AddressFamily => Socket::AF_INET,
			      :BindAddress => ENV['HOSTNAME'],
			      :Logger => logger)

  ring = Tofu::RingTofuletProvider.new(s)
  ring.join

  s.mount('/~seki/tdiary-theme', WEBrick::HTTPServlet::FileHandler,
	  '/home/mas/public_html/tdiary-theme', {})

  trap("INT"){ s.shutdown }
  s.start
end

unless $DEBUG
  # run as a daemon ...
  exit!(0) if fork
  Process.setsid
  exit!(0) if fork

  STDIN.reopen('/dev/null')
  STDOUT.reopen('/dev/null', 'w')
  STDERR.reopen('/dev/null', 'w')
end

main

