require 'div'

class MBoxDiv < Div::Div
  set_erb('mbox.erb')

  def initialize(session, mbox)
    super(session)
    @mbox = mbox
    @mode = :browse
  end

  def remove(key)
    @mbox.remove(session.username, key)
  end

  def add(text, to)
    @mbox.add(text, session.username, to)
  end

  def to_args(params)
    key, = params['key']
    text, = params['text']
    to, = params['to']
    return key, text, to
  end

  def do_remove(context, params)
    key, = to_args(params)
    remove(key)
  end

  def do_edit(context, params)
    @mode = :edit
  end
  
  def do_browse(context, params)
    @mode = :browse
  end

  def do_add(context, params)
    key, text, to = to_args(params)
    add(text, to)
  end
end

