require "div/div"
require "enquete"

class EnqueteDiv < Div::Div
  set_erb('enquete.erb')

  def initialize(session, enquete_db)
    super(session)
    @enquete_db = enquete_db
    @mode = :browse
    @num = nil
  end

  def to_args(params)
    num, = params['num']
    if (!num) or (num == "")
      num = nil
    else
      num = num.to_i
    end
    question, = params['question']
    return num, question
  end

  def do_vote_yes(context, params)
    num, = to_args(params)
    @enquete_db.inc_yes(num)
  end

  def do_vote_no(context, params)
    num, = to_args(params)
    @enquete_db.inc_no(num)
  end

  def do_browse(context, params)
    @num,  = to_args(params)
    @mode = :browse
  end

  def do_edit(context, params)
    @mode = :edit
  end

  def do_add(context, params)
    num, question, = to_args(params)
    add(question)
    @num = nil
    @mode = :browse
  end

  def add(question)
    @enquete_db.new_enquete(question)
  end
end
