require 'div'

class CounterDiv < Div::Div
  @erb_fname = 'counter.erb'
  def_erb_method('to_html(session=nil)', @erb_fname)

  def initialize(session)
    super(session)
    @counter = 0
  end

  def do_set(req, params)
    num, = params['num']
    @counter = num.to_i if num
  end

  def do_up(req, params)
    @counter += 1
  end

  def do_down(req, params)
    @counter -= 1
  end
end

