require 'lib/address'

class MainPage < CKComponent
	attr_accessor :address_book, :address, :index, :country, :language

	ADDRESS_FILE = 'addresses.txt'

	def init
		@address_book = AddressManager.new ADDRESS_FILE
		@country  = ['Japan','China','America','England','France','Italy','Spain']
	end

	def tr_bgcolor
		if (@index % 2) == 1 then
			"#999999"
		else
			"#cccccc"
		end
	end

	def edit
		@address_book.each_with_index do | address, index |
			if address.delete? == true then
				@address_book[index].delete
			end
		end
		@address_book.write
	end

	def add
		@address_book << Address.new
		@address_book.write
	end
end
