/*
 *  RSGISFindInfoBetweenLayers.h
 *  RSGIS_LIB
 *
 *  Created by Pete Bunting on 30/09/2012.
 *  Copyright 2012 RSGISLib.
 *
 *  RSGISLib is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  RSGISLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with RSGISLib.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef RSGISFindInfoBetweenLayers_H
#define RSGISFindInfoBetweenLayers_H

#include <iostream>
#include <string>
#include <cmath>
#include <list>

#include "gdal_priv.h"
#include "gdal_rat.h"

#include "rastergis/RSGISRasterAttUtils.h"

#include "common/RSGISAttributeTableException.h"

#include "img/RSGISImageCalcException.h"
#include "img/RSGISCalcImageValue.h"
#include "img/RSGISCalcImage.h"

#include <boost/numeric/conversion/cast.hpp>
#include <boost/lexical_cast.hpp>

// mark all exported classes/functions with DllExport to have
// them exported by Visual Studio
#undef DllExport
#ifdef _MSC_VER
    #ifdef rsgis_rastergis_EXPORTS
        #define DllExport   __declspec( dllexport )
    #else
        #define DllExport   __declspec( dllimport )
    #endif
#else
    #define DllExport
#endif

namespace rsgis{namespace rastergis{

    class DllExport RSGISFindInfoBetweenLayers
    {
    public:
        RSGISFindInfoBetweenLayers();
        void findClassMajority(GDALDataset *baseSegmentsDS, GDALDataset *infoSegmentsDS, std::string baseClassCol, std::string infoClassCol, bool ignoreZero = true, int baseRatBand=1, int infoRatBand=1);
        ~RSGISFindInfoBetweenLayers();
    };


    class DllExport RSGISCalcClumpClassMajorities : public rsgis::img::RSGISCalcImageValue
	{
	public:
        RSGISCalcClumpClassMajorities(std::string *baseColData, std::string *infoColData, std::vector<std::string> classes, unsigned int **clumpCounter, bool ignoreZero = true);
		void calcImageValue(float *bandValues, int numBands);
		~RSGISCalcClumpClassMajorities();
    protected:
        std::string *baseColData;
        std::string *infoColData;
        std::vector<std::string> classes;
        unsigned int **clumpCounter;
        bool ignoreZero;
	};

}}

#endif

