/*
 *  RSGISOGRPolygonReader.h
 *  RSGIS_LIB
 *
 *  Created by Pete Bunting on 01/03/2010.
 *  Copyright 2009 RSGISLib. All rights reserved.
 *  This file is part of RSGISLib.
 * 
 *  RSGISLib is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  RSGISLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with RSGISLib.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef RSGISOGRPolygonReader_H
#define RSGISOGRPolygonReader_H

#include <iostream>
#include <string>
#include <list>

#include "ogrsf_frmts.h"

#include "common/RSGISVectorException.h"

#include "vec/RSGISVectorOutputException.h"
#include "vec/RSGISProcessOGRFeature.h"
#include "vec/RSGISVectorUtils.h"

#include "geos/index/SpatialIndex.h"

// mark all exported classes/functions with DllExport to have
// them exported by Visual Studio
#undef DllExport
#ifdef _MSC_VER
    #ifdef rsgis_vec_EXPORTS
        #define DllExport   __declspec( dllexport )
    #else
        #define DllExport   __declspec( dllimport )
    #endif
#else
    #define DllExport
#endif

namespace rsgis{namespace vec{
	
	class DllExport RSGISOGRPolygonReader : public RSGISProcessOGRFeature
	{
	public:
		RSGISOGRPolygonReader(std::vector<OGRPolygon*> *polygons);
		void processFeature(OGRFeature *inFeature, OGRFeature *outFeature, geos::geom::Envelope *env, long fid);
		void processFeature(OGRFeature *feature, geos::geom::Envelope *env, long fid);
		void createOutputLayerDefinition(OGRLayer *outputLayer, OGRFeatureDefn *inFeatureDefn);
		~RSGISOGRPolygonReader();
	protected:
        std::vector<OGRPolygon*> *polygons;
	};
    
    
    class DllExport RSGISOGRPolygonReader2Index : public RSGISProcessOGRFeature
    {
    public:
        RSGISOGRPolygonReader2Index(geos::index::SpatialIndex *polysIdx);
        void processFeature(OGRFeature *inFeature, OGRFeature *outFeature, geos::geom::Envelope *env, long fid);
        void processFeature(OGRFeature *feature, geos::geom::Envelope *env, long fid);
        void createOutputLayerDefinition(OGRLayer *outputLayer, OGRFeatureDefn *inFeatureDefn);
        ~RSGISOGRPolygonReader2Index();
    protected:
        geos::index::SpatialIndex *polysIdx;
    };
    
    
   
    
    
}}

#endif



