/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_ScriptManager
#define GUARD_ScriptManager

#include <squirrel.h>

#include <string>
#include <vector>

enum WakeEventType {
WET_NONE,
WET_TIME,
WET_PORTRAIT_FINISHED,
WET_ALL_BIG_SELECTED,
WET_NUMBER_HOTKEYED,
WET_SHIPS_MOVING_DOWN,
WET_MISSIONS_OPEN,
WET_TWO_FIGHTERS_SELECTED,
WET_RECON_TARGET_OPEN,
WET_RECON_LAUNCHED,
WET_FREIGHTER_FOUND,
WET_BOMBERS_COMING_IN,
WET_ATTACK_BOMBER_LAUNCHED,
WET_ENEMY_UNDER_ATTACK,
WET_ALL_BIG_SHIPS_DEAD,
WET_CUSTOM_AI_TASK_0,
WET_CUSTOM_AI_TASK_1,
WET_CUSTOM_AI_TASK_2,
WET_CUSTOM_AI_TASK_3,
WET_CUSTOM_AI_TASK_4
};

class SquadArray {
public:
	SquadArray(const std::wstring& i_name, int i_side): name(i_name), my_side(i_side) {}
	std::wstring name;
	int my_side;
};

class SquirrelVM {
public:
	SquirrelVM(HSQUIRRELVM i_vm, int i_side): vm(i_vm), wakeup_time(-1), wait_event(WET_NONE), side(i_side) {}
	SquirrelVM() {}

	HSQUIRRELVM vm;
	int wakeup_time;
	WakeEventType wait_event;
	int side;

	std::vector<SquadArray> squad_arrays;
};

class ScriptManager {
public:
	void set_mission_script(const std::wstring& filename);
	void add_ai_script(const std::wstring& filename, int side);
	void run();
	void delete_squad(int side, int squad);
	void shutdown();

	void set_wakeup_event(WakeEventType type, int frames = -1);
	void fire_wakeup_event(WakeEventType type);
	void suspend_ai_script(HSQUIRRELVM vm);

	WakeEventType wakeup_reason;
	int which_side_dead;

private:
	HSQUIRRELVM setup_vm();
	void setup_vm_for_ai(HSQUIRRELVM vm, SquirrelVM& vm_container, int side);
	void run_script(HSQUIRRELVM vm, const std::wstring& filename);

	std::vector<SquirrelVM> vms;
};



#endif
