/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#include "Display.h"
#include "Globals.h"
#include "SettingsStruct.h"
#include "Terrain.h"
#include "World.h"

TerrainTile::TerrainTile() {
	for (int i = 0; i != max_players; ++i)
		num_seeing[i] = 0;
}

ForegroundPic::ForegroundPic(int i_x, int i_y, const ScaledPic& i_pic):
scaled_pic(i_pic) {
	rect.x = i_x;
	rect.y = i_y;
	rect.w = scaled_pic.w;
	rect.h = scaled_pic.h;
}

void ForegroundPic::draw_self() {
	static SDL_Rect screen_rect;

	screen_rect.x = static_cast<Uint16>(rect.x - world.viewx);
	screen_rect.y = static_cast<Uint16>(rect.y - world.viewy);
	screen_rect.w = static_cast<Uint16>(rect.w);
	screen_rect.h = static_cast<Uint16>(rect.h);

	//no point in clipping when blitting is automatically clipped to the screen anyhow
	display.blt(scaled_pic.pic, screen_rect, GL_EFFECT_SCALED);
}

