/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#include "StandardColors.h"
#include "Globals.h"
#include "Display.h"
#include "SettingsStruct.h"

void StandardColors::init() {
	text_blue = display.map_rgb(210, 222, 255);
	light_blue = display.map_rgb(89, 154, 214);	
	dark_blue = display.map_rgb(0, 36, 65);	
    
	big_range_blue = display.map_rgb(60, 130, 210);

	laser_red = display.map_rgb(204, 0, 0);
	laser_green = display.map_rgb(0, 190, 0);
	laser_blue = display.map_rgb(0, 0, 220);
	laser_yellow = display.map_rgb(214, 214, 0);
	missile_grey = display.map_rgb(206, 206, 206);
	torpedo_blue = display.map_rgb(36, 96, 226);

	side_blue = light_blue;
	side_red = display.map_rgb(160, 0, 0);
	side_green = display.map_rgb(60, 150, 40);
	side_yellow = display.map_rgb(255, 255, 100);

	radar_red = display.map_rgb(255, 80, 80);
	radar_green = display.map_rgb(60, 220, 40);
	radar_blue = display.map_rgb(100, 140, 255);
	radar_yellow = display.map_rgb(230, 230, 0);

	shield_green = display.map_rgb(21, 135, 24);
	armour_blue = display.map_rgb(36, 89, 103);

	black = display.map_rgb(0, 0, 0);
	white = display.map_rgb(255, 255, 255);
	grey_text = display.map_rgb(150, 150, 150);
}
