/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_Sound
#define GUARD_Sound

#include "GlobalConstants.h"

#include <SDL_mixer.h>

#include <map>
#include <string>

enum SoundEffect {
	SE_NO_SOUND,
	SE_COORDINATES_SET,
	SE_TARGET_ACQUIRED,
	SE_BE_THERE,
	SE_HEADING_FOR_HOME,
	SE_MISSION_UNDER_WAY,

	SE_CAP_SPOTTED,
	SE_FRIGATE_SPOTTED,
	SE_ENEMY_BOMBERS,

	SE_MENU_CLICK,
	SE_SMALL_LASER,
	SE_TWIN_LASER,
	SE_LARGE_LASER,
	SE_MISSILE_LAUNCH,
	SE_TORPEDO_EXPLOSION,
	SE_SS_EXPLOSION,
	SE_NEUTRON_BOMB_EXPLOSION,
	SE_DROP_SHIP_LAUNCH,
	SE_MEDIUM_EXPLOSION,
	SE_LARGE_EXPLOSION
};

const int n_sounds = 21;

class Sound {
public:
	Sound(): b_music_on(true), current_song(0), script_sound(0), volume_reset(true) {}

	void init();
	void shutdown();
	void update();

	void load_song(const std::string& filename);
	void start_music();
	void end_music();
	void set_music_volume(int volume);

	void play_sound(SoundEffect which);
	void play_script_sound(const std::wstring& filename);
	void stop_script_sound();
	void pause_sound();
	void resume_sound();
	bool script_sound_playing();
	void set_sound_volume(int volume);
	void end_sound();

private:
	void next_music_track();
	void load_data();
	void load_sound(const std::wstring& filename, SoundEffect which);

	void play_music();

	bool b_music_on;
	int current_song;
	std::vector<Mix_Music*> music_cache;
	Mix_Chunk* sound_cache[n_sounds];
	Mix_Chunk* script_sound;
	bool b_script_sound;
	bool volume_reset;
	int volume_reset_timer;
	SoundEffect alert_sound_one;
	SoundEffect alert_sound_two;

	static const int VOLUME_RESET_TIME = 2000;
};

#endif
