/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_SettingsStruct
#define GUARD_SettingsStruct

#include <string>

class SettingsStruct {
public:
	SettingsStruct() {dont_write_sound = false;}
	void load_settings();
	void save_settings();
	
	bool full_screen;
	int screen_width;
	int screen_height;
	int bpp;
	int texture_size;
	
	int sound_volume;
	int music_volume;
	bool disable_sound;	
	bool dont_write_sound;
	bool old_disable_sound;

	int max_mission;
	bool debug;
	
	//base data path
	std::string bdp;
	std::string rem_dir;

	//not written to file, obviously
	std::string user_home_path;
};

#endif
