/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_SelectMission
#define GUARD_SelectMission

#include "GameState.h"
#include "Menu_Base.h"
#include "DragWindow.h"

namespace SelectMission {

const int briefing_width = 400;
const int briefing_height = 370;

class SelectMission_State: public GameState {
public:
	SelectMission_State();
	~SelectMission_State();
	void main();
	
	void mouse_d(Uint8 button, Uint16 x, Uint16 y);
	void keyboard(SDL_keysym& keysym);

private:
	void draw_world();
};

////

class SelectMissionMenu: public Menu_Base {
public:
	SelectMissionMenu(int ix, int iy, int flags);
	bool mouse_m(Uint8 state, Uint16 x, Uint16 y);

private:
	void switch_on_choice(Uint16 x, Uint16 y);

	int info_win_id;
	int old_hover;
};

} //end namespace

#endif

