/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#include "RTSUnit.h"
#include "RTSUnit_Base.h"
#include "Globals.h"
#include "RTSStructs.h"

#include <string>

using std::wstring;

RTSUnit::RTSUnit(int i_my_side, int i_my_group, const wstring& i_name, bool face_left) {
	h_unit = new BigUnit(i_name, i_my_side, i_my_group, face_left);
}

RTSUnit::RTSUnit(int i_my_side, int i_my_group, const wstring& i_name) {
	h_unit = new SmallShip(i_name, i_my_side, i_my_group);
}


