/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_OptWindow
#define GUARD_OptWindow

#include "DragWindow.h"
#include "Menu_Base.h"

class ChooseResolution: public Menu_Base {
public:
	ChooseResolution();
	bool mouse_d(Uint8 button, Uint16 x, Uint16 y);
	void switch_on_choice(Uint16 x, Uint16 y);
};

class SoundVolume: public SliderWithUnits {
public:
	SoundVolume(int ix, int iy, int flags);

	bool mouse_m(Uint8 state, Uint16 x, Uint16 y);
	void draw_self();
};

class MusicVolume: public SliderWithUnits {
public:
	MusicVolume(int ix, int iy, int flags);

	bool mouse_m(Uint8 state, Uint16 x, Uint16 y);
	void draw_self();
};

#endif


