/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#include "Globals.h"
#include "Group.h"
#include "Font.h"
#include "LoadGameData.h"
#include "OptWindow.h"
#include "SettingsStruct.h"
#include "Side.h"
#include "Sound.h"
#include "Stuff.h"

using std::wstring;

ChooseResolution::ChooseResolution():
Menu_Base(0, 0, window_id_none, 0) {
	add_item(L"Select desired resolution:", WC_NOTHING);

	add_blank_item();

	add_item(L"800*600", OPT_800);
	add_item(L"1024*768", OPT_1024);
	add_item(L"1280*1024", OPT_1280);

	add_blank_item();

	add_item(L"Cancel", WC_QUIT);

	init_rects();
	center_window();
}

bool ChooseResolution::mouse_d(Uint8 button, Uint16 x, Uint16 y) {
	Menu_Base::mouse_d(button, x, y);

	//can't click elsewhere until a choice is made
	return true;
}

void ChooseResolution::switch_on_choice(Uint16 x, Uint16 y) {
	if (current_selection.choice_type == MCT_LEFTCURSOR) {
		switch (current_selection.choice) {
		case OPT_800:
			global_settings.screen_width = 800;
			global_settings.screen_height = 600;
			reset_graphics();
			gs_to = GST_RELOAD;
			closed = true;
			break;

		case OPT_1024:
			global_settings.screen_width = 1024;
			global_settings.screen_height = 768;
			reset_graphics();
			gs_to = GST_RELOAD;
			closed = true;
			break;

		case OPT_1280:
			global_settings.screen_width = 1280;
			global_settings.screen_height = 1024;
			reset_graphics();
			gs_to = GST_RELOAD;
			closed = true;
			break;

		case WC_QUIT:
			closed = true;
		}
	}
}

SoundVolume::SoundVolume(int ix, int iy, int flags):
SliderWithUnits(ix, iy, &global_settings.sound_volume, 0, MIX_MAX_VOLUME, L"Sound Volume", L"/ 128", window_id_none, flags) {
}

bool SoundVolume::mouse_m(Uint8 state, Uint16 x, Uint16 y) {
	bool ret = Slider::mouse_m(state, x, y);

	if (b_slider_drag)
		sound.set_sound_volume(*var_pointer);

	return ret;
}

void SoundVolume::draw_self() {
	if (*var_pointer == 0) {
		Slider::draw_self();
		int x = rect.x + small_border_size;
		int y = rect.y + small_border_size;
		wstring output = var_name + L": " + L"off";
		normal_font.render(x, y, output);
	} else if (*var_pointer == 128) {
		Slider::draw_self();
		int x = rect.x + small_border_size;
		int y = rect.y + small_border_size;
		wchar_t output[48];
		swprintf(output, 48, L"%ls: %d - Default", var_name.c_str(), *var_pointer);
		normal_font.render(x, y, output);
	} else
		SliderWithUnits::draw_self();
}

MusicVolume::MusicVolume(int ix, int iy, int flags):
SliderWithUnits(ix, iy, &global_settings.music_volume, 0, MIX_MAX_VOLUME, L"Music Volume", L"/ 128", window_id_none, flags) {
}

bool MusicVolume::mouse_m(Uint8 state, Uint16 x, Uint16 y) {
	bool ret = Slider::mouse_m(state, x, y);

	if (b_slider_drag) {
		if (gs_current != GST_BATTLE && *var_pointer >= 90)
			sound.set_music_volume(128);
		else
			sound.set_music_volume(*var_pointer);
	}

	return ret;
}

void MusicVolume::draw_self() {
	if (*var_pointer == 0) {
		Slider::draw_self();
		int x = rect.x + small_border_size;
		int y = rect.y + small_border_size;
		wstring output = var_name + L": " + L"Off";
		normal_font.render(x, y, output);
	} else if (*var_pointer == 90) {
		Slider::draw_self();
		int x = rect.x + small_border_size;
		int y = rect.y + small_border_size;
		wchar_t output[48];
		swprintf(output, 48, L"%ls: %d - Default", var_name.c_str(), *var_pointer);
		normal_font.render(x, y, output);
	} else
		SliderWithUnits::draw_self();
}

