/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_Menu
#define GUARD_Menu

#include "GenWindow_Base.h"
#include "GlobalConstants.h"

#include <string>
#include <vector>

class ItemInfo {
public:
	ItemInfo(): flags(0) {}
	virtual ~ItemInfo() {}
	std::wstring desc;
	WindowChoice choice;
	int parem;
	int flags;
};

class MenuItem: public ItemInfo {
public:
	MenuItem();
	SDL_Rect rect;
};

class MenuChoice: public ItemInfo {
public:
	MenuChoiceType choice_type;
};

class Menu_Base: public GenWindow_Base {
public:
	Menu_Base(int ix, int iy, int i_parent_id, int flags);

	virtual bool mouse_d(Uint8 button, Uint16 x, Uint16 y);
	virtual bool mouse_m(Uint8 state, Uint16 x, Uint16 y);
	virtual void draw_self();

protected:
	virtual void init_rects();
	void add_item(const std::wstring& desc, WindowChoice choice, int i_parem = 0, int i_height = 0, int i_flags = 0);
	void add_item(MenuItem& temp_item);
	void add_blank_item();
	void clear_items() {items.clear(); new_item_x = 0; new_item_y = 0;}
	virtual void switch_on_choice(Uint16 x, Uint16 y) = 0;

	std::vector<MenuItem> items;
	MenuChoice current_selection;
	int hover;
	bool b_hover_highlight;
	int new_item_x;
	int new_item_y;	
};

#endif
