/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#include "Display.h"
#include "Font.h"
#include "Globals.h"
#include "Inlines.h"
#include "Menu_Base.h"
#include "SettingsStruct.h"
#include "Side.h"
#include "Sound.h"

MenuItem::MenuItem() {
	rect.x = 0;
	rect.y = 0;
	rect.w = menu_item_width;
	rect.h = normal_font.get_height();
}

Menu_Base::Menu_Base(int ix, int iy, int i_parent_id, int flags):
GenWindow_Base(ix, iy, i_parent_id, flags), new_item_x(0), new_item_y(0), hover(-1), b_hover_highlight(true) {}

bool Menu_Base::mouse_d(Uint8 button, Uint16 x, Uint16 y) {
	bool ret = GenWindow_Base::mouse_d(button, x, y);
	
	if (hover != -1) {
		if (button == SDL_BUTTON_LEFT) {
			current_selection.choice_type = MCT_LEFTCURSOR;
			sound.play_sound(SE_MENU_CLICK);
		}
		else if (button == SDL_BUTTON_RIGHT)
			current_selection.choice_type = MCT_RIGHTCURSOR;		
	}
	
	switch_on_choice(x, y);

	return ret;
}

bool Menu_Base::mouse_m(Uint8 state, Uint16 x, Uint16 y) {
	bool ret = GenWindow_Base::mouse_m(state, x, y);
	current_selection.choice_type = MCT_NONE;
	hover = -1;

	//cursor inside window?
	if (ret) {
		for (int i = 0; i != items.size(); ++i) {
			if (point_in_rect(x - rect.x, y - rect.y, items[i].rect)) {
				//return true even if nothing in particular is highlighted
				ret = true;
				if (items[i].choice != WC_NOTHING) {
					hover = i;

					current_selection.desc = items[i].desc;
					current_selection.choice = items[i].choice;
					current_selection.parem = items[i].parem;
					
					current_selection.choice_type = MCT_HIGHLIGHT;
					return true;
				}
			}
		}
	}

	return ret;
}

void Menu_Base::draw_self() {
	GenWindow_Base::draw_self();

	if (hover != -1 && b_hover_highlight) {
		SDL_Rect temp_rect;
		temp_rect.x = items[hover].rect.x + rect.x;
		temp_rect.y = items[hover].rect.y + rect.y;
		temp_rect.w = items[hover].rect.w;
		temp_rect.h = items[hover].rect.h;

		display.blt_fill(temp_rect, standard_colors.light_blue);
	}

	for (int i = 0; i != items.size(); ++i) {
		int x = items[i].rect.x + rect.x + small_border_size;
		int y = items[i].rect.y + rect.y + small_border_size;

		if (items[i].flags & MFLAG_HIGHLIGHT) {
			SDL_Rect temp_rect;
			temp_rect.x = items[i].rect.x + rect.x;
			temp_rect.y = items[i].rect.y + rect.y;
			temp_rect.w = items[i].rect.w;
			temp_rect.h = items[i].rect.h;

			display.blt_fill(temp_rect, standard_colors.dark_blue);
		}

		if (items[i].flags & MFLAG_BOLD)
			bold_font.render(x, y, items[i].desc);
		else if (items[i].flags & MFLAG_FADED)
			normal_font.render(x, y, items[i].desc, standard_colors.grey_text);
		else
			normal_font.render(x, y, items[i].desc);
	}
}

void Menu_Base::init_rects() {
	//width
	int longest_index = 0;
	int longest = 0;
	rect.h = 0;

	for (int i = 0; i != items.size(); ++i) {

		int first_index = 0;
		int last_index = 0;

		for (; last_index != items[i].desc.size(); ++last_index) {
			if (items[i].desc[last_index] == '\n') {
				int current_length = normal_font.get_width(items[i].desc.substr(first_index, last_index - first_index));
				if (current_length > longest) {
					longest_index = i;
					longest = current_length;
				}

				first_index = last_index + 1;
			}
		}

		int current_length = normal_font.get_width(items[i].desc.substr(first_index, last_index - first_index));
		if (current_length > longest) {
			longest_index = i;
			longest = current_length;
		}

		rect.h += items[i].rect.h;
	}

	int menuWidth = 0;
	if (items.size() && items[longest_index].flags & MFLAG_BOLD)
		menuWidth = bold_font.get_width(items[longest_index].desc + L" ");
	else
		menuWidth = normal_font.get_width(items[longest_index].desc + L" ");

	for (int i = 0; i != items.size(); ++i)
		items[i].rect.w = menuWidth;

	//overall dimensions
	rect.w = menuWidth;

	init_border();
}

void Menu_Base::add_item(const std::wstring& desc, WindowChoice choice, int i_parem, int i_line_gap, int i_flags) {
	//FIXME maybe there should be a permanent newItem as part of Menu_Base for greater effeciency?
	MenuItem temp_item;
	temp_item.desc = desc;
	temp_item.choice = choice;
	if (i_line_gap == 0)
		i_line_gap = normal_font.get_height();
	temp_item.rect.h = i_line_gap;
	temp_item.parem = i_parem;
	temp_item.flags = i_flags;
	add_item(temp_item);
}

void Menu_Base::add_item(MenuItem& temp_item) {
	temp_item.rect.x = new_item_x;
	temp_item.rect.y = new_item_y;
	items.push_back(temp_item);

	new_item_y += temp_item.rect.h;
}

void Menu_Base::add_blank_item() {
	MenuItem temp_item;
	temp_item.choice = WC_NOTHING;
	add_item(temp_item);
}


