/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_MainMenu
#define GUARD_MainMenu

#include "GameState.h"
#include "Menu_Base.h"

namespace MainMenu {

class MainMenu_State: public GameState {
public:
	MainMenu_State();
	~MainMenu_State();
	void main();
};

////

class MainSM: public Menu_Base {
public:
	MainSM();

	void create_help_window();
	void switch_on_choice(Uint16 x, Uint16 y);

	bool keyboard(SDL_keysym& keysym);
};

class Options: public Menu_Base {
public:
	Options();
	void switch_on_choice(Uint16 x, Uint16 y);
	bool keyboard(SDL_keysym& keysym);

private:
	void refresh();

	static const int num_texture_size_levels = 3;
};

} //end namespace

#endif

