/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#include "Inlines.h"
#include "Logging.h"
#include "Globals.h"
#include "SettingsStruct.h"

#include <fstream>
#include <iostream>
#include <ctime>

using std::ofstream;
using std::wcout;
using std::endl;
using std::ctime;
using std::string;
using std::wstring;

void write_log(const std::wstring& log_msg) {
	#ifndef WIN32
		wcout << log_msg << endl;
	#endif
	string concat_string = "rrgbis-log.txt";
	ofstream output(concat_string.c_str(), std::ios::app | std::ios::out);

	time_t theTime = time(0);
	output << ctime(&theTime) << wstring_to_string(log_msg) << endl << endl;
}

void write_text(const std::wstring& log_msg, bool to_file) {
	#ifndef WIN32
		wcout << log_msg << endl;
	#endif
	if (to_file) {
		wstring concat_string = L"rrgbis-log.txt";
		ofstream output(wstring_to_string(concat_string).c_str(), std::ios::app | std::ios::out);	
		output << wstring_to_string(log_msg) << endl;
	}
}

