/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#include "Group.h"
#include "Enums.h"

#include <string>

using std::wstring;

Group::Group(int i_my_side, int i_my_squad, int i_my_group, const wstring& i_name, CoordsInt i_starting_coords, bool face_left) {
	h_group = new BigUnitGroup(i_my_side, i_my_squad, i_my_group, i_name, i_starting_coords, face_left);
}

Group::Group(int i_my_side, int i_my_squad, int i_my_group, const wstring& i_name, int i_parent_cap, CoordsInt i_starting_coords) {
	h_group = new SmallShipGroup(i_my_side, i_my_squad, i_my_group, i_name, i_parent_cap, i_starting_coords);
}
