/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_GenWindow_Base
#define GUARD_GenWindow_Base

#include "GLSDL.h"

#include "Enums.h"

class GenWindow_Base {
public:
	GenWindow_Base(int ix, int iy, int i_parent_id, int flags);
	//tell everyone we're closing
	virtual ~GenWindow_Base();

	virtual void update() {}

	virtual bool mouse_d(Uint8 button, Uint16 x, Uint16 y);
	virtual bool mouse_m(Uint8 state, Uint16 x, Uint16 y);
	virtual bool keyboard(SDL_keysym& keysym) {return false;}
	virtual bool key_u(SDL_keysym& keysym) {return false;}

	virtual void draw_self() = 0;

	virtual void win_message(WindowChoice the_msg, int parem_one, int parem_two, int target_id, int source_id);

	//for dragwindows you must centre before initing rects, for menus it is the other way round. 
	//This is seriously error prone, I should FIXME it. Logically you may need to init before centering, but 
	//needing to center before init is silly
	//--this may be fixed now--
	void center_window();

	SDL_Rect rect;
	SDL_Rect border_rect;

	int my_id;
	//set to none in constructor, derived classes
	//can set it to a proper value if they have a parent
	int parentID;
	bool activate;
	//you can send messages to windows to tell them to close
	bool closed;

	bool visible;

protected:
	void init_border();
	void tile();

	virtual void move(int distx, int disty);

	OpenGLColor border_color;
	bool b_static;
	bool cant_close;
	bool transparent;
};

#endif


