/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.

   See the COPYING file for more details.
*/

#ifndef GUARD_Font
#define GUARD_Font

#include <FTGL/ftgl.h>
#include "GLSDL.h"

#include <string>

class Font {
public:
	Font() {}

	void init(const std::string& filename, int i_size);
	void render(int x, int y, const std::wstring& output, const OpenGLColor& color = my_white);
	int get_width(const std::wstring& str);
	int get_height() {return my_line_height;}
	void shutdown();

private:
	FTGLTextureFont* font;
	static OpenGLColor my_white;
	int my_size;
	int my_line_height;
};

#endif
