/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.

   See the COPYING file for more details.
*/

#ifndef GUARD_FileUtils
#define GUARD_FileUtils

#include <sstream>
#include <iterator>
#include <string>

class FileReader {
public:
	FileReader() {}
	FileReader(const std::string& filename);

	void load(const std::string& filename);
	bool at_end();

	const std::string get_string_after_colon();
	int get_int_after_colon();
	void skip_colon();

	void go_in_brackets();
	bool on_close_bracket();
	const std::string get_string();
	int get_int();

private:
	std::string the_string;
	std::istringstream input;
	std::istream_iterator<char> iter;
	std::istream_iterator<char> file_end;
};

class OptionSkipIter: public std::istreambuf_iterator<char> {
public:
	OptionSkipIter(): std::istreambuf_iterator<char>() {}
	OptionSkipIter(std::istringstream& is): std::istreambuf_iterator<char>(is) {}
	
	void plus_plus_ss() {++(*this); skip_space();}
	void equals_ss(std::istringstream& is) {*this = OptionSkipIter(is); skip_space();}

private:
	void skip_space() {while ((*this) != OptionSkipIter() && isspace(*(*this))) ++(*this);}
};

bool does_file_exist(const std::string& filename);
void file_to_string(const std::string& fileName, std::string& the_string);
void newline_convert(std::string& the_string);
void skip_to_next_section(std::istringstream& input, OptionSkipIter& iter, const OptionSkipIter& file_end);

#endif
