/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.

   See the COPYING file for more details.
*/

#include "FileUtils.h"
#include "Inlines.h"

#include <fstream>
#include <stdexcept>

using std::fstream;
using std::stringstream;
using std::getline;
using std::ifstream;
using std::string;
using std::wstring;
using std::runtime_error;
using std::istringstream;

FileReader::FileReader(const string& filename) {
	load(filename);
}

void FileReader::load(const string& filename) {
	file_to_string(filename, the_string);
	input.str(the_string);
	iter = input;
}

bool FileReader::at_end() {
	if (iter == file_end)
		return true;
	else
		return false;
}

const string FileReader::get_string_after_colon() {
	iter = find(iter, file_end, ':');
	input.ignore();

	return get_string();
}

int FileReader::get_int_after_colon() {
	iter = find(iter, file_end, ':');
	++iter;

	return get_int();
}

void FileReader::skip_colon() {
	iter = find(iter, file_end, ':');
	++iter;
}

void FileReader::go_in_brackets() {
	iter = find(iter, file_end, ':');
	++iter;
	++iter;
}

bool FileReader::on_close_bracket() {
	if (*iter == '}')
		return true;
	else
		return false;
}

const string FileReader::get_string() {
	string tmp_str;

	//stupid
	if (isalpha(*iter))
		input.unget();

	getline(input, tmp_str);

	//convert /ns in string to actual newlines
	for (string::iterator s_iter = tmp_str.begin(); s_iter != tmp_str.end();) {
		if (s_iter + 1 != tmp_str.end() && *s_iter == '\\' && *(s_iter + 1) == 'n') {
			*s_iter = '\n';
			s_iter = tmp_str.erase(s_iter + 1);
		} else
			++s_iter;
	}

	iter = input;
	return tmp_str;
}

int FileReader::get_int() {
	int ret = iter_to_int(iter, file_end);
	if (iter != file_end)
		++iter;
	return ret;
}

void skip_to_next_section(istringstream& input, OptionSkipIter& iter, const OptionSkipIter& file_end) {
	while (!find_not_comment(iter, file_end)) {
		iter = find(iter, file_end, '\n');

		if (iter == file_end)
			throw runtime_error("skip_to_next_section hit end of file");
		else
			++iter;
	}
}

bool does_file_exist(const string& filename) {
	ifstream test(filename.c_str(), ifstream::in);
	test.close();

	if(test.fail())
		return false;
	else
		return true;
}

void file_to_string(const string& filename, string& the_string) {
	ifstream f_stream(filename.c_str());

	if (!f_stream.is_open()) {
		string error = "Error opening file ";
		error += filename;
		throw runtime_error(error.c_str());
	}

	string temp_str;
	while (getline(f_stream, temp_str))
		the_string += temp_str + '\n';

	newline_convert(the_string);
}

//game always uses Linux newlines, whatever system it is running on
void newline_convert(string& the_string) {
	char c, prevCh;
	string newStr;

	prevCh = EOF;

	for (int i = 0; i != the_string.size(); ++i) {
		c = the_string[i];

		/* basically we withhold emitting any '\r' until we */
		/* are sure that the next character is not a '\n'. */
		/* If it is not, we emit the '\r', if it is, we */
		/* only emit the '\n'. */

		if (prevCh == '\r') {
			/* '\r' is a special case because we don't */
			/* emit a '\r' until the next character */
			/* has been read */
			if (c == '\n') {
				/* a "\r\n" pair */
				/* discard previous '\r' and */
				/* just put the '\n' */
				newStr += c;
			} else {	/* prevch was a standalone '\r' */
				/* emit the standalone '\r' */
				newStr += '\r';
				/* emit the current character if it is not a '\r' */

				if (c != '\r')
					newStr += c;
			}
		} else { /* prevch was not '\r' */
			/* emit current character if it is not */
			/* a '\r' */
			if (c != '\r')
				newStr += c;
		}

		prevCh = c;
	}

	the_string = newStr;
}

