/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_Display
#define GUARD_Display

#include "GLSDL.h"

#include <string>
#include <fstream>

class Display {
public:
	Display(): screen(0) {}

	void init();
	void reset_video();
	void shutdown();

	void surface_color_convert(SDL_Surface* surface, const OpenGLColor& new_color);

	SDL_Surface* file_to_surface(const std::string& filename, const OpenGLColor& transparency = OpenGLColor());
	//automatically frees src before returning
	SDL_Surface* reduce_image_resolution(SDL_Surface* src, bool main_background);

	void take_screenshot();

	//not references because SDL_FillRect clips the actual dest_rect you send it
	void blt_fill(SDL_Rect dest_rect, const OpenGLColor& color, float alpha = -1);
	void blt(SDL_Surface* src, SDL_Rect dest_rect, int gl_effect = 0);
	void blt_part(SDL_Surface* src, SDL_Rect& src_rect, SDL_Rect dest_rect, int gl_effect = 0);

	void draw_line(float x1, float y1, float x2, float y2, float width, const OpenGLColor& color);
	void draw_circle(Sint16 x, Sint16 y, Sint16 radius, const OpenGLColor& color);

	void flip();

	OpenGLColor map_rgb(Uint32 r, Uint32 g, Uint32 b);

	Uint8* keyboard;

private:
	bool pixel_color_matches(Uint8* src, Uint32 color, int bytes_per_pixel);
	void pixel_color(Uint8* dst, Uint32 color, int bytes_per_pixel);

	bool clip_line(SDL_Surface* dst, float* x1, float* y1, float* x2, float* y2);
	int clip_encode(float x, float y, float left, float top, float right, float bottom);

	SDL_Surface* screen;
};

#endif

