/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_Credits
#define GUARD_Credits

#include "DragWindow.h"
#include "GameState.h"
#include "Menu_Base.h"

namespace Credits {

class Credits_State: public GameState {
public:
	Credits_State();
	~Credits_State();
	void main();
	
	void keyboard(SDL_keysym& keysym);
};

class CreditsText: public WrappedString {
public:
	CreditsText(int ix, int iy, int iw, int ih, const std::wstring& the_string, bool bold_title, int flags);

	void update();

private:
	int last_scroll;
	static const int scroll_interval = 50;
};

} //end namespace

#endif
