/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#include "Credits.h"
#include "Display.h"
#include "Font.h"
#include "GenWindow.h"
#include "Globals.h"
#include "Intro.h"
#include "LoadGameData.h"
#include "SettingsStruct.h"
#include "Sound.h"

using std::wstring;

namespace Credits {

Credits_State::Credits_State() {
	free_title_images();
	sound.end_music();
	sound.load_song("dimo_-_velocity.ogg");
	if (global_settings.music_volume >= 90)
		sound.set_music_volume(128);
	sound.start_music();

	wstring tmp_str =
L"=============\n\n"
L"Really Rather Good Battles In Space:\n\n"
L"Galactic Conflict 4320 - 4359 AD\n\n"
L"=============\n\n"
L"Credits:\n\n"
L"=============\n\n"
L"Code:\n\n"
L"James Gregory\n\n"
L"Squirrel scripting language by Alberto Demichelis\n\n"
L"Using the SDL, SDL_Image, SDL_Mixer, OpenGL, FTGL, and Freetype libraries\n\n"
L"OpenGL blitting code based on glSDL by David Olofson\n\n"
L"Image scaling code based on SDL_gfx by Andreas Schiffler\n\n"
L"=============\n\n"

L"Unit artwork:\n\n"
L"=============\n\n"
L"Kasper Hviid\n\n"
L"Katarzyna Matylla\n\n"
L"notalent\n\n"
L"James Gregory\n\n"
L"=============\n\n"

L"Space and planet artwork:\n\n"
L"=============\n\n"
L"Andr-Sar\n\n"
L"hameed\n\n"
L"Mr-Frenzy\n\n"
L"NASA\n\n"
L"=============\n\n"

L"Character portraits:\n\n"
L"=============\n\n"
L"emperial\n\n"
L"Ingo Ruhnke\n\n"
L"ranin\n\n"
L"melora\n\n"
L"suprhppymgcprincesss\n\n"
L"Maddjuju\n\n"
L"NZrommel\n\n"
L"TheQuezot\n\n"
L"=============\n\n"

L"UI artwork:\n\n"
L"=============\n\n"
L"The Tango Desktop Project\n\n"
L"James Gregory\n\n"
L"=============\n\n"

L"Voice:\n\n"
L"=============\n\n"
L"James Gregory\n\n"
L"Simon Ko\n\n"
L"Eleanor Jones\n\n"
L"James Marchant\n\n"
L"Paulo Morfeo\n\n"
L"Laurence Abbott\n\n"
L"=============\n\n"

L"Music:\n\n"
L"=============\n\n"
L"\"one moment\" by cdk\n\n"
L"\"state of every day madness\" by Ghost_k\n\n"
L"\"43\" by hepepe\n\n"
L"\"Crazy Breaks\" by cdk\n\n"
L"\"Disrupted Melody\" by cdk\n\n"
L"\"The Pudding\" by cdk\n\n"
L"\"sevenhundredbeats\" by duncan_beattie\n\n"
L"\"velocity\" by dimo\n\n"
L"=============\n\n"

L"Sound effects:\n\n"
L"=============\n\n"
L"inferno\n\n"
L"Jace\n\n"
L"user 56891b\n\n"
L"Heigh_hoo\n\n"
L"James Gregory\n\n"
L"=============\n\n"

L"Website:\n\n"
L"=============\n\n"
L"James Gregory\n\n"
L"=============\n\n";

	my_windows.push_back(GenWindow(0, 0, CREDITS_CREDITS_TEXT, 400, -1, tmp_str, false, WFLAG_CENTER | WFLAG_TRANSPARENT | WFLAG_CANTCLOSE | WFLAG_STATIC));
}

Credits_State::~Credits_State() {
	sound.end_music();
	kill_all_windows();
	current_cursor_type = GENPIC_CURSOR;

	load_title_images();
	load_title_music();
	sound.start_music();
}

void Credits_State::main() {
	current_cursor_type = GENPIC_CLOSEBOX;
	display.blt_fill(viewable_screen_rect, standard_colors.black);
	draw_all_windows();
}

void Credits_State::keyboard(SDL_keysym& keysym) {
	if (keysym.sym == SDLK_ESCAPE || keysym.sym == SDLK_RETURN)
		gs_to = GST_MAIN_MENU;
}

CreditsText::CreditsText(int ix, int iy, int iw, int ih, const std::wstring& the_string, bool bold_title, int flags):
WrappedString(ix, iy, iw, ih, the_string, bold_title, flags), last_scroll(now) {
	rect.y = 200;
}

void CreditsText::update() {
	if (rect.y + rect.h < 0) {
		gs_to = GST_MAIN_MENU;
	} else if (now - last_scroll > scroll_interval) {
		move(0, -1);
		last_scroll = now;
	}
}

}

