/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_AIInterpreter
#define GUARD_AIInterpreter

#include "GlobalConstants.h"
#include "RTSStructs.h"

#include <vector>
#include <string>

class Group_Base;

class AIInterpreter {
public:
	void init(Group_Base* i_this_group, AICommands* i_the_commands);
	void get_commands();

	//don't want people decrementing them to negative values
	unsigned int script_vars[n_ai_vars];
	CoordsInt save_groups[n_ai_vars];
	unsigned int script_timers[n_ai_vars];

private:
	void call_function();

	void skip_block(int tab_level);

	bool interpret_if();
	bool interpret_if_part_two();
	bool true_or_false();

	bool compare_values(int first_value, const unsigned char operator_type, int second_value);
	
	void interpret_set_var();
	void interpret_set_save_group();
	void interpret_start_timer();

	void interpret_move();
	void interpret_fire();
	void interpret_patrol();
	void interpret_dock();

	//overloaded...
	int token_to_int();
	int token_to_int(int& give_side, int& give_group);
	int stat_to_int(const unsigned char the_token, int n_side, int n_group);

	void get_group_indices(int& side, int& group, bool ignore_invalid_save_groups = false);
	bool are_groups_the_same();

	void find_nearest_with(CoordsInt& give_indices, int& give_dist);
	void find_nearest_with_part_two(CoordsInt& give_indices, std::vector<bool>& possible_sides, int& give_dist);
	void search_through_groups(std::vector<bool>& possible_sides, std::vector<std::vector <bool> >& possible_groups);

	bool do_any_have();
	int how_many_have();
	void which_sides_valid(std::vector<bool>& possible_sides);
	bool is_nearest_like_this();
	bool is_group_like_this(int n_side, int n_group, bool discount_dead, bool discount_our);
	bool is_edge_like_this(int n_side, int n_group);
	
	void NearestEnemy(int& give_side, int& give_group);
	void NearestFriend(int& give_group);
	void NearestAlly(int& give_side, int& give_group);
	void which_saved_group(int& give_side, int& give_group, bool ignore_invalid_save_groups = false);
	
	void short_circuit_skip();

	CompassDirection TokenToEdge(int& give_dist);
	CompassDirection NearestEdge(int& distance);
	int DistToXEdge(CompassDirection which);
	int DistToLeftEdge() const;
	int DistToRightEdge() const;
	int DistToTopEdge() const;
	int DistToBottomEdge() const;
	int count_waypoints() const;

	Group_Base* this_group;
	const std::vector<ustring>* the_text;
	AICommands* the_commands;
	int my_side;
	int my_group;

	int current_line;
	int ins_counter;
	ustring::const_iterator l_iter;
	ustring::const_iterator l_end;
};

#endif
