#
# Include generated dependency files.
#
XAR_SRCS := xar.c
XAR_SRCS := $(patsubst %, src/%, $(XAR_SRCS))
-include $(XAR_SRCS:%.c=%.d)

src_all : src/xar src/ixar

src_install : src/ixar
	/usr/bin/install -c -d $(DESTDIR)$(BINDIR)
	/usr/bin/install -c -m 0755 $< $(DESTDIR)$(BINDIR)/xar
	/usr/bin/install -c -d $(DESTDIR)$(MANDIR)/man1
	/usr/bin/install -c -m 0644 src/xar.1 $(DESTDIR)$(MANDIR)/man1

src_uninstall :
	rm -f $(DESTDIR)/$(BINDIR)/xar
	rm -f $(DESTDIR)/$(MANDIR)/man1/xar.1

src_clean :
	rm -f src/xar
	rm -f src/ixar
	rm -f $(XAR_SRCS:%.c=%.o)
	rm -f $(XAR_SRCS:%.c=%.d)

src_distclean :


ifeq (yes, @shared@)
LIBRXAR := $(LIBRXAR_S)
endif
ifeq (yes, @static@)
LIBRXAR := $(LIBXAR_A)
endif

# xar links against librxar, so that it can be run without first installing
# libxar.
src/% : src/%.o $(LIBRXAR)
	@mkdir -p $(@D)
ifneq ($(words "" ), 1)
	$(CC) $(CFLAGS) -o $@ $< /X/src/wdj52/xar/lib $(LDFLAGS) $(LIBRXAR) -lbz2 -lz -lcrypto -lacl  -lxml2 -lz -lm
else
	$(CC) $(CFLAGS) -o $@ $< $(LDFLAGS) $(LIBRXAR) -lbz2 -lz -lcrypto -lacl  -lxml2 -lz -lm
endif

ifeq (yes, @static@)
LIBXAR := $(LIBXAR_A)
endif
ifeq (yes, @shared@)
LIBXAR := $(LIBXAR_S)
endif

# ixar is the version of the xar binary that gets installed.
src/i% : src/%.o $(LIBXAR)
	@mkdir -p $(@D)
ifneq ($(words "" ), 1)
	$(CC) $(CFLAGS) -o $@ $< $(LIBDIR) $(LDFLAGS) $(LIBXAR) -lbz2 -lz -lcrypto -lacl  -lxml2 -lz -lm
else
	$(CC) $(CFLAGS) -o $@ $< $(LDFLAGS) $(LIBXAR) -lbz2 -lz -lcrypto -lacl  -lxml2 -lz -lm
endif

src/%.o : src/%.c
	@mkdir -p $(@D)
	$(CC) $(CFLAGS) $(CPPFLAGS) -c $< -o $@
	@$(SHELL) -ec "$(CC) -MM $(CPPFLAGS) $< | sed \"s/\($(subst /,\/,$(notdir $(basename $@)))\)\.o\([ :]*\)/$(subst /,\/,$(strip $(dir $@)))\1.o \2/g\" > $(@:%.o=%.d)"
