/// Generates the root file output of the macro MacroName

void MakeTCanvasJS(const char *MacroName, const char *IN, const char *OutDir, bool cp, bool py)
{

   // Execute the macro as a C++ one or a Python one.
   if (!py) gROOT->ProcessLine(Form(".x %s",MacroName));
   else     gROOT->ProcessLine(Form("TPython::ExecScript(\"%s\");",MacroName));

   // If needed, copy the macro in the documentation directory.
   if (cp) {
      TString MN = MacroName;
      Int_t i = MN.Index("(");
      Int_t l = MN.Length();
      if (i>0) MN.Remove(i, l);
      gSystem->Exec(TString::Format("cp %s %s/macros", MN.Data(), OutDir));
   }

   // Build the html file inlining the JS pictures

   TIter next(gROOT->GetListOfCanvases());
   std::vector<TString> json_codes;
   TCanvas* canvas = nullptr;
   int ImageNum = 0;

   // Iterate over all the pads generated by the macro and produce the corresponding pictures.

   FILE *fh = fopen(TString::Format("%s/macros/%s.html",OutDir,IN), "w");
   fprintf(fh,"<center>\n");
   while ((canvas = (TCanvas*) next()) != nullptr) {
      ImageNum++;
      json_codes.push_back(TBufferJSON::ToJSON(canvas, TBufferJSON::kNoSpaces + TBufferJSON::kSameSuppression));
      fprintf(fh,"   <div id=\"draw_pict%d_%s\" style=\"width:%dpx; height:%dpx\"></div>\n",
                  ImageNum,IN,canvas->GetWindowWidth(),canvas->GetWindowHeight());
   }
   fprintf(fh,"</center>\n");

   fprintf(fh,"<script type=\"text/javascript\">\n");
   fprintf(fh,"   function load_jsroot_%s() {\n", IN);
   fprintf(fh,"      return new Promise(resolveFunc => {\n");
   fprintf(fh,"         if (typeof JSROOT != 'undefined') return resolveFunc(true);\n");
   fprintf(fh,"         let script = document.createElement('script');\n");
   fprintf(fh,"         script.src = './js/scripts/JSRoot.core.js';\n");
   fprintf(fh,"         script.onload = resolveFunc;\n");
   fprintf(fh,"         document.head.appendChild(script);\n");
   fprintf(fh,"      });\n");
   fprintf(fh,"   }\n");
   fprintf(fh,"   load_jsroot_%s().then(() => {\n", IN);
   fprintf(fh,"      JSROOT.settings.HandleKeys = false;\n");
   for (int i=1; i<=ImageNum; i++) {
      fprintf(fh,"      let obj%d = JSROOT.parse(%s);\n", i, json_codes[i-1].Data());
      fprintf(fh,"      JSROOT.draw(\"draw_pict%d_%s\", obj%d, \"\");\n", i,IN,i);
   }
   fprintf(fh,"   });\n");
   fprintf(fh,"</script>\n");

   fclose(fh);
}
