/*
 * ! OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/m/ColumnHeader',['sap/ui/core/Control','sap/ui/core/Icon','./ColumnHeaderRenderer'],function(C,I,a){"use strict";
var b=C.extend("sap.m.ColumnHeader",{
library:"sap.m",
metadata:{properties:{text:{type:"string",defaultValue:null},sorted:{type:"boolean",defaultValue:false},sortOrder:{type:"string",defaultValue:null},filtered:{type:"boolean",defaultValue:false}},defaultAggregations:"viewSettingsPopover",aggregations:{viewSettingsPopover:{type:"sap.m.ViewSettingsPopover",multiple:false},_sortIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_filterIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}}}
});
b.prototype.setViewSettingsPopover=function(v){this.setAggregation("viewSettingsPopover",v,true);this._attachViewSettingsPopoverEvents();return this;};
b.prototype.setSortOrder=function(s){this.setProperty("sortOrder",s);var i=s==="Ascending"?"sap-icon://sort-ascending":"sap-icon://sort-descending";var S=this.getAggregation("_sortIcon");if(!S){this.setAggregation("_sortIcon",new I({src:i,visible:this.getSorted()}));}else{S.setSrc(i);}return this;};
b.prototype.setSorted=function(s){this.setProperty("sorted",s);var S=this.getAggregation("_sortIcon");if(!s&&!S){return this;}if(s){if(!S){this.setAggregation("_sortIcon",new I({src:this.getSortOrder()==="Ascending"?"sap-icon://sort-ascending":"sap-icon://sort-descending"}));}else{S.setVisible(true);}}else{S.setVisible(false);}return this;};
b.prototype.setFiltered=function(f){this.setProperty("filtered",f);var F=this.getAggregation("_filterIcon");if(!f&&!F){return this;}if(f){if(!F){this.setAggregation("_filterIcon",new I({src:"sap-icon://filter"}));}else{F.setVisible(true);}}else{F.setVisible(false);}return this;};
b.prototype.setTableAdapter=function(A){this._oAdapter=A;};
b.prototype.getTableAdapter=function(){return this._oAdapter||{interactive:true,rowAggregation:"items"};};
b.prototype.onclick=function(e){if(this._isInteractive()){this._openColumnActions();}};
b.prototype.onsapselect=b.prototype.onclick;
b.prototype._openColumnActions=function(){var v=this.getViewSettingsPopover();if(v!=null){var $=this.$();v.openBy(this);v._getPopover(this).setOffsetY(-$.outerHeight());}};
b.prototype._attachViewSettingsPopoverEvents=function(){var v=this.getViewSettingsPopover();if(v){this._detachViewSettingsPopoverEvents(v);v.attachSortSelected(this.onSortSelected,this);v.attachFilterSelected(this.onFilterSelected,this);}};
b.prototype._detachViewSettingsPopoverEvents=function(v){v.detachSortSelected(this.onSortSelected,this);v.detachFilterSelected(this.onFilterSelected,this);};
b.prototype.onSortSelected=function(){if(!this.getSorted()){this.setSorted(true);}if(this.getSortOrder()===""||this.getSortOrder()==="Descending"){this.setSortOrder("Ascending");}else{this.setSortOrder("Descending");}};
b.prototype.onFilterSelected=function(){this.setFiltered(true);};
b.prototype.getAccessibilityInfo=function(){var B=sap.ui.getCore().getLibraryResourceBundle("sap.m"),A=this.getText()+" ";if(this._isInteractive()){if(this.getSortOrder()){A+=B.getText("COLUMNHEADER_SORTED")+" ";A+=(this.getSortOrder()==="Ascending"?B.getText("COLUMNHEADER_SORTED_ASCENDING"):B.getText("COLUMNHEADER_SORTED_DESCENDING"))+" ";}if(this.getFiltered()){A+=B.getText("COLUMNHEADER_FILTERED")+" ";}A+=B.getText("COLUMNHEADER_ACCESS_COLUMN_ACTIONS");return{role:"button",focusable:true,description:A};}return{focusable:false,description:A};};
b.prototype._isInteractive=function(){return this.getTableAdapter().interactive&&!!this.getViewSettingsPopover();};
b.prototype.exit=function(){this._oAdapter=null;};
return b;});
sap.ui.predefine('sap/m/ColumnHeaderPopover',['sap/ui/core/Control','sap/ui/model/base/ManagedObjectModel','sap/m/OverflowToolbar','sap/m/ResponsivePopover','sap/m/OverflowToolbarButton','sap/m/OverflowToolbarToggleButton','sap/m/ToolbarSpacer','sap/ui/model/Filter','sap/ui/model/FilterOperator'],function(C,M,O,R,a,b,T,F,c){"use strict";
var d=C.extend("sap.m.ColumnHeaderPopover",{
library:"sap.m",
metadata:{properties:{},aggregations:{items:{type:"sap.m.ColumnPopoverItem",multiple:true,singularName:"item",bindable:true},_popover:{type:"sap.m.ResponsivePopover",multiple:false,visibility:"hidden"}}}
});
d.prototype.init=function(){var m=new M(this);var t=this;this._oShownCustomContent=null;var p=new R({showArrow:false,showHeader:false,placement:"Bottom",verticalScrolling:true,horizontalScrolling:false});this.setAggregation("_popover",p);var f=new F({path:"visible",operator:c.EQ,value1:true});var e=function(i,g){var I=g.getObject();if(I.isA("sap.m.ColumnPopoverActionItem")){return t._createActionItem(i,I);}else if(I.isA("sap.m.ColumnPopoverCustomItem")){return t._createCustomItem(i,I);}};var o=new O({content:{path:'/items',filters:[f],length:5,factory:e}});o.updateAggregation=function(){if(this._oShownCustomContent){this._oShownCustomContent=null;}O.prototype.updateAggregation.apply(this,arguments);o.addContent(new T());o.addContent(new a({type:"Transparent",icon:"sap-icon://decline",tooltip:"Close",press:[p.close,p]}));};p.addContent(o);p.setModel(m);};
d.prototype._createActionItem=function(i,I){var t=this;var p=this.getAggregation("_popover");return new a(i,{icon:"{icon}",tooltip:"{text}",type:"Transparent",press:function(){if(t._oShownCustomContent){t._oShownCustomContent.setVisible(false);t._oShownCustomContent=null;t._cleanSelection(p);}I.firePress();}});};
d.prototype._createCustomItem=function(i,I){var t=this;var p=this.getAggregation("_popover");var o=I.getContent();if(o){o.setVisible(false);}p.addContent(o);return new b(i,{icon:"{icon}",type:"Transparent",tooltip:"{text}",press:function(){if(t._oShownCustomContent){t._oShownCustomContent.setVisible(false);}if(this.getPressed()){t._cleanSelection(p);I.fireBeforeShowContent();o.setVisible(true);t._oShownCustomContent=o;I._sRelatedId=o.sId;}else{o.setVisible(false);t._oShownCustomContent=null;}}});};
d.prototype._cleanSelection=function(p){var o=p.getContent()[0],B;if(o&&o.isA("sap.m.OverflowToolbar")&&o.getContent()){B=o.getContent();}if(B){for(var i=0;i<B.length;i++){if(B[i]!==this&&B[i].getPressed&&B[i].getPressed()){B[i].setPressed(false);}}}};
d.prototype.updateAggregation=function(){var p=this.getAggregation("_popover"),e;if(p){e=p.getAggregation("content");}if(e){for(var i=0;i<e.length;i++){if(!e[i].isA("sap.m.OverflowToolbar")){p.removeAggregation("content",e[i]);}}}C.prototype.updateAggregation.apply(this,arguments);};
d.prototype.openBy=function(o){var p=this.getAggregation("_popover");if(!this._bAppendedToUIArea&&!this.getParent()){var s=sap.ui.getCore().getStaticAreaRef();s=sap.ui.getCore().getUIArea(s);s.addContent(this,true);this._bAppendedToUIArea=true;}var e=o.getFocusDomRef();if(e){p.setOffsetY(-e.clientHeight);}p.openBy(o);};
d.prototype.exit=function(){this._oShownCustomContent=null;var p=this.getAggregation("_popover");if(p.getContent()){p.destroyContent();}};
return d;});
sap.ui.predefine('sap/m/ColumnPopoverActionItem',['./ColumnPopoverItem'],function(C){"use strict";
var a=C.extend("sap.m.ColumnPopoverActionItem",{
library:"sap.m",
metadata:{properties:{icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null}},events:{press:{}}}
});
return a;});
sap.ui.predefine('sap/m/ColumnPopoverCustomItem',['./ColumnPopoverItem'],function(C){"use strict";
var a=C.extend("sap.m.ColumnPopoverCustomItem",{
library:"sap.m",
metadata:{properties:{icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:false,singularName:"content"}},events:{beforeShowContent:{}}}
});
return a;});
sap.ui.predefine('sap/m/ColumnPopoverItem',['sap/ui/core/Element'],function(E){"use strict";
var C=E.extend("sap.m.ColumnPopoverItem",{metadata:{library:"sap.m",properties:{visible:{type:"boolean",group:"Misc",defaultValue:true}}}});
return C;});
sap.ui.predefine('sap/m/CustomTreeItem',['./TreeItemBase','./ListItemBase','./library',"./CustomTreeItemRenderer"],function(T,L,l,C){"use strict";
var a=T.extend("sap.m.CustomTreeItem",{metadata:{library:"sap.m",defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",bindable:"bindable"}}}});
a.prototype.getContentAnnouncement=function(){return this.getContent().map(function(c){return L.getAccessibilityText(c);}).join(" ").trim();};
return a;});
sap.ui.predefine('sap/m/CustomTreeItemRenderer',['./TreeItemBaseRenderer','sap/ui/core/Renderer'],function(T,R){"use strict";var C=R.extend(T);
C.renderLIAttributes=function(r,l){r.addClass("sapMCTI");T.renderLIAttributes.apply(this,arguments);};
C.renderLIContent=function(r,l){l.getContent().forEach(function(c){r.renderControl(c);});};
return C;},true);
sap.ui.predefine('sap/m/P13nAnyFilterItem',['./library','sap/m/P13nFilterItem'],function(l,P){"use strict";
var a=P.extend("sap.m.P13nAnyFilterItem",{metadata:{library:"sap.m",properties:{value1:{type:"any",group:"Misc",defaultValue:null},value2:{type:"any",group:"Misc",defaultValue:null}}}});
return a;});
sap.ui.predefine('sap/m/P13nColumnsItem',['./library','sap/ui/core/Item'],function(l,I){"use strict";
var P=I.extend("sap.m.P13nColumnsItem",{metadata:{library:"sap.m",properties:{columnKey:{type:"string",group:"Misc"},index:{type:"int",group:"Appearance"},visible:{type:"boolean",group:"Appearance"},width:{type:"string",group:"Misc"},total:{type:"boolean"}}}});
return P;});
sap.ui.predefine('sap/m/P13nColumnsPanel',['sap/ui/core/library','sap/ui/model/ChangeReason','sap/ui/model/json/JSONModel','sap/ui/model/BindingMode','sap/ui/core/ResizeHandler','sap/ui/core/IconPool','./library','./Table','./Column','./ColumnListItem','./P13nPanel','./P13nColumnsItem','./SearchField','./ScrollContainer','./Text','./Button','./OverflowToolbar','./OverflowToolbarLayoutData','./OverflowToolbarButton','./ToolbarSpacer',"sap/ui/thirdparty/jquery"],function(C,c,J,B,R,I,l,T,d,e,P,f,S,g,h,i,O,j,k,m,q){"use strict";var n=l.OverflowToolbarPriority;var o=l.ButtonType;var p=l.ToolbarDesign;var L=l.ListType;var r=l.ListMode;var s=l.P13nPanelType;
var t=P.extend("sap.m.P13nColumnsPanel",{
metadata:{library:"sap.m",properties:{visibleItemsThreshold:{type:"int",group:"Behavior",defaultValue:-1}},aggregations:{columnsItems:{type:"sap.m.P13nColumnsItem",multiple:true,singularName:"columnsItem",bindable:"bindable"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"}},events:{addColumnsItem:{parameters:{newItem:{type:"sap.m.P13nColumnsItem"}}},changeColumnsItems:{parameters:{newItems:{type:"sap.m.P13nColumnsItem[]"},existingItems:{type:"sap.m.P13nColumnsItem[]"},items:{type:"object[]"}}},setData:{}}},
renderer:function(a,b){a.write("<div");a.writeControlData(b);a.addClass("sapMP13nColumnsPanel");a.writeClasses();a.write(">");var u=b.getAggregation("content");if(u){u.forEach(function(v){a.renderControl(v);});}a.write("</div>");}
});
t.prototype.init=function(){this._iLiveChangeTimer=0;this._iSearchTimer=0;this._bIgnoreUpdateInternalModel=false;this._bUpdateInternalModel=true;this._bTableItemsChanged=false;this._bOnAfterRenderingFirstTimeExecuted=false;var M=new J({items:[],columnKeyOfMarkedItem:undefined,isMoveDownButtonEnabled:undefined,isMoveUpButtonEnabled:undefined,showOnlySelectedItems:undefined,countOfSelectedItems:0,countOfItems:0});M.setDefaultBindingMode(B.TwoWay);M.setSizeLimit(1000);this.setModel(M,"$sapmP13nColumnsPanel");this.setType(s.columns);this.setTitle(sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("COLUMSPANEL_TITLE"));this._createTable();this._createToolbar();this.setVerticalScrolling(false);var a=new g({horizontal:false,vertical:true,content:[this._oTable],width:'100%',height:'100%'});this.addAggregation("content",a);var b=this;this._fnHandleResize=function(){var u=false,v,w;if(b.getParent){var $=null,x,H;var y=b.getParent();var z=b._getToolbar();if(y&&y.$){$=y.$("cont");if($.children().length>0&&z.$().length>0){v=a.$()[0].clientHeight;x=$.children()[0].clientHeight;H=z?z.$()[0].clientHeight:0;w=x-H;if(v!==w){a.setHeight(w+'px');u=true;}}}}return u;};this._sContainerResizeListener=R.register(a,this._fnHandleResize);};
t.prototype.reInitialize=function(){};
t.prototype.onBeforeRendering=function(){this._updateInternalModel();if(!this._getInternalModel().getProperty("/columnKeyOfMarkedItem")){this._setColumnKeyOfMarkedItem(this._getColumnKeyByTableItem(this._getVisibleTableItems()[0]));}this._switchMarkedTableItemTo(this._getTableItemByColumnKey(this._getInternalModel().getProperty("/columnKeyOfMarkedItem")));this._updateControlLogic();};
t.prototype.onAfterRendering=function(){if(!this._bOnAfterRenderingFirstTimeExecuted){this._bOnAfterRenderingFirstTimeExecuted=true;window.clearTimeout(this._iLiveChangeTimer);var a=this;this._iLiveChangeTimer=window.setTimeout(function(){a._fnHandleResize();},0);}};
t.prototype.getOkPayload=function(){this._updateInternalModel();var M=this._getInternalModel().getProperty("/items");return{tableItems:M.map(function(a){return{columnKey:a.columnKey,index:a.persistentIndex===-1?undefined:a.persistentIndex,visible:a.persistentSelected,width:a.width};}),tableItemsChanged:this._bTableItemsChanged,selectedItems:M.filter(function(a){return a.persistentSelected;}).map(function(a){return{columnKey:a.columnKey};})};};
t.prototype.getResetPayload=function(){return{oPanel:this};};
t.prototype.exit=function(){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;this._getToolbar().destroy();this._oTable.destroy();this._oTable=null;if(this._getInternalModel()){this._getInternalModel().destroy();}window.clearTimeout(this._iLiveChangeTimer);window.clearTimeout(this._iSearchTimer);};
t.prototype.addItem=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("items",a);return this;};
t.prototype.insertItem=function(a,b){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("items",a,b);return this;};
t.prototype.removeItem=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}a=this.removeAggregation("items",a);return a;};
t.prototype.removeAllItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("items");};
t.prototype.destroyItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("items");return this;};
t.prototype.addColumnsItem=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("columnsItems",a);return this;};
t.prototype.insertColumnsItem=function(a,b){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("columnsItems",a,b);return this;};
t.prototype.updateColumnsItems=function(a){this.updateAggregation("columnsItems");if(a===c.Change&&!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}};
t.prototype.removeColumnsItem=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAggregation("columnsItems",a);};
t.prototype.removeAllColumnsItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("columnsItems");};
t.prototype.destroyColumnsItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("columnsItems");return this;};
t.prototype.onBeforeNavigationFrom=function(){var M=this._getSelectedModelItems();var v=this.getVisibleItemsThreshold();return!(M&&v!==-1&&M.length>v);};
t.prototype._notifyChange=function(){this._bTableItemsChanged=true;var a=this.getChangeNotifier();if(a){a(this);}};
t.prototype._scrollToSelectedItem=function(a){if(!a){return;}sap.ui.getCore().applyChanges();if(!!a.getDomRef()){a.focus();}};
t.prototype._getInternalModel=function(){return this.getModel("$sapmP13nColumnsPanel");};
t.prototype._createTable=function(){this._oTable=new T({mode:r.MultiSelect,rememberSelections:false,itemPress:q.proxy(this._onItemPressed,this),selectionChange:q.proxy(this._onSelectionChange,this),columns:[new d({vAlign:C.VerticalAlign.Middle,header:new h({text:{parts:[{path:'/countOfSelectedItems'},{path:'/countOfItems'}],formatter:function(a,b){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText('COLUMNSPANEL_SELECT_ALL_WITH_COUNTER',[a,b]);}}})})],items:{path:"/items",templateShareable:false,template:new e({cells:[new h({text:"{text}"})],visible:"{visible}",selected:"{persistentSelected}",tooltip:"{tooltip}",type:L.Active})}});this._oTable.setModel(this._getInternalModel());};
t.prototype._createToolbar=function(){var a=this;var b=sap.ui.getCore().getLibraryResourceBundle("sap.m");var u=new O(this.getId()+"-toolbar",{design:p.Auto,content:[new m(),new S(this.getId()+"-searchField",{liveChange:function(E){var v=E.getSource().getValue(),D=(v?300:0);window.clearTimeout(a._iSearchTimer);if(D){a._iSearchTimer=window.setTimeout(function(){a._onExecuteSearch();},D);}else{a._onExecuteSearch();}},search:q.proxy(this._onExecuteSearch,this),layoutData:new j({minWidth:"12.5rem",maxWidth:"23.077rem",shrinkable:true,moveToOverflow:false,stayInOverflow:false})}),new i({text:{path:'/showOnlySelectedItems',formatter:function(v){return v?b.getText('COLUMNSPANEL_SHOW_ALL'):b.getText('COLUMNSPANEL_SHOW_SELECTED');}},tooltip:{path:'/showOnlySelectedItems',formatter:function(v){return v?b.getText('COLUMNSPANEL_SHOW_ALL'):b.getText('COLUMNSPANEL_SHOW_SELECTED');}},type:o.Transparent,press:q.proxy(this._onSwitchButtonShowSelected,this),layoutData:new j({moveToOverflow:true,priority:n.High})}),new k({icon:I.getIconURI("collapse-group"),text:b.getText('COLUMNSPANEL_MOVE_TO_TOP'),tooltip:b.getText('COLUMNSPANEL_MOVE_TO_TOP'),type:o.Transparent,enabled:{path:'/isMoveUpButtonEnabled'},press:q.proxy(this.onPressButtonMoveToTop,this),layoutData:new j({moveToOverflow:true,priority:n.Low,group:2})}),new k({icon:I.getIconURI("slim-arrow-up"),text:b.getText('COLUMNSPANEL_MOVE_UP'),tooltip:b.getText('COLUMNSPANEL_MOVE_UP'),type:o.Transparent,enabled:{path:'/isMoveUpButtonEnabled'},press:q.proxy(this.onPressButtonMoveUp,this),layoutData:new j({moveToOverflow:true,priority:n.High,group:1})}),new k({icon:I.getIconURI("slim-arrow-down"),text:b.getText('COLUMNSPANEL_MOVE_DOWN'),tooltip:b.getText('COLUMNSPANEL_MOVE_DOWN'),type:o.Transparent,enabled:{path:'/isMoveDownButtonEnabled'},press:q.proxy(this.onPressButtonMoveDown,this),layoutData:new j({moveToOverflow:true,priority:n.High,group:1})}),new k({icon:I.getIconURI("expand-group"),text:b.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),tooltip:b.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),type:o.Transparent,enabled:{path:'/isMoveDownButtonEnabled'},press:q.proxy(this.onPressButtonMoveToBottom,this),layoutData:new j({moveToOverflow:true,priority:n.Low,group:2})})]});u.setModel(this._getInternalModel());this.addAggregation("content",u);};
t.prototype.onPressButtonMoveToTop=function(){this._moveMarkedTableItem(this._getMarkedTableItem(),this._getVisibleTableItems()[0]);};
t.prototype.onPressButtonMoveUp=function(){var v=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),v[v.indexOf(this._getMarkedTableItem())-1]);};
t.prototype.onPressButtonMoveDown=function(){var v=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),v[v.indexOf(this._getMarkedTableItem())+1]);};
t.prototype.onPressButtonMoveToBottom=function(){var v=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),v[v.length-1]);};
t.prototype._onSwitchButtonShowSelected=function(){this._getInternalModel().setProperty("/showOnlySelectedItems",!this._getInternalModel().getProperty("/showOnlySelectedItems"));this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._scrollToSelectedItem(this._getMarkedTableItem());this._updateControlLogic();this._fnHandleResize();};
t.prototype._onExecuteSearch=function(){this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._updateControlLogic();};
t.prototype._switchVisibilityOfUnselectedModelItems=function(){var b=this._isFilteredByShowSelected();var M=this._getInternalModel().getProperty("/items");M.forEach(function(a){if(a.persistentSelected){a.visible=true;return;}a.visible=!b;});this._getInternalModel().setProperty("/items",M);};
t.prototype._getVisibleModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(M){return!!M.visible;});};
t.prototype._moveMarkedTableItem=function(a,b){var M=this._getModelItemByColumnKey(this._getColumnKeyByTableItem(a));var u=this._getModelItemByColumnKey(this._getColumnKeyByTableItem(b));var v=this._getModelItemIndexByColumnKey(M.columnKey);var w=this._getModelItemIndexByColumnKey(u.columnKey);this._moveModelItems(v,w);this._scrollToSelectedItem(this._getMarkedTableItem());this._updateControlLogic();this._fireChangeColumnsItems();this._fireSetData();this._notifyChange();};
t.prototype._moveModelItems=function(a,b){var M=this._getInternalModel().getProperty("/items");if(a<0||b<0||a>M.length-1||b>M.length-1){return false;}this._removeStyleOfMarkedTableItem();var u=M.splice(a,1);M.splice(b,0,u[0]);this._updateModelItemsPersistentIndex(M);this._updateCounts(M);this._getInternalModel().setProperty("/items",M);this._switchMarkedTableItemTo(this._getMarkedTableItem());return true;};
t.prototype._getModelItemByColumnKey=function(a){var M=this._getInternalModel().getProperty("/items").filter(function(b){return b.columnKey===a;});return M[0];};
t.prototype._updateCounts=function(M){var a=0;var b=0;M.forEach(function(u){a++;if(u.persistentSelected){b++;}});this._getInternalModel().setProperty("/countOfItems",a);this._getInternalModel().setProperty("/countOfSelectedItems",b);};
t.prototype._sortModelItemsByPersistentIndex=function(M){var u;var v;try{v=sap.ui.getCore().getConfiguration().getLocale().toString();if(typeof window.Intl!=='undefined'){u=window.Intl.Collator(v,{numeric:true});}}catch(E){}M.forEach(function(a,b){a.localIndex=b;});M.sort(function(a,b){if(a.persistentSelected===true&&(b.persistentSelected===false||b.persistentSelected===undefined)){return-1;}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&b.persistentSelected===true){return 1;}else if(a.persistentSelected===true&&b.persistentSelected===true){if(a.persistentIndex>-1&&a.persistentIndex<b.persistentIndex){return-1;}else if(b.persistentIndex>-1&&a.persistentIndex>b.persistentIndex){return 1;}else{return a.localIndex-b.localIndex;}}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&(b.persistentSelected===false||b.persistentSelected===undefined)){return u?u.compare(a.text,b.text):a.text.localeCompare(b.text,v,{numeric:true});}});M.forEach(function(a){delete a.localIndex;});};
t.prototype._getColumnKeyByTableItem=function(a){var b=this._oTable.indexOfItem(a);if(b<0){return null;}return this._oTable.getBinding("items").getContexts()[b].getObject().columnKey;};
t.prototype._getModelItemIndexByColumnKey=function(a){var b=-1;this._getInternalModel().getProperty("/items").some(function(M,u){if(M.columnKey===a){b=u;return true;}});return b;};
t.prototype._getSelectedModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(M){return M.persistentSelected;});};
t.prototype._getVisibleTableItems=function(){return this._oTable.getItems().filter(function(a){return a.getVisible();});};
t.prototype._getTableItemByColumnKey=function(a){var b=this._oTable.getBinding("items").getContexts();var u=this._oTable.getItems().filter(function(v,w){return b[w].getObject().columnKey===a;});return u[0];};
t.prototype._getToolbar=function(){return sap.ui.getCore().byId(this.getId()+"-toolbar")||null;};
t.prototype._getSearchField=function(){return sap.ui.getCore().byId(this.getId()+"-searchField")||null;};
t.prototype._getSearchText=function(){var a=this._getSearchField();return a?a.getValue():"";};
t.prototype._isFilteredBySearchText=function(){return!!this._getSearchText().length;};
t.prototype._isFilteredByShowSelected=function(){return this._getInternalModel().getData().showOnlySelectedItems;};
t.prototype._updateControlLogic=function(){var b=this._isFilteredBySearchText();var a=this._isFilteredByShowSelected();var v=this._getVisibleTableItems();this._getInternalModel().setProperty("/isMoveUpButtonEnabled",v.indexOf(this._getMarkedTableItem())>0);this._getInternalModel().setProperty("/isMoveDownButtonEnabled",v.indexOf(this._getMarkedTableItem())>-1&&v.indexOf(this._getMarkedTableItem())<v.length-1);var u=sap.ui.getCore().byId(this._oTable.getId()+'-sa');if(u){u.setEnabled(!b&&!a);}};
t.prototype._updateModelItemsPersistentIndex=function(M){var a=-1;M.forEach(function(b){b.persistentIndex=-1;if(b.persistentSelected){a++;b.persistentIndex=a;}});};
t.prototype._fireSetData=function(){this._bIgnoreUpdateInternalModel=true;this.fireSetData();this._bIgnoreUpdateInternalModel=false;};
t.prototype._fireChangeColumnsItems=function(){this._bIgnoreUpdateInternalModel=true;var M=this._getInternalModel().getProperty("/items");var E={newItems:[],existingItems:[],items:M.map(function(a){return{columnKey:a.columnKey,visible:a.persistentSelected,index:a.persistentIndex===-1?undefined:a.persistentIndex,width:a.width,total:a.total};})};M.forEach(function(a){var b=this._getColumnsItemByColumnKey(a.columnKey);if(b){b.setVisible(a.persistentSelected);b.setIndex(a.persistentIndex===-1?undefined:a.persistentIndex);if(a.width!==undefined){b.setWidth(a.width);}if(a.total!==undefined){b.setTotal(a.total);}E.existingItems.push(b);}else{E.newItems.push(new f({columnKey:a.columnKey,visible:a.persistentSelected,index:a.persistentIndex===-1?undefined:a.persistentIndex,width:a.width,total:a.total}));}},this);this.fireChangeColumnsItems(E);this._bIgnoreUpdateInternalModel=false;};
t.prototype._getColumnsItemByColumnKey=function(a){var b=this.getColumnsItems().filter(function(u){return u.getColumnKey()===a;});return b[0];};
t.prototype._getMarkedTableItem=function(){return this._getTableItemByColumnKey(this._getInternalModel().getProperty("/columnKeyOfMarkedItem"));};
t.prototype._setColumnKeyOfMarkedItem=function(a){this._getInternalModel().setProperty("/columnKeyOfMarkedItem",a);};
t.prototype._onItemPressed=function(E){this._switchMarkedTableItemTo(E.getParameter('listItem'));this._updateControlLogic();};
t.prototype._onSelectionChange=function(E){if(!E.getParameter("selectAll")&&E.getParameter("listItems").length===1){this._switchMarkedTableItemTo(E.getParameter("listItem"));}this._selectTableItem();};
t.prototype._selectTableItem=function(){this._updateControlLogic();var M=this._getInternalModel().getProperty("/items");this._updateModelItemsPersistentIndex(M);this._updateCounts(M);this._getInternalModel().setProperty("/items",M);this._fireChangeColumnsItems();this._fireSetData();this._notifyChange();var v=this.getValidationExecutor();if(v){v();}};
t.prototype._switchMarkedTableItemTo=function(a){this._removeStyleOfMarkedTableItem();var b=this._getColumnKeyByTableItem(a);if(b){this._setColumnKeyOfMarkedItem(b);a.addStyleClass("sapMP13nColumnsPanelItemSelected");}};
t.prototype._removeStyleOfMarkedTableItem=function(){if(this._getMarkedTableItem()){this._getMarkedTableItem().removeStyleClass("sapMP13nColumnsPanelItemSelected");}};
t.prototype._filterModelItemsBySearchText=function(){var a=this._getSearchText();a=a.replace(/(^\s+)|(\s+$)/g,'');a=a.replace(/[-\/\\^$*+?.()|[\]{}]/g,'\\$&');var b=new RegExp(a,'igm');if(!b){return;}this._getVisibleModelItems().forEach(function(M){M.visible=false;if(typeof M.text==="string"&&M.text.match(b)){M.visible=true;}if(typeof M.tooltip==="string"&&M.tooltip.match(b)){M.visible=true;}});this._getInternalModel().refresh();};
t.prototype._updateInternalModel=function(){if(!this._bUpdateInternalModel){return;}this._bUpdateInternalModel=false;this._removeStyleOfMarkedTableItem();var M=this._getInternalModel().getProperty("/items");this._getInternalModel().setProperty("/items",this.getItems().map(function(b){return{columnKey:b.getColumnKey(),visible:true,text:b.getText(),tooltip:b.getTooltip(),persistentIndex:-1,persistentSelected:b.getVisible(),width:undefined,total:undefined};},this));this.getColumnsItems().forEach(function(b){var u=this._getModelItemByColumnKey(b.getColumnKey());if(!u){return;}if(b.getIndex()!==undefined){u.persistentIndex=b.getIndex();}if(b.getVisible()!==undefined){u.persistentSelected=b.getVisible();}if(b.getWidth()!==undefined){u.width=b.getWidth();}if(b.getTotal()!==undefined){u.total=b.getTotal();}},this);this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();var a=this._getInternalModel().getProperty("/items");this._sortModelItemsByPersistentIndex(a);this._updateCounts(a);this._getInternalModel().setProperty("/items",a);this._switchMarkedTableItemTo(this._getMarkedTableItem());if(q(a).not(M).length!==0||q(M).not(a).length!==0){this._bTableItemsChanged=true;}};
return t;});
sap.ui.predefine('sap/m/P13nConditionPanel',['./library','sap/ui/core/library','sap/ui/core/Control','sap/ui/core/format/DateFormat','sap/ui/core/format/NumberFormat','sap/ui/core/IconPool','sap/ui/Device','sap/ui/core/InvisibleText','sap/ui/core/ResizeHandler','sap/ui/core/Item','sap/ui/core/ListItem','sap/ui/model/odata/type/Boolean','sap/ui/model/type/String','sap/ui/model/odata/type/String','sap/ui/model/type/Date','sap/ui/model/type/Time','sap/ui/model/odata/type/DateTime','sap/ui/model/type/Float','./Button','./OverflowToolbar','./OverflowToolbarLayoutData','./ToolbarSpacer','./Text','./SearchField','./CheckBox','./ComboBox','./Select','./Label','./Input','./DatePicker','./TimePicker','./DateTimePicker',"sap/base/Log","sap/ui/thirdparty/jquery"],function(a,c,C,D,N,I,b,d,R,e,L,B,S,f,g,T,h,F,k,O,m,o,q,r,s,t,u,v,x,y,z,A,E,Q){"use strict";var V=c.ValueState;var G=a.ButtonType;var H=a.ToolbarDesign;var J=c.TextAlign;var K=a.OverflowToolbarPriority;var M;var P;var U;var W;
var X=C.extend("sap.m.P13nConditionPanel",{
metadata:{library:"sap.m",properties:{maxConditions:{type:"string",group:"Misc",defaultValue:'-1'},exclude:{type:"boolean",group:"Misc",defaultValue:false},containerQuery:{type:"boolean",group:"Misc",defaultValue:false},autoAddNewRow:{type:"boolean",group:"Misc",defaultValue:false},disableFirstRemoveIcon:{type:"boolean",group:"Misc",defaultValue:false},alwaysShowAddIcon:{type:"boolean",group:"Misc",defaultValue:true},usePrevConditionSetting:{type:"boolean",group:"Misc",defaultValue:true},autoReduceKeyFieldItems:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null},showLabel:{type:"boolean",group:"Misc",defaultValue:false},displayFormat:{type:"string",group:"Misc",defaultValue:null},validationExecutor:{type:"object",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"}},events:{dataChange:{}}},
renderer:function(j,l){j.write("<section");j.writeControlData(l);j.addClass("sapMConditionPanel");j.writeClasses();j.writeStyles();j.write(">");j.write("<div");j.addClass("sapMConditionPanelContent");j.addClass("sapMConditionPanelBG");j.writeClasses();j.write(">");var n=l.getAggregation("content");var p=n.length;for(var i=0;i<p;i++){j.renderControl(n[i]);}j.write("</div>");j.write("</section>");}
});
X.prototype.setConditions=function(j){if(!j){E.error("sap.m.P13nConditionPanel : aCondition is not defined");}if(this._bIgnoreSetConditions){return;}this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;for(var i=0;i<j.length;i++){this._addCondition2Map(j[i]);}this._clearConditions();this._fillConditions();};
X.prototype.removeAllConditions=function(){this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;this._clearConditions();this._fillConditions();};
X.prototype.addCondition=function(i){if(this._bIgnoreSetConditions){return;}i.index=this._iConditions;this._addCondition2Map(i);this._addCondition(i);};
X.prototype.insertCondition=function(i,j){if(this._bIgnoreSetConditions){return;}if(j!==undefined){i.index=j;}this._addCondition2Map(i);this._addCondition(i);};
X.prototype.removeCondition=function(i){this._clearConditions();if(typeof i=="string"){this._removeConditionFromMap(i);}if(typeof i=="object"){this._removeConditionFromMap(i.key);}this._fillConditions();};
X.prototype._addCondition2Map=function(i){if(!i.key){i.key="condition_"+this._iConditions;if(this.getExclude()){i.key="x"+i.key;}}this._iConditions++;this._oConditionsMap[i.key]=i;this._aConditionKeys.push(i.key);};
X.prototype._removeConditionFromMap=function(j){this._iConditions--;delete this._oConditionsMap[j];var i=this._aConditionKeys.indexOf(j);if(i>=0){this._aConditionKeys.splice(i,1);}};
X.prototype.getConditions=function(){var i;var j=[];if(this._oConditionsMap){for(var l in this._oConditionsMap){i=this._oConditionsMap[l];var n=i.value;if(!n){n=this._getFormatedConditionText(i.operation,i.value1,i.value2,i.exclude,i.keyField,i.showIfGrouped);}if(!i._oGrid||i._oGrid.select.getSelected()){j.push({"key":l,"text":n,"exclude":i.exclude,"operation":i.operation,"keyField":i.keyField,"value1":i.value1,"value2":i.operation===Y.BT?i.value2:null,"showIfGrouped":i.showIfGrouped});}}}return j;};
X.prototype.setOperations=function(i,j){j=j||"default";this._oTypeOperations[j]=i;this._updateAllOperations();};
X.prototype.setValues=function(i,j){j=j||"default";this._oTypeValues[j]=i;};
X.prototype.addOperation=function(i,j){j=j||"default";this._oTypeOperations[j].push(i);this._updateAllOperations();};
X.prototype.removeAllOperations=function(i){i=i||"default";this._oTypeOperations[i]=[];this._updateAllOperations();};
X.prototype.getOperations=function(i){i=i||"default";return this._oTypeOperations[i];};
X.prototype.setKeyFields=function(i){this._aKeyFields=i;this._aKeyFields.forEach(function(j){X._createKeyFieldTypeInstance(j);},this);this._updateKeyFieldItems(this._oConditionsGrid,true);this._updateAllConditionsEnableStates();this._createAndUpdateAllKeyFields();this._updateAllOperations();};
X.prototype.addKeyField=function(i){this._aKeyFields.push(i);X._createKeyFieldTypeInstance(i);this._updateKeyFieldItems(this._oConditionsGrid,true,true);this._updateAllConditionsEnableStates();this._createAndUpdateAllKeyFields();this._updateAllOperations();};
X._createKeyFieldTypeInstance=function(i){var j;if(!i.typeInstance){switch(i.type){case"boolean":i.typeInstance=new B();break;case"numc":if(!(i.formatSettings&&i.formatSettings.isDigitSequence)){E.error("sap.m.P13nConditionPanel","NUMC type support requires isDigitSequence==true!");i.formatSettings=Q.extend({},i.formatSettings,{isDigitSequence:true});}j=i.formatSettings;if(i.maxLength){j=Q.extend({},j,{maxLength:i.maxLength});}if(!j.maxLength){E.error("sap.m.P13nConditionPanel","NUMC type suppport requires maxLength!");}i.typeInstance=new f({},j);break;case"date":i.typeInstance=new g(Q.extend({},i.formatSettings,{strictParsing:true}),{});break;case"time":i.typeInstance=new T(Q.extend({},i.formatSettings,{strictParsing:true}),{});break;case"datetime":i.typeInstance=new h(Q.extend({},i.formatSettings,{strictParsing:true}),{displayFormat:"Date"});var n=i.typeInstance;if(!n.oFormat){n.formatValue(new Date(),"string");}if(n.oFormat){n.oFormat.oFormatOptions.UTC=false;}break;case"stringdate":sap.ui.getCore().loadLibrary("sap.ui.comp");W=W||sap.ui.requireSync("sap/ui/comp/odata/type/StringDate");i.typeInstance=new W(Q.extend({},i.formatSettings,{strictParsing:true}));break;case"numeric":if(i.precision||i.scale){j={};if(i.precision){j["maxIntegerDigits"]=parseInt(i.precision);}if(i.scale){j["maxFractionDigits"]=parseInt(i.scale);}}i.typeInstance=new F(j);break;default:var l=i.formatSettings;if(i.maxLength){l=Q.extend({},l,{maxLength:i.maxLength});}i.typeInstance=new S({},l);break;}}};
X.prototype.removeAllKeyFields=function(){this._aKeyFields=[];this._updateKeyFieldItems(this._oConditionsGrid,true);};
X.prototype.getKeyFields=function(){return this._aKeyFields;};
X.prototype.setAlwaysShowAddIcon=function(i){this.setProperty("alwaysShowAddIcon",i);if(this._oConditionsGrid){this._oConditionsGrid.toggleStyleClass("conditionRootGrid",this.getLayoutMode()!=="Desktop");}return this;};
X.prototype.setLayoutMode=function(l){this.setProperty("layoutMode",l);if(this._oConditionsGrid){this._oConditionsGrid.toggleStyleClass("conditionRootGrid",l!=="Desktop");}this._updateConditionFieldSpans(l);this._clearConditions();this._fillConditions();return this;};
X.prototype.setContainerQuery=function(i){this._unregisterResizeHandler();this.setProperty("containerQuery",i);this._registerResizeHandler();this._clearConditions();this._fillConditions();return this;};
X.prototype._updateConditionFieldSpans=function(i){if(this._aConditionsFields){var j=i==="Desktop";if(j){this._aConditionsFields[2].SpanFilter="L3 M3 S3";this._aConditionsFields[4].SpanFilter="L2 M2 S2";this._aConditionsFields[5].SpanFilter="L3 M3 S3";this._aConditionsFields[6].SpanFilter="L2 M2 S2";this._aConditionsFields[7].SpanFilter="L1 M1 S1";}var l=i==="Tablet";if(l){this._aConditionsFields[2].SpanFilter="L5 M5 S5";this._aConditionsFields[4].SpanFilter="L5 M5 S5";this._aConditionsFields[5].SpanFilter="L10 M10 S10";this._aConditionsFields[6].SpanFilter="L10 M10 S10";this._aConditionsFields[7].SpanFilter="L1 M1 S1";}}};
X.prototype.init=function(){sap.ui.getCore().loadLibrary("sap.ui.layout");M=M||sap.ui.requireSync("sap/ui/layout/Grid");P=P||sap.ui.requireSync("sap/ui/layout/GridData");U=U||sap.ui.requireSync("sap/ui/layout/HorizontalLayout");this.addStyleClass("sapMConditionPanel");this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._sFromLabelText=this._oRb.getText("CONDITIONPANEL_LABELFROM");this._sToLabelText=this._oRb.getText("CONDITIONPANEL_LABELTO");this._sValueLabelText=this._oRb.getText("CONDITIONPANEL_LABELVALUE");this._sShowIfGroupedLabelText=this._oRb.getText("CONDITIONPANEL_LABELGROUPING");this._sValidationDialogFieldMessage=this._oRb.getText("CONDITIONPANEL_FIELDMESSAGE");this._oTypeOperations={"default":[]};this._oTypeValues={"default":[]};this._aKeyFields=[];this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;this._sLayoutMode="Desktop";this._sConditionType="Filter";this._sAddRemoveIconTooltip="FILTER";this._iBreakPointTablet=b.media._predefinedRangeSets[b.media.RANGESETS.SAP_STANDARD].points[0];this._iBreakPointDesktop=b.media._predefinedRangeSets[b.media.RANGESETS.SAP_STANDARD].points[1];this._oConditionsGrid=new M({width:"100%",defaultSpan:"L12 M12 S12",hSpacing:0,vSpacing:0}).toggleStyleClass("conditionRootGrid",this.getLayoutMode()!=="Desktop");this._oConditionsGrid.addStyleClass("sapUiRespGridOverflowHidden");this._iFirstConditionIndex=0;this._iConditionPageSize=10;this._oInvisibleTextField=new d({text:this._oRb.getText("CONDITIONPANEL_FIELD_LABEL")});this._oInvisibleTextOperator=new d({text:this._oRb.getText("CONDITIONPANEL_OPERATOR_LABEL")});this.addAggregation("content",this._oInvisibleTextField);this.addAggregation("content",this._oInvisibleTextOperator);this.addAggregation("content",this._oConditionsGrid);this._registerResizeHandler();this._aConditionsFields=[{"ID":"select","Label":"","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"CheckBox","Value":""},{"ID":"keyFieldLabel","Text":"Sort By","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"Label"},{"ID":"keyField","Label":"","SpanFilter":"L3 M5 S10","SpanSort":"L5 M5 S12","SpanGroup":"L4 M4 S12","Control":"ComboBox"},{"ID":"operationLabel","Text":"Sort Order","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"Label"},{"ID":"operation","Label":"","SpanFilter":"L2 M5 S10","SpanSort":b.system.phone?"L5 M5 S8":"L5 M5 S9","SpanGroup":"L2 M5 S10","Control":"ComboBox"},{"ID":"value1","Label":this._sFromLabelText,"SpanFilter":"L3 M10 S10","SpanSort":"L3 M10 S10","SpanGroup":"L3 M10 S10","Control":"TextField","Value":""},{"ID":"value2","Label":this._sToLabelText,"SpanFilter":"L2 M10 S10","SpanSort":"L2 M10 S10","SpanGroup":"L2 M10 S10","Control":"TextField","Value":""},{"ID":"showIfGrouped","Label":this._sShowIfGroupedLabelText,"SpanFilter":"L1 M10 S10","SpanSort":"L1 M10 S10","SpanGroup":"L3 M4 S9","Control":"CheckBox","Value":"false"}];this._oButtonGroupSpan={"SpanFilter":"L2 M2 S2","SpanSort":b.system.phone?"L2 M2 S4":"L2 M2 S3","SpanGroup":"L2 M2 S3"};this._updateConditionFieldSpans(this.getLayoutMode());this._fillConditions();};
X.prototype._createPaginatorToolbar=function(){this._bPaginatorButtonsVisible=false;var i=this;this._oPrevButton=new k({icon:I.getIconURI("navigation-left-arrow"),tooltip:this._oRb.getText("WIZARD_FINISH"),visible:true,press:function(j){i._iFirstConditionIndex=Math.max(0,i._iFirstConditionIndex-i._iConditionPageSize);i._clearConditions();i._fillConditions();},layoutData:new m({priority:K.NeverOverflow})});this._oNextButton=new k({icon:I.getIconURI("navigation-right-arrow"),tooltip:this._oRb.getText("WIZARD_NEXT"),visible:true,press:function(j){i._iFirstConditionIndex+=i._iConditionPageSize;i._clearConditions();i._fillConditions();},layoutData:new m({priority:K.NeverOverflow})});this._oRemoveAllButton=new k({text:this._oRb.getText("CONDITIONPANEL_REMOVE_ALL"),visible:true,press:function(j){i._aConditionKeys.forEach(function(l,n){if(n>=0){this.fireDataChange({key:l,index:n,operation:"remove",newData:null});}},i);this._iFirstConditionIndex=0;i.removeAllConditions();},layoutData:new m({priority:K.Low})});this._oAddButton=new k({icon:I.getIconURI("add"),tooltip:this._oRb.getText("CONDITIONPANEL_ADD"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP"),visible:true,press:function(j){var l=i._createConditionRow(i._oConditionsGrid,undefined,null,0);i._changeField(l);setTimeout(function(){l.keyField.focus();});i._updatePaginatorToolbar();},layoutData:new m({priority:K.Low})});this._oHeaderText=new q({wrapping:false,layoutData:new m({priority:K.NeverOverflow})});this._oPageText=new q({wrapping:false,textAlign:J.Center,layoutData:new m({priority:K.NeverOverflow})});this._oFilterField=new r({width:"12rem",layoutData:new m({priority:K.High})});this._oPaginatorToolbar=new O({height:"3rem",design:H.Transparent,content:[this._oHeaderText,new o(),this._oFilterField,this._oPrevButton,this._oPageText,this._oNextButton,this._oRemoveAllButton,this._oAddButton]});};
X.prototype._updatePaginatorToolbar=function(){if(this._sConditionType!=="Filter"||this.getMaxConditions()!=="-1"){return;}var i=this._aConditionKeys.length;var p=1+Math.floor(Math.max(0,i-1)/this._iConditionPageSize);var j=1+Math.floor(this._iFirstConditionIndex/this._iConditionPageSize);var l=this.getParent();if(!this._oPaginatorToolbar){if(i>this._iConditionPageSize){this._createPaginatorToolbar();this.insertAggregation("content",this._oPaginatorToolbar,0);this._onGridResize();}else{if(l&&l.setHeaderText){if(this._sOrgHeaderText==undefined){this._sOrgHeaderText=l.getHeaderText();}l.setHeaderText(this._sOrgHeaderText+(i>0?" ("+i+")":""));}return;}}this._oPrevButton.setEnabled(this._iFirstConditionIndex>0);this._oNextButton.setEnabled(this._iFirstConditionIndex+this._iConditionPageSize<i);if(l&&l.setHeaderToolbar){if(!l.getHeaderToolbar()){this.removeAggregation("content",this._oPaginatorToolbar);l.setHeaderToolbar(this._oPaginatorToolbar);l.attachExpand(function(Z){this._setToolbarElementVisibility(Z.getSource().getExpanded()&&this._bPaginatorButtonsVisible);}.bind(this));}}if(l&&l.setHeaderText){if(this._sOrgHeaderText==undefined){this._sOrgHeaderText=l.getHeaderText();}var n=this._sOrgHeaderText+(i>0?" ("+i+")":"");l.setHeaderText(n);this._oHeaderText.setText(n);}else{this._oHeaderText.setText(i+" Conditions");}this._oPageText.setText(j+"/"+p);this._bPaginatorButtonsVisible=this._bPaginatorButtonsVisible||p>1;this._setToolbarElementVisibility(this._bPaginatorButtonsVisible);if(j>p){this._iFirstConditionIndex-=Math.max(0,this._iConditionPageSize);this._clearConditions();this._fillConditions();}var w=0;this._oConditionsGrid.getContent().forEach(function(Z){if(Z.select.getSelected()){w++;}},this);if(p==j&&(i-this._iFirstConditionIndex)>w){this._clearConditions();this._fillConditions();}};
X.prototype._setToolbarElementVisibility=function(i){this._oPrevButton.setVisible(i);this._oNextButton.setVisible(i);this._oPageText.setVisible(i);this._oFilterField.setVisible(false);this._oAddButton.setVisible(i);this._oRemoveAllButton.setVisible(i);};
X.prototype.exit=function(){this._clearConditions();this._unregisterResizeHandler();this._aConditionsFields=null;this._aKeys=null;this._aKeyFields=null;this._oTypeOperations=null;this._oRb=null;this._sFromLabelText=null;this._sToLabelText=null;this._sValueLabelText=null;this._sValidationDialogFieldMessage=null;this._oConditionsMap=null;this._aConditionKeys=[];};
X.prototype._clearConditions=function(){var i=this._oConditionsGrid.getContent();i.forEach(function(j){for(var l in this._aConditionsFields){var n=this._aConditionsFields[l];if(j[n["ID"]]&&j.getContent().indexOf(j[n["ID"]])===-1){j[n["ID"]].destroy();}}},this);this._oConditionsGrid.destroyContent();};
X.prototype._fillConditions=function(){var j,l;var i=0,p=this._getMaxConditionsAsNumber(),n=this._aConditionKeys.length;if(this._oConditionsMap){var w=this._sConditionType!=="Filter"||this.getMaxConditions()!=="-1"?9999:this._iConditionPageSize;n=Math.min(n,Math.min(p,this._iFirstConditionIndex+w));for(i=this._iFirstConditionIndex;i<n;i++){l=this._aConditionKeys[i];j=this._oConditionsMap[l];this._createConditionRow(this._oConditionsGrid,j,l);}}this._updatePaginatorToolbar();if((this.getAutoAddNewRow()||this._oConditionsGrid.getContent().length===0)&&this._oConditionsGrid.getContent().length<p){this._createConditionRow(this._oConditionsGrid);}};
X.prototype._addCondition=function(j){var i=0;var l=this._getMaxConditionsAsNumber();if(this._oConditionsMap){for(var n in this._oConditionsMap){if(i<l&&j===this._oConditionsMap[n]){this._createConditionRow(this._oConditionsGrid,j,n,i);}i++;}}this._updatePaginatorToolbar();};
X.prototype._getMaxConditionsAsNumber=function(){return this.getMaxConditions()==="-1"?9999:parseInt(this.getMaxConditions());};
X.prototype.onAfterRendering=function(){if(this.getLayoutMode()){this._sLayoutMode=this.getLayoutMode();return;}};
X.prototype._handleMediaChange=function(p){this._sLayoutMode=p.name;this._updateLayout(p);};
X.prototype._unregisterResizeHandler=function(){if(this._sContainerResizeListener){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;}b.media.detachHandler(this._handleMediaChange,this,b.media.RANGESETS.SAP_STANDARD);};
X.prototype._registerResizeHandler=function(){if(this.getContainerQuery()){this._sContainerResizeListener=R.register(this._oConditionsGrid,Q.proxy(this._onGridResize,this));this._onGridResize();}else{b.media.attachHandler(this._handleMediaChange,this,b.media.RANGESETS.SAP_STANDARD);}};
X.prototype._getKeyFromConditionGrid=function(i){var j=i.data("_key");if(!j){j=this._createConditionKey();}return j;};
X.prototype._createConditionKey=function(){var i=0;var j;do{j="condition_"+i;if(this.getExclude()){j="x"+j;}i++;}while(this._oConditionsMap[j]);return j;};
X.prototype._createConditionRow=function(i,j,l,p){var n=null;var w;var Z=this;if(p===undefined){p=i.getContent().length;}var $=new M({width:"100%",defaultSpan:"L12 M12 S12",hSpacing:1,vSpacing:0,containerQuery:this.getContainerQuery()}).data("_key",l);$.addStyleClass("sapUiRespGridOverflowHidden");for(var _ in this._aConditionsFields){var a1;var b1=this._aConditionsFields[_];switch(b1["Control"]){case"CheckBox":a1=new s({enabled:false,visible:false,layoutData:new P({span:b1["Span"+this._sConditionType]})});if(b1["ID"]==="showIfGrouped"){a1.setEnabled(true);a1.setText(b1["Label"]);a1.attachSelect(function(){Z._changeField($);});a1.setSelected(j?j.showIfGrouped:true);}else{if(j){a1.setSelected(true);a1.setEnabled(true);}}break;case"ComboBox":if(b1["ID"]==="keyField"){a1=new t({width:"100%",ariaLabelledBy:this._oInvisibleTextField});var c1=Q.proxy(a1.setSelectedKey,a1);a1.setSelectedKey=function(l){c1(l);var p1=Z.getValidationExecutor();if(p1){p1();}};var d1=Q.proxy(a1.setSelectedItem,a1);a1.setSelectedItem=function(p1){d1(p1);var q1=Z.getValidationExecutor();if(q1){q1();}};a1.setLayoutData(new P({span:b1["Span"+this._sConditionType]}));this._fillKeyFieldListItems(a1,this._aKeyFields);if(a1.attachSelectionChange){a1.attachSelectionChange(function(p1){var q1=Z.getValidationExecutor();if(q1){q1();}Z._handleSelectionChangeOnKeyField(i,$);});}if(a1.attachChange){a1.attachChange(function(p1){$.keyField.close();Z._handleChangeOnKeyField(i,$);});}if(a1.setSelectedItem){if(j){a1.setSelectedKey(j.keyField);this._aKeyFields.forEach(function(e1,p1){var q1=e1.key;if(q1===undefined){q1=e1;}if(j.keyField===q1){a1.setSelectedItem(a1.getItems()[p1]);}},this);}else{if(this.getUsePrevConditionSetting()&&!this.getAutoReduceKeyFieldItems()){if(p>0&&!l){w=i.getContent()[p-1];if(w.keyField.getSelectedKey()){a1.setSelectedKey(w.keyField.getSelectedKey());}else{if(!a1.getSelectedItem()&&a1.getItems().length>0){a1.setSelectedItem(a1.getItems()[0]);}}}else{this._aKeyFields.some(function(e1,p1){if(e1.isDefault){a1.setSelectedItem(a1.getItems()[p1]);return true;}if(!a1.getSelectedItem()&&e1.type!=="boolean"){a1.setSelectedItem(a1.getItems()[p1]);}},this);if(!a1.getSelectedItem()&&a1.getItems().length>0){a1.setSelectedItem(a1.getItems()[0]);}}}else{this._aKeyFields.forEach(function(e1,p1){if(e1.isDefault){a1.setSelectedItem(a1.getItems()[p1]);}},this);}}}}if(b1["ID"]==="operation"){a1=new u({width:"100%",ariaLabelledBy:this._oInvisibleTextOperator,layoutData:new P({span:b1["Span"+this._sConditionType]})});a1.attachChange(function(){Z._handleChangeOnOperationField(i,$);});$[b1["ID"]]=a1;this._updateOperationItems(i,$);if(j){var e1=this._getCurrentKeyFieldItem($.keyField);var f1=this._oTypeOperations["default"];if(e1){if(e1.type&&this._oTypeOperations[e1.type]){f1=this._oTypeOperations[e1.type];}if(e1.operations){f1=e1.operations;}}f1.some(function(p1,q1){if(j.operation===p1){a1.setSelectedKey(p1);return true;}},this);}else{if(this.getUsePrevConditionSetting()){if(p>0&&l===null){var w=i.getContent()[p-1];a1.setSelectedKey(w.operation.getSelectedKey());}}}}if(a1.getSelectedItem&&a1.getSelectedItem()){a1.setTooltip(a1.getSelectedItem().getTooltip()||a1.getSelectedItem().getText());}break;case"TextField":var g1=this._getCurrentKeyFieldItem($.keyField);a1=this._createValueField(g1,b1,$);a1.oTargetGrid=i;if(j&&j[b1["ID"]]!==undefined){var h1=j[b1["ID"]];if(a1 instanceof u){if(typeof h1==="boolean"){a1.setSelectedIndex(h1?2:1);}}else if(h1!==null&&$.oType){if(typeof h1==="string"&&$.oType.getName()==="sap.ui.comp.odata.type.StringDate"){a1.setValue(h1);}else{if(typeof h1==="string"&&["String","sap.ui.model.odata.type.String","sap.ui.model.odata.type.Decimal"].indexOf($.oType.getName())==-1){try{h1=$.oType.parseValue(h1,"string");a1.setValue($.oType.formatValue(h1,"string"));}catch(i1){E.error("sap.m.P13nConditionPanel","Value '"+h1+"' does not have the expected type format for "+$.oType.getName()+".parseValue()");}}else{a1.setValue($.oType.formatValue(h1,"string"));}}}else{a1.setValue(h1);}}break;case"Label":a1=new v({text:b1["Text"]+":",visible:this.getShowLabel(),layoutData:new P({span:b1["Span"+this._sConditionType]})}).addStyleClass("conditionLabel");a1.oTargetGrid=i;break;}$[b1["ID"]]=a1;$.addContent(a1);}n=new U({layoutData:new P({span:this.getLayoutMode()==="Desktop"?"L2 M2 S2":this._oButtonGroupSpan["Span"+this._sConditionType]})}).addStyleClass("floatRight");$.addContent(n);$["ButtonContainer"]=n;var j1=new k({type:G.Transparent,icon:I.getIconURI("sys-cancel"),tooltip:this._oRb.getText("CONDITIONPANEL_REMOVE"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP"),press:function(){Z._handleRemoveCondition(this.oTargetGrid,$);},layoutData:new P({span:this.getLayoutMode()==="Desktop"?"L1 M1 S1":"L1 M2 S2"})});j1.oTargetGrid=i;n.addContent(j1);$["remove"]=j1;var k1=new k({type:G.Transparent,icon:I.getIconURI("add"),tooltip:this._oRb.getText("CONDITIONPANEL_ADD"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP"),press:function(){Z._handleAddCondition(this.oTargetGrid,$);},layoutData:new P({span:this.getLayoutMode()==="Desktop"?"L1 M1 S1":"L1 M10 S10"})});k1.oTargetGrid=i;k1.addStyleClass("conditionAddBtnFloatRight");n.addContent(k1);$["add"]=k1;i.insertContent($,p);this._updateOperationItems(i,$);this._changeOperationValueFields(i,$);this._updateAllConditionsEnableStates();this._updateConditionButtons(i);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(i,false);}if(this._sLayoutMode){this._updateLayout({name:this._sLayoutMode});}if(j){var l1=this._getFormatedConditionText(j.operation,j.value1,j.value2,j.exclude,j.keyField,j.showIfGrouped);j._oGrid=$;j.value=l1;this._oConditionsMap[l]=j;}var m1=$.operation.getSelectedKey();if(m1==="BT"&&$.value1.setMinDate&&$.value2.setMaxDate){var n1=$.value1.getDateValue();var o1=$.value2.getDateValue();this._updateMinMaxDate($,n1,o1);}else{this._updateMinMaxDate($,null,null);}return $;};
X.prototype._handleRemoveCondition=function(i,j){var l=i.getContent().indexOf(j);this._removeCondition(i,j);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(i,false);}if(l>=0){l=Math.min(l,i.getContent().length-1);var j=i.getContent()[l];setTimeout(function(){j.remove.focus();});}this._updatePaginatorToolbar();};
X.prototype._handleAddCondition=function(i,j){var p=i.getContent().indexOf(j);var l=this._createConditionRow(i,undefined,null,p+1);this._changeField(l);setTimeout(function(){l.keyField.focus();});this._updatePaginatorToolbar();};
X.prototype._getCurrentKeyFieldItem=function(i){if(i.getSelectedKey&&i.getSelectedKey()){var j=i.getSelectedKey();var l=this._aKeyFields;for(var n in l){var p=l[n];if(p.key===j){return p;}}}return null;};
X.prototype._createValueField=function(j,n,p){var w;var Z;var $=this;var _={value:n["Value"],width:"100%",placeholder:n["Label"],change:function(i){$._validateAndFormatFieldValue(i);$._changeField(p);},layoutData:new P({span:n["Span"+this._sConditionType]})};if(j&&j.typeInstance){var a1=j.typeInstance;Z=this._findConfig(a1,"ctrl");if(Z==="DateTimePicker"&&a1.getMetadata().getName()==="sap.ui.model.odata.type.DateTime"){if(!(a1.oConstraints&&a1.oConstraints.isDateOnly)){E.error("sap.m.P13nConditionPanel","sap.ui.model.odata.type.DateTime without displayFormat = Date is not supported!");a1.oConstraints=Q.extend({},a1.oConstraints,{isDateOnly:true});}Z="DatePicker";}p.oType=a1;if(Z=="select"){var b1=[];var c1=j.values||this._oTypeValues[Z]||["",a1.formatValue(false,"string"),a1.formatValue(true,"string")];c1.forEach(function(i,e1){b1.push(new e({key:(e1===c1.length-1).toString(),text:i.toString()}));});_={width:"100%",items:b1,change:function(){$._changeField(p);},layoutData:new P({span:n["Span"+this._sConditionType]})};w=new u(_);}else if(Z=="TimePicker"){if(a1.oFormatOptions&&a1.oFormatOptions.style){_.displayFormat=a1.oFormatOptions.style;}w=new z(_);}else if(Z=="DateTimePicker"){if(a1.oFormatOptions&&a1.oFormatOptions.style){_.displayFormat=a1.oFormatOptions.style;}w=new A(_);}else if(Z=="DatePicker"){if(a1.oFormatOptions&&a1.oFormatOptions.style){_.displayFormat=a1.oFormatOptions.style;}w=new y(_);if(a1&&a1.getName()==="sap.ui.comp.odata.type.StringDate"){w.setValueFormat("yyyyMMdd");w.setDisplayFormat(a1.oFormatOptions.style||a1.oFormatOptions.pattern);}}else{w=new x(_);if(this._fSuggestCallback){j=this._getCurrentKeyFieldItem(p.keyField);if(j&&j.key){var d1=this._fSuggestCallback(w,j.key);if(d1){w._oSuggestProvider=d1;}}}}}else{p.oType=null;w=new x(_);}if(Z!=="boolean"&&Z!=="enum"&&w){w.onpaste=function(e1){var f1;if(window.clipboardData){f1=window.clipboardData.getData("Text");}else{f1=e1.originalEvent.clipboardData.getData('text/plain');}var p=e1.srcControl.getParent();var g1=f1.split(/\r\n|\r|\n/g);var h1=p.operation;var op=h1.getSelectedKey();if(g1&&g1.length>1&&op!=="BT"){setTimeout(function(){var i1=g1?g1.length:0;var j1=$._getCurrentKeyFieldItem(p.keyField);var h1=p.operation;for(var i=0;i<i1;i++){if($._aConditionKeys.length>=$._getMaxConditionsAsNumber()){break;}var k1=g1[i].trim();if(k1){var l1={"key":$._createConditionKey(),"exclude":$.getExclude(),"operation":h1.getSelectedKey(),"keyField":j1.key,"value1":k1,"value2":null};$._addCondition2Map(l1);$.fireDataChange({key:l1.key,index:l1.index,operation:"add",newData:l1});}}$._clearConditions();$._fillConditions();},0);}};}if(j&&j.maxLength&&w.setMaxLength){var l=-1;if(typeof j.maxLength==="string"){l=parseInt(j.maxLength);}if(typeof j.maxLength==="number"){l=j.maxLength;}if(l>0&&(!w.getShowSuggestion||!w.getShowSuggestion())){w.setMaxLength(l);}}return w;};
X.prototype._fillOperationListItems=function(i,j,l){if(l==="_STRING_"){l="";}if(l==="_TIME_"||l==="_DATETIME_"){l="_DATE_";}if(l==="_BOOLEAN_"||l==="_NUMC_"){l="";}i.destroyItems();for(var n in j){var p=this._oRb.getText("CONDITIONPANEL_OPTION"+l+j[n]);if(p.startsWith("CONDITIONPANEL_OPTION")){p=this._oRb.getText("CONDITIONPANEL_OPTION"+j[n]);}i.addItem(new L({key:j[n],text:p,tooltip:p}));}};
X.prototype._fillKeyFieldListItems=function(i,j){i.destroyItems();for(var l in j){var n=j[l];i.addItem(new L({key:n.key,text:n.text,tooltip:n.tooltip?n.tooltip:n.text}));}i.setEditable(i.getItems().length>1);};
X.prototype._handleChangeOnOperationField=function(i,j){this._changeOperationValueFields(i,j);this._changeField(j);};
X.prototype._handleSelectionChangeOnKeyField=function(i,j){if(this._sConditionType==="Filter"){this._updateOperationItems(i,j);this._createAndUpdateValueFields(i,j);this._changeOperationValueFields(i,j);}this._changeField(j);};
X.prototype._handleChangeOnKeyField=function(i,j){if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(i,false,false,j.keyField);}};
X.prototype._createAndUpdateAllKeyFields=function(){var i=this._oConditionsGrid.getContent();i.forEach(function(j){this._createAndUpdateValueFields(this._oConditionsGrid,j);this._changeOperationValueFields(this._oConditionsGrid,j);},this);};
X.prototype._createAndUpdateValueFields=function(i,j){var l=this._getCurrentKeyFieldItem(j.keyField);var n=function(j,p,w){var Z=p.getValue?p.getValue():"";var $=j.indexOfContent(p);j.removeContent(p);if(p._oSuggestProvider){p._oSuggestProvider.destroy();p._oSuggestProvider=null;}p.destroy();var _=this._aConditionsFields[w];p=this._createValueField(l,_,j);j[_["ID"]]=p;j.insertContent(p,$===-1?j.indexOfContent(j.operation)+1:$);var a1,b1;if(j.oType&&Z){try{a1=j.oType.parseValue(Z,"string");j.oType.validateValue(a1);b1=j.oType.formatValue(a1,"string");p.setValue(b1);}catch(c1){var d1=c1.message;this._makeFieldValid(p,false,d1);p.setValue(Z);}}};Q.proxy(n,this)(j,j.value1,5);Q.proxy(n,this)(j,j.value2,6);};
X.prototype._updateAllOperations=function(){var i=this._oConditionsGrid.getContent();i.forEach(function(j){this._updateOperationItems(this._oConditionsGrid,j);this._changeOperationValueFields(this._oConditionsGrid,j);},this);};
X.prototype._updateOperationItems=function(i,j){var l="";var n=this._getCurrentKeyFieldItem(j.keyField);var p=j.operation;var w=this._oTypeOperations["default"];var Z=p.getSelectedItem();if(n){if(n.type&&n.type!==""&&this._oTypeOperations[n.type]){l=n.type;w=this._oTypeOperations[l];}if(n.operations){w=n.operations;}}this._fillOperationListItems(p,w,l?"_"+l.toUpperCase()+"_":"");if(Z&&p.getItemByKey(Z.getKey())){p.setSelectedKey(Z.getKey());}else{p.setSelectedItem(p.getItems()[0]);}this._sConditionType="Filter";if(w[0]===Y.Ascending||w[0]===Y.Descending){this._sConditionType="Sort";}if(w[0]===Y.GroupAscending||w[0]===Y.GroupDescending){this._sConditionType="Group";}this._adjustValue1Span(j);};
X.prototype._updateKeyFieldItems=function(l,p,w,Z){var n=l.getContent().length;var i;var $={};if(!p){for(i=0;i<n;i++){var _=l.getContent()[i].keyField;var a1=_.getSelectedKey();if(a1!=null&&a1!==""){$[a1]=true;}}}for(i=0;i<n;i++){var _=l.getContent()[i].keyField;var b1=l.getContent()[i].select;var c1=_.getSelectedKey();var j=0;var d1=this._aKeyFields;if(_!==Z){if(w){j=d1.length-1;}else{_.destroyItems();}for(j;j<d1.length;j++){var e1=d1[j];if(e1.key==null||e1.key===""||!$[e1.key]||e1.key===c1){_.addItem(new L({key:e1.key,text:e1.text,tooltip:e1.tooltip?e1.tooltip:e1.text}));}}_.setEditable(_.getItems().length>1);}if(c1){_.setSelectedKey(c1);}else if(_.getItems().length>0){_.setSelectedItem(_.getItems()[0]);}if(!b1.getSelected()){this._aKeyFields.some(function(f1,g1){if(f1.isDefault){_.setSelectedItem(_.getItems()[g1]);return true;}if(!_.getSelectedItem()){if(f1.type!=="boolean"){_.setSelectedItem(_.getItems()[g1]);}}},this);}if(_.getSelectedItem()){_.setTooltip(_.getSelectedItem().getTooltip()||_.getSelectedItem().getText());}}};
X.prototype._changeOperationValueFields=function(i,j){var l=j.operation;var n=l.getSelectedKey();var p=j.value1;var w=j.value2;var Z=j.showIfGrouped;if(!n){return;}if(n===Y.BT){if(p.setPlaceholder&&p.getPlaceholder()!==this._sFromLabelText){p.setPlaceholder(this._sFromLabelText);}if(!p.getVisible()){p.setVisible(true);j.insertContent(p,j.getContent().length-1);}if(w.setPlaceholder&&w.getPlaceholder()!==this._sToLabelText){w.setPlaceholder(this._sToLabelText);}if(!w.getVisible()){w.setVisible(true);j.insertContent(w,j.getContent().length-1);}}else{if(n===Y.GroupAscending||n===Y.GroupDescending){if(p.getVisible()){p.setVisible(false);j.removeContent(p);}if(w.getVisible()){w.setVisible(false);j.removeContent(w);}if(l.getVisible()){l.setVisible(false);j.removeContent(l);}Z.setVisible(this._getMaxConditionsAsNumber()!=1);}else{if(n===Y.NotEmpty||n===Y.Empty||n===Y.Initial||n===Y.Ascending||n===Y.Descending||n===Y.Total||n===Y.Average||n===Y.Minimum||n===Y.Maximum){if(p.getVisible()){p.setVisible(false);j.removeContent(p);}if(w.getVisible()){w.setVisible(false);j.removeContent(w);}j.removeContent(Z);}else{if(p.setPlaceholder&&p.getPlaceholder()!==this._sValueLabelText){p.setPlaceholder(this._sValueLabelText);}if(!p.getVisible()){p.setVisible(true);j.insertContent(p,j.getContent().length-1);}if(w.getVisible()){w.setVisible(false);j.removeContent(w);}}}}this._adjustValue1Span(j);};
X.prototype._adjustValue1Span=function(i){if(this._sConditionType==="Filter"&&i.value1&&i.operation){var j=i.operation;var n=this._aConditionsFields[5]["Span"+this._sConditionType];if(j.getSelectedKey()!=="BT"){n="L5 M10 S10";}var l=i.value1.getLayoutData();if(l.getSpan()!==n){l.setSpan(n);}}};
X.prototype._getIndexOfCondition=function(i){var j=-1;i.getParent().getContent().some(function(l){if(l.select.getSelected()){j++;}return(l===i);},this);return j+this._iFirstConditionIndex;};
X.prototype._makeFieldValid=function(i,j,l){if(j){i.setValueState(V.None);i.setValueStateText("");}else{i.setValueState(V.Warning);i.setValueStateText(l?l:this._sValidationDialogFieldMessage);}};
X.prototype._validateAndFormatFieldValue=function(i){var j=i.oSource;var l=j.getParent();var n;if(j.getDateValue&&i){n=i.getParameter("value");var p=i.getParameter("valid");this._makeFieldValid(j,p);return;}else{n=j.getValue&&j.getValue();}if(!l){return;}if(this.getDisplayFormat()==="UpperCase"&&n){n=n.toUpperCase();j.setValue(n);}if(l.oType&&n){try{var w=l.oType.parseValue(n,"string");l.oType.validateValue(w);this._makeFieldValid(j,true);n=l.oType.formatValue(w,"string");j.setValue(n);}catch(Z){var $=Z.message;this._makeFieldValid(j,false,$);}}else{this._makeFieldValid(j,true);}};
X.prototype._updateMinMaxDate=function(i,j,l){if(i.value1.setMinDate&&i.value2.setMaxDate){if(i.value1&&i.value1.setMaxDate){i.value1.setMaxDate(l instanceof Date?l:null);}if(i.value2&&i.value2.setMinDate){i.value2.setMinDate(j instanceof Date?j:null);}}};
X.prototype._changeField=function(i,j){var l=i.keyField.getSelectedKey();if(i.keyField.getSelectedItem()){i.keyField.setTooltip(i.keyField.getSelectedItem().getTooltip()||i.keyField.getSelectedItem().getText());}else{i.keyField.setTooltip(null);}var n=i.operation.getSelectedKey();if(i.operation.getSelectedItem()){i.operation.setTooltip(i.operation.getSelectedItem().getTooltip()||i.operation.getSelectedItem().getText());}else{i.operation.setTooltip(null);}var p=function(j1,k1){var f1;var l1;if(j1.getDateValue&&!(j1.isA("sap.m.TimePicker"))&&k1.getName()!=="sap.ui.comp.odata.type.StringDate"){l1=j1.getDateValue();if(k1&&l1){f1=k1.formatValue(l1,"string");}}else{f1=this._getValueTextFromField(j1);l1=f1;if(k1&&k1.getName()==="sap.ui.comp.odata.type.StringDate"){f1=k1.formatValue(l1,"string");}else if(k1&&f1){try{l1=k1.parseValue(f1,"string");k1.validateValue(l1);}catch(m1){f1="";E.error("sap.m.P13nConditionPanel","not able to parse value "+f1+" with type "+k1.getName());}}}return[l1,f1];}.bind(this);var w=p(i.value1,i.oType);var Z=w[0],$=w[1];w=p(i.value2,i.oType);var _=w[0],a1=w[1];if(n==="BT"){this._updateMinMaxDate(i,Z,_);}else{this._updateMinMaxDate(i,null,null);}var b1=this._getCurrentKeyFieldItem(i.keyField);if(b1&&b1.type==="numc"){if([Y.Contains,Y.EndsWith].indexOf(n)!=-1){Z=i.oType.formatValue(Z,"string");}}var c1=i.showIfGrouped.getSelected();var d1=this.getExclude();var e1=i.select;var f1="";var g1;if(l===""||l==null){l=null;g1=this._getKeyFromConditionGrid(i);this._removeConditionFromMap(g1);this._enableCondition(i,false);var h1=this._getIndexOfCondition(i);if(e1.getSelected()){e1.setSelected(false);e1.setEnabled(false);this._bIgnoreSetConditions=true;this.fireDataChange({key:g1,index:h1,operation:"remove",newData:null});this._bIgnoreSetConditions=false;}return;}this._enableCondition(i,true);f1=this._getFormatedConditionText(n,$,a1,d1,l,c1);var i1={"value":f1,"exclude":d1,"operation":n,"keyField":l,"value1":Z,"value2":n===Y.BT?_:null,"showIfGrouped":c1};g1=this._getKeyFromConditionGrid(i);if(f1!==""){e1.setSelected(true);e1.setEnabled(true);var n="update";if(!this._oConditionsMap[g1]){n="add";}this._oConditionsMap[g1]=i1;if(n==="add"){this._aConditionKeys.splice(this._getIndexOfCondition(i),0,g1);}i.data("_key",g1);this.fireDataChange({key:g1,index:this._getIndexOfCondition(i),operation:n,newData:i1});}else if(this._oConditionsMap[g1]!==undefined){this._removeConditionFromMap(g1);i.data("_key",null);var h1=this._getIndexOfCondition(i);if(e1.getSelected()){e1.setSelected(false);e1.setEnabled(false);this._bIgnoreSetConditions=true;this.fireDataChange({key:g1,index:h1,operation:"remove",newData:null});this._bIgnoreSetConditions=false;}}this._updatePaginatorToolbar();};
X.prototype._getValueTextFromField=function(i){if(i instanceof u){return i.getSelectedItem()?i.getSelectedItem().getText():"";}return i.getValue();};
X.prototype._updateAllConditionsEnableStates=function(){var i=this._oConditionsGrid.getContent();i.forEach(function(j){var l=this._getCurrentKeyFieldItem(j.keyField);var n=l&&l.key!==undefined?l.key:l;var p=n!==""&&n!==null;this._enableCondition(j,p);},this);};
X.prototype._enableCondition=function(i,j){i.operation.setEnabled(j);i.value1.setEnabled(j);i.value2.setEnabled(j);i.showIfGrouped.setEnabled(j);};
X.prototype._removeCondition=function(i,j){var l=this._getKeyFromConditionGrid(j);var n=-1;if(j.select.getSelected()){n=this._getIndexOfCondition(j);}this._removeConditionFromMap(l);j.destroy();if(i.getContent().length<1){this._createConditionRow(i);}else{this._updateConditionButtons(i);}if(n>=0){this.fireDataChange({key:l,index:n,operation:"remove",newData:null});}};
X.prototype._updateConditionButtons=function(j){var l=this._getMaxConditionsAsNumber();var n=j.getContent().length;for(var i=0;i<n;i++){var p=j.getContent()[i].add;if((this.getAlwaysShowAddIcon()&&(n<l))||(i===n-1&&i<l-1)){p.removeStyleClass("displayNone");}else{p.addStyleClass("displayNone");}var w=j.getContent()[i].remove;if(l===1||(i===0&&n===1&&this.getDisableFirstRemoveIcon())){w.addStyleClass("displayNone");}else{w.removeStyleClass("displayNone");}}};
X.prototype.validateConditions=function(){var j=this;var l=function(n){var p=true;for(var i=0;i<n.length;i++){var w=n[i];var Z=j._checkCondition(w,i===n.length-1);p=p&&Z;}return p;};return l(this._oConditionsGrid.getContent());};
X.prototype.removeValidationErrors=function(){this._oConditionsGrid.getContent().forEach(function(i){var j=i.value1;var l=i.value2;j.setValueState(V.None);j.setValueStateText("");l.setValueState(V.None);l.setValueStateText("");},this);};
X.prototype.removeInvalidConditions=function(){var i=[];this._oConditionsGrid.getContent().forEach(function(j){if(j.value1.getValueState()!==V.None||j.value2.getValueState()!==V.None){i.push(j);}},this);i.forEach(function(j){this._removeCondition(this._oConditionsGrid,j);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(this._oConditionsGrid,false);}},this);};
X.prototype._checkCondition=function(i,j){var l=true;var n=i.value1;var p=i.value2;var w=n&&(n.getVisible()&&!this._getValueTextFromField(n));var Z=n&&n.getVisible()&&n.getValueState?n.getValueState():V.None;var $=p&&(p.getVisible()&&!this._getValueTextFromField(p));var _=p&&p.getVisible()&&p.getValueState?p.getValueState():V.None;var a1=i.operation.getSelectedKey();if(a1===Y.BT){if(!w?$:!$){if(w){n.setValueState(V.Warning);n.setValueStateText(this._sValidationDialogFieldMessage);}if($){p.setValueState(V.Warning);p.setValueStateText(this._sValidationDialogFieldMessage);}l=false;}else if(Z!==V.None||_!==V.None){l=false;}else{n.setValueState(V.None);n.setValueStateText("");p.setValueState(V.None);p.setValueStateText("");}}if((n.getVisible()&&n.getValueState&&n.getValueState()!==V.None)||(p.getVisible()&&p.getValueState&&p.getValueState()!==V.None)){l=false;}return l;};
X.prototype._getFormatedConditionText=function(j,l,n,p,w,Z){var $=X.getFormatedConditionText(j,l,n,p);if(!$){switch(j){case Y.Initial:$="=''";break;case Y.NotEmpty:$="!''";break;case Y.Ascending:$="ascending";break;case Y.GroupAscending:$="ascending";$+=" showIfGrouped:"+Z;break;case Y.Descending:$="descending";break;case Y.GroupDescending:$="descending";$+=" showIfGrouped:"+Z;break;case Y.Total:$="total";break;case Y.Average:$="average";break;case Y.Minimum:$="minimum";break;case Y.Maximum:$="maximum";break;}if(p&&$!==""){$="!("+$+")";}}if(this._aKeyFields&&this._aKeyFields.length>1){var _=null;for(var i=0;i<this._aKeyFields.length;i++){var a1=this._aKeyFields[i];if(typeof a1!=="string"){if(a1.key===w&&a1.text){_=a1.text;}}}if(_&&$!==""){$=_+": "+$;}}return $;};
var Y=sap.m.P13nConditionOperation={BT:"BT",EQ:"EQ",Contains:"Contains",StartsWith:"StartsWith",EndsWith:"EndsWith",LT:"LT",LE:"LE",GT:"GT",GE:"GE",Initial:"Initial",Empty:"Empty",NotEmpty:"NotEmpty",Ascending:"Ascending",Descending:"Descending",GroupAscending:"GroupAscending",GroupDescending:"GroupDescending",Total:"Total",Average:"Average",Minimum:"Minimum",Maximum:"Maximum"};X._oConditionMap={"EQ":"=$0","GT":">$0","GE":">=$0","LT":"<$0","LE":"<=$0","Contains":"*$0*","StartsWith":"$0*","EndsWith":"*$0","BT":"$0...$1","Empty":"<$r>"};(function(){var _=sap.ui.getCore().getLibraryResourceBundle("sap.m");X._oConditionMap[Y.Empty]=X._oConditionMap[Y.Empty].replace("$r",_.getText("CONDITIONPANEL_OPTIONEmpty"));})();
X._templateReplace=function(i,j){return i.replace(/\$\d/g,function(l){return j[parseInt(l.substr(1))];});};
X.getFormatedConditionText=function(i,j,l,n){var p="";switch(i){case Y.Empty:p=X._templateReplace(X._oConditionMap[i],[]);break;case Y.EQ:case Y.GT:case Y.GE:case Y.LT:case Y.LE:case Y.Contains:case Y.StartsWith:case Y.EndsWith:if(j!==""&&j!==undefined){p=X._templateReplace(X._oConditionMap[i],[j]);}break;case Y.BT:if(j!==""&&j!==undefined){if(l!==""&&l!==undefined){p=X._templateReplace(X._oConditionMap[i],[j,l]);}}break;default:break;}if(n&&p!==""){p="!("+p+")";}return p;};
X.prototype._updateLayout=function(j){if(!this._oConditionsGrid){return;}var l=this._oConditionsGrid.getContent();var n=this._aConditionsFields.length;var p=n;if(j.name==="Tablet"){p=5;}if(j.name==="Phone"){p=3;}if(this._sConditionType==="Filter"){for(var i=0;i<l.length;i++){var w=l[i];w.ButtonContainer.removeStyleClass("floatRight");w.removeContent(w.ButtonContainer);w.insertContent(w.ButtonContainer,p);if(!this.getAlwaysShowAddIcon()){if(p!==n){w.ButtonContainer.removeContent(w.add);w.addContent(w.add);}else{w.removeContent(w.add);w.ButtonContainer.addContent(w.add);}}}}};
X.prototype._onGridResize=function(){if(this._oPaginatorToolbar&&this._oConditionsGrid&&this._oConditionsGrid.getContent().length>0){var i=this._oConditionsGrid.getContent()[0];if(i.remove&&i.remove.$().position()){var w=0;if(this._oPaginatorToolbar.getParent()&&this._oPaginatorToolbar.getParent().getExpandable&&this._oPaginatorToolbar.getParent().getExpandable()){w=48-4;}var j=i.remove.$().position().left-w+i.remove.$().width();this._oPaginatorToolbar.setWidth(j+"px");}}var l=this._oConditionsGrid.getDomRef();if(!l){return;}if(!Q(l).is(":visible")){return;}var w=l.clientWidth;var n={};if(w<=this._iBreakPointTablet){n.name="Phone";}else if((w>this._iBreakPointTablet)&&(w<=this._iBreakPointDesktop)){n.name="Tablet";}else{n.name="Desktop";}if(n.name==="Phone"&&this._sLayoutMode!==n.name){this._updateLayout(n);this._sLayoutMode=n.name;}if(n.name==="Tablet"&&this._sLayoutMode!==n.name){this._updateLayout(n);this._sLayoutMode=n.name;}if(n.name==="Desktop"&&this._sLayoutMode!==n.name){this._updateLayout(n);this._sLayoutMode=n.name;}};
X.prototype._findConfig=function(i,j){if(typeof i==="object"){i=i.getMetadata().getName();}var l;while(i&&!(l=this._getConfig(i,j))){i=this._getParentType(i);}return l;};
X.prototype._getConfig=function(i,j){var l=this._mOpsForType[i];if(l){return l[j];}};
X.prototype._getParentType=function(i){return this._mTypes[i];};
X.prototype._mTypes={"base":undefined,"string":"base","numeric":"base","date":"base","time":"base","boolean":"base","int":"numeric","float":"numeric","sap.ui.model.type.Boolean":"boolean","sap.ui.model.type.Date":"date","sap.ui.model.type.FileSize":"string","sap.ui.model.type.Float":"float","sap.ui.model.type.Integer":"int","sap.ui.model.type.String":"string","sap.ui.model.type.Time":"time","sap.ui.comp.odata.type.StringDate":"date","sap.ui.model.odata.type.Boolean":"boolean","sap.ui.model.odata.type.Byte":"int","sap.ui.model.odata.type.Date":"date","sap.ui.model.odata.type.DateTime":"datetime","sap.ui.model.odata.type.DateTimeOffset":"datetime","sap.ui.model.odata.type.Decimal":"float","sap.ui.model.odata.type.Double":"float","sap.ui.model.odata.type.Single":"float","sap.ui.model.odata.type.Guid":"string","sap.ui.model.odata.type.Int16":"int","sap.ui.model.odata.type.Int32":"int","sap.ui.model.odata.type.Int64":"int","sap.ui.model.odata.type.Raw":"string","sap.ui.model.odata.type.SByte":"int","sap.ui.model.odata.type.String":"string","sap.ui.model.odata.type.Time":"time","sap.ui.model.odata.type.TimeOfDay":"time","Edm.Boolean":"sap.ui.model.odata.type.Boolean","Edm.Byte":"sap.ui.model.odata.type.Byte","Edm.Date":"sap.ui.model.odata.type.Date","Edm.DateTime":"sap.ui.model.odata.type.DateTime","Edm.DateTimeOffset":"sap.ui.model.odata.type.DateTimeOffset","Edm.Decimal":"sap.ui.model.odata.type.Decimal","Edm.Double":"sap.ui.model.odata.type.Double","Edm.Single":"sap.ui.model.odata.type.Single","Edm.Guid":"sap.ui.model.odata.type.Guid","Edm.Int16":"sap.ui.model.odata.type.Int16","Edm.Int32":"sap.ui.model.odata.type.Int32","Edm.Int64":"sap.ui.model.odata.type.Int64","Edm.SByte":"sap.ui.model.odata.type.SByte","Edm.String":"sap.ui.model.odata.type.String","Edm.Time":"sap.ui.model.odata.type.Time","Edm.TimeOfDay":"sap.ui.model.odata.type.TimeOfDay"};X.prototype._mOpsForType={"base":{ctrl:"input"},"string":{ctrl:"input"},"date":{ctrl:"DatePicker"},"datetime":{ctrl:"DateTimePicker"},"numeric":{ctrl:"input"},"time":{ctrl:"TimePicker"},"boolean":{ctrl:"select"}};return X;});
sap.ui.predefine('sap/m/P13nDialog',['./Dialog','./library','sap/ui/core/EnabledPropagator','./DialogRenderer','sap/ui/core/library','sap/ui/Device','./Bar','./Button','./Title','sap/m/OverflowToolbarLayoutData','sap/ui/base/ManagedObjectObserver',"sap/ui/thirdparty/jquery","sap/base/Log"],function(D,l,E,a,c,b,B,d,T,O,M,q,L){"use strict";var e=l.OverflowToolbarPriority;var f=l.ListType;var P=l.P13nPanelType;var g=l.ListMode;var h=c.MessageType;var j=l.ButtonType;var N;var k;
var m=D.extend("sap.m.P13nDialog",{
metadata:{library:"sap.m",properties:{initialVisiblePanelType:{type:"string",group:"Misc",defaultValue:null},showReset:{type:"boolean",group:"Appearance",defaultValue:false},showResetEnabled:{type:"boolean",group:"Appearance",defaultValue:false},validationExecutor:{type:"object",group:"Misc",defaultValue:null}},aggregations:{panels:{type:"sap.m.P13nPanel",multiple:true,singularName:"panel",bindable:"bindable"}},events:{ok:{},cancel:{},reset:{}}},
renderer:function(r,C){a.render.apply(this,arguments);var i=C._getVisiblePanelID();var p=C.getVisiblePanel();if(i&&p){r.write("<div");r.writeAttribute("id",i);r.write(">");r.renderControl(p);r.write("</div>");}}
});
E.apply(m.prototype,[true]);
m.prototype.init=function(o){this.addStyleClass("sapMP13nDialog");D.prototype.init.apply(this,arguments);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._mValidationListener={};this._createDialog();this._mVisibleNavigationItems={};this._bNavigationControlsPromiseResolved=false;this._oNavigationControlsPromise=this._requestRequiredNavigationControls();this._oObserver=new M(_.bind(this));this._oObserver.observe(this,{properties:["showReset","showResetEnabled"],aggregations:["panels"]});};
m.prototype.setShowResetEnabled=function(i){return this.setProperty("showResetEnabled",i,true);};
m.prototype._createDialog=function(){if(b.system.phone){var t=this;this.setStretch(true);this.setVerticalScrolling(false);this.setHorizontalScrolling(false);this.setCustomHeader(new B(this.getId()+"-phoneHeader",{contentLeft:new d(this.getId()+"-backToList",{visible:false,type:j.Back,press:function(){t._backToList();}}),contentMiddle:new T(this.getId()+"-phoneTitle",{text:this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS"),level:"H2"})}));this.addButton(this._createOKButton());this.addButton(this._createCancelButton());this.addButton(this._createResetButton());}else{this.setHorizontalScrolling(false);this.setContentWidth("65rem");this.setContentHeight("40rem");this.setDraggable(true);this.setResizable(true);this.setTitle(this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS"));this.addButton(this._createOKButton());this.addButton(this._createCancelButton());this.addButton(this._createResetButton());}};
m.prototype._showValidationDialog=function(C,F,v){var w=[];var i=[];this._prepareMessages(F,v,w,i);var t=this;return new Promise(function(r){sap.ui.require(["sap/m/MessageBox"],function(n){var s="";if(i.length){i.forEach(function(o,I,p){s=(p.length>1?"• ":"")+o.messageText+"\n"+s;});n.show(s,{icon:n.Icon.ERROR,title:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_TITLE_ERROR"),actions:[n.Action.CLOSE],styleClass:t.$().closest(".sapUiSizeCompact").length?"sapUiSizeCompact":""});}else if(w.length){w.forEach(function(o,I,p){s=(p.length>1?"• ":"")+o.messageText+"\n"+s;});s=s+sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_MESSAGE_QUESTION");n.show(s,{icon:n.Icon.WARNING,title:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_TITLE"),actions:[sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_FIX"),n.Action.IGNORE],onClose:function(A){if(A===n.Action.IGNORE){C();}},styleClass:t.$().closest(".sapUiSizeCompact").length?"sapUiSizeCompact":""});}r();});});};
m.prototype._prepareMessages=function(F,v,w,n){if(!F.length&&!v.length){return;}F.forEach(function(p){switch(p){case P.filter:v.push({messageType:h.Warning,messageText:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_MESSAGE")});break;case P.columns:v.push({messageType:h.Warning,messageText:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VISIBLE_ITEMS_THRESHOLD_MESSAGE")});break;default:L.error("Panel type '"+p+"' is not supported jet.");}});var u=v.filter(function(o,I,p){for(var i=++I;i<p.length;i++){if(o.messageText===p[i].messageText){return false;}}return true;});u.forEach(function(o){if(o.messageType===h.Warning){w.push(o);}else if(o.messageType===h.Error){n.push(o);}});};
m.prototype._mapPanelToNavigationItem=function(p){if(!p){return null;}return b.system.phone?new k(p.getId()+"-navItem",{type:f.Navigation,title:p.getTitle()}):new k(p.getId()+"-navItem",{text:p.getTitle()});};
m.prototype._switchPanel=function(n){var p=this._getPanelByNavigationItem(n);this.setVerticalScrolling(p.getVerticalScrolling());if(b.system.phone){var o=this._getNavigationControl();if(o){o.setVisible(false);p.beforeNavigationTo();p.setVisible(true);this.getCustomHeader().getContentMiddle()[0].setText(p.getTitle());this.getCustomHeader().getContentLeft()[0].setVisible(true);}}else{this.getPanels().forEach(function(i){if(i===p){i.beforeNavigationTo();i.setVisible(true);}else{i.setVisible(false);}},this);}this.invalidate();this.rerender();};
m.prototype._backToList=function(){var n=this._getNavigationControl();if(n){n.setVisible(true);var p=this.getVisiblePanel();p.setVisible(false);this._updateDialogTitle();this.getCustomHeader().getContentLeft()[0].setVisible(false);}};
m.prototype.getVisiblePanel=function(){var p=null;this.getPanels().some(function(o){if(o.getVisible()){p=o;return true;}});return p;};
m.prototype._getVisiblePanelID=function(){var p=this.getVisiblePanel();if(p){return this.getId()+"-panel_"+p.getId();}return null;};
m.prototype._getPanelByNavigationItem=function(n){for(var i=0,p=this.getPanels(),o=p.length;i<o;i++){if(this._getNavigationItemByPanel(p[i])===n){return p[i];}}return null;};
m.prototype._getNavigationItemByPanel=function(p){return p?p.data("sapMP13nDialogNavigationItem"):null;};
m.prototype.onAfterRendering=function(){D.prototype.onAfterRendering.apply(this,arguments);var C=q(this.getFocusDomRef()).find(".sapMDialogScrollCont");var i=this._getVisiblePanelID();if(i&&C){var p=q(document.getElementById(i));p.appendTo(q(C));}};
m.prototype._updateDialogTitle=function(){var p=this.getVisiblePanel();var t=this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS");if(!this._isNavigationControlExpected()&&p){switch(p.getType()){case P.filter:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_FILTER");break;case P.sort:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_SORT");break;case P.group:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_GROUP");break;case P.columns:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_COLUMNS");break;case P.dimeasure:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_DIMEASURE");break;default:t=p.getTitleLarge()||this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS");}}if(b.system.phone){this.getCustomHeader().getContentMiddle()[0].setText(t);}else{this.setTitle(t);}};
m.prototype._registerValidationListener=function(p,C){if(this.getPanels().indexOf(p)&&C&&this._mValidationListener[p.getType()]===undefined){this._mValidationListener[p.getType()]=C;}};
m.prototype._callValidationExecutor=function(){var v=this.getValidationExecutor();if(v&&!q.isEmptyObject(this._mValidationListener)){var t=this;v(this._getPayloadOfPanels()).then(function(V){var r=t._distributeValidationResult(V);for(var s in t._mValidationListener){var C=t._mValidationListener[s];C(r[s]||[]);}});}};
m.prototype._distributeValidationResult=function(r){var o={};r.forEach(function(R){R.panelTypes.forEach(function(t){if(o[t]===undefined){o[t]=[];}o[t].push({columnKey:R.columnKey,messageType:R.messageType,messageText:R.messageText});});});return o;};
m.prototype._createOKButton=function(){var t=this;return new d(this.getId()+"-ok",{type:j.Emphasized,text:this._oResourceBundle.getText("P13NDIALOG_OK"),layoutData:new O({priority:e.NeverOverflow}),press:function(){t.setBusy(true);var p=t._getPayloadOfPanels();var F=function(){t.setBusy(false);t.fireOk({payload:p});};var i=[];var C=function(){t.getPanels().forEach(function(o){if(i.indexOf(o.getType())>-1){o.onAfterNavigationFrom();}});F();};t.getPanels().forEach(function(o){if(!o.onBeforeNavigationFrom()){i.push(o.getType());}});var v=[];var V=t.getValidationExecutor();if(V){V(p).then(function(v){if(i.length||v.length){t.setBusy(false);t._showValidationDialog(C,i,v);}else{F();}});}else{if(i.length||v.length){t.setBusy(false);t._showValidationDialog(C,i,v);}else{F();}}}});};
m.prototype._createCancelButton=function(){var t=this;return new d(this.getId()+"-cancel",{text:this._oResourceBundle.getText("P13NDIALOG_CANCEL"),layoutData:new O({priority:e.NeverOverflow}),press:function(){t.fireCancel();}});};
m.prototype._createResetButton=function(){var t=this;return new d(this.getId()+"-reset",{text:this._oResourceBundle.getText("P13NDIALOG_RESET"),layoutData:new O({priority:e.NeverOverflow}),visible:this.getShowReset(),enabled:this.getShowResetEnabled(),press:function(){t.setShowResetEnabled(false);var p={};t.getPanels().forEach(function(o){p[o.getType()]=o.getResetPayload();});t.fireReset({payload:p});}});};
m.prototype._getPayloadOfPanels=function(){var p={};this.getPanels().forEach(function(o){p[o.getType()]=o.getOkPayload();});return p;};
m.prototype.exit=function(){D.prototype.exit.apply(this,arguments);this._oObserver.disconnect();this._oObserver=undefined;this._mValidationListener={};this._mVisibleNavigationItems={};this._oNavigationControlsPromise=null;};
m.prototype._isInstanceOf=function(o,s){var C=sap.ui.require(s);return o&&typeof C==='function'&&(o instanceof C);};
function _(C){if(this._isInstanceOf(C.object,"sap/m/P13nDialog")){var i;switch(C.name){case"panels":var p=C.child?[C.child]:C.children;p.forEach(function(o){switch(C.mutation){case"insert":this._mVisibleNavigationItems[o.getType()]=o.getVisible();o.setVisible(false);o.beforeNavigationTo();this._oObserver.observe(o,{properties:["title"]});o.setValidationExecutor(q.proxy(this._callValidationExecutor,this));o.setValidationListener(q.proxy(this._registerValidationListener,this));break;case"remove":delete this._mVisibleNavigationItems[o.getType()];this._oObserver.unobserve(o);o.setValidationExecutor();o.setValidationListener();break;default:L.error("Mutation '"+C.mutation+"' is not supported jet.");}},this);if(this._bNavigationControlsPromiseResolved){this._updateDialog();}else{this._oNavigationControlsPromise.then(function(){this._updateDialog();}.bind(this));}break;case"showReset":i=this.getButtons();if(i.length>1){i[2].setVisible(C.current);}break;case"showResetEnabled":i=this.getButtons();if(i.length>1){i[2].setEnabled(C.current);i[2].invalidate();}break;default:L.error("The property or aggregation '"+C.name+"' has not been registered.");}}else if(this._isInstanceOf(C.object,"sap/m/P13nPanel")){if(C.name==="title"){var I=this._getNavigationItemByPanel(C.object);if(I){if(b.system.phone){I.setTitle(C.current);}else{I.setText(C.current);}}}}}
m.prototype._isNavigationControlExpected=function(){return this._getCountOfVisibleNavigationItems()>1;};
m.prototype._getCountOfVisibleNavigationItems=function(){var C=0;for(var t in this._mVisibleNavigationItems){C=this._mVisibleNavigationItems[t]?C+1:C;}return C;};
m.prototype._isNavigationControlExists=function(){return b.system.phone?this.getContent().length>0:(!!this.getSubHeader()&&this.getSubHeader().getContentLeft().length>0);};
m.prototype._getNavigationControl=function(){if(!this._isNavigationControlExists()){this._createNavigationControl();}return b.system.phone?this.getContent()[0]:this.getSubHeader().getContentLeft()[0];};
m.prototype._setVisibleOfNavigationControl=function(v){if(!this._isNavigationControlExists()){return;}return b.system.phone?this.getContent()[0].setVisible(v):this.getSubHeader().setVisible(v);};
m.prototype._createNavigationControl=function(){if(b.system.phone){this.addContent(new N(this.getId()+"-navigationItems",{mode:g.None,itemPress:function(o){this._switchPanel(o.getParameter("listItem"));}.bind(this)}));}else{this.setSubHeader(new B(this.getId()+"-navigationBar",{contentLeft:new N(this.getId()+"-navigationItems",{width:'100%',selectionChange:function(o){this._switchPanel(o.getParameter("item"));}.bind(this)})}));}return this._getNavigationControl();};
m.prototype._updateDialog=function(){var n=this._getNavigationControl();n.destroyItems();var i=this._determineInitialVisiblePanelType();this.getPanels().forEach(function(p){var o=this._mapPanelToNavigationItem(p);p.data("sapMP13nDialogNavigationItem",o);n.addItem(o);var v=b.system.phone?this._mVisibleNavigationItems[p.getType()]&&this._getCountOfVisibleNavigationItems()===1:this._mVisibleNavigationItems[p.getType()]&&i===p.getType();p.setVisible(v);if(v){if(!b.system.phone){this.setVerticalScrolling(p.getVerticalScrolling());}}o.setVisible(this._mVisibleNavigationItems[p.getType()]);if(v&&n.setSelectedItem){n.setSelectedItem(o);}}.bind(this));this._updateDialogTitle();this._setVisibleOfNavigationControl(this._isNavigationControlExpected());};
m.prototype._determineInitialVisiblePanelType=function(){if(this.getInitialVisiblePanelType()&&this._mVisibleNavigationItems[this.getInitialVisiblePanelType()]){return this.getInitialVisiblePanelType();}var t;this.getPanels().some(function(p){if(this._mVisibleNavigationItems[p.getType()]){t=p.getType();return true;}}.bind(this));return t;};
m.prototype._requestRequiredNavigationControls=function(){var n=b.system.phone?"sap/m/List":"sap/m/SegmentedButton";var s=b.system.phone?"sap/m/StandardListItem":"sap/m/SegmentedButtonItem";N=sap.ui.require(n);k=sap.ui.require(s);if(N&&k){this._bNavigationControlsPromiseResolved=true;return Promise.resolve();}if(!this._oNavigationControlsPromise){this._oNavigationControlsPromise=new Promise(function(r){sap.ui.require([n,s],function(i,o){N=i;k=o;this._bNavigationControlsPromiseResolved=true;return r();}.bind(this));}.bind(this));}return this._oNavigationControlsPromise;};
return m;});
sap.ui.predefine('sap/m/P13nDimMeasureItem',['./library','sap/ui/core/Item'],function(l,I){"use strict";
var P=I.extend("sap.m.P13nDimMeasureItem",{metadata:{library:"sap.m",properties:{columnKey:{type:"string"},index:{type:"int",defaultValue:-1},visible:{type:"boolean"},role:{type:"string"}}}});
return P;});
sap.ui.predefine('sap/m/P13nDimMeasurePanel',['./library','./P13nPanel','./P13nDimMeasureItem','./SearchField','./Table','./Column','./ColumnListItem','./ScrollContainer','./Text','./Select','./ComboBox','./Button','./OverflowToolbar','./OverflowToolbarLayoutData','./OverflowToolbarButton','./ToolbarSpacer','sap/ui/core/library','sap/ui/model/ChangeReason','sap/ui/model/json/JSONModel','sap/ui/model/BindingMode','sap/ui/core/ResizeHandler','sap/ui/core/Item','sap/ui/core/InvisibleText','sap/ui/core/IconPool',"sap/ui/thirdparty/jquery"],function(l,P,c,S,T,C,d,e,f,g,h,B,O,i,j,k,m,n,J,o,R,I,p,q,Q){"use strict";var r=l.OverflowToolbarPriority;var s=l.ButtonType;var t=l.ToolbarDesign;var L=l.ListType;var u=l.ListMode;var v=l.P13nPanelType;
var w=P.extend("sap.m.P13nDimMeasurePanel",{
metadata:{library:"sap.m",properties:{chartTypeKey:{type:"string",defaultValue:""}},aggregations:{dimMeasureItems:{type:"sap.m.P13nDimMeasureItem",multiple:true,singularName:"dimMeasureItem",bindable:"bindable"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},availableChartTypes:{type:"sap.ui.core.Item",multiple:true,singularName:"availableChartType"}},events:{changeDimMeasureItems:{},changeChartType:{}}},
renderer:function(a,b){a.write("<div");a.writeControlData(b);a.addClass("sapMP13nColumnsPanel");a.writeClasses();a.write(">");var x=b.getAggregation("content");if(x){x.forEach(function(y){a.renderControl(y);});}a.write("</div>");}
});
w.prototype.init=function(){var a=this;this._iLiveChangeTimer=0;this._iSearchTimer=0;this._bIgnoreUpdateInternalModel=false;this._bUpdateInternalModel=true;this._bOnAfterRenderingFirstTimeExecuted=false;var b=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.oAvailableRoleTypes={Dimension:[{key:"category",text:b.getText('COLUMNSPANEL_CHARTROLE_CATEGORY')},{key:"category2",text:b.getText('COLUMNSPANEL_CHARTROLE_CATEGORY2')},{key:"series",text:b.getText('COLUMNSPANEL_CHARTROLE_SERIES')}],Measure:[{key:"axis1",text:b.getText('COLUMNSPANEL_CHARTROLE_AXIS1')},{key:"axis2",text:b.getText('COLUMNSPANEL_CHARTROLE_AXIS2')},{key:"axis3",text:b.getText('COLUMNSPANEL_CHARTROLE_AXIS3')},{key:"axis4",text:b.getText('COLUMNSPANEL_CHARTROLE_AXIS4')}]};var M=new J({availableChartTypes:[],selectedChartTypeKey:null,items:[],columnKeyOfMarkedItem:undefined,isMoveDownButtonEnabled:undefined,isMoveUpButtonEnabled:undefined,showOnlySelectedItems:undefined,countOfSelectedItems:0,countOfItems:0});M.setDefaultBindingMode(o.TwoWay);M.setSizeLimit(1000);this.setModel(M,"$sapmP13nDimMeasurePanel");this.setType(v.dimeasure);this.setTitle(b.getText("CHARTPANEL_TITLE"));this._createTable();this._createToolbar();this.setVerticalScrolling(false);var x=new e({horizontal:false,vertical:true,content:[this._oTable],width:'100%',height:'100%'});this.addAggregation("content",x);this._fnHandleResize=function(){var y=false,z,A;if(a.getParent){var $=null,D,H;var E=a.getParent();var F=a._getToolbar();if(E&&E.$){$=E.$("cont");if($.children().length>0&&F.$().length>0){z=x.$()[0].clientHeight;D=$.children()[0].clientHeight;H=F?F.$()[0].clientHeight:0;A=D-H;if(z!==A){x.setHeight(A+'px');y=true;}}}}return y;};this._sContainerResizeListener=R.register(x,this._fnHandleResize);};
w.prototype.onBeforeRendering=function(){this._updateInternalModel();if(!this._getInternalModel().getProperty("/columnKeyOfMarkedItem")){this._setColumnKeyOfMarkedItem(this._getColumnKeyByTableItem(this._getVisibleTableItems()[0]));}this._switchMarkedTableItemTo(this._getTableItemByColumnKey(this._getInternalModel().getProperty("/columnKeyOfMarkedItem")));this._updateControlLogic();};
w.prototype.onAfterRendering=function(){var a=this;if(!this._bOnAfterRenderingFirstTimeExecuted){this._bOnAfterRenderingFirstTimeExecuted=true;window.clearTimeout(this._iLiveChangeTimer);this._iLiveChangeTimer=window.setTimeout(function(){a._fnHandleResize();a._getToolbar()._resetAndInvalidateToolbar();},0);}};
w.prototype.getOkPayload=function(){this._updateInternalModel();this._getInternalModel().getProperty("/items").forEach(function(M){if(this._getDimMeasureItemByColumnKey(M.columnKey)){return;}if(!M.persistentSelected){return;}this.addAggregation("dimMeasureItems",new c({columnKey:M.columnKey,visible:M.persistentSelected,index:M.persistentIndex===-1?undefined:M.persistentIndex,role:M.role}));},this);return{dimMeasureItems:this.getDimMeasureItems(),chartTypeKey:this.getChartTypeKey()};};
w.prototype.exit=function(){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;this._getToolbar().destroy();this._oTable.destroy();this._oTable=null;if(this._getInternalModel()){this._getInternalModel().destroy();}if(this.oInvisibleChartTypeText){this.oInvisibleChartTypeText.destroy();this.oInvisibleChartTypeText=null;}window.clearTimeout(this._iLiveChangeTimer);window.clearTimeout(this._iSearchTimer);};
w.prototype.addItem=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("items",a);return this;};
w.prototype.insertItem=function(a,b){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("items",a,b);return this;};
w.prototype.removeItem=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}a=this.removeAggregation("items",a);return a;};
w.prototype.removeAllItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("items");};
w.prototype.destroyItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("items");return this;};
w.prototype.addDimMeasureItem=function(D){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("dimMeasureItems",D);return this;};
w.prototype.insertDimMeasureItem=function(D,a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("dimMeasureItems",D,a);return this;};
w.prototype.updateDimMeasureItems=function(a){this.updateAggregation("dimMeasureItems");if(a===n.Change&&!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}};
w.prototype.removeDimMeasureItem=function(D){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAggregation("dimMeasureItems",D);};
w.prototype.removeAllDimMeasureItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("dimMeasureItems");};
w.prototype.destroyDimMeasureItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("dimMeasureItems");return this;};
w.prototype.setChartTypeKey=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.setProperty("chartTypeKey",a);return this;};
w.prototype.addAvailableChartType=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("availableChartTypes",a);return this;};
w.prototype.insertAvailableChartType=function(a,b){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("availableChartTypes",a,b);return this;};
w.prototype.removeAvailableChartType=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAggregation("availableChartTypes",a);};
w.prototype.removeAllAvailableChartType=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("availableChartTypes");};
w.prototype.destroyAvailableChartType=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("availableChartTypes");return this;};
w.prototype._notifyChange=function(){var a=this.getChangeNotifier();if(a){a(this);}};
w.prototype._scrollToSelectedItem=function(a){if(!a){return;}sap.ui.getCore().applyChanges();if(!!a.getDomRef()){a.focus();}};
w.prototype._getInternalModel=function(){return this.getModel("$sapmP13nDimMeasurePanel");};
w.prototype._createTable=function(){var a=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oTable=new T({mode:u.MultiSelect,rememberSelections:false,itemPress:Q.proxy(this._onItemPressed,this),selectionChange:Q.proxy(this._onSelectionChange,this),columns:[new C({vAlign:m.VerticalAlign.Middle,header:new f({text:{parts:[{path:'/countOfSelectedItems'},{path:'/countOfItems'}],formatter:function(b,x){return a.getText('COLUMNSPANEL_SELECT_ALL_WITH_COUNTER',[b,x]);}}})}),new C({vAlign:m.VerticalAlign.Middle,header:new f({text:a.getText('COLUMNSPANEL_COLUMN_TYPE')})}),new C({vAlign:m.VerticalAlign.Middle,header:new f({text:a.getText('COLUMNSPANEL_COLUMN_ROLE')})})],items:{path:"/items",templateShareable:false,template:new d({cells:[new f({text:"{text}"}),new f({text:{path:'',formatter:function(M){if(M.aggregationRole==="Dimension"){return a.getText('COLUMNSPANEL_TYPE_DIMENSION');}if(M.aggregationRole==="Measure"){return a.getText('COLUMNSPANEL_TYPE_MEASURE');}}}}),new g({selectedKey:"{role}",items:{path:'availableRoleTypes',factory:function(b,x){var A=x.getObject();return new I({key:A.key,text:A.text});}},change:Q.proxy(this._onRoleChange,this)})],visible:"{visible}",selected:"{persistentSelected}",tooltip:"{tooltip}",type:L.Active})}});this._oTable.setModel(this._getInternalModel());};
w.prototype._createToolbar=function(){var a=this;var b=sap.ui.getCore().getLibraryResourceBundle("sap.m");var x=new p({text:b.getText('COLUMNSPANEL_CHARTTYPE')});this.oInvisibleChartTypeText=x;var y=new h({placeholder:x.getText(),selectedKey:{path:'/selectedChartTypeKey'},ariaLabelledBy:x,items:{path:'/availableChartTypes',templateShareable:false,template:new I({key:"{key}",text:"{text}"})},selectionChange:Q.proxy(this._onChartTypeChange,this),layoutData:new i({moveToOverflow:false,stayInOverflow:false})});var z=new O(this.getId()+"-toolbar",{design:t.Auto,content:[x,y,new k(),new S(this.getId()+"-searchField",{liveChange:function(E){var V=E.getSource().getValue(),D=(V?300:0);window.clearTimeout(a._iSearchTimer);if(D){a._iSearchTimer=window.setTimeout(function(){a._onExecuteSearch();},D);}else{a._onExecuteSearch();}},search:Q.proxy(this._onExecuteSearch,this),layoutData:new i({minWidth:"12.5rem",maxWidth:"23.077rem",shrinkable:true,moveToOverflow:false,stayInOverflow:false})}),new B({text:{path:'/showOnlySelectedItems',formatter:function(A){return A?b.getText('COLUMNSPANEL_SHOW_ALL'):b.getText('COLUMNSPANEL_SHOW_SELECTED');}},tooltip:{path:'/showOnlySelectedItems',formatter:function(A){return A?b.getText('COLUMNSPANEL_SHOW_ALL'):b.getText('COLUMNSPANEL_SHOW_SELECTED');}},type:s.Transparent,press:Q.proxy(this._onSwitchButtonShowSelected,this),layoutData:new i({moveToOverflow:true,priority:r.High})}),new j({icon:q.getIconURI("collapse-group"),text:b.getText('COLUMNSPANEL_MOVE_TO_TOP'),tooltip:b.getText('COLUMNSPANEL_MOVE_TO_TOP'),type:s.Transparent,enabled:{path:'/isMoveUpButtonEnabled'},press:Q.proxy(this.onPressButtonMoveToTop,this),layoutData:new i({moveToOverflow:true,priority:r.Low,group:2})}),new j({icon:q.getIconURI("slim-arrow-up"),text:b.getText('COLUMNSPANEL_MOVE_UP'),tooltip:b.getText('COLUMNSPANEL_MOVE_UP'),type:s.Transparent,enabled:{path:'/isMoveUpButtonEnabled'},press:Q.proxy(this.onPressButtonMoveUp,this),layoutData:new i({moveToOverflow:true,priority:r.High,group:1})}),new j({icon:q.getIconURI("slim-arrow-down"),text:b.getText('COLUMNSPANEL_MOVE_DOWN'),tooltip:b.getText('COLUMNSPANEL_MOVE_DOWN'),type:s.Transparent,enabled:{path:'/isMoveDownButtonEnabled'},press:Q.proxy(this.onPressButtonMoveDown,this),layoutData:new i({moveToOverflow:true,priority:r.High,group:1})}),new j({icon:q.getIconURI("expand-group"),text:b.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),tooltip:b.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),type:s.Transparent,enabled:{path:'/isMoveDownButtonEnabled'},press:Q.proxy(this.onPressButtonMoveToBottom,this),layoutData:new i({moveToOverflow:true,priority:r.Low,group:2})})]});z.setModel(this._getInternalModel());this.addAggregation("content",z);};
w.prototype.onPressButtonMoveToTop=function(){this._moveMarkedTableItem(this._getMarkedTableItem(),this._getVisibleTableItems()[0]);};
w.prototype.onPressButtonMoveUp=function(){var V=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),V[V.indexOf(this._getMarkedTableItem())-1]);};
w.prototype.onPressButtonMoveDown=function(){var V=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),V[V.indexOf(this._getMarkedTableItem())+1]);};
w.prototype.onPressButtonMoveToBottom=function(){var V=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),V[V.length-1]);};
w.prototype._onSwitchButtonShowSelected=function(){this._getInternalModel().setProperty("/showOnlySelectedItems",!this._getInternalModel().getProperty("/showOnlySelectedItems"));this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._scrollToSelectedItem(this._getMarkedTableItem());this._updateControlLogic();this._fnHandleResize();};
w.prototype._onExecuteSearch=function(){this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._updateControlLogic();};
w.prototype._switchVisibilityOfUnselectedModelItems=function(){var b=this._isFilteredByShowSelected();var M=this._getInternalModel().getProperty("/items");M.forEach(function(a){if(a.persistentSelected){a.visible=true;return;}a.visible=!b;});this._getInternalModel().setProperty("/items",M);};
w.prototype._getVisibleModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(M){return!!M.visible;});};
w.prototype._getVisibleModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(M){return!!M.visible;});};
w.prototype._moveMarkedTableItem=function(a,b){var M=this._getModelItemByColumnKey(this._getColumnKeyByTableItem(a));var x=this._getModelItemByColumnKey(this._getColumnKeyByTableItem(b));var y=this._getModelItemIndexByColumnKey(M.columnKey);var z=this._getModelItemIndexByColumnKey(x.columnKey);this._moveModelItems(y,z);this._scrollToSelectedItem(this._getMarkedTableItem());this._updateControlLogic();this._fireChangeDimMeasureItems();this._notifyChange();};
w.prototype._moveModelItems=function(a,b){var M=this._getInternalModel().getProperty("/items");if(a<0||b<0||a>M.length-1||b>M.length-1){return false;}this._removeStyleOfMarkedTableItem();var x=M.splice(a,1);M.splice(b,0,x[0]);this._updateModelItemsPersistentIndex(M);this._updateCounts(M);this._getInternalModel().setProperty("/items",M);this._switchMarkedTableItemTo(this._getMarkedTableItem());return true;};
w.prototype._getModelItemByColumnKey=function(a){var M=this._getInternalModel().getProperty("/items").filter(function(b){return b.columnKey===a;});return M[0];};
w.prototype._updateCounts=function(M){var a=0;var b=0;M.forEach(function(x){a++;if(x.persistentSelected){b++;}});this._getInternalModel().setProperty("/countOfItems",a);this._getInternalModel().setProperty("/countOfSelectedItems",b);};
w.prototype._sortModelItemsByPersistentIndex=function(M){var x;var y=sap.ui.getCore().getConfiguration().getLocale().toString();try{if(typeof window.Intl!=='undefined'){x=window.Intl.Collator(y,{numeric:true});}}catch(E){}M.forEach(function(a,b){a.localIndex=b;});M.sort(function(a,b){if(a.persistentSelected===true&&(b.persistentSelected===false||b.persistentSelected===undefined)){return-1;}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&b.persistentSelected===true){return 1;}else if(a.persistentSelected===true&&b.persistentSelected===true){if(a.persistentIndex>-1&&a.persistentIndex<b.persistentIndex){return-1;}else if(b.persistentIndex>-1&&a.persistentIndex>b.persistentIndex){return 1;}else{return a.localIndex-b.localIndex;}}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&(b.persistentSelected===false||b.persistentSelected===undefined)){return x?x.compare(a.text,b.text):a.text.localeCompare(b.text,y,{numeric:true});}});M.forEach(function(a){delete a.localIndex;});};
w.prototype._getColumnKeyByTableItem=function(a){var b=this._oTable.indexOfItem(a);if(b<0){return null;}return this._oTable.getBinding("items").getContexts()[b].getObject().columnKey;};
w.prototype._getModelItemIndexByColumnKey=function(a){var b=-1;this._getInternalModel().getData().items.some(function(M,x){if(M.columnKey===a){b=x;return true;}});return b;};
w.prototype._getSelectedModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(M){return M.persistentSelected;});};
w.prototype._getVisibleTableItems=function(){return this._oTable.getItems().filter(function(a){return a.getVisible();});};
w.prototype._getTableItemByColumnKey=function(a){var b=this._oTable.getBinding("items").getContexts();var x=this._oTable.getItems().filter(function(y,z){return b[z].getObject().columnKey===a;});return x[0];};
w.prototype._getToolbar=function(){return sap.ui.getCore().byId(this.getId()+"-toolbar")||null;};
w.prototype._getSearchField=function(){return sap.ui.getCore().byId(this.getId()+"-searchField")||null;};
w.prototype._getSearchText=function(){var a=this._getSearchField();return a?a.getValue():"";};
w.prototype._isFilteredBySearchText=function(){return!!this._getSearchText().length;};
w.prototype._isFilteredByShowSelected=function(){return this._getInternalModel().getData().showOnlySelectedItems;};
w.prototype._updateControlLogic=function(){var b=this._isFilteredBySearchText();var a=this._isFilteredByShowSelected();var V=this._getVisibleTableItems();this._getInternalModel().setProperty("/isMoveUpButtonEnabled",V.indexOf(this._getMarkedTableItem())>0);this._getInternalModel().setProperty("/isMoveDownButtonEnabled",V.indexOf(this._getMarkedTableItem())>-1&&V.indexOf(this._getMarkedTableItem())<V.length-1);var x=sap.ui.getCore().byId(this._oTable.getId()+'-sa');if(x){x.setEnabled(!b&&!a);}};
w.prototype._updateModelItemsPersistentIndex=function(M){var a=-1;M.forEach(function(b){b.persistentIndex=-1;if(b.persistentSelected){a++;b.persistentIndex=a;}});};
w.prototype._fireChangeDimMeasureItems=function(){this._bIgnoreUpdateInternalModel=true;this.fireChangeDimMeasureItems({items:this._getInternalModel().getProperty("/items").map(function(M){return{columnKey:M.columnKey,visible:M.persistentSelected,index:M.persistentIndex===-1?undefined:M.persistentIndex,role:M.role};})});this._bIgnoreUpdateInternalModel=false;};
w.prototype._fireChangeChartType=function(){this._bIgnoreUpdateInternalModel=true;this.fireChangeChartType({chartTypeKey:this._getInternalModel().getProperty("/selectedChartTypeKey")});this._bIgnoreUpdateInternalModel=false;};
w.prototype._getDimMeasureItemByColumnKey=function(a){var D=this.getDimMeasureItems().filter(function(b){return b.getColumnKey()===a;});return D[0];};
w.prototype._getMarkedTableItem=function(){return this._getTableItemByColumnKey(this._getInternalModel().getProperty("/columnKeyOfMarkedItem"));};
w.prototype._setColumnKeyOfMarkedItem=function(a){this._getInternalModel().setProperty("/columnKeyOfMarkedItem",a);};
w.prototype._onItemPressed=function(E){this._switchMarkedTableItemTo(E.getParameter('listItem'));this._updateControlLogic();};
w.prototype._onChartTypeChange=function(E){this._fireChangeChartType();this._notifyChange();};
w.prototype._onRoleChange=function(E){this._fireChangeDimMeasureItems();this._notifyChange();};
w.prototype._onSelectionChange=function(E){if(!E.getParameter("selectAll")&&E.getParameter("listItems").length===1){this._switchMarkedTableItemTo(E.getParameter("listItem"));}this._selectTableItem();};
w.prototype._selectTableItem=function(){this._updateControlLogic();var M=this._getInternalModel().getProperty("/items");this._updateModelItemsPersistentIndex(M);this._updateCounts(M);this._getInternalModel().setProperty("/items",M);this._fireChangeDimMeasureItems();this._notifyChange();};
w.prototype._switchMarkedTableItemTo=function(a){this._removeStyleOfMarkedTableItem();var b=this._getColumnKeyByTableItem(a);if(b){this._setColumnKeyOfMarkedItem(b);a.addStyleClass("sapMP13nColumnsPanelItemSelected");}};
w.prototype._removeStyleOfMarkedTableItem=function(){if(this._getMarkedTableItem()){this._getMarkedTableItem().removeStyleClass("sapMP13nColumnsPanelItemSelected");}};
w.prototype._filterModelItemsBySearchText=function(){var a=this._getSearchText();a=a.replace(/(^\s+)|(\s+$)/g,'');a=a.replace(/[-\/\\^$*+?.()|[\]{}]/g,'\\$&');var b=new RegExp(a,'igm');if(!b){return;}this._getVisibleModelItems().forEach(function(M){var x=this._getTableItemByColumnKey(M.columnKey);var y=x.getCells();M.visible=false;if(y[0]&&y[0].getText().match(b)){M.visible=true;}if(y[1]&&y[1].getText().match(b)){M.visible=true;}if(y[2]&&y[2].getSelectedItem()&&y[2].getSelectedItem().getText().match(b)){M.visible=true;}if(M.tooltip&&M.tooltip.match(b)){M.visible=true;}},this);this._getInternalModel().refresh();};
w.prototype._updateInternalModel=function(){if(!this._bUpdateInternalModel){return;}this._bUpdateInternalModel=false;this._removeStyleOfMarkedTableItem();this._getInternalModel().setProperty("/items",this.getItems().map(function(a){return{columnKey:a.getColumnKey(),visible:true,text:a.getText(),tooltip:a.getTooltip(),aggregationRole:a.getAggregationRole(),availableRoleTypes:this.oAvailableRoleTypes[a.getAggregationRole()],role:a.getRole(),persistentIndex:-1,persistentSelected:undefined};},this));this._getInternalModel().setProperty("/selectedChartTypeKey",this.getChartTypeKey());this._getInternalModel().setProperty("/availableChartTypes",this.getAvailableChartTypes().map(function(a){return{key:a.getKey(),text:a.getText()};},this));this.getDimMeasureItems().forEach(function(D){var a=this._getModelItemByColumnKey(D.getColumnKey());if(!a){return;}if(D.getIndex()!==undefined){a.persistentIndex=D.getIndex();}if(D.getVisible()!==undefined){a.persistentSelected=D.getVisible();}if(D.getRole()!==undefined){a.role=D.getRole();}},this);this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();var M=this._getInternalModel().getProperty("/items");this._sortModelItemsByPersistentIndex(M);this._updateCounts(M);this._getInternalModel().setProperty("/items",M);this._switchMarkedTableItemTo(this._getMarkedTableItem());};
return w;});
sap.ui.predefine('sap/m/P13nFilterItem',['./library','sap/ui/core/Item'],function(l,I){"use strict";
var P=I.extend("sap.m.P13nFilterItem",{metadata:{library:"sap.m",properties:{operation:{type:"string",group:"Misc",defaultValue:null},value1:{type:"string",group:"Misc",defaultValue:null},value2:{type:"string",group:"Misc",defaultValue:null},columnKey:{type:"string",group:"Misc",defaultValue:null},exclude:{type:"boolean",group:"Misc",defaultValue:false}}}});
P.prototype.setOperation=function(o){return this.setProperty("operation",o,true);};
P.prototype.setColumnKey=function(k){return this.setProperty("columnKey",k,true);};
P.prototype.setValue1=function(v){return this.setProperty("value1",v,true);};
P.prototype.setValue2=function(v){return this.setProperty("value2",v,true);};
P.prototype.setExclude=function(e){return this.setProperty("exclude",e,true);};
return P;});
sap.ui.predefine('sap/m/P13nFilterPanel',['./P13nConditionPanel','./P13nPanel','./library','sap/m/Panel','./P13nFilterItem'],function(P,a,l,b,c){"use strict";var d=l.P13nPanelType;var e=l.P13nConditionOperation;
var f=a.extend("sap.m.P13nFilterPanel",{
metadata:{library:"sap.m",properties:{maxIncludes:{type:"string",group:"Misc",defaultValue:'-1'},maxExcludes:{type:"string",group:"Misc",defaultValue:'-1'},containerQuery:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},filterItems:{type:"sap.m.P13nFilterItem",multiple:true,singularName:"filterItem",bindable:"bindable"}},events:{addFilterItem:{},removeFilterItem:{},updateFilterItem:{},filterItemChanged:{parameters:{reason:{type:"string"},key:{type:"string"},index:{type:"int"},itemData:{type:"object"}}}}},
renderer:function(r,C){r.write("<section");r.writeControlData(C);r.addClass("sapMFilterPanel");r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.addClass("sapMFilterPanelContent");r.addClass("sapMFilterPanelBG");r.writeClasses();r.write(">");var g=C.getAggregation("content");var L=g.length;for(var i=0;i<L;i++){r.renderControl(g[i]);}r.write("</div>");r.write("</section>");}
});
f.prototype.setConditions=function(C){var I=[];var E=[];if(C.length){for(var i=0;i<C.length;i++){var o=C[i];if(!o.exclude){I.push(o);}else{E.push(o);}}}this._oIncludeFilterPanel.setConditions(I);this._oExcludeFilterPanel.setConditions(E);if(E.length>0){this._oExcludePanel.setExpanded(true);}return this;};
f.prototype.getConditions=function(){var i=this._oIncludeFilterPanel.getConditions();var E=this._oExcludeFilterPanel.getConditions();return i.concat(E);};
f.prototype.setContainerQuery=function(C){this.setProperty("containerQuery",C);this._oIncludeFilterPanel.setContainerQuery(C);this._oExcludeFilterPanel.setContainerQuery(C);return this;};
f.prototype.setLayoutMode=function(m){this.setProperty("layoutMode",m);this._oIncludeFilterPanel.setLayoutMode(m);this._oExcludeFilterPanel.setLayoutMode(m);return this;};
f.prototype.validateConditions=function(){return this._oIncludeFilterPanel.validateConditions()&&this._oExcludeFilterPanel.validateConditions();};
f.prototype.removeInvalidConditions=function(){this._oIncludeFilterPanel.removeInvalidConditions();this._oExcludeFilterPanel.removeInvalidConditions();};
f.prototype.removeValidationErrors=function(){this._oIncludeFilterPanel.removeValidationErrors();this._oExcludeFilterPanel.removeValidationErrors();};
f.prototype.onBeforeNavigationFrom=function(){return this.validateConditions();};
f.prototype.onAfterNavigationFrom=function(){return this.removeInvalidConditions();};
f.prototype.setIncludeOperations=function(o,t){t=t||"default";this._aIncludeOperations[t]=o;if(this._oIncludeFilterPanel){this._oIncludeFilterPanel.setOperations(this._aIncludeOperations[t],t);}};
f.prototype.getIncludeOperations=function(t){if(this._oIncludeFilterPanel){return this._oIncludeFilterPanel.getOperations(t);}};
f.prototype.setExcludeOperations=function(o,t){t=t||"default";this._aExcludeOperations[t]=o;if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.setOperations(this._aExcludeOperations[t],t);}};
f.prototype.getExcludeOperations=function(t){if(this._oExcludeFilterPanel){return this._oExcludeFilterPanel.getOperations(t);}};
f.prototype.setKeyFields=function(k){this._aKeyFields=k;if(this._oIncludeFilterPanel){this._oIncludeFilterPanel.setKeyFields(this._aKeyFields);}if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.setKeyFields(this._aKeyFields);}};
f.prototype.getKeyFields=function(){return this._aKeyFields;};
f.prototype.setMaxIncludes=function(m){this.setProperty("maxIncludes",m);if(this._oIncludeFilterPanel){this._oIncludeFilterPanel.setMaxConditions(m);}this._updatePanel();return this;};
f.prototype.setMaxExcludes=function(m){this.setProperty("maxExcludes",m);if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.setMaxConditions(m);}this._updatePanel();return this;};
f.prototype._updatePanel=function(){var m=this.getMaxIncludes()==="-1"?1000:parseInt(this.getMaxIncludes());var M=this.getMaxExcludes()==="-1"?1000:parseInt(this.getMaxExcludes());if(m>0){if(M<=0){this._oIncludePanel.setHeaderText(null);this._oIncludePanel.setExpandable(false);this._oIncludePanel.addStyleClass("panelTopMargin");this._oIncludePanel.addStyleClass("panelNoHeader");}}if(M===0){this._oExcludePanel.setHeaderText(null);this._oExcludePanel.setExpandable(false);this._oExcludePanel.addStyleClass("panelNoHeader");}};
f.prototype.init=function(){this.setType(d.filter);this.setTitle(sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("FILTERPANEL_TITLE"));sap.ui.getCore().loadLibrary("sap.ui.layout");this._aKeyFields=[];this.addStyleClass("sapMFilterPanel");this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._aIncludeOperations={};if(!this._aIncludeOperations["default"]){this.setIncludeOperations([e.EQ,e.BT,e.LT,e.LE,e.GT,e.GE]);}if(!this._aIncludeOperations["string"]){this.setIncludeOperations([e.Contains,e.EQ,e.BT,e.StartsWith,e.EndsWith,e.LT,e.LE,e.GT,e.GE],"string");}if(!this._aIncludeOperations["date"]){this.setIncludeOperations([e.EQ,e.BT,e.LT,e.LE,e.GT,e.GE],"date");}if(!this._aIncludeOperations["time"]){this.setIncludeOperations([e.EQ,e.BT,e.LT,e.LE,e.GT,e.GE],"time");}if(!this._aIncludeOperations["datetime"]){this.setIncludeOperations([e.EQ,e.BT,e.LT,e.LE,e.GT,e.GE],"datetime");}if(!this._aIncludeOperations["numeric"]){this.setIncludeOperations([e.EQ,e.BT,e.LT,e.LE,e.GT,e.GE],"numeric");}if(!this._aIncludeOperations["numc"]){this.setIncludeOperations([e.Contains,e.EQ,e.BT,e.EndsWith,e.LT,e.LE,e.GT,e.GE],"numc");}if(!this._aIncludeOperations["boolean"]){this.setIncludeOperations([e.EQ],"boolean");}this._aExcludeOperations={};if(!this._aExcludeOperations["default"]){this.setExcludeOperations([e.EQ]);}this._oIncludePanel=new b({expanded:true,expandable:true,headerText:this._oRb.getText("FILTERPANEL_INCLUDES"),width:"auto"}).addStyleClass("sapMFilterPadding");this._oIncludeFilterPanel=new P({maxConditions:this.getMaxIncludes(),alwaysShowAddIcon:false,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange()});this._oIncludeFilterPanel._sAddRemoveIconTooltipKey="FILTER";for(var t in this._aIncludeOperations){this._oIncludeFilterPanel.setOperations(this._aIncludeOperations[t],t);}this._oIncludePanel.addContent(this._oIncludeFilterPanel);this.addAggregation("content",this._oIncludePanel);this._oExcludePanel=new b({expanded:false,expandable:true,headerText:this._oRb.getText("FILTERPANEL_EXCLUDES"),width:"auto"}).addStyleClass("sapMFilterPadding");this._oExcludeFilterPanel=new P({exclude:true,maxConditions:this.getMaxExcludes(),alwaysShowAddIcon:false,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange()});this._oExcludeFilterPanel._sAddRemoveIconTooltipKey="FILTER";for(var t in this._aExcludeOperations){this._oExcludeFilterPanel.setOperations(this._aExcludeOperations[t],t);}this._oExcludePanel.addContent(this._oExcludeFilterPanel);this.addAggregation("content",this._oExcludePanel);this._updatePanel();};
f.prototype.exit=function(){var g=function(o){if(o&&o.destroy){o.destroy();}return null;};this._aKeyFields=g(this._aKeyFields);this._aIncludeOperations=g(this._aIncludeOperations);this._aExcludeOperations=g(this._aExcludeOperations);this._oRb=g(this._oRb);};
f.prototype.onBeforeRendering=function(){if(this._bUpdateRequired){this._bUpdateRequired=false;var k=[];var m=(this.getBindingInfo("items")||{}).model;var g=function(n,o,i){var B=i.getBinding(n);if(B&&o){return o.getObject()[B.getPath()];}return i.getMetadata().getProperty(n)?i.getProperty(n):i.getAggregation(n);};this.getItems().forEach(function(i){var o=i.getBindingContext(m);if(i.getBinding("key")){o.getObject()[i.getBinding("key").getPath()]=i.getKey();}k.push({key:i.getColumnKey(),text:g("text",o,i),tooltip:g("tooltip",o,i),maxLength:g("maxLength",o,i),type:g("type",o,i),typeInstance:g("typeInstance",o,i),formatSettings:g("formatSettings",o,i),precision:g("precision",o,i),scale:g("scale",o,i),isDefault:g("isDefault",o,i),values:g("values",o,i)});var n=k.length;if(k[n-1].maxLength===1||k[n-1].maxLength==="1"){k[n-1].operations=[e.EQ,e.BT,e.LT,e.LE,e.GT,e.GE];}});this.setKeyFields(k);var C=[];m=(this.getBindingInfo("filterItems")||{}).model;this.getFilterItems().forEach(function(F){var o=F.getBindingContext(m);if(F.getBinding("key")&&o){o.getObject()[F.getBinding("key").getPath()]=F.getKey();}C.push({key:F.getKey(),keyField:g("columnKey",o,F),operation:g("operation",o,F),value1:g("value1",o,F),value2:g("value2",o,F),exclude:g("exclude",o,F)});});this.setConditions(C);}};
f.prototype.addItem=function(i){a.prototype.addItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype.removeItem=function(i){var r=a.prototype.removeItem.apply(this,arguments);this._bUpdateRequired=true;return r;};
f.prototype.destroyItems=function(){this.destroyAggregation("items");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype.addFilterItem=function(F){this.addAggregation("filterItems",F,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype.insertFilterItem=function(F,i){this.insertAggregation("filterItems",F,i,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype.updateFilterItems=function(r){this.updateAggregation("filterItems");if(r==="change"&&!this._bIgnoreBindCalls){this._bUpdateRequired=true;this.invalidate();}};
f.prototype.removeFilterItem=function(F){F=this.removeAggregation("filterItems",F,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return F;};
f.prototype.removeAllFilterItems=function(){var F=this.removeAllAggregation("filterItems",true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return F;};
f.prototype.destroyFilterItems=function(){this.destroyAggregation("filterItems");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype._handleDataChange=function(){var t=this;return function(E){var n=E.getParameter("newData");var o=E.getParameter("operation");var k=E.getParameter("key");var C=E.getParameter("index");var F;var I=-1;var g=E.getSource()===t._oExcludeFilterPanel;t.getFilterItems().some(function(h,i){if((!h.getExclude()&&!g)||(h.getExclude()&&g)){C--;}I=i;return C<0;},this);switch(o){case"update":F=t.getFilterItems()[I];if(F){F.setExclude(n.exclude);F.setColumnKey(n.keyField);F.setOperation(n.operation);F.setValue1(n.value1);F.setValue2(n.value2);}t.fireUpdateFilterItem({key:k,index:I,filterItemData:F});t.fireFilterItemChanged({reason:"updated",key:k,index:I,itemData:{columnKey:n.keyField,operation:n.operation,exclude:n.exclude,value1:n.value1,value2:n.value2}});break;case"add":if(C>=0){I++;}F=new c({columnKey:n.keyField,exclude:n.exclude,operation:n.operation});F.setValue1(n.value1);F.setValue2(n.value2);t._bIgnoreBindCalls=true;t.fireAddFilterItem({key:k,index:I,filterItemData:F});t.fireFilterItemChanged({reason:"added",key:k,index:I,itemData:{columnKey:n.keyField,operation:n.operation,exclude:n.exclude,value1:n.value1,value2:n.value2}});t._bIgnoreBindCalls=false;break;case"remove":t._bIgnoreBindCalls=true;t.fireRemoveFilterItem({key:k,index:I});t.fireFilterItemChanged({reason:"removed",key:k,index:I});t._bIgnoreBindCalls=false;break;default:throw"Operation'"+o+"' is not supported yet";}t._notifyChange();};};
f.prototype._notifyChange=function(){var L=this.getChangeNotifier();if(L){L(this);}};
return f;});
sap.ui.predefine('sap/m/P13nGroupItem',['./library','sap/ui/core/Item'],function(l,I){"use strict";
var P=I.extend("sap.m.P13nGroupItem",{metadata:{library:"sap.m",properties:{operation:{type:"string",group:"Misc",defaultValue:null},columnKey:{type:"string",group:"Misc",defaultValue:null},showIfGrouped:{type:"boolean",group:"Misc",defaultValue:false}}}});
P.prototype.setColumnKey=function(v){return this.setProperty("columnKey",v,true);};
P.prototype.setOperation=function(v){return this.setProperty("operation",v,true);};
P.prototype.setShowIfGrouped=function(v){return this.setProperty("showIfGrouped",v,true);};
return P;});
sap.ui.predefine('sap/m/P13nGroupPanel',['./library','./P13nConditionPanel','./P13nPanel','./P13nGroupItem',"sap/ui/thirdparty/jquery"],function(l,P,a,c,q){"use strict";var d=l.P13nPanelType;var e=l.P13nConditionOperation;
var f=a.extend("sap.m.P13nGroupPanel",{
metadata:{library:"sap.m",properties:{maxGroups:{type:"string",group:"Misc",defaultValue:'-1'},containerQuery:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},groupItems:{type:"sap.m.P13nGroupItem",multiple:true,singularName:"groupItem",bindable:"bindable"}},events:{addGroupItem:{parameters:{}},removeGroupItem:{},updateGroupItem:{}}},
renderer:function(r,C){r.write("<section");r.writeControlData(C);r.addClass("sapMGroupPanel");r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.addClass("sapMGroupPanelContent");r.addClass("sapMGroupPanelBG");r.writeClasses();r.write(">");var b=C.getAggregation("content");var L=b.length;for(var i=0;i<L;i++){r.renderControl(b[i]);}r.write("</div>");r.write("</section>");}
});
f.prototype.setMaxGroups=function(m){this.setProperty("maxGroups",m);if(this._oGroupPanel){this._oGroupPanel.setMaxConditions(m);}};
f.prototype._getConditions=function(){return this._oGroupPanel.getConditions();};
f.prototype.setContainerQuery=function(b){this.setProperty("containerQuery",b);this._oGroupPanel.setContainerQuery(b);};
f.prototype.setLayoutMode=function(m){this.setProperty("layoutMode",m);this._oGroupPanel.setLayoutMode(m);};
f.prototype.validateConditions=function(){return this._oGroupPanel.validateConditions();};
f.prototype.removeInvalidConditions=function(){this._oGroupPanel.removeInvalidConditions();};
f.prototype.removeValidationErrors=function(){this._oGroupPanel.removeValidationErrors();};
f.prototype.onBeforeNavigationFrom=function(){return this.validateConditions();};
f.prototype.onAfterNavigationFrom=function(){return this.removeInvalidConditions();};
f.prototype.setOperations=function(o){this._aOperations=o;if(this._oGroupPanel){this._oGroupPanel.setOperations(this._aOperations);}};
f.prototype.init=function(){this.setType(d.group);this.setTitle(sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("GROUPPANEL_TITLE"));sap.ui.getCore().loadLibrary("sap.ui.layout");this._aKeyFields=[];this.addStyleClass("sapMGroupPanel");if(!this._aOperations){this.setOperations([e.GroupAscending,e.GroupDescending]);}this._oGroupPanel=new P({maxConditions:this.getMaxGroups(),autoReduceKeyFieldItems:true,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange(),validationExecutor:q.proxy(this._callValidationExecutor,this)});this._oGroupPanel.setOperations(this._aOperations);this._oGroupPanel._sAddRemoveIconTooltipKey="GROUP";this.addAggregation("content",this._oGroupPanel);};
f.prototype.exit=function(){var b=function(o){if(o&&o.destroy){o.destroy();}return null;};this._aKeyFields=b(this._aKeyFields);this._aOperations=b(this._aOperations);};
f.prototype.onBeforeRendering=function(){if(this._bUpdateRequired){this._bUpdateRequired=false;var k=[];var m=(this.getBindingInfo("items")||{}).model;var g=function(n,o,i){var b=i.getBinding(n);if(b&&o){return o.getObject()[b.getPath()];}return i.getMetadata().getProperty(n)?i.getProperty(n):i.getAggregation(n);};this.getItems().forEach(function(i){var o=i.getBindingContext(m);if(i.getBinding("key")){o.getObject()[i.getBinding("key").getPath()]=i.getKey();}k.push({key:i.getColumnKey(),text:g("text",o,i),tooltip:g("tooltip",o,i)});});k.splice(0,0,{key:null,text:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_SELECTION_NONE")});this._oGroupPanel.setKeyFields(k);var C=[];m=(this.getBindingInfo("groupItems")||{}).model;this.getGroupItems().forEach(function(G){var o=G.getBindingContext(m);if(G.getBinding("key")){o.getObject()[G.getBinding("key").getPath()]=G.getKey();}C.push({key:G.getKey(),keyField:g("columnKey",o,G),operation:g("operation",o,G),showIfGrouped:g("showIfGrouped",o,G)});});this._oGroupPanel.setConditions(C);}};
f.prototype.addItem=function(i){a.prototype.addItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype.removeItem=function(i){var r=a.prototype.removeItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return r;};
f.prototype.destroyItems=function(){this.destroyAggregation("items");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype.addGroupItem=function(g){this.addAggregation("groupItems",g,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype.insertGroupItem=function(g,i){this.insertAggregation("groupItems",g,i,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype.updateGroupItems=function(r){this.updateAggregation("groupItems");if(r==="change"&&!this._bIgnoreBindCalls){this._bUpdateRequired=true;this.invalidate();}};
f.prototype.removeGroupItem=function(g){g=this.removeAggregation("groupItems",g,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return g;};
f.prototype.removeAllGroupItems=function(){var g=this.removeAllAggregation("groupItems",true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return g;};
f.prototype.destroyGroupItems=function(){this.destroyAggregation("groupItems");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype._handleDataChange=function(){var t=this;return function(E){var n=E.getParameter("newData");var o=E.getParameter("operation");var k=E.getParameter("key");var i=E.getParameter("index");var g;if(o==="update"){g=t.getGroupItems()[i];if(g){g.setColumnKey(n.keyField);g.setOperation(n.operation);g.setShowIfGrouped(n.showIfGrouped);}t.fireUpdateGroupItem({key:k,index:i,groupItemData:g});t._notifyChange();}if(o==="add"){g=new c({key:k,columnKey:n.keyField,operation:n.operation,showIfGrouped:n.showIfGrouped});t._bIgnoreBindCalls=true;t.fireAddGroupItem({key:k,index:i,groupItemData:g});t._bIgnoreBindCalls=false;t._notifyChange();}if(o==="remove"){t._bIgnoreBindCalls=true;t.fireRemoveGroupItem({key:k,index:i});t._bIgnoreBindCalls=false;t._notifyChange();}};};
f.prototype.getOkPayload=function(){if(!this.getModel()){return null;}var s=[];this._oGroupPanel._oConditionsGrid.getContent().forEach(function(C){var o=C.keyField;s.push(o.getSelectedKey());});return{selectedColumnKeys:s};};
f.prototype._callValidationExecutor=function(){var v=this.getValidationExecutor();if(v){v();}};
f.prototype._updateValidationResult=function(v){this._oGroupPanel._oConditionsGrid.getContent().forEach(function(C){var o=C.keyField;o.setValueStateText("");o.setValueState("None");var s=o.getSelectedKey();v.forEach(function(r){if(r.columnKey===s){o.setValueStateText(r.messageText);o.setValueState(r.messageType);}});});};
f.prototype.setValidationListener=function(L){this.setProperty("validationListener",L);if(L){L(this,q.proxy(this._updateValidationResult,this));}};
f.prototype._notifyChange=function(){var L=this.getChangeNotifier();if(L){L(this);}};
return f;});
sap.ui.predefine('sap/m/P13nItem',['./library','sap/ui/core/Element'],function(l,E){"use strict";
var P=E.extend("sap.m.P13nItem",{metadata:{library:"sap.m",properties:{columnKey:{type:"string",group:"Data",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:""},visible:{type:"boolean",group:"Misc",defaultValue:null},type:{type:"string",group:"Misc",defaultValue:"text"},typeInstance:{type:"object",group:"Misc",defaultValue:null,since:"1.56"},precision:{type:"string",group:"Misc",defaultValue:null},formatSettings:{type:"object",group:"Misc",defaultValue:null,since:"1.52"},scale:{type:"string",group:"Misc",defaultValue:null},maxLength:{type:"string",group:"Misc",defaultValue:null},width:{type:"string",group:"Misc",defaultValue:null},isDefault:{type:"boolean",group:"Misc",defaultValue:false},values:{type:"string[]",group:"Misc",defaultValue:null},role:{type:"string",defaultValue:null},aggregationRole:{type:"string",defaultValue:null},href:{type:"string",defaultValue:null},target:{type:"string",defaultValue:null},press:{type:"object",defaultValue:null},description:{type:"string",defaultValue:null}}}});
return P;});
sap.ui.predefine('sap/m/P13nPanel',['./library','sap/ui/core/Control'],function(l,C){"use strict";
var P=C.extend("sap.m.P13nPanel",{
metadata:{"abstract":true,library:"sap.m",properties:{title:{type:"string",group:"Appearance",defaultValue:null},titleLarge:{type:"string",group:"Appearance",defaultValue:null},type:{type:"string",group:"Misc",defaultValue:null},verticalScrolling:{type:"boolean",group:"Misc",defaultValue:true},validationExecutor:{type:"object",group:"Misc",defaultValue:null},validationListener:{type:"object",group:"Misc",defaultValue:null},changeNotifier:{type:"object",group:"Misc",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.P13nItem",multiple:true,singularName:"item",bindable:"bindable"}},events:{beforeNavigationTo:{}}},
renderer:function(r,c){r.write("<span");r.writeControlData(c);r.addClass("sapMP13nPanel");r.writeClasses();r.write(">");r.write("</span>");}
});
P.prototype.getOkPayload=function(){return{};};
P.prototype.getResetPayload=function(){return{};};
P.prototype.beforeNavigationTo=function(){this.fireBeforeNavigationTo();};
P.prototype.onBeforeNavigationFrom=function(){return true;};
P.prototype.onAfterNavigationFrom=function(){};
return P;});
sap.ui.predefine('sap/m/P13nSelectionItem',['./library','sap/ui/core/Item'],function(l,I){"use strict";
var P=I.extend("sap.m.P13nSelectionItem",{metadata:{library:"sap.m",properties:{columnKey:{type:"string",defaultValue:undefined},selected:{type:"boolean",defaultValue:false}}}});
return P;});
sap.ui.predefine('sap/m/P13nSelectionPanel',['./library','./ColumnListItem','./P13nPanel','./SearchField','./Text','./Table','./Column','./ScrollContainer','./P13nSelectionItem','./VBox','./Link','./OverflowToolbar','./OverflowToolbarLayoutData','./ToolbarSpacer','sap/ui/core/library','sap/ui/model/ChangeReason','sap/ui/model/json/JSONModel','sap/ui/model/BindingMode','sap/ui/core/ResizeHandler',"sap/ui/thirdparty/jquery"],function(l,C,P,S,T,a,b,c,d,V,L,O,e,f,g,h,J,B,R,q){"use strict";var i=l.ToolbarDesign;var j=l.ListType;var k=l.ListMode;var m=l.P13nPanelType;
var n=P.extend("sap.m.P13nSelectionPanel",{
metadata:{library:"sap.m",aggregations:{selectionItems:{type:"sap.m.P13nSelectionItem",multiple:true,singularName:"selectionItem",bindable:"bindable"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"}},events:{changeSelectionItems:{parameters:{items:{type:"object[]"}}}}},
renderer:function(r,o){r.write("<div");r.writeControlData(o);r.addClass("sapMP13nColumnsPanel");r.writeClasses();r.write(">");var p=o.getAggregation("content");if(p){p.forEach(function(s){r.renderControl(s);});}r.write("</div>");}
});
n.prototype.init=function(){this._iLiveChangeTimer=0;this._iSearchTimer=0;this._bIgnoreUpdateInternalModel=false;this._bUpdateInternalModel=true;this._bOnAfterRenderingFirstTimeExecuted=false;var M=new J({items:[],countOfSelectedItems:0,countOfItems:0});M.setDefaultBindingMode(B.TwoWay);M.setSizeLimit(1000);this.setModel(M,"$sapmP13nSelectionPanel");this.setType(m.selection);this._createTable();this._createToolbar();this.setVerticalScrolling(false);var s=new c({horizontal:false,vertical:true,content:[this._oTable],width:'100%',height:'100%'});this.addAggregation("content",s);var t=this;this._fnHandleResize=function(){var o=false,p,r;if(t.getParent){var $=null,u,H;var v=t.getParent();var w=t._getToolbar();if(v&&v.$){$=v.$("cont");if($.children().length>0&&w.$().length>0){p=s.$()[0].clientHeight;u=$.children()[0].clientHeight;H=w?w.$()[0].clientHeight:0;r=u-H;if(p!==r){s.setHeight(r+'px');o=true;}}}}return o;};this._sContainerResizeListener=R.register(s,this._fnHandleResize);};
n.prototype.onBeforeRendering=function(){this._updateInternalModel();};
n.prototype.onAfterRendering=function(){var t=this;if(!this._bOnAfterRenderingFirstTimeExecuted){this._bOnAfterRenderingFirstTimeExecuted=true;window.clearTimeout(this._iLiveChangeTimer);this._iLiveChangeTimer=window.setTimeout(function(){t._fnHandleResize();},0);}};
n.prototype.getOkPayload=function(){this._updateInternalModel();var M=this._getInternalModel().getProperty("/items");return{selectionItems:M.map(function(o){return{columnKey:o.columnKey,selected:o.persistentSelected};})};};
n.prototype.exit=function(){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;this._getToolbar().destroy();this._oTable.destroy();this._oTable=null;if(this._getInternalModel()){this._getInternalModel().destroy();}window.clearTimeout(this._iLiveChangeTimer);window.clearTimeout(this._iSearchTimer);};
n.prototype.addItem=function(I){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("items",I);return this;};
n.prototype.insertItem=function(I,o){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("items",I,o);return this;};
n.prototype.removeItem=function(I){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}I=this.removeAggregation("items",I);return I;};
n.prototype.removeAllItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("items");};
n.prototype.destroyItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("items");return this;};
n.prototype.addSelectionItem=function(s){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("selectionItems",s);return this;};
n.prototype.insertSelectionItem=function(s,I){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("selectionItems",s,I);return this;};
n.prototype.updateSelectionItems=function(r){this.updateAggregation("selectionItems");if(r===h.Change&&!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}};
n.prototype.removeSelectionItem=function(s){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAggregation("selectionItems",s);};
n.prototype.removeAllSelectionItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("selectionItems");};
n.prototype.destroySelectionItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("selectionItems");return this;};
n.prototype.onBeforeNavigationFrom=function(){return true;};
n.prototype._notifyChange=function(){var o=this.getChangeNotifier();if(o){o(this);}};
n.prototype._getInternalModel=function(){return this.getModel("$sapmP13nSelectionPanel");};
n.prototype._createTable=function(){var t=this;this._oTable=new a({mode:k.MultiSelect,rememberSelections:false,selectionChange:q.proxy(this._onSelectionChange,this),columns:[new b({vAlign:g.VerticalAlign.Middle,header:new T({text:{parts:[{path:'/countOfSelectedItems'},{path:'/countOfItems'}],formatter:function(o,p){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText('COLUMNSPANEL_SELECT_ALL_WITH_COUNTER',[o,p]);}}})})],items:{path:"/items",templateShareable:false,template:new C({cells:new V({items:[new L({href:"{href}",text:"{text}",target:"{target}",enabled:{path:'href',formatter:function(v){if(!v){this.addStyleClass("sapUiCompSmartLink");}return!!v;}},press:function(E){var H=E.getSource().getHref();var I=t.getItems().filter(function(o){return o.getHref()===H&&!!o.getPress();});if(!I.length){return;}var p=I[0].getPress();p(E);}}),new T({visible:{path:'description',formatter:function(D){return!!D;}},text:"{description}"})]}),visible:"{visible}",selected:"{persistentSelected}",tooltip:"{tooltip}",type:j.Active})}});this._oTable.setModel(this._getInternalModel());};
n.prototype._createToolbar=function(){var t=this;var o=new O(this.getId()+"-toolbar",{design:i.Auto,content:[new f(),new S(this.getId()+"-searchField",{liveChange:function(E){var v=E.getSource().getValue(),D=(v?300:0);window.clearTimeout(t._iSearchTimer);if(D){t._iSearchTimer=window.setTimeout(function(){t._onExecuteSearch();},D);}else{t._onExecuteSearch();}},search:q.proxy(this._onExecuteSearch,this),layoutData:new e({minWidth:"12.5rem",maxWidth:"23.077rem",shrinkable:true,moveToOverflow:false,stayInOverflow:false})})]});o.setModel(this._getInternalModel());this.addAggregation("content",o);};
n.prototype._onExecuteSearch=function(){this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._updateControlLogic();};
n.prototype._switchVisibilityOfUnselectedModelItems=function(){var s=this._isFilteredByShowSelected();var M=this._getInternalModel().getProperty("/items");M.forEach(function(o){if(o.persistentSelected){o.visible=true;return;}o.visible=!s;});this._getInternalModel().setProperty("/items",M);};
n.prototype._getVisibleModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(M){return!!M.visible;});};
n.prototype._getModelItemByColumnKey=function(s){var M=this._getInternalModel().getProperty("/items").filter(function(o){return o.columnKey===s;});return M[0];};
n.prototype._updateCounts=function(M){var o=0;var p=0;M.forEach(function(r){o++;if(r.persistentSelected){p++;}});this._getInternalModel().setProperty("/countOfItems",o);this._getInternalModel().setProperty("/countOfSelectedItems",p);};
n.prototype._getToolbar=function(){return sap.ui.getCore().byId(this.getId()+"-toolbar")||null;};
n.prototype._getSearchField=function(){return sap.ui.getCore().byId(this.getId()+"-searchField")||null;};
n.prototype._getSearchText=function(){var s=this._getSearchField();return s?s.getValue():"";};
n.prototype._isFilteredBySearchText=function(){return!!this._getSearchText().length;};
n.prototype._isFilteredByShowSelected=function(){return false;};
n.prototype._updateControlLogic=function(){var I=this._isFilteredBySearchText();var s=this._isFilteredByShowSelected();var t=sap.ui.getCore().byId(this._oTable.getId()+'-sa');if(t){t.setEnabled(!I&&!s);}};
n.prototype._fireChangeSelectionItems=function(){this._bIgnoreUpdateInternalModel=true;var M=this._getInternalModel().getProperty("/items");this.fireChangeSelectionItems({items:M.map(function(o){return{columnKey:o.columnKey,selected:o.persistentSelected};})});this._bIgnoreUpdateInternalModel=false;};
n.prototype._onSelectionChange=function(){this._selectTableItem();};
n.prototype._selectTableItem=function(){var M=this._getInternalModel().getProperty("/items");this._updateCounts(M);this._getInternalModel().setProperty("/items",M);this._fireChangeSelectionItems();this._notifyChange();};
n.prototype._filterModelItemsBySearchText=function(){var s=this._getSearchText();s=s.replace(/(^\s+)|(\s+$)/g,'');s=s.replace(/[-\/\\^$*+?.()|[\]{}]/g,'\\$&');var r=new RegExp(s,'igm');this._getVisibleModelItems().forEach(function(M){M.visible=false;if(M.text&&M.text.match(r)){M.visible=true;}if(M.tooltip&&M.tooltip.match(r)){M.visible=true;}});this._getInternalModel().refresh();};
n.prototype._updateInternalModel=function(){if(!this._bUpdateInternalModel){return;}this._bUpdateInternalModel=false;this._getInternalModel().setProperty("/items",this.getItems().map(function(I){return{columnKey:I.getColumnKey(),visible:true,text:I.getText(),tooltip:I.getTooltip(),href:I.getHref(),target:I.getTarget(),persistentSelected:I.getVisible(),description:I.getDescription()};},this));this.getSelectionItems().forEach(function(s){var o=this._getModelItemByColumnKey(s.getColumnKey());if(!o){return;}if(s.getSelected()!==undefined){o.persistentSelected=s.getSelected();}},this);this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();var M=this._getInternalModel().getProperty("/items");this._updateCounts(M);this._getInternalModel().setProperty("/items",M);};
return n;});
sap.ui.predefine('sap/m/P13nSortItem',['./library','sap/ui/core/Item'],function(l,I){"use strict";
var P=I.extend("sap.m.P13nSortItem",{metadata:{library:"sap.m",properties:{operation:{type:"string",group:"Misc",defaultValue:null},columnKey:{type:"string",group:"Misc",defaultValue:null}}}});
P.prototype.setColumnKey=function(v){return this.setProperty("columnKey",v,true);};
P.prototype.setOperation=function(v){return this.setProperty("operation",v,true);};
return P;});
sap.ui.predefine('sap/m/P13nSortPanel',['./library','./P13nConditionPanel','./P13nPanel','./P13nSortItem'],function(l,P,a,c){"use strict";var d=l.P13nPanelType;var e=l.P13nConditionOperation;
var f=a.extend("sap.m.P13nSortPanel",{
metadata:{library:"sap.m",properties:{containerQuery:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},sortItems:{type:"sap.m.P13nSortItem",multiple:true,singularName:"sortItem",bindable:"bindable"}},events:{addSortItem:{},removeSortItem:{},updateSortItem:{}}},
renderer:function(r,C){if(!C.getVisible()){return;}r.write("<section");r.writeControlData(C);r.addClass("sapMSortPanel");r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.addClass("sapMSortPanelContent");r.addClass("sapMSortPanelBG");r.writeClasses();r.write(">");var b=C.getAggregation("content");var L=b.length;for(var i=0;i<L;i++){r.renderControl(b[i]);}r.write("</div>");r.write("</section>");}
});
f.prototype._getConditions=function(){return this._oSortPanel.getConditions();};
f.prototype.setContainerQuery=function(b){this.setProperty("containerQuery",b);this._oSortPanel.setContainerQuery(b);return this;};
f.prototype.setLayoutMode=function(m){this.setProperty("layoutMode",m);this._oSortPanel.setLayoutMode(m);return this;};
f.prototype.validateConditions=function(){return this._oSortPanel.validateConditions();};
f.prototype.removeInvalidConditions=function(){this._oSortPanel.removeInvalidConditions();};
f.prototype.removeValidationErrors=function(){this._oSortPanel.removeValidationErrors();};
f.prototype.onBeforeNavigationFrom=function(){return this.validateConditions();};
f.prototype.onAfterNavigationFrom=function(){return this.removeInvalidConditions();};
f.prototype.setOperations=function(o){this._aOperations=o;if(this._oSortPanel){this._oSortPanel.setOperations(this._aOperations);}return this;};
f.prototype.init=function(){this.setType(d.sort);this.setTitle(sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("SORTPANEL_TITLE"));sap.ui.getCore().loadLibrary("sap.ui.layout");this._aKeyFields=[];this.addStyleClass("sapMSortPanel");if(!this._aOperations){this.setOperations([e.Ascending,e.Descending]);}this._oSortPanel=new P({autoReduceKeyFieldItems:true,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange()});this._oSortPanel.setOperations(this._aOperations);this._oSortPanel._sAddRemoveIconTooltipKey="SORT";this.addAggregation("content",this._oSortPanel);};
f.prototype.exit=function(){var b=function(o){if(o&&o.destroy){o.destroy();}return null;};this._aKeyFields=b(this._aKeyFields);this._aOperations=b(this._aOperations);};
f.prototype.onBeforeRendering=function(){if(this._bUpdateRequired){this._bUpdateRequired=false;var k=[];var m=(this.getBindingInfo("items")||{}).model;var g=function(n,o,i){var b=i.getBinding(n);if(b&&o){return o.getObject()[b.getPath()];}return i.getMetadata().getProperty(n)?i.getProperty(n):i.getAggregation(n);};this.getItems().forEach(function(i){var o=i.getBindingContext(m);if(i.getBinding("key")){o.getObject()[i.getBinding("key").getPath()]=i.getKey();}k.push({key:i.getColumnKey(),text:g("text",o,i),tooltip:g("tooltip",o,i)});});k.splice(0,0,{key:null,text:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_SELECTION_NONE")});this._oSortPanel.setKeyFields(k);var C=[];m=(this.getBindingInfo("sortItems")||{}).model;this.getSortItems().forEach(function(s){var o=s.getBindingContext(m);if(s.getBinding("key")){o.getObject()[s.getBinding("key").getPath()]=s.getKey();}C.push({key:s.getKey(),keyField:g("columnKey",o,s),operation:g("operation",o,s)});});this._oSortPanel.setConditions(C);}};
f.prototype.addItem=function(i){a.prototype.addItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype.removeItem=function(i){var r=a.prototype.removeItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return r;};
f.prototype.destroyItems=function(){this.destroyAggregation("items");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype.addSortItem=function(s){this.addAggregation("sortItems",s,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype.insertSortItem=function(s,i){this.insertAggregation("sortItems",s,i,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype.updateSortItems=function(r){this.updateAggregation("sortItems");if(r==="change"&&!this._bIgnoreBindCalls){this._bUpdateRequired=true;this.invalidate();}};
f.prototype.removeSortItem=function(s){s=this.removeAggregation("sortItems",s,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return s;};
f.prototype.removeAllSortItems=function(){var s=this.removeAllAggregation("sortItems",true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return s;};
f.prototype.destroySortItems=function(){this.destroyAggregation("sortItems");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype._handleDataChange=function(){var t=this;return function(E){var n=E.getParameter("newData");var o=E.getParameter("operation");var k=E.getParameter("key");var i=E.getParameter("index");var s;if(o==="update"){s=t.getSortItems()[i];if(s){s.setColumnKey(n.keyField);s.setOperation(n.operation);}t.fireUpdateSortItem({key:k,index:i,sortItemData:s});t._notifyChange();}if(o==="add"){s=new c({key:k,columnKey:n.keyField,operation:n.operation});t._bIgnoreBindCalls=true;t.fireAddSortItem({key:k,index:i,sortItemData:s});t._bIgnoreBindCalls=false;t._notifyChange();}if(o==="remove"){t._bIgnoreBindCalls=true;t.fireRemoveSortItem({key:k,index:i});t._bIgnoreBindCalls=false;t._notifyChange();}};};
f.prototype._notifyChange=function(){var L=this.getChangeNotifier();if(L){L(this);}};
return f;});
sap.ui.predefine('sap/m/QuickView',['./library','sap/ui/Device','sap/ui/core/IconPool','./QuickViewBase','./ResponsivePopover','./NavContainer','./Page','./Bar','./Button','./QuickViewRenderer'],function(l,D,I,Q,R,N,P,B,a,b){"use strict";var c=l.PlacementType;
var d=Q.extend("sap.m.QuickView",{metadata:{library:"sap.m",properties:{placement:{type:"sap.m.PlacementType",group:"Misc",defaultValue:c.Right},width:{type:'sap.ui.core.CSSSize',group:'Dimension',defaultValue:'320px'}},aggregations:{},designtime:"sap/m/designtime/QuickView.designtime",events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},afterClose:{parameters:{openBy:{type:"sap.ui.core.Control"},origin:{type:"sap.m.Button"}}},beforeOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeClose:{parameters:{openBy:{type:"sap.ui.core.Control"},origin:{type:"sap.m.Button"}}}}}});
d.prototype.init=function(){var n={pages:[new P()],navigate:this._navigate.bind(this),afterNavigate:this._afterNavigate.bind(this)};this._oNavContainer=new N(n);var t=this;this._oPopover=new R(this.getId()+'-quickView',{placement:this.getPlacement(),content:[this._oNavContainer],contentWidth:this.getWidth(),showHeader:false,showCloseButton:false,afterOpen:function(e){t._afterOpen(e);t.fireAfterOpen({openBy:e.getParameter("openBy")});},afterClose:function(e){t.fireAfterClose({openBy:e.getParameter("openBy"),origin:t.getCloseButton()});},beforeOpen:function(e){t.fireBeforeOpen({openBy:e.getParameter("openBy")});},beforeClose:function(e){t.fireBeforeClose({openBy:e.getParameter("openBy"),origin:t.getCloseButton()});t._bRendered=false;}});this._oPopover.addStyleClass('sapMQuickView');var p=this._oPopover.getAggregation("_popup");p.addEventDelegate({onBeforeRendering:this._initializeQuickView,onAfterRendering:this._setLinkWidth,onkeydown:this._onPopupKeyDown},this);var t=this;var s=p._fnAdjustPositionAndArrow;if(s){p._fnAdjustPositionAndArrow=function(){s.apply(p,arguments);t._adjustContainerHeight();};}this._bItemsChanged=true;this._oPopover.addStyleClass("sapMQuickView");};
d.prototype._initializeQuickView=function(){this._bRendered=true;if(this._bItemsChanged){this._clearContainerHeight();this._initPages();var p=this.getAggregation("pages");if(!p&&D.system.phone){this._addEmptyPage();}this._bItemsChanged=false;}};
d.prototype.exit=function(){this._bRendered=false;this._bItemsChanged=true;if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}};
d.prototype.invalidate=function(){};
d.prototype._createPage=function(q){return q._createPage();};
d.prototype._onPopupKeyDown=function(e){this._processKeyboard(e);};
d.prototype._afterOpen=function(e){if(D.system.phone){this._restoreFocus();}};
d.prototype._addEmptyPage=function(){var p=new P({customHeader:new B().addStyleClass("sapMQuickViewHeader")});var t=this;var C=p.getCustomHeader();C.addContentRight(new a({icon:I.getIconURI("decline"),press:function(){t._oPopover.close();}}));p.addStyleClass('sapMQuickViewPage');this._oNavContainer.addPage(p);};
d.prototype._clearContainerHeight=function(){var p=this._oPopover.getAggregation("_popup");var $=p.$().find('.sapMPopoverCont');if($[0]&&$[0].style.height){$[0].style.height='';}};
d.prototype._adjustContainerHeight=function(){if(this.getPages().length<=1){return;}var p=this._oPopover.getAggregation("_popup");var $=p.$().find('.sapMPopoverCont');if($[0]&&!$[0].style.height){$[0].style.height=$.height()+'px';}};
d.prototype._setLinkWidth=function(){this._oPopover.$().find(".sapMLnk").css("width","auto");};
d.prototype.getCloseButton=function(){if(!D.system.phone){return undefined;}var p=this._oNavContainer.getCurrentPage();var o=p.getCustomHeader().getContentRight()[0];return o;};
d.prototype.setPlacement=function(p){this.setProperty("placement",p,true);this._oPopover.setPlacement(p);return this;};
d.prototype.setWidth=function(w){if(this._oPopover){this._oPopover.setContentWidth(w);this.setProperty('width',w,true);}return this;};
d.prototype.openBy=function(C){this._bItemsChanged=true;this._oPopover.openBy(C);return this;};
d.prototype.getDomRef=function(s){return this._oPopover&&this._oPopover.getAggregation("_popup").getDomRef(s);};
["addStyleClass","removeStyleClass","toggleStyleClass","hasStyleClass","getBusyIndicatorDelay","setBusyIndicatorDelay","getVisible","setVisible","getFieldGroupIds","setFieldGroupIds","getBusy","setBusy","setTooltip","getTooltip"].forEach(function(n){d.prototype[n]=function(){if(this._oPopover&&this._oPopover[n]){var r=this._oPopover.getAggregation("_popup")[n].apply(this._oPopover.getAggregation("_popup"),arguments);return r===this._oPopover.getAggregation("_popup")?this:r;}};});["setModel","bindAggregation","setAggregation","insertAggregation","addAggregation","removeAggregation","removeAllAggregation","destroyAggregation"].forEach(function(f){d.prototype["_"+f+"Old"]=d.prototype[f];d.prototype[f]=function(){var n,r;if(["removeAggregation","removeAllAggregation","destroyAggregation"].indexOf(f)!==-1){n=[arguments[0],true];}else{n=[arguments[0],arguments[1],true];}r=d.prototype["_"+f+"Old"].apply(this,n);this._bItemsChanged=true;if(this._oPopover){if(arguments[0]!="pages"){this._oPopover[f].apply(this._oPopover,arguments);}if(this._bRendered){this._initializeQuickView();}}if(["removeAggregation","removeAllAggregation"].indexOf(f)!==-1){return r;}return this;};});return d;});
sap.ui.predefine('sap/m/QuickViewBase',['./library','sap/ui/core/Control',"sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/Focusable"],function(l,C,K,q){"use strict";
var Q=C.extend("sap.m.QuickViewBase",{metadata:{library:"sap.m",properties:{},defaultAggregation:"pages",aggregations:{pages:{type:"sap.m.QuickViewPage",multiple:true,singularName:"page",bindable:"bindable"}},events:{navigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"},navOrigin:{type:"sap.ui.core.Control"}}},afterNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"},isTopPage:{type:"boolean"},navOrigin:{type:"sap.ui.core.Control"}}}}}});
Q.prototype.navigateBack=function(){if(!this._oNavContainer.currentPageIsTopPage()){this._setNavOrigin(null);this._oNavContainer.back();}};
Q.prototype.getNavContainer=function(){return this._oNavContainer;};
Q.prototype._initPages=function(){var n=this._oNavContainer;n.destroyPages();n.init();var p=this.getAggregation("pages");if(!p){return;}var I=this.getId();for(var i=0;i<p.length;i++){var o=p[i];o._oPage=null;var N={hasBackButton:i>0,popover:this._oPopover,navContainer:n,quickViewId:I,quickView:this};o.setNavContext(N);var P=this._createPage(o);this._oNavContainer.addPage(P);}};
Q.prototype._processKeyboard=function(e){if(e.shiftKey&&e.which===K.ENTER){this.navigateBack();e.preventDefault();}};
Q.prototype._createPage=function(o){return o;};
Q.prototype._navigate=function(e){var t=e.getParameter('to');var f=e.getParameter('from');var T=e.getParameter('toId');var F=e.getParameter('fromId');var i=q(document.getElementById(F)).index();var a=q(document.getElementById(T)).index();if(a==-1||a>i){t.addStyleClass('sapMNavItemOffset');}else{f.addStyleClass('sapMNavItemOffset');}f.$().parents('.sapMPanelContent').scrollTop(0);var p=e.getParameters();if(this._navOrigin){p.navOrigin=this._navOrigin;}this.fireNavigate(p);};
Q.prototype._afterNavigate=function(e){var t=e.getParameter('to');var f=e.getParameter('from');var T=e.getParameter('toId');var F=e.getParameter('fromId');var i=q(document.getElementById(F)).index();var a=q(document.getElementById(T)).index();if(a>i){t.removeStyleClass('sapMNavItemOffset');}else{f.removeStyleClass('sapMNavItemOffset');}var p=e.getParameters();p.isTopPage=this._oNavContainer.currentPageIsTopPage();if(this._navOrigin){p.navOrigin=this._navOrigin;}this.fireAfterNavigate(p);this._setLinkWidth();setTimeout(this._restoreFocus.bind(this),0);};
Q.prototype._restoreFocus=function(){var p=this._oNavContainer.getCurrentPage();var f=this._oNavContainer._mFocusObject[p.getId()];if(!f){var c=p.getContent();if(c&&c.length>1){f=c[1].$().firstFocusableDomRef();}}if(f){f.focus();}};
Q.prototype._setLinkWidth=function(){};
Q.prototype._setNavOrigin=function(c){this._navOrigin=c;};
return Q;});
sap.ui.predefine('sap/m/QuickViewCard',['./library','./QuickViewBase','./NavContainer','./Page','./ScrollContainer','./QuickViewCardRenderer'],function(l,Q,N,P,S,a){"use strict";
var b=Q.extend("sap.m.QuickViewCard",{metadata:{library:"sap.m",properties:{showVerticalScrollBar:{type:"boolean",group:"Behavior",defaultValue:true}},designtime:"sap/m/designtime/QuickViewCard.designtime"}});
b.prototype.init=function(){var n={pages:[new P()],navigate:this._navigate.bind(this),afterNavigate:this._afterNavigate.bind(this)};this._oNavContainer=new N(n);};
b.prototype.onBeforeRendering=function(){this._initPages();};
b.prototype.onAfterRendering=function(){this._setLinkWidth();};
b.prototype.exit=function(){if(this._oNavContainer){this._oNavContainer.destroy();}};
b.prototype.onkeydown=function(e){this._processKeyboard(e);};
b.prototype._createPage=function(q){var c=q._createPageContent();q._mPageContent=null;var C=new S(this.getId()+'-'+q.getPageId(),{horizontal:false,vertical:false});if(c.header){C.addContent(c.header);}C.addContent(c.form);C.addStyleClass('sapMQuickViewPage');return C;};
b.prototype._setLinkWidth=function(){this.$().find(".sapMLnk").css("width","auto");};
return b;});
sap.ui.predefine('sap/m/QuickViewGroupElement',['./library','sap/ui/core/Element','./Link','./Text','sap/ui/core/CustomData'],function(l,E,L,T,C){"use strict";var G=l.QuickViewGroupElementType;
var a=E.extend("sap.m.QuickViewGroupElement",{metadata:{library:"sap.m",properties:{visible:{type:"boolean",group:"Appearance",defaultValue:true},label:{type:"string",group:"Misc",defaultValue:""},value:{type:"string",group:"Misc",defaultValue:""},url:{type:"string",group:"Misc",defaultValue:""},target:{type:"string",group:"Misc",defaultValue:"_blank"},type:{type:"sap.m.QuickViewGroupElementType",group:"Misc",defaultValue:G.text},pageLinkId:{type:"string",group:"Misc",defaultValue:""},emailSubject:{type:"string",group:"Misc",defaultValue:""}}}});
a.prototype._getGroupElementValue=function(q){if(!this.getValue()){return null;}switch(this.getType()){case G.email:var h="mailto:"+this.getValue();var s=this.getEmailSubject();if(s){h+='?subject='+s;}return new L({href:h,text:this.getValue(),wrapping:true});case G.phone:case G.mobile:return new L({href:"tel:"+this.getValue(),text:this.getValue()});case G.link:return new L({href:this.getUrl(),text:this.getValue(),target:this.getTarget()});case G.pageLink:var b=this.getPageLinkId();if(q){b=q+'-'+b;}return new L({href:"#",text:this.getValue(),customData:[new C({key:"pageNumber",value:b})]});default:return new T({text:this.getValue()});}};
a.prototype.setProperty=function(n,v){E.prototype.setProperty.call(this,n,v,true);var g=this.getParent();if(!g){return;}var p=g.getParent();if(p){p._updatePage();}};
return a;});
sap.ui.predefine('sap/m/QuickViewPage',['./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/layout/form/SimpleForm','sap/ui/layout/VerticalLayout','sap/ui/layout/HorizontalLayout','./Page','./Button','./Bar','./Title','./Image','./Link','./Text','./Label','./HBox','sap/ui/core/Icon','sap/ui/core/Title','sap/ui/core/CustomData','sap/ui/core/library','sap/ui/layout/library','sap/ui/Device','sap/ui/layout/form/ResponsiveGridLayout','./QuickViewPageRenderer',"sap/base/security/encodeURL"],function(l,C,I,S,V,H,P,B,a,T,b,L,c,d,f,g,h,i,m,n,D,R,Q,o){"use strict";var U=l.URLHelper;var p=n.form.SimpleFormLayout;var q=m.TitleLevel;var r=l.QuickViewGroupElementType;var s=l.ButtonType;
var t=C.extend("sap.m.QuickViewPage",{metadata:{library:"sap.m",properties:{pageId:{type:"string",group:"Misc",defaultValue:""},header:{type:"string",group:"Misc",defaultValue:""},title:{type:"string",group:"Misc",defaultValue:""},titleUrl:{type:"string",group:"Misc",defaultValue:""},crossAppNavCallback:{type:"object",group:"Misc"},description:{type:"string",group:"Misc",defaultValue:""},icon:{type:"string",group:"Misc",defaultValue:""}},defaultAggregation:"groups",aggregations:{groups:{type:"sap.m.QuickViewGroup",multiple:true,singularName:"group",bindable:"bindable"}}}});
t.prototype.init=function(){this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle('sap.m');var G=sap.ushell&&sap.ushell.Container&&sap.ushell.Container.getService;if(G){this.oCrossAppNavigator=G("CrossApplicationNavigation");}};
t.prototype.onBeforeRendering=function(){this._destroyPageContent();this._createPageContent();};
t.prototype.getPageContent=function(){return this._mPageContent;};
t.prototype.setNavContext=function(e){this._mNavContext=e;};
t.prototype.getNavContext=function(){return this._mNavContext;};
t.prototype.setPageTitleControl=function(e){this._oPageTitle=e;};
t.prototype.getPageTitleControl=function(){return this._oPageTitle;};
t.prototype._createPage=function(){var e=this._createPageContent();var N=this.getNavContext();var j;if(this._oPage){j=this._oPage;j.destroyContent();j.setCustomHeader(new a());}else{j=this._oPage=new P(N.quickViewId+'-'+this.getPageId(),{customHeader:new a()});j.addEventDelegate({onAfterRendering:this.onAfterRenderingPage},this);}if(this.getHeader()===""&&N.quickView.getPages().length===1&&!D.system.phone){j.setShowHeader(false);j.addStyleClass('sapMQuickViewPageWithoutHeader');}if(e.header){j.addContent(e.header);}j.addContent(e.form);var k=j.getCustomHeader();k.addContentMiddle(new T({text:this.getHeader()}).addStyleClass("sapMQuickViewTitle"));if(N.hasBackButton){k.addContentLeft(new B({type:s.Back,tooltip:this._oResourceBundle.getText("PAGE_NAVBUTTON_TEXT"),press:function(){if(N.navContainer){N.quickView._setNavOrigin(null);N.navContainer.back();}}}));}if(N.popover&&D.system.phone){k.addContentRight(new B({icon:I.getIconURI("decline"),press:function(){N.popover.close();}}));}j.addStyleClass('sapMQuickViewPage');return j;};
t.prototype.onAfterRenderingPage=function(){if(this._bItemsChanged){var N=this.getNavContext();if(N){N.quickView._restoreFocus();}this._bItemsChanged=false;}};
t.prototype._createPageContent=function(){var F=this._createForm();var e=this._getPageHeaderContent();var j=this.getPageTitleControl();if(e&&j){F.addAriaLabelledBy(j);}this._mPageContent={form:F,header:e};return this._mPageContent;};
t.prototype._createForm=function(){var G=this.getAggregation("groups"),F=new S({maxContainerCols:1,editable:false,layout:p.ResponsiveGridLayout});if(G){for(var j=0;j<G.length;j++){if(G[j].getVisible()){this._renderGroup(G[j],F);}}}return F;};
t.prototype._getPageHeaderContent=function(){var e,v=new V(),j=new H(),k=this.getIcon(),u=this.getTitle(),w=this.getDescription(),x=this.getTitleUrl();if(!k&&!u&&!w){return null;}if(k){if(this.getIcon().indexOf("sap-icon")==0){e=new g({src:k,decorative:!x,useIconTooltip:false,tooltip:u});}else{e=new b({src:k,decorative:false,tooltip:u}).addStyleClass("sapUiIcon");}e.addStyleClass("sapMQuickViewThumbnail");if(x){e.attachPress(this._crossApplicationNavigation(this));}j.addContent(e);}var y;if(x){y=new L({text:u,href:x,target:"_blank"});}else if(this.getCrossAppNavCallback()){y=new L({text:u});y.attachPress(this._crossApplicationNavigation(this));}else{y=new T({text:u,level:q.H1});}this.setPageTitleControl(y);var z=new c({text:w});v.addContent(y);v.addContent(z);j.addContent(v);return j;};
t.prototype._renderGroup=function(G,F){var e=G.getAggregation("elements");var j,u,v;if(G.getHeading()){F.addContent(new h({text:G.getHeading(),level:q.H2}));}if(!e){return;}var N=this.getNavContext();for(var k=0;k<e.length;k++){j=e[k];if(!j.getVisible()){continue;}v=new d({text:j.getLabel()});var w;if(N){w=N.quickViewId;}u=j._getGroupElementValue(w);F.addContent(v);if(!u){F.addContent(new c({text:""}));continue;}v.setLabelFor(u.getId());if(j.getType()==r.pageLink){u.attachPress(this._attachPressLink(this));}if(j.getType()==r.mobile&&!D.system.desktop){var x=new g({src:I.getIconURI("post"),tooltip:this._oResourceBundle.getText("QUICKVIEW_SEND_SMS"),decorative:false,customData:[new i({key:"phoneNumber",value:j.getValue()})],press:this._mobilePress});var y=new f({items:[u,x]});F.addContent(y);}else{F.addContent(u);}}};
t.prototype._crossApplicationNavigation=function(e){return function(){if(e.getCrossAppNavCallback()&&e.oCrossAppNavigator){var j=e.getCrossAppNavCallback();if(typeof j=="function"){var k=j();var u=e.oCrossAppNavigator.hrefForExternal({target:{semanticObject:k.target.semanticObject,action:k.target.action},params:k.params});U.redirect(u);}}else if(e.getTitleUrl()){window.open(e.getTitleUrl(),"_blank");}};};
t.prototype._destroyPageContent=function(){if(!this._mPageContent){return;}if(this._mPageContent.form){this._mPageContent.form.destroy();}if(this._mPageContent.header){this._mPageContent.header.destroy();}this._mPageContent=null;};
t.prototype.exit=function(){this._oResourceBundle=null;if(this._oPage){this._oPage.destroy();this._oPage=null;}else{this._destroyPageContent();}this._mNavContext=null;};
t.prototype._attachPressLink=function(j){var N=j.getNavContext();return function(e){e.preventDefault();var k=this.getCustomData()[0].getValue();if(N.navContainer&&k){N.quickView._setNavOrigin(this);N.navContainer.to(k);}};};
t.prototype._mobilePress=function(){var e="sms://"+o(this.getCustomData()[0].getValue());window.location.replace(e);};
t.prototype._updatePage=function(){var N=this.getNavContext();if(N&&N.quickView._bRendered){this._bItemsChanged=true;N.popover.focus();if(N.quickView.indexOfPage(this)==0){N.quickView._clearContainerHeight();}this._createPage();N.popover.$().css('display','block');N.quickView._adjustContainerHeight();N.quickView._restoreFocus();}};
["setModel","bindAggregation","setAggregation","insertAggregation","addAggregation","removeAggregation","removeAllAggregation","destroyAggregation"].forEach(function(F){t.prototype["_"+F+"Old"]=t.prototype[F];t.prototype[F]=function(){var e=t.prototype["_"+F+"Old"].apply(this,arguments);this._updatePage();if(["removeAggregation","removeAllAggregation"].indexOf(F)!==-1){return e;}return this;};});
t.prototype.setProperty=function(N,v){C.prototype.setProperty.call(this,N,v,true);this._updatePage();};
return t;});
/*
 * !OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/m/ColumnHeaderRenderer',[],function(){"use strict";var C={};
C.render=function(r,c){var s=c.getId();var i=c._isInteractive();r.write("<div");r.writeControlData(c);if(i){r.writeAttribute("tabindex",0);r.writeAttribute("role","button");r.writeAttribute("aria-labelledby",s+"-info");r.addClass("sapMColumnHeaderActive");}r.addClass("sapMColumnHeader");r.writeClasses();r.write(">");this.renderText(r,c);this.renderIcons(r,c);if(i&&sap.ui.getCore().getConfiguration().getAccessibility()){r.write("<span");r.writeAttributeEscaped("id",s+"-info");r.addClass("sapUiInvisibleText");r.writeClasses();r.writeAttributeEscaped("aria-hidden","true");r.write(">");r.writeEscaped(c.getAccessibilityInfo().description);r.write("</span>");}r.write("</div>");};
C.renderText=function(r,c){r.write("<div");r.addClass("sapMColumnHeaderText");r.writeClasses();r.write(">");r.writeEscaped(c.getText());r.write("</div>");};
C.renderIcons=function(r,c){r.write("<div");r.addClass("sapMColumnHeaderIcons");r.writeClasses();r.write(">");this.renderSortIcon(r,c);this.renderFilterIcon(r,c);r.write("</div>");};
C.renderSortIcon=function(r,c){var s=c.getAggregation("_sortIcon");if(!s){return;}r.renderControl(s);};
C.renderFilterIcon=function(r,c){var f=c.getAggregation("_filterIcon");if(!f){return;}r.renderControl(f);};
return C;},true);
/*!
 * @copyright@
 */
sap.ui.predefine('sap/m/NumericContentRenderer',['./library'],function(l){"use strict";var N={};
N.render=function(r,c){var v=c.getValue();var i=c.getIndicator();var s=c.getScale();var S=c.getState();var I=l.DeviationIndicator.None!==i&&v!=="";var w=c.getWithMargin();var W;if(w){W="";}else{W="WithoutMargin";}if(c.getFormatterValue()){var f=c._parseFormattedValue(v);s=f.scale;v=f.value;}var b=s&&v;r.write("<div");r.writeControlData(c);var t=c.getTooltip_AsString();if(typeof t!=="string"){t="";}r.writeAttributeEscaped("aria-label",t);r.writeAttribute("role","img");if(S==l.LoadState.Failed||S==l.LoadState.Loading){r.writeAttribute("aria-disabled","true");}if(c.getAnimateTextChange()){r.addStyle("opacity","0.25");}if(c.getWidth()){r.addStyle("width",c.getWidth());}r.writeStyles();r.addClass("sapMNC");r.addClass(W);if(c.hasListeners("press")){r.writeAttribute("tabindex","0");r.addClass("sapMPointer");}r.writeClasses();r.write(">");r.write("<div");r.addClass("sapMNCInner");r.addClass(W);r.writeClasses();r.write(">");if(w){this._renderScaleAndIndicator(r,c,I,b,W,i,s);this._renderValue(r,c,W,v);}else{this._renderValue(r,c,W,v);this._renderScaleAndIndicator(r,c,I,b,W,i,s);}r.write("</div>");r.write("</div>");};
N._prepareAndRenderIcon=function(r,c,i){if(i){var s,L=l.LoadState,C=c.getState();for(s in L){if(L.hasOwnProperty(s)&&s!==C){i.removeStyleClass(s);}else if(L.hasOwnProperty(s)&&s===C){i.addStyleClass(s);}}i.addStyleClass("sapMNCIconImage");r.renderControl(i);}};
N._renderScaleAndIndicator=function(r,c,i,a,w,t,b){if(i||a){var s=c.getState();var C=c.getValueColor();r.write("<div");r.addClass("sapMNCIndScale");r.addClass(w);r.addClass(s);r.writeClasses();r.write(">");r.write("<div");r.writeAttribute("id",c.getId()+"-indicator");r.addClass("sapMNCIndicator");r.addClass(t);r.addClass(s);r.addClass(C);r.writeClasses();r.write("></div>");if(a){r.write("<div");r.writeAttribute("id",c.getId()+"-scale");r.addClass("sapMNCScale");r.addClass(s);r.addClass(C);r.writeClasses();r.write(">");r.writeEscaped(b.substring(0,3));r.write("</div>");}r.write("</div>");}};
N._renderValue=function(r,c,w,v){var e;if(c.getNullifyValue()){e="0";}else{e="";}r.write("<div");r.writeAttribute("id",c.getId()+"-value");r.addClass("sapMNCValue");r.addClass(w);r.addClass(c.getValueColor());r.addClass(c.getState());r.writeClasses();r.write(">");r.write("<div");r.writeAttribute("id",c.getId()+"-value-scr");r.addClass("sapMNCValueScr");r.addClass(w);r.writeClasses();r.write(">");this._prepareAndRenderIcon(r,c,c._oIcon);var C=c.getTruncateValueTo();if(v.length>=C&&(v[C-1]==="."||v[C-1]===",")){r.writeEscaped(v.substring(0,C-1));}else{if(v){r.writeEscaped(v.substring(0,C));}else{r.writeEscaped(e);}}r.write("</div>");r.write("</div>");};
return N;},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/m/AccButton',['./Button','./AccButtonRenderer'],function(B,A){"use strict";
var a=B.extend("sap.m.AccButton",{metadata:{library:"sap.m",properties:{"tabIndex":{type:"string",defaultValue:null,bindable:"bindable"},"ariaHidden":{type:"string",defaultValue:null,bindable:"bindable"},"ariaHaspopup":{type:"string",defaultValue:null,bindable:"bindable"}}}});
return a;});
sap.ui.predefine('sap/m/AccButtonRenderer',['./ButtonRenderer','sap/ui/core/Renderer'],function(B,R){"use strict";var A=R.extend(B);
A.renderAccessibilityAttributes=function(r,c){if(c.getTabIndex()){r.writeAttribute("tabindex",c.getTabIndex());}if(c.getAriaHidden()){r.writeAttribute("aria-hidden",c.getAriaHidden());}if(c.getAriaHaspopup()){r.writeAttribute("aria-haspopup",c.getAriaHaspopup());}};
return A;},true);
sap.ui.predefine('sap/m/ActionListItem',['./ListItemBase','./library','./ActionListItemRenderer'],function(L,l,A){"use strict";var a=l.ListMode;var b=l.ListType;
var c=L.extend("sap.m.ActionListItem",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:null}}}});
c.prototype.init=function(){this.setType(b.Active);L.prototype.init.apply(this,arguments);};
c.prototype.getMode=function(){return a.None;};
c.prototype.onsapspace=c.prototype.onsapenter;
c.prototype.getContentAnnouncement=function(){return this.getText();};
return c;});
sap.ui.predefine('sap/m/ActionListItemRenderer',['./ListItemBaseRenderer','sap/ui/core/Renderer'],function(L,R){"use strict";var A=R.extend(L);
A.renderLIAttributes=function(r,l){r.addClass("sapMALI");};
A.renderLIContent=function(r,l){var i=l.getText();if(i){r.write("<div class='sapMALIText'>");r.writeEscaped(i);r.write("</div>");}};
return A;},true);
sap.ui.predefine('sap/m/ActionSelect',['./Select','sap/ui/core/InvisibleText','./library','./ActionSelectRenderer'],function(S,I,l,A){"use strict";
var a=S.extend("sap.m.ActionSelect",{metadata:{library:"sap.m",associations:{buttons:{type:"sap.m.Button",multiple:true,singularName:"button"}}}});
a.prototype.init=function(){S.prototype.init.call(this);this.getList().addEventDelegate({onfocusin:this.onfocusinList},this);};
a.prototype.hasContent=function(){return S.prototype.hasContent.call(this)||!!this.getButtons().length;};
a.prototype.addContent=function(){var c=sap.ui.getCore(),p=this.getPicker();this.getButtons().forEach(function(b){p.addContent(c.byId(b));});};
a.prototype._onBeforeRenderingPopover=function(){S.prototype._onBeforeRenderingPopover.call(this);this._updateTutorMessage();};
a.prototype.onAfterRenderingPicker=function(){S.prototype.onAfterRenderingPicker.call(this);var p=this.getPicker(),r=this.getRenderer();p.addStyleClass(r.CSS_CLASS+"Picker");p.addStyleClass(r.ACTION_SELECT_CSS_CLASS+"Picker");p.addStyleClass(r.ACTION_SELECT_CSS_CLASS+"Picker-CTX");};
a.prototype.createPickerCloseButton=function(){};
a.prototype.removeButton=function(b){var p=this.getPicker();if(p){if(typeof b==="number"){b=this.getButtons()[b];}p.removeContent(b);}return this.removeAssociation("buttons",b);};
a.prototype.removeAllButtons=function(){var p=this.getPicker();if(p){this.getButtons().forEach(function(b){p.removeContent(b);});}return this.removeAllAssociation("buttons");};
a.prototype.onsaptabprevious=function(e){var b=this.getButtons(),p=this.getPicker(),i;if(e.isMarked()||!this.getEnabled()){return;}e.setMarked();if(p&&p.isOpen()&&b.length>0){for(i=b.length-1;i>=0;i--){if(sap.ui.getCore().byId(b[i]).getEnabled()){sap.ui.getCore().byId(b[i]).focus();e.preventDefault();break;}}}};
a.prototype.onsaptabnext=function(e){var b=this.getButtons(),p=this.getPicker(),i;if(e.isMarked()||!this.getEnabled()){return;}e.setMarked();if(p&&p.isOpen()&&b.length>0){for(i=0;i<b.length;i++){if(sap.ui.getCore().byId(b[i]).getEnabled()){sap.ui.getCore().byId(b[i]).focus();e.preventDefault();break;}}}};
a.prototype.onsapfocusleave=function(e){var b=this.getButtons();var k=(b.indexOf(e.relatedControlId)==-1);if(k){S.prototype.onsapfocusleave.apply(this,arguments);}this._toggleListFocusIndication(true);};
a.prototype.onfocusinList=function(e){if(document.activeElement!==this.getList().getDomRef()){this.focus();}};
a.prototype.onfocusin=function(){S.prototype.onfocusin.apply(this,arguments);this._toggleListFocusIndication(false);};
a.prototype._toggleListFocusIndication=function(r){var s=this.getSelectedItem();if(this.isOpen()&&s){s.$().toggleClass("sapMActionSelectItemWithoutFocus",r);}};
a.prototype._updateTutorMessage=function(){var p=this.getPicker(),b=p.getAriaLabelledBy(),h=!!this.getButtons().length,t;if(!this._sTutorMessageId){this._sTutorMessageId=this._getTutorMessageId();this._oTutorMessageText=new I(this._sTutorMessageId,{text:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACTION_SELECT_TUTOR_MESSAGE")}).toStatic();}t=(b.indexOf(this._sTutorMessageId)===-1);if(t&&h){p.addAriaLabelledBy(this._sTutorMessageId);}else{if(!h){p.removeAriaLabelledBy(this._sTutorMessageId);}}};
a.prototype._getTutorMessageId=function(){return this.getId()+"-tutorMessage";};
a.prototype.exit=function(){if(this._oTutorMessageText){this._oTutorMessageText.destroy();this._oTutorMessageText=null;}};
return a;});
sap.ui.predefine('sap/m/ActionSelectRenderer',['sap/ui/core/Renderer','./SelectRenderer'],function(R,S){"use strict";var A=R.extend(S);A.ACTION_SELECT_CSS_CLASS="sapMActionSelect";
A.addClass=function(r,a){r.addClass(A.ACTION_SELECT_CSS_CLASS);};
return A;},true);
sap.ui.predefine('sap/m/ActionSheet',['./Dialog','./Popover','./library','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','sap/ui/core/InvisibleText','sap/ui/base/ManagedObject','sap/ui/Device','./ActionSheetRenderer',"sap/ui/thirdparty/jquery"],function(D,P,l,C,I,a,M,b,A,q){"use strict";var B=l.ButtonType;var c=l.DialogType;var d=l.PlacementType;
var e=C.extend("sap.m.ActionSheet",{metadata:{library:"sap.m",properties:{placement:{type:"sap.m.PlacementType",group:"Appearance",defaultValue:d.Bottom},showCancelButton:{type:"boolean",group:"Appearance",defaultValue:true},cancelButtonText:{type:"string",group:"Appearance",defaultValue:null},title:{type:"string",group:"Appearance",defaultValue:null}},aggregations:{buttons:{type:"sap.m.Button",multiple:true,singularName:"button"},_cancelButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_invisibleAriaTexts:{type:"sap.ui.core.InvisibleText",multiple:true,visibility:"hidden"}},defaultAggregation:"buttons",events:{cancelButtonTap:{deprecated:true},beforeOpen:{},afterOpen:{},beforeClose:{origin:{type:"sap.m.Button"}},afterClose:{origin:{type:"sap.m.Button"}},cancelButtonPress:{}},designtime:"sap/m/designtime/ActionSheet.designtime"}});
e.prototype.init=function(){this._fnOrientationChange=this._orientationChange.bind(this);};
e.prototype.exit=function(){b.resize.detachHandler(this._fnOrientationChange);if(this._parent){this._parent.destroy();this._parent=null;}if(this._oCancelButton){this._oCancelButton.destroy();this._oCancelButton=null;}this._clearItemNavigation();};
e.prototype._clearItemNavigation=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}};
e.prototype._setItemNavigation=function(){var f=this._getAllButtons(),g=[],o=this.getDomRef();if(o){this._oItemNavigation.setRootDomRef(o);for(var i=0;i<f.length;i++){if(f[i].getEnabled()&&f[i].getVisible()){g.push(f[i].getFocusDomRef());}}if(this._oCancelButton){g.push(this._oCancelButton.getFocusDomRef());}this._oItemNavigation.setItemDomRefs(g);this._oItemNavigation.setSelectedIndex(0);this._oItemNavigation.setPageSize(5);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"]});}};
e.prototype.onBeforeRendering=function(){this._clearItemNavigation();};
e.prototype.onAfterRendering=function(){this._oItemNavigation=new I();this._oItemNavigation.setCycling(false);this.addDelegate(this._oItemNavigation);this._setItemNavigation();};
e.prototype.sapfocusleave=function(){this.close();};
e.prototype.openBy=function(o){var t=this;if(!this._parent){var O=this.getParent();if(O){this.setParent(null);}if(!b.system.phone){this._parent=new P({placement:this.getPlacement(),showHeader:false,content:[this],beforeOpen:function(){t.fireBeforeOpen();},afterOpen:function(){t.focus();t.fireAfterOpen();},beforeClose:function(){t.fireBeforeClose();},afterClose:function(){if(t.getShowCancelButton()){t.fireCancelButtonTap();t.fireCancelButtonPress();}t.fireAfterClose();},ariaLabelledBy:this.getPopupHiddenLabelId()||undefined}).addStyleClass("sapMActionSheetPopover");if(b.browser.internet_explorer){this._parent._fnAdjustPositionAndArrow=q.proxy(function(){P.prototype._adjustPositionAndArrow.apply(this);var $=this.$(),f=$.children(".sapMPopoverCont")[0].getBoundingClientRect().width;q.each($.find(".sapMActionSheet > .sapMBtn"),function(i,g){var h=q(g),j;h.css("width","");j=g.getBoundingClientRect().width;if(j<=f){h.css("width","100%");}});},this._parent);}}else{this._parent=new D({title:this.getTitle(),type:c.Standard,content:[this],beforeOpen:function(){t.fireBeforeOpen();},afterOpen:function(){t.focus();t.fireAfterOpen();},beforeClose:function(E){t.fireBeforeClose({origin:E.getParameter("origin")});},afterClose:function(E){t.fireAfterClose({origin:E.getParameter("origin")});b.resize.detachHandler(t._fnOrientationChange);}}).addStyleClass("sapMActionSheetDialog");if(this.getTitle()){this._parent.addStyleClass("sapMActionSheetDialogWithTitle");}else{this._parent.addAriaLabelledBy(this.getPopupHiddenLabelId()||undefined);}if(!b.system.phone){this._parent.setBeginButton(this._getCancelButton());}if(b.system.phone){this._parent.oPopup.setModal(true);this._parent._setDimensions=function(){D.prototype._setDimensions.apply(this);this.$("cont").css("max-height","");};this._parent._adjustScrollingPane=function(){var h=this.$().height();this.$("cont").css("max-height",h);if(this._oScroller){this._oScroller.refresh();}};}}if(O){O.addDependent(this._parent);}}if(!b.system.phone){this._parent.openBy(o);}else{this._parent.open();b.resize.attachHandler(this._fnOrientationChange);}};
e.prototype.close=function(o){if(this._parent){this._parent.close();}};
e.prototype.isOpen=function(o){return!!this._parent&&this._parent.isOpen();};
e.prototype._createCancelButton=function(){if(!this._oCancelButton){var s=(this.getCancelButtonText())?this.getCancelButtonText():sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACTIONSHEET_CANCELBUTTON_TEXT"),t=this;this._oCancelButton=new sap.m.Button(this.getId()+'-cancelBtn',{text:s,type:B.Reject,press:function(){if(b.system.phone&&t._parent){t._parent._oCloseTrigger=this;}t.close();t.fireCancelButtonTap();t.fireCancelButtonPress();}}).addStyleClass("sapMActionSheetButton sapMActionSheetCancelButton sapMBtnTransparent sapMBtnInverted");if(b.system.phone){this.setAggregation("_cancelButton",this._oCancelButton,true);}}return this;};
e.prototype._getCancelButton=function(){if(b.system.phone&&this.getShowCancelButton()){this._createCancelButton();return this._oCancelButton;}return null;};
e.prototype.setCancelButtonText=function(t){this.setProperty("cancelButtonText",t,true);if(this._oCancelButton){this._oCancelButton.setText(t);}return this;};
e.prototype._preProcessActionButton=function(o){var t=o.getType();if(t!==B.Accept&&t!==B.Reject){o.setType(B.Transparent);}o.addStyleClass("sapMBtnInverted");this._parent&&this._parent.invalidate();return this;};
e.prototype.setShowCancelButton=function(v){if(this._parent){if(b.system.phone){this.setProperty("showCancelButton",v,false);}}else{this.setProperty("showCancelButton",v,true);}return this;};
e.prototype.setTitle=function(t){this.setProperty("title",t,true);if(this._parent&&b.system.phone){this._parent.setTitle(t);this._parent.toggleStyleClass("sapMDialog-NoHeader",!t);}if(this._parent){if(t){this._parent.addStyleClass("sapMActionSheetDialogWithTitle");}else{this._parent.removeStyleClass("sapMActionSheetDialogWithTitle");}}return this;};
e.prototype.setPlacement=function(p){this.setProperty("placement",p,true);if(!b.system.phone){if(this._parent){this._parent.setPlacement(p);}}return this;};
e.prototype._buttonSelected=function(){if(b.system.phone&&this._parent){this._parent._oCloseTrigger=this;}this.close();};
e.prototype._orientationChange=function(){this._parent._adjustScrollingPane();};
e.prototype._addAriaHiddenTexts=function(o){var s=o.getId(),i;if(sap.ui.getCore().getConfiguration().getAccessibility()){i=new a(s+"-actionSheetHiddenText");this.addAggregation("_invisibleAriaTexts",i,false);o.addAriaLabelledBy(i.getId());}};
e.prototype._removeAriaHiddenTexts=function(o){o.getAriaLabelledBy().forEach(function(i){var f=sap.ui.getCore().byId(i);if(f instanceof a&&i.indexOf("actionSheetHiddenText")>-1){this.removeAggregation("_invisibleAriaTexts",f,false);o.removeAriaLabelledBy(f);f.destroy();}},this);};
e.prototype.addButton=function(o){this.addAggregation("buttons",o,false);this._addAriaHiddenTexts(o);this._preProcessActionButton(o);o.attachPress(this._buttonSelected,this);return this;};
e.prototype.insertButton=function(o,i){this.insertAggregation("buttons",o,i,false);this._addAriaHiddenTexts(o);this._preProcessActionButton(o);o.attachPress(this._buttonSelected,this);return this;};
e.prototype.removeButton=function(o){var r=this.removeAggregation("buttons",o,false);if(r){r.detachPress(this._buttonSelected,this);this._removeAriaHiddenTexts(r);}return r;};
e.prototype.removeAllButtons=function(){var r=this.removeAllAggregation("buttons",false),t=this;q.each(r,function(i,o){o.detachPress(t._buttonSelected,t);t._removeAriaHiddenTexts(o);});return r;};
e.prototype.clone=function(){var f=this.getButtons();for(var i=0;i<f.length;i++){f[i].detachPress(this._buttonSelected,this);}var o=C.prototype.clone.apply(this,arguments);for(var j=0;j<f.length;j++){f[j].attachPress(this._buttonSelected,this);}return o;};
e.prototype._getAllButtons=function(){return this.getButtons();};
e.prototype.getPopupHiddenLabelId=function(){return a.getStaticId("sap.m","ACTIONSHEET_AVAILABLE_ACTIONS");};
e.prototype._applyContextualSettings=function(){M.prototype._applyContextualSettings.call(this,M._defaultContextualSettings);};
return e;});
sap.ui.predefine('sap/m/ActionSheetRenderer',["sap/ui/Device"],function(D){"use strict";var A={};
A.render=function(r,c){var a=c._getAllButtons(),I=c.getAggregation("_invisibleAriaTexts"),R=sap.ui.getCore().getLibraryResourceBundle('sap.m'),b=a.length,d=sap.ui.getCore().getConfiguration().getAccessibility(),v=a.filter(function(B){return B.getVisible();}).length,C,i,m,B,V=1,g=function(o){return I.filter(function(e){return e.getId().indexOf(o.getId())>-1;})[0];};for(i=0;i<b;i++){B=a[i];B.removeStyleClass("sapMActionSheetButtonNoIcon");if(B.getIcon()&&B.getVisible()){m=true;}else{B.addStyleClass("sapMActionSheetButtonNoIcon");}}r.write("<div");r.writeControlData(c);r.addClass("sapMActionSheet");if(m){r.addClass("sapMActionSheetMixedButtons");}r.writeClasses();var t=c.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}d&&r.writeAttributeEscaped("role","presentation");r.write(">");for(i=0;i<b;i++){B=a[i];r.renderControl(a[i].addStyleClass("sapMActionSheetButton"));if(d&&B.getVisible()){C=g(B);if(C){C.setText(R.getText('ACTIONSHEET_BUTTON_INDEX',[V,v]));r.renderControl(C);}V++;}}if(D.system.phone&&c.getShowCancelButton()){r.renderControl(c._getCancelButton());}r.write("</div>");};
return A;},true);
sap.ui.predefine('sap/m/App',['./NavContainer','./library','./AppRenderer','sap/ui/base/DataType',"sap/ui/util/Mobile","sap/base/Log","sap/ui/thirdparty/jquery"],function(N,l,A,D,M,L,q){"use strict";
var a=N.extend("sap.m.App",{metadata:{library:"sap.m",properties:{homeIcon:{type:"any",group:"Misc",defaultValue:null},backgroundColor:{type:"string",group:"Appearance",defaultValue:null},backgroundImage:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},backgroundRepeat:{type:"boolean",group:"Appearance",defaultValue:false},backgroundOpacity:{type:"float",group:"Appearance",defaultValue:1},mobileWebAppCapable:{type:"boolean",group:"Appearance",defaultValue:true}},events:{orientationChange:{deprecated:true,parameters:{landscape:{type:"boolean"}}}}}});
a.prototype.init=function(){N.prototype.init.apply(this,arguments);this.addStyleClass("sapMApp");M.init({viewport:!this._debugZoomAndScroll,statusBar:"default",hideBrowser:true,preventScroll:!this._debugZoomAndScroll,rootId:this.getId()});q(window).bind("resize",q.proxy(this._handleOrientationChange,this));};
a.prototype.onBeforeRendering=function(){if(N.prototype.onBeforeRendering){N.prototype.onBeforeRendering.apply(this,arguments);}M.init({homeIcon:this.getHomeIcon(),mobileWebAppCapable:this.getMobileWebAppCapable()});};
a.prototype.onAfterRendering=function(){if(N.prototype.onAfterRendering){N.prototype.onAfterRendering.apply(this,arguments);}var r=this.getDomRef().parentNode;while(r&&r!==document.documentElement){var $=q(r);if($.attr("data-sap-ui-root-content")){break;}if(!r.style.height){r.style.height="100%";}r=r.parentNode;}};
a.prototype.exit=function(){q(window).unbind("resize",this._handleOrientationChange);if(this._sInitTimer){clearTimeout(this._sInitTimer);}};
a.prototype._handleOrientationChange=function(){var $=q(window);var i=$.width()>$.height();if(this._oldIsLandscape!==i){this.fireOrientationChange({landscape:i});this._oldIsLandscape=i;}};
a.prototype.setBackgroundOpacity=function(o){if(o>1||o<0){L.warning("Invalid value "+o+" for App.setBackgroundOpacity() ignored. Valid values are: floats between 0 and 1.");return this;}this.$("BG").css("opacity",o);return this.setProperty("backgroundOpacity",o,true);};
a.prototype._getValidatedBackgroundColor=function(){var b=this.getBackgroundColor();if(!D.getType("sap.ui.core.CSSColor").isValid(b)){b="";}return b;};
return a;});
sap.ui.predefine('sap/m/AppRenderer',['./NavContainerRenderer','sap/ui/core/Renderer','sap/m/library'],function(N,R,l){"use strict";var B=l.BackgroundHelper;var A={};var A=R.extend(N);
A.renderAttributes=function(r,c){B.addBackgroundColorStyles(r,c._getValidatedBackgroundColor(),c.getBackgroundImage());};
A.renderBeforeContent=function(r,c){B.renderBackgroundImageTag(r,c,"sapMAppBG",c.getBackgroundImage(),c.getBackgroundRepeat(),c.getBackgroundOpacity());};
return A;},true);
sap.ui.predefine('sap/m/AssociativeOverflowToolbar',['sap/base/Log','./OverflowToolbar','./OverflowToolbarRenderer','./Toolbar','sap/ui/Device'],function(L,O,a,T,D){"use strict";
var A=O.extend("sap.m.AssociativeOverflowToolbar",{
metadata:{associations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}},
renderer:a
});
A.prototype.getContent=function(){var b=this.getAssociation("content")||[];return b.map(function(c){return sap.ui.getCore().byId(c);});};
A.prototype.insertContent=function(c,I){var s=c.getId(),b=this.getAssociation("content").filter(function(d){return d!==s;});var i;if(I<0){i=0;}else if(I>b.length){i=b.length;}else{i=I;}if(i!==I){L.warning("AssociativeOverflowToolbar.insertContent: index '"+I+"' out of range [0,"+b.length+"], forced to "+i);}b.splice(i,0,s);this.removeAllAssociation("content");b.forEach(function(d){this.addAssociation("content",d);},this);return this;};
A.prototype.exit=function(){O.prototype.exit.apply(this,arguments);return this._callToolbarMethod('destroyContent',[true]);};
A.prototype.indexOfContent=function(c){var b=this.getAssociation("content")||[];return b.indexOf(c.getId());};
A.prototype._handleResize=function(){if(D.system.phone){this._resetAndInvalidateToolbar();}else{this._bControlsInfoCached=false;O.prototype._handleResize.apply(this,arguments);}};
A.prototype._callToolbarMethod=function(f,b){switch(f){case'addContent':return this.addAssociation("content",b[0]);case'getContent':return this.getContent();case'insertContent':return this.insertContent(b[0],b[1]);case'removeContent':return sap.ui.getCore().byId(this.removeAssociation("content",b[0],b[1],b[2]))||null;case'destroyContent':this.removeAllAssociation("content",b[0]);return this;case'removeAllContent':return this.removeAllAssociation("content",b[0]).map(function(c){return sap.ui.getCore().byId(c);});default:return T.prototype[f].apply(this,b);}};
return A;});
sap.ui.predefine('sap/m/Bar',['./BarInPageEnabler','./library','sap/ui/core/Control','sap/ui/core/ResizeHandler','sap/ui/Device','./BarRenderer',"sap/ui/thirdparty/jquery"],function(B,l,C,R,D,a,q){"use strict";var b=l.BarDesign;
var c=C.extend("sap.m.Bar",{metadata:{interfaces:["sap.m.IBar"],library:"sap.m",properties:{enableFlexBox:{type:"boolean",group:"Misc",defaultValue:false,deprecated:true},translucent:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},design:{type:"sap.m.BarDesign",group:"Appearance",defaultValue:b.Auto}},aggregations:{contentLeft:{type:"sap.ui.core.Control",multiple:true,singularName:"contentLeft"},contentMiddle:{type:"sap.ui.core.Control",multiple:true,singularName:"contentMiddle"},contentRight:{type:"sap.ui.core.Control",multiple:true,singularName:"contentRight"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designtime:"sap/m/designtime/Bar.designtime",dnd:{draggable:false,droppable:true}}});
c.prototype.onBeforeRendering=function(){this._removeAllListeners();};
c.prototype.onAfterRendering=function(){this._handleResize();};
c.prototype.init=function(){this.data("sap-ui-fastnavgroup","true",true);};
c.prototype.exit=function(){this._removeAllListeners();if(this._oflexBox){this._oflexBox.destroy();this._oflexBox=null;}this._$MidBarPlaceHolder=null;this._$RightBar=null;this._$LeftBar=null;};
c._aResizeHandlers=["_sResizeListenerId","_sResizeListenerIdMid","_sResizeListenerIdRight","_sResizeListenerIdLeft"];
c.prototype._removeAllListeners=function(){var t=this;c._aResizeHandlers.forEach(function(i){t._removeListenerFailsave(i);});};
c.prototype._removeListenerFailsave=function(L){if(this[L]){R.deregister(this[L]);this[L]=null;}};
c.prototype._handleResize=function(){this._removeAllListeners();var e=!!this.getContentLeft().length,f=!!this.getContentMiddle().length,g=!!this.getContentRight().length;if(!this.getVisible()){return;}if(!e&&!f&&!g){return;}this._$LeftBar=this.$("BarLeft");this._$RightBar=this.$("BarRight");this._$MidBarPlaceHolder=this.$("BarPH");this._updatePosition(e,f,g);this._sResizeListenerId=R.register(this.getDomRef(),q.proxy(this._handleResize,this));if(this.getEnableFlexBox()){return;}if(e){this._sResizeListenerIdLeft=R.register(this._$LeftBar[0],q.proxy(this._handleResize,this));}if(f){this._sResizeListenerIdMid=R.register(this._$MidBarPlaceHolder[0],q.proxy(this._handleResize,this));}if(g){this._sResizeListenerIdRight=R.register(this._$RightBar[0],q.proxy(this._handleResize,this));}};
c.prototype._updatePosition=function(e,f,g){if(!e&&!g&&f){return;}if(e&&!f&&!g){return;}if(!e&&!f&&g){return;}var i=this.$().outerWidth(true);this._$RightBar.css({width:""});this._$LeftBar.css({width:""});this._$MidBarPlaceHolder.css({position:"",width:"",visibility:'hidden'});var r=this._$RightBar.outerWidth(true);if(r>i){if(e){this._$LeftBar.css({width:"0px"});}if(f){this._$MidBarPlaceHolder.css({width:"0px"});}this._$RightBar.css({width:i+"px"});return;}var L=this._getBarContainerWidth(this._$LeftBar);if(i<(L+r)){L=i-r;this._$LeftBar.css({width:L+"px"});this._$MidBarPlaceHolder.css({width:"0px"});return;}this._$MidBarPlaceHolder.css(this._getMidBarCss(r,i,L));};
c.prototype._getMidBarCss=function(r,i,L){var m=this._$MidBarPlaceHolder.outerWidth(true),e=sap.ui.getCore().getConfiguration().getRTL(),s=e?"right":"left",M={visibility:""};if(this.getEnableFlexBox()){m=i-L-r-parseInt(this._$MidBarPlaceHolder.css('margin-left'))-parseInt(this._$MidBarPlaceHolder.css('margin-right'));M.position="absolute";M.width=m+"px";M[s]=L;return M;}var S=i-L-r,f=(i/2)-(m/2),g=L>f,h=(i/2)+(m/2),j=(i-r)<h;if(S>0&&(g||j)){M.position="absolute";M.width=S+"px";M.left=e?r:L;}return M;};
c.prototype._getBarContainerWidth=function($){var i,e=0,f=$.children(),g=0;if(D.browser.webkit||D.browser.firefox||D.browser.edge){for(i=0;i<f.length;i++){g+=q(f[i]).outerWidth(true);}e=$.outerWidth(true);}else{var o;for(i=0;i<f.length;i++){o=window.getComputedStyle(f[i]);if(o.width=="auto"){g+=q(f[i]).width()+1;}else{g+=parseFloat(o.width);}g+=parseFloat(o.marginLeft);g+=parseFloat(o.marginRight);g+=parseFloat(o.paddingLeft);g+=parseFloat(o.paddingRight);}var h=window.getComputedStyle($[0]);e+=parseFloat(h.width);e+=parseFloat(h.marginLeft);e+=parseFloat(h.marginRight);e+=parseFloat(h.paddingLeft);e+=parseFloat(h.paddingRight);}if(e<g){e=g;}return e;};
var d=B.extend("sap.m.BarInAnyContentEnabler",{});
d.mContexts={dialogFooter:{contextClass:"sapMFooter-CTX",tag:"Footer"}};
d.prototype.getContext=function(){var p=B.prototype.getContext.call();for(var k in d.mContexts){p[k]=d.mContexts[k];}return p;};
c.prototype.getContext=d.prototype.getContext;c.prototype.isContextSensitive=d.prototype.isContextSensitive;c.prototype.setHTMLTag=d.prototype.setHTMLTag;c.prototype.getHTMLTag=d.prototype.getHTMLTag;c.prototype.applyTagAndContextClassFor=d.prototype.applyTagAndContextClassFor;c.prototype._applyContextClassFor=d.prototype._applyContextClassFor;c.prototype._applyTag=d.prototype._applyTag;c.prototype._getContextOptions=d.prototype._getContextOptions;c.prototype._setRootAccessibilityRole=d.prototype._setRootAccessibilityRole;c.prototype._getRootAccessibilityRole=d.prototype._getRootAccessibilityRole;return c;});
sap.ui.predefine('sap/m/BarInPageEnabler',['sap/ui/base/Object','sap/m/library',"sap/base/Log"],function(O,l,L){"use strict";var I=l.IBarHTMLTag;var c={footer:{contextClass:"sapMFooter-CTX sapContrast sapContrastPlus",tag:"Footer",internalAriaLabel:"BAR_ARIA_DESCRIPTION_FOOTER"},header:{contextClass:"sapMHeader-CTX",tag:"Header",internalAriaLabel:"BAR_ARIA_DESCRIPTION_HEADER"},subheader:{contextClass:"sapMSubHeader-CTX",tag:"Header",internalAriaLabel:"BAR_ARIA_DESCRIPTION_SUBHEADER"}};var a="sapMIBar";
var B=O.extend("sap.m.BarInPageEnabler",{
isContextSensitive:function(){return this.getDesign&&this.getDesign()==="Auto";},
setHTMLTag:function(n){if(n===this.sTag){return this;}this.sTag=n;return this;},
getHTMLTag:function(){if(!this.hasOwnProperty("sTag")){this.sTag=I.Div;}return this.sTag;},
getContext:function(){return c;},
_getRootAccessibilityRole:function(){var r=this._sRootAccessibilityRole||"toolbar";return r;},
_setRootAccessibilityRole:function(r){this._sRootAccessibilityRole=r;return this;},
applyTagAndContextClassFor:function(C){this._applyTag(C);return this._applyContextClassFor(C);},
_applyContextClassFor:function(C){var o=this._getContextOptions(C);if(!o){return this;}if(!this.isContextSensitive){L.error("The bar control you are using does not implement all the members of the IBar interface",this);return this;}if(!this.getRenderer().shouldAddIBarContext()){this.addStyleClass(a+"-CTX");}if(this.isContextSensitive()){this.addStyleClass(o.contextClass);}return this;},
_applyTag:function(C){var o=this._getContextOptions(C);if(!o){return this;}if(!this.setHTMLTag){L.error("The bar control you are using does not implement all the members of the IBar interface",this);return this;}this.setHTMLTag(o.tag);return this;},
_getContextOptions:function(C){var o;if(this.getContext){o=this.getContext();}else{o=c;}var b=o[C];if(!b){L.error("The context "+C+" is not known",this);return null;}return b;},
render:function(r,C){var t=C.getHTMLTag().toLowerCase();r.write("<"+t);r.addClass(a);if(this.shouldAddIBarContext(C)){r.addClass(a+"-CTX");}r.writeControlData(C);B.renderTooltip(r,C);this.decorateRootElement(r,C);r.writeClasses();r.writeStyles();r.write(">");this.renderBarContent(r,C);r.write("</"+t+">");}
});
B.renderTooltip=function(r,C){var t=C.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}};
B.addChildClassTo=function(C){C.addStyleClass("sapMBarChild");};
return B;});
sap.ui.predefine('sap/m/BarRenderer',['./BarInPageEnabler','sap/ui/Device',"sap/base/Log"],function(B,D,L){"use strict";var a={};a.render=B.prototype.render;
a.decorateRootElement=function(r,c){r.addClass("sapMBar");r.addClass(this.getContext(c));r.writeAccessibilityState(c,{"role":c._getRootAccessibilityRole()});if(c.getTranslucent()&&D.support.touch){r.addClass("sapMBarTranslucent");}r.addClass("sapMBar-CTX");};
a.shouldAddIBarContext=function(){return true;};
a.renderBarContent=function(r,c){var C="</div>";r.write("<div id='"+c.getId()+"-BarLeft' ");r.addClass('sapMBarLeft');r.addClass('sapMBarContainer');r.writeClasses();w("left",r,c);r.write(">");this.renderAllControls(c.getContentLeft(),r,c);r.write(C);r.write("<div id='"+c.getId()+"-BarMiddle' ");r.addClass('sapMBarMiddle');r.writeClasses();r.write(">");if(c.getEnableFlexBox()){c._oflexBox=c._oflexBox||new sap.m.HBox(c.getId()+"-BarPH",{alignItems:"Center"}).addStyleClass("sapMBarPH").setParent(c,null,true);var b=!!c.getContentLeft().length,d=!!c.getContentMiddle().length,e=!!c.getContentRight().length;if(d&&!b&&!e){c._oflexBox.addStyleClass("sapMBarFlexBoxWidth100");}c.getContentMiddle().forEach(function(m){c._oflexBox.addItem(m);});r.renderControl(c._oflexBox);}else{r.write("<div id='"+c.getId()+"-BarPH' ");r.addClass('sapMBarPH');r.addClass('sapMBarContainer');w("middle",r,c);r.writeClasses();r.write(">");this.renderAllControls(c.getContentMiddle(),r,c);r.write(C);}r.write(C);r.write("<div id='"+c.getId()+"-BarRight'");r.addClass('sapMBarRight');r.addClass('sapMBarContainer');if(sap.ui.getCore().getConfiguration().getRTL()){r.addClass("sapMRTL");}r.writeClasses();w("right",r,c);r.write(">");this.renderAllControls(c.getContentRight(),r,c);r.write(C);};
a.renderAllControls=function(c,r,b){c.forEach(function(C){B.addChildClassTo(C,b);r.renderControl(C);});};
a._mContexts={Header:"sapMHeader-CTX",SubHeader:"sapMSubHeader-CTX",Footer:"sapMFooter-CTX",Default:"sapMContent-CTX"};
a.getContext=function(c){var d=c.getDesign(),C=a._mContexts;return C[d]||C.Default;};
function w(A,r,c){var C=!!c.getContentLeft().length,b=!!c.getContentMiddle().length,d=!!c.getContentRight().length;function e(){r.addStyle("width","100%");r.writeStyles();}switch(A.toLowerCase()){case"left":if(C&&!b&&!d){e();}break;case"middle":if(b&&!C&&!d){e();}break;case"right":if(d&&!C&&!b){e();}break;default:L.error("Cannot determine which of the three content aggregations is alone");}}
return a;},true);
sap.ui.predefine('sap/m/Breadcrumbs',["sap/ui/core/Control","sap/m/Text","sap/m/Link","sap/m/Select","sap/ui/core/Item","sap/ui/core/delegate/ItemNavigation","sap/ui/core/ResizeHandler","sap/ui/core/IconPool","sap/ui/Device","sap/m/library","./BreadcrumbsRenderer"],function(C,T,L,S,I,a,R,b,D,l,B){"use strict";var c=l.SelectType;
var d=C.extend("sap.m.Breadcrumbs",{metadata:{library:"sap.m",interfaces:["sap.m.IBreadcrumbs"],designtime:"sap/m/designtime/Breadcrumbs.designtime",properties:{currentLocationText:{type:"string",group:"Behavior",defaultValue:null}},aggregations:{links:{type:"sap.m.Link",multiple:true,singularName:"link"},_currentLocation:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_select:{type:"sap.m.Select",multiple:false,visibility:"hidden"}},defaultAggregation:"links"}});
d.prototype.onBeforeRendering=function(){this.bRenderingPhase=true;if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._bControlsInfoCached){this._updateSelect(true);}};
d.prototype.onAfterRendering=function(){if(!this._sResizeListenerId){this._sResizeListenerId=R.register(this,this._handleScreenResize.bind(this));}if(!this._bControlsInfoCached){this._updateSelect(true);return;}this._configureKeyboardHandling();this.bRenderingPhase=false;};
d.prototype.onThemeChanged=function(){this._resetControl();};
d.prototype.exit=function(){this._resetControl();this._destroyItemNavigation();};
d.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;
d.prototype._getAugmentedId=function(s){return this.getId()+"-"+s;};
d.prototype._getSelect=function(){if(!this.getAggregation("_select")){this.setAggregation("_select",this._decorateSelect(new S({id:this._getAugmentedId("select"),change:this._selectChangeHandler.bind(this),forceSelection:false,autoAdjustWidth:true,icon:b.getIconURI("slim-arrow-down"),type:c.IconOnly,tooltip:B._getResourceBundleText("BREADCRUMB_SELECT_TOOLTIP")})));}return this.getAggregation("_select");};
d.prototype._getCurrentLocation=function(){if(!this.getAggregation("_currentLocation")){this.setAggregation("_currentLocation",new T({id:this._getAugmentedId("currentText"),text:this.getCurrentLocationText(),wrapping:false}).addStyleClass("sapMBreadcrumbsCurrentLocation"));}return this.getAggregation("_currentLocation");};
function f(A,e){var g=Array.prototype.slice.apply(e);g.unshift(A);return g;}
d.prototype.insertLink=function(o,i){var r=this.insertAggregation.apply(this,f("links",arguments));this._registerControlListener(o);this._resetControl();return r;};
d.prototype.addLink=function(o){var r=this.addAggregation.apply(this,f("links",arguments));this._registerControlListener(o);this._resetControl();return r;};
d.prototype.removeLink=function(o){var r=this.removeAggregation.apply(this,f("links",arguments));this._deregisterControlListener(r);this._resetControl();return r;};
d.prototype.removeAllLinks=function(){var e=this.getAggregation("links",[]);var r=this.removeAllAggregation.apply(this,f("links",arguments));e.forEach(this._deregisterControlListener,this);this._resetControl();return r;};
d.prototype.destroyLinks=function(){var e=this.getAggregation("links",[]);var r=this.destroyAggregation.apply(this,f("links",arguments));e.forEach(this._deregisterControlListener,this);this._resetControl();return r;};
d.prototype._decorateSelect=function(s){s.getPicker().attachAfterOpen(this._removeItemNavigation,this).attachBeforeClose(this._restoreItemNavigation,this);s._onBeforeOpenDialog=this._onSelectBeforeOpenDialog.bind(this);s._onBeforeOpenPopover=this._onSelectBeforeOpenPopover.bind(this);s.onsapescape=this._onSelectEscPress.bind(this);return s;};
d.prototype._removeItemNavigation=function(){this.removeDelegate(this._getItemNavigation());};
d.prototype._onSelectBeforeOpenDialog=function(){var s=this._getSelect();if(this.getCurrentLocationText()&&D.system.phone){s.setSelectedIndex(0);}else{s.setSelectedItem(null);}S.prototype._onBeforeOpenDialog.call(s);this._removeItemNavigation();};
d.prototype._onSelectBeforeOpenPopover=function(){this._getSelect().setSelectedItem(null);this._removeItemNavigation();};
d.prototype._restoreItemNavigation=function(){this.addDelegate(this._getItemNavigation());};
d.prototype._onSelectEscPress=function(){this._getSelect().close();};
d.prototype._createSelectItem=function(i){return new I({key:i.getId(),text:i.getText()});};
d.prototype._selectChangeHandler=function(e){var o,s,g,h=e.getParameter("selectedItem");if(!h){return;}if(!this._getSelect().isOpen()){return;}o=sap.ui.getCore().byId(h.getKey());if(!(o instanceof L)){return;}s=o.getHref();g=o.getTarget();o.firePress();if(s){if(g){window.open(s,g);}else{window.location.href=s;}}};
d.prototype._getItemsForMobile=function(){var i=this.getLinks();if(this.getCurrentLocationText()){i.push(this._getCurrentLocation());}return i;};
d.prototype._updateSelect=function(i){var s=this._getSelect(),e,o=this._getControlDistribution();if(!this._bControlDistributionCached||i){s.destroyItems();e=D.system.phone?this._getItemsForMobile():o.aControlsForSelect;e.map(this._createSelectItem).reverse().forEach(s.insertItem,s);this._bControlDistributionCached=true;this.invalidate(this);}s.setVisible(!!o.aControlsForSelect.length);if(!this._sResizeListenerId&&!this.bRenderingPhase){this._sResizeListenerId=R.register(this,this._handleScreenResize.bind(this));}};
d.prototype._getControlsForBreadcrumbTrail=function(){var v;if(this._bControlDistributionCached&&this._oDistributedControls){return this._oDistributedControls.aControlsForBreadcrumbTrail;}v=this.getLinks().filter(function(o){return o.getVisible();});if(this.getCurrentLocationText()){return v.concat([this._getCurrentLocation()]);}return v;};
d.prototype._getControlInfo=function(o){return{id:o.getId(),control:o,width:o.$().parent().outerWidth(true),bCanOverflow:o instanceof L};};
d.prototype._getControlDistribution=function(m){m=m||this._iContainerSize;this._iContainerSize=m;this._oDistributedControls=this._determineControlDistribution(m);return this._oDistributedControls;};
d.prototype._getSelectWidth=function(){return this._getSelect().getVisible()&&this._iSelectWidth||0;};
d.prototype._determineControlDistribution=function(m){var i,o,e=this._getControlsInfo().aControlInfo,s=this._getSelectWidth(),g=[],h=[],u=s;for(i=e.length-1;i>=0;i--){o=e[i];u+=o.width;if(e.length-1===i){h.push(o.control);continue;}if(i===0){u-=s;}if(u>m&&o.bCanOverflow){g.unshift(o.control);}else{h.unshift(o.control);}}return{aControlsForBreadcrumbTrail:h,aControlsForSelect:g};};
d.prototype._getControlsInfo=function(){if(!this._bControlsInfoCached){this._iSelectWidth=this._getSelect().$().parent().outerWidth(true)||0;this._aControlInfo=this._getControlsForBreadcrumbTrail().map(this._getControlInfo);this._iContainerSize=this.$().outerWidth(true);this._bControlsInfoCached=true;}return{aControlInfo:this._aControlInfo,iSelectWidth:this._iSelectWidth,iContentSize:this._iContainerSize};};
d.prototype._handleScreenResize=function(e){var i=this._oDistributedControls.aControlsForBreadcrumbTrail.length,o=this._getControlDistribution(e.size.width),g=o.aControlsForBreadcrumbTrail.length;if(i!==g){this._updateSelect(true);}return this;};
d.prototype._getItemsToNavigate=function(){var i=this._getControlsForBreadcrumbTrail().slice(),s=this._getSelect();if(s.getVisible()){i.unshift(s);}return i;};
d.prototype._getItemNavigation=function(){if(!this._itemNavigation){this._itemNavigation=new a();}return this._itemNavigation;};
d.prototype._destroyItemNavigation=function(){if(this._itemNavigation){this.removeEventDelegate(this._itemNavigation);this._itemNavigation.destroy();this._itemNavigation=null;}};
d.prototype._configureKeyboardHandling=function(){var i=this._getItemNavigation(),s=-1,e=this._getItemsToNavigate(),n=[];if(e.length===0){return;}e.forEach(function(o,g){if(g===0){o.$().attr("tabIndex","0");}o.$().attr("tabIndex","-1");n.push(o.getDomRef());});this.addDelegate(i);i.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});i.setCycling(false);i.setPageSize(d.PAGEUP_AND_PAGEDOWN_JUMP_SIZE);i.setRootDomRef(this.getDomRef());i.setItemDomRefs(n);i.setSelectedIndex(s);return this;};
d.prototype._registerControlListener=function(o){if(o){o.attachEvent("_change",this._resetControl,this);}};
d.prototype._deregisterControlListener=function(o){if(o){o.detachEvent("_change",this._resetControl,this);}};
d.prototype.setCurrentLocationText=function(t){var o=this._getCurrentLocation(),r=this.setProperty("currentLocationText",t,true);if(o.getText()!==t){o.setText(t);this._resetControl();}return r;};
d.prototype._resetControl=function(){this._aControlInfo=null;this._iContainerSize=null;this._bControlsInfoCached=null;this._bControlDistributionCached=null;this._oDistributedControls=null;if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this.removeDelegate(this._getItemNavigation());this.invalidate(this);return this;};
return d;});
sap.ui.predefine('sap/m/BreadcrumbsRenderer',["sap/m/Text"],function(T){"use strict";var B={};
B.render=function(r,c){var C=c._getControlsForBreadcrumbTrail(),s=c._getSelect();r.write("<ul");r.writeControlData(c);r.addClass("sapMBreadcrumbs");r.writeClasses();r.writeAttribute("role","navigation");r.writeAttributeEscaped("aria-label",B._getResourceBundleText("BREADCRUMB_LABEL"));r.write(">");if(s.getVisible()){this._renderControlInListItem(r,s,false,"sapMBreadcrumbsSelectItem");}C.forEach(function(o){this._renderControlInListItem(r,o,o instanceof T);},this);r.write("</ul>");};
B._renderControlInListItem=function(r,c,s,a){r.write("<li");r.writeAttribute("role","presentation");r.writeAttribute("aria-hidden","true");r.addClass("sapMBreadcrumbsItem");r.addClass(a);r.writeClasses();r.write(">");r.renderControl(c);if(!s){r.write("<span");r.addClass("sapMBreadcrumbsSeparator");r.writeClasses();r.write(">/</span>");}r.write("</li>");};
B._getResourceBundleText=function(t){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText(t);};
return B;},true);
sap.ui.predefine('sap/m/BusyDialog',['./library','sap/ui/core/Control','sap/m/Dialog','sap/m/BusyIndicator','sap/m/Label','sap/m/Button',"sap/base/Log"],function(l,C,D,B,L,a,b){"use strict";
var c=C.extend("sap.m.BusyDialog",{
metadata:{library:"sap.m",properties:{text:{type:"string",group:"Appearance",defaultValue:''},title:{type:"string",group:"Appearance",defaultValue:''},customIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''},customIconRotationSpeed:{type:"int",group:"Appearance",defaultValue:1000},customIconDensityAware:{type:"boolean",defaultValue:true},customIconWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},customIconHeight:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},cancelButtonText:{type:"string",group:"Misc",defaultValue:''},showCancelButton:{type:"boolean",group:"Appearance",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{close:{parameters:{cancelPressed:{type:"boolean"}}}},designtime:"sap/m/designtime/BusyDialog.designtime"},
renderer:function(r,o){}
});
c.prototype.init=function(){this._busyIndicator=new B(this.getId()+'-busyInd',{visible:true});function o(){if(sap.ui.getCore().getConfiguration().getAccessibility()){this._$content.attr('role','application');}}this._oDialog=new D(this.getId()+'-Dialog',{content:this._busyIndicator,showHeader:false,afterOpen:o,afterClose:this._fnCloseHandler.bind(this),initialFocus:this._busyIndicator.getId()+'-busyIndicator'}).addStyleClass('sapMBusyDialog');this._oDialog.close=function(){};this._oDialog.addEventDelegate({onBeforeRendering:function(){var t=this.getText(),d=this.getTitle(),s=this.getShowCancelButton()||this.getCancelButtonText();if(!t&&!d&&!s){this._oDialog.addStyleClass('sapMBusyDialog-Light');}else{this._oDialog.removeStyleClass('sapMBusyDialog-Light');}}},this);this._oDialog.oPopup.onsapescape=function(e){this.close(true);}.bind(this);};
c.prototype.exit=function(){this._busyIndicator.destroy();this._busyIndicator=null;if(this._cancelButton){this._cancelButton.destroy();this._cancelButton=null;}if(this._oLabel){this._oLabel.destroy();this._oLabel=null;}if(this._oDialog){this._oDialog.destroy();this._oDialog=null;}};
c.prototype.open=function(){b.debug("sap.m.BusyDialog.open called at "+new Date().getTime());if(this.getAriaLabelledBy()&&!this._oDialog._$dialog){var t=this;this.getAriaLabelledBy().forEach(function(i){t._oDialog.addAriaLabelledBy(i);});}if(!document.body||!sap.ui.getCore().isInitialized()){setTimeout(function(){this.open();}.bind(this),50);}else{this._oDialog.open();}return this;};
c.prototype.close=function(i){this._isClosedFromUserInteraction=i;D.prototype.close.call(this._oDialog);return this;};
c.prototype._fnCloseHandler=function(){this.fireClose({cancelPressed:this._isClosedFromUserInteraction||false});};
c.prototype.setTitle=function(t){this.setProperty('title',t,true);this._oDialog.setTitle(t).setShowHeader(!!t);return this;};
c.prototype.setTooltip=function(t){this._oDialog.setTooltip(t);return this;};
c.prototype.getTooltip=function(){this._oDialog.getTooltip();return this;};
c.prototype.setText=function(t){this.setProperty('text',t,true);if(!this._oLabel){if(t){this._oLabel=new L(this.getId()+'-TextLabel',{text:t}).addStyleClass('sapMBusyDialogLabel');this._oDialog.insertAggregation('content',this._oLabel,0);this._oDialog.addAriaLabelledBy(this._oLabel.getId());}}else{if(t){this._oLabel.setText(t).setVisible(true);}else{this._oLabel.setVisible(false);}}return this;};
c.prototype.setCustomIcon=function(i){this.setProperty("customIcon",i,true);this._busyIndicator.setCustomIcon(i);return this;};
c.prototype.setCustomIconRotationSpeed=function(s){this.setProperty("customIconRotationSpeed",s,true);this._busyIndicator.setCustomIconRotationSpeed(s);return this;};
c.prototype.setCustomIconDensityAware=function(i){this.setProperty("customIconDensityAware",i,true);this._busyIndicator.setCustomIconDensityAware(i);return this;};
c.prototype.setCustomIconWidth=function(w){this.setProperty("customIconWidth",w,true);this._busyIndicator.setCustomIconWidth(w);return this;};
c.prototype.setCustomIconHeight=function(h){this.setProperty("customIconHeight",h,true);this._busyIndicator.setCustomIconHeight(h);return this;};
c.prototype.setShowCancelButton=function(i){this.setProperty("showCancelButton",i,false);if(i){this._oDialog.setEndButton(this._getCancelButton());}else{this._destroyTheCancelButton();}return this;};
c.prototype.setCancelButtonText=function(t){this.setProperty("cancelButtonText",t,false);if(t){this._getCancelButton().setText(t);this._oDialog.setEndButton(this._getCancelButton());}else{this._destroyTheCancelButton();}return this;};
c.prototype.getDomRef=function(){return this._oDialog&&this._oDialog.getDomRef();};
["addStyleClass","removeStyleClass","toggleStyleClass","hasStyleClass"].forEach(function(A){c.prototype[A]=function(){if(this._oDialog&&this._oDialog[A]){this._oDialog[A].apply(this._oDialog,arguments);return this;}};});
c.prototype._destroyTheCancelButton=function(){this._oDialog.destroyEndButton();this._cancelButton=null;};
c.prototype._getCancelButton=function(){var d=this.getCancelButtonText();d=d?d:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("BUSYDIALOG_CANCELBUTTON_TEXT");return this._cancelButton?this._cancelButton:this._cancelButton=new a(this.getId()+'busyCancelBtn',{text:d,press:function(){this.close(true);}.bind(this)});};
return c;});
sap.ui.predefine('sap/m/BusyIndicator',['./library','sap/ui/core/Control','sap/ui/core/library',"./BusyIndicatorRenderer"],function(l,C,c,B){"use strict";var T=c.TextDirection;
var a=C.extend("sap.m.BusyIndicator",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Data",defaultValue:""},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},customIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:""},customIconRotationSpeed:{type:"int",group:"Appearance",defaultValue:1000},customIconDensityAware:{type:"boolean",defaultValue:true},customIconWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},customIconHeight:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},size:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"1rem"},design:{type:"string",group:"Appearance",defaultValue:"auto"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}}});
a.prototype.init=function(){this.setBusyIndicatorDelay(0);};
a.prototype.setText=function(t){this.setProperty("text",t,true);this._createLabel("setText",t);return this;};
a.prototype.setTextDirection=function(d){this.setProperty("textDirection",d,true);this._createLabel("setTextDirection",d);return this;};
a.prototype.setCustomIcon=function(s){this.setProperty("customIcon",s,false);this._createCustomIcon("setSrc",s);return this;};
a.prototype.setCustomIconRotationSpeed=function(s){if(isNaN(s)||s<0){s=0;}if(s!==this.getCustomIconRotationSpeed()){this.setProperty("customIconRotationSpeed",s,true);this._setRotationSpeed();}return this;};
a.prototype.setCustomIconDensityAware=function(A){this.setProperty("customIconDensityAware",A,true);this._createCustomIcon("setDensityAware",A);return this;};
a.prototype.setCustomIconWidth=function(w){this.setProperty("customIconWidth",w,true);this._createCustomIcon("setWidth",w);return this;};
a.prototype.setCustomIconHeight=function(h){this.setProperty("customIconHeight",h,true);this._createCustomIcon("setHeight",h);return this;};
a.prototype.setSize=function(s){this.setProperty("size",s,true);var d=this.getDomRef();if(d){d.style.fontSize=s;}return this;};
a.prototype.onBeforeRendering=function(){if(this.getCustomIcon()){this.setBusy(false);}else{this.setBusy(true,"busy-area");}};
a.prototype.exit=function(){if(this._iconImage){this._iconImage.destroy();this._iconImage=null;}if(this._busyLabel){this._busyLabel.destroy();this._busyLabel=null;}};
a.prototype._createCustomIcon=function(n,v){if(!this._iconImage){this._iconImage=new sap.m.Image(this.getId()+"-icon",{width:"44px",height:"44px"}).addStyleClass("sapMBsyIndIcon");this._iconImage.addEventDelegate({onAfterRendering:function(){this._setRotationSpeed();}},this);}this._iconImage[n](v);this._setRotationSpeed();};
a.prototype._createLabel=function(n,v){if(!this._busyLabel){this._busyLabel=new sap.m.Label(this.getId()+"-label",{labelFor:this.getId(),textAlign:"Center"});}this._busyLabel[n](v);};
a.prototype._setRotationSpeed=function(){if(!this._iconImage){return;}var $=this._iconImage.$();var r=this.getCustomIconRotationSpeed()+"ms";$.css("-webkit-animation-duration",r).css("animation-duration",r);$.css("display","none");setTimeout(function(){$.css("display","inline");},0);};
return a;});
sap.ui.predefine('sap/m/BusyIndicatorRenderer',[],function(){"use strict";var B={};
B.render=function(r,b){this.startBusyIndicator(r,b);this.renderBusyIndication(r,b);this.renderLabel(r,b);this.endBusyIndicator(r);};
B.startBusyIndicator=function(r,b){r.write("<div ");r.writeControlData(b);r.addClass("sapMBusyIndicator");r.writeClasses();r.addStyle("font-size",b.getSize());r.writeStyles();r.writeAccessibilityState(b);this.renderTooltip(r,b.getTooltip_AsString());r.write(">");};
B.renderTooltip=function(r,t){if(t){r.writeAttributeEscaped("title",t);}};
B.renderBusyIndication=function(r,b){if(b.getCustomIcon()){r.renderControl(b._iconImage);}else{r.write("<div class='sapMBusyIndicatorBusyArea'");r.writeAttribute("id",b.getId()+"-busy-area");r.write("></div>");}};
B.renderLabel=function(r,b){if(b.getText()){r.renderControl(b._busyLabel);}};
B.endBusyIndicator=function(r){r.write("</div>");};
return B;},true);
sap.ui.predefine('sap/m/Button',['./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','sap/ui/Device','sap/ui/core/ContextMenuSupport','sap/ui/core/library','./ButtonRenderer',"sap/ui/events/KeyCodes"],function(l,C,E,I,D,a,c,B,K){"use strict";var T=c.TextDirection;var b=l.ButtonType;
var d=C.extend("sap.m.Button",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:null},type:{type:"sap.m.ButtonType",group:"Appearance",defaultValue:b.Default},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},iconFirst:{type:"boolean",group:"Appearance",defaultValue:true},activeIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{tap:{deprecated:true},press:{}},designtime:"sap/m/designtime/Button.designtime",dnd:{draggable:true,droppable:false}}});
E.call(d.prototype);a.apply(d.prototype);
d.prototype.exit=function(){if(this._image){this._image.destroy();}if(this._iconBtn){this._iconBtn.destroy();}};
d.prototype.onBeforeRendering=function(){this._bRenderActive=this._bActive;};
d.prototype.onAfterRendering=function(){if(this._bRenderActive){this._activeButton();this._bRenderActive=this._bActive;}};
d.prototype.ontouchstart=function(e){e.setMarked();if(this._bRenderActive){delete this._bRenderActive;}if(e.targetTouches.length===1){this._activeButton();}if(this.getEnabled()&&this.getVisible()){if(D.browser.safari&&(e.originalEvent&&e.originalEvent.type==="mousedown")){this.focus();e.preventDefault();}}};
d.prototype.ontouchend=function(e){this._inactiveButton();if(this._bRenderActive){delete this._bRenderActive;if(e.originalEvent&&e.originalEvent.type in{mouseup:1,touchend:1}){this.ontap(e);}}};
d.prototype.ontouchcancel=function(){this._inactiveButton();};
d.prototype.ontap=function(e){e.setMarked();if(this.getEnabled()&&this.getVisible()){if((e.originalEvent&&e.originalEvent.type==="touchend")){this.focus();}this.fireTap({});this.firePress({});}};
d.prototype.onkeydown=function(e){if(e.which===K.SPACE||e.which===K.ENTER){e.setMarked();this._activeButton();}if(e.which===K.ENTER){this.firePress({});}};
d.prototype.onkeyup=function(e){if(e.which===K.SPACE||e.which===K.ENTER){e.setMarked();this._inactiveButton();}if(e.which===K.SPACE){this.firePress({});}};
d.prototype.onfocusout=function(){this._inactiveButton();};
d.prototype._activeButton=function(){if(!this._isUnstyled()){this.$("inner").addClass("sapMBtnActive");}this._bActive=this.getEnabled();if(this._bActive){if(this.getIcon()&&this.getActiveIcon()&&this._image){this._image.setSrc(this.getActiveIcon());}}};
d.prototype._inactiveButton=function(){if(!this._isUnstyled()){this.$("inner").removeClass("sapMBtnActive");}this._bActive=false;if(this.getEnabled()){if(this.getIcon()&&this.getActiveIcon()&&this._image){this._image.setSrc(this.getIcon());}}};
d.prototype._isHoverable=function(){return this.getEnabled()&&D.system.desktop;};
d.prototype._getImage=function(i,s,A,e){if(this._image&&(this._image.getSrc()!==s)){this._image.destroy();this._image=undefined;}var o=this._image;var f=this.getIconFirst();if(!!o){o.setSrc(s);if(o instanceof sap.m.Image){o.setActiveSrc(A);o.setDensityAware(e);}}else{o=I.createControlByURI({id:i,src:s,activeSrc:A,densityAware:e,useIconTooltip:false},sap.m.Image).addStyleClass("sapMBtnCustomIcon").setParent(this,null,true);}o.addStyleClass("sapMBtnIcon");o.toggleStyleClass("sapMBtnIconLeft",f);o.toggleStyleClass("sapMBtnIconRight",!f);this._image=o;return this._image;};
d.prototype._getInternalIconBtn=function(i,s){var o=this._iconBtn;if(o){o.setSrc(s);}else{o=I.createControlByURI({id:i,src:s,useIconTooltip:false},sap.m.Image).setParent(this,null,true);}o.addStyleClass("sapMBtnIcon");o.addStyleClass("sapMBtnIconLeft");this._iconBtn=o;return this._iconBtn;};
d.prototype._isUnstyled=function(){var u=false;if(this.getType()===b.Unstyled){u=true;}return u;};
d.prototype.setText=function(t){var v=this.getText();if(t===null||t===undefined){t="";}if(v!==t){var o=this.getDomRef("BDI-content")||this.getDomRef("content");var s=!!o;this.setProperty("text",t,s);if(s){t=this.getText();o.textContent=t;this.$("inner").toggleClass("sapMBtnText",!!t);}}return this;};
d.prototype.setIcon=function(i){var v=this.getIcon()||"";i=i||"";if(v!==i){var s=!!v&&!!i&&I.isIconURI(i)===I.isIconURI(v);this.setProperty("icon",i,s);if(s&&this._image){this._image.setSrc(i);}}return this;};
d.prototype.getPopupAnchorDomRef=function(){return this.getDomRef("inner");};
d.prototype._getText=function(){return this.getText();};
d.prototype._getTooltip=function(){var t=this.getTooltip_AsString();if(!t&&!this.getText()){var i=I.getIconInfo(this.getIcon());if(i&&i.text){t=i.text;}}return t;};
d.prototype.getAccessibilityInfo=function(){var s=this.getText()||this.getTooltip_AsString();if(!s&&this.getIcon()){var i=I.getIconInfo(this.getIcon());if(i){s=i.text||i.name;}}return{role:"button",type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_BUTTON"),description:s,focusable:this.getEnabled(),enabled:this.getEnabled()};};
return d;});
sap.ui.predefine('sap/m/ButtonRenderer',['sap/ui/Device','sap/ui/core/library','sap/ui/core/IconPool','sap/m/library','sap/ui/core/InvisibleText',"sap/base/security/encodeXML"],function(D,c,I,l,a,e){"use strict";var B=l.ButtonType;var T=c.TextDirection;var b={};
b.render=function(R,o){var t=o.getType();var E=o.getEnabled();var w=o.getWidth();var s=o._getTooltip();var d=o._getText();var f=o.getTextDirection();var i=D.browser.internet_explorer||D.browser.edge;var g=(f===T.Inherit)&&!i;var h=I.getIconURI("nav-back");R.write("<button");R.writeControlData(o);R.addClass("sapMBtnBase");if(!o._isUnstyled()){R.addClass("sapMBtn");if((t===B.Back||t===B.Up)&&o.getIcon()&&!d){R.addClass("sapMBtnBack");}}var m={};var j=b.getButtonTypeAriaLabelId(t);if(j){m["describedby"]={value:j,append:true};}if(d&&o.getAriaLabelledBy()&&o.getAriaLabelledBy().length>0){m["labelledby"]={value:o.getId()+"-content",append:true};}if(this.renderAccessibilityAttributes){this.renderAccessibilityAttributes(R,o,m);}R.writeAccessibilityState(o,m);if(!E){R.writeAttribute("disabled","disabled");if(!o._isUnstyled()){R.addClass("sapMBtnDisabled");}}else{switch(t){case B.Accept:case B.Reject:case B.Emphasized:R.addClass("sapMBtnInverted");break;default:break;}}if(s){R.writeAttributeEscaped("title",s);}R.writeClasses();if(w!=""||w.toLowerCase()==="auto"){R.addStyle("width",w);R.writeStyles();}r(o,R);R.write(">");R.write("<span");R.writeAttribute("id",o.getId()+"-inner");if(!o._isUnstyled()){R.addClass("sapMBtnInner");}if(o._isHoverable()){R.addClass("sapMBtnHoverable");}if(E){R.addClass("sapMFocusable");if(i){R.addClass("sapMIE");}}if(!o._isUnstyled()){if(d){R.addClass("sapMBtnText");}if(t===B.Back||t===B.Up){R.addClass("sapMBtnBack");}if(o.getIcon()){if(o.getIconFirst()){R.addClass("sapMBtnIconFirst");}else{R.addClass("sapMBtnIconLast");}}}if(this.renderButtonAttributes){this.renderButtonAttributes(R,o);}if(!o._isUnstyled()&&t!==""){R.addClass("sapMBtn"+e(t));}R.writeClasses();r(o,R);R.write(">");if(t===B.Back||t===B.Up){this.writeInternalIconPoolHtml(R,o,h);}if(o.getIcon()){this.writeImgHtml(R,o);}if(d){R.write("<span ");R.addClass("sapMBtnContent");if(f!==T.Inherit){R.writeAttribute("dir",f.toLowerCase());}R.writeClasses();R.writeAttribute("id",o.getId()+"-content");R.write(">");if(g){R.write("<bdi");R.writeAttribute("id",o.getId()+"-BDI-content");R.write(">");}R.writeEscaped(d);if(g){R.write("</bdi>");}R.write("</span>");}if(i&&E){R.write('<span class="sapMBtnFocusDiv"></span>');}R.write("</span>");R.write("</button>");};
b.writeImgHtml=function(R,o){R.renderControl(o._getImage((o.getId()+"-img"),o.getIcon(),o.getActiveIcon(),o.getIconDensityAware()));};
b.writeInternalIconPoolHtml=function(R,o,u){R.renderControl(o._getInternalIconBtn((o.getId()+"-iconBtn"),u));};
function r(o,R){if(o._bExcludeFromTabChain){R.writeAttribute("tabindex",-1);}}
var A={Accept:"BUTTON_ARIA_TYPE_ACCEPT",Reject:"BUTTON_ARIA_TYPE_REJECT",Emphasized:"BUTTON_ARIA_TYPE_EMPHASIZED"};
b.getButtonTypeAriaLabelId=function(t){return a.getStaticId("sap.m",A[t]);};
return b;},true);
sap.ui.predefine('sap/m/CalendarAppointment',['sap/ui/unified/CalendarAppointment'],function(U){"use strict";
var C=U.extend("sap.m.CalendarAppointment",{metadata:{library:"sap.m",properties:{fullDay:{type:"boolean",group:"Data",defaultValue:false}}}});
return C;});
sap.ui.predefine('sap/m/Carousel',['./library','sap/ui/core/Control','sap/ui/Device','sap/ui/core/ResizeHandler','sap/ui/core/library','sap/ui/core/HTML','sap/m/ScrollContainer','sap/ui/core/theming/Parameters','sap/ui/dom/units/Rem','./CarouselRenderer','./CarouselLayout',"sap/ui/events/KeyCodes","sap/base/Log","sap/ui/events/F6Navigation","sap/ui/thirdparty/jquery",'sap/ui/thirdparty/mobify-carousel','sap/ui/core/IconPool'],function(l,C,D,R,c,H,S,P,a,b,d,K,L,F,q){"use strict";var B=c.BusyIndicatorSize;var I=l.ImageHelper;var f=l.CarouselArrowsPlacement;var g=l.PlacementType;
var h=C.extend("sap.m.Carousel",{metadata:{library:"sap.m",designtime:"sap/m/designtime/Carousel.designtime",properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},loop:{type:"boolean",group:"Misc",defaultValue:false},showPageIndicator:{type:"boolean",group:"Appearance",defaultValue:true},pageIndicatorPlacement:{type:"sap.m.PlacementType",group:"Appearance",defaultValue:g.Bottom},showBusyIndicator:{type:"boolean",group:"Appearance",defaultValue:true,deprecated:true},arrowsPlacement:{type:"sap.m.CarouselArrowsPlacement",group:"Appearance",defaultValue:f.Content}},defaultAggregation:"pages",aggregations:{pages:{type:"sap.ui.core.Control",multiple:true,singularName:"page"},customLayout:{type:"sap.m.CarouselLayout",multiple:false}},associations:{activePage:{type:"sap.ui.core.Control",multiple:false}},events:{loadPage:{deprecated:true,parameters:{pageId:{type:"string"}}},unloadPage:{deprecated:true,parameters:{pageId:{type:"string"}}},pageChanged:{parameters:{oldActivePageId:{type:"string"},newActivePageId:{type:"string"},activePages:{type:"array"}}},beforePageChanged:{parameters:{activePages:{type:"array"}}}}}});
h._INNER_SELECTOR=".sapMCrslInner";h._PAGE_INDICATOR_SELECTOR=".sapMCrslBulleted";h._PAGE_INDICATOR_ARROWS_SELECTOR=".sapMCrslIndicatorArrow";h._CONTROLS=".sapMCrslControls";h._ITEM_SELECTOR=".sapMCrslItem";h._LEFTMOST_CLASS="sapMCrslLeftmost";h._RIGHTMOST_CLASS="sapMCrslRightmost";h._LATERAL_CLASSES="sapMCrslLeftmost sapMCrslRightmost";h._MODIFIERNUMBERFORKEYBOARDHANDLING=10;h._BULLETS_TO_NUMBERS_THRESHOLD=9;h._PREVIOUS_CLASS_ARROW="sapMCrslPrev";h._NEXT_CLASS_ARROW="sapMCrslNext";
h.prototype.init=function(){this._aScrollContainers=[];this._fnAdjustAfterResize=q.proxy(function(){var $=this.$().find(h._INNER_SELECTOR);this._oMobifyCarousel.resize($);this._setWidthOfPages(this._getNumberOfItemsToShow());},this);this._aOrderOfFocusedElements=[];this._aAllActivePages=[];this._aAllActivePagesIndexes=[];this._onBeforePageChangedRef=this._onBeforePageChanged.bind(this);this._onAfterPageChangedRef=this._onAfterPageChanged.bind(this);this.data("sap-ui-fastnavgroup","true",true);};
h.prototype.exit=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.destroy();delete this._oMobifyCarousel;}if(this._oArrowLeft){this._oArrowLeft.destroy();delete this._oArrowLeft;}if(this._oArrowRight){this._oArrowRight.destroy();delete this._oArrowRight;}if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this.$().off('afterSlide');this._cleanUpScrollContainer();this._fnAdjustAfterResize=null;this._aScrollContainers=null;this._$InnerDiv=null;this._aOrderOfFocusedElements=null;this._aAllActivePages=null;this._aAllActivePagesIndexes=null;};
h.prototype._cleanUpScrollContainer=function(){var s;while(this._aScrollContainers&&this._aScrollContainers.length>0){s=this._aScrollContainers.pop();s.destroyContent();if(s&&typeof s.destroy==='function'){s.destroy();}}};
h.prototype.ontouchstart=function(e){if(this._oMobifyCarousel){this._oMobifyCarousel.touchstart(e);}};
h.prototype.ontouchmove=function(e){if(this._oMobifyCarousel){this._oMobifyCarousel.touchmove(e);}};
h.prototype.ontouchend=function(e){if(this._oMobifyCarousel){this._oMobifyCarousel.touchend(e);}};
h.prototype.onBeforeRendering=function(){var A=this.getActivePage();if(!A&&this.getPages().length>0){this.setAssociation("activePage",this.getPages()[0].getId(),true);}if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}return this;};
h.prototype._getNumberOfItemsToShow=function(){var p=this.getPages().length,o=this.getCustomLayout(),n=1;if(o&&o.isA("sap.m.CarouselLayout")){n=Math.max(o.getVisiblePagesCount(),1);}if(n>1&&p<n){return p;}return n;};
h.prototype.onAfterRendering=function(){var n=this._getNumberOfItemsToShow();if(this._oMobifyCarousel){this._oMobifyCarousel.unbind();}this.$().carousel(undefined,{numberOfItemsToShow:n});this._oMobifyCarousel=this.getDomRef()._carousel;this._oMobifyCarousel.setLoop(this.getLoop());this._oMobifyCarousel.setRTL(sap.ui.getCore().getConfiguration().getRTL());if(n>1){this._setWidthOfPages(n);}var A=this.getActivePage();if(A){var i=this._getPageNumber(A);if(isNaN(i)||i==0){if(this.getPages().length>0){this.setAssociation("activePage",this.getPages()[0].getId(),true);this._adjustHUDVisibility(1);}}else{var o=sap.ui.getCore();if(o.isThemeApplied()){this._moveToPage(i+1);}else{o.attachThemeChanged(this._handleThemeLoad,this);}if(this.getParent()&&this.getParent().isA("sap.zen.commons.layout.PositionContainer")){if(this._isCarouselUsedWithCommonsLayout===undefined){setTimeout(this["invalidate"].bind(this),0);this._isCarouselUsedWithCommonsLayout=true;}}}}this.$().on('beforeSlide',this._onBeforePageChangedRef);this.$().on('afterSlide',this._onAfterPageChangedRef);this._$InnerDiv=this.$().find(h._INNER_SELECTOR)[0];this._sResizeListenerId=R.register(this._$InnerDiv,this._fnAdjustAfterResize);this.$().find('.sapMCrslItemTableCell').focus(function(e){e.preventDefault();q(e.target).parents('.sapMCrsl').focus();return false;});var s='sap.m.IconTabBar';var p=this.getParent();while(p){if(p.getMetadata().getName()==s){var t=this;p.attachExpand(function(e){var E=e.getParameter('expand');if(E&&i>0){t._moveToPage(i+1);}});break;}p=p.getParent();}};
h.prototype._onBeforePageChanged=function(e,p,n){if(e.target!==this.getDomRef()){return;}var N=this.getPages()[n-1].getId();this._updateActivePages(N);this.fireBeforePageChanged({activePages:this._aAllActivePagesIndexes});};
h.prototype._onAfterPageChanged=function(e,p,n){if(e.target!==this.getDomRef()){return;}if(n>0){this._changePage(n);}};
h.prototype._setWidthOfPages=function(n){var i=this._calculatePagesWidth(n);this.$().find(".sapMCrslItem").each(function(e,p){p.style.width=i+"%";});};
h.prototype._calculatePagesWidth=function(n){var w=this.$().width(),m=a.toPx(P.get("_sap_m_Carousel_PagesMarginRight")),i=(w-(m*(n-1)))/n,e=(i/w)*100;return e;};
h.prototype._handleThemeLoad=function(){var o,A=this.getActivePage();if(A){var i=this._getPageNumber(A);if(i>0){this._moveToPage(i+1);}}o=sap.ui.getCore();o.detachThemeChanged(this._handleThemeLoad,this);};
h.prototype._moveToPage=function(i){this._oMobifyCarousel.changeAnimation('sapMCrslNoTransition');this._oMobifyCarousel.move(i);this._changePage(i);};
h.prototype._changePage=function(n){this._adjustHUDVisibility(n);var o=this.getActivePage();var N=this.getPages()[n-1].getId();this.setAssociation("activePage",N,true);var t=this._getPageIndicatorText(n);L.debug("sap.m.Carousel: firing pageChanged event: old page: "+o+", new page: "+N);if(!D.system.desktop){q(document.activeElement).blur();}this.firePageChanged({oldActivePageId:o,newActivePageId:N,activePages:this._aAllActivePagesIndexes});this.$('slide-number').text(t);};
h.prototype._getPageIndicatorText=function(n){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("CAROUSEL_PAGE_INDICATOR_TEXT",[n,this.getPages().length-this._getNumberOfItemsToShow()+1]);};
h.prototype._adjustHUDVisibility=function(n){var N=this._getNumberOfItemsToShow();if(D.system.desktop&&!this.getLoop()&&this.getPages().length>1){var $=this.$('hud');$.removeClass(h._LATERAL_CLASSES);if(n===1){$.addClass(h._LEFTMOST_CLASS);this._focusCarouselContainer($,h._PREVIOUS_CLASS_ARROW);}if((n+N-1)===this.getPages().length){$.addClass(h._RIGHTMOST_CLASS);this._focusCarouselContainer($,h._NEXT_CLASS_ARROW);}}};
h.prototype._focusCarouselContainer=function($,A){if($.find('.'+A)[0]===document.activeElement){this.focus();}};
h.prototype.setActivePage=function(p){var s=null;if(typeof(p)=='string'){s=p;}else if(p instanceof C){s=p.getId();}if(s){if(s===this.getActivePage()){return this;}var i=this._getPageNumber(s);if(!isNaN(i)){if(this._oMobifyCarousel){this._oMobifyCarousel.move(i+1);}}}this.setAssociation("activePage",s,true);return this;};
h.prototype.setHeight=function(o){this.setProperty("height",o,true);this.$().css("height",o);return this;};
h.prototype.setWidth=function(w){this.setProperty("width",w,true);this.$().css("width",w);return this;};
h.prototype.setLoop=function(e){this.setProperty("loop",e,true);if(this._oMobifyCarousel){this._oMobifyCarousel.setLoop(e);}return this;};
h.prototype._getNavigationArrow=function(n){var p={src:"sap-icon://slim-arrow-"+n,useIconTooltip:false};if(n==="left"){if(!this._oArrowLeft){this._oArrowLeft=I.getImageControl(this.getId()+"-arrowScrollLeft",this._oArrowLeft,this,p);}return this._oArrowLeft;}else if(n==="right"){if(!this._oArrowRight){this._oArrowRight=I.getImageControl(this.getId()+"-arrowScrollRight",this._oArrowRight,this,p);}return this._oArrowRight;}};
h.prototype._createScrollContainer=function(p){var i;var s=D.system.desktop&&this.getArrowsPlacement()===f.PageIndicator;if(s){i="sapMCrslImg";}else{i="sapMCrslImgNoArrows";}var j=p.isA("sap.m.Image")?"sapMCrslItemTableCell "+i:"sapMCrslItemTableCell",o=new H({content:"<div class='sapMCrslItemTable'>"+"<div class='"+j+"'></div>"+"</div>",afterRendering:function(e){var r=sap.ui.getCore().createRenderManager();p.addStyleClass("sapMCrsPage");r.render(p,this.getDomRef().firstChild);r.destroy();p=null;}});var k=new S({horizontal:false,vertical:false,content:[o],width:'100%',height:'100%'});k.setParent(this,null,true);this._aScrollContainers.push(k);return k;};
h.prototype.previous=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.prev();}else{L.warning("Unable to execute sap.m.Carousel.previous: carousel must be rendered first.");}return this;};
h.prototype.next=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.next();}else{L.warning("Unable to execute sap.m.Carousel.next: carousel must be rendered first.");}return this;};
h.prototype._getPageNumber=function(p){var i,r;for(i=0;i<this.getPages().length;i++){if(this.getPages()[i].getId()==p){r=i;break;}}return r;};
h.prototype.onsaptabprevious=function(e){this._bDirection=false;this._fnOnTabPress(e);};
h.prototype.onsaptabnext=function(e){this._bDirection=true;this._fnOnTabPress(e);};
h.prototype.onfocusin=function(e){this.saveLastFocusReference(e);this._bDirection=undefined;};
h.prototype.onsapskipforward=function(e){e.preventDefault();this._handleGroupNavigation(e,false);};
h.prototype.onsapskipback=function(e){e.preventDefault();this._handleGroupNavigation(e,true);};
h.prototype.onkeydown=function(e){if(e.keyCode==K.F7){this._handleF7Key(e);return;}if(e.target!=this.getDomRef()){return;}switch(e.keyCode){case 189:case K.NUMPAD_MINUS:this._fnSkipToIndex(e,-1);break;case K.PLUS:case K.NUMPAD_PLUS:this._fnSkipToIndex(e,1);break;}};
h.prototype.onsapescape=function(e){var i;if(e.target===this.$()[0]&&this._lastActivePageNumber){i=this._lastActivePageNumber+1;this._oMobifyCarousel.move(i);this._changePage(i);}};
h.prototype.onsapright=function(e){this._fnSkipToIndex(e,1);};
h.prototype.onsapup=function(e){this._fnSkipToIndex(e,-1);};
h.prototype.onsapleft=function(e){this._fnSkipToIndex(e,-1);};
h.prototype.onsapdown=function(e){this._fnSkipToIndex(e,1);};
h.prototype.onsaphome=function(e){this._fnSkipToIndex(e,0);};
h.prototype.onsapend=function(e){this._fnSkipToIndex(e,this.getPages().length);};
h.prototype.onsaprightmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,h._MODIFIERNUMBERFORKEYBOARDHANDLING);}};
h.prototype.onsapupmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,h._MODIFIERNUMBERFORKEYBOARDHANDLING);}};
h.prototype.onsappageup=function(e){this._fnSkipToIndex(e,h._MODIFIERNUMBERFORKEYBOARDHANDLING);};
h.prototype.onsapleftmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,-h._MODIFIERNUMBERFORKEYBOARDHANDLING);}};
h.prototype.onsapdownmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,-h._MODIFIERNUMBERFORKEYBOARDHANDLING);}};
h.prototype.onsappagedown=function(e){this._fnSkipToIndex(e,-h._MODIFIERNUMBERFORKEYBOARDHANDLING);};
h.prototype._fnOnTabPress=function(e){if(e.target===this.$()[0]){this._lastActivePageNumber=this._getPageNumber(this.getActivePage());}};
h.prototype._handleGroupNavigation=function(e,s){var E=q.Event("keydown");e.preventDefault();this.$().focus();E.target=e.target;E.keyCode=K.F6;E.shiftKey=s;F.handleF6GroupNavigation(E);};
h.prototype.saveLastFocusReference=function(e){var o=q(e.target).closest(".sapMCrsPage").control(0),s;if(this._bDirection===undefined){return;}if(this._lastFocusablePageElement===undefined){this._lastFocusablePageElement={};}if(o){s=o.getId();this._lastFocusablePageElement[s]=e.target;this._updateFocusedPagesOrder(s);}};
h.prototype._getActivePageLastFocusedElement=function(){if(this._lastFocusablePageElement){return this._lastFocusablePageElement[this._getLastFocusedActivePage()];}};
h.prototype._updateFocusedPagesOrder=function(s){var i=this._aOrderOfFocusedElements.indexOf(s);if(i>-1){this._aOrderOfFocusedElements.splice(0,0,this._aOrderOfFocusedElements.splice(i,1)[0]);}else{this._aOrderOfFocusedElements.unshift(s);}};
h.prototype._updateActivePages=function(n){var N=this._getPageNumber(n),e=this._getNumberOfItemsToShow(),j=N+e,A=this.getPages();if(j>A.length){j=A.length-e;}this._aAllActivePages=[];this._aAllActivePagesIndexes=[];for(var i=N;i<j;i++){this._aAllActivePages.push(A[i].getId());this._aAllActivePagesIndexes.push(i);}};
h.prototype._getLastFocusedActivePage=function(){for(var i=0;i<this._aOrderOfFocusedElements.length;i++){var p=this._aOrderOfFocusedElements[i];if(this._aAllActivePages.indexOf(p)>-1){return p;}}return this.getActivePage();};
h.prototype._fnSkipToIndex=function(e,n){var i=n;if(e.target!==this.getDomRef()){return;}e.preventDefault();if(n!==0){i=this._getPageNumber(this.getActivePage())+1+n;}this._oMobifyCarousel.move(i);};
h.prototype._handleF7Key=function(e){var A;e.preventDefault();A=this._getActivePageLastFocusedElement();if(e.target===this.$()[0]&&A){A.focus();}else{this.$().focus();}};
h.prototype.setShowBusyIndicator=function(){L.warning("sap.m.Carousel: Deprecated function 'setShowBusyIndicator' called. Does nothing.");return this;};
h.prototype.getShowBusyIndicator=function(){L.warning("sap.m.Carousel: Deprecated function 'getShowBusyIndicator' called. Does nothing.");return false;};
h.prototype.setBusyIndicatorSize=function(s){if(!(s in B)){s=B.Medium;}return C.prototype.setBusyIndicatorSize.call(this,s);};
return h;});
sap.ui.predefine('sap/m/CarouselLayout',["sap/ui/base/ManagedObject"],function(M){"use strict";
var C=M.extend("sap.m.CarouselLayout",{metadata:{library:"sap.m",properties:{visiblePagesCount:{type:"int",group:"Misc",defaultValue:1}}}});
return C;});
sap.ui.predefine('sap/m/CarouselRenderer',["sap/m/library","sap/ui/Device"],function(l,D){"use strict";var C=l.CarouselArrowsPlacement;var P=l.PlacementType;var a={};a._BULLETS_TO_NUMBERS_THRESHOLD=9;
a.render=function(r,c){var p=c.getPages(),i=p.length,s=c.getPageIndicatorPlacement(),A=c.getArrowsPlacement(),I=c.getId(),b=a._BULLETS_TO_NUMBERS_THRESHOLD,d=c._getPageNumber(c.getActivePage());this._renderOpeningDiv(r,c);if(s===P.Top){this._renderPageIndicatorAndArrows({rm:r,iPageCount:i,sId:I,iIndex:d,iBulletsToNumbersThreshold:b,sArrowsPlacement:A,bBottom:false,bShowPageIndicator:c.getShowPageIndicator()},c);}this._renderInnerDiv(r,c,p,s);if(D.system.desktop&&i>c._getNumberOfItemsToShow()&&A===C.Content){this._renderHudArrows(r,c);}if(s===P.Bottom){this._renderPageIndicatorAndArrows({rm:r,iPageCount:i,sId:I,iIndex:d,iBulletsToNumbersThreshold:b,sArrowsPlacement:A,bBottom:true,bShowPageIndicator:c.getShowPageIndicator()},c);}this._renderClosingDiv(r);};
a._renderOpeningDiv=function(r,c){var t=c.getTooltip_AsString();r.write("<div");r.writeControlData(c);r.writeAttribute("data-sap-ui-customfastnavgroup","true");r.addStyle("width",c.getWidth());r.addStyle("height",c.getHeight());r.writeStyles();r.addClass("sapMCrsl");r.addClass("sapMCrslFluid");r.writeClasses();if(t){r.writeAttributeEscaped("title",t);}r.writeAttributeEscaped("tabindex","0");r.writeAccessibilityState(c,{role:"list"});r.write(">");};
a._renderInnerDiv=function(r,c,p,s){r.write("<div class='sapMCrslInner");c._cleanUpScrollContainer();if(p.length>1&&(c.getShowPageIndicator()||c.getArrowsPlacement()===C.PageIndicator)){if(s===P.Bottom){r.write(" sapMCrslBottomOffset");if(c.getArrowsPlacement()===C.PageIndicator){r.write(" sapMCrslBottomArrowsOffset");}}else{r.write(" sapMCrslTopOffset");if(c.getArrowsPlacement()===C.PageIndicator){r.write(" sapMCrslTopArrowsOffset");}}}r.write("'>");var R=function(o,i,A){r.write("<div class='sapMCrslItem");r.write("' id='"+c.sId+"-"+o.sId+"-slide'");r.writeAccessibilityState(o,{role:"listitem",posinset:i+1,setsize:A.length});r.write(">");r.renderControl(c._createScrollContainer(o,i));r.write("</div>");};p.forEach(R);r.write("</div>");};
a._renderClosingDiv=function(r){r.write('</div>');};
a._renderPageIndicatorAndArrows=function(s,c){var r=s.rm,p=s.iPageCount,S=D.system.desktop&&s.sArrowsPlacement===C.PageIndicator,b=s.bBottom,I=s.sId,d=s.iIndex,B=s.iBulletsToNumbersThreshold,e=s.bShowPageIndicator,f=e?'':'opacity: 0',R=sap.ui.getCore().getLibraryResourceBundle('sap.m'),o="",t=R.getText("CAROUSEL_PAGE_INDICATOR_TEXT",[d+1,p]),n=c._getNumberOfItemsToShow(),t=R.getText("CAROUSEL_PAGE_INDICATOR_TEXT",[d+1,p-n+1]),g=1;if(p<=c._getNumberOfItemsToShow()){return;}if(!e&&!S){return;}if(b){o+=" sapMCrslControlsBottom";}else{o+=" sapMCrslControlsTop";}if(S){r.write('<div');r.addClass("sapMCrslControls");r.addClass(o);r.writeClasses();r.write('>');r.write('<div class="sapMCrslControlsContainer'+o+'">');}else{r.write('<div class="sapMCrslControlsNoArrows'+o+'">');}if(S){this._renderPrevArrow(r,c);}var h=I+'-pageIndicator';r.write('<div id="'+h+'" style="'+f+'"');if(p<B){r.write(' class="sapMCrslBulleted">');for(var i=1;i<=p-n+1;i++){r.write("<span role='img' data-slide="+g+" aria-label='"+R.getText('CAROUSEL_POSITION',[i,p])+"'>"+i+"</span>");g++;}}else{r.write(' class="sapMCrslNumeric">');r.write('<span id='+I+'-'+'slide-number>'+t+'</span>');}r.write('</div>');if(S){this._renderNextArrow(r,c);}if(!S){r.write('</div>');}if(S){r.write('</div>');r.write('</div>');}};
a._renderHudArrows=function(r,c){var b;if(c.getShowPageIndicator()){if(c.getPageIndicatorPlacement()===P.Top){b="sapMCrslHudTop";}else if(c.getPageIndicatorPlacement()===P.Bottom){b="sapMCrslHudBottom";}}else{b="sapMCrslHudMiddle";}var h=c.getId()+'-hud';r.write('<div id="'+h+'" class="sapMCrslHud '+b+'">');this._renderPrevArrow(r,c);this._renderNextArrow(r,c);r.write("</div>");};
a._renderPrevArrow=function(r,c){r.write("<a class='sapMCrslPrev' href='#' data-slide='prev' tabindex='-1'><div class='sapMCrslArrowInner'>");r.renderControl(c._getNavigationArrow('left'));r.write("</div></a>");};
a._renderNextArrow=function(r,c){r.write("<a class='sapMCrslNext' href='#' data-slide='next' tabindex='-1'><div class='sapMCrslArrowInner'>");r.renderControl(c._getNavigationArrow('right'));r.write("</div></a>");};
return a;},true);
sap.ui.predefine('sap/m/CheckBox',['./Label','./library','sap/ui/Device','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/EnabledPropagator','sap/ui/core/library','./CheckBoxRenderer',"sap/ui/thirdparty/jquery"],function(L,l,D,C,I,E,c,a,q){"use strict";var V=c.ValueState;var T=c.TextAlign;var b=c.TextDirection;
var d=C.extend("sap.m.CheckBox",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{selected:{type:"boolean",group:"Data",defaultValue:false},partiallySelected:{type:"boolean",group:"Data",defaultValue:false},enabled:{type:"boolean",group:"Behavior",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:null},text:{type:"string",group:"Appearance",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:b.Inherit},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:T.Begin},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},useEntireWidth:{type:"boolean",group:"Appearance",defaultValue:false},activeHandling:{type:"boolean",group:"Misc",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:V.None},displayOnly:{type:"boolean",group:"Behavior",defaultValue:false},wrapping:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{_label:{type:"sap.m.Label",group:"Behavior",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{parameters:{selected:{type:"boolean"}}}},designtime:"sap/m/designtime/CheckBox.designtime"}});
E.call(d.prototype);
d.prototype.init=function(){this.addActiveState(this);I.insertFontFaceStyle();};
d.prototype.exit=function(){this._oLabel=null;delete this._iTabIndex;};
d.prototype.setSelected=function(s){if(s===this.getSelected()){return this;}this.$("CbBg").toggleClass("sapMCbMarkChecked",!!s);var o=this.getDomRef("CB");if(o){s?o.setAttribute('checked','checked'):o.removeAttribute('checked');}this.setProperty("selected",s,true);this.$().attr("aria-checked",this._getAriaChecked());return this;};
d.prototype.setPartiallySelected=function(p){if(p===this.getPartiallySelected()){return this;}this.setProperty("partiallySelected",p,true);this.$("CbBg").toggleClass("sapMCbMarkPartiallyChecked",p);this.$().attr("aria-checked",this._getAriaChecked());return this;};
d.prototype.setText=function(t){var o=this._getLabel(),h=!!t;this.setProperty("text",t,true);o.setText(t);this.$().toggleClass("sapMCbHasLabel",h);return this;};
d.prototype.setWidth=function(w){this.setProperty("width",w,true);this._setWidth();return this;};
d.prototype.setUseEntireWidth=function(u){this.setProperty("useEntireWidth",u,true);this._setWidth();return this;};
d.prototype.setTextDirection=function(s){var o=this._getLabel();this.setProperty("textDirection",s,true);o.setTextDirection(s);return this;};
d.prototype.setTextAlign=function(A){var o=this._getLabel();this.setProperty("textAlign",A,true);o.setTextAlign(A);return this;};
d.prototype.setWrapping=function(w){var o=this._getLabel();this.setProperty("wrapping",w,true);o.setWrapping(w);this.$().toggleClass("sapMCbWrapped",w);return this;};
d.prototype.addActiveState=function(o){if(D.os.blackberry){o.addDelegate({ontouchstart:function(e){q(o.getDomRef()).addClass("sapMActive");},ontouchend:function(e){q(o.getDomRef()).removeClass("sapMActive");}});}};
d.prototype.ontouchstart=function(e){e.originalEvent._sapui_handledByControl=true;};
d.prototype.ontap=function(e){var s;if(this.getEnabled()&&this.getEditable()&&!this.getDisplayOnly()){this.$().focus();s=this._getSelectedState();this.setSelected(s);this.setPartiallySelected(false);this.fireSelect({selected:s});e&&e.setMarked();}};
d.prototype.onsapspace=function(e){this.ontap(e);if(e){e.preventDefault();e.stopPropagation();}};
d.prototype.onsapenter=function(e){this.ontap(e);};
d.prototype.setTabIndex=function(t){this._iTabIndex=t;this.$("CbBg").attr("tabindex",t);return this;};
d.prototype.getTabIndex=function(){if(this.hasOwnProperty("_iTabIndex")){return this._iTabIndex;}return(this.getEnabled()&&!this.getDisplayOnly())?0:-1;};
d.prototype._getLabel=function(){if(!this._oLabel){this._oLabel=new L(this.getId()+"-label",{labelFor:this.getId()}).addStyleClass("sapMCbLabel");this.setAggregation("_label",this._oLabel,true);}return this.getAggregation("_label");};
d.prototype._setWidth=function(){var o=this._getLabel(),$=this.$(),w=this.getWidth();if(this.getUseEntireWidth()){o.setWidth("");$.outerWidth(w);}else{$.outerWidth("");o.setWidth(w);}};
d.prototype._getSelectedState=function(){var s=this.getSelected(),p=this.getPartiallySelected();return(s===p)||(!s&&p);};
d.prototype._getAriaChecked=function(){var s=this.getSelected();if(this.getPartiallySelected()&&s){return"mixed";}return s;};
d.prototype.getAccessibilityInfo=function(){var B=sap.ui.getCore().getLibraryResourceBundle("sap.m");return{role:"checkbox",type:B.getText("ACC_CTR_TYPE_CHECKBOX"),description:(this.getText()||"")+(this.getSelected()?(" "+B.getText("ACC_CTR_STATE_CHECKED")):""),focusable:this.getEnabled()&&!this.getDisplayOnly(),enabled:this.getEnabled(),editable:this.getEditable()};};
d.prototype.getFormDoNotAdjustWidth=function(){return this.getText()?false:true;};
return d;});
sap.ui.predefine('sap/m/CheckBoxRenderer',['sap/ui/core/library','sap/ui/core/ValueStateSupport','sap/ui/Device'],function(c,V,D){"use strict";var a=c.ValueState;var C={};
C.render=function(r,o){var i=o.getId(),e=o.getEnabled(),d=o.getDisplayOnly(),E=o.getEditable(),I=e&&!d,b=e&&d,f=o.getAggregation("_label"),v=o.getValueState(),g=a.Error===v,h=a.Warning===v,j=a.Success===v,k=a.Information===v,u=o.getUseEntireWidth();r.write("<div");r.addClass("sapMCb");if(!E){r.addClass("sapMCbRo");}if(b){r.addClass("sapMCbDisplayOnly");}if(!e){r.addClass("sapMCbBgDis");}if(g){r.addClass("sapMCbErr");}else if(h){r.addClass("sapMCbWarn");}else if(j){r.addClass("sapMCbSucc");}else if(k){r.addClass("sapMCbInfo");}if(o.getText()){r.addClass("sapMCbHasLabel");}if(o.getWrapping()){r.addClass("sapMCbWrapped");}r.writeControlData(o);r.writeClasses();if(u){r.addStyle("width",o.getWidth());r.writeStyles();}var t=V.enrichTooltip(o,o.getTooltip_AsString());if(t){r.writeAttributeEscaped("title",t);}if(I){r.writeAttribute("tabindex",o.getTabIndex());}r.writeAccessibilityState(o,{role:"checkbox",selected:null,checked:o._getAriaChecked(),describedby:t?i+"-Descr":undefined});if(b){r.writeAttribute("aria-readonly",true);}r.write(">");r.write("<div id='");r.write(o.getId()+"-CbBg'");r.addClass("sapMCbBg");if(I&&E&&D.system.desktop){r.addClass("sapMCbHoverable");}if(!o.getActiveHandling()){r.addClass("sapMCbActiveStateOff");}r.addClass("sapMCbMark");if(o.getSelected()){r.addClass("sapMCbMarkChecked");}if(o.getPartiallySelected()){r.addClass("sapMCbMarkPartiallyChecked");}r.writeClasses();r.write(">");r.write("<input type='CheckBox' id='");r.write(o.getId()+"-CB'");if(o.getSelected()){r.writeAttribute("checked","checked");}if(o.getName()){r.writeAttributeEscaped('name',o.getName());}if(!e){r.write(" disabled=\"disabled\"");}if(!E){r.write(" readonly=\"readonly\"");}r.write(" /></div>");r.renderControl(f);if(t&&sap.ui.getCore().getConfiguration().getAccessibility()){r.write("<span id=\""+i+"-Descr\" class=\"sapUiHidden\">");r.writeEscaped(t);r.write("</span>");}r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/m/ColorPalette',['sap/ui/core/Control','sap/ui/Device','sap/ui/base/DataType','sap/ui/core/library','sap/ui/core/delegate/ItemNavigation','./Button','./Dialog','./library','./ColorPaletteRenderer',"sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery"],function(C,D,a,c,I,B,b,l,d,e,K,q){"use strict";var f=c.CSSColor;var g;var h;var i=l.ButtonType;var j=a.getType("boolean");var k="sapMColorPaletteSquare";var S=5;var M=2;var m=15;var L=sap.ui.getCore().getLibraryResourceBundle("sap.m");
var n=C.extend("sap.m.ColorPalette",{metadata:{library:"sap.m",properties:{colors:{type:"sap.ui.core.CSSColor[]",group:"Appearance",defaultValue:["gold","darkorange","indianred","darkmagenta","cornflowerblue","deepskyblue","darkcyan","olivedrab","darkslategray","azure","white","lightgray","darkgray","dimgray","black"]}},aggregations:{_defaultColorButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_moreColorsButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},events:{colorSelect:{parameters:{"value":{type:"sap.ui.core.CSSColor"},"defaultAction":{type:"boolean"}}}}}});
n.prototype.init=function(){this._oDefaultColor=null;this._bShowDefaultColorButton=false;this._bShowMoreColorsButton=false;this._oMoreColorsDialog=null;this._oItemNavigation=null;};
n.prototype.exit=function(){if(this._oMoreColorsDialog){this._oMoreColorsDialog.destroy();delete this._oMoreColorsDialog;}if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}};
n.prototype.setColors=function(p){p=this.validateProperty("colors",p);if(p.length<M||p.length>m){throw new Error("Cannot set property 'colors' - array must has minimum 2 and maximum 15 elements");}return this.setProperty("colors",p);};
n.prototype.ontap=function(E){var t=q(E.target),s,$;$=t.closest("."+k);if(!$.length){return;}s=$.attr("data-sap-ui-color");this._fireColorSelect(s,false,E);};
n.prototype.onsaptabnext=n.prototype.onsaptabprevious=function(E){var p=this._getElementInfo(E.target);if(p.bIsMoreColorsButton){this.fireEvent("_colorNotSelected",{_originalEvent:E});return;}if(p.bIsDefaultColorButton){this._fireColorSelect(this._getDefaultColor(),true,E);return;}n.prototype.ontap.apply(this,arguments);};n.prototype.onsapenter=n.prototype.ontap;
n.prototype.onkeyup=function(E){if(E.which===K.SPACE){E.preventDefault();n.prototype.ontap.apply(this,arguments);}};
n.prototype.onsaphome=n.prototype.onsapend=function(E){var p=this._getElementInfo(E.target);if(p.bIsDefaultColorButton||p.bIsMoreColorsButton){E.preventDefault();E.stopImmediatePropagation(true);}};
n.prototype.onAfterRendering=function(){this._ensureItemNavigation();};
n.prototype._createDefaultColorButton=function(){return new B(this.getId()+"-btnDefaultColor",{width:"100%",type:i.Transparent,text:L.getText("COLOR_PALETTE_DEFAULT_COLOR"),visible:this._getShowDefaultColorButton(),press:function(E){this._fireColorSelect(this._getDefaultColor(),true,E);}.bind(this)});};
n.prototype._getDefaultColor=function(){return this._oDefaultColor;};
n.prototype._setDefaultColor=function(p){if(!f.isValid(p)){throw new Error("Cannot set internal property '_defaultColor' - invalid value: "+p);}this._oDefaultColor=p;return this;};
n.prototype._getShowDefaultColorButton=function(){return this._bShowDefaultColorButton;};
n.prototype._setShowDefaultColorButton=function(v){if(!j.isValid(v)){throw new Error("Cannot set internal property 'showDefaultColorButton' - invalid value: "+v);}this._bShowDefaultColorButton=v;if(v&&!this._getDefaultColorButton()){this.setAggregation("_defaultColorButton",this._createDefaultColorButton());}if(this._getDefaultColorButton()){this._getDefaultColorButton().setVisible(v);}return this;};
n.prototype._getDefaultColorButton=function(){return this.getAggregation("_defaultColorButton");};
n.prototype._createMoreColorsButton=function(){return new B(this.getId()+"-btnMoreColors",{width:"100%",type:i.Transparent,text:L.getText("COLOR_PALETTE_MORE_COLORS"),visible:this._getShowMoreColorsButton(),press:this._openColorPicker.bind(this)});};
n.prototype._getShowMoreColorsButton=function(){return this._bShowMoreColorsButton;};
n.prototype._setShowMoreColorsButton=function(v){if(!j.isValid(v)){throw new Error("Cannot set internal property 'showMoreColorsButton' - invalid value: "+v);}this._bShowMoreColorsButton=v;if(v&&!this._getMoreColorsButton()){this.setAggregation("_moreColorsButton",this._createMoreColorsButton());}if(this._getMoreColorsButton()){this._getMoreColorsButton().setVisible(v);}return this;};
n.prototype._getMoreColorsButton=function(){return this.getAggregation("_moreColorsButton");};
n.prototype._openColorPicker=function(){this.fireEvent("_beforeOpenColorPicker");this._ensureMoreColorsDialog().open();};
n.prototype._ensureMoreColorsDialog=function(){if(!this._oMoreColorsDialog){this._oMoreColorsDialog=this._createMoreColorsDialog();}return this._oMoreColorsDialog;};
n.prototype._createMoreColorsDialog=function(){var p=new b(this.getId()+"-moreColorsDialog",{stretch:!!D.system.phone,title:L.getText("COLOR_PALETTE_MORE_COLORS_TITLE")}).addStyleClass("CPDialog");this._ensureUnifiedLibrary();p.addContent(p._oColorPicker=new g({mode:h.HSL}));p.setBeginButton(new B({text:L.getText("COLOR_PALETTE_MORE_COLORS_CONFIRM"),press:function(E){p.close();if(p._oColorPicker.getColorString()){this._fireColorSelect(p._oColorPicker.getColorString(),false,E);}}.bind(this)}));p.setEndButton(new B({text:L.getText("COLOR_PALETTE_MORE_COLORS_CANCEL"),press:function(){p.close();}}));return p;};
n.prototype._ensureUnifiedLibrary=function(){var u;if(!g){sap.ui.getCore().loadLibrary("sap.ui.unified");u=sap.ui.require("sap/ui/unified/library");g=sap.ui.requireSync("sap/ui/unified/ColorPicker");h=u.ColorPickerMode;}};
n.prototype._focusFirstElement=function(){var F=this._getShowDefaultColorButton()?this._getDefaultColorButton().getDomRef():this._getAllSwatches()[0];F.focus();};
n.prototype._fireColorSelect=function(p,r,O){this.fireColorSelect({value:p,defaultAction:r,_originalEvent:O});};
n.prototype._ensureItemNavigation=function(){var p=[];if(!this._oItemNavigation){this._oItemNavigation=new o(this);this._oItemNavigation.setColumns(S);this._oItemNavigation.setCycling(false);this.addDelegate(this._oItemNavigation);this._oItemNavigation.attachEvent(I.Events.BorderReached,this._onSwatchContainerBorderReached,this);}p=p.concat(this._getAllSwatches());this._oItemNavigation.setRootDomRef(this.getDomRef("swatchCont"));this._oItemNavigation.setItemDomRefs(p);};
n.prototype._onSwatchContainerBorderReached=function(E){var N,s,H=["saphome","sapend"].indexOf(E.getParameter("event").type)>-1;if(E.getParameter(o.BorderReachedDirection)===o.BorderReachedDirectionForward){if(this._getShowMoreColorsButton()){N=this._getMoreColorsButton();}else if(!H&&this._getShowDefaultColorButton()){N=this._getDefaultColorButton();}else if(!H){N=this._getAllSwatches()[0];}}else{if(this._getShowDefaultColorButton()){N=this._getDefaultColorButton();}else if(!H&&this._getShowMoreColorsButton()){N=this._getMoreColorsButton();}else if(!H){s=this._getAllSwatches();N=s[this._oItemNavigation._getIndexOfTheFirstItemInLastRow()];}}if(N){N.focus();}return N;};
n.prototype.onsapnext=function(E){var N,p=this._getElementInfo(E.target);if(!(p.bIsDefaultColorButton||p.bIsMoreColorsButton)){return;}E.preventDefault();E.stopImmediatePropagation(true);if(p.bIsDefaultColorButton){N=this._getAllSwatches()[0];}else{N=this._getShowDefaultColorButton()?this._getDefaultColorButton():this._getAllSwatches()[0];}N.focus();};
n.prototype.onsapprevious=function(E){var N,F=this._getElementInfo(E.target),A;if(!(F.bIsDefaultColorButton||F.bIsMoreColorsButton)){return;}E.preventDefault();E.stopImmediatePropagation(true);A=this._getAllSwatches();if(F.bIsMoreColorsButton){N=E.keyCode===K.ARROW_UP?A[this._oItemNavigation._getIndexOfTheFirstItemInLastRow()]:A[A.length-1];}else{N=this._getShowMoreColorsButton()?this._getMoreColorsButton():A[this._oItemNavigation._getIndexOfTheFirstItemInLastRow()];}N.focus();};
n.prototype._getAllSwatches=function(){return this.$().find("."+k).get();};
n.prototype._getElementInfo=function(E){var p=this._getShowDefaultColorButton()&&e(E,this._getDefaultColorButton().getDomRef()),r=!p&&this._getShowMoreColorsButton()&&e(E,this._getMoreColorsButton().getDomRef()),s=!r&&!p&&q(E).hasClass(k);return{bIsDefaultColorButton:p,bIsMoreColorsButton:r,bIsASwatch:s};};
var o=I.extend("sap.m.ItemNavigationHomeEnd",{constructor:function(){I.apply(this,arguments);this.setHomeEndColumnMode(true);this.fireEvent=function(N,E){var s;if(N===I.Events.BorderReached){s=o.BorderReachedDirectionBackward;if(["sapnext","sapend"].indexOf(E.event.type)>-1){s=o.BorderReachedDirectionForward;}E[o.BorderReachedDirection]=s;}I.prototype.fireEvent.apply(this,arguments);};}});
o.BorderReachedDirection="direction";o.BorderReachedDirectionForward="BorderReachedDirectionForward";o.BorderReachedDirectionBackward="BorderReachedDirectionBackward";
o.prototype.getColumns=function(){return this.iColumns;};
o.prototype.onsapprevious=function(E){var p=e(this.getRootDomRef(),E.target),A=E.keyCode===K.ARROW_UP&&this.getFocusedIndex()===0;if(!p){return;}if(!A){I.prototype.onsapprevious.apply(this,arguments);return;}E.preventDefault();this.fireEvent(I.Events.BorderReached,{index:0,event:E});};
o.prototype.onsapnext=function(E){var p=e(this.getRootDomRef(),E.target),r,s,t;if(!p){return;}if(E.keyCode!==K.ARROW_DOWN){I.prototype.onsapnext.apply(this,arguments);return;}s=this.getFocusedIndex();t=this._getItemInfo(s);if(t.bIsLastItem&&t.bIsInTheLastColumn){E.preventDefault();this.fireEvent(I.Events.BorderReached,{index:s,event:E});return;}if(t.bNextRowExists&&!t.bItemSameColumnNextRowExists){E.preventDefault();r=this.getItemDomRefs();r[r.length-1].focus();return;}I.prototype.onsapnext.apply(this,arguments);};
o.prototype.onsaphome=function(E){var p=e(this.getRootDomRef(),E.target),r;if(!p){return;}r=this._getItemInfo(this.getFocusedIndex());if(!r.bIsInTheFirstColumn){I.prototype.onsaphome.apply(this,arguments);return;}E.preventDefault();if(r.bIsFirstItem){this.fireEvent(I.Events.BorderReached,{index:0,event:E});}else{this.getItemDomRefs()[0].focus();}};
o.prototype.onsapend=function(E){var p=e(this.getRootDomRef(),E.target),r;if(!p){return;}r=this._getItemInfo(this.getFocusedIndex());if(!(r.bIsLastItem||r.bIsInTheLastColumn)){I.prototype.onsapend.apply(this,arguments);return;}E.preventDefault();if(r.bIsLastItem){this.fireEvent(I.Events.BorderReached,{index:this.getItemDomRefs().length-1,event:E});}else{this.getItemDomRefs()[this.getItemDomRefs().length-1].focus();}};
o.prototype._getItemInfo=function(p){var r=this.getItemDomRefs().length,s=p===(r-1),t=r>this.getColumns()?this.getColumns():r,u=p%this.getColumns()===0,v=(p+1)%t===0,w=Math.floor(p/this.getColumns())+1,N,x;N=w*this.getColumns()<r;x=N&&(p+this.getColumns())<r;return{bIsFirstItem:p===0,bIsLastItem:s,bIsInTheLastColumn:v,bIsInTheFirstColumn:u,bNextRowExists:N,bItemSameColumnNextRowExists:x};};
o.prototype._getIndexOfTheFirstItemInLastRow=function(){return Math.floor((this.getItemDomRefs().length-1)/this.getColumns())*this.getColumns();};
n.prototype._ItemNavigation=o;n.prototype._ColorsHelper={RGB_TO_NAMED_COLORS_MAP:{"#FFB200":"gold","#FF8C00":"darkorange","#CD5C5C":"indianred","#8B008B":"darkmagenta","#6495ED":"cornflowerblue","#00BFFF":"deepskyblue","#008B8B":"darkcyan","#6B8E23":"olivedrab","#2F4F4F":"darkslategray","#F0FFFF":"azure","#FFFFFF":"white","#D3D3D3":"lightgray","#A9A9A9":"darkgray","#696969":"dimgray","#000000":"black"},NAME_COLORS_TO_RGB_MAP:{"gold":"#FFB200","darkorange":"#FF8C00","indianred":"#CD5C5C","darkmagenta":"#8B008B","cornflowerblue":"#6495ED","deepskyblue":"#00BFFF","darkcyan":"#008B8B","olivedrab":"#6B8E23","darkslategray":"#2F4F4F","azure":"#F0FFFF","white":"#FFFFFF","lightgray":"#D3D3D3","darkgray":"#A9A9A9","dimgray":"#696969","black":"#000000"},getNamedColor:function(s){var H="";if(!s||s.toLowerCase().indexOf("hsl")!==-1){return undefined;}if(s.indexOf("#")===-1){return this.NAME_COLORS_TO_RGB_MAP[s.toLowerCase()]?s.toLowerCase():undefined;}if(s.length===4){H=["#",s[1],s[1],s[2],s[2],s[3],s[3]].join("");}else{H=s;}H=H.toUpperCase();return this.RGB_TO_NAMED_COLORS_MAP[H];}};return n;});
sap.ui.predefine('sap/m/ColorPalettePopover',['sap/ui/core/Control','sap/ui/Device','./Button','./ResponsivePopover','./ColorPalette','./library'],function(C,D,B,R,a,l){"use strict";var P=l.PlacementType;
var b=C.extend("sap.m.ColorPalettePopover",{
metadata:{library:"sap.m",publicMethods:["openBy","close"],properties:{defaultColor:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null},colors:{type:"sap.ui.core.CSSColor[]",group:"Appearance",defaultValue:["gold","darkorange","indianred","darkmagenta","cornflowerblue","deepskyblue","darkcyan","olivedrab","darkslategray","azure","white","lightgray","darkgray","dimgray","black"]},showDefaultColorButton:{type:"boolean",group:"Appearance",defaultValue:true},showMoreColorsButton:{type:"boolean",group:"Appearance",defaultValue:true}},events:{colorSelect:{parameters:{"value":{type:"sap.ui.core.CSSColor"},"defaultAction":{type:"boolean"}}}}},
renderer:{}
});
var L=sap.ui.getCore().getLibraryResourceBundle("sap.m");var F={COLOR_PALETTE_PROPS:{colors:"setColors",defaultColor:"_setDefaultColor",showDefaultColorButton:"_setShowDefaultColorButton",showMoreColorsButton:"_setShowMoreColorsButton"},POPOVER_METHODS:{getDomRef:"",close:""}};
b.prototype.init=function(){this._oPopover=null;this._bPopoverDestroying=null;};
b.prototype.exit=function(){this._bPopoverDestroying=true;if(this._oPopover){this._oPopover.removeDelegate(this._oPopover._onAfterRenderingDelegate);this._oPopover.destroy();this._oPopover=null;}};
b.prototype.openBy=function(o){return R.prototype.openBy.apply(this._ensurePopover(),arguments);};
b.prototype._getPalette=function(){return this._ensurePopover().getContent()[0];};
b.prototype._ensurePopover=function(){if(!this._oPopover){this._oPopover=this._createPopover();}return this._oPopover;};
b.prototype._createPopover=function(){var p,c=this._createColorPalette(),d;p=new R(this.getId()+"-colorPalettePopover",{showHeader:D.system.phone,placement:P.VerticalPreferredBottom,showArrow:false,showCloseButton:false,title:L.getText("COLOR_PALETTE_TITLE"),content:c,afterOpen:c._focusFirstElement.bind(c)}).addStyleClass("sapMColorPaletteContainer");if(D.system.phone){p.setEndButton(new B({text:L.getText("COLOR_PALETTE_CANCEL"),press:function(){p.close();}}));}c.attachEvent("_beforeOpenColorPicker",function(){p.close();});c.attachEvent("_colorNotSelected",function(e){this._handleNextOrPreviousUponPaletteClose(e);p.close();}.bind(this));c.attachEvent("colorSelect",function(e){this._handleNextOrPreviousUponPaletteClose(e);p.close();this.fireColorSelect({"value":e.getParameter("value"),"defaultAction":e.getParameter("defaultAction")});}.bind(this));d={onAfterRendering:function(){var $=this.$();$.attr("aria-modal","true");$.attr("aria-label",this.getTitle());}};p.addEventDelegate(d,p);p._onAfterRenderingDelegate=d;return p;};
b.prototype._createColorPalette=function(){var c=new a(this.getId()+"-palette");c._setShowDefaultColorButton(this.getShowDefaultColorButton());c._setShowMoreColorsButton(this.getShowMoreColorsButton());return c;};
b.prototype._handleNextOrPreviousUponPaletteClose=function(e){var o=e.getParameter("_originalEvent");if(!o){return;}if(o.type==="saptabnext"||o.type==="saptabprevious"){o.stopPropagation();o.preventDefault();}};
b.prototype.setProperty=function(p,v,s){var t;if(F.COLOR_PALETTE_PROPS[p]!==undefined){t=F.COLOR_PALETTE_PROPS[p]||p;a.prototype[t].call(this._getPalette(),v);}return C.prototype.setProperty.apply(this,arguments);};
Object.keys(F.POPOVER_METHODS).forEach(function(s){var t=F.COLOR_PALETTE_PROPS[s]||s;b.prototype[s]=function(){if(this._bPopoverDestroying){return null;}var p=this._ensurePopover();return p[t].apply(p,arguments);};});return b;});
sap.ui.predefine('sap/m/ColorPaletteRenderer',['sap/ui/Device'],function(D){"use strict";var C={};var l=sap.ui.getCore().getLibraryResourceBundle("sap.m");
C.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapMColorPalette");r.writeClasses();r.write(">");if(c._getShowDefaultColorButton()){this.renderDefaultColorButton(r,c);this.renderSeparator(r);}this.renderSwatches(r,c);if(c._getShowMoreColorsButton()){this.renderSeparator(r);this.renderMoreColorsButton(r,c);if(D.system.phone){this.renderSeparator(r);}}r.write("</div>");};
C.renderSwatches=function(r,c){var s=c.getColors();r.write("<div id='"+c.getId()+"-swatchCont'");r.addClass("sapMColorPaletteContent");r.writeClasses();r.writeAccessibilityState(c,{"role":"region","label":l.getText("COLOR_PALETTE_SWATCH_CONTAINER_TITLE")});r.write(">");s.forEach(function(a,i){this.renderSquare(r,c,a,i);},this);r.write("</div>");};
C.renderSquare=function(r,c,s,i){var n=c._ColorsHelper.getNamedColor(s),a=(n===undefined)?l.getText("COLOR_PALETTE_PREDEFINED_COLOR_CUSTOM"):l.getText("COLOR_PALETTE_PREDEFINED_COLOR_"+n.toUpperCase()),b=l.getText("COLOR_PALETTE_PREDEFINED_COLOR",[i+1,a]);r.write("<div");r.addClass("sapMColorPaletteSquare");r.writeClasses();r.writeAttribute("data-sap-ui-color",s);r.writeAttribute("tabindex","-1");r.writeAttribute("title",b);r.writeAccessibilityState(c,{"role":"button","label":b});r.write(">");r.write("<div");r.addStyle("background-color",s);r.writeStyles();r.write("></div>");r.write("</div>");};
C.renderSeparator=function(r){r.write("<div");r.addClass("sapMColorPaletteSeparator");r.writeClasses();r.write(">");r.write("<hr/>");r.write("</div>");};
C.renderDefaultColorButton=function(r,c){r.renderControl(c._getDefaultColorButton());};
C.renderMoreColorsButton=function(r,c){r.renderControl(c._getMoreColorsButton());};
return C;},true);
sap.ui.predefine('sap/m/Column',['./library','sap/ui/core/Element','sap/ui/core/Renderer','sap/ui/core/library','sap/ui/Device',"sap/ui/thirdparty/jquery"],function(l,E,R,c,D,q){"use strict";var P=l.PopinDisplay;var V=c.VerticalAlign;var T=c.TextAlign;var S=c.SortOrder;
var C=E.extend("sap.m.Column",{metadata:{library:"sap.m",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},hAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:T.Begin},vAlign:{type:"sap.ui.core.VerticalAlign",group:"Appearance",defaultValue:V.Inherit},styleClass:{type:"string",group:"Appearance",defaultValue:null},visible:{type:"boolean",group:"Appearance",defaultValue:true},minScreenWidth:{type:"string",group:"Behavior",defaultValue:null},demandPopin:{type:"boolean",group:"Behavior",defaultValue:false},popinHAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:T.Begin,deprecated:true},popinDisplay:{type:"sap.m.PopinDisplay",group:"Appearance",defaultValue:P.Block},mergeDuplicates:{type:"boolean",group:"Behavior",defaultValue:false},mergeFunctionName:{type:"string",group:"Misc",defaultValue:'getText'},sortIndicator:{type:"sap.ui.core.SortOrder",group:"Appearance",defaultValue:S.None}},defaultAggregation:"header",aggregations:{header:{type:"sap.ui.core.Control",multiple:false},footer:{type:"sap.ui.core.Control",multiple:false}},designtime:"sap/m/designtime/Column.designtime"}});
C.prototype._index=-1;C.prototype._screen="";C.prototype._media=null;
C.prototype.exit=function(){this._clearMedia();};
C.prototype.getTable=function(){var p=this.getParent();if(p&&p.isA("sap.m.Table")){return p;}};
C.prototype.informTable=function(e,p,v){var t=this.getTable();if(t){var m="onColumn"+e;if(t[m]){t[m](this,p,v);}}};
C.prototype.ontouchstart=function(e){this._bTouchStartMarked=e.isMarked();};
C.prototype.ontap=function(e){if(!this._bTouchStartMarked&&!e.isMarked()){this.informTable("Press");}};
C.prototype.onsapspace=function(e){if(e.srcControl===this){this.informTable("Press");e.preventDefault();}};
C.prototype.onsapenter=C.prototype.onsapspace;
C.prototype.invalidate=function(){var p=this.getParent();if(!p||!p.bOutput){return;}E.prototype.invalidate.apply(this,arguments);};
C.prototype._clearMedia=function(){if(this._media&&this._minWidth){this._detachMediaContainerWidthChange(this._notifyResize,this,this.getId());D.media.removeRangeSet(this.getId());this._media=null;}};
C.prototype._addMedia=function(){delete this._bShouldAddMedia;if(this._minWidth){D.media.initRangeSet(this.getId(),[parseFloat(this._minWidth)]);this._attachMediaContainerWidthChange(this._notifyResize,this,this.getId());this._media=this._getCurrentMediaContainerRange(this.getId());if(this._media){this._media.matches=!!this._media.from;}}};
C.prototype._notifyResize=function(m){if(this._media.from===m.from){return;}this._media=m;this._media.matches=!!m.from;setTimeout(function(){this.fireEvent("media",this);this.informTable("Resize");}.bind(this),0);};
C.prototype._validateMinWidth=function(w){if(!w){return;}if(Object.prototype.toString.call(w)!="[object String]"){throw new Error('expected string for property "minScreenWidth" of '+this);}if(Object.keys(l.ScreenSizes).indexOf(w.toLowerCase())!=-1){return;}if(!/^\d+(\.\d+)?(px|em|rem)$/i.test(w)){throw new Error('invalid CSS size("px", "em", "rem" required) or sap.m.ScreenSize enumeration for property "minScreenWidth" of '+this);}};
C.prototype._isWidthPredefined=function(w){var t=this,u=w.replace(/[^a-z]/ig,""),b=parseFloat(l.BaseFontSize)||16;q.each(l.ScreenSizes,function(s,a){if(u!="px"){a/=b;}if(a+u==w){t._minWidth=this+"px";t._screen=s;return false;}});if(this._minWidth){return true;}if(u=="px"){this._minWidth=w;}else{this._minWidth=parseFloat(w)*b+"px";}};
C.prototype.getCssAlign=function(a){a=a||this.getHAlign();if(a===T.Begin||a===T.End||a===T.Initial){a=R.getTextAlign(a);}return a.toLowerCase();};
C.prototype.getStyleClass=function(r){var a=this.getProperty("styleClass");if(!r){return a;}if(this._screen&&(!this.getDemandPopin()||!window.matchMedia)){a+=" sapMSize-"+this._screen;}else if(this._media&&!this._media.matches){a+=" sapMListTblNone";}return a.trim();};
C.prototype.setIndex=function(n){this._index=+n;};
C.prototype.setOrder=function(n){this._order=+n;};
C.prototype.getOrder=function(){return this.hasOwnProperty("_order")?this._order:this.getInitialOrder();};
C.prototype.setInitialOrder=function(n){this._initialOrder=+n;};
C.prototype.getInitialOrder=function(){if(this.hasOwnProperty("_initialOrder")){return this._initialOrder;}var t=this.getTable();if(!t){return-1;}return t.indexOfColumn(this);};
C.prototype.setDisplay=function(t,d){if(!t||this._index<0){return;}var i=this._index+1,p=this.getParent(),a=d?"table-cell":"none",h=t.querySelector("tr > th:nth-child("+i+")"),b=t.querySelectorAll("tr > td:nth-child("+i+")"),e=b.length;h.style.display=a;h.setAttribute("aria-hidden",!d);for(i=0;i<e;i++){b[i].style.display=a;b[i].setAttribute("aria-hidden",!d);}if(p&&p.setTableHeaderVisibility){setTimeout(function(){p.setTableHeaderVisibility(d);},0);}};
C.prototype.setDisplayViaMedia=function(t){var p=this.getParent(),d=this._media&&this._media.matches;if(!this.getDemandPopin()&&this._screen&&p&&p.setTableHeaderVisibility){setTimeout(function(){p.setTableHeaderVisibility(d);},0);}else{this.setDisplay(t,d);}};
C.prototype.setVisible=function(v){if(v==this.getVisible()){return this;}var p=this.getParent(),t=p&&p.getTableDomRef&&p.getTableDomRef(),s=t&&this._index>=0;this.setProperty("visible",v,s);if(s){this.setDisplay(t,v);}return this;};
C.prototype.setMinScreenWidth=function(w){var p=this.getParent();if(w==this.getMinScreenWidth()){return this;}this._validateMinWidth(w);this._clearMedia();this._minWidth=0;this._screen="";if(w){w=w.toLowerCase();var a=l.ScreenSizes[w];if(a){this._screen=w;this._minWidth=a+"px";}else{this._isWidthPredefined(w);}if(p&&p.isActive()){this._addMedia();}else{this._bShouldAddMedia=true;}}return this.setProperty("minScreenWidth",w);};
C.prototype.setDemandPopin=function(v){if(v==this.getDemandPopin()){return this;}if(!this.getMinScreenWidth()){return this.setProperty("demandPopin",v,true);}return this.setProperty("demandPopin",v);};
C.prototype.setSortIndicator=function(s){this.setProperty("sortIndicator",s,true);this.$().attr("aria-sort",this.getSortIndicator().toLowerCase());return this;};
C.prototype.isPopin=function(){if(!this.getDemandPopin()){return false;}if(this._media){return!this._media.matches;}return false;};
C.prototype.isHidden=function(){if(this._media){return!this._media.matches;}if(this._screen&&this._minWidth){return parseFloat(this._minWidth)>window.innerWidth;}return false;};
C.prototype.setLastValue=function(v){if(this.getMergeDuplicates()){this._lastValue=v;}return this;};
C.prototype.clearLastValue=function(){return this.setLastValue(NaN);};
C.prototype.getLastValue=function(){return this._lastValue;};
C.prototype.onItemsRemoved=function(){this.clearLastValue();};
C.prototype.getFocusDomRef=function(){var p=this.getParent();if(p&&p.bActiveHeaders){var o=this.getDomRef();if(o){return o.firstChild;}}return E.prototype.getFocusDomRef.apply(this,arguments);};
return C;});
sap.ui.predefine('sap/m/ColumnListItem',["sap/ui/core/Element","sap/ui/core/library","./library","./ListItemBase","./ColumnListItemRenderer","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/Selectors"],function(E,c,l,L,C,q){"use strict";var a=l.ListType;var V=c.VerticalAlign;
var b=L.extend("sap.m.ColumnListItem",{metadata:{library:"sap.m",properties:{vAlign:{type:"sap.ui.core.VerticalAlign",group:"Appearance",defaultValue:V.Inherit}},defaultAggregation:"cells",aggregations:{cells:{type:"sap.ui.core.Control",multiple:true,singularName:"cell",bindable:"bindable"}}}});
var T=E.extend("sap.m.TablePopin",{ontap:function(e){if(e.isMarked()||L.detectTextSelection(this.getDomRef())){return e.stopImmediatePropagation(true);}if(e.srcControl===this||!q(e.target).is(":sapFocusable")){this.getParent().focus();}}});
b.prototype.TagName="tr";
b.prototype.init=function(){L.prototype.init.call(this);this._bNeedsTypeColumn=false;this._aClonedHeaders=[];};
b.prototype.onAfterRendering=function(){L.prototype.onAfterRendering.call(this);this._checkTypeColumn();};
b.prototype.exit=function(){L.prototype.exit.call(this);this._checkTypeColumn(false);this._destroyClonedHeaders();if(this._oPopin){this._oPopin.destroy(true);this._oPopin=null;}};
b.prototype.setVisible=function(v){L.prototype.setVisible.call(this,v);if(!v&&this.hasPopin()){this.removePopin();}return this;};
b.prototype.getTable=function(){var p=this.getParent();if(p&&p.isA("sap.m.Table")){return p;}};
b.prototype.getPopin=function(){if(!this._oPopin){this._oPopin=new T({id:this.getId()+"-sub"}).addEventDelegate({ontouchstart:this.ontouchstart,ontouchmove:this.ontouchmove,ontap:this.ontap,ontouchend:this.ontouchend,ontouchcancel:this.ontouchcancel,onsaptabnext:this.onsaptabnext,onsaptabprevious:this.onsaptabprevious,onsapup:this.onsapup,onsapdown:this.onsapdown,oncontextmenu:this.oncontextmenu},this).setParent(this,null,true);}return this._oPopin;};
b.prototype.$Popin=function(){return this.$("sub");};
b.prototype.hasPopin=function(){return this._oPopin;};
b.prototype.removePopin=function(){this._oPopin&&this.$Popin().remove();};
b.prototype.getTabbables=function(){return this.$().add(this.$Popin()).find(":sapTabbable");};
b.prototype.getAccessibilityType=function(B){return B.getText("ACC_CTR_TYPE_ROW");};
b.prototype.getContentAnnouncement=function(B){var t=this.getTable();if(!t){return;}var A="",d=this.getCells(),e=t.getColumns(true);e.forEach(function(o){var f=d[o.getInitialOrder()];if(!f||!o.getVisible()||(o.isHidden()&&!o.isPopin())){return;}var h=o.getHeader();if(h&&h.getVisible()){A+=L.getAccessibilityText(h)+" ";}A+=L.getAccessibilityText(f,true)+" ";});return A;};
b.prototype.updateSelectedDOM=function(s,t){L.prototype.updateSelectedDOM.apply(this,arguments);if(this.hasPopin()){this.$Popin().attr("aria-selected",s);}};
b.prototype.onfocusin=function(e){if(e.isMarked()||e.srcControl!==this){return;}this.$().children(".sapMListTblCellDup").find(":sapTabbable").attr("tabindex",-1);L.prototype.onfocusin.apply(this,arguments);};
b.prototype._checkTypeColumn=function(n){if(n==undefined){n=this._needsTypeColumn();}if(this._bNeedsTypeColumn!=n){this._bNeedsTypeColumn=n;this.informList("TypeColumnChange",n);}};
b.prototype._needsTypeColumn=function(){var t=this.getType();return this.getVisible()&&(t==a.Detail||t==a.Navigation||t==a.DetailAndActive);};
b.prototype._addClonedHeader=function(h){return this._aClonedHeaders.push(h);};
b.prototype._destroyClonedHeaders=function(){if(this._aClonedHeaders.length){this._aClonedHeaders.forEach(function(o){o.destroy("KeepDom");});this._aClonedHeaders=[];}};
b.prototype._activeHandlingInheritor=function(){this._toggleActiveClass(true);};
b.prototype._inactiveHandlingInheritor=function(){this._toggleActiveClass(false);};
b.prototype._toggleActiveClass=function(s){if(this.hasPopin()){this.$Popin().toggleClass("sapMLIBActive",s);}};
return b;});
sap.ui.predefine('sap/m/ColumnListItemRenderer',["sap/ui/core/Renderer","sap/ui/core/library","sap/ui/Device","./library","./ListItemBaseRenderer","./Label","sap/base/Log","sap/base/security/encodeXML"],function(R,c,D,l,L,a,b,e){"use strict";var P=l.PopinDisplay;var V=c.VerticalAlign;var d=l.PopinLayout;var C=R.extend(L);
C.render=function(r,o){var t=o.getTable();if(!t){return;}L.render.apply(this,arguments);if(o.getVisible()&&t.hasPopin()){this.renderPopin(r,o,t);}};
C.renderHighlight=function(r,o){r.write('<td class="sapMListTblHighlightCell" aria-hidden="true">');L.renderHighlight.apply(this,arguments);r.write('</td>');};
C.renderType=function(r,o){r.write('<td class="sapMListTblNavCol" aria-hidden="true">');L.renderType.apply(this,arguments);r.write('</td>');};
C.renderModeContent=function(r,o){r.write('<td class="sapMListTblSelCol" aria-hidden="true">');L.renderModeContent.apply(this,arguments);r.write('</td>');};
C.renderCounter=function(r,o){};
C.getAriaRole=function(o){return"";};
C.renderLIAttributes=function(r,o){r.addClass("sapMListTblRow");var A=o.getVAlign();if(A!=V.Inherit){r.addClass("sapMListTblRow"+A);}var t=o.getTable();if(t&&t.getAlternateRowColors()){var p=t.indexOfItem(o);if(p%2==0){r.addClass("sapMListTblRowAlternate");}}};
C.renderLIContentWrapper=function(r,o){var t=o.getTable();if(!t){return;}var f=t.getColumns(true),g=o.getCells();o._destroyClonedHeaders();f.forEach(function(h,i){var j,H,k=true,m=g[h.getInitialOrder()];if(!m||!h.getVisible()||h.isPopin()){h.setIndex(-1);return;}r.write("<td");r.addClass("sapMListTblCell");r.writeAttribute("id",o.getId()+"_cell"+i);r.writeAttribute("data-sap-ui-column",h.getId());if(h){j=h.getStyleClass(true);j&&r.addClass(e(j));H=h.getHeader();if(H){r.writeAttribute("headers",H.getId());}if(!t.hasPopin()&&h.getMergeDuplicates()){var F=h.getMergeFunctionName(),n=F.split("#"),s=n[1],p=n[0];if(typeof m[p]!="function"){b.warning("mergeFunctionName property is defined on "+h+" but this is not function of "+m);}else if(t._bRendering||!m.bOutput){var q=h.getLastValue(),u=m[p](s);if(q===u){k=sap.ui.getCore().getConfiguration().getAccessibility();m.addStyleClass("sapMListTblCellDupCnt");r.addClass("sapMListTblCellDup");}else{h.setLastValue(u);}}else if(m.hasStyleClass("sapMListTblCellDupCnt")){r.addClass("sapMListTblCellDup");}}h.getVAlign()!="Inherit"&&r.addStyle("vertical-align",h.getVAlign().toLowerCase());var A=h.getCssAlign();if(A){r.addStyle("text-align",A);}r.writeStyles();}r.writeClasses();r.write(">");if(k){this.applyAriaLabelledBy(H,m);r.renderControl(m);}r.write("</td>");},this);};
C.applyAriaLabelledBy=function(h,o){if(o&&o.removeAriaLabelledBy){o.removeAriaLabelledBy(o.data("ariaLabelledBy")||undefined);}if(h&&h.getText&&o.addAriaLabelledBy&&h.getVisible()){o.addAriaLabelledBy(h);o.data("ariaLabelledBy",h.getId());}};
C.renderPopin=function(r,o,t){o.removePopin();r.write("<tr");r.addClass("sapMListTblSubRow");r.writeElementData(o.getPopin());r.writeAttribute("tabindex","-1");if(o.isSelectable()){r.writeAttribute("aria-selected",o.getSelected());}r.writeClasses();r.write(">");this.renderHighlight(r,o);r.write("<td");r.writeAttribute("id",o.getId()+"-subcell");r.writeAttribute("colspan",t.getColSpan());var p=t.getPopinLayout();if(D.browser.msie||(D.browser.edge&&D.browser.version<16)){p=d.Block;}r.write("><div");r.addClass("sapMListTblSubCnt");r.addClass("sapMListTblSubCnt"+p);r.writeClasses();r.write(">");var f=o.getCells(),g=t.getColumns(true);g.forEach(function(h){if(!h.getVisible()||!h.isPopin()){return;}var i=f[h.getInitialOrder()],H=h.getHeader();if(!H&&!i){return;}var s=h.getStyleClass(),j=h.getPopinDisplay();r.write("<div");r.addClass("sapMListTblSubCntRow");s&&r.addClass(e(s));r.writeClasses();r.write(">");if(H&&j!=P.WithoutHeader){r.write("<div");r.addClass("sapMListTblSubCntHdr");r.writeClasses();r.write(">");var k=sap.ui.require("sap/m/ColumnHeader");if(typeof k=="function"&&H instanceof k){var m=H.getText();H=new a({text:m});}else{H=H.clone();}h.addDependent(H);o._addClonedHeader(H);r.renderControl(H);r.write("</div>");r.write("<div class='sapMListTblSubCntSpr'>:</div>");}if(i){r.write("<div");r.addClass("sapMListTblSubCntVal");r.addClass("sapMListTblSubCntVal"+j);r.writeClasses();r.write(">");this.applyAriaLabelledBy(H,i);r.renderControl(i);r.write("</div>");}r.write("</div>");},this);r.write("</div></td></tr>");};
C.addLegacyOutlineClass=function(r,o){};
return C;},true);
sap.ui.predefine('sap/m/ComboBox',['./InputBase','./ComboBoxTextField','./ComboBoxBase','./Popover','./List','./library','sap/ui/Device','sap/ui/core/Item','./StandardListItem','./ComboBoxRenderer',"sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/base/assert","sap/base/security/encodeXML"],function(I,C,a,P,L,l,D,b,S,c,d,K,e,f){"use strict";var g=l.ListType;var h=l.ListMode;var j=l.ListSeparators;
var k=a.extend("sap.m.ComboBox",{metadata:{library:"sap.m",designtime:"sap/m/designtime/ComboBox.designtime",properties:{selectedKey:{type:"string",group:"Data",defaultValue:""},selectedItemId:{type:"string",group:"Misc",defaultValue:""},filterSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false}},events:{change:{parameters:{value:{type:"string"},itemPressed:{type:"boolean"}}},selectionChange:{parameters:{selectedItem:{type:"sap.ui.core.Item"}}}}}});
function H(o,i){if(!i){return;}var n=o.getFocusDomRef(),p=n.selectionStart,q=n.selectionEnd,r=p!==q,t=n.value.substring(0,n.selectionStart),u=this.getSelectedItem();this.setSelection(i);if(i!==u){o.updateDomValue(i.getText());this.fireSelectionChange({selectedItem:i});i=this.getSelectedItem();if(!((typeof t=="string"&&t!=""?i.getText().toLowerCase().startsWith(t.toLowerCase()):false))||!r){p=0;}o.selectText(p,n.value.length);}if(this.isOpen()){this.$().removeClass("sapMFocus");this.getList().addStyleClass("sapMListFocus");}else{this.$().addClass("sapMFocus");}this.scrollToItem(i);}
k.prototype.scrollToItem=function(i){var p=this.getPicker(),o=p.getDomRef("cont"),n=this.getListItem(i),q=i&&n&&n.getDomRef();if(!p||!o||!q){return;}var r=o.scrollTop,t=q.offsetTop,u=o.clientHeight,v=q.offsetHeight;if(r>t){o.scrollTop=t;}else if((t+v)>(r+u)){o.scrollTop=Math.ceil(t+v-u);}};
function s(i,E){if(document.activeElement===this.getFocusDomRef()){this.selectText(i,E);}}
function m(i){var o=this.getSelectedItem(),n=this.getListItem(o),p=o&&n&&n.getDomRef(),q=p&&p.offsetTop,r=p&&p.offsetHeight,t=this.getPicker(),u=t.getDomRef("cont"),v=u.clientHeight;if(o&&((q+r)>(v))){if(!i){this.getList().$().css("visibility","hidden");}else{u.scrollTop=q-r/2;this.getList().$().css("visibility","visible");}}}
k.prototype._handleAriaActiveDescendant=function(i){var o=this.getFocusDomRef(),n=this.getListItem(i),A="aria-activedescendant";if(o){if(i&&n&&n.getDomRef()&&this.isOpen()){o.setAttribute(A,i.getId());}else{o.removeAttribute(A);}}};
k.prototype._getSelectedItemText=function(i){i=i||this.getSelectedItem();if(!i){i=this.getDefaultSelectedItem();}if(i){return i.getText();}return"";};
k.prototype._setItemVisibility=function(i,v){var o=i&&this.getListItem(i).$(),n="sapMSelectListItemBaseInvisible";if(v){i.bVisible=true;o.length&&o.removeClass(n);}else{i.bVisible=false;o.length&&o.addClass(n);}};
k.prototype._highlightList=function(v){var i=[],n=[],o,p;this._oList.getItems().forEach(function(q){p=q.getDomRef();if(p){i.push({ref:p.getElementsByClassName("sapMSLITitleOnly")[0],text:q.getTitle()});o=p.querySelector(".sapMSLIInfo");if(o&&q.getInfo){n.push({ref:o,text:q.getInfo()});}}});this.highLightList(v,i);this.highLightList(v,n);};
k.prototype.setSelectedIndex=function(i,_){var o;_=_||this.getItems();i=(i>_.length-1)?_.length-1:Math.max(0,i);o=_[i];if(o){this.setSelection(o);}};
k.prototype.createDropdown=function(){var t=this;var o=new P(this.getDropdownSettings());o.setInitialFocus(this);o.open=function(){return this.openBy(t);};return o;};
k.prototype.createPickerTextField=function(){var t=new C({width:"100%",showValueStateMessage:false,showButton:false}).addEventDelegate({onsapenter:function(){this.updateDomValue(t.getValue());this.onChange();}},this);return t;};
k.prototype.revertSelection=function(){var p,o=this.getPickerTextField();this.setSelectedItem(this._oSelectedItemBeforeOpen);this.setValue(this._sValueBeforeOpen);if(this.getSelectedItem()===null){p=this._sValueBeforeOpen;}else{p=this._oSelectedItemBeforeOpen.getText();}o&&o.setValue(p);};
k.prototype.filterItems=function(o){var i=this.getItems(),F=[],n=[],p=o.properties.indexOf("additionalText")>-1,q=this.fnFilter||a.DEFAULT_TEXT_FILTER;this._oFirstItemTextMatched=null;i.forEach(function(r){var M=q.call(this,o.value,r,"getText");var t=q.call(this,o.value,r,"getAdditionalText");if(M){n.push(r);F.push(r);}else if(t&&p){F.push(r);}});i.forEach(function(r){var t=F.indexOf(r)>-1;var u=n.indexOf(r)>-1;if(!this._oFirstItemTextMatched&&u){this._oFirstItemTextMatched=r;}this.getListItem(r).setVisible(t);},this);return F;};
k.prototype._filterStartsWithItems=function(i,M){var n=i.toLowerCase();var o=this.getItems(),F=o.filter(function(p){return p[M]&&p[M]().toLowerCase().startsWith(n);});return F;};
k.prototype._getFilters=function(){return this.getFilterSecondaryValues()?["text","additionalText"]:["text"];};
k.prototype.init=function(){a.prototype.init.apply(this,arguments);this.bOpenValueStateMessage=true;this._sValueBeforeOpen="";this._sInputValueBeforeOpen="";this._oSelectedItemBeforeOpen=null;this._oFirstItemTextMatched=null;this.bIsFocused=false;if(D.system.phone){this.attachEvent("_change",this.onPropertyChange,this);}};
k.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);this._fillList();this.synchronizeSelection();};
k.prototype._fillList=function(){var o=this.getList(),n,p,q,i;if(!o){return;}o.destroyItems();n=this.getVisibleItems();for(i=0,q=n.length;i<q;i++){p=this._mapItemToListItem(n[i]);o.addAggregation("items",p,true);}};
k.prototype.exit=function(){a.prototype.exit.apply(this,arguments);this._oSelectedItemBeforeOpen=null;this._oFirstItemTextMatched=null;};
k.prototype.onBeforeRenderingPicker=function(){var o=this["onBeforeRendering"+this.getPickerType()];o&&o.call(this);};
k.prototype.onBeforeRenderingDropdown=function(){var p=this.getPicker(),w=(this.$().outerWidth()/parseFloat(l.BaseFontSize))+"rem";if(p){p.setContentMinWidth(w);}};
k.prototype.onBeforeRenderingList=function(){if(this.bProcessingLoadItemsEvent){var o=this.getList(),F=this.getFocusDomRef();if(o){o.setBusy(true);}if(F){F.setAttribute("aria-busy","true");}}};
k.prototype.onAfterRenderingPicker=function(){var o=this["onAfterRendering"+this.getPickerType()];o&&o.call(this);m.call(this,false);};
k.prototype.onAfterRenderingList=function(){if(this.bProcessingLoadItemsEvent&&(this.getItems().length===0)){return;}var o=this.getList(),F=this.getFocusDomRef();this._highlightList(this._sInputValueBeforeOpen);if(o){o.setBusy(false);}if(F){F.removeAttribute("aria-busy");}};
k.prototype.oninput=function(E){a.prototype.oninput.apply(this,arguments);if(E.isMarked("invalid")){return;}this.loadItems(function(){this.handleInputValidation(E,this.isComposingCharacter());},{name:"input",busyIndicator:false});if(this.bProcessingLoadItemsEvent&&(this.getPickerType()==="Dropdown")){this.open();}this.$().addClass("sapMFocus");this.getList().removeStyleClass("sapMListFocus");};
k.prototype.handleInputValidation=function(E,i){var o=this.getSelectedItem(),v=E.target.value,n=v==="",p=E.srcControl,V,t=(this.getPickerType()==="Dropdown");if(n&&!this.bOpenedByKeyboardOrButton&&!this.isPickerDialog()){V=this.getItems();}else{V=this.filterItems({properties:this._getFilters(),value:v});}var q=!!V.length;var F=V[0];if(!n&&F&&F.getEnabled()){this.handleTypeAhead(p,V,v,i);}if(n||!q||(!p._bDoTypeAhead&&(this._getSelectedItemText()!==v))){this.setSelection(null);if(o!==this.getSelectedItem()){this.fireSelectionChange({selectedItem:this.getSelectedItem()});}}this._sInputValueBeforeOpen=v;if(this.isOpen()){setTimeout(function(){this._highlightList(v);}.bind(this));}if(q){if(n&&!this.bOpenedByKeyboardOrButton){this.close();}else if(t){this.open();this.scrollToItem(this.getSelectedItem());}}else if(this.isOpen()){if(t&&!this.bOpenedByKeyboardOrButton){this.close();}}else{this.clearFilter();}};
k.prototype.handleTypeAhead=function(i,n,v,o){var p=this.intersectItems(this._filterStartsWithItems(v,'getText'),n);var q=this.getFilterSecondaryValues();var r=D.system.desktop;var t=this.getSelectedItem();if(i._bDoTypeAhead){var u=this.intersectItems(this._filterStartsWithItems(v,'getAdditionalText'),n);if(q&&!p[0]&&u[0]){!o&&i.updateDomValue(u[0].getAdditionalText());this.setSelection(u[0]);}else if(p[0]){!o&&i.updateDomValue(p[0].getText());this.setSelection(p[0]);}}else{this.setSelection(p[0]);}if(t!==this.getSelectedItem()){this.fireSelectionChange({selectedItem:this.getSelectedItem()});}if(i._bDoTypeAhead){if(r){s.call(i,v.length,i.getValue().length);}else{setTimeout(s.bind(i,v.length,i.getValue().length),0);}}this.$().addClass("sapMFocus");this.getList().removeStyleClass("sapMListFocus");};
k.prototype.onSelectionChange=function(o){var i=this._getItemByListItem(o.getParameter("listItem")),p=this.getChangeEventParams(),n=(i!==this.getSelectedItem());this.setSelection(i);this.fireSelectionChange({selectedItem:this.getSelectedItem()});if(n){p.itemPressed=true;this.onChange(null,p);}};
k.prototype.onItemPress=function(o){var i=o.getParameter("listItem"),t=i.getTitle(),p=this.getChangeEventParams(),n=(i!==this.getListItem(this.getSelectedItem()));this.updateDomValue(t);if(!n){p.itemPressed=true;this.onChange(null,p);}this.setProperty("value",t,true);if(this.getPickerType()==="Dropdown"){setTimeout(this.selectText.bind(this,this.getValue().length,this.getValue().length),0);}setTimeout(this.close.bind(this));};
k.prototype.onBeforeOpen=function(){var p=this["onBeforeOpen"+this.getPickerType()],o=this.getFocusDomRef();if(this.hasLoadItemsEventListeners()&&!this.bProcessingLoadItemsEvent){this.loadItems();}this.addStyleClass(I.ICON_PRESSED_CSS_CLASS);if(o){o.setAttribute("aria-owns",this.getList().getId());}this.addContent();p&&p.call(this);};
k.prototype.onBeforeOpenDialog=function(){var p=this.getPickerTextField();this._oSelectedItemBeforeOpen=this.getSelectedItem();this._sValueBeforeOpen=this.getValue();if(this.getSelectedItem()){this.filterItems({properties:this._getFilters(),value:""});}p.setValue(this._sValueBeforeOpen);};
k.prototype.onAfterOpen=function(){var o=this.getFocusDomRef(),i=this.getSelectedItem();if(o){o.setAttribute("aria-expanded","true");i&&o.setAttribute("aria-activedescendant",i.getId());}m.call(this,true);};
k.prototype.onBeforeClose=function(){a.prototype.onBeforeClose.apply(this,arguments);var o=this.getFocusDomRef();if(o){o.removeAttribute("aria-owns");o.removeAttribute("aria-activedescendant");}this.removeStyleClass(I.ICON_PRESSED_CSS_CLASS);};
k.prototype.onAfterClose=function(){var o=this.getFocusDomRef();if(o){o.setAttribute("aria-expanded","false");}this.clearFilter();this._sInputValueBeforeOpen="";if(this.shouldValueStateMessageBeOpened()&&(document.activeElement===o)){this.openValueStateMessage();}};
k.prototype.onItemChange=function(o){var i=this.getAssociation("selectedItem"),n=o.getParameter("newValue"),p=o.getParameter("name");if(i===o.getParameter("id")){switch(p){case"text":if(!this.isBound("value")){this.setValue(n);}break;case"key":if(!this.isBound("selectedKey")){this.setSelectedKey(n);}break;}}};
k.prototype.onkeydown=function(E){var o=E.srcControl;a.prototype.onkeydown.apply(o,arguments);if(!o.getEnabled()||!o.getEditable()){return;}var i=K;o._bDoTypeAhead=(E.which!==i.BACKSPACE)&&(E.which!==i.DELETE);};
k.prototype.oncut=function(E){var o=E.srcControl;a.prototype.oncut.apply(o,arguments);o._bDoTypeAhead=false;};
k.prototype.onsapenter=function(E){var o=E.srcControl,i=o.getSelectedItem();if(i&&this.getFilterSecondaryValues()){o.updateDomValue(i.getText());}a.prototype.onsapenter.apply(o,arguments);if(!o.getEnabled()||!o.getEditable()){return;}if(o.isOpen()&&!this.isComposingCharacter()){o.close();}};
k.prototype.onsapdown=function(E){var o=E.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}E.setMarked();E.preventDefault();this.loadItems(function navigateToNextSelectableItem(){var i=this.getSelectableItems(),n;if(this.$().hasClass("sapMFocus")&&this.isOpen()){n=i[0];}else{n=i[i.indexOf(this.getSelectedItem())+1];}H.call(this,o,n);});};
k.prototype.onsapup=function(E){var o=E.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}E.setMarked();E.preventDefault();this.loadItems(function navigateToPrevSelectableItem(){var i=this.getSelectableItems();var p=i[i.indexOf(this.getSelectedItem())-1];H.call(this,o,p);});};
k.prototype.onsaphome=function(E){var o=E.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}E.setMarked();E.preventDefault();this.loadItems(function navigateToFirstSelectableItem(){var F=this.getSelectableItems()[0];H.call(this,o,F);});};
k.prototype.onsapend=function(E){var o=E.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}E.setMarked();E.preventDefault();this.loadItems(function navigateToLastSelectableItem(){var i=this.findLastEnabledItem(this.getSelectableItems());H.call(this,o,i);});};
k.prototype.onsappagedown=function(E){var o=E.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}E.setMarked();E.preventDefault();this.loadItems(function(){var i=this.getSelectableItems(),n=i.indexOf(this.getSelectedItem())+10,p;n=(n>i.length-1)?i.length-1:Math.max(0,n);p=i[n];H.call(this,o,p);});};
k.prototype.onsappageup=function(E){var o=E.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}E.setMarked();E.preventDefault();this.loadItems(function(){var i=this.getSelectableItems(),n=i.indexOf(this.getSelectedItem())-10,p;n=(n>i.length-1)?i.length-1:Math.max(0,n);p=i[n];H.call(this,o,p);});};
k.prototype.onsapshow=function(E){var i,o;a.prototype.onsapshow.apply(this,arguments);if(!this.getValue()){i=this.getSelectableItems();o=i[0];if(o){this.setSelection(o);this.updateDomValue(o.getText());this.fireSelectionChange({selectedItem:o});setTimeout(function(){this.selectText(0,o.getText().length);}.bind(this),0);}}};
k.prototype.onsaphide=k.prototype.onsapshow;
k.prototype.onfocusin=function(E){var i=this.getPickerType()==="Dropdown";if(this._bIsBeingDestroyed){return;}if(E.target===this.getOpenArea()){this.bOpenValueStateMessage=false;if(i&&!this.isPlatformTablet()){this.focus();}}else{if(i){setTimeout(function(){if(document.activeElement===this.getFocusDomRef()&&!this.bIsFocused&&!this.bFocusoutDueRendering&&!this.getSelectedText()){this.selectText(0,this.getValue().length);}this.bIsFocused=true;}.bind(this),0);}if(!this.isOpen()&&this.bOpenValueStateMessage&&this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}this.bOpenValueStateMessage=true;}if(this.getEnabled()&&(!this.isOpen()||!this.getSelectedItem()||!this.getList().hasStyleClass("sapMListFocus"))){this.$().addClass("sapMFocus");}};
k.prototype.onsapfocusleave=function(E){this.bIsFocused=false;var t,p,r,F,i=this.getSelectedItem();if(i&&this.getFilterSecondaryValues()){this.updateDomValue(i.getText());}a.prototype.onsapfocusleave.apply(this,arguments);if(this.isPickerDialog()){return;}p=this.getAggregation("picker");if(!E.relatedControlId||!p){return;}t=this.isPlatformTablet();r=sap.ui.getCore().byId(E.relatedControlId);F=r&&r.getFocusDomRef();if(d(p.getFocusDomRef(),F)&&!t){this.focus();}};
k.prototype.setSelection=function(i){var o=this.getList(),n,p;this.setAssociation("selectedItem",i,true);this.setProperty("selectedItemId",(i instanceof b)?i.getId():i,true);if(typeof i==="string"){i=sap.ui.getCore().byId(i);}if(o){n=this.getListItem(i);if(n){o.setSelectedItem(n,true);}else{o.removeSelections(true);}}p=i?i.getKey():"";this.setProperty("selectedKey",p,true);this._handleAriaActiveDescendant(i);};
k.prototype.isSelectionSynchronized=function(){var i=this.getSelectedItem();return this.getSelectedKey()===(i&&i.getKey());};
k.prototype.synchronizeSelection=function(){if(this.isSelectionSynchronized()){return;}var i=this.getSelectedKey(),v=this.getItemByKey(""+i);if(v&&(i!=="")){this.setAssociation("selectedItem",v,true);this.setProperty("selectedItemId",v.getId(),true);if(this._sValue===this.getValue()){this.setValue(v.getText());this._sValue=this.getValue();}}};
k.prototype.isFiltered=function(){var o=this.getList();return o&&(o.getVisibleItems().length!==o.getItems().length);};
k.prototype.isItemVisible=function(i){return i&&(i.bVisible===undefined||i.bVisible);};
k.prototype.createPicker=function(p){var o=this.getAggregation("picker");if(o){return o;}o=this["create"+p]();this.setAggregation("picker",o,true);var i=this.getRenderer().CSS_CLASS_COMBOBOXBASE;o.setHorizontalScrolling(false).addStyleClass(i+"Picker").addStyleClass(i+"Picker-CTX").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this).addContent(this.createList());return o;};
k.prototype.createList=function(){var r=this.getRenderer();this._oList=new L({width:"100%",mode:h.SingleSelectMaster,rememberSelections:false,busyIndicatorDelay:0,showSeparators:j.None}).addStyleClass(r.CSS_CLASS_COMBOBOXBASE+"List").addStyleClass(r.CSS_CLASS_COMBOBOX+"List").addEventDelegate({ontap:function(E){this.close();},onBeforeRendering:this.onBeforeRenderingList,onAfterRendering:this.onAfterRenderingList},this).attachSelectionChange(this.onSelectionChange,this).attachItemPress(this.onItemPress,this);return this._oList;};
k.prototype.destroyItems=function(){this.destroyAggregation("items");if(this.getList()){this.getList().destroyItems();}return this;};
k.prototype._mapItemToListItem=function(i){var o,n,p,A;var r=this.getRenderer();if(!i){return null;}A=(i.getAdditionalText&&this.getShowSecondaryValues())?i.getAdditionalText():"";n=r.CSS_CLASS_COMBOBOXBASE+"Item";p=(this.isItemSelected(i))?n+"Selected":"";o=new S({type:g.Active,info:A,visible:i.getEnabled()}).addStyleClass(n+" "+p);o.setTooltip(i.getTooltip());i.data(r.CSS_CLASS_COMBOBOXBASE+"ListItem",o);o.setTitle(i.getText());this.setSelectable(i,i.getEnabled());return o;};
k.prototype.setSelectable=function(i,n){if(this.indexOfItem(i)<0){return;}i._bSelectable=n;var o=this.getListItem(i);if(o){o.setVisible(n);}};
k.prototype.isItemSelected=function(i){return i&&(i.getId()===this.getAssociation("selectedItem"));};
k.prototype.getDefaultSelectedItem=function(){return null;};
k.prototype.getChangeEventParams=function(){return{itemPressed:false};};
k.prototype.clearSelection=function(){this.setSelection(null);};
k.prototype.selectText=function(i,n){a.prototype.selectText.apply(this,arguments);this.textSelectionStart=i;this.textSelectionEnd=n;return this;};
k.prototype.setAssociation=function(A,i,n){var o=this.getList();if(o&&(A==="selectedItem")){if(!(i instanceof b)){i=this.findItem("id",i);}o.setSelectedItem(this.getListItem(i),true);}return a.prototype.setAssociation.apply(this,arguments);};
k.prototype.removeAllAssociation=function(A,i){var o=this.getList();if(o&&(A==="selectedItem")){L.prototype.removeAllAssociation.apply(o,arguments);}return a.prototype.removeAllAssociation.apply(this,arguments);};
k.prototype.clone=function(i){var o=a.prototype.clone.apply(this,arguments),n=this.getList();if(!this.isBound("items")&&n){o.setSelectedIndex(this.indexOfItem(this.getSelectedItem()));}return o;};
k.prototype.open=function(){var o=this.getList();a.prototype.open.call(this);if(this.getSelectedItem()){o.addStyleClass("sapMListFocus");this.$().removeClass("sapMFocus");}return this;};
k.prototype.close=function(){var o=this.getList();a.prototype.close.call(this);this.$().addClass("sapMFocus");o&&o.removeStyleClass("sapMListFocus");return this;};
k.prototype.findAggregatedObjects=function(){var o=this.getList();if(o){return L.prototype.findAggregatedObjects.apply(o,arguments);}return[];};
k.prototype.setSelectedItem=function(i){if(typeof i==="string"){this.setAssociation("selectedItem",i,true);i=sap.ui.getCore().byId(i);}if(!(i instanceof b)&&i!==null){return this;}if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);this.setValue(this._getSelectedItemText(i));return this;};
k.prototype.setSelectedItemId=function(i){i=this.validateProperty("selectedItemId",i);if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);i=this.getSelectedItem();this.setValue(this._getSelectedItemText(i));return this;};
k.prototype.setSelectedKey=function(i){i=this.validateProperty("selectedKey",i);var n=(i===""),o=this.isBound("selectedKey")&&this.isBound("value")&&this.getBindingInfo("selectedKey").skipModelUpdate;if(n){this.setSelection(null);if(!o){this.setValue("");}return this;}var p=this.getItemByKey(i);if(p){this.setSelection(p);if(!o){this.setValue(this._getSelectedItemText(p));}return this;}this._sValue=this.getValue();return this.setProperty("selectedKey",i);};
k.prototype.getSelectedItem=function(){var v=this.getAssociation("selectedItem");return(v===null)?null:sap.ui.getCore().byId(v)||null;};
k.prototype.updateItems=function(){var r,o=this.getSelectedItem(),r=a.prototype.updateItems.apply(this,arguments);clearTimeout(this._debounceItemsUpdate);this._debounceItemsUpdate=setTimeout(this["_syncItemsSelection"].bind(this,o),0);return r;};
k.prototype._syncItemsSelection=function(o){var i,n,p=this.getSelectedKey();if(!o||o===this.getSelectedItem()){return;}n=this.getItems();i=n.some(function(q){return p===q.getKey();});this.setSelectedItem(i&&p?this.getItemByKey(p):null);};
k.prototype.removeItem=function(i){i=a.prototype.removeItem.apply(this,arguments);var o;if(this.getList()){this.getList().removeItem(i&&this.getListItem(i));}if(this.isBound("items")&&!this.bItemsUpdated){return i;}var v=this.getValue();if(this.getItems().length===0){this.clearSelection();}else if(this.isItemSelected(i)){o=this.getDefaultSelectedItem();this.setSelection(o);this.setValue(v);}return i;};
return k;});
sap.ui.predefine('sap/m/ComboBoxBase',['./Dialog','./ComboBoxTextField','./Toolbar','./Button','./Bar','./Text','./Title','sap/ui/core/InvisibleText','sap/ui/core/IconPool','sap/ui/core/ValueStateSupport','sap/base/Log','./library','sap/ui/Device','sap/ui/core/library','./ComboBoxBaseRenderer',"sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/base/security/encodeXML","sap/base/strings/escapeRegExp"],function(D,C,T,B,a,b,c,I,d,V,L,l,e,f,g,h,K,q,j,k){"use strict";var P=l.PlacementType;var m=f.ValueState;
var n=C.extend("sap.m.ComboBoxBase",{metadata:{library:"sap.m","abstract":true,defaultAggregation:"items",properties:{showSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false}},aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable"},picker:{type:"sap.ui.core.PopupInterface",multiple:false,visibility:"hidden"}},events:{loadItems:{}}}});
n.DEFAULT_TEXT_FILTER=function(i,o,p){var s,r,M;if(!o[p]){return false;}s=o[p]().toLowerCase();r=i.toLowerCase();M=new RegExp('(^|\\s)'+k(r)+".*",'g');return M.test(s);};
n.prototype.oncompositionstart=function(){this._bIsComposingCharacter=true;};
n.prototype.oncompositionend=function(E){this._bIsComposingCharacter=false;this._sComposition=E.target.value;if(!e.browser.edge&&!e.browser.firefox){C.prototype.handleInput.apply(this,arguments);this.handleInputValidation(E,this.isComposingCharacter());}};
n.prototype.isComposingCharacter=function(){return this._bIsComposingCharacter;};
n.prototype.updateItems=function(r){this.bItemsUpdated=false;this.destroyItems();this.updateAggregation("items");this.bItemsUpdated=true;if(this.hasLoadItemsEventListeners()){this.onItemsLoaded();}};
n.prototype.setFilterFunction=function(F){if(F===null||F===undefined){this.fnFilter=null;return this;}if(typeof(F)!=="function"){L.warning("Passed filter is not a function and the default implementation will be used");}else{this.fnFilter=F;}return this;};
n.prototype.highLightList=function(v,i){var o=v.length,v=v.replace(/[-[\]{}()*+?.,\\^$|#\s]/g,'\\$&'),r=new RegExp("\\b"+v,"gi"),$;i.forEach(function(p){$=q(p.ref);$.html(this._boldItemRef.call(this,p.text,r,o));},this);};
n.prototype._boldItemRef=function(i,r,o){r.lastIndex=0;var R,p=r.exec(i);if(p===null){return j(i);}var M=p.index;var t="<b>"+j(i.slice(M,M+o))+"</b>";var s=i.split(r);if(s.length===1){R=j(i);}else{R=s.map(function(u){return j(u);}).join(t);}return R;};
n.prototype.refreshItems=function(){this.bItemsUpdated=false;this.refreshAggregation("items");};
n.prototype.loadItems=function(i,o){var p=typeof i==="function";if(this.hasLoadItemsEventListeners()&&(this.getItems().length===0)){this._bOnItemsLoadedScheduled=false;if(p){o=q.extend({action:i,busyIndicator:true,busyIndicatorDelay:300},o);this.aMessageQueue.push(o);if((this.iLoadItemsEventInitialProcessingTimeoutID===-1)&&(o.busyIndicator)){this.iLoadItemsEventInitialProcessingTimeoutID=setTimeout(function onItemsNotLoadedAfterDelay(){this.setInternalBusyIndicatorDelay(0);this.setInternalBusyIndicator(true);}.bind(this),o.busyIndicatorDelay);}}if(!this.bProcessingLoadItemsEvent){this.bProcessingLoadItemsEvent=true;this.fireLoadItems();}}else if(p){i.call(this);}};
n.prototype.onItemsLoaded=function(){this.bProcessingLoadItemsEvent=false;clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);if(this.bInitialBusyIndicatorState!==this.getBusy()){this.setInternalBusyIndicator(this.bInitialBusyIndicatorState);}if(this.iInitialBusyIndicatorDelay!==this.getBusyIndicatorDelay()){this.setInternalBusyIndicatorDelay(this.iInitialBusyIndicatorDelay);}for(var i=0,o,N,p;i<this.aMessageQueue.length;i++){o=this.aMessageQueue.shift();i--;p=(i+1)===this.aMessageQueue.length;N=p?null:this.aMessageQueue[i+1];if(typeof o.action==="function"){if((o.name==="input")&&!p&&(N.name==="input")){continue;}o.action.call(this);}}};
n.prototype.hasLoadItemsEventListeners=function(){return this.hasListeners("loadItems");};
n.prototype._scheduleOnItemsLoadedOnce=function(){if(!this._bOnItemsLoadedScheduled&&!this.isBound("items")&&this.hasLoadItemsEventListeners()&&this.bProcessingLoadItemsEvent){this._bOnItemsLoadedScheduled=true;setTimeout(this.onItemsLoaded.bind(this),0);}};
n.prototype.getPickerInvisibleTextId=function(){return I.getStaticId("sap.m","COMBOBOX_AVAILABLE_OPTIONS");};
n.prototype._getItemByListItem=function(o){return this._getItemBy(o,"ListItem");};
n.prototype._getItemBy=function(o,s){s=this.getRenderer().CSS_CLASS_COMBOBOXBASE+s;for(var i=0,p=this.getItems(),r=p.length;i<r;i++){if(p[i].data(s)===o){return p[i];}}return null;};
n.prototype._isListInSuggestMode=function(){return this.getList().getItems().some(function(o){return!o.getVisible()&&this._getItemByListItem(o).getEnabled();},this);};
n.prototype.getListItem=function(i){return i?i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"ListItem"):null;};
n.prototype.getSelectable=function(i){return i._bSelectable;};
n.prototype.init=function(){C.prototype.init.apply(this,arguments);this.setPickerType(e.system.phone?"Dialog":"Dropdown");this.createPicker(this.getPickerType());this.bItemsUpdated=false;this.bOpenedByKeyboardOrButton=false;this._bShouldClosePicker=false;this._oPickerValueStateText=null;this.bProcessingLoadItemsEvent=false;this.iLoadItemsEventInitialProcessingTimeoutID=-1;this.aMessageQueue=[];this.bInitialBusyIndicatorState=this.getBusy();this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();this._bOnItemsLoadedScheduled=false;this._bDoTypeAhead=true;this.getIcon().addEventDelegate({onmousedown:function(E){this._bShouldClosePicker=this.isOpen();}},this);this.getIcon().attachPress(function(E){var p;if(!this.getEnabled()||!this.getEditable()){return;}if(this._bShouldClosePicker){this._bShouldClosePicker=false;this.close();return;}this.loadItems();this.bOpenedByKeyboardOrButton=true;if(this.isPlatformTablet()){p=this.getPicker();p.setInitialFocus(p);}this.open();},this);this._sComposition="";this.fnFilter=null;};
n.prototype.onBeforeRendering=function(){var N=this.getValueState()===m.None;C.prototype.onBeforeRendering.apply(this,arguments);if(!this.isPickerDialog()&&N){this._showValueStateText(false);}};
n.prototype.exit=function(){C.prototype.exit.apply(this,arguments);if(this.getList()){this.getList().destroy();this._oList=null;}if(this._oPickerValueStateText){this._oPickerValueStateText.destroy();}clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);this.aMessageQueue=null;this.fnFilter=null;};
n.prototype.onsapshow=function(E){if(!this.getEnabled()||!this.getEditable()){return;}E.setMarked();if(E.keyCode===K.F4){this.onF4(E);}if(this.isOpen()){this.close();return;}this.selectText(0,this.getValue().length);this.loadItems();this.bOpenedByKeyboardOrButton=true;this.open();};
n.prototype.onF4=function(E){E.preventDefault();};
n.prototype.onsapescape=function(E){if(this.getEnabled()&&this.getEditable()&&this.isOpen()){E.setMarked();E.preventDefault();this.close();}else{C.prototype.onsapescape.apply(this,arguments);}};
n.prototype.onsaphide=n.prototype.onsapshow;
n.prototype.onsapfocusleave=function(E){if(!E.relatedControlId){C.prototype.onsapfocusleave.apply(this,arguments);return;}var r=sap.ui.getCore().byId(E.relatedControlId);if(r===this){return;}var p=this.getAggregation("picker"),F=r&&r.getFocusDomRef();if(p&&h(p.getFocusDomRef(),F)){return;}C.prototype.onsapfocusleave.apply(this,arguments);};
n.prototype.getPopupAnchorDomRef=function(){return this.getDomRef();};
n.prototype.addContent=function(p){};
n.prototype.getList=function(){if(this.bIsDestroyed){return null;}L.warning("[Warning]:","You are attempting to use deprecated method 'getList()', please refer to SAP note 2746748.",this);return this._oList;};
n.prototype.setPickerType=function(p){this._sPickerType=p;};
n.prototype.getPickerType=function(){return this._sPickerType;};
n.prototype.setValueState=function(v){var A,s=this.getValueStateText(),S=(v===m.None?false:this.getShowValueStateMessage());this._sOldValueState=this.getValueState();C.prototype.setValueState.apply(this,arguments);this._showValueStateText(S);if(s){this._setValueStateText(s);}else{A=V.getAdditionalText(this);this._setValueStateText(A);}this._alignValueStateStyles();return this;};
n.prototype.setValueStateText=function(t){C.prototype.setValueStateText.apply(this,arguments);this._setValueStateText(this.getValueStateText());return this;};
n.prototype.setShowValueStateMessage=function(s){C.prototype.setShowValueStateMessage.apply(this,arguments);this._showValueStateText(this.getShowValueStateMessage());return this;};
n.prototype._showValueStateText=function(s){var o;if(this.isPickerDialog()){if(this._oPickerValueStateText){this._oPickerValueStateText.setVisible(s);}}else{o=this._getPickerCustomHeader();if(o){o.setVisible(s);}}};
n.prototype._setValueStateText=function(t){var H;if(this.isPickerDialog()){this._oPickerValueStateText=this.getPickerValueStateText();this._oPickerValueStateText.setText(t);}else{H=this._getPickerCustomHeader();if(H){H.getContentLeft()[0].setText(t);}}};
n.prototype._getPickerCustomHeader=function(){var i,o,p=this.getPicker(),s=this.getRenderer().CSS_CLASS_COMBOBOXBASE+"PickerTitle";if(!p){return null;}if(p.getCustomHeader()){return p.getCustomHeader();}i=new c({textAlign:"Left"}).addStyleClass(s);o=new a({visible:false,contentLeft:i});p.setCustomHeader(o);return o;};
n.prototype._alignValueStateStyles=function(){var o=this._sOldValueState,i=this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Picker",p=i+"ValueState",O=i+o+"State",s=i+this.getValueState()+"State",r;if(this.isPickerDialog()&&this._oPickerValueStateText){this._oPickerValueStateText.addStyleClass(p);this._oPickerValueStateText.removeStyleClass(O);this._oPickerValueStateText.addStyleClass(s);}else{r=this._getPickerCustomHeader();if(r){r.addStyleClass(p);r.removeStyleClass(O);r.addStyleClass(s);}}};
n.prototype.shouldValueStateMessageBeOpened=function(){var s=C.prototype.shouldValueStateMessageBeOpened.apply(this,arguments);return(s&&!this.isOpen());};
n.prototype.onPropertyChange=function(o,i){var N=o.getParameter("newValue"),p=o.getParameter("name"),M="set"+p.charAt(0).toUpperCase()+p.slice(1),r=(i&&i.srcControl)||this.getPickerTextField();if(/\bvalue\b|\benabled\b|\bname\b|\bplaceholder\b|\beditable\b|\btextAlign\b|\btextDirection\b|\bvalueState\b/.test(p)&&r&&(typeof r[M]==="function")){r[M](N);}};
n.prototype.isPickerDialog=function(){return this.getPickerType()==="Dialog";};
n.prototype.isPlatformTablet=function(){var N=!e.system.combi,t=e.system.tablet&&N;return t;};
n.prototype.getDropdownSettings=function(){return{showArrow:false,placement:P.VerticalPreferredBottom,offsetX:0,offsetY:0,bounce:false,ariaLabelledBy:this.getPickerInvisibleTextId()||undefined};};
n.prototype.getPickerValueStateText=function(){var p=this.getPicker();if(!this._oPickerValueStateText){this._oPickerValueStateText=new b({width:"100%"});p.insertContent(this._oPickerValueStateText,0);}return this._oPickerValueStateText;};
n.prototype.createPicker=function(p){};
n.prototype.onBeforeClose=function(){this.bOpenedByKeyboardOrButton=false;};
n.prototype.getPicker=function(){if(this.bIsDestroyed){return null;}return this.createPicker(this.getPickerType());};
n.prototype.getPickerTextField=function(){var p=this.getPicker(),s=p.getSubHeader();return s&&s.getContent()[0]||null;};
n.prototype.getPickerTitle=function(){var p=this.getPicker(),H=p&&p.getCustomHeader();if(this.isPickerDialog()&&H){return H.getContentMiddle()[0];}return null;};
n.prototype.createDialog=function(){var t=this,o=this.createPickerTextField(),i=o._handleEvent;o._handleEvent=function(E){i.apply(this,arguments);if(/keydown|sapdown|sapup|saphome|sapend|sappagedown|sappageup|input/.test(E.type)){t._handleEvent(E);}};return new D({stretch:true,customHeader:t.createPickerHeader(),buttons:this.createPickerCloseButton(),subHeader:new T({content:o}),beforeOpen:function(){t.updatePickerHeaderTitle();},afterClose:function(){t.focus();l.closeKeyboard();},ariaLabelledBy:t.getPickerInvisibleTextId()||undefined});};
n.prototype.createPickerHeader=function(){var t=this,i=d.getIconURI("decline");return new a({contentMiddle:new c(),contentRight:new B({icon:i,press:function(){t.close();t.revertSelection();}})});};
n.prototype.revertSelection=function(){};
n.prototype.updatePickerHeaderTitle=function(){var p=this.getPicker(),r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),o,i;if(!p){return;}i=this.getLabels();if(i.length){o=i[0];if(o&&(typeof o.getText==="function")){this.getPickerTitle().setText(o.getText());}}else{this.getPickerTitle().setText(r.getText("COMBOBOX_PICKER_TITLE"));}};
n.prototype.createPickerCloseButton=function(){var t=this,o,r=sap.ui.getCore().getLibraryResourceBundle("sap.m");return new B({text:r.getText("COMBOBOX_CLOSE_BUTTON"),press:function(){o=t.getPickerTextField();t.updateDomValue(o.getValue());t.onChange();t.close();}});};
n.prototype.hasContent=function(){return this.getItems().length>0;};
n.prototype.findFirstEnabledItem=function(o){o=o||this.getItems();for(var i=0;i<o.length;i++){if(o[i].getEnabled()){return o[i];}}return null;};
n.prototype.findLastEnabledItem=function(i){i=i||this.getItems();return this.findFirstEnabledItem(i.reverse());};
n.prototype.open=function(){var p=this.getPicker();if(p){p.open();}return this;};
n.prototype.getVisibleItems=function(){for(var i=0,o,p=this.getItems(),v=[];i<p.length;i++){o=this.getListItem(p[i]);if(o&&o.getVisible()){v.push(p[i]);}}return v;};
n.prototype.isItemSelected=function(){};
n.prototype.getKeys=function(o){o=o||this.getItems();for(var i=0,p=[];i<o.length;i++){p[i]=o[i].getKey();}return p;};
n.prototype.getSelectableItems=function(){return this.getEnabledItems(this.getVisibleItems());};
n.prototype.findItem=function(p,v){var M="get"+p.charAt(0).toUpperCase()+p.slice(1);for(var i=0,o=this.getItems();i<o.length;i++){if(o[i][M]()===v){return o[i];}}return null;};
n.prototype.getItemByText=function(t){return this.findItem("text",t);};
n.prototype.scrollToItem=function(i){var p=this.getPicker(),o=p.getDomRef("cont"),r=i&&i.getDomRef();if(!p||!o||!r){return;}var s=o.scrollTop,t=r.offsetTop,u=o.clientHeight,v=r.offsetHeight;if(s>t){o.scrollTop=t;}else if((t+v)>(s+u)){o.scrollTop=Math.ceil(t+v-u);}};
n.prototype.clearFilter=function(){this.getItems().forEach(function(i){var o=this.getListItem(i);if(o){o.setVisible(i.getEnabled()&&this.getSelectable(i));}},this);};
n.prototype.onItemChange=function(o){};
n.prototype.clearSelection=function(){};
n.prototype.setInternalBusyIndicator=function(i){this.bInitialBusyIndicatorState=this.getBusy();return this.setBusy.apply(this,arguments);};
n.prototype.setInternalBusyIndicatorDelay=function(i){this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();return this.setBusyIndicatorDelay.apply(this,arguments);};
n.prototype.addItem=function(i){this.addAggregation("items",i);if(i){i.attachEvent("_change",this.onItemChange,this);}if(this.getList()){this.getList().addItem(this._mapItemToListItem(i));}return this;};
n.prototype.insertItem=function(i,o){this.insertAggregation("items",i,o,true);if(i){i.attachEvent("_change",this.onItemChange,this);}if(this.getList()){this.getList().insertItem(this._mapItemToListItem(i),o);}this._scheduleOnItemsLoadedOnce();return this;};
n.prototype.getItemAt=function(i){return this.getItems()[+i]||null;};
n.prototype.getFirstItem=function(){return this.getItems()[0]||null;};
n.prototype.getLastItem=function(){var i=this.getItems();return i[i.length-1]||null;};
n.prototype.getEnabledItems=function(i){i=i||this.getItems();return i.filter(function(o){return o.getEnabled();});};
n.prototype.getItemByKey=function(s){return this.findItem("key",s);};
n.prototype.isOpen=function(){var p=this.getAggregation("picker");return!!(p&&p.isOpen());};
n.prototype.close=function(){var p=this.getAggregation("picker");if(p){p.close();}return this;};
n.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(i){i.detachEvent("_change",this.onItemChange,this);}return i;};
n.prototype.removeAllItems=function(){var o=this.removeAllAggregation("items");this.clearSelection();for(var i=0;i<o.length;i++){o[i].detachEvent("_change",this.onItemChange,this);}return o;};
n.prototype.intersectItems=function(i,o){return i.filter(function(p){return o.map(function(O){return O.getId();}).indexOf(p.getId())!==-1;});};
return n;});
sap.ui.predefine('sap/m/ComboBoxBaseRenderer',['./ComboBoxTextFieldRenderer','sap/ui/core/Renderer'],function(C,R){"use strict";var a=R.extend(C);a.CSS_CLASS_COMBOBOXBASE="sapMComboBoxBase";
a.getAccessibilityState=function(c){var A=C.getAccessibilityState.call(this,c);A.expanded=c.isOpen();return A;};
a.addOuterClasses=function(r,c){C.addOuterClasses.apply(this,arguments);var b=a.CSS_CLASS_COMBOBOXBASE;r.addClass(b);if(!c.getEnabled()){r.addClass(b+"Disabled");}if(!c.getEditable()){r.addClass(b+"Readonly");}};
a.addButtonClasses=function(r,c){C.addButtonClasses.apply(this,arguments);r.addClass(a.CSS_CLASS_COMBOBOXBASE+"Arrow");};
return a;},true);
sap.ui.predefine('sap/m/ComboBoxRenderer',['./ComboBoxBaseRenderer','sap/ui/core/Renderer'],function(C,R){"use strict";var a=R.extend(C);a.CSS_CLASS_COMBOBOX="sapMComboBox";
a.addOuterClasses=function(r,c){C.addOuterClasses.apply(this,arguments);r.addClass(a.CSS_CLASS_COMBOBOX);};
a.addInnerClasses=function(r,c){C.addInnerClasses.apply(this,arguments);r.addClass(a.CSS_CLASS_COMBOBOX+"Inner");};
a.addButtonClasses=function(r,c){C.addButtonClasses.apply(this,arguments);r.addClass(a.CSS_CLASS_COMBOBOX+"Arrow");};
a.addPlaceholderClasses=function(r,c){C.addPlaceholderClasses.apply(this,arguments);r.addClass(a.CSS_CLASS_COMBOBOX+"Placeholder");};
return a;},true);
sap.ui.predefine('sap/m/ComboBoxTextField',['./InputBase','./library','sap/ui/core/InvisibleText','sap/ui/core/library','sap/ui/Device','sap/ui/core/LabelEnablement',"./ComboBoxTextFieldRenderer"],function(I,l,a,c,D,L,C){"use strict";
var b=I.extend("sap.m.ComboBoxTextField",{metadata:{library:"sap.m",properties:{maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},showButton:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{_buttonLabelText:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}}}});
var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");
b.prototype.init=function(){I.prototype.init.apply(this,arguments);var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var i=this.addEndIcon({id:this.getId()+"-arrow",src:"sap-icon://slim-arrow-down",noTabStop:true,alt:r.getText("COMBOBOX_BUTTON"),decorative:false});i.addAriaLabelledBy("");};
b.prototype.getIcon=function(){return this.getAggregation("_endIcon")[0];};
b.prototype.onBeforeRendering=function(){I.prototype.onBeforeRendering.apply(this,arguments);var R=L.getReferencingLabels(this)||[];R.forEach(function(s){if(this.getIcon().getAriaLabelledBy().indexOf(s)===-1){this.getIcon().addAssociation("ariaLabelledBy",s,true);}},this);if(!this.oInvisibleText&&D.browser.msie){this.oInvisibleText=new a(this.getId()+'-describedby',{text:r.getText("ACC_CTR_TYPE_COMBO")}).toStatic();}};
b.prototype.setShowButton=function(s){this.getIcon().setVisible(s);return this.setProperty("showButton",s,true);};
b.prototype.getOpenArea=function(){return this.getIcon().getDomRef();};
b.prototype.onsapenter=function(e){I.prototype.onsapenter.apply(this,arguments);if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();var v=this.getValue(),V=v.length;this.setValue(v);this.selectText(V,V);};
b.prototype.getValue=function(){var d=this.getFocusDomRef();if(d){return d.value;}return this.getProperty("value");};
b.prototype.getDomRefForValueStateMessage=function(){return this.getDomRef();};
b.prototype.getAccessibilityInfo=function(){var i=I.prototype.getAccessibilityInfo.apply(this,arguments);i.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_COMBO");return i;};
b.prototype.exit=function(){I.prototype.exit.apply(this,arguments);if(this.oInvisibleText){this.oInvisibleText.destroy();this.oInvisibleText=null;}};
return b;});
sap.ui.predefine('sap/m/ComboBoxTextFieldRenderer',['./InputBaseRenderer','sap/ui/core/Renderer','sap/ui/core/LabelEnablement','sap/ui/Device'],function(I,R,L,D){"use strict";var C=R.extend(I);C.CSS_CLASS_COMBOBOXTEXTFIELD="sapMComboBoxTextField";
C.writeInnerAttributes=function(r,c){r.writeAttribute("autocomplete","off");r.writeAttribute("autocorrect","off");r.writeAttribute("autocapitalize","off");r.writeAttribute("type","text");};
C.writeOuterAttributes=function(r,c){if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","combobox");}};
C.getAriaRole=function(){};
C.getAccessibilityState=function(c){var a=I.getAccessibilityState.call(this,c);a.autocomplete="both";return a;};
C.getAriaDescribedBy=function(c){var a=I.getAriaDescribedBy.apply(this,arguments);if(D.browser.msie){return(a||"")+" "+c.oInvisibleText.getId();}return a;};
C.addOuterStyles=function(r,c){r.addStyle("max-width",c.getMaxWidth());};
return C;},true);
sap.ui.predefine('sap/m/CustomListItem',['./ListItemBase','./library','./CustomListItemRenderer'],function(L,l,C){"use strict";
var a=L.extend("sap.m.CustomListItem",{metadata:{library:"sap.m",defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",bindable:"bindable"}},designtime:"sap/m/designtime/CustomListItem.designtime"}});
a.prototype.getContentAnnouncement=function(){return this.getContent().map(function(c){return L.getAccessibilityText(c);}).join(" ").trim();};
return a;});
sap.ui.predefine('sap/m/CustomListItemRenderer',['./ListItemBaseRenderer','sap/ui/core/Renderer'],function(L,R){"use strict";var C=R.extend(L);
C.renderLIAttributes=function(r,l){r.addClass("sapMCLI");};
C.renderLIContent=function(r,l){var c=l.getContent();var a=c.length;for(var i=0;i<a;i++){r.renderControl(c[i]);}};
return C;},true);
sap.ui.predefine('sap/m/CustomTile',['./Tile','./library','./CustomTileRenderer'],function(T,l,C){"use strict";
var a=T.extend("sap.m.CustomTile",{metadata:{library:"sap.m",designtime:"sap/m/designtime/CustomTile.designtime",defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:false}}}});
return a;});
sap.ui.predefine('sap/m/CustomTileRenderer',['./TileRenderer','sap/ui/core/Renderer'],function(T,R){"use strict";var C=R.extend(T);
C.render=function(r,c){var t,v;r.write("<div tabindex=\"0\"");r.writeControlData(c);r.addClass("sapMCustomTile");r.writeClasses();if(c._invisible){r.addStyle("visibility","hidden");r.writeStyles();}if(c.getParent()instanceof sap.m.TileContainer){t=c.getParent();v=t._getVisibleTiles();r.writeAccessibilityState(c,{role:"option",posinset:t._indexOfVisibleTile(c,v)+1,setsize:v.length});}r.write(">");r.write("<div id=\""+c.getId()+"-remove\" class=\"sapMTCRemove\"></div>");r.write("<div class=\"sapMCustomTileContent\">");this._renderContent(r,c);r.write("</div></div>");};
C._renderContent=function(r,t){r.renderControl(t.getContent());};
return C;},true);
sap.ui.predefine('sap/m/DatePicker',['jquery.sap.global','sap/ui/Device','./InputBase','./DateTimeField','sap/ui/core/date/UniversalDate','./library','sap/ui/core/Control','sap/ui/core/library',"./DatePickerRenderer","sap/base/util/deepEqual","sap/base/assert","sap/base/Log","sap/ui/core/IconPool","sap/ui/core/Popup","./InstanceManager","sap/ui/dom/jquery/cursorPos"],function(q,D,I,a,U,l,C,c,b,d,e,L,f,P,g){"use strict";var T=c.TextAlign;var h=c.CalendarType;var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var i;
var j=a.extend("sap.m.DatePicker",{metadata:{library:"sap.m",properties:{displayFormatType:{type:"string",group:"Appearance",defaultValue:""},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}},aggregations:{specialDates:{type:"sap.ui.core.Element",multiple:true,singularName:"specialDate"}},associations:{legend:{type:"sap.ui.core.Control",multiple:false}},events:{navigate:{parameters:{dateRange:{type:"sap.ui.unified.DateRange"},afterPopupOpened:{type:"boolean"}}}},designtime:"sap/m/designtime/DatePicker.designtime",dnd:{draggable:false,droppable:true}}});
j.prototype.init=function(){a.prototype.init.apply(this,arguments);this._bIntervalSelection=false;this._bOnlyCalendar=true;this._bValid=true;this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);this._oMaxDate=new Date(9999,11,31,23,59,59,999);var u=this.addEndIcon({id:this.getId()+"-icon",src:this.getIconSrc(),noTabStop:true,tooltip:r.getText("OPEN_PICKER_TEXT")});this._bShouldClosePicker=false;u.addEventDelegate({onmousedown:function(E){this._bShouldClosePicker=!!this.isOpen();}},this);u.attachPress(function(){this.toggleOpen(this._bShouldClosePicker);},this);};
j.prototype.isOpen=function(){return this._oPopup&&this._oPopup.isOpen();};
j.prototype.toggleOpen=function(O){if(this.getEditable()&&this.getEnabled()){if(O){k.call(this);}else{_.call(this);}}};
j.prototype.getIconSrc=function(){return f.getIconURI("appointment-2");};
j.prototype.exit=function(){I.prototype.exit.apply(this,arguments);if(this._oPopup){if(this._oPopup.isOpen()){this._oPopup.close();}delete this._oPopup;}if(this._oCalendar){this._oCalendar.destroy();delete this._oCalendar;}if(this._iInvalidateCalendar){clearTimeout(this._iInvalidateCalendar);}this._sUsedDisplayPattern=undefined;this._sUsedDisplayCalendarType=undefined;this._oDisplayFormat=undefined;this._sUsedValuePattern=undefined;this._sUsedValueCalendarType=undefined;this._oValueFormat=undefined;};
j.prototype.invalidate=function(O){if(!O||O!=this._oCalendar){C.prototype.invalidate.apply(this,arguments);this._iInvalidateCalendar=setTimeout(t.bind(this),0);}};
j.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);this._checkMinMaxDate();var v=this._getValueHelpIcon();if(v){v.setProperty("visible",this.getEditable(),true);}};
j.prototype.setWidth=function(w){return I.prototype.setWidth.call(this,w||"100%");};
j.prototype.getWidth=function(w){return this.getProperty("width")||"100%";};
j.prototype.applyFocusInfo=function(F){this._bFocusNoPopup=true;I.prototype.applyFocusInfo.apply(this,arguments);};
j.prototype.onfocusin=function(E){if(!q(E.target).hasClass("sapUiIcon")){I.prototype.onfocusin.apply(this,arguments);}this._bFocusNoPopup=undefined;};
j.prototype.onsapshow=function(E){this.toggleOpen(this.isOpen());E.preventDefault();};
j.prototype.onsaphide=j.prototype.onsapshow;
j.prototype.onsappageup=function(E){m.call(this,1,"day");E.preventDefault();};
j.prototype.onsappageupmodifiers=function(E){if(!E.ctrlKey&&E.shiftKey){m.call(this,1,"month");}else{m.call(this,1,"year");}E.preventDefault();};
j.prototype.onsappagedown=function(E){m.call(this,-1,"day");E.preventDefault();};
j.prototype.onsappagedownmodifiers=function(E){if(!E.ctrlKey&&E.shiftKey){m.call(this,-1,"month");}else{m.call(this,-1,"year");}E.preventDefault();};
j.prototype.onkeypress=function(E){if(!E.charCode||E.metaKey||E.ctrlKey){return;}var F=this._getFormatter(true);var u=String.fromCharCode(E.charCode);if(u&&F.sAllowedCharacters&&F.sAllowedCharacters.indexOf(u)<0){E.preventDefault();}};
j.prototype._getValueHelpIcon=function(){var v=this.getAggregation("_endIcon");return v&&v[0];};
j.prototype._dateValidation=function(u){this._bValid=true;if(u&&(u.getTime()<this._oMinDate.getTime()||u.getTime()>this._oMaxDate.getTime())){this._bValid=false;e(this._bValid,"Date must be in valid range");}this.setProperty("dateValue",u);return u;};
j.prototype.setMinDate=function(u){if(this._isValidDate(u)){throw new Error("Date must be a JavaScript date object; "+this);}if(d(this.getMinDate(),u)){return this;}if(u){var y=u.getFullYear();if(y<1||y>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this);}this._oMinDate=new Date(u.getTime());var v=this.getDateValue();if(v&&v.getTime()<u.getTime()){L.warning("DateValue not in valid date range",this);}}else{this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);}this.setProperty("minDate",u);if(this._oCalendar){this._oCalendar.setMinDate(u);}this._oMinDate.setHours(0,0,0,0);return this;};
j.prototype.setMaxDate=function(u){if(this._isValidDate(u)){throw new Error("Date must be a JavaScript date object; "+this);}if(d(this.getMaxDate(),u)){return this;}if(u){var y=u.getFullYear();if(y<1||y>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this);}this._oMaxDate=new Date(u.getTime());var v=this.getDateValue();if(v&&v.getTime()>u.getTime()){L.warning("DateValue not in valid date",this);}}else{this._oMaxDate=new Date(9999,11,31,23,59,59,999);}this.setProperty("maxDate",u);if(this._oCalendar){this._oCalendar.setMaxDate(u);}this._oMaxDate.setHours(23,59,59,999);return this;};
j.prototype._checkMinMaxDate=function(){if(this._oMinDate.getTime()>this._oMaxDate.getTime()){L.warning("minDate > MaxDate -> dates switched",this);var M=new Date(this._oMinDate.getTime());var u=new Date(this._oMaxDate.getTime());this._oMinDate=new Date(u.getTime());this._oMaxDate=new Date(M.getTime());this.setProperty("minDate",u,true);this.setProperty("maxDate",M,true);if(this._oCalendar){this._oCalendar.setMinDate(u);this._oCalendar.setMaxDate(M);}}var v=this.getDateValue();if(v&&(v.getTime()<this._oMinDate.getTime()||v.getTime()>this._oMaxDate.getTime())){L.error("dateValue "+v.toString()+"(value="+this.getValue()+") does not match "+"min/max date range("+this._oMinDate.toString()+" - "+this._oMaxDate.toString()+"). App. "+"developers should take care to maintain dateValue/value accordingly.",this);}};
j.prototype.getDisplayFormatType=function(){return this.getProperty("displayFormatType");};
j.prototype._handleDateValidation=function(u){this._bValid=true;if(!u||u.getTime()<this._oMinDate.getTime()||u.getTime()>this._oMaxDate.getTime()){this._bValid=false;L.warning("Value can not be converted to a valid date",this);}this.setProperty("dateValue",u);};
j.prototype.setDisplayFormatType=function(u){if(u){var F=false;for(var v in h){if(v==u){F=true;break;}}if(!F){throw new Error(u+" is not a valid calendar type"+this);}}this.setProperty("displayFormatType",u,true);this.setDisplayFormat(this.getDisplayFormat());return this;};
j.prototype.setSecondaryCalendarType=function(u){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",u,true);if(this._oCalendar){this._oCalendar.setSecondaryCalendarType(u);}return this;};
j.prototype.addSpecialDate=function(S){s.call(this,S);this.addAggregation("specialDates",S,true);t.call(this);return this;};
j.prototype.insertSpecialDate=function(S,u){s.call(this,S);this.insertAggregation("specialDates",S,u,true);t.call(this);return this;};
j.prototype.removeSpecialDate=function(S){var R=this.removeAggregation("specialDates",S,true);t.call(this);return R;};
j.prototype.removeAllSpecialDates=function(){var R=this.removeAllAggregation("specialDates",true);t.call(this);return R;};
j.prototype.destroySpecialDates=function(){this.destroyAggregation("specialDates",true);t.call(this);return this;};
j.prototype.setLegend=function(u){this.setAssociation("legend",u,true);var v=this.getLegend();if(v){var w=sap.ui.require("sap/ui/unified/CalendarLegend");u=sap.ui.getCore().byId(v);if(u&&!(typeof w=="function"&&u instanceof w)){throw new Error(u+" is not an sap.ui.unified.CalendarLegend. "+this);}}if(this._oCalendar){this._oCalendar.setLegend(v);}return this;};
j.prototype.onChange=function(E){if(!this.getEditable()||!this.getEnabled()){return;}var v=this._$input.val();var O=this._formatValue(this.getDateValue());if(v==O&&this._bValid){return;}var u;this._bValid=true;if(v!=""){u=this._parseValue(v,true);if(!u||u.getTime()<this._oMinDate.getTime()||u.getTime()>this._oMaxDate.getTime()){this._bValid=false;u=undefined;}else{v=this._formatValue(u);}}if(this.getDomRef()&&(this._$input.val()!==v)){this._$input.val(v);this._curpos=this._$input.cursorPos();}if(u){v=this._formatValue(u,true);}if(this._lastValue!==v||(u&&this.getDateValue()&&u.getFullYear()!==this.getDateValue().getFullYear())){this._lastValue=v;this.setProperty("value",v,true);var N=this.getValue();if(this._bValid&&v==N){this.setProperty("dateValue",u,true);}v=N;if(this.isOpen()){if(this._bValid){u=this.getDateValue();}this._oCalendar.focusDate(u);var S=this._oDateRange.getStartDate();if((!S&&u)||(S&&u&&S.getTime()!=u.getTime())){this._oDateRange.setStartDate(new Date(u.getTime()));}else if(S&&!u){this._oDateRange.setStartDate(undefined);}}this.fireChangeEvent(v,{valid:this._bValid});}};
j.prototype._getInputValue=function(v){v=(typeof v=="undefined")?this._$input.val():v.toString();var u=this._parseValue(v,true);v=this._formatValue(u,true);return v;};
j.prototype.updateDomValue=function(v){if(this.isActive()&&(this._$input.val()!==v)){this._bCheckDomValue=true;v=(typeof v=="undefined")?this._$input.val():v.toString();this._curpos=this._$input.cursorPos();var u=this._parseValue(v,true);v=this._formatValue(u);this._$input.val(v);this._$input.cursorPos(this._curpos);}return this;};
j.prototype._storeInputSelection=function(u){if((D.browser.msie||D.browser.edge)&&!D.support.touch){this._oInputSelBeforePopupOpen={iStart:u.selectionStart,iEnd:u.selectionEnd};u.selectionStart=0;u.selectionEnd=0;}};
j.prototype._restoreInputSelection=function(u){if((D.browser.msie||D.browser.edge)&&!D.support.touch){u.selectionStart=this._oInputSelBeforePopupOpen.iStart;u.selectionEnd=this._oInputSelBeforePopupOpen.iEnd;}};
function _(){this._createPopup();this._createPopupContent();var u;var B=this.getBinding("value");if(B&&B.oType&&B.oType.oOutputFormat){u=B.oType.oOutputFormat.oFormatOptions.calendarType;}else if(B&&B.oType&&B.oType.oFormat){u=B.oType.oFormat.oFormatOptions.calendarType;}if(!u){u=this.getDisplayFormatType();}if(u){this._oCalendar.setPrimaryCalendarType(u);}var v=this._bValid?this._formatValue(this.getDateValue()):this.getValue();if(v!=this._$input.val()){this.onChange();}this._fillDateRange();this._openPopup();this.fireNavigate({dateRange:this._getVisibleDatesRange(this._oCalendar),afterPopupOpened:true});}
j.prototype._createPopup=function(){if(!this._oPopup){this._oPopup=new P();this._oPopup.setAutoClose(true);this._oPopup.setDurations(0,0);this._oPopup.attachOpened(n,this);this._oPopup.attachClosed(o,this);}};
j.prototype._openPopup=function(){if(!this._oPopup){return;}this._storeInputSelection(this._$input.get(0));this._oPopup.setAutoCloseAreas([this.getDomRef()]);var u=P.Dock;var A;if(this.getTextAlign()==T.End){A=u.EndBottom+"-4";this._oPopup.open(0,u.EndTop,A,this,null,"fit",true);}else{A=u.BeginBottom+"-4";this._oPopup.open(0,u.BeginTop,A,this,null,"fit",true);}};
j.prototype._getVisibleDatesRange=function(u){var v=u._getVisibleDays();return new sap.ui.unified.DateRange({startDate:v[0].toLocalJSDate(),endDate:v[v.length-1].toLocalJSDate()});};
j.prototype._createPopupContent=function(){if(!this._oCalendar){if(!i){sap.ui.getCore().loadLibrary("sap.ui.unified");i=sap.ui.requireSync("sap/ui/unified/Calendar");}this._oCalendar=new i(this.getId()+"-cal",{intervalSelection:this._bIntervalSelection,minDate:this.getMinDate(),maxDate:this.getMaxDate(),legend:this.getLegend(),startDateChange:function(){this.fireNavigate({dateRange:this._getVisibleDatesRange(this._oCalendar)});}.bind(this)});this._oDateRange=new sap.ui.unified.DateRange();this._oCalendar.addSelectedDate(this._oDateRange);if(this.$().closest(".sapUiSizeCompact").length>0){this._oCalendar.addStyleClass("sapUiSizeCompact");}if(this._bSecondaryCalendarTypeSet){this._oCalendar.setSecondaryCalendarType(this.getSecondaryCalendarType());}if(this._bOnlyCalendar){this._oCalendar.attachSelect(this._selectDate,this);this._oCalendar.attachCancel(k,this);this._oCalendar.attachEvent("_renderMonth",p,this);this._oCalendar.setPopupMode(true);this._oCalendar.setParent(this,undefined,true);this._oPopup.setContent(this._oCalendar);}}};
j.prototype._fillDateRange=function(){var u=this.getDateValue();if(u&&u.getTime()>=this._oMinDate.getTime()&&u.getTime()<=this._oMaxDate.getTime()){this._oCalendar.focusDate(new Date(u.getTime()));if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=u.getTime()){this._oDateRange.setStartDate(new Date(u.getTime()));}}else{var v=this.getInitialFocusedDateValue();var F=v?v:new Date();var M=this._oMaxDate.getTime();if(F.getTime()<this._oMinDate.getTime()||F.getTime()>M){F=this._oMinDate;}this._oCalendar.focusDate(F);if(this._oDateRange.getStartDate()){this._oDateRange.setStartDate(undefined);}}};
j.prototype.getAccessibilityInfo=function(){var R=this.getRenderer();var u=I.prototype.getAccessibilityInfo.apply(this,arguments);var v=this.getValue()||"";if(this._bValid){var w=this.getDateValue();if(w){v=this._formatValue(w);}}u.type=r.getText("ACC_CTR_TYPE_DATEINPUT");u.description=[v,R.getLabelledByAnnouncement(this),R.getDescribedByAnnouncement(this)].join(" ").trim();return u;};
j.prototype._selectDate=function(E){var u=this.getDateValue();var v=this._getSelectedDate();var V="";if(!d(v,u)){this.setDateValue(new Date(v.getTime()));V=this.getValue();this.fireChangeEvent(V,{valid:true});if(this.getDomRef()&&(D.system.desktop||!D.support.touch)){this._curpos=this._$input.val().length;this._$input.cursorPos(this._curpos);}}else if(!this._bValid){V=this._formatValue(v);if(V!=this._$input.val()){this._bValid=true;if(this.getDomRef()){this._$input.val(V);this._lastValue=V;}V=this._formatValue(v,true);this.setProperty("value",V,true);this.fireChangeEvent(V,{valid:true});}}else if(D.system.desktop||!D.support.touch){this.focus();}this._oPopup.close();};
j.prototype._getSelectedDate=function(){var S=this._oCalendar.getSelectedDates();var u;if(S.length>0){u=S[0].getStartDate();}return u;};
function k(E){if(this.isOpen()){this._oPopup.close();if((D.system.desktop||!D.support.touch)){this.focus();}}}
function m(N,u){var O=this.getDateValue();var v=this._$input.cursorPos();if(O&&this.getEditable()&&this.getEnabled()){var w;var B=this.getBinding("value");if(B&&B.oType&&B.oType.oOutputFormat){w=B.oType.oOutputFormat.oFormatOptions.calendarType;}else if(B&&B.oType&&B.oType.oFormat){w=B.oType.oFormat.oFormatOptions.calendarType;}if(!w){w=this.getDisplayFormatType();}var x=U.getInstance(new Date(O.getTime()),w);O=U.getInstance(new Date(O.getTime()),w);switch(u){case"day":x.setDate(x.getDate()+N);break;case"month":x.setMonth(x.getMonth()+N);var M=(O.getMonth()+N)%12;if(M<0){M=12+M;}while(x.getMonth()!=M){x.setDate(x.getDate()-1);}break;case"year":x.setFullYear(x.getFullYear()+N);while(x.getMonth()!=O.getMonth()){x.setDate(x.getDate()-1);}break;default:break;}if(x.getTime()<this._oMinDate.getTime()){x=new U(this._oMinDate.getTime());}else if(x.getTime()>this._oMaxDate.getTime()){x=new U(this._oMaxDate.getTime());}if(!d(this.getDateValue(),x.getJSDate())){this.setDateValue(new Date(x.getTime()));this._curpos=v;this._$input.cursorPos(this._curpos);var V=this.getValue();this.fireChangeEvent(V,{valid:true});}}}
function n(E){this.addStyleClass(I.ICON_PRESSED_CSS_CLASS);this._renderedDays=this._oCalendar.$("-Month0-days").find(".sapUiCalItem").length;this.$("inner").attr("aria-owns",this.getId()+"-cal");this.$("inner").attr("aria-expanded",true);g.addPopoverInstance(this._oPopup);}
function o(E){this.removeStyleClass(I.ICON_PRESSED_CSS_CLASS);this.$("inner").attr("aria-expanded",false);this._restoreInputSelection(this._$input.get(0));g.removePopoverInstance(this._oPopup);}
function p(E){var u=E.getParameter("days");if(u>this._renderedDays){this._renderedDays=u;this._oPopup._applyPosition(this._oPopup._oLastPosition);}}
function s(S){var u=sap.ui.require("sap/ui/unified/DateTypeRange");if(S&&!(u&&S instanceof u)){throw new Error(S+"is not valid for aggregation \"specialDates\" of "+this);}}
function t(){if(this.isOpen()){this._oCalendar._bDateRangeChanged=true;this._oCalendar.invalidate();}}
return j;});
sap.ui.predefine('sap/m/DatePickerRenderer',['sap/ui/core/Renderer','./InputBaseRenderer'],function(R,I){"use strict";var D=R.extend(I);
D.writeInnerValue=function(r,d){if(d._bValid){r.writeAttributeEscaped("value",d._formatValue(d.getDateValue()));}else{r.writeAttributeEscaped("value",d.getValue());}};
D.writeInnerAttributes=function(r,d){r.writeAttribute("type","text");if(d._bMobile){r.writeAttribute("readonly","readonly");}};
D.getAriaRole=function(d){return"combobox";};
D.getDescribedByAnnouncement=function(d){var b=I.getDescribedByAnnouncement.apply(this,arguments);return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("DATEPICKER_DATE_TYPE")+" "+b;};
D.getAccessibilityState=function(d){var a=I.getAccessibilityState.apply(this,arguments);a["autocomplete"]="none";a["haspopup"]=true;a["expanded"]=false;if(d._bMobile&&d.getEnabled()&&d.getEditable()){a["readonly"]=false;}return a;};
return D;},true);
sap.ui.predefine('sap/m/DateRangeSelection',['sap/ui/Device','./DatePicker','./library','sap/ui/core/LocaleData','sap/ui/core/format/DateFormat','./DateRangeSelectionRenderer',"sap/base/util/deepEqual","sap/base/Log","sap/base/assert","sap/ui/dom/jquery/cursorPos"],function(D,a,l,L,b,c,d,f,g){"use strict";
var h=a.extend("sap.m.DateRangeSelection",{metadata:{library:"sap.m",properties:{delimiter:{type:"string",group:"Misc",defaultValue:'-'},secondDateValue:{type:"object",group:"Data",defaultValue:null},from:{type:"object",group:"Misc",defaultValue:null,deprecated:true},to:{type:"object",group:"Misc",defaultValue:null,deprecated:true}},designtime:"sap/m/designtime/DateRangeSelection.designtime",dnd:{draggable:false,droppable:true}}});
h.prototype.init=function(){a.prototype.init.apply(this,arguments);this._bIntervalSelection=true;};
h.prototype.onkeypress=function(e){if(!e.charCode||e.metaKey||e.ctrlKey){return;}var F=o.call(this);var s=n.call(this);var A=F.sAllowedCharacters+s+" ";var C=String.fromCharCode(e.charCode);if(C&&F.sAllowedCharacters&&A.indexOf(C)<0){e.preventDefault();}};
h.prototype._getPlaceholder=function(){var P=this.getPlaceholder(),B,e,i,s;if(!P){B=this.getBinding("value");i=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();s=L.getInstance(i);if(B&&B.getType()instanceof sap.ui.model.type.DateInterval){e=B.getType();if(e.oFormatOptions&&e.oFormatOptions.format){P=s.getCustomDateTimePattern(e.oFormatOptions.format);}else{P=s.getDatePattern("medium");}}else{P=this.getDisplayFormat();if(!P){P="medium";}if(this._checkStyle(P)){P=s.getDatePattern(P);}}var t=n.call(this);if(t&&t!==""){P=P+" "+t+" "+P;}}return P;};
h.prototype.setValue=function(v){if(v!==this.getValue()){this._lastValue=v;}else{return this;}this.setProperty("value",v);this._bValid=true;var e=[undefined,undefined];if(v){e=this._parseValue(v);if(!m.call(this,e[0],e[1])[0]){this._bValid=false;f.warning("Value can not be converted to a valid dates",this);}}this.setProperty("dateValue",_(e[0]));this.setProperty("secondDateValue",_(e[1]));if(this.getDomRef()){var O=this._formatValue(e[0],e[1]);if(this._$input.val()!==O){this._$input.val(O);this._curpos=this._$input.cursorPos();}}return this;};
function _(B){return(typeof B==='number')?new Date(B):B;}
function j(B){return(B&&B.getTime)?B.getTime():B;}
h.prototype.setValueFormat=function(v){this.setProperty("valueFormat",v,true);f.warning("Property valueFormat is not supported in sap.m.DateRangeSelection control.",this);return this;};
h.prototype.setDisplayFormat=function(s){this.setProperty("displayFormat",s,true);var O=this._formatValue(this.getDateValue(),this.getSecondDateValue());this.setProperty("value",O,true);if(this.getDomRef()&&(this._$input.val()!==O)){this._$input.val(O);this._curpos=this._$input.cursorPos();}return this;};
h.prototype.setFrom=function(F){this.setDateValue(F);return this;};
h.prototype.getFrom=function(){return this.getDateValue();};
h.prototype.setTo=function(t){this.setSecondDateValue(t);return this;};
h.prototype.getTo=function(){return this.getSecondDateValue();};
h.prototype.setDateValue=function(e){if(this._isValidDate(e)){throw new Error("Date must be a JavaScript date object; "+this);}if(d(this.getDateValue(),e)){return this;}a.prototype._dateValidation.call(this,e);this._syncDateObjectsToValue(e,this.getSecondDateValue());return this;};
h.prototype.setSecondDateValue=function(s){if(this._isValidDate(s)){throw new Error("Date must be a JavaScript date object; "+this);}if(d(this.getSecondDateValue(),s)){return this;}this._bValid=true;if(s&&(s.getTime()<this._oMinDate.getTime()||s.getTime()>this._oMaxDate.getTime())){this._bValid=false;g(this._bValid,"Date must be in valid range");}this.setProperty("secondDateValue",s);this._syncDateObjectsToValue(this.getDateValue(),s);return this;};
h.prototype.setMinDate=function(e){a.prototype.setMinDate.apply(this,arguments);if(e){var s=this.getSecondDateValue();if(s&&s.getTime()<this._oMinDate.getTime()){f.warning("SecondDateValue not in valid date range",this);}}return this;};
h.prototype.setMaxDate=function(e){a.prototype.setMaxDate.apply(this,arguments);if(e){var s=this.getSecondDateValue();if(s&&s.getTime()>this._oMaxDate.getTime()){f.warning("SecondDateValue not in valid date range",this);}}return this;};
h.prototype._checkMinMaxDate=function(){a.prototype._checkMinMaxDate.apply(this,arguments);var s=this.getSecondDateValue();if(s&&(s.getTime()<this._oMinDate.getTime()||s.getTime()>this._oMaxDate.getTime())){f.error("secondDateValue "+s.toString()+"(value="+this.getValue()+") does not match "+"min/max date range("+this._oMinDate.toString()+" - "+this._oMaxDate.toString()+"). App. "+"developers should take care to maintain secondDateValue/value accordingly.",this);}};
h.prototype._parseValue=function(v){var F;var i=[];var s,t;var B=this.getBinding("value");if(B&&B.getType()instanceof sap.ui.model.type.DateInterval){try{i=B.getType().parseValue(v,"string");}catch(e){return[undefined,undefined];}if(B.getType().oFormatOptions&&B.getType().oFormatOptions.UTC){i=i.map(function(U){return new Date(U.getUTCFullYear(),U.getUTCMonth(),U.getUTCDate(),U.getUTCHours(),U.getUTCMinutes(),U.getUTCSeconds());});}return i;}var u=n.call(this);if(u&&v){v=v.trim();v=r(v,[u," "]);i=v.split(u);if(i.length===2){if(i[0].slice(i[0].length-1,i[0].length)==" "){i[0]=i[0].slice(0,i[0].length-1);}if(i[1].slice(0,1)==" "){i[1]=i[1].slice(1);}}else{i=v.split(" "+u+" ");}if(v.indexOf(u)===-1){var w=v.split(" ");if(w.length===2){i=w;}}}if(v&&i.length<=2){F=o.call(this);if((!u||u==="")||i.length===1){s=F.parse(v);}else if(i.length===2){s=F.parse(i[0]);t=F.parse(i[1]);if(!s||!t){s=undefined;t=undefined;}}}return[s,t];};
h.prototype._formatValue=function(e,s){var v="",i=n.call(this),F,B,t,u;t=e;u=s;if(t){B=this.getBinding("value");if(B&&B.getType()instanceof sap.ui.model.type.DateInterval){if(B.getType().oFormatOptions&&B.getType().oFormatOptions.source&&B.getType().oFormatOptions.source.pattern==="timestamp"){v=B.getType().formatValue([j(e),j(s)],"string");}else{if(B.getType().oFormatOptions&&B.getType().oFormatOptions.UTC){t=new Date(Date.UTC(e.getFullYear(),e.getMonth(),e.getDate(),e.getHours(),e.getMinutes(),e.getSeconds()));if(s){u=new Date(Date.UTC(s.getFullYear(),s.getMonth(),s.getDate(),s.getHours(),s.getMinutes(),s.getSeconds()));}}v=B.getType().formatValue([t,u],"string");}}else{F=o.call(this);if(i&&i!==""&&u){v=F.format(t)+" "+i+" "+F.format(u);}else{v=F.format(t);}}}return v;};
h.prototype.onChange=function(){if(!this.getEditable()||!this.getEnabled()){return;}var v=this._$input.val();var e=[undefined,undefined];this._bValid=true;if(v!=""){e=this._parseValue(v);e=m.call(this,e[0],e[1]);if(e[0]){v=this._formatValue(e[0],e[1]);}else{this._bValid=false;}}if(v!==this._lastValue){if(this.getDomRef()&&(this._$input.val()!==v)){this._$input.val(v);this._curpos=this._$input.cursorPos();}this._lastValue=v;this.setProperty("value",v,true);if(this._bValid){this.setProperty("dateValue",_(e[0]),true);this.setProperty("secondDateValue",_(e[1]),true);}if(this._oPopup&&this._oPopup.isOpen()){var s=this.getDateValue();if(s){if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!==s.getTime()){this._oDateRange.setStartDate(new Date(s.getTime()));this._oCalendar.focusDate(s);}}else{if(this._oDateRange.getStartDate()){this._oDateRange.setStartDate(undefined);}}var E=this.getSecondDateValue();if(E){if(!this._oDateRange.getEndDate()||this._oDateRange.getEndDate().getTime()!==E.getTime()){this._oDateRange.setEndDate(new Date(E.getTime()));this._oCalendar.focusDate(E);}}else{if(this._oDateRange.getEndDate()){this._oDateRange.setEndDate(undefined);}}}k.call(this,this._bValid);}};
h.prototype._getInputValue=function(v){v=(typeof v=="undefined")?this._$input.val():v.toString();var e=this._parseValue(v);v=this._formatValue(e[0],e[1]);return v;};
h.prototype.updateDomValue=function(v){this._bCheckDomValue=true;v=(typeof v=="undefined")?this._$input.val():v.toString();this._curpos=this._$input.cursorPos();var e=this._parseValue(v);v=this._formatValue(e[0],e[1]);if(this.isActive()&&(this._$input.val()!==v)){this._$input.val(v);this._$input.cursorPos(this._curpos);}return this;};
h.prototype.onsappageup=function(){};
h.prototype.onsappageupmodifiers=function(){};
h.prototype.onsappagedown=function(){};
h.prototype.onsappagedownmodifiers=function(){};
h.prototype._fillDateRange=function(){a.prototype._fillDateRange.apply(this,arguments);var e=this.getSecondDateValue();if(e&&e.getTime()>=this._oMinDate.getTime()&&e.getTime()<=this._oMaxDate.getTime()){if(!this._oDateRange.getEndDate()||this._oDateRange.getEndDate().getTime()!==e.getTime()){this._oDateRange.setEndDate(new Date(e.getTime()));}}else{if(this._oDateRange.getEndDate()){this._oDateRange.setEndDate(undefined);}}};
h.prototype._selectDate=function(e){var s=this._oCalendar.getSelectedDates();if(s.length>0){var i=s[0].getStartDate();var t=s[0].getEndDate();if(i&&t){var u=this.getDateValue();var v=this.getSecondDateValue();t.setHours(11,59,59);var V;if(!d(i,u)||!d(t,v)){if(d(t,v)){this.setDateValue(i);}else{this.setProperty("dateValue",i,true);this.setSecondDateValue(t);}V=this.getValue();k.call(this,true);if(D.system.desktop||!D.support.touch){this._curpos=V.length;this._$input.cursorPos(this._curpos);}}else if(!this._bValid){V=this._formatValue(i,t);if(V!=this._$input.val()){this._bValid=true;if(this.getDomRef()){this._$input.val(V);}k.call(this,true);}}this._oPopup.close();}}};
h.prototype.getAccessibilityInfo=function(){var R=this.getRenderer();var i=a.prototype.getAccessibilityInfo.apply(this,arguments);var v=this.getValue()||"";if(this._bValid){var e=this.getDateValue();if(e){v=this._formatValue(e,this.getSecondDateValue());}}i.description=[v,R.getLabelledByAnnouncement(this),R.getDescribedByAnnouncement(this)].join(" ").trim();return i;};
h.prototype._syncDateObjectsToValue=function(e,s){var v=this._formatValue(e,s);if(v!==this.getValue()){this._lastValue=v;}this.setProperty("value",v);if(this.getDomRef()){var O=this._formatValue(e,s);if(this._$input.val()!==O){this._$input.val(O);this._curpos=this._$input.cursorPos();}}};
function k(v){this.fireChangeEvent(this.getValue(),{from:this.getDateValue(),to:this.getSecondDateValue(),valid:v});}
function m(e,s){var F,S;if(e&&e.getTime){F=e.getTime();}else if(typeof e==='number'){F=e;}if(s&&s.getTime){S=s.getTime();}else if(typeof s==='number'){S=s;}if(e&&s&&F>S){var t=e;e=s;s=t;}if((e&&(F<this._oMinDate.getTime()||F>this._oMaxDate.getTime()))||(s&&(S<this._oMinDate.getTime()||S>this._oMaxDate.getTime()))){return[undefined,undefined];}else{return[e,s];}}
function n(){var s=this.getDelimiter();if(!s){if(!this._sLocaleDelimiter){var e=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var i=L.getInstance(e);var P=i.getIntervalPattern();var I=P.indexOf("{0}")+3;var t=P.indexOf("{1}");s=P.slice(I,t);if(s.length>1){if(s.slice(0,1)==" "){s=s.slice(1);}if(s.slice(s.length-1,s.length)==" "){s=s.slice(0,s.length-1);}}this._sLocaleDelimiter=s;}else{s=this._sLocaleDelimiter;}}return s;}
function o(){var P=(this.getDisplayFormat()||"medium");var F;var C=this.getDisplayFormatType();if(P==this._sUsedDisplayPattern&&C==this._sUsedDisplayCalendarType){F=this._oDisplayFormat;}else{if(this._checkStyle(P)){F=b.getInstance({style:P,strictParsing:true,calendarType:C});}else{F=b.getInstance({pattern:P,strictParsing:true,calendarType:C});}this._sUsedDisplayPattern=P;this._sUsedDisplayCalendarType=C;this._oDisplayFormat=F;}return F;}
function p(v,e){return v&&e&&v.lastIndexOf(e)===v.length-e.length;}
function q(v,s){return v&&s&&v.indexOf(s)===0;}
function r(v,P){var i=0,t=P;if(!t){t=[" "];}while(i<t.length){if(p(v,t[i])){v=v.substring(0,v.length-t[i].length);i=0;continue;}i++;}i=0;while(i<t.length){if(q(v,t[i])){v=v.substring(t[i].length);i=0;continue;}i++;}return v;}
return h;});
sap.ui.predefine('sap/m/DateRangeSelectionRenderer',['sap/ui/core/Renderer','./DatePickerRenderer'],function(R,D){"use strict";var a=R.extend(D);
a.writeInnerValue=function(r,c){if(c._bValid){r.writeAttributeEscaped("value",c._formatValue(c.getDateValue(),c.getSecondDateValue()));}else{r.writeAttributeEscaped("value",c.getValue());}};
return a;},true);
sap.ui.predefine('sap/m/DateTimeField',['sap/ui/model/type/Date','sap/ui/model/odata/type/ODataType','./InputBase','sap/ui/core/LocaleData','sap/ui/core/library','sap/ui/core/format/DateFormat','./DateTimeFieldRenderer',"sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/cursorPos"],function(S,O,I,L,c,D,a,d,b,q){"use strict";var C=c.CalendarType;
var e=I.extend("sap.m.DateTimeField",{metadata:{"abstract":true,library:"sap.m",properties:{displayFormat:{type:"string",group:"Appearance",defaultValue:null},valueFormat:{type:"string",group:"Data",defaultValue:null},dateValue:{type:"object",group:"Data",defaultValue:null},initialFocusedDateValue:{type:"object",group:"Data",defaultValue:null}}}});
e.prototype.setValue=function(v){v=this.validateProperty("value",v);var o=this.getValue();if(v===o){return this;}else{this._lastValue=v;}this.setProperty("value",v);this._bValid=true;var f;if(v){f=this._parseValue(v);if(!f||f.getTime()<this._oMinDate.getTime()||f.getTime()>this._oMaxDate.getTime()){this._bValid=false;b.warning("Value can not be converted to a valid date",this);}}this.setProperty("dateValue",f);if(this.getDomRef()){var s;if(f){s=this._formatValue(f);}else{s=v;}if(this._$input.val()!==s){this._$input.val(s);this._curpos=this._$input.cursorPos();}}return this;};
e.prototype.setDateValue=function(o){if(this._isValidDate(o)){throw new Error("Date must be a JavaScript date object; "+this);}if(d(this.getDateValue(),o)){return this;}o=this._dateValidation(o);var v=this._formatValue(o,true);if(v!==this.getValue()){this._lastValue=v;}this.setProperty("value",v);if(this.getDomRef()){var s=this._formatValue(o);if(this._$input.val()!==s){this._$input.val(s);this._curpos=this._$input.cursorPos();}}return this;};
e.prototype.setValueFormat=function(v){this.setProperty("valueFormat",v,true);var V=this.getValue();if(V){this._handleDateValidation(this._parseValue(V));}return this;};
e.prototype.setDisplayFormat=function(s){this.setProperty("displayFormat",s,true);this.updateDomValue(this._formatValue(this.getDateValue()));this._updateDomPlaceholder(this._getPlaceholder());return this;};
e.prototype.getDisplayFormatType=function(){return null;};
e.prototype._dateValidation=function(o){this._bValid=true;this.setProperty("dateValue",o);return o;};
e.prototype._handleDateValidation=function(o){this._bValid=true;this.setProperty("dateValue",o);};
e.prototype._getPlaceholder=function(){var p=this.getPlaceholder();if(!p){p=this._getDisplayFormatPattern();if(!p){p=this._getDefaultDisplayStyle();}if(this._checkStyle(p)){p=this._getLocaleBasedPattern(p);}}return p;};
e.prototype._getLocaleBasedPattern=function(p){return L.getInstance(sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale()).getDatePattern(p);};
e.prototype._parseValue=function(v,f){return this._getFormatter(f).parse(v);};
e.prototype._formatValue=function(o,v){if(o){return this._getFormatter(!v).format(o);}return"";};
e.prototype._getDefaultDisplayStyle=function(){return"medium";};
e.prototype._getDefaultValueStyle=function(){return"short";};
e.prototype._getFormatter=function(f){var p=this._getBoundValueTypePattern(),r=false,F,B=this.getBinding("value"),s;if(B&&B.oType&&B.oType.oOutputFormat){r=!!B.oType.oOutputFormat.oFormatOptions.relative;s=B.oType.oOutputFormat.oFormatOptions.calendarType;}if(!p){if(f){p=(this.getDisplayFormat()||this._getDefaultDisplayStyle());s=this.getDisplayFormatType();}else{p=(this.getValueFormat()||this._getDefaultValueStyle());s=C.Gregorian;}}if(!s){s=sap.ui.getCore().getConfiguration().getCalendarType();}if(f){if(p===this._sUsedDisplayPattern&&s===this._sUsedDisplayCalendarType){F=this._oDisplayFormat;}}else{if(p===this._sUsedValuePattern&&s===this._sUsedValueCalendarType){F=this._oValueFormat;}}if(F){return F;}return this._getFormatterInstance(F,p,r,s,f);};
e.prototype._getFormatterInstance=function(f,p,r,s,g){if(this._checkStyle(p)){f=this._getFormatInstance({style:p,strictParsing:true,relative:r,calendarType:s},g);}else{f=this._getFormatInstance({pattern:p,strictParsing:true,relative:r,calendarType:s},g);}if(g){this._sUsedDisplayPattern=p;this._sUsedDisplayCalendarType=s;this._oDisplayFormat=f;}else{this._sUsedValuePattern=p;this._sUsedValueCalendarType=s;this._oValueFormat=f;}return f;};
e.prototype._getFormatInstance=function(A,f){return D.getInstance(A);};
e.prototype._checkStyle=function(p){return(p==="short"||p==="medium"||p==="long"||p==="full");};
e.prototype._getDisplayFormatPattern=function(){var p=this._getBoundValueTypePattern();if(p){return p;}p=this.getDisplayFormat();if(this._checkStyle(p)){p=this._getLocaleBasedPattern(p);}return p;};
e.prototype._getBoundValueTypePattern=function(){var B=this.getBinding("value"),o=B&&B.getType&&B.getType();if(o instanceof S){return o.getOutputPattern();}if(o instanceof O&&o.oFormat){return o.oFormat.oFormatOptions.pattern;}return undefined;};
e.prototype._isValidDate=function(o){return o&&q.type(o)!=="date";};
e.prototype._updateDomPlaceholder=function(v){if(this.getDomRef()){this._$input.attr("placeholder",v);}};
return e;});
sap.ui.predefine('sap/m/DateTimeFieldRenderer',['sap/ui/core/Renderer','./InputBaseRenderer'],function(R,I){"use strict";var D=R.extend(I);return D;},true);
sap.ui.predefine('sap/m/DateTimeInput',['jquery.sap.global','sap/ui/core/Control','./library','./DatePicker','./DateTimePicker','./TimePicker','sap/ui/model/type/Date','sap/ui/model/type/Time','sap/ui/model/type/DateTime','sap/ui/model/odata/type/ODataType','sap/ui/core/library','sap/ui/Device',"./DateTimeInputRenderer"],function(q,C,l,D,a,T,b,c,d,O,e,f,g){"use strict";var h=l.DateTimeInputType;var j=e.TextDirection;var k=e.TextAlign;var V=e.ValueState;
var m=C.extend("sap.m.DateTimeInput",{metadata:{library:"sap.m",designtime:"sap/m/designtime/DateTimeInput.designtime",properties:{value:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},enabled:{type:"boolean",group:"Behavior",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:V.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},showValueStateMessage:{type:"boolean",group:"Misc",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:k.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:j.Inherit},type:{type:"sap.m.DateTimeInputType",group:"Data",defaultValue:h.Date},displayFormat:{type:"string",group:"Appearance",defaultValue:null},valueFormat:{type:"string",group:"Data",defaultValue:null},dateValue:{type:"object",group:"Data",defaultValue:null}},aggregations:{_picker:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"string"},dateValue:{type:"object"},valid:{type:"boolean"}}}}}});
!(function(P,$,i){var r=l.getLocaleData();q.extend(P,{_types:{Date:{valueFormat:r.getDatePattern("short"),displayFormat:r.getDatePattern("medium")},Time:{valueFormat:r.getTimePattern("short"),displayFormat:r.getTimePattern("short")},DateTime:{valueFormat:r.getDateTimePattern("short"),displayFormat:r.getDateTimePattern("short")}}});["Time","Date"].forEach(function(t,s){["valueFormat","displayFormat"].forEach(function(F){var u=P._types;u.DateTime[F]=u.DateTime[F].replace("{"+s+"}",u[t][F]);});});}(m.prototype,q,f));
m.prototype.init=function(){this.setType(h.Date);};
m.prototype.onBeforeRendering=function(){o.call(this);};
m.prototype.getFocusDomRef=function(){var P=_.call(this);return P.getFocusDomRef();};
m.prototype.getIdForLabel=function(){var P=_.call(this);return P.getIdForLabel();};
function n(t){var P;switch(t){case h.DateTime:P=new a(this.getId()+"-Picker");break;case h.Time:P=new T(this.getId()+"-Picker",{localeId:sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString()});break;default:P=new D(this.getId()+"-Picker");break;}P.setDisplayFormat(this.getDisplayFormat()||this._types[t].displayFormat);P.setValueFormat(this.getValueFormat()||this._types[t].valueFormat);if(this.getDateValue()){P.setDateValue(this.getDateValue());}P.setEnabled(this.getEnabled());P.setEditable(this.getEditable());P.setValueState(this.getValueState());P.setValueStateText(this.getValueStateText());P.setShowValueStateMessage(this.getShowValueStateMessage());P.setName(this.getName());P.setPlaceholder(this.getPlaceholder());P.setTextAlign(this.getTextAlign());P.setTextDirection(this.getTextDirection());P.setWidth("100%");P.attachChange(p,this);var A=this.getAriaLabelledBy();for(var i=0;i<A.length;i++){P.addAriaLabelledBy(A[i]);}return P;}
m.prototype.setType=function(t){if(t==this.getType()&&_.call(this)){return this;}this.destroyAggregation("_picker");var P=n.call(this,t);this.setAggregation("_picker",P);this.setProperty("type",t);return this;};
m.prototype.setWidth=function(w){this.setProperty("width",w);if(this.getDomRef()){w=this.getWidth();this.$().css("width",w);}return this;};
m.prototype.setValue=function(v){o.call(this);v=this.validateProperty("value",v);if(v.toLowerCase()=="now"){return this.setDateValue(new Date());}if(v===this.getValue()){return this;}this.setProperty("value",v,true);var P=_.call(this);P.setValue(v);var i=P.getDateValue();this.setProperty("dateValue",i,true);return this;};
m.prototype.setDateValue=function(i){if(this._isValidDate(i)){throw new Error("Date must be a JavaScript date object; "+this);}o.call(this);this.setProperty("dateValue",i,true);var P=_.call(this);P.setDateValue(i);var v=P.getValue();this.setProperty("value",v,true);return this;};
m.prototype.setDisplayFormat=function(s){this.setProperty("displayFormat",s,true);var P=_.call(this);P.setDisplayFormat(s||this._types[this.getType()].displayFormat);return this;};
m.prototype.setValueFormat=function(v){this.setProperty("valueFormat",v,true);var P=_.call(this);P.setValueFormat(v||this._types[this.getType()].ValueFormat);return this;};
m.prototype.setEnabled=function(E){this.setProperty("enabled",E,true);var P=_.call(this);P.setEnabled(E);return this;};
m.prototype.setEditable=function(E){this.setProperty("editable",E,true);var P=_.call(this);P.setEditable(E);return this;};
m.prototype.setValueState=function(v){this.setProperty("valueState",v,true);var P=_.call(this);P.setValueState(v);return this;};
m.prototype.setValueStateText=function(v){this.setProperty("valueStateText",v,true);var P=_.call(this);P.setValueStateText(v);return this;};
m.prototype.setShowValueStateMessage=function(s){this.setProperty("showValueStateMessage",s,true);var P=_.call(this);P.setShowValueStateMessage(s);return this;};
m.prototype.setName=function(N){this.setProperty("name",N,true);var P=_.call(this);P.setName(N);return this;};
m.prototype.setPlaceholder=function(P){this.setProperty("placeholder",P,true);var i=_.call(this);i.setPlaceholder(P);return this;};
m.prototype.setTextAlign=function(t){this.setProperty("textAlign",t,true);var P=_.call(this);P.setTextAlign(t);return this;};
m.prototype.setTextDirection=function(t){this.setProperty("textDirection",t,true);var P=_.call(this);P.setTextDirection(t);return this;};
m.prototype.addAriaLabelledBy=function(i){this.addAssociation("ariaLabelledBy",i,true);var P=_.call(this);P.addAriaLabelledBy(i);return this;};
m.prototype.removeAriaLabelledBy=function(i){this.removeAssociation("ariaLabelledBy",i,true);var P=_.call(this);P.removeAriaLabelledBy(i);return this;};
m.prototype.removeAllAriaLabelledBy=function(){this.removeAssociation("ariaLabelledBy",true);var P=_.call(this);P.removeAllAriaLabelledBy();return this;};
m.prototype.getAccessibilityInfo=function(){var P=_.call(this);return P&&P.getAccessibilityInfo?P.getAccessibilityInfo():null;};
m.prototype._getPickerByTypeAndPattern=function(t,i,r){var R=/[DdYyMLWwGQUur]/,s=/[HhKkmsa]/,u=s.test(r),v=R.test(r),w=u&&!v,x=v&&!u,y=v&&u,N,z;switch(t){case h.Time:case h.Date:case h.DateTime:if(w&&i.getMetadata().getName()!=="sap.m.TimePicker"){N=h.Time;}else if(x&&i.getMetadata().getName()!=="sap.m.DatePicker"){N=h.Date;}else if(y&&i.getMetadata().getName()!=="sap.m.DateTimePicker"){N=h.DateTime;}break;default:{throw"Invalid type: "+t+". Expected is one of the sap.m.DateTimeInputType";}}if(N){this.destroyAggregation("_picker");z=n.call(this,N);this.setAggregation("_picker",z);}return z||i;};
m.prototype._getBoundValueTypePattern=function(){var B=this.getBinding("value"),i=B&&B.getType()&&B.getType();if(i instanceof b||i instanceof c||i instanceof d){return i.getOutputPattern();}if(i instanceof O&&i.oFormat){return i.oFormat.oFormatOptions.pattern;}return undefined;};
function _(){return this.getAggregation("_picker");}
m.prototype._isValidDate=function(i){return i&&q.type(i)!=="date";};
function o(){if(this._getBoundValueTypePattern()){var P=this._getBoundValueTypePattern();var i=_.call(this);i=this._getPickerByTypeAndPattern(this.getType(),i,P);if(i.getValueFormat()!=P){i.setValueFormat(P);}if(i.getDisplayFormat()!=P){i.setDisplayFormat(P);}}}
function p(E){var v=E.getParameter("value");var i;var r=E.getParameter("valid");this.setProperty("value",v,true);if(r){i=E.oSource.getDateValue();this.setProperty("dateValue",i,true);}this.fireChange({value:v,newValue:v,valid:r,dateValue:i,newDateValue:i});}
return m;});
sap.ui.predefine('sap/m/DateTimeInputRenderer',[],function(){"use strict";var D={};
D.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapMDTI");var w=c.getWidth();if(w){r.addStyle("width",w);}r.writeStyles();r.writeClasses();r.write(">");var p=c.getAggregation("_picker");if(p){r.renderControl(p);}r.write("</div>");};
return D;},true);
sap.ui.predefine('sap/m/DateTimePicker',['jquery.sap.global','./InputBase','./DatePicker','sap/ui/model/type/Date','sap/ui/unified/DateRange','./library','sap/ui/core/Control','sap/ui/Device','sap/ui/core/format/DateFormat','sap/ui/core/LocaleData','./DateTimePickerRenderer','./TimePickerSliders',"sap/ui/events/KeyCodes","sap/ui/core/IconPool"],function(q,I,D,a,b,l,C,c,d,L,e,T,K,f){"use strict";var P=l.PlacementType;var S="Phone";
var g=D.extend("sap.m.DateTimePicker",{metadata:{library:"sap.m",properties:{minutesStep:{type:"int",group:"Misc",defaultValue:1},secondsStep:{type:"int",group:"Misc",defaultValue:1}},aggregations:{_popup:{type:"sap.m.ResponsivePopover",multiple:false,visibility:"hidden"}},designtime:"sap/m/designtime/DateTimePicker.designtime",dnd:{draggable:false,droppable:true}}});
var h=C.extend("sap.m.internal.DateTimePickerPopup",{
metadata:{library:"sap.m",aggregations:{_switcher:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},calendar:{type:"sap.ui.core.Control",multiple:false},timeSliders:{type:"sap.ui.core.Control",multiple:false}}},
renderer:function(r,i){r.write("<div");r.writeControlData(i);r.addClass("sapMDateTimePopupCont");r.addClass("sapMTimePickerDropDown");r.writeClasses();r.write(">");var s=i.getAggregation("_switcher");if(s){r.write("<div");r.addClass("sapMTimePickerSwitch");r.writeClasses();r.write(">");r.renderControl(s);r.write("</div>");}var j=i.getCalendar();if(j){r.renderControl(j);}r.write("<div");r.addClass("sapMTimePickerSep");r.writeClasses();r.write(">");r.write("</div>");var t=i.getTimeSliders();if(t){r.renderControl(t);}r.write("</div>");},
init:function(){},
onBeforeRendering:function(){var s=this.getAggregation("_switcher");if(!s){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var i=r.getText("DATETIMEPICKER_DATE");var t=r.getText("DATETIMEPICKER_TIME");s=new sap.m.SegmentedButton(this.getId()+"-Switch",{selectedKey:"Cal",items:[new sap.m.SegmentedButtonItem(this.getId()+"-Switch-Cal",{key:"Cal",text:i}),new sap.m.SegmentedButtonItem(this.getId()+"-Switch-Sli",{key:"Sli",text:t})]});s.attachSelect(this._handleSelect,this);this.setAggregation("_switcher",s,true);}if(c.system.phone||q('html').hasClass("sapUiMedia-Std-Phone")){s.setVisible(true);s.setSelectedKey("Cal");}else{s.setVisible(false);}},
onAfterRendering:function(){if(c.system.phone||q('html').hasClass("sapUiMedia-Std-Phone")){var s=this.getAggregation("_switcher");var i=s.getSelectedKey();this._switchVisibility(i);}},
_handleSelect:function(E){this._switchVisibility(E.getParameter("key"));},
_switchVisibility:function(s){var i=this.getCalendar();var j=this.getTimeSliders();if(!i||!j){return;}if(s=="Cal"){i.$().css("display","");j.$().css("display","none");}else{i.$().css("display","none");j.$().css("display","");j._updateSlidersValues();j._onOrientationChanged();j.openFirstSlider();}},
switchToTime:function(){var s=this.getAggregation("_switcher");if(s&&s.getVisible()){s.setSelectedKey("Sli");this._switchVisibility("Sli");}},
getSpecialDates:function(){return this._oDateTimePicker.getSpecialDates();}
});
g.prototype.init=function(){D.prototype.init.apply(this,arguments);this._bOnlyCalendar=false;};
g.prototype.getIconSrc=function(){return f.getIconURI("date-time");};
g.prototype.exit=function(){D.prototype.exit.apply(this,arguments);if(this._oSliders){this._oSliders.destroy();delete this._oSliders;}this._oPopupContent=undefined;c.media.detachHandler(this._handleWindowResize,this);};
g.prototype.setDisplayFormat=function(s){D.prototype.setDisplayFormat.apply(this,arguments);if(this._oSliders){this._oSliders.setDisplayFormat(o.call(this));}return this;};
g.prototype.setMinutesStep=function(M){this.setProperty('minutesStep',M,true);if(this._oSliders){this._oSliders.setMinutesStep(M);}return this;};
g.prototype.setMinDate=function(i){D.prototype.setMinDate.call(this,i);if(i){this._oMinDate.setHours(i.getHours(),i.getMinutes(),i.getSeconds());}return this;};
g.prototype.setMaxDate=function(i){D.prototype.setMaxDate.call(this,i);if(i){this._oMaxDate.setHours(i.getHours(),i.getMinutes(),i.getSeconds());}return this;};
g.prototype.setSecondsStep=function(s){this.setProperty('secondsStep',s,true);if(this._oSliders){this._oSliders.setSecondsStep(s);}return this;};
g.prototype._getFormatInstance=function(A,i){var M=q.extend({},A);var s=-1;if(M.style){s=M.style.indexOf("/");}if(i){var j=q.extend({},M);if(s>0){j.style=j.style.substr(0,s);}this._oDisplayFormatDate=d.getInstance(j);}return d.getDateTimeInstance(M);};
g.prototype._checkStyle=function(s){if(D.prototype._checkStyle.apply(this,arguments)){return true;}else if(s.indexOf("/")>0){var r=["short","medium","long","full"];var t=false;for(var i=0;i<r.length;i++){var u=r[i];for(var j=0;j<r.length;j++){var v=r[j];if(s==u+"/"+v){t=true;break;}}if(t){break;}}return t;}return false;};
g.prototype._parseValue=function(v,i){var j=D.prototype._parseValue.apply(this,arguments);if(i&&!j){j=this._oDisplayFormatDate.parse(v);if(j){var O=this.getDateValue();if(!O){O=new Date();}j.setHours(O.getHours());j.setMinutes(O.getMinutes());j.setSeconds(O.getSeconds());j.setMilliseconds(O.getMilliseconds());}}return j;};
g.prototype._getLocaleBasedPattern=function(s){var i=L.getInstance(sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale()),j=s.indexOf("/");if(j>0){return i.getCombinedDateTimePattern(s.substr(0,j),s.substr(j+1));}else{return i.getCombinedDateTimePattern(s,s);}};
g.prototype._createPopup=function(){if(!this._oPopup){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var O=r.getText("TIMEPICKER_SET");var s=r.getText("TIMEPICKER_CANCEL");this._oPopupContent=new h(this.getId()+"-PC");this._oPopupContent._oDateTimePicker=this;this._oPopup=new sap.m.ResponsivePopover(this.getId()+"-RP",{showCloseButton:false,showHeader:false,placement:P.VerticalPreferedBottom,beginButton:new sap.m.Button(this.getId()+"-OK",{text:O,press:q.proxy(_,this)}),endButton:new sap.m.Button(this.getId()+"-Cancel",{text:s,press:q.proxy(k,this)}),content:this._oPopupContent});this._oPopup.addStyleClass("sapMDateTimePopup");var i=this._oPopup.getAggregation("_popup");if(i.setShowArrow){i.setShowArrow(false);}this._oPopup.attachAfterOpen(m,this);this._oPopup.attachAfterClose(n,this);if(c.system.desktop){this._oPopoverKeydownEventDelegate={onkeydown:function(E){var j=K,t=E.which||E.keyCode,A=E.altKey;if((A&&(t===j.ARROW_UP||t===j.ARROW_DOWN))||t===j.F4){_.call(this,E);this.focus();E.preventDefault();}}};this._oPopup.addEventDelegate(this._oPopoverKeydownEventDelegate,this);}this.setAggregation("_popup",this._oPopup,true);}};
g.prototype._openPopup=function(){if(!this._oPopup){return;}this.addStyleClass(I.ICON_PRESSED_CSS_CLASS);this._storeInputSelection(this._$input.get(0));var i=this._oPopup.getAggregation("_popup");i.oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.openBy(this);var s=this._oPopup.getContent()[0]&&this._oPopup.getContent()[0].getTimeSliders();if(s){setTimeout(s._updateSlidersValues.bind(s),0);}};
g.prototype._createPopupContent=function(){var N=!this._oCalendar;D.prototype._createPopupContent.apply(this,arguments);if(N){this._oPopupContent.setCalendar(this._oCalendar);this._oCalendar.attachSelect(p,this);var t=this,H=this._oCalendar._hideMonthPicker,i=this._oCalendar._hideYearPicker;this._oCalendar._hideMonthPicker=function(s){H.apply(this,arguments);if(!s){t._selectFocusedDateValue(new b().setStartDate(this._getFocusedDate().toLocalJSDate()));}};this._oCalendar._hideYearPicker=function(s){i.apply(this,arguments);if(!s){t._selectFocusedDateValue(new b().setStartDate(this._getFocusedDate().toLocalJSDate()));}};}if(!this._oSliders){this._oSliders=new T(this.getId()+"-Sliders",{minutesStep:this.getMinutesStep(),secondsStep:this.getSecondsStep(),displayFormat:o.call(this),localeId:this.getLocaleId()})._setShouldOpenSliderAfterRendering(true);this._oPopupContent.setTimeSliders(this._oSliders);}};
g.prototype._selectFocusedDateValue=function(i){var j=this._oCalendar;j.removeAllSelectedDates();j.addSelectedDate(i);return this;};
g.prototype._fillDateRange=function(){var i=this.getDateValue();if(i){i=new Date(i.getTime());}else{i=this._getInitialFocusedDateValue();var M=this._oMaxDate.getTime();if(i.getTime()<this._oMinDate.getTime()||i.getTime()>M){i=this._oMinDate;}}this._oCalendar.focusDate(i);if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=i.getTime()){this._oDateRange.setStartDate(i);}this._oSliders._setTimeValues(i);};
g.prototype._getSelectedDate=function(){var i=D.prototype._getSelectedDate.apply(this,arguments);if(i){var j=this._oSliders.getTimeValues();var s=this._oSliders._getDisplayFormatPattern();if(s.search("h")>=0||s.search("H")>=0){i.setHours(j.getHours());}if(s.search("m")>=0){i.setMinutes(j.getMinutes());}if(s.search("s")>=0){i.setSeconds(j.getSeconds());}if(i.getTime()<this._oMinDate.getTime()){i=new Date(this._oMinDate.getTime());}else if(i.getTime()>this._oMaxDate.getTime()){i=new Date(this._oMaxDate.getTime());}}return i;};
g.prototype._getInitialFocusedDateValue=function(){return this.getInitialFocusedDateValue()||new Date();};
g.prototype.getLocaleId=function(){return sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();};
g.prototype.getAccessibilityInfo=function(){var i=D.prototype.getAccessibilityInfo.apply(this,arguments);i.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_DATETIMEINPUT");return i;};
function _(E){this._selectDate();}
function k(E){this.onsaphide(E);this._oCalendar.removeAllSelectedDates();this._oCalendar.addSelectedDate(new b().setStartDate(this._getInitialFocusedDateValue()));}
g.prototype._handleWindowResize=function(i){var s=this.getAggregation("_popup").getContent()[0].getAggregation("_switcher"),j=this.getAggregation("_popup").getContent()[0].getCalendar(),r=this.getAggregation("_popup").getContent()[0].getTimeSliders();if(i.name===S){s.setVisible(true);this.getAggregation("_popup").getContent()[0]._switchVisibility(s.getSelectedKey());}else{s.setVisible(false);r.$().css("display","");j.$().css("display","");}};
function m(E){this.$("inner").attr("aria-expanded",true);this._oCalendar.focus();this._oSliders._onOrientationChanged();c.media.attachHandler(this._handleWindowResize,this);}
function n(){this.removeStyleClass(I.ICON_PRESSED_CSS_CLASS);this.$("inner").attr("aria-expanded",false);this._restoreInputSelection(this._$input.get(0));c.media.detachHandler(this._handleWindowResize,this);}
function o(){var s=this.getDisplayFormat();var t;var B=this.getBinding("value");if(B&&B.oType&&(B.oType instanceof a)){s=B.oType.getOutputPattern();}else if(B&&B.oType&&B.oType.oFormat){s=B.oType.oFormat.oFormatOptions.pattern;}else{s=this.getDisplayFormat();}if(!s){s="medium";}var i=s.indexOf("/");if(i>0&&this._checkStyle(s)){s=s.substr(i+1);}if(s=="short"||s=="medium"||s=="long"||s=="full"){var j=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var r=L.getInstance(j);t=r.getTimePattern(s);}else{t=s;}return t;}
function p(E){this._oPopupContent.switchToTime();}
return g;});
sap.ui.predefine('sap/m/DateTimePickerRenderer',['sap/ui/core/Renderer','./DatePickerRenderer','./InputBaseRenderer'],function(R,D,I){"use strict";var a=R.extend(D);
a.getDescribedByAnnouncement=function(d){var b=I.getDescribedByAnnouncement.apply(this,arguments);return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("DATETIMEPICKER_TYPE")+" "+b;};
return a;},true);
sap.ui.predefine('sap/m/Dialog',['./Bar','./InstanceManager','./AssociativeOverflowToolbar','./ToolbarSpacer','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/Popup','sap/ui/core/delegate/ScrollEnablement','sap/ui/core/RenderManager','sap/ui/core/InvisibleText','sap/ui/core/ResizeHandler','sap/ui/Device','sap/ui/base/ManagedObject','sap/ui/core/library','./TitlePropagationSupport','./DialogRenderer',"sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/core/Core","sap/ui/core/Configuration","sap/ui/dom/jquery/control","sap/ui/dom/jquery/Focusable"],function(B,I,A,T,l,C,a,P,S,R,b,c,D,M,d,f,g,L,q,h,j){"use strict";var O=d.OpenState;var k=l.DialogType;var V=d.ValueState;var s=h.getConfiguration().getAnimationMode();var u=s!==j.AnimationMode.none&&s!==j.AnimationMode.minimal;var m=u?300:10;
var n=C.extend("sap.m.Dialog",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.m",properties:{icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},title:{type:"string",group:"Appearance",defaultValue:null},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},type:{type:"sap.m.DialogType",group:"Appearance",defaultValue:k.Standard},state:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:V.None},stretchOnPhone:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},stretch:{type:"boolean",group:"Appearance",defaultValue:false},contentWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},contentHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},horizontalScrolling:{type:"boolean",group:"Behavior",defaultValue:true},verticalScrolling:{type:"boolean",group:"Behavior",defaultValue:true},resizable:{type:"boolean",group:"Behavior",defaultValue:false},draggable:{type:"boolean",group:"Behavior",defaultValue:false},escapeHandler:{type:"any",group:"Behavior",defaultValue:null}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},subHeader:{type:"sap.m.IBar",multiple:false},customHeader:{type:"sap.m.IBar",multiple:false},beginButton:{type:"sap.m.Button",multiple:false},endButton:{type:"sap.m.Button",multiple:false},buttons:{type:"sap.m.Button",multiple:true,singularName:"button"},_header:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_title:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_icon:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_toolbar:{type:"sap.m.OverflowToolbar",multiple:false,visibility:"hidden"},_valueState:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},associations:{leftButton:{type:"sap.m.Button",multiple:false,deprecated:true},rightButton:{type:"sap.m.Button",multiple:false,deprecated:true},initialFocus:{type:"sap.ui.core.Control",multiple:false},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{beforeOpen:{},afterOpen:{},beforeClose:{parameters:{origin:{type:"sap.m.Button"}}},afterClose:{parameters:{origin:{type:"sap.m.Button"}}}},designtime:"sap/m/designtime/Dialog.designtime"}});
f.call(n.prototype,"content",function(){return this._headerTitle?this._headerTitle.getId():false;});n._bPaddingByDefault=(sap.ui.getCore().getConfiguration().getCompatibilityVersion("sapMDialogWithPadding").compareTo("1.16")<0);n._mIcons={};n._mIcons[V.Success]=a.getIconURI("message-success");n._mIcons[V.Warning]=a.getIconURI("message-warning");n._mIcons[V.Error]=a.getIconURI("message-error");n._mIcons[V.Information]=a.getIconURI("hint");
n.prototype.init=function(){var t=this;this._externalIcon=undefined;this._oManuallySetSize=null;this._oManuallySetPosition=null;this._bRTL=sap.ui.getCore().getConfiguration().getRTL();this._scrollContentList=["sap.m.NavContainer","sap.m.Page","sap.m.ScrollContainer","sap.m.SplitContainer","sap.m.MultiInput"];this.oPopup=new P();this.oPopup.setShadow(true);this.oPopup.setNavigationMode("SCOPE");if(D.os.ios&&D.system.phone&&!this._bMessageType){this.oPopup.setModal(true,"sapMDialogTransparentBlk");}else{this.oPopup.setModal(true,"sapMDialogBlockLayerInit");}this.oPopup.setAnimations(q.proxy(this._openAnimation,this),q.proxy(this._closeAnimation,this));this.oPopup._applyPosition=function(p,F){var e;var i;t._setDimensions();t._adjustScrollingPane();p.at={};if(t._oManuallySetPosition){p.at.left=t._oManuallySetPosition.x;p.at.top=t._oManuallySetPosition.y;}else{if(window.scrollY===undefined){e=window.pageYOffset;}else{e=window.scrollY;}if(D.os.ios||e<0){e=0;}p.at.top='calc(50% + '+e+'px)';if(t._bRTL){p.at.left='auto';}else{if(window.scrollX===undefined){i=window.pageXOffset;}else{i=window.scrollX;}if(D.os.ios||i<0){i=0;}p.at.left='calc(50% + '+i+'px)';}}t._deregisterContentResizeHandler();P.prototype._applyPosition.call(this,p);t._registerContentResizeHandler();};if(n._bPaddingByDefault){this.addStyleClass("sapUiPopupWithPadding");}this._initTitlePropagationSupport();};
n.prototype.onBeforeRendering=function(){if(this._hasSingleScrollableContent()){this.setProperty("verticalScrolling",false);this.setProperty("horizontalScrolling",false);L.info("VerticalScrolling and horizontalScrolling in sap.m.Dialog with ID "+this.getId()+" has been disabled because there's scrollable content inside");}else if(!this._oScroller){this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:this.getHorizontalScrolling(),vertical:this.getVerticalScrolling()});}this._createToolbarButtons();if(sap.ui.getCore().getConfiguration().getAccessibility()&&this.getState()!=V.None){var v=new b({text:this.getValueStateString(this.getState())});this.setAggregation("_valueState",v);this.addAriaLabelledBy(v.getId());}};
n.prototype.onAfterRendering=function(){this._$scrollPane=this.$("scroll");this._$content=this.$("cont");this._$dialog=this.$();if(this.isOpen()){this._setInitialFocus();}if(this.getType()===k.Message){this.$("footer").removeClass("sapContrast sapContrastPlus");}};
n.prototype.exit=function(){I.removeDialogInstance(this);this._deregisterContentResizeHandler();this._deregisterResizeHandler();if(this.oPopup){this.oPopup.detachOpened(this._handleOpened,this);this.oPopup.detachClosed(this._handleClosed,this);this.oPopup.destroy();this.oPopup=null;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._header){this._header.destroy();this._header=null;}if(this._headerTitle){this._headerTitle.destroy();this._headerTitle=null;}if(this._iconImage){this._iconImage.destroy();this._iconImage=null;}if(this._toolbarSpacer){this._toolbarSpacer.destroy();this._toolbarSpacer=null;}};
n.prototype.open=function(){var p=this.oPopup;p.setInitialFocusId(this.getId());var e=p.getOpenState();switch(e){case O.OPEN:case O.OPENING:return this;case O.CLOSING:this._bOpenAfterClose=true;break;default:}this._oCloseTrigger=null;this.fireBeforeOpen();p.attachOpened(this._handleOpened,this);this._iLastWidthAndHeightWithScroll=null;p.setContent(this);p.open();this._registerResizeHandler();I.addDialogInstance(this);return this;};
n.prototype.close=function(){this._bOpenAfterClose=false;this.$().removeClass('sapDialogDisableTransition');this._deregisterResizeHandler();var p=this.oPopup;var e=this.oPopup.getOpenState();if(!(e===O.CLOSED||e===O.CLOSING)){l.closeKeyboard();this.fireBeforeClose({origin:this._oCloseTrigger});p.attachClosed(this._handleClosed,this);this._bDisableRepositioning=false;this._oManuallySetPosition=null;this._oManuallySetSize=null;p.close();this._deregisterContentResizeHandler();}return this;};
n.prototype.isOpen=function(){return this.oPopup&&this.oPopup.isOpen();};
n.prototype._handleOpened=function(){this.oPopup.detachOpened(this._handleOpened,this);this._setInitialFocus();this.fireAfterOpen();};
n.prototype._handleClosed=function(){if(!this.oPopup){return;}this.oPopup.detachClosed(this._handleClosed,this);if(this.getDomRef()){R.preserveContent(this.getDomRef());this.$().remove();}I.removeDialogInstance(this);this.fireAfterClose({origin:this._oCloseTrigger});if(this._bOpenAfterClose){this._bOpenAfterClose=false;this.open();}};
n.prototype.onfocusin=function(e){var i=e.target;if(i.id===this.getId()+"-firstfe"){var p=this.$("footer").lastFocusableDomRef()||this.$("cont").lastFocusableDomRef()||(this.getSubHeader()&&this.getSubHeader().$().firstFocusableDomRef())||(this._getAnyHeader()&&this._getAnyHeader().$().lastFocusableDomRef());if(p){p.focus();}}else if(i.id===this.getId()+"-lastfe"){var F=(this._getAnyHeader()&&this._getAnyHeader().$().firstFocusableDomRef())||(this.getSubHeader()&&this.getSubHeader().$().firstFocusableDomRef())||this.$("cont").firstFocusableDomRef()||this.$("footer").firstFocusableDomRef();if(F){F.focus();}}};
n.prototype._getPromiseWrapper=function(){var t=this;return{reject:function(){t.currentPromise.reject();},resolve:function(){t.currentPromise.resolve();}};};
n.prototype.onsapescape=function(e){var E=this.getEscapeHandler(),p={},t=this;if(e.originalEvent&&e.originalEvent._sapui_handledByControl){return;}this._oCloseTrigger=null;if(typeof E==='function'){new window.Promise(function(r,i){p.resolve=r;p.reject=i;t.currentPromise=p;E(t._getPromiseWrapper());}).then(function(r){t.close();}).catch(function(){L.info("Disallow dialog closing");});}else{this.close();}e.stopPropagation();};
n.prototype._openAnimation=function(r,i,e){r.addClass("sapMDialogOpen");r.css("display","block");setTimeout(e,m);};
n.prototype._closeAnimation=function(r,i,e){r.removeClass("sapMDialogOpen");setTimeout(e,m);};
n.prototype._setDimensions=function(){var $=this.$(),e=this.getStretch(),i=this.getStretchOnPhone()&&D.system.phone,p=this._bMessageType,r={};if(!e){if(!this._oManuallySetSize){r.width=this.getContentWidth()||undefined;r.height=this.getContentHeight()||undefined;}else{r.width=this._oManuallySetSize.width;r.height=this._oManuallySetSize.height;}}if(r.width=='auto'){r.width=undefined;}if(r.height=='auto'){r.height=undefined;}if((e&&!p)||(i)){this.$().addClass('sapMDialogStretched');}$.css(r);if(!e&&!this._oManuallySetSize&&!this._bDisableRepositioning){this._applyCustomTranslate();}if(window.navigator.userAgent.toLowerCase().indexOf("chrome")!==-1&&this.getStretch()){$.find('> footer').css({bottom:'0.001px'});}};
n.prototype._adjustScrollingPane=function(){if(this._oScroller){this._oScroller.refresh();}};
n.prototype._reposition=function(){};
n.prototype._repositionAfterOpen=function(){};
n.prototype._reapplyPosition=function(){this._adjustScrollingPane();};
n.prototype._onResize=function(){var $=this.$(),e=this.$('cont'),i=e[0].clientWidth,p,r=this.getContentHeight(),t=this.getContentWidth(),v,w=Math.floor(window.innerWidth*0.9),x=2,y=D.browser,z=0;if(this._oManuallySetSize){e.css({width:'auto'});return;}if(!r||r=='auto'){p=e.scrollTop();e.css({height:'auto'});$.children().each(function(){z+=q(this).outerHeight(true);});if(this.getStretch()||z>$.innerHeight()){v=parseFloat($.height())+x;e.height(Math.round(v));}e.scrollTop(p);}if(D.system.desktop&&!y.chrome){var E=Math.ceil(e.outerWidth()-i),F=e.width()+"x"+e.height();if(F!==this._iLastWidthAndHeightWithScroll){if(E>0&&(!t||t=='auto')&&!this.getStretch()&&e.width()<w){$.addClass("sapMDialogVerticalScrollIncluded");e.css({"padding-right":E});this._iLastWidthAndHeightWithScroll=F;}else{$.removeClass("sapMDialogVerticalScrollIncluded");e.css({"padding-right":""});this._iLastWidthAndHeightWithScroll=null;}}}if(!this.getStretch()&&!this._oManuallySetSize&&!this._bDisableRepositioning){this._applyCustomTranslate();}};
n.prototype._applyCustomTranslate=function(){var $=this.$(),t,e,i=$.innerWidth(),p=$.innerHeight();if(D.system.desktop&&(i%2!==0||p%2!==0)){if(!this._bRTL){t='-'+Math.floor(i/2)+"px";}else{t=Math.floor(i/2)+"px";}e='-'+Math.floor(p/2)+"px";var r='translate('+t+','+e+') scale(1) ';$.css('transform',r);$.css('-webkit-transform',r+' translateZ(0px)');}else{$.css('transform','');$.css('-webkit-transform','');}};
n.prototype._createHeader=function(){if(!this._header){this._header=new B(this.getId()+"-header");this._header._setRootAccessibilityRole("heading");this.setAggregation("_header",this._header,false);}};
n.prototype._hasSingleScrollableContent=function(){var e=this.getContent();while(e.length===1&&e[0]instanceof C&&e[0].isA("sap.ui.core.mvc.View")){e=e[0].getContent();}if(e.length===1&&e[0]instanceof C&&e[0].isA(this._scrollContentList)){return true;}return false;};
n.prototype._initBlockLayerAnimation=function(){this.oPopup._hideBlockLayer=function(){var $=q("#sap-ui-blocklayer-popup");$.removeClass("sapMDialogTransparentBlk");P.prototype._hideBlockLayer.call(this);};};
n.prototype._clearBlockLayerAnimation=function(){if(D.os.ios&&D.system.phone&&!this._bMessageType){delete this.oPopup._showBlockLayer;this.oPopup._hideBlockLayer=function(){var $=q("#sap-ui-blocklayer-popup");$.removeClass("sapMDialogTransparentBlk");P.prototype._hideBlockLayer.call(this);};}};
n.prototype._getFocusId=function(){return this.getInitialFocus()||this._getFirstFocusableContentSubHeader()||this._getFirstFocusableContentElementId()||this._getFirstVisibleButtonId()||this.getId();};
n.prototype._getFirstVisibleButtonId=function(){var e=this.getBeginButton(),E=this.getEndButton(),p=this.getButtons(),r="";if(e&&e.getVisible()){r=e.getId();}else if(E&&E.getVisible()){r=E.getId();}else if(p&&p.length>0){for(var i=0;i<p.length;i++){if(p[i].getVisible()){r=p[i].getId();break;}}}return r;};
n.prototype._getFirstFocusableContentSubHeader=function(){var $=this.$().find('.sapMDialogSubHeader');var r;var F=$.firstFocusableDomRef();if(F){r=F.id;}return r;};
n.prototype._getFirstFocusableContentElementId=function(){var r="";var $=this.$("cont");var F=$.firstFocusableDomRef();if(F){r=F.id;}return r;};
n.prototype._setInitialFocus=function(){var F=this._getFocusId();var e=sap.ui.getCore().byId(F);var i;if(e){if(e.getVisible&&!e.getVisible()){this.focus();return;}i=e.getFocusDomRef();}i=i||((F?window.document.getElementById(F):null));if(!i){this.setInitialFocus("");i=sap.ui.getCore().byId(this._getFocusId());}if(!this.getInitialFocus()){this.setAssociation('initialFocus',i?i.id:this.getId(),true);}if(D.system.desktop||(i&&!/input|textarea|select/i.test(i.tagName))){if(i){i.focus();}}else{this.focus();}};
n.prototype.getScrollDelegate=function(){return this._oScroller;};
n.prototype._composeAggreNameInHeader=function(p){var H;if(p==="Begin"){H="contentLeft";}else if(p==="End"){H="contentRight";}else{H="content"+p;}return H;};
n.prototype._isToolbarEmpty=function(){var e=this._oToolbar.getContent().filter(function(i){return i.getMetadata().getName()!=='sap.m.ToolbarSpacer';});return e.length===0;};
n.prototype._setButton=function(e,p,i){return this;};
n.prototype._getButton=function(p){var e=p.toLowerCase()+"Button",i="_o"+this._firstLetterUpperCase(p)+"Button";if(D.system.phone){return this.getAggregation(e,null,true);}else{return this[i];}};
n.prototype._getButtonFromHeader=function(p){if(this._header){var H=this._composeAggreNameInHeader(this._firstLetterUpperCase(p)),e=this._header.getAggregation(H);return e&&e[0];}else{return null;}};
n.prototype._firstLetterUpperCase=function(v){return v.charAt(0).toUpperCase()+v.slice(1);};
n.prototype._getAnyHeader=function(){var e=this.getCustomHeader();if(e){return e._setRootAccessibilityRole("heading");}else{var i=this.getShowHeader();if(!i){return null;}this._createHeader();return this._header;}};
n.prototype._deregisterResizeHandler=function(){if(this._resizeListenerId){c.deregister(this._resizeListenerId);this._resizeListenerId=null;}D.resize.detachHandler(this._onResize,this);};
n.prototype._registerResizeHandler=function(){var _=this.$("scroll");this._resizeListenerId=c.register(_.get(0),q.proxy(this._onResize,this));D.resize.attachHandler(this._onResize,this);this._onResize();};
n.prototype._deregisterContentResizeHandler=function(){if(this._sContentResizeListenerId){c.deregister(this._sContentResizeListenerId);this._sContentResizeListenerId=null;}};
n.prototype._registerContentResizeHandler=function(){if(!this._sContentResizeListenerId){this._sContentResizeListenerId=c.register(this.getDomRef("scrollCont"),q.proxy(this._onResize,this));}this._onResize();};
n.prototype._attachHandler=function(e){var t=this;if(!this._oButtonDelegate){this._oButtonDelegate={ontap:function(){t._oCloseTrigger=this;},onkeyup:function(){t._oCloseTrigger=this;},onkeydown:function(){t._oCloseTrigger=this;}};}if(e){e.addDelegate(this._oButtonDelegate,true,e);}};
n.prototype._createToolbarButtons=function(){var t=this._getToolbar();var e=this.getButtons();var i=this.getBeginButton();var p=this.getEndButton(),r=this,v=[i,p];v.forEach(function(w){if(w&&r._oButtonDelegate){w.removeDelegate(r._oButtonDelegate);}});t.removeAllContent();if(!("_toolbarSpacer"in this)){this._toolbarSpacer=new T();}t.addContent(this._toolbarSpacer);v.forEach(function(w){r._attachHandler(w);});if(e&&e.length){e.forEach(function(w){t.addContent(w);});}else{if(i){t.addContent(i);}if(p){t.addContent(p);}}};
n.prototype._getToolbar=function(){if(!this._oToolbar){this._oToolbar=new A(this.getId()+"-footer").addStyleClass("sapMTBNoBorders");this.setAggregation("_toolbar",this._oToolbar);}return this._oToolbar;};
n.prototype.getValueStateString=function(v){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");switch(v){case(V.Success):return r.getText("LIST_ITEM_STATE_SUCCESS");case(V.Warning):return r.getText("LIST_ITEM_STATE_WARNING");case(V.Error):return r.getText("LIST_ITEM_STATE_ERROR");case(V.Information):return r.getText("LIST_ITEM_STATE_INFORMATION");default:return"";}};
n.prototype.setSubHeader=function(e){this.setAggregation("subHeader",e);if(e){e.setVisible=function(i){this.$().toggleClass('sapMDialogWithSubHeader',i);e.setProperty("visible",i);}.bind(this);}return this;};
n.prototype.setLeftButton=function(v){if(typeof v==="string"){v=sap.ui.getCore().byId(v);}this.setBeginButton(v);return this.setAssociation("leftButton",v);};
n.prototype.setRightButton=function(v){if(typeof v==="string"){v=sap.ui.getCore().byId(v);}this.setEndButton(v);return this.setAssociation("rightButton",v);};
n.prototype.getLeftButton=function(){var e=this.getBeginButton();return e?e.getId():null;};
n.prototype.getRightButton=function(){var e=this.getEndButton();return e?e.getId():null;};
n.prototype.setBeginButton=function(e){var t=h.getConfiguration().getTheme();if(e&&e.isA("sap.m.Button")&&t.startsWith("sap_fiori_")){e.setType("Emphasized");e.addStyleClass("sapMDialogBeginButton");}return this.setAggregation("beginButton",e);};
n.prototype.setEndButton=function(e){var t=h.getConfiguration().getTheme();if(e&&e.isA("sap.m.Button")&&t.startsWith("sap_fiori_")){e.setType("Transparent");e.addStyleClass("sapMDialogEndButton");}return this.setAggregation("endButton",e);};
n.prototype.getAggregation=function(e,i,p){var r=C.prototype.getAggregation.apply(this,Array.prototype.slice.call(arguments,0,2));if(e==='buttons'&&r.length===0){this.getBeginButton()&&r.push(this.getBeginButton());this.getEndButton()&&r.push(this.getEndButton());}return r;};
n.prototype.getAriaLabelledBy=function(){var e=this._getAnyHeader(),i=this.getAssociation("ariaLabelledBy",[]).slice();var p=this.getSubHeader();if(p){i.unshift(p.getId());}if(e){var t=e.findAggregatedObjects(true,function(r){return r.isA("sap.m.Title");});if(t.length){i=t.map(function(r){return r.getId();}).concat(i);}else{i.unshift(e.getId());}}return i;};
n.prototype.setTitle=function(t){this.setProperty("title",t,true);if(this._headerTitle){this._headerTitle.setText(t);}else{this._headerTitle=new sap.m.Title(this.getId()+"-title",{text:t,level:"H2"}).addStyleClass("sapMDialogTitle");this._createHeader();this._header.addContentMiddle(this._headerTitle);}return this;};
n.prototype.setState=function(e){var F={},$=this.$(),N;F[e]=true;this.setProperty("state",e,true);for(N in g._mStateClasses){$.toggleClass(g._mStateClasses[N],!!F[N]);}this.setIcon(n._mIcons[e],true);return this;};
n.prototype.setIcon=function(i,e){if(!e){this._externalIcon=i;}else{if(this._externalIcon){i=this._externalIcon;}}if(i){if(i!==this.getIcon()){if(this._iconImage){this._iconImage.setSrc(i);}else{this._iconImage=a.createControlByURI({id:this.getId()+"-icon",src:i,useIconTooltip:false},sap.m.Image).addStyleClass("sapMDialogIcon");this._createHeader();this._header.insertAggregation("contentMiddle",this._iconImage,0);}}}else{var p=this.getState();if(!e&&p!==V.None){if(this._iconImage){this._iconImage.setSrc(n._mIcons[p]);}}else{if(this._iconImage){this._iconImage.destroy();this._iconImage=null;}}}this.setProperty("icon",i,true);return this;};
n.prototype.setType=function(t){var e=this.getType();if(e===t){return this;}this._bMessageType=(t===k.Message);return this.setProperty("type",t,false);};
n.prototype.setStretch=function(e){this._bStretchSet=true;return this.setProperty("stretch",e);};
n.prototype.setStretchOnPhone=function(e){if(this._bStretchSet){L.warning("sap.m.Dialog: stretchOnPhone property is deprecated. Setting stretchOnPhone property is ignored when there's already stretch property set.");return this;}this.setProperty("stretchOnPhone",e);return this.setProperty("stretch",e&&D.system.phone);};
n.prototype.setVerticalScrolling=function(v){var e=this.getVerticalScrolling(),H=this._hasSingleScrollableContent();if(H){L.warning("sap.m.Dialog: property verticalScrolling automatically reset to false. See documentation.");v=false;}if(e===v){return this;}this.$().toggleClass("sapMDialogVerScrollDisabled",!v);this.setProperty("verticalScrolling",v);if(this._oScroller){this._oScroller.setVertical(v);}return this;};
n.prototype.setHorizontalScrolling=function(v){var e=this.getHorizontalScrolling(),H=this._hasSingleScrollableContent();if(H){L.warning("sap.m.Dialog: property horizontalScrolling automatically reset to false. See documentation.");v=false;}if(e===v){return this;}this.$().toggleClass("sapMDialogHorScrollDisabled",!v);this.setProperty("horizontalScrolling",v);if(this._oScroller){this._oScroller.setHorizontal(v);}return this;};
n.prototype.setInitialFocus=function(i){return this.setAssociation("initialFocus",i,true);};
n.prototype.forceInvalidate=C.prototype.invalidate;
n.prototype.invalidate=function(e){if(this.isOpen()){this.forceInvalidate(e);}};
function o(e){var $=q(e);var i=$.control(0);if(!i||i.getMetadata().getInterfaces().indexOf("sap.m.IBar")>-1){return true;}return $.hasClass('sapMDialogTitle');}
if(D.system.desktop){n.prototype.ondblclick=function(e){if(o(e.target)){var $=this.$('cont');this._bDisableRepositioning=false;this._oManuallySetPosition=null;this._oManuallySetSize=null;this.oPopup&&this.oPopup._applyPosition(this.oPopup._oLastPosition,true);this._$dialog.removeClass('sapMDialogTouched');$.css({height:'100%'});}};n.prototype.onmousedown=function(e){if(e.which===3){return;}if(this.getStretch()||(!this.getDraggable()&&!this.getResizable())){return;}var t;var i=this;var $=q(document);var p=q(e.target);var r=p.hasClass('sapMDialogResizeHandler')&&this.getResizable();var v=function(K){t=t?clearTimeout(t):setTimeout(function(){K();},0);};var w=window.innerWidth;var x=window.innerHeight;var y={x:e.pageX,y:e.pageY,width:i._$dialog.width(),height:i._$dialog.height(),outerHeight:i._$dialog.outerHeight(),offset:{x:e.offsetX?e.offsetX:e.originalEvent.layerX,y:e.offsetY?e.offsetY:e.originalEvent.layerY},position:{x:i._$dialog.offset().left,y:i._$dialog.offset().top}};function z(){var K=i.$(),N=i.$('cont'),Q,U;$.off("mouseup mousemove");if(r){i._$dialog.removeClass('sapMDialogResizing');Q=parseInt(K[0].style.height)||parseInt(K.height());U=parseInt(K.css("border-top-width"))+parseInt(K.css("border-bottom-width"));N.height(Q+U);}}if((o(e.target)&&this.getDraggable())||r){i._bDisableRepositioning=true;i._$dialog.addClass('sapDialogDisableTransition');i._$dialog.addClass('sapMDialogTouched');i._oManuallySetPosition={x:y.position.x,y:y.position.y};i._$dialog.css({left:Math.min(Math.max(0,i._oManuallySetPosition.x),w-y.width),top:Math.min(Math.max(0,i._oManuallySetPosition.y),x-y.height),width:y.width,height:y.height,transform:""});}if(o(e.target)&&this.getDraggable()){$.on("mousemove",function(K){if(K.buttons===0){z();return;}v(function(){i._bDisableRepositioning=true;i._oManuallySetPosition={x:K.pageX-e.pageX+y.position.x,y:K.pageY-e.pageY+y.position.y};i._$dialog.css({left:Math.min(Math.max(0,i._oManuallySetPosition.x),w-y.width),top:Math.min(Math.max(0,i._oManuallySetPosition.y),x-y.outerHeight),transform:""});});});}else if(r){i._$dialog.addClass('sapMDialogResizing');var E={};var F=parseInt(i._$dialog.css('min-width'));var G=y.x+y.width-F;var H=p.width()-e.offsetX;var J=p.height()-e.offsetY;$.on("mousemove",function(K){v(function(){i._bDisableRepositioning=true;i.$('cont').height('').width('');if(K.pageY+J>x){K.pageY=x-J;}if(K.pageX+H>w){K.pageX=w-H;}i._oManuallySetSize={width:y.width+K.pageX-y.x,height:y.height+K.pageY-y.y};if(i._bRTL){E.left=Math.min(Math.max(K.pageX,0),G);E.transform="";i._oManuallySetSize.width=y.width+y.x-Math.max(K.pageX,0);}E.width=i._oManuallySetSize.width;E.height=i._oManuallySetSize.height;i._$dialog.css(E);});});}else{return;}$.on("mouseup",z);e.preventDefault();e.stopPropagation();};}
n.prototype._applyContextualSettings=function(){M.prototype._applyContextualSettings.call(this,M._defaultContextualSettings);};
return n;});
sap.ui.predefine('sap/m/DialogRenderer',["sap/m/library","sap/ui/Device","sap/ui/core/library"],function(l,D,c){"use strict";var a=l.DialogType;var V=c.ValueState;var b={};b._mStateClasses={};b._mStateClasses[V.None]="";b._mStateClasses[V.Success]="sapMDialogSuccess";b._mStateClasses[V.Warning]="sapMDialogWarning";b._mStateClasses[V.Error]="sapMDialogError";b._mStateClasses[V.Information]="sapMDialogInformation";
b.render=function(r,C){var d=C.getId(),t=C.getType(),h=C._getAnyHeader(),s=C.getSubHeader(),m=(t===a.Message),L=C.getBeginButton(),R=C.getEndButton(),H=C.getHorizontalScrolling(),v=C.getVerticalScrolling(),S=C.getState(),e=C.getStretch(),f=C.getStretchOnPhone()&&D.system.phone,g=C.getResizable(),j=C.getDraggable(),o=C.getAggregation("_valueState");var k=C.getContentWidth()&&C.getContentWidth()!='auto'?' width: '+C.getContentWidth()+';':'';var n=C.getContentHeight()&&C.getContentHeight()!='auto'?' height: '+C.getContentHeight()+';':'';var p="style='"+k+n+"'";r.write('<div '+p);r.writeControlData(C);r.addClass("sapMDialog");r.addClass("sapMDialog-CTX");r.addClass("sapMPopup-CTX");if(C.isOpen()){r.addClass("sapMDialogOpen");}if(window.devicePixelRatio>1){r.addClass("sapMDialogHighPixelDensity");}if(C._bDisableRepositioning){r.addClass("sapMDialogTouched");}if(e||(f)){r.addClass("sapMDialogStretched");}r.addClass(b._mStateClasses[S]);var q=!C._oToolbar&&!L&&!R;var u=C._oToolbar&&C._isToolbarEmpty()&&!L&&!R;if(q||u){r.addClass("sapMDialog-NoFooter");}if(!h){r.addClass("sapMDialog-NoHeader");}if(S==="Error"||S==="Warning"){r.writeAccessibilityState(C,{role:"alertdialog"});}else{r.writeAccessibilityState(C,{role:"dialog"});}if(C._forceDisableScrolling){r.addClass("sapMDialogWithScrollCont");}if(s&&s.getVisible()){r.addClass("sapMDialogWithSubHeader");if(s.getDesign()==l.ToolbarDesign.Info){r.addClass("sapMDialogSubHeaderInfoBar");}}if(m){r.addClass("sapMMessageDialog");}if(!v){r.addClass("sapMDialogVerScrollDisabled");}if(!H){r.addClass("sapMDialogHorScrollDisabled");}if(D.system.phone){r.addClass("sapMDialogPhone");}if(j&&!e){r.addClass("sapMDialogDraggable");}if(l._bSizeCompact){r.addClass("sapUiSizeCompact");}r.writeClasses();var T=C.getTooltip_AsString();if(T){r.writeAttributeEscaped("title",T);}r.writeAttribute("tabindex","-1");r.write(">");if(D.system.desktop){if(g&&!e){r.writeIcon("sap-icon://resize-corner",["sapMDialogResizeHandler"],{"title":""});}r.write('<span id="'+C.getId()+'-firstfe" tabindex="0" class="sapMDialogFirstFE"></span>');}if(h){h._applyContextClassFor("header");r.write("<header");r.addClass("sapMDialogTitle");r.writeClasses();r.write(">");r.renderControl(h);r.write("</header>");}if(s){s._applyContextClassFor("subheader");r.write("<header");r.addClass("sapMDialogSubHeader");r.writeClasses();r.write(">");r.renderControl(s);r.write("</header>");}if(o){r.renderControl(o);}r.write('<section id="'+d+'-cont" class="sapMDialogSection">');r.write('<div id="'+d+'-scroll" class="sapMDialogScroll">');r.write('<div id="'+d+'-scrollCont" class="sapMDialogScrollCont');if(C.getStretch()||n){r.write(' sapMDialogStretchContent');}r.write('">');var w=C.getContent();for(var i=0;i<w.length;i++){r.renderControl(w[i]);}r.write("</div>");r.write("</div>");r.write("</section>");if(!(q||u)){r.write("<footer");r.addClass("sapMDialogFooter");r.writeClasses();r.write(">");C._oToolbar._applyContextClassFor("footer");r.renderControl(C._oToolbar);r.write("</footer>");}if(D.system.desktop){r.write('<span id="'+C.getId()+'-lastfe" tabindex="0" class="sapMDialogLastFE"></span>');}r.write("</div>");};
return b;},true);
sap.ui.predefine('sap/m/DisplayListItem',["sap/ui/core/library","./library","./ListItemBase","./DisplayListItemRenderer"],function(c,l,L,D){"use strict";var T=c.TextDirection;
var a=L.extend("sap.m.DisplayListItem",{metadata:{library:"sap.m",properties:{label:{type:"string",group:"Misc",defaultValue:null},value:{type:"string",group:"Data",defaultValue:null},valueTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit}}}});
a.prototype.getContentAnnouncement=function(){return this.getLabel()+" "+this.getValue();};
return a;});
sap.ui.predefine('sap/m/DisplayListItemRenderer',["sap/ui/core/library","sap/ui/core/Renderer","./ListItemBaseRenderer"],function(c,R,L){"use strict";var T=c.TextDirection;var D=R.extend(L);
D.renderLIAttributes=function(r,l){r.addClass("sapMDLI");};
D.renderLIContent=function(r,l){var i=l.getLabel();if(i){r.write("<label for='"+l.getId()+"-value' class='sapMDLILabel'>");r.writeEscaped(l.getLabel());r.write("</label>");}var a=l.getValue();var v=l.getValueTextDirection();if(a){r.write("<div id='"+l.getId()+"-value' class='sapMDLIValue'");if(v!=T.Inherit){r.writeAttribute("dir",v.toLowerCase());}r.write(">");r.writeEscaped(l.getValue());r.write("</div>");}};
return D;},true);
sap.ui.predefine('sap/m/DraftIndicator',["sap/ui/core/Control","sap/m/Label","sap/m/library","./DraftIndicatorRenderer"],function(C,L,l,D){"use strict";var a=l.DraftIndicatorState;
var b=C.extend("sap.m.DraftIndicator",{metadata:{library:"sap.m",designtime:"sap/m/designtime/DraftIndicator.designtime",properties:{state:{type:"sap.m.DraftIndicatorState",group:"Behavior",defaultValue:a.Clear},minDisplayTime:{type:"int",group:"Behavior",defaultValue:1500}},aggregations:{_label:{type:"sap.m.Label",multiple:false,visibility:"hidden"}}}});
var B=sap.ui.getCore().getLibraryResourceBundle("sap.m");b._oTEXTS={};b._oTEXTS[a.Saving]=B.getText("DRAFT_INDICATOR_SAVING_DRAFT");b._oTEXTS[a.Saved]=B.getText("DRAFT_INDICATOR_DRAFT_SAVED");b._oTEXTS[a.Clear]="";
b.prototype.init=function(){this.aQueue=[];this.iDelayedCallId=null;};
b.prototype.exit=function(){this._resetDraftTimer();};
b.prototype.setState=function(s){this.setProperty("state",s);this._addToQueue(s);if(s===a.Saving){this._addToQueue(a.Clear);}return this;};
b.prototype._getLabel=function(){var c=this.getAggregation('_label');if(!c){var c=new L({id:this.getId()+"-label"});this.setAggregation('_label',c,true);c=this.getAggregation('_label');}return c;};
b.prototype.showDraftSaving=function(){this._addToQueue(a.Saving);this._addToQueue(a.Clear);};
b.prototype.showDraftSaved=function(){this._addToQueue(a.Saved);};
b.prototype.clearDraftState=function(){this._addToQueue(a.Clear);};
b.prototype._addToQueue=function(s){this.aQueue.push(s);this._processQueue();};
b.prototype._processQueue=function(){if(this.iDelayedCallId){return;}var n=this.aQueue.shift();var t=this.getMinDisplayTime();if(!n){return;}this._applyState(n);if(n===a.Clear){this._proceed();return;}this.iDelayedCallId=setTimeout(this._proceed.bind(this),t);};
b.prototype._proceed=function(){this._resetDraftTimer();this._processQueue();};
b.prototype._applyState=function(s){this._getLabel().setText(b._oTEXTS[s]);};
b.prototype._resetDraftTimer=function(){clearTimeout(this.iDelayedCallId);this.iDelayedCallId=null;};
return b;});
sap.ui.predefine('sap/m/DraftIndicatorRenderer',[],function(){"use strict";var D={};
D.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapMDraftIndicator");r.writeClasses();r.write(">");var l=c._getLabel();r.renderControl(l);r.write("</div>");};
return D;},true);
sap.ui.predefine('sap/m/FacetFilter',['./NavContainer','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/delegate/ItemNavigation','sap/ui/core/InvisibleText','sap/ui/core/IntervalTrigger','sap/ui/Device','sap/ui/base/ManagedObject','sap/ui/core/Icon','sap/ui/model/Filter','./FacetFilterRenderer',"sap/ui/events/KeyCodes","sap/base/assert","sap/base/Log","sap/ui/events/jquery/EventSimulation","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/scrollRightRTL","sap/ui/dom/jquery/scrollLeftRTL","sap/ui/dom/jquery/Selectors"],function(N,l,C,I,a,b,c,D,M,d,F,e,K,f,L,E,q){"use strict";var T=l.ToolbarDesign;var g=l.ListType;var h=l.ListMode;var m=l.FacetFilterListDataType;var B=l.ButtonType;var P=l.PlacementType;var n=l.FacetFilterType;
var o=C.extend("sap.m.FacetFilter",{metadata:{interfaces:["sap.ui.core.IShrinkable"],library:"sap.m",properties:{showPersonalization:{type:"boolean",group:"Appearance",defaultValue:false},type:{type:"sap.m.FacetFilterType",group:"Appearance",defaultValue:n.Simple},liveSearch:{type:"boolean",group:"Behavior",defaultValue:true},showSummaryBar:{type:"boolean",group:"Behavior",defaultValue:false},showReset:{type:"boolean",group:"Behavior",defaultValue:true},showPopoverOKButton:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"lists",aggregations:{lists:{type:"sap.m.FacetFilterList",multiple:true,singularName:"list"},buttons:{type:"sap.m.Button",multiple:true,singularName:"button",visibility:"hidden"},removeFacetIcons:{type:"sap.ui.core.Icon",multiple:true,singularName:"removeFacetIcon",visibility:"hidden"},popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"},addFacetButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},dialog:{type:"sap.m.Dialog",multiple:false,visibility:"hidden"},summaryBar:{type:"sap.m.Toolbar",multiple:false,visibility:"hidden"},resetButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},arrowLeft:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},arrowRight:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{reset:{},confirm:{}}}});
o.SCROLL_STEP=264;
o.prototype.setType=function(t){var s=this.getAggregation("summaryBar");if(D.system.phone){this.setProperty("type",n.Light);s.setActive(true);}else{this.setProperty("type",t);s.setActive(t===n.Light);}if(t===n.Light){if(this.getShowReset()){this._addResetToSummary(s);}else{this._removeResetFromSummary(s);}}return this;};
o.prototype.setShowReset=function(v){this.setProperty("showReset",v);var s=this.getAggregation("summaryBar");if(v){if(this.getShowSummaryBar()||this.getType()===n.Light){this._addResetToSummary(s);}}else{if(this.getShowSummaryBar()||this.getType()===n.Light){this._removeResetFromSummary(s);}}return this;};
o.prototype.setShowSummaryBar=function(v){this.setProperty("showSummaryBar",v);if(v){var s=this.getAggregation("summaryBar");if(this.getShowReset()){this._addResetToSummary(s);}else{this._removeResetFromSummary(s);}s.setActive(this.getType()===n.Light);}return this;};
o.prototype.setLiveSearch=function(v){this.setProperty("liveSearch",v);if(this._displayedList){var i=this._displayedList;var s=sap.ui.getCore().byId(i.getAssociation("search"));s.detachLiveChange(i._handleSearchEvent,i);if(v){s.attachLiveChange(i._handleSearchEvent,i);}}return this;};
o.prototype.getLists=function(){var i=this.getAggregation("lists");if(!i){i=[];}if(this._displayedList){i.splice(this._listAggrIndex,0,this._displayedList);}return i;};
o.prototype.removeList=function(O){var i=M.prototype.removeAggregation.call(this,"lists",O);this._removeList(i);return i;};
o.prototype.removeAggregation=function(){var i=M.prototype.removeAggregation.apply(this,arguments);if(arguments[0]==="lists"){this._removeList(i);}return i;};
o.prototype.openFilterDialog=function(){var i=this._getFacetDialog();var j=this._getFacetDialogNavContainer();i.addContent(j);this.getLists().forEach(function(k){if(k.getMode()===h.MultiSelect){k._preserveOriginalActiveState();}});i.setInitialFocus(j.getPages()[0].getContent()[0].getItems()[0]);i.open();return this;};
o.prototype.init=function(){this._pageSize=5;this._addDelegateFlag=false;this._invalidateFlag=false;this._lastCategoryFocusIndex=0;this._aDomRefs=null;this._previousTarget=null;this._addTarget=null;this._aRows=null;this._bundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.data("sap-ui-fastnavgroup","true",true);this._buttons={};this._aOwnedLabels=[];this._removeFacetIcons={};this._listAggrIndex=-1;this._displayedList=null;this._lastScrolling=false;this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._getAddFacetButton();this._getSummaryBar();this.setAggregation("resetButton",this._createResetButton());if(E.touchEventMode==="ON"&&!D.system.phone){this._enableTouchSupport();}if(D.system.phone){this.setType(n.Light);}};
o.prototype.exit=function(){var i;c.removeListener(this._checkOverflow,this);if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();}if(this._aOwnedLabels){this._aOwnedLabels.forEach(function(s){i=sap.ui.getCore().byId(s);if(i){i.destroy();}});this._aOwnedLabels=null;}};
o.prototype.onBeforeRendering=function(){if(this.getShowSummaryBar()||this.getType()===n.Light){var s=this.getAggregation("summaryBar");var t=s.getContent()[0];t.setText(this._getSummaryText());}c.removeListener(this._checkOverflow,this);};
o.prototype.onAfterRendering=function(){if(this.getType()!==n.Light&&!D.system.phone){c.addListener(this._checkOverflow,this);}if(this.getType()!==n.Light){this._startItemNavigation();}};
o.prototype._startItemNavigation=function(){var j=this.getDomRef(),r=j.getElementsByClassName("sapMFFHead"),k=[];if(r.length>0){for(var i=0;i<r[0].childNodes.length;i++){if(r[0].childNodes[i].id.indexOf("ff")<0&&r[0].childNodes[i].id.indexOf("icon")<0&&r[0].childNodes[i].id.indexOf("add")<0){k.push(r[0].childNodes[i]);}if(r[0].childNodes[i].id.indexOf("add")>=0){k.push(r[0].childNodes[i]);}}}if(k!=""){this._aDomRefs=k;}if((!this.oItemNavigation)||this._addDelegateFlag==true){this.oItemNavigation=new a();this.addDelegate(this.oItemNavigation);this._addDelegateFlag=false;}this._aRows=r;for(var i=0;i<this.$().find(":sapTabbable").length;i++){if(this.$().find(":sapTabbable")[i].id.indexOf("add")>=0){this._addTarget=this.$().find(":sapTabbable")[i];break;}}this.oItemNavigation.setRootDomRef(j);this.oItemNavigation.setItemDomRefs(k);this.oItemNavigation.setCycling(false);this.oItemNavigation.setPageSize(this._pageSize);};
o.prototype.onsapdelete=function(i){var j,p;if(this.getType()===n.Light){return;}if(!this.getShowPersonalization()){return;}j=sap.ui.getCore().byId(i.target.id);if(!j){return;}p=sap.ui.getCore().byId(j.getAssociation("list"));if(!p){return;}if(!p.getShowRemoveFacetIcon()){return;}p.removeSelections(true);p.setSelectedKeys();p.setProperty("active",false,true);this.invalidate();var t=this.$().find(":sapTabbable");q(t[t.length-1]).focus();var r=this.oItemNavigation.getFocusedIndex();q(i.target).blur();this.oItemNavigation.setFocusedIndex(r+1);this.focus();if(this.oItemNavigation.getFocusedIndex()==0){for(var k=0;k<this.$().find(":sapTabbable").length-1;k++){if(t[k].id.indexOf("add")>=0){q(t[k]).focus();}}}};
o.prototype.onsaptabnext=function(j){if(this.getType()===n.Light){return;}this._previousTarget=j.target;if(j.target.parentNode.className=="sapMFFHead"){for(var i=0;i<this.$().find(":sapTabbable").length;i++){if(this.$().find(":sapTabbable")[i].parentNode.className=="sapMFFResetDiv"){q(this.$().find(":sapTabbable")[i]).focus();this._invalidateFlag=false;j.preventDefault();j.setMarked();return;}}}this._lastCategoryFocusIndex=this.oItemNavigation.getFocusedIndex();if(this._invalidateFlag==true){this.oItemNavigation.setFocusedIndex(-1);this.focus();this._invalidateFlag=false;}};
o.prototype.onsaptabprevious=function(i){if(this.getType()===n.Light){return;}if(i.target.parentNode.className=="sapMFFResetDiv"&&this._previousTarget==null){q(this.$().find(":sapTabbable")[0]).focus();i.preventDefault();i.setMarked();return;}if(i.target.parentNode.className=="sapMFFResetDiv"&&this._previousTarget!=null&&this._previousTarget.id!=i.target.id){q(this._previousTarget).focus();i.preventDefault();i.setMarked();return;}if(i.target.id.indexOf("add")>=0||i.target.parentNode.className=="sapMFFHead"){this._previousTarget=i.target;q(this.$().find(":sapTabbable")[0]).focus();}};
o.prototype.onsapend=function(i){if(this.getType()===n.Light){return;}if(this._addTarget!=null){q(this._addTarget).focus();i.preventDefault();i.setMarked();}else{q(this._aRows[this._aRows.length-1]).focus();i.preventDefault();i.setMarked();}this._previousTarget=i.target;};
o.prototype.onsaphome=function(i){if(this.getType()===n.Light){return;}q(this._aRows[0]).focus();i.preventDefault();i.setMarked();this._previousTarget=i.target;};
o.prototype.onsappageup=function(i){this._previousTarget=i.target;};
o.prototype.onsappagedown=function(i){this._previousTarget=i.target;};
o.prototype.onsapincreasemodifiers=function(i){if(this.getType()===n.Light){return;}if(i.which==K.ARROW_RIGHT){this._previousTarget=i.target;var j=this.oItemNavigation.getFocusedIndex()-1;var k=j+this._pageSize;q(i.target).blur();this.oItemNavigation.setFocusedIndex(k);this.focus();}};
o.prototype.onsapdecreasemodifiers=function(i){if(this.getType()===n.Light){return;}var j=0;if(i.which==K.ARROW_LEFT){this._previousTarget=i.target;j=this.oItemNavigation.getFocusedIndex()+1;var k=j-this._pageSize;q(i.target).blur();this.oItemNavigation.setFocusedIndex(k);this.focus();}};
o.prototype.onsapdownmodifiers=function(i){if(this.getType()===n.Light){return;}this._previousTarget=i.target;var j=0;j=this.oItemNavigation.getFocusedIndex()-1;var k=j+this._pageSize;q(i.target).blur();this.oItemNavigation.setFocusedIndex(k);this.focus();};
o.prototype.onsapupmodifiers=function(i){if(this.getType()===n.Light){return;}this._previousTarget=i.target;var j=0;j=this.oItemNavigation.getFocusedIndex();if(j!=0){j=j+1;}var k=j-this._pageSize;q(i.target).blur();this.oItemNavigation.setFocusedIndex(k);this.focus();};
o.prototype.onsapexpand=function(i){if(this.getType()===n.Light){return;}this._previousTarget=i.target;var j=this.oItemNavigation.getFocusedIndex()+1;q(i.target).blur();this.oItemNavigation.setFocusedIndex(j);this.focus();};
o.prototype.onsapcollapse=function(i){if(this.getType()===n.Light){return;}this._previousTarget=i.target;var j=this.oItemNavigation.getFocusedIndex()-1;q(i.target).blur();this.oItemNavigation.setFocusedIndex(j);this.focus();};
o.prototype.onsapdown=function(i){if(this.getType()===n.Light){return;}this._previousTarget=i.target;if(i.target.parentNode.className=="sapMFFResetDiv"){q(i.target).focus();i.preventDefault();i.setMarked();return;}};
o.prototype.onsapup=function(i){if(this.getType()===n.Light){return;}this._previousTarget=i.target;if(i.target.parentNode.className=="sapMFFResetDiv"){q(i.target).focus();i.preventDefault();i.setMarked();}};
o.prototype.onsapleft=function(i){if(this.getType()===n.Light){return;}this._previousTarget=i.target;if(i.target.parentNode.className=="sapMFFResetDiv"){q(i.target).focus();i.preventDefault();i.setMarked();}};
o.prototype.onsapright=function(i){if(this.getType()===n.Light){return;}this._previousTarget=i.target;if(i.target.parentNode.className=="sapMFFResetDiv"){q(i.target).focus();i.preventDefault();i.setMarked();}};
o.prototype.onsapescape=function(i){if(this.getType()===n.Light){return;}if(i.target.parentNode.className=="sapMFFResetDiv"){return;}var j=this._lastCategoryFocusIndex;q(i.target).blur();this.oItemNavigation.setFocusedIndex(j);this.focus();};
o.prototype._getPopover=function(){var p=this.getAggregation("popover");if(!p){var t=this;p=new sap.m.Popover({placement:P.Bottom,beforeOpen:function(j){if(t._displayedList){t._displayedList._setSearchValue("");}this.setCustomHeader(t._createFilterItemsSearchFieldBar(t._displayedList));var s=this.getSubHeader();if(!s){this.setSubHeader(t._createSelectAllCheckboxBar(t._displayedList));}i(t._displayedList);},afterClose:function(j){t._addDelegateFlag=true;t._handlePopoverAfterClose();},horizontalScrolling:false});this.setAggregation("popover",p,true);p.setContentWidth("30%");p.addStyleClass("sapMFFPop");var i=function(j){if(!j){return;}var k=t._getFacetRemoveIcon(j);if(k){k._bTouchStarted=false;}};}if(this.getShowPopoverOKButton()){this._addOKButtonToPopover(p);}else{p.destroyAggregation("footer");}return p;};
o.prototype._handlePopoverAfterClose=function(){var p=this.getAggregation("popover"),i=this._displayedList;if(!p){return;}var j=this._getFacetRemoveIcon(i);if(j&&j._bTouchStarted){return;}this._restoreListFromDisplayContainer(p);this._displayRemoveIcon(false,i);i._fireListCloseEvent();this._fireConfirmEvent();this.destroyAggregation("popover");if(this._oOpenPopoverDeferred){setTimeout(function(){this._oOpenPopoverDeferred.resolve();this._oOpenPopoverDeferred=undefined;}.bind(this),0);}};
o.prototype._fireConfirmEvent=function(){this.fireEvent('confirm');};
o.prototype._openPopover=function(p,i){if(!p.isOpen()){var j=sap.ui.getCore().byId(i.getAssociation("list"));f(j,"The facet filter button should be associated with a list.");j.fireListOpen({});this._moveListToDisplayContainer(j,p);p.openBy(i);if(j.getShowRemoveFacetIcon()){this._displayRemoveIcon(true,j);}if(j.getWordWrap()){p.setContentWidth("30%");}j._applySearch();}return this;};
o.prototype._getAddFacetButton=function(){var i=this.getAggregation("addFacetButton");if(!i){var t=this;var i=new sap.m.Button(this.getId()+"-add",{icon:I.getIconURI("add-filter"),type:B.Transparent,tooltip:this._bundle.getText("FACETFILTER_ADDFACET"),press:function(j){t.openFilterDialog();}});this.setAggregation("addFacetButton",i,true);}return i;};
o.prototype._getButtonForList=function(i){if(this._buttons[i.getId()]){this._setButtonText(i);return this._buttons[i.getId()];}var t=this;var j=new sap.m.Button({type:B.Transparent,press:function(k){var p=this;var O=function(){var r=t._getPopover();t._openPopover(r,p);};if(i.getMode()===h.MultiSelect){i._preserveOriginalActiveState();}var r=t._getPopover();if(r.isOpen()){setTimeout(function(){if(r.isOpen()){return;}t._oOpenPopoverDeferred=q.Deferred();t._oOpenPopoverDeferred.promise().done(O);},100);}else{setTimeout(O.bind(this),100);}}});this._buttons[i.getId()]=j;this.addAggregation("buttons",j);j.setAssociation("list",i.getId(),true);this._setButtonText(i);return j;};
o.prototype._setButtonText=function(i){var j=this._buttons[i.getId()];if(i._iAllItemsCount===undefined&&i.getMaxItemsCount()){i._iAllItemsCount=i.getMaxItemsCount();}if(j){var t="";var s=Object.getOwnPropertyNames(i._oSelectedKeys);var k=s.length;if(k===1){var S=i._oSelectedKeys[s[0]];t=this._bundle.getText("FACETFILTER_ITEM_SELECTION",[i.getTitle(),S]);}else if(k>0&&k===(i._iAllItemsCount?i._iAllItemsCount:0)){t=this._bundle.getText("FACETFILTER_ALL_SELECTED",[i.getTitle()]);}else if(k>0){t=this._bundle.getText("FACETFILTER_ITEM_SELECTION",[i.getTitle(),k]);}else{t=i.getTitle();}j.setText(t);}};
o.prototype._getFacetRemoveIcon=function(i){var t=this,j=this._removeFacetIcons[i.getId()];if(!j){j=new d({src:I.getIconURI("sys-cancel"),tooltip:this._bundle.getText("FACETFILTER_REMOVE"),press:function(){j._bPressed=true;}});j.addDelegate({ontouchstart:function(){j._bTouchStarted=true;j._bPressed=false;},ontouchend:function(){t._displayRemoveIcon(false,i);j._bTouchStarted=false;setTimeout(p.bind(this),100);}},true);var p=function(){if(j._bPressed){i.removeSelections(true);i.setSelectedKeys();i.setProperty("active",false,true);}t._handlePopoverAfterClose();};j.setAssociation("list",i.getId(),true);j.addStyleClass("sapMFFLRemoveIcon");this._removeFacetIcons[i.getId()]=j;this.addAggregation("removeFacetIcons",j);this._displayRemoveIcon(false,i);}return j;};
o.prototype._displayRemoveIcon=function(i,j){if(this.getShowPersonalization()){var k=this._removeFacetIcons[j.getId()];if(i){k.removeStyleClass("sapMFFLHiddenRemoveIcon");k.addStyleClass("sapMFFLVisibleRemoveIcon");}else{k.removeStyleClass("sapMFFLVisibleRemoveIcon");k.addStyleClass("sapMFFLHiddenRemoveIcon");}}};
o.prototype._getFacetDialogNavContainer=function(){var i=new N({autoFocus:false});var j=this._createFacetPage();i.addPage(j);i.setInitialPage(j);var t=this;i.attachAfterNavigate(function(k){var p=k.getParameters()["to"];var r=k.getParameters()['from'];if(r===j){var s=(t._displayedList.getMode()===h.MultiSelect)?p.getContent(0)[1].getItems()[0]:p.getContent(0)[0].getItems()[0];if(s){s.focus();}}if(p===j){r.destroySubHeader();f(t._displayedList===null,"Filter items list should have been placed back in the FacetFilter aggregation before page content is destroyed.");r.destroyContent();t._selectedFacetItem.invalidate();p.invalidate();t._selectedFacetItem.focus();t._selectedFacetItem=null;}});return i;};
o.prototype._createFacetPage=function(){var i=this._createFacetList();var j=new sap.m.SearchField({width:"100%",tooltip:this._bundle.getText("FACETFILTER_SEARCH"),liveChange:function(k){var r=i.getBinding("items");if(r){var s=new F("text",sap.ui.model.FilterOperator.Contains,k.getParameters()["newValue"]);r.filter([s]);}}});var p=new sap.m.Page({enableScrolling:true,title:this._bundle.getText("FACETFILTER_TITLE"),subHeader:new sap.m.Bar({contentMiddle:j}),content:[i]});return p;};
o.prototype._createFilterItemsPage=function(){var t=this;var p=new sap.m.Page({showNavButton:true,enableScrolling:true,navButtonPress:function(i){var j=i.getSource().getParent();t._navFromFilterItemsPage(j);}});return p;};
o.prototype._getFilterItemsPage=function(i){var O=i.getPages()[1];if(O){i.removePage(O);O.destroy();}var p=this._createFilterItemsPage();i.addPage(p);return p;};
o.prototype._createFilterItemsSearchFieldBar=function(i){var t=this;var s=true;if(i.getDataType()!=m.String){s=false;}var S=new sap.m.SearchField({value:i._getSearchValue(),width:"100%",enabled:s,tooltip:this._bundle.getText("FACETFILTER_SEARCH"),search:function(k){t._displayedList._handleSearchEvent(k);}});if(this.getLiveSearch()){S.attachLiveChange(i._handleSearchEvent,i);}var j=new sap.m.Bar({contentMiddle:S});i.setAssociation("search",S);return j;};
o.prototype._getFacetDialog=function(){var i=this.getAggregation("dialog");if(!i){var t=this;i=new sap.m.Dialog({showHeader:false,stretch:D.system.phone?true:false,afterClose:function(){t._addDelegateFlag=true;t._invalidateFlag=true;var j=this.getContent()[0];var k=j.getPages()[1];if(j.getCurrentPage()===k){var p=t._restoreListFromDisplayContainer(k);if(p.getMode()===h.MultiSelect){p._updateActiveState();}p._fireListCloseEvent();p._search("");}this.destroyAggregation("content",true);t.invalidate();},beginButton:new sap.m.Button({text:this._bundle.getText("FACETFILTER_ACCEPT"),tooltip:this._bundle.getText("FACETFILTER_ACCEPT"),press:function(){t._closeDialog();}}),contentHeight:"500px",ariaLabelledBy:[b.getStaticId("sap.m","FACETFILTER_AVAILABLE_FILTER_NAMES")]});i.addStyleClass("sapMFFDialog");i.onsapentermodifiers=function(j){if(j.shiftKey&&!j.ctrlKey&&!j.altKey){var k=this.getContent()[0];t._navFromFilterItemsPage(k);}};this.setAggregation("dialog",i,true);}return i;};
o.prototype._closeDialog=function(){var i=this.getAggregation("dialog");if(i&&i.isOpen()){i.close();this._fireConfirmEvent();}};
o.prototype._closePopover=function(){var p=this.getAggregation("popover");if(p&&p.isOpen()){p.close();}};
o.prototype._createFacetList=function(){var j=this._oFacetList=new sap.m.List({mode:h.None,items:{path:"/items",template:new sap.m.StandardListItem({title:"{text}",counter:"{count}",type:g.Navigation,customData:[new sap.ui.core.CustomData({key:"index",value:"{index}"})]})}});var k=this._getMapFacetLists();var p=new sap.ui.model.json.JSONModel({items:k});if(k.length>100){p.setSizeLimit(k.length);}var t=this;j.attachUpdateFinished(function(){for(var i=0;i<j.getItems().length;i++){var r=this.getItems()[i];r.detachPress(t._handleFacetListItemPress,t);r.attachPress(t._handleFacetListItemPress,t);}});j.setModel(p);return j;};
o.prototype.refreshFacetList=function(){this._oFacetList.getModel().setData({items:this._getMapFacetLists()});return this;};
o.prototype._getMapFacetLists=function(){return this.getLists().map(function(i,j){return{text:i.getTitle(),count:i.getAllCount(),index:j};});};
o.prototype._createSelectAllCheckboxBar=function(i){if(!i.getMultiSelect()){return null;}var s=i.getActive()&&i.getItems().length>0&&Object.getOwnPropertyNames(i._oSelectedKeys).length===i.getItems().length;var j=new sap.m.CheckBox(i.getId()+"-selectAll",{text:this._bundle.getText("FACETFILTER_CHECKBOX_ALL"),tooltip:this._bundle.getText("FACETFILTER_CHECKBOX_ALL"),selected:s,select:function(p){j.setSelected(p.getParameter("selected"));i._handleSelectAllClick(p.getParameter("selected"));}});i.setAssociation("allcheckbox",j);var k=new sap.m.Bar();k.addEventDelegate({ontap:function(p){if(p.srcControl===this){i._handleSelectAllClick(j.getSelected());}}},k);k.addContentLeft(j);k.addStyleClass("sapMFFCheckbar");return k;};
o.prototype._handleFacetListItemPress=function(i){this._navToFilterItemsPage(i.getSource());};
o.prototype._navToFilterItemsPage=function(i){this._selectedFacetItem=i;var j=this.getAggregation("dialog").getContent()[0];var k=i.getCustomData();f(k.length===1,"There should be exactly one custom data for the original facet list item index");var p=k[0].getValue();var r=this.getLists()[p];this._listIndexAgg=this.indexOfAggregation("lists",r);if(this._listIndexAgg==p){var s=this._getFilterItemsPage(j);r.fireListOpen({});this._moveListToDisplayContainer(r,s);s.setSubHeader(this._createFilterItemsSearchFieldBar(r));var t=this._createSelectAllCheckboxBar(r);if(t){s.insertContent(t,0);}s.setTitle(r.getTitle());j.to(s);}};
o.prototype._navFromFilterItemsPage=function(i){var j=i.getPages()[1];var k=this._restoreListFromDisplayContainer(j);if(k.getMode()===h.MultiSelect){k._updateActiveState();}k._fireListCloseEvent();k._search("");this._selectedFacetItem.setCounter(k.getAllCount());i.backToTop();};
o.prototype._moveListToDisplayContainer=function(i,j){this._listAggrIndex=this.indexOfAggregation("lists",i);f(this._listAggrIndex>-1,"The lists index should be valid.");M.prototype.removeAggregation.call(this,"lists",i,true);j.addAggregation("content",i,false);i.setAssociation("facetFilter",this,true);this._displayedList=i;};
o.prototype._restoreListFromDisplayContainer=function(i){var j=i.removeAggregation("content",this._displayedList,true);this.insertAggregation("lists",j,this._listAggrIndex,j.getActive());this._listAggrIndex=-1;this._displayedList=null;return j;};
o.prototype._getSequencedLists=function(){var k=-1;var s=[];var p=this.getLists();if(p.length>0){for(var i=0;i<p.length;i++){if(p[i].getActive()){if(p[i].getSequence()<-1){p[i].setSequence(-1);}else if(p[i].getSequence()>k){k=p[i].getSequence();}s.push(p[i]);}else if(!p[i].getRetainListSequence()){p[i].setSequence(-1);}}for(var j=0;j<s.length;j++){if(s[j].getSequence()<=-1){k+=1;s[j].setSequence(k);}}if(s.length>1){s.sort(function(r,t){return r.getSequence()-t.getSequence();});}}return s;};
o.prototype._getSummaryBar=function(){var s=this.getAggregation("summaryBar");if(!s){var t=new sap.m.Text({maxLines:1});var i=this;s=new sap.m.Toolbar({content:[t],active:this.getType()===n.Light?true:false,design:T.Info,ariaLabelledBy:[b.getStaticId("sap.m","FACETFILTER_TITLE"),t],press:function(j){i.openFilterDialog();}});s._setRootAccessibilityRole("button");this.setAggregation("summaryBar",s);}return s;};
o.prototype._createResetButton=function(){var t=this;var j=new sap.m.Button({type:B.Transparent,icon:I.getIconURI("undo"),tooltip:this._bundle.getText("FACETFILTER_RESET"),press:function(k){t._addDelegateFlag=true;t._invalidateFlag=true;t.fireReset();var p=t.getLists();for(var i=0;i<p.length;i++){p[i]._searchValue="";p[i]._applySearch();var r=p[i].getItems()[0];if(r){r.focus();}}t.invalidate();}});return j;};
o.prototype._addOKButtonToPopover=function(p){var i=p.getFooter();if(!i){var t=this;var i=new sap.m.Button({text:this._bundle.getText("FACETFILTER_ACCEPT"),tooltip:this._bundle.getText("FACETFILTER_ACCEPT"),width:"100%",press:function(){t._closePopover();}});p.setFooter(i);}return i;};
o.prototype._getSummaryText=function(){var k=", ";var S=" ";var s="";var p=true;var r=this.getLists();if(r.length>0){for(var i=0;i<r.length;i++){var t=r[i];if(t.getActive()){var u=this._getSelectedItemsText(t);var v="";for(var j=0;j<u.length;j++){v=v+u[j]+k;}if(v){v=v.substring(0,v.lastIndexOf(k)).trim();if(p){s=this._bundle.getText("FACETFILTER_INFOBAR_FILTERED_BY",[t.getTitle(),v]);p=false;}else{s=s+S+this._bundle.getText("FACETFILTER_INFOBAR_AND")+S+this._bundle.getText("FACETFILTER_INFOBAR_AFTER_AND",[t.getTitle(),v]);}}}}}if(!s){s=this._bundle.getText("FACETFILTER_INFOBAR_NO_FILTERS");}return s;};
o.prototype._getSelectedItemsText=function(i){var t=i.getSelectedItems().map(function(v){return v.getText();});i._oSelectedKeys&&Object.getOwnPropertyNames(i._oSelectedKeys).forEach(function(v){t.indexOf(i._oSelectedKeys[v])===-1&&t.push(i._oSelectedKeys[v]);});return t;};
o.prototype._addResetToSummary=function(s){if(s.getContent().length===1){s.addContent(new sap.m.ToolbarSpacer({width:""}));var i=this._createResetButton();s.addContent(i);i.addStyleClass("sapUiSizeCompact");i.addStyleClass("sapMFFRefresh");i.addStyleClass("sapMFFBtnHoverable");}};
o.prototype._removeResetFromSummary=function(s){if(s.getContent().length===3){var S=s.removeAggregation("content",1);S.destroy();var i=s.removeAggregation("content",1);i.destroy();}};
o.prototype._removeList=function(i){if(i){var j=this._buttons[i.getId()];if(j){this.removeAggregation("buttons",j);j.destroy();}var r=this._removeFacetIcons[i.getId()];if(r){this.removeAggregation("removeIcons",r);r.destroy();}delete this._buttons[i.getId()];delete this._removeFacetIcons[i.getId()];}};
o.prototype._getScrollingArrow=function(s){var A=null;var p={src:"sap-icon://navigation-"+s+"-arrow"};if(s==="left"){A=this.getAggregation("arrowLeft");if(!A){p.id=this.getId()+"-arrowScrollLeft";A=I.createControlByURI(p);var j=["sapMPointer","sapMFFArrowScroll","sapMFFArrowScrollLeft"];for(var i=0;i<j.length;i++){A.addStyleClass(j[i]);A.setTooltip(this._bundle.getText("FACETFILTER_PREVIOUS"));}this.setAggregation("arrowLeft",A);}}else if(s==="right"){A=this.getAggregation("arrowRight");if(!A){p.id=this.getId()+"-arrowScrollRight";A=I.createControlByURI(p);var k=["sapMPointer","sapMFFArrowScroll","sapMFFArrowScrollRight"];for(var i=0;i<k.length;i++){A.addStyleClass(k[i]);A.setTooltip(this._bundle.getText("FACETFILTER_NEXT"));}this.setAggregation("arrowRight",A);}}else{L.error("Scrolling arrow name "+s+" is not valid");}return A;};
o.prototype._checkOverflow=function(){var i=this.getDomRef("head"),$=q(i),j=this.$(),s=false,S=false,k=false,p=null,r=null,t=null;if(i){p=i.scrollLeft;r=i.scrollWidth;t=i.clientWidth;if(r>t){if(r-t==1){r=t;}else{k=true;}}j.toggleClass("sapMFFScrolling",k);j.toggleClass("sapMFFNoScrolling",!k);this._lastScrolling=k;if(!this._bRtl){s=p>0;S=(r>t)&&(r>p+t);}else{S=$.scrollLeftRTL()>0;s=$.scrollRightRTL()>0;}if((S!=this._bPreviousScrollForward)||(s!=this._bPreviousScrollBack)){j.toggleClass("sapMFFNoScrollBack",!s);j.toggleClass("sapMFFNoScrollForward",!S);}}};
o.prototype.onclick=function(i){var t=i.target.id;if(t){var s=this.getId(),j=i.target;i.preventDefault();if(t==s+"-arrowScrollLeft"){j.tabIndex=-1;j.focus();this._scroll(-o.SCROLL_STEP,500);}else if(t==s+"-arrowScrollRight"){j.tabIndex=-1;j.focus();this._scroll(o.SCROLL_STEP,500);}}};
o.prototype._scroll=function(i,j){var k=this.getDomRef("head");var s=k.scrollLeft;if(!D.browser.internet_explorer&&this._bRtl){i=-i;}var S=s+i;q(k).stop(true,true).animate({scrollLeft:S},j);};
o.prototype._enableTouchSupport=function(){var t=this;var i=function(p){var s=t.getType();if(s===n.Light){return;}p.preventDefault();if(t._iInertiaIntervalId){window.clearInterval(t._iInertiaIntervalId);}t.startScrollX=t.getDomRef("head").scrollLeft;t.startTouchX=p.touches[0].pageX;t._bTouchNotMoved=true;t._lastMoveTime=new Date().getTime();};var j=function(p){var s=t.getType();if(s===n.Light){return;}var r=p.touches[0].pageX-t.startTouchX;var u=t.getDomRef("head");var v=u.scrollLeft;var w=t.startScrollX-r;u.scrollLeft=w;t._bTouchNotMoved=false;var x=new Date().getTime()-t._lastMoveTime;t._lastMoveTime=new Date().getTime();if(x>0){t._velocity=(w-v)/x;}p.preventDefault();};var k=function(p){var s=t.getType();if(s===n.Light){return;}if(t._bTouchNotMoved===false){p.preventDefault();var r=t.getDomRef("head");var u=50;var v=Math.abs(t._velocity/10);t._iInertiaIntervalId=window.setInterval(function(){t._velocity=t._velocity*0.80;var w=t._velocity*u;r.scrollLeft=r.scrollLeft+w;if(Math.abs(t._velocity)<v){window.clearInterval(t._iInertiaIntervalId);t._iInertiaIntervalId=undefined;}},u);}else if(t._bTouchNotMoved===true){t.onclick(p);p.preventDefault();}t._bTouchNotMoved=undefined;t._lastMoveTime=undefined;};this.addEventDelegate({ontouchstart:i},this);this.addEventDelegate({ontouchend:k},this);this.addEventDelegate({ontouchmove:j},this);};
return o;});
sap.ui.predefine('sap/m/FacetFilterItem',['./ListItemBase','./library','./FacetFilterItemRenderer'],function(L,l,F){"use strict";
var a=L.extend("sap.m.FacetFilterItem",{metadata:{library:"sap.m",properties:{key:{type:"string",group:"Data",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null},count:{type:"int",group:"Misc",defaultValue:null,deprecated:true}}}});
a.prototype.setCount=function(c){this.setProperty("count",c);this.setProperty("counter",c);return this;};
a.prototype.setCounter=function(c){this.setProperty("count",c);this.setProperty("counter",c);return this;};
a.prototype.init=function(){this.attachEvent("_change",this._itemTextChange);L.prototype.init.apply(this);this.addStyleClass("sapMFFLI");};
a.prototype.exit=function(){L.prototype.exit.apply(this);this.detachEvent("_change",this._itemTextChange);};
a.prototype._itemTextChange=function(e){if(e.getParameter("name")==="text"){this.informList("TextChange",e.getParameter("newValue"));}};
return a;});
sap.ui.predefine('sap/m/FacetFilterItemRenderer',['./ListItemBaseRenderer','sap/ui/core/Renderer'],function(L,R){"use strict";var F=R.extend(L);
F.renderLIContent=function(r,c){r.write("<div");if(c.getParent()&&c.getParent().getWordWrap()){r.addClass("sapMFFLITitleWrap");}else{r.addClass("sapMFFLITitle");}r.writeClasses();r.write(">");r.writeEscaped(c.getText());r.write("</div>");};
return F;},true);
sap.ui.predefine('sap/m/FacetFilterList',['./List','./library','sap/ui/model/ChangeReason','sap/ui/model/Filter','./FacetFilterListRenderer',"sap/base/Log"],function(L,l,C,F,a,b){"use strict";var c=l.ListMode;var d=l.FacetFilterListDataType;
var e=L.extend("sap.m.FacetFilterList",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Appearance",defaultValue:null},wordWrap:{type:"boolean",group:"Appearance",defaultValue:false},multiSelect:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},active:{type:"boolean",group:"Behavior",defaultValue:true},enableCaseInsensitiveSearch:{type:"boolean",group:"Behavior",defaultValue:false,deprecated:false},allCount:{type:"int",group:"Appearance",defaultValue:null},sequence:{type:"int",group:"Behavior",defaultValue:-1},key:{type:"string",group:"Identification",defaultValue:null},showRemoveFacetIcon:{type:"boolean",group:"Misc",defaultValue:true},retainListSequence:{type:"boolean",group:"Misc",defaultValue:false},dataType:{type:"sap.m.FacetFilterListDataType",group:"Misc",defaultValue:d.String}},events:{listOpen:{},listClose:{parameters:{selectedItems:{type:"sap.m.FacetFilterItem[]"},allSelected:{type:"boolean"},selectedKeys:{type:"object"}}}}}});
e.prototype.setTitle=function(t){this.setProperty("title",t,true);this._updateFacetFilterButtonText();return this;};
e.prototype.setMultiSelect=function(v){this.setProperty("multiSelect",v,true);var m=v?c.MultiSelect:c.SingleSelectMaster;this.setMode(m);return this;};
e.prototype.setMode=function(m){if(m===c.MultiSelect||m===c.SingleSelectMaster){L.prototype.setMode.call(this,m);this.setProperty("multiSelect",m===c.MultiSelect?true:false,true);}return this;};
e.prototype._applySearch=function(){var s=this._getSearchValue();if(s!=null){this._search(s,true);this._updateSelectAllCheckBox();}};
e.prototype.getSelectedItems=function(){var s=[];var o={};var f=sap.m.ListBase.prototype.getSelectedItems.apply(this,arguments);f.forEach(function(i){s.push(new sap.m.FacetFilterItem({text:i.getText(),key:i.getKey(),selected:true}));o[i.getKey()]=true;});var S=this.getSelectedKeys();var g=Object.getOwnPropertyNames(S);if(f.length<g.length){g.forEach(function(k){if(!o[k]){s.push(new sap.m.FacetFilterItem({text:S[k],key:k,selected:true}));}});}return s;};
e.prototype.getSelectedItem=function(){var i=sap.m.ListBase.prototype.getSelectedItem.apply(this,arguments);var s=Object.getOwnPropertyNames(this.getSelectedKeys());if(!i&&s.length>0){i=new sap.m.FacetFilterItem({text:this.getSelectedKeys()[s[0]],key:s[0],selected:true});}return i;};
e.prototype.removeSelections=function(A){if(this._allowRemoveSelections){A?this.setSelectedKeys():sap.m.ListBase.prototype.removeSelections.call(this,A);}return this;};
e.prototype.getSelectedKeys=function(){var r={};var k=this._oSelectedKeys;Object.getOwnPropertyNames(k).forEach(function(f){r[f]=k[f];});return r;};
e.prototype.setSelectedKeys=function(k){this._oSelectedKeys={};var K=false;k&&Object.getOwnPropertyNames(k).forEach(function(f){this._addSelectedKey(f,k[f]);K=true;},this);if(K){if(this.getMode()===c.MultiSelect){this.setActive(true);}this._selectItemsByKeys();}else{sap.m.ListBase.prototype.removeSelections.call(this);}};
e.prototype._getNonGroupItems=function(){var i=[];this.getItems().forEach(function(I){if(I.getMode()!==c.None){i.push(I);}});return i;};
e.prototype.removeSelectedKey=function(k,t){if(this._removeSelectedKey(k,t)){this._getNonGroupItems().forEach(function(i){var I=i.getKey()||i.getText();k===I&&i.setSelected(false);});}};
e.prototype.removeSelectedKeys=function(){this._oSelectedKeys={};sap.m.ListBase.prototype.removeSelections.call(this,true);};
e.prototype.removeItem=function(i){var I=sap.m.ListBase.prototype.removeItem.apply(this,arguments);if(!this._filtering){I&&I.getSelected()&&this.removeSelectedKey(I.getKey(),I.getText());return I;}};
e.prototype.init=function(){this._firstTime=true;this._saveBindInfo;this._oSelectedKeys={};L.prototype.init.call(this);this.setMode(c.MultiSelect);this.setIncludeItemInSelection(true);this.setGrowing(true);this.setRememberSelections(false);this._searchValue="";this.attachUpdateFinished(function(E){var u=E.getParameter("reason");u=u?u.toLowerCase():u;if(u==="change"){var B=this.getBinding("items"),m=B?B.getModel():null;if(m&&m.getProperty(B.getPath())){this._iAllItemsCount=m.getProperty(B.getPath()).length||0;}}if(u!=="growing"&&u!==C.Filter.toLowerCase()){this._oSelectedKeys={};this._getNonGroupItems().forEach(function(i){if(i.getSelected()){this._addSelectedKey(i.getKey(),i.getText());}},this);}if(u!==C.Filter.toLowerCase()){this._selectItemsByKeys();}this._updateFacetFilterButtonText();this._updateSelectAllCheckBox();});this._allowRemoveSelections=true;this._bOriginalActiveState;this._iAllItemsCount;};
e.prototype._resetItemsBinding=function(){if(this.isBound("items")){this._searchValue="";this._allowRemoveSelections=false;sap.m.ListBase.prototype._resetItemsBinding.apply(this,arguments);this._allowRemoveSelections=true;}};
e.prototype._fireListCloseEvent=function(){var s=this.getSelectedItems();var S=this.getSelectedKeys();var A=s.length===0;this._firstTime=true;this.fireListClose({selectedItems:s,selectedKeys:S,allSelected:A});};
e.prototype._updateActiveState=function(){var o=sap.ui.getCore().byId(this.getAssociation("allcheckbox"));if(Object.getOwnPropertyNames(this._oSelectedKeys).length>0||(o&&o.getSelected())){this.setActive(true);}};
e.prototype._handleSearchEvent=function(E){var s=E.getParameters()["query"];if(s===undefined){s=E.getParameters()["newValue"];}this._search(s);this._updateSelectAllCheckBox();};
e.prototype._search=function(s,f){var g;var n=0;function h(m){return m instanceof sap.ui.model.odata.ODataModel||m instanceof sap.ui.model.odata.v2.ODataModel;}if(f||(s!==this._searchValue)){this._searchValue=s;var B=this.getBinding("items");var o=this.getBindingInfo("items");if(o&&o.binding){g=o.binding.aFilters;if(g.length>0){n=g[0].aFilters.length;if(this._firstTime){this._saveBindInfo=g[0].aFilters[0][0];this._firstTime=false;}}}if(B){if(s||n>0){var j=this.getBindingInfo("items").template.getBindingInfo("text").parts;var p=j[0].path;if(p||p===""){var u=new F(p,sap.ui.model.FilterOperator.Contains,s);var U=[u];for(var i=1;i<j.length;i++){U.push(new F(j[i].path,sap.ui.model.FilterOperator.Contains,s));}if(this.getEnableCaseInsensitiveSearch()&&h(B.getModel())){var E="'"+String(s).replace(/'/g,"''")+"'";E=E.toLowerCase();u=new F("tolower("+p+")",sap.ui.model.FilterOperator.Contains,E);U=[u];for(var i=1;i<j.length;i++){U.push(new F("tolower("+j[i].path+")",sap.ui.model.FilterOperator.Contains,s));}}var P=new F(U,false);if(n>1){var k=new F([P,this._saveBindInfo],true);}else{if(this._saveBindInfo>""&&u.sPath!=this._saveBindInfo.sPath){var k=new F([P,this._saveBindInfo],true);}else{if(s==""){var k=[];}else{var k=new F([P],true);}}}B.filter(k,sap.ui.model.FilterType.Control);}}else{B.filter([],sap.ui.model.FilterType.Control);}}else{b.warning("No filtering performed","The list must be defined with a binding for search to work",this);}}};
e.prototype._getSearchValue=function(){return this._searchValue;};
e.prototype._updateSelectAllCheckBox=function(){var i=this._getNonGroupItems(),I=i.length,o,A,s;function f(g){return g.getSelected();}if(this.getMultiSelect()){o=sap.ui.getCore().byId(this.getAssociation("allcheckbox"));A=I>0&&I===i.filter(f).length;s=this.getActive()&&A;o&&o.setSelected(s);}};
e.prototype._addSelectedKey=function(k,t){if(!k&&!t){b.error("Both sKey and sText are not defined. At least one must be defined.");return;}if(this.getMode()===c.SingleSelectMaster){this.removeSelectedKeys();}if(!k){k=t;}this._oSelectedKeys[k]=t||k;};
e.prototype._removeSelectedKey=function(k,t){if(!k&&!t){b.error("Both sKey and sText are not defined. At least one must be defined.");return false;}if(!k){k=t;}delete this._oSelectedKeys[k];return true;};
e.prototype._setSearchValue=function(v){this._searchValue=v;};
e.prototype._isItemSelected=function(i){return!!(this._oSelectedKeys[i&&(i.getKey()||i.getText())]);};
e.prototype._updateFacetFilterButtonText=function(){if(this.getParent()&&this.getParent()._setButtonText){this.getParent()._setButtonText(this);}};
e.prototype._selectItemsByKeys=function(){this._getNonGroupItems().forEach(function(i){i.setSelected(this._isItemSelected(i));},this);this._updateFacetFilterButtonText();};
e.prototype._handleSelectAllClick=function(s){var A;this._getNonGroupItems().forEach(function(i){if(s){this._addSelectedKey(i.getKey(),i.getText());}else{this._removeSelectedKey(i.getKey(),i.getText());}i.setSelected(s,true);},this);if(this.getMode()===c.MultiSelect){A=this._getOriginalActiveState()||s;this.setActive(A);}setTimeout(this._updateSelectAllCheckBox.bind(this),0);};
e.prototype.onItemTextChange=function(i,n){var k=i.getKey();if(this._oSelectedKeys[k]&&n&&!this._filtering){this._oSelectedKeys[k]=n;}};
e.prototype.onItemSelectedChange=function(i,s){var A;if(s){this._addSelectedKey(i.getKey(),i.getText());}else{this._removeSelectedKey(i.getKey(),i.getText());}sap.m.ListBase.prototype.onItemSelectedChange.apply(this,arguments);if(this.getMode()===c.MultiSelect){A=this._getOriginalActiveState()||s||this.getSelectedItems().length>1;this.setActive(A);}!this.getDomRef()&&this.getParent()&&this.getParent().getDomRef()&&this.getParent().invalidate();setTimeout(this._updateSelectAllCheckBox.bind(this),0);};
e.prototype.updateItems=function(r){this._filtering=r===C.Filter;sap.m.ListBase.prototype.updateItems.apply(this,arguments);this._filtering=false;if(!this.getGrowing()||r===C.Filter){this._selectItemsByKeys();}};
e.prototype._getOriginalActiveState=function(){return this._bOriginalActiveState;};
e.prototype._preserveOriginalActiveState=function(){this._bOriginalActiveState=this.getActive();};
return e;});
sap.ui.predefine('sap/m/FacetFilterListRenderer',['./ListRenderer','sap/ui/core/Renderer'],function(L,R){"use strict";var F=R.extend(L);return F;},true);
sap.ui.predefine('sap/m/FacetFilterRenderer',["sap/m/library","sap/ui/Device","sap/ui/core/InvisibleText"],function(l,D,I){"use strict";var F=l.FacetFilterType;var a={};
a.render=function(r,c){switch(c.getType()){case F.Simple:a.renderSimpleFlow(r,c);break;case F.Light:a.renderSummaryBar(r,c);break;}};
a.renderSimpleFlow=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapMFF");r.writeAccessibilityState(c,{"role":"toolbar"});if(c.getShowSummaryBar()){r.write(">");a.renderSummaryBar(r,c);}else{if(c._lastScrolling){r.addClass("sapMFFScrolling");}else{r.addClass("sapMFFNoScrolling");}if(c.getShowReset()){r.addClass("sapMFFResetSpacer");}r.writeClasses();r.write(">");if(D.system.desktop){r.renderControl(c._getScrollingArrow("left"));}r.write("<div");r.writeAttribute("id",c.getId()+"-head");r.addClass("sapMFFHead");r.writeClasses();r.write(">");a.renderFacetFilterListButtons(c,r);if(c.getShowPersonalization()){r.renderControl(c.getAggregation("addFacetButton"));}r.write("</div>");if(D.system.desktop){r.renderControl(c._getScrollingArrow("right"));}if(c.getShowReset()){r.write("<div");r.addClass("sapMFFResetDiv");r.writeClasses();r.write(">");r.renderControl(c.getAggregation("resetButton"));r.write("</div>");}}r.write("</div>");};
a.renderSummaryBar=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapMFF");r.writeClasses();r.write(">");r.renderControl(c.getAggregation("summaryBar"));r.write("</div>");};
a.getAriaAnnouncement=function(k,b){return I.getStaticId("sap.m",b||"FACETFILTER_"+k.toUpperCase());};
a.getAriaDescribedBy=function(c){var d=[];if(c.getShowPersonalization()){d.push(this.getAriaAnnouncement("ARIA_REMOVE"));}d=d.concat(c._aAriaPositionTextIds);return d.join(" ");};
a.getAccessibilityState=function(c){return{describedby:{value:this.getAriaDescribedBy(c),append:true}};};
a.renderFacetFilterListButtons=function(c,r){var L=c._getSequencedLists(),b=L.length,B,i,p,A,o=[],n=[],f=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("FACETFILTER_ARIA_FACET_FILTER"),R=this.getAriaAnnouncement("ARIA_REMOVE");for(i=0;i<b;i++){B=c._getButtonForList(L[i]);o=B.removeAllAriaDescribedBy();o.forEach(d);p=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("FACETFILTERLIST_ARIA_POSITION",[(i+1),b]);A=new I({text:f+" "+p}).toStatic();c._aOwnedLabels.push(A.getId());B.addAriaDescribedBy(A);n.push(A.getId());if(c.getShowPersonalization()){B.addAriaDescribedBy(a.getAriaAnnouncement("ARIA_REMOVE"));}r.renderControl(B);if(c.getShowPersonalization()){r.renderControl(c._getFacetRemoveIcon(L[i]));}}c._aAriaPositionTextIds=n;function d(s){if(R!==s){var e=sap.ui.getCore().byId(s);if(e){e.destroy();}}}};
return a;},true);
sap.ui.predefine('sap/m/FeedContent',['./library','sap/ui/core/Control','sap/m/Text','sap/ui/Device','./FeedContentRenderer',"sap/ui/events/KeyCodes"],function(l,C,T,D,F,K){"use strict";var S=l.Size;
var a=C.extend("sap.m.FeedContent",{metadata:{library:"sap.m",properties:{"size":{type:"sap.m.Size",group:"Misc",defaultValue:S.Auto},"contentText":{type:"string",group:"Misc",defaultValue:null},"subheader":{type:"string",group:"Misc",defaultValue:null},"value":{type:"string",group:"Misc",defaultValue:null},"valueColor":{type:"sap.m.ValueColor",group:"Misc",defaultValue:null},"truncateValueTo":{type:"int",group:"Misc",defaultValue:4}},defaultAggregation:"_contentTextAgr",aggregations:{"_contentTextAgr":{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{"press":{}}}});
a.prototype.init=function(){this._oContentText=new T(this.getId()+"-content-text",{maxLines:2});this._oContentText.cacheLineHeight=false;this.setAggregation("_contentTextAgr",this._oContentText,true);this.setTooltip("{AltText}");};
a.prototype.onBeforeRendering=function(){this.$().unbind("mouseenter");this.$().unbind("mouseleave");};
a.prototype.onAfterRendering=function(){this.$().bind("mouseenter",this._addTooltip.bind(this));this.$().bind("mouseleave",this._removeTooltip.bind(this));};
a.prototype.exit=function(){this._oContentText=null;};
a.prototype._addTooltip=function(){this.$().attr("title",this.getTooltip_AsString());};
a.prototype._removeTooltip=function(){this.$().attr("title",null);};
a.prototype.getAltText=function(){var A="";var i=true;if(this.getAggregation("_contentTextAgr").getText()){A+=this.getAggregation("_contentTextAgr").getText();i=false;}if(this.getSubheader()){if(i){A+=""+this.getSubheader();}else{A+="\n"+this.getSubheader();}i=false;}if(this.getValue()){if(i){A+=""+this.getValue();}else{A+="\n"+this.getValue();}}return A;};
a.prototype.getTooltip_AsString=function(){var t=this.getTooltip();var s=this.getAltText();if(typeof t==="string"||t instanceof String){s=t.split("{AltText}").join(s).split("((AltText))").join(s);return s;}if(t){return t;}else{return"";}};
a.prototype.setContentText=function(t){this._oContentText.setText(t);return this;};
a.prototype.ontap=function(e){if(D.browser.msie){this.$().focus();}this.firePress();};
a.prototype.onkeydown=function(e){if(e.which===K.ENTER||e.which===K.SPACE){this.firePress();e.preventDefault();}};
a.prototype.attachEvent=function(e,d,f,b){C.prototype.attachEvent.call(this,e,d,f,b);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapMPointer");}return this;};
a.prototype.detachEvent=function(e,f,b){C.prototype.detachEvent.call(this,e,f,b);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapMPointer");}return this;};
return a;});
sap.ui.predefine('sap/m/FeedContentRenderer',[],function(){"use strict";var F={};
F.render=function(r,c){var s=c.getSubheader();var v=c.getValue();var t=c.getTooltip_AsString();if(typeof t!=="string"){t="";}r.write("<div");r.writeControlData(c);r.writeAttribute("role","presentation");r.writeAttributeEscaped("aria-label",t);r.addClass("sapMFC");if(c.hasListeners("press")){r.writeAttribute("tabindex","0");r.addClass("sapMPointer");}r.writeClasses();r.write(">");if(v){r.write("<div");r.writeAttribute("id",c.getId()+"-value");r.addClass("sapMFCValue");r.addClass(c.getValueColor());r.writeClasses();r.write(">");var C=c.getTruncateValueTo();if(v.length>=C&&(v[C-1]==="."||v[C-1]===",")){r.writeEscaped(v.substring(0,C-1));}else if(v){r.writeEscaped(v.substring(0,C));}else{r.writeEscaped("");}r.write("</div>");}r.write("<div");r.addClass("sapMFCCTxt");r.writeClasses();r.write(">");r.renderControl(c._oContentText);r.write("</div>");r.write("<div");r.writeAttribute("id",c.getId()+"-subheader");r.addClass("sapMFCSbh");r.writeClasses();r.write(">");r.writeEscaped(s);r.write("</div>");r.write("</div>");};
return F;},true);
sap.ui.predefine('sap/m/FeedInput',["./library","sap/ui/core/Control","sap/ui/core/IconPool","sap/m/TextArea","sap/m/Button","./FeedInputRenderer","sap/ui/thirdparty/jquery"],function(l,C,I,T,B,F,q){"use strict";var a=l.ButtonType;var M=15,b=2,U=0;
var c=C.extend("sap.m.FeedInput",{metadata:{library:"sap.m",designtime:"sap/m/designtime/FeedInput.designtime",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},rows:{type:"int",group:"Appearance",defaultValue:2},showExceededText:{type:"boolean",group:"Behavior",defaultValue:false},maxLength:{type:"int",group:"Behavior",defaultValue:0},growing:{type:"boolean",group:"Behavior",defaultValue:false},growingMaxLines:{type:"int",group:"Behavior",defaultValue:0},placeholder:{type:"string",group:"Appearance",defaultValue:"Post something here"},value:{type:"string",group:"Data",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},showIcon:{type:"boolean",group:"Behavior",defaultValue:true},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true},buttonTooltip:{type:"sap.ui.core.TooltipBase",group:"Accessibility",defaultValue:"Submit"},ariaLabelForPicture:{type:"string",group:"Accessibility",defaultValue:null}},events:{post:{parameters:{value:{type:"string"}}}}}});
c.prototype.init=function(){var o=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.setProperty("placeholder",o.getText("FEEDINPUT_PLACEHOLDER"),true);this.setProperty("buttonTooltip",o.getText("FEEDINPUT_SUBMIT"),true);};
c.prototype.exit=function(){if(this._oTextArea){this._oTextArea.destroy();}if(this._oButton){this._oButton.destroy();}if(this._oImageControl){this._oImageControl.destroy();}};
c.prototype.setIconDensityAware=function(i){this.setProperty("iconDensityAware",i,true);var f=sap.ui.require("sap/m/Image");if(this._getImageControl()instanceof f){this._getImageControl().setDensityAware(i);}return this;};
c.prototype.setRows=function(r){var m=this.getProperty("growingMaxLines");if(r>M){r=M;}else if(r<b){r=b;}if(r>m&&m!==0){this.setProperty("growingMaxLines",r,true);this._getTextArea().setGrowingMaxLines(r);}this.setProperty("rows",r,true);this._getTextArea().setRows(r);return this;};
c.prototype.setShowExceededText=function(v){this.setProperty("showExceededText",v,true);this._getTextArea().setShowExceededText(v);return this;};
c.prototype.setMaxLength=function(m){this.setProperty("maxLength",m,true);this._getTextArea().setMaxLength(m);return this;};
c.prototype.setGrowing=function(g){this.setProperty("growing",g,true);this._getTextArea().setGrowing(g);return this;};
c.prototype.setGrowingMaxLines=function(m){var r=this.getProperty("rows");if(m!==U){if(m<r){m=r;}else if(m>M){m=M;}}this.setProperty("growingMaxLines",m,true);this._getTextArea().setGrowingMaxLines(m);return this;};
c.prototype.setValue=function(v){this.setProperty("value",v,true);this._getTextArea().setValue(v);this._enablePostButton();return this;};
c.prototype.setPlaceholder=function(v){this.setProperty("placeholder",v,true);this._getTextArea().setPlaceholder(v);return this;};
c.prototype.setEnabled=function(e){this.setProperty("enabled",e,true);this._getTextArea().setEnabled(e);this._enablePostButton();return this;};
c.prototype.setButtonTooltip=function(v){this.setProperty("buttonTooltip",v,true);this._getPostButton().setTooltip(v);return this;};
c.prototype._getTextArea=function(){var t=this;if(!this._oTextArea){this._oTextArea=new T(this.getId()+"-textArea",{value:this.getValue(),maxLength:this.getMaxLength(),placeholder:this.getPlaceholder(),growing:this.getGrowing(),growingMaxLines:this.getGrowingMaxLines(),showExceededText:this.getShowExceededText(),rows:this.getRows(),liveChange:q.proxy(function(e){var v=e.getParameter("value");this.setProperty("value",v,true);this._enablePostButton();},this)});this._oTextArea.setParent(this);this._oTextArea.addEventDelegate({onAfterRendering:function(){t.$("counterContainer").empty();t.$("counterContainer").html(t._oTextArea.getAggregation("_counter").$());}});}return this._oTextArea;};
c.prototype._getPostButton=function(){if(!this._oButton){this._oButton=new B(this.getId()+"-button",{enabled:false,type:a.Default,icon:"sap-icon://feeder-arrow",tooltip:this.getButtonTooltip(),press:q.proxy(function(){this._oTextArea.focus();this.firePost({value:this.getValue()});this.setValue(null);},this)});this._oButton.setParent(this);}return this._oButton;};
c.prototype._enablePostButton=function(){var p=this._isControlEnabled();var o=this._getPostButton();o.setEnabled(p);};
c.prototype._isControlEnabled=function(){var v=this.getValue();return this.getEnabled()&&q.type(v)==="string"&&v.trim().length>0;};
c.prototype._getImageControl=function(){var i=this.getIcon()||I.getIconURI("person-placeholder"),s=this.getId()+'-icon',p={src:i,alt:this.getAriaLabelForPicture(),densityAware:this.getIconDensityAware(),decorative:false,useIconTooltip:false},d=['sapMFeedInImage'];this._oImageControl=l.ImageHelper.getImageControl(s,this._oImageControl,this,p,d);return this._oImageControl;};
return c;});
sap.ui.predefine('sap/m/FeedInputRenderer',[],function(){"use strict";var F={};
F.render=function(r,c){var m=c.getId();r.write("<div");r.writeControlData(c);r.addClass("sapMFeedInBase");r.writeClasses();r.write(">");r.write('<div id="'+m+'-outerContainer"');r.addClass("sapMFeedIn");if(!c.getShowIcon()){r.addClass("sapMFeedInNoIcon");}if(!c.getEnabled()){r.addClass("sapMFeedInDisabled");}r.writeClasses();r.write(">");if(!!c.getShowIcon()){this._addImage(r,c,m);}r.write('<div id="'+m+'-container"');r.addClass("sapMFeedInContainer");r.writeClasses();r.write(">");var t=c._getTextArea();r.renderControl(t);r.renderControl(c._getPostButton());r.write("</div>");r.write("</div>");r.write('<div id="'+m+'-counterContainer"');r.addClass("sapMFeedInCounter");r.writeClasses();r.write(">");r.write("</div>");r.write("</div>");};
F._addImage=function(r,c,m){r.write('<figure id="'+m+'-figure" class ="sapMFeedInFigure');if(!!c.getIcon()){r.write('">');}else{r.write(' sapMFeedListItemIsDefaultIcon">');}r.renderControl(c._getImageControl());r.write('</figure>');};
return F;},true);
sap.ui.predefine('sap/m/FeedListItem',["./ListItemBase","./Link","./library","./FormattedText","sap/ui/core/Control","sap/ui/core/IconPool","sap/m/Button","sap/ui/Device","./FeedListItemRenderer"],function(L,a,l,F,C,I,B,D,b){"use strict";var c=l.ListType;var d=l.ImageHelper;var e=l.LinkConversion;var f=l.ButtonType;
var g=L.extend("sap.m.FeedListItem",{metadata:{library:"sap.m",designtime:"sap/m/designtime/FeedListItem.designtime",properties:{icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},activeIcon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},sender:{type:"string",group:"Data",defaultValue:null},text:{type:"string",group:"Data",defaultValue:null},moreLabel:{type:"string",group:"Data",defaultValue:null},lessLabel:{type:"string",group:"Data",defaultValue:null},info:{type:"string",group:"Data",defaultValue:null},timestamp:{type:"string",group:"Data",defaultValue:null},senderActive:{type:"boolean",group:"Behavior",defaultValue:true},iconActive:{type:"boolean",group:"Behavior",defaultValue:true},iconDensityAware:{type:"boolean",defaultValue:true},showIcon:{type:"boolean",group:"Behavior",defaultValue:true},convertLinksToAnchorTags:{type:"sap.m.LinkConversion",group:"Behavior",defaultValue:e.None},convertedLinksDefaultTarget:{type:"string",group:"Behavior",defaultValue:"_blank"},maxCharacters:{type:"int",group:"Behavior",defaultValue:null}},defaultAggregation:"actions",aggregations:{actions:{type:"sap.m.FeedListItemAction",multiple:true},_text:{type:"sap.m.FormattedText",multiple:false,visibility:"hidden"},_actionSheet:{type:"sap.m.ActionSheet",multiple:false,visibility:"hidden"},_actionButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},events:{senderPress:{parameters:{domRef:{type:"string"},getDomRef:{type:"function"}}},iconPress:{parameters:{domRef:{type:"string"},getDomRef:{type:"function"}}}}}});
g._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");g._nMaxCharactersMobile=300;g._nMaxCharactersDesktop=500;g._sTextShowMore=g._oRb.getText("TEXT_SHOW_MORE");g._sTextShowLess=g._oRb.getText("TEXT_SHOW_LESS");
g.prototype.init=function(){L.prototype.init.apply(this);this.setAggregation("_text",new F(this.getId()+"-formattedText"),true);this.setAggregation("_actionButton",new B({id:this.getId()+"-actionButton",type:f.Transparent,icon:"sap-icon://overflow",press:[this._onActionButtonPress,this]}),true);};
g.prototype._onActionButtonPress=function(){sap.ui.require(["sap/m/ActionSheet"],this._openActionSheet.bind(this));};
g.prototype._openActionSheet=function(A){var o=this.getAggregation("_actionSheet");var h=this.getActions();var j;if(!(o&&o instanceof A)){o=new A({id:this.getId()+"-actionSheet",beforeOpen:[this._onBeforeOpenActionSheet,this]});this.setAggregation("_actionSheet",o,true);}o.destroyAggregation("buttons",true);for(var i=0;i<h.length;i++){j=h[i];o.addButton(new B({icon:j.getIcon(),text:j.getText(),press:j.firePress.bind(j,{"item":this})}));}o.openBy(this.getAggregation("_actionButton"));};
g.prototype._onBeforeOpenActionSheet=function(h){var A,t;if(D.system.phone){return;}t=sap.ui.getCore().getConfiguration().getTheme();A=h.getSource().getParent();A.removeStyleClass("sapContrast sapContrastPlus");if(t==="sap_belize"){A.addStyleClass("sapContrast");}else if(t==="sap_belize_plus"){A.addStyleClass("sapContrastPlus");}};
g.prototype.invalidate=function(){C.prototype.invalidate.apply(this,arguments);var m=g._sTextShowMore;if(this.getMoreLabel()){m=this.getMoreLabel();}delete this._bTextExpanded;if(this._oLinkExpandCollapse){this._oLinkExpandCollapse.setProperty("text",m,true);}};
g.prototype.onBeforeRendering=function(){this.$("realtext").find('a[target="_blank"]').off("click");var o=this.getAggregation("_text");o.setProperty("convertLinksToAnchorTags",this.getConvertLinksToAnchorTags(),true);o.setProperty("convertedLinksDefaultTarget",this.getConvertedLinksDefaultTarget(),true);if(this.getConvertLinksToAnchorTags()===l.LinkConversion.None){o.setHtmlText(this.getText());}else{o.setProperty("htmlText",this.getText(),true);}this._sFullText=o._getDisplayHtml().replace(/\n/g,"<br>");this._sShortText=this._getCollapsedText();this._bEmptyTagsInShortTextCleared=false;};
g.prototype.onAfterRendering=function(){if(this._checkTextIsExpandable()&&!this._bTextExpanded){this._clearEmptyTagsInCollapsedText();}var r=this.$("realtext");F.prototype.onAfterRendering.apply({$:function(){return r;}});};
g.prototype.exit=function(){this.$("realtext").find('a[target="_blank"]').off("click");if(this._oLinkControl){this._oLinkControl.destroy();}if(this._oImageControl){this._oImageControl.destroy();}if(this._oLinkExpandCollapse){this._oLinkExpandCollapse.destroy();}L.prototype.exit.apply(this);};
g.prototype.ontap=function(E){if(E.srcControl){if((!this.getIconActive()&&this._oImageControl&&E.srcControl.getId()===this._oImageControl.getId())||(!this.getSenderActive()&&this._oLinkControl&&E.srcControl.getId()===this._oLinkControl.getId())||(!this._oImageControl||(E.srcControl.getId()!==this._oImageControl.getId())&&(!this._oLinkControl||(E.srcControl.getId()!==this._oLinkControl.getId()))&&(!this._oLinkExpandCollapse||(E.srcControl.getId()!==this._oLinkExpandCollapse.getId())))){L.prototype.ontap.apply(this,[E]);}}};
g.prototype.onfocusin=function(E){if(this._oImageControl){var $=this.$("icon");if(E.target.id===this.getId()){$.removeAttr("alt");}else{$.attr("alt"," ");}}var i=E.srcControl,o=i.getDomRef(),p=this.getParent().getAccessbilityPosition(i);if(i instanceof sap.m.FeedListItem){o.setAttribute("aria-posinset",p.posInset);o.setAttribute("aria-setsize",p.setSize);}};
g.prototype._getImageControl=function(){var i=this.getIcon();var s=i?i:I.getIconURI("person-placeholder");var h=this.getId()+'-icon';var p={src:s,alt:this.getSender(),densityAware:this.getIconDensityAware(),decorative:false,useIconTooltip:false};var j;if(this.getIconActive()){j=['sapMFeedListItemImage'];}else{j=['sapMFeedListItemImageInactive'];}var t=this;this._oImageControl=d.getImageControl(h,this._oImageControl,this,p,j);if(this.getIconActive()){this._oImageControl.attachPress(function(){t.fireIconPress({domRef:this.getDomRef(),getDomRef:this.getDomRef.bind(this)});});}return this._oImageControl;};
g.prototype._getLinkSender=function(w){if(!this._oLinkControl){var t=this;this._oLinkControl=new a({press:function(){t.fireSenderPress({domRef:this.getDomRef(),getDomRef:this.getDomRef.bind(this)});}});this._oLinkControl.setParent(this,null,true);}if(w){this._oLinkControl.setProperty("text",this.getSender()+g._oRb.getText("COLON"),true);}else{this._oLinkControl.setProperty("text",this.getSender(),true);}this._oLinkControl.setProperty("enabled",this.getSenderActive(),true);return this._oLinkControl;};
g.prototype._activeHandlingInheritor=function(){var A=this.getActiveIcon();if(this._oImageControl&&A){this._oImageControl.setSrc(A);}};
g.prototype._inactiveHandlingInheritor=function(){var s=this.getIcon()?this.getIcon():I.getIconURI("person-placeholder");if(this._oImageControl){this._oImageControl.setSrc(s);}};
g.prototype._getCollapsedText=function(){this._nMaxCollapsedLength=this.getMaxCharacters();if(this._nMaxCollapsedLength===0){if(D.system.phone){this._nMaxCollapsedLength=g._nMaxCharactersMobile;}else{this._nMaxCollapsedLength=g._nMaxCharactersDesktop;}}var p=this._convertHtmlToPlainText(this._sFullText);var t=null;if(p&&p.length>this._nMaxCollapsedLength){var s=p.substring(0,this._nMaxCollapsedLength);var n=s.lastIndexOf(" ");if(n>0){s=s.substr(0,n);}if(p.length===this._sFullText.length){t=s;}else{t=this._convertPlainToHtmlText(s);}}return t;};
g.prototype._clearEmptyTagsInCollapsedText=function(){var r;if(this._bEmptyTagsInShortTextCleared){return;}this._bEmptyTagsInShortTextCleared=true;do{r=this.$("realtext").find(":empty").remove();}while(r.length>0);this._sShortText=this.$("realtext").html();};
g.prototype._toggleTextExpanded=function(){var $=this.$("realtext");var h=this.$("threeDots");var m=g._sTextShowMore;var s=g._sTextShowLess;if(this.getMoreLabel()){m=this.getMoreLabel();}if(this.getLessLabel()){s=this.getLessLabel();}if(this._bTextExpanded){$.html(this._sShortText.replace(/&#xa;/g,"<br>"));h.text(" ... ");this._oLinkExpandCollapse.setText(m);this._bTextExpanded=false;this._clearEmptyTagsInCollapsedText();}else{$.html(this._sFullText.replace(/&#xa;/g,"<br>"));h.text("  ");this._oLinkExpandCollapse.setText(s);this._bTextExpanded=true;}};
g.prototype._getLinkExpandCollapse=function(){var m=g._sTextShowMore;if(this.getMoreLabel()){m=this.getMoreLabel();}if(!this._oLinkExpandCollapse){this._oLinkExpandCollapse=new a({text:m,press:[this._toggleTextExpanded,this]});this._bTextExpanded=false;this._oLinkExpandCollapse.setParent(this,null,true);}return this._oLinkExpandCollapse;};
g.prototype._convertHtmlToPlainText=function(h){var r=/(<([^>]+)>)/ig;return h.replace(r,"");};
g.prototype._convertPlainToHtmlText=function(h){var s=this._sFullText;var r=/(<([^>]+)>)/ig;var E=s.split(r);var t="";for(var i=0;i<E.length;i++){if(E[i].length===0){continue;}if(h.length>0&&E[i].indexOf(h.trim())!==-1){E[i]=h;}if(/^<.+>$/.test(E[i])){t=t+E[i];E[i+1]="";continue;}if(h.indexOf(E[i].trim())===-1){continue;}else{h=h.replace(E[i],"");}t=t+E[i];}return t;};
g.prototype._checkTextIsExpandable=function(){return this._sShortText!==null;};
g.prototype.setType=function(t){if(this.getType()!==t){if(t===c.Navigation){this.setProperty("type",c.Active);}else{this.setProperty("type",t);}}return this;};
return g;});
sap.ui.predefine('sap/m/FeedListItemAction',["sap/ui/core/Element"],function(E){"use strict";
var F=E.extend("sap.m.FeedListItemAction",{metadata:{library:"sap.m",properties:{icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:""},key:{type:"string",group:"Misc",defaultValue:""}},events:{press:{}}}});
return F;});
sap.ui.predefine('sap/m/FeedListItemRenderer',["./ListItemBaseRenderer","sap/ui/core/Renderer","sap/ui/Device"],function(L,R,D){"use strict";var F=R.extend(L);
F.renderLIAttributes=function(r,c){r.addClass("sapMFeedListItemTitleDiv");r.addClass("sapMFeedListShowSeparatorsAll");};
F.renderLIContent=function(r,c){var m=c.getId(),i=D.system.phone;r.write('<div');r.addClass('sapMFeedListItem');r.writeClasses();r.write('>');if(c.getShowIcon()){this._writeImageControl(r,c,m);}if(c.getActions().length>0){r.write("<div");r.writeAttributeEscaped("id",m+"-action-button");r.addClass('sapMFeedListItemActionButton');r.writeClasses();r.write(">");r.renderControl(c.getAggregation("_actionButton"));r.write("</div>");}if(i){r.write('<div class= "sapMFeedListItemHeader sapUiSelectable ');if(c.getShowIcon()){r.write('sapMFeedListItemHasFigure ');}if(c.getSender()&&c.getTimestamp()){r.write('sapMFeedListItemFullHeight');}r.write('" >');if(c.getSender()){r.write('<p id="'+m+'-name" class="sapMFeedListItemTextName sapUiSelectable">');r.renderControl(c._getLinkSender(false));r.write('</p>');}if(c.getTimestamp()){r.write('<p id="'+m+'-timestamp" class="sapMFeedListItemTimestamp sapUiSelectable">');r.writeEscaped(c.getTimestamp());r.write('</p>');}r.write('</div>');r.write('<div class="sapMFeedListItemText sapUiSelectable">');this._writeText(r,c,m,i);if(c._checkTextIsExpandable()){this._writeCollapsedText(r,c,m);}else{r.write(c._sFullText);r.write('</span>');}r.write('</div>');if(c.getInfo()){r.write('<p class="sapMFeedListItemFooter sapUiSelectable">');if(c.getInfo()){r.write('<span id="'+m+'-info" class="sapMFeedListItemInfo sapUiSelectable">');r.writeEscaped(c.getInfo());r.write('</span>');}r.write('</p>');}}else{r.write('<div class= "sapMFeedListItemText ');if(c.getShowIcon()){r.write('sapMFeedListItemHasFigure');}r.write('" >');r.write('<div id="'+m+'-text" class="sapMFeedListItemTextText sapUiSelectable">');if(c.getSender()){r.write('<span id="'+m+'-name" class="sapMFeedListItemTextName sapUiSelectable">');r.renderControl(c._getLinkSender(true));r.write('</span>');}this._writeText(r,c,m,i);if(c._checkTextIsExpandable()){this._writeCollapsedText(r,c,m);}else{r.write(c._sFullText);r.write('</span>');}r.write('</div>');if(c.getInfo()||c.getTimestamp()){r.write('<p class="sapMFeedListItemFooter sapUiSelectable">');if(!sap.ui.getCore().getConfiguration().getRTL()){if(c.getInfo()){this._writeInfo(r,c,m);if(c.getTimestamp()){r.write("<span>&#160&#160&#x00B7&#160&#160</span>");}}if(c.getTimestamp()){this._writeTimestamp(r,c,m);}}else{if(c.getTimestamp()){this._writeTimestamp(r,c,m);}if(c.getInfo()){if(c.getTimestamp()){r.write("<span>&#160&#160&#x00B7&#160&#160</span>");}this._writeInfo(r,c,m);}}r.write('</p>');}r.write('</div>');}r.write('</div>');};
F._writeImageControl=function(r,c,i){r.write('<figure id="'+i+'-figure"');r.addClass('sapMFeedListItemFigure');if(!c.getIcon()){r.addClass('sapMFeedListItemIsDefaultIcon');}r.writeClasses();r.write('>');r.renderControl(c._getImageControl());r.write('</figure>');};
F._writeCollapsedText=function(r,c,i){if(c._bTextExpanded){r.write(c._sFullText);r.write('</span>');r.write('<span id="'+i+'-threeDots" class ="sapMFeedListItemTextString">');r.write("&#32");r.write('</span>');}else{r.write(c._sShortText);r.write('</span>');r.write('<span id="'+i+'-threeDots" class ="sapMFeedListItemTextString">');r.write("&#32&#46&#46&#46&#32");r.write('</span>');}var l=c._getLinkExpandCollapse();l.addStyleClass("sapMFeedListItemLinkExpandCollapse");r.renderControl(l);};
F._writeTimestamp=function(r,c,i){r.write('<span id="'+i+'-timestamp"');r.addClass('sapMFeedListItemTimestampText');r.addClass('sapUiSelectable');if(c.getUnread()){r.addClass('sapMFeedListItem-Unread');}r.writeClasses();r.write(">");r.writeEscaped(c.getTimestamp());r.write('</span>');};
F._writeInfo=function(r,c,i){r.write('<span id="'+i+'-info"');r.addClass('sapMFeedListItemInfoText');r.addClass('sapUiSelectable');if(c.getUnread()){r.addClass('sapMFeedListItem-Unread');}r.writeClasses();r.write(">");r.writeEscaped(c.getInfo());r.write('</span>');};
F._writeText=function(r,c,i,I){r.write('<span id="'+i+'-realtext"');I?r.addClass('sapMFeedListItemText'):r.addClass('sapMFeedListItemTextString');r.addClass('sapMFeedListItemText');r.addClass('sapUiSelectable');if(c.getUnread()){r.addClass('sapMFeedListItem-Unread');}r.writeClasses();r.write(">");};
return F;},true);
sap.ui.predefine('sap/m/Fiori20Adapter',['sap/ui/base/Object','sap/ui/base/EventProvider','sap/ui/base/ManagedObjectObserver','sap/ui/Device',"sap/base/Log","sap/ui/thirdparty/jquery"],function(O,E,M,D,L,q){"use strict";var e=new E(),i,c;
var H=O.extend("HeaderAdapter",{constructor:function(o,A){if(!o||!A){L.error("Cannot initialize: Invalid arguments.");return;}this._oHeader=o;this._oStyledPage=null;this._oTitleInfo=null;this._oSubTitleInfo=null;this._oBackButtonInfo=null;this._oAdaptOptions=A;}});
H.prototype.adapt=function(){var s=this._oAdaptOptions.bStylePage,C=this._oAdaptOptions.bCollapseHeader;if(s){this._toggleStyle("sapF2Adapted",true,true);}this._adaptTitle();this._adaptBackButton();if(C){this._collapseHeader();}return this.getAdaptedContent();};
H.prototype.getAdaptedContent=function(){return{oTitleInfo:this._oTitleInfo,oSubTitleInfo:this._oSubTitleInfo,oBackButtonInfo:this._oBackButtonInfo,oStyledPage:this._oStyledPage};};
H.prototype._adaptTitle=function(){if(!H._isAdaptableHeader(this._oHeader)||this._oAdaptOptions.bMoveTitle!==true){return false;}this._oTitleInfo=this._detectTitle();this._oSubTitleInfo=this._detectSubTitle();var s=!!this._oTitleInfo||!!this._oSubTitleInfo;if(this._oTitleInfo){this._oTitleInfo.oControl.toggleStyleClass("sapF2AdaptedTitle",true);}return s;};
H.prototype._adaptBackButton=function(){if(!H._isAdaptableHeader(this._oHeader)||this._oAdaptOptions.bHideBackButton!==true){return false;}var j,B=false;this._oBackButtonInfo=this._detectBackButton();if(this._oBackButtonInfo){j=this._oBackButtonInfo.oControl.getVisible();this._oBackButtonInfo.oControl.toggleStyleClass("sapF2AdaptedNavigation",j);B=true;}return B;};
H.prototype._toggleStyle=function(s,A,S){var p=this._oHeader.getParent();if(!p){return;}this._oStyledPage=p;if(A===true){p.addStyleClass(s,S);}else if(A===false){p.removeStyleClass(s,S);}else if(A===undefined){p.hasStyleClass(s)?p.removeStyleClass(s,S):p.addStyleClass(s,S);}};
H._isAdaptableHeader=function(o){if(!o||!f(o,"sap/m/Bar")){return false;}var p=o.getParent();return p&&(f(p,"sap/m/Page")||f(p,"sap/m/MessagePage")||f(p,"sap/uxap/ObjectPageHeader"));};
H.prototype._detectTitle=function(){var t;if(H._isAdaptableHeader(this._oHeader)){var m=this._oHeader.getContentMiddle();if(m.length===1&&a(m[0])){var T=m[0];t={id:T.getId(),text:T.getText(),oControl:T,sChangeEventId:"_change",sPropertyName:"text"};}}return t;};
H.prototype._detectSubTitle=function(p){if(f(p,"sap/uxap/ObjectPageHeader")){var o=p.getHeaderTitle();if(o){return{id:o.getId(),text:o.getObjectTitle(),oControl:o,sChangeEventId:"_titleChange",sPropertyName:"objectTitle"};}}};
H.prototype._detectBackButton=function(){var B,o;if(H._isAdaptableHeader(this._oHeader)){B=this._oHeader.getContentLeft();if(B.length>0&&f(B[0],"sap/m/Button")&&(B[0].getType()==="Back"||B[0].getType()==="Up"||B[0].getIcon()==="sap-icon://nav-back")){o=B[0];return{id:o.getId(),oControl:o,sChangeEventId:"_change",sPropertyName:"visible"};}}};
H.prototype._collapseHeader=function(){var t=this._oTitleInfo,B=this._oBackButtonInfo,j,m,k,l,n,o,A;if(H._isAdaptableHeader(this._oHeader)){j=this._oHeader.getContentLeft();m=this._oHeader.getContentMiddle();k=this._oHeader.getContentRight();l=(j.length===1)&&(h(j[0])||B);n=(m.length===1)&&(h(m[0])||t);o=(k.length===1)&&h(k[0]);A=(j.length===0||l)&&(m.length===0||n)&&((k.length===0)||o);this._toggleStyle("sapF2CollapsedHeader",A,true);}};
var F=O.extend("sap.m.Fiori20Adapter",{});
F.attachViewChange=function(l,o){e.attachEvent("adaptedViewChange",l,o);};
F.detachViewChange=function(l,o){e.detachEvent("adaptedViewChange",l,o);};
F.traverse=function(C,A){i={aViewTitles:{},aViewSubTitles:{},aViewBackButtons:{},aChangeListeners:{}};c=null;this._doBFS([{oNode:C,oAdaptOptions:A}]);if(this._getCurrentlyAdaptedTopViewId()){this._fireViewChange(this._getCurrentlyAdaptedTopViewId(),A);}};
F._doBFS=function(Q){var n=Q.shift();if(!n){return;}var N=n.oNode,A=n.oAdaptOptions,s=A.iSearchDepth;A=this._applyRules(A,N);if(!this._isAdaptationRequired(N,A)||(s<=0)){return;}var I=this._isTopNavigableView(N);if(I){this._setAsCurrentlyAdaptedTopViewId(N.getId());}var o=this._processNode(N,A);var C=this._getNodeChildren(N),j=q.extend({},A,{iSearchDepth:this._updateSearchDepth(s,N)});if(o){var t=!!o.oTitleInfo,B=!!o.oBackButton,p=!!o.oStyledPage;j=q.extend(j,{bMoveTitle:A.bMoveTitle&&!t,bHideBackButton:A.bHideBackButton&&!B,bStylePage:A.bStylePage&&!p});}C.forEach(function(k){if(k){Q.push({oNode:k,oAdaptOptions:j});}});this._doBFS(Q);};
F._processNode=function(C,A){this._attachDefferedAdaptationListeners(C,A);if(H._isAdaptableHeader(C)){return this._adaptHeader(C,A);}if(C.getParent()&&f(C.getParent(),"sap/m/NavContainer")){return this._getCachedViewInfoToMerge(C.getId());}};
F._attachDefferedAdaptationListeners=function(C,A){this._attachAdaptableContentChange(C,A);this._attachNavigablePageChange(C,A);if(f(C,"sap/m/Page")||f(C,"sap/ui/core/mvc/XMLView")){this._attachModifyAggregation(C,"content",A);}if((A.bLateAdaptation===true)&&f(C,"sap/m/Bar")){this._attachModifyAggregation(C,"contentLeft",A,C);this._attachModifyAggregation(C,"contentMiddle",A,C);this._attachModifyAggregation(C,"contentRight",A,C);}if(f(C,"sap/ui/core/ComponentContainer")){var o=C.getComponentInstance();if(!o&&C.getName()&&!C.getDomRef()){var t=this;var j={onBeforeRendering:function(){C.removeEventDelegate(j);t._doBFS([{oNode:C.getComponentInstance(),oAdaptOptions:A}]);if(t._getCurrentlyAdaptedTopViewId()){t._fireViewChange(t._getCurrentlyAdaptedTopViewId(),A);}}};C.addEventDelegate(j,this);}}};
F._checkHasListener=function(k){return i.aChangeListeners[k];};
F._setHasListener=function(k,v){i.aChangeListeners[k]=v;};
F._attachAdaptableContentChange=function(C,A){if(!C._getAdaptableContent||!q.isFunction(C._getAdaptableContent)){return;}var k=C.getId()+"_adaptableContentChange";if(this._checkHasListener(k)){return;}var o=this._getCurrentlyAdaptedTopViewId();var j=function(l){var m=l.getParameter("adaptableContent");this._setAsCurrentlyAdaptedTopViewId(o);this._doBFS([{oNode:m,oAdaptOptions:A}]);if(this._getCurrentlyAdaptedTopViewId()){this._fireViewChange(this._getCurrentlyAdaptedTopViewId(),A);}}.bind(this);C.attachEvent("_adaptableContentChange",j);this._setHasListener(k,j);};
F._attachNavigablePageChange=function(C,A){if(!f(C,"sap/m/NavContainer")){return;}var k=C.getId()+"navigate";if(this._checkHasListener(k)){return;}var o=function(j){var n=j.getParameter("to");A=this._applyRules(A,n);this._doBFS([{oNode:n,oAdaptOptions:A}]);if(this._getCurrentlyAdaptedTopViewId()){this._fireViewChange(this._getCurrentlyAdaptedTopViewId(),A);}}.bind(this);C.attachNavigate(o);this._setHasListener(k,o);};
F._attachModifyAggregation=function(C,A,o,j){var k=C.getId()+A;if(this._checkHasListener(k)){return;}var l=this._getCurrentlyAdaptedTopViewId(),m=function(p){var s=p.mutation,r=p.object;if((s==="add")||(s==="insert")){this._setAsCurrentlyAdaptedTopViewId(l);this._doBFS([{oNode:j?j:r,oAdaptOptions:o}]);if(this._getCurrentlyAdaptedTopViewId()){this._fireViewChange(this._getCurrentlyAdaptedTopViewId(),o);}}}.bind(this),n=new M(m);n.observe(C,{aggregations:[A]});this._setHasListener(k,n);};
F._getNodeChildren=function(C){if(C._getAdaptableContent&&q.isFunction(C._getAdaptableContent)){var j=[C._getAdaptableContent()];if(f(C,"sap/m/Page")){j=j.concat(C.getContent());}return j;}if(f(C,"sap/m/SplitContainer")){return[].concat(C.getAggregation("_navMaster"),C.getAggregation("_navDetail"));}if(f(C,"sap/uxap/ObjectPageLayout")){return[C.getHeaderTitle()];}if(f(C,"sap/ui/core/ComponentContainer")){return[C.getComponentInstance()];}if(f(C,"sap/ui/core/UIComponent")){return[C.getAggregation("rootControl")];}return C.findAggregatedObjects(false,g);};
F._updateSearchDepth=function(s,C){if(f(C,"sap/ui/core/mvc/View")||f(C,"sap/ui/core/Component")||f(C,"sap/ui/core/ComponentContainer")){return s;}return s-1;};
F._getTotalCachedInfoToMerge=function(v){var V=sap.ui.getCore().byId(v),C=this._getCachedViewInfoToMerge(v),j,k,s,S,o,p,l;if(!D.system.phone&&this._isTopSplitContainerSubView(V)){p=V.getParent();o=p&&p.getParent();if(o){j=o._oMasterNav&&(o._oMasterNav.getId()===p.getId());k=o._oDetailNav&&(o._oDetailNav.getId()===p.getId());}}if(j){s=o.getCurrentDetailPage();S=s&&s.getId();l=this._getCachedViewInfoToMerge(S);C=this._mergeSplitViewInfos(C,l);}if(k){s=o.getCurrentMasterPage();S=s&&s.getId();l=this._getCachedViewInfoToMerge(S);C=this._mergeSplitViewInfos(l,C);}C.sViewId=(j||k)?o.getId():v;return C;};
F._isTopSplitContainerSubView=function(C){var p=C&&C.getParent();return this._isTopmostNavContainer(p)&&f(p.getParent(),"sap/m/SplitContainer");};
F._mergeSplitViewInfos=function(m,o){q.each(m,function(k,v){m[k]=v||o[k];});return m;};
F._getCachedViewInfoToMerge=function(v){var B=(i.aViewBackButtons[v])?i.aViewBackButtons[v].oControl:undefined;return{oTitleInfo:i.aViewTitles[v],oSubTitleInfo:i.aViewSubTitles[v],oBackButton:B};};
F._applyRules=function(A,C){var p=C.getParent();if(f(p,"sap/m/SplitContainer")){var I=D.system.phone,m=A.bMoveTitle,j=A.bHideBackButton;if(m){m=I;}if(j&&!D.system.phone){j='initialPage';}return q.extend({},A,{bMoveTitle:m,bHideBackButton:j});}if(f(p,"sap/m/NavContainer")){if(A.bHideBackButton==='initialPage'){var k=p._getActualInitialPage()&&(p._getActualInitialPage().getId()===C.getId());return q.extend({},A,{bHideBackButton:k});}}if((A.bMoveTitle===false)||(A.bHideBackButton===false)){return q.extend({},A,{bCollapseHeader:false});}return A;};
F._getCurrentlyAdaptedTopViewId=function(){return c;};
F._setAsCurrentlyAdaptedTopViewId=function(v){c=v;};
F._isTopNavigableView=function(n){var p=n.getParent();return p&&this._isTopmostNavContainer(p);};
F._isTopmostNavContainer=function(C){var o,n=C;while(n){if(f(n,"sap/m/NavContainer")){o=n;}n=n.getParent();}return o&&(o.getId()===C.getId());};
F._adaptHeader=function(o,A){if(!o||!A){return;}var j=new H(o,A),k=j.adapt();var t=this._getCurrentlyAdaptedTopViewId();if(k.oTitleInfo){i.aViewTitles[t]=k.oTitleInfo;this._registerTextChangeListener(i.aViewTitles,t,A);}if(k.oSubTitleInfo){i.aViewSubTitles[t]=k.oSubTitleInfo;this._registerTextChangeListener(i.aViewSubTitles,t,A);}if(k.oBackButtonInfo){if(k.oBackButtonInfo.oControl.getVisible()){i.aViewBackButtons[t]=k.oBackButtonInfo;}this._registerVisibilityChangeListener(k.oBackButtonInfo,i.aViewBackButtons,t,A);}return k;};
F._registerTextChangeListener=function(t,v,A){var T=t[v];if(T&&T.oControl&&T.sChangeEventId&&!i.aChangeListeners[T.id]){var C=function(o){var T=t[v];if(o.getParameter("name")!==T.sPropertyName){return;}T.text=o.getParameter("newValue");this._fireViewChange(v,A);}.bind(this);T.oControl.attachEvent(T.sChangeEventId,C);i.aChangeListeners[T.id]=C;}};
F._registerVisibilityChangeListener=function(C,j,v,A){var V;if(C&&C.oControl&&C.sChangeEventId&&!i.aChangeListeners[C.id]){var k=function(o){if(o.getParameter("name")!==C.sPropertyName){return;}V=o.getParameter("newValue");if(!V){q.each(j,function(I,l){if(l.oControl.getId()===C.oControl.getId()){delete j[I];}});}var p=C.oControl.getParent();if(H._isAdaptableHeader(p)){F._adaptHeader(p,A);this._fireViewChange(v,A);}}.bind(this);C.oControl.attachEvent(C.sChangeEventId,k);i.aChangeListeners[C.id]=k;}};
F._fireViewChange=function(v,A){var t=this._getTotalCachedInfoToMerge(v);t.oAdaptOptions=A;e.fireEvent("adaptedViewChange",t);};
F._isAdaptationRequired=function(n,A){if(!n||this._isNonAdaptableControl(n)){return false;}for(var o in A){if(A.hasOwnProperty(o)&&((A[o]===true)||(A[o]==="initialPage"))){return true;}}return false;};
F._isNonAdaptableControl=function(C){return b(C);};
function a(C){return d(C,["sap/m/Label","sap/m/Text","sap/m/Title"]);}
function b(C){return d(C,["sap/m/List","sap/m/Table","sap/ui/table/Table","sap/ui/table/TreeTable"]);}
function d(C,t){if(!C||!t){return;}return t.some(function(T){return f(C,T);});}
function f(C,t){var T=sap.ui.require(t);return T&&(C instanceof T);}
function g(o){return o&&(o.sParentAggregationName!=="dependents");}
function h(o){return o&&(typeof o.getVisible==="function")&&(o.getVisible()===false);}
return F;});
sap.ui.predefine('sap/m/FlexBox',['./FlexBoxStylingHelper','./FlexItemData','./library','sap/ui/core/Control','sap/ui/core/RenderManager','./FlexBoxRenderer','sap/ui/thirdparty/jquery'],function(F,a,l,C,R,b,q){"use strict";var B=l.BackgroundDesign;var c=l.FlexAlignContent;var d=l.FlexWrap;var e=l.FlexAlignItems;var f=l.FlexJustifyContent;var g=l.FlexRendertype;var h=l.FlexDirection;
var j=C.extend("sap.m.FlexBox",{metadata:{library:"sap.m",properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},displayInline:{type:"boolean",group:"Appearance",defaultValue:false},direction:{type:"sap.m.FlexDirection",group:"Appearance",defaultValue:h.Row},fitContainer:{type:"boolean",group:"Appearance",defaultValue:false},renderType:{type:"sap.m.FlexRendertype",group:"Misc",defaultValue:g.Div},justifyContent:{type:"sap.m.FlexJustifyContent",group:"Appearance",defaultValue:f.Start},alignItems:{type:"sap.m.FlexAlignItems",group:"Appearance",defaultValue:e.Stretch},wrap:{type:"sap.m.FlexWrap",group:"Appearance",defaultValue:d.NoWrap},alignContent:{type:"sap.m.FlexAlignContent",group:"Appearance",defaultValue:c.Stretch},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:B.Transparent}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Control",multiple:true,singularName:"item"}},designtime:"sap/m/designtime/FlexBox.designtime",dnd:{draggable:false,droppable:true}}});
j.prototype.init=function(){if(this instanceof sap.m.HBox&&(this.getDirection()!==h.Row||this.getDirection()!==h.RowReverse)){this.setDirection('Row');}if(this instanceof sap.m.VBox&&(this.getDirection()!==h.Column||this.getDirection()!==h.ColumnReverse)){this.setDirection('Column');}this._oItemDelegate={onAfterRendering:this._onAfterItemRendering};};
j.prototype.addItem=function(i){this.addAggregation("items",i);this._onItemInserted(i);return this;};
j.prototype.insertItem=function(i,I){this.insertAggregation("items",i,I);this._onItemInserted(i);return this;};
j.prototype.removeItem=function(i){var I=this.removeAggregation("items",i);this._onItemRemoved(I);return I;};
j.prototype.removeAllItems=function(){var I=this.getItems();for(var i=0;i<I.length;i++){this._onItemRemoved(I[i]);}return this.removeAllAggregation("items");};
j.prototype._onItemInserted=function(i){if(i&&!(i instanceof j)){i.attachEvent("_change",this._onItemChange,this);if(this.getRenderType()===g.Bare){i.addEventDelegate(this._oItemDelegate,i);}}};
j.prototype._onItemRemoved=function(i){if(i&&!(i instanceof j)){i.detachEvent("_change",this._onItemChange,this);if(this.getRenderType()===g.Bare){i.removeEventDelegate(this._oItemDelegate,i);}}};
j.prototype._onItemChange=function(o){if(o.getParameter("name")!=="visible"||(this.getRenderType()!==g.List&&this.getRenderType()!==g.Div)){return;}var i=sap.ui.getCore().byId(o.getParameter("id")),w=null;if(i.getLayoutData()){w=q(document.getElementById(i.getLayoutData().getId()));}else{w=q(document.getElementById(R.createInvisiblePlaceholderId(i))).parent();}if(o.getParameter("newValue")){w.removeClass("sapUiHiddenPlaceholder").removeAttr("aria-hidden");}else{w.addClass("sapUiHiddenPlaceholder").attr("aria-hidden","true");}};
j.prototype._onAfterItemRendering=function(){var L=this.getLayoutData();if(L instanceof a){F.setFlexItemStyles(null,L);}};
j.prototype.setRenderType=function(v){var o=this.getRenderType(),i=this.getItems();if(v===o){return this;}this.setProperty("renderType",v);if(o==="Bare"){i.forEach(this._onItemRemoved,this);}if(v==="Bare"){i.forEach(this._onItemInserted,this);}return this;};
j.prototype.setDisplayInline=function(i){this.setProperty("displayInline",i,true);this.$().toggleClass("sapMFlexBoxInline",this.getDisplayInline());return this;};
j.prototype.setDirection=function(v){this.setProperty("direction",v,true);if(this.getDirection()===h.Column||this.getDirection()===h.ColumnReverse){this.$().removeClass("sapMHBox").addClass("sapMVBox");}else{this.$().removeClass("sapMVBox").addClass("sapMHBox");}if(this.getDirection()===h.RowReverse||this.getDirection()===h.ColumnReverse){this.$().addClass("sapMFlexBoxReverse");}else{this.$().removeClass("sapMFlexBoxReverse");}return this;};
j.prototype.setFitContainer=function(v){this.setProperty("fitContainer",v,true);this.$().toggleClass("sapMFlexBoxFit",this.getFitContainer());return this;};
j.prototype.setWrap=function(v){var o=this.getWrap();this.setProperty("wrap",v,true);this.$().removeClass("sapMFlexBoxWrap"+o).addClass("sapMFlexBoxWrap"+this.getWrap());return this;};
j.prototype.setJustifyContent=function(v){var o=this.getJustifyContent();this.setProperty("justifyContent",v,true);this.$().removeClass("sapMFlexBoxJustify"+o).addClass("sapMFlexBoxJustify"+this.getJustifyContent());return this;};
j.prototype.setAlignItems=function(v){var o=this.getAlignItems();this.setProperty("alignItems",v,true);this.$().removeClass("sapMFlexBoxAlignItems"+o).addClass("sapMFlexBoxAlignItems"+this.getAlignItems());return this;};
j.prototype.setAlignContent=function(v){var o=this.getAlignContent();this.setProperty("alignContent",v,true);this.$().removeClass("sapMFlexBoxAlignContent"+o).addClass("sapMFlexBoxAlignContent"+this.getAlignContent());return this;};
j.prototype.setHeight=function(v){this.setProperty("height",v,true);this.$().css("height",this.getHeight());return this;};
j.prototype.setWidth=function(v){this.setProperty("width",v,true);this.$().css("width",this.getWidth());return this;};
j.prototype.setBackgroundDesign=function(v){var o=this.getBackgroundDesign();this.setProperty("backgroundDesign",v,true);this.$().removeClass("sapMFlexBoxBG"+o).addClass("sapMFlexBoxBG"+this.getBackgroundDesign());return this;};
j.prototype.getAccessibilityInfo=function(){return{children:this.getItems()};};
return j;});
sap.ui.predefine('sap/m/FlexBoxCssPropertyMap',[],function(){"use strict";var F={'specie10':{'order':{'<number>':{'flex-order':'<number>'}},'flex-grow':{'<number>':{'flex-positive':'<number>','flex-preferred-size':'auto'}},'flex-shrink':{'<number>':{'flex-negative':'<number>'}},'flex-basis':{'<number>':{'flex-preferred-size':'<number>'}}}};return F;},true);
sap.ui.predefine('sap/m/FlexBoxRenderer',['./FlexBoxStylingHelper','sap/m/library',"sap/base/security/encodeXML","sap/base/Log"],function(F,l,e,L){"use strict";var a=l.FlexDirection;var b=l.FlexRendertype;var c={};
c.render=function(r,C){if(C.getRenderType()===b.List){r.write('<ul');}else{r.write('<div');}r.writeControlData(C);var p=C.getParent();if(p&&p.isA("sap.m.FlexBox")){r.addClass("sapMFlexItem");var o=C.getLayoutData();if(o instanceof sap.m.FlexItemData){F.setFlexItemStyles(r,o);}if(p.getRenderType()===b.List){r.write('<li');}}else if(C.getFitContainer()){r.addClass("sapMFlexBoxFit");}r.addClass("sapMFlexBox");if(C.getDisplayInline()){r.addClass("sapMFlexBoxInline");}if(C.getDirection()===a.Column||C.getDirection()===a.ColumnReverse){r.addClass("sapMVBox");}else{r.addClass("sapMHBox");}if(C.getDirection()===a.RowReverse||C.getDirection()===a.ColumnReverse){r.addClass("sapMFlexBoxReverse");}r.addClass("sapMFlexBoxJustify"+C.getJustifyContent());r.addClass("sapMFlexBoxAlignItems"+C.getAlignItems());r.addClass("sapMFlexBoxWrap"+C.getWrap());r.addClass("sapMFlexBoxAlignContent"+C.getAlignContent());r.addClass("sapMFlexBoxBG"+C.getBackgroundDesign());r.writeClasses();if(C.getHeight()){r.addStyle("height",C.getHeight());}if(C.getWidth()){r.addStyle("width",C.getWidth());}r.writeStyles();var t=C.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}r.write(">");c.renderItems(C,r);if(C.getRenderType()===b.List){r.write("</ul>");}else{r.write("</div>");}};
c.renderItems=function(C,r){var d=C.getItems(),w='';for(var i=0;i<d.length;i++){if(d[i].isA('sap.m.FlexBox')||C.getRenderType()===b.Bare){w="";}else if(C.getRenderType()===b.List){w="li";}else{w="div";}c.renderItem(d[i],w,r);}};
c.renderItem=function(i,w,r){if(w){r.write('<'+w);if(i instanceof sap.m.ScrollContainer){r.addClass("sapMFlexBoxScroll");}if(!i.getVisible()){r.addClass("sapUiHiddenPlaceholder");}}var o=i.getLayoutData();if(w&&!o){i.setAggregation("layoutData",new sap.m.FlexItemData(),true);o=i.getLayoutData();}if(!(o instanceof sap.m.FlexItemData)){if(o){L.warning(o+" set on "+i+" is not of type sap.m.FlexItemData");}}else{if(w&&o.getId()){r.writeAttributeEscaped("id",o.getId());}if(o.getStyleClass()){c.addItemClass(e(o.getStyleClass()),i,w,r);}c.addItemClass("sapMFlexItemAlign"+o.getAlignSelf(),i,w,r);c.addItemClass("sapMFlexBoxBG"+o.getBackgroundDesign(),i,w,r);if(w){F.setFlexItemStyles(r,o);}}c.addItemClass("sapMFlexItem",i,w,r);if(w){r.writeStyles();r.writeClasses();r.write(">");}r.renderControl(i);if(w){r.write('</'+w+'>');}};
c.addItemClass=function(C,i,w,r){if(w){r.addClass(C);}else{i.addStyleClass(C);}};
return c;},true);
sap.ui.predefine('sap/m/FlexBoxStylingHelper',['./FlexBoxCssPropertyMap','sap/ui/Device'],function(F,D){"use strict";var a={};
a.setFlexItemStyles=function(r,l){r=r||null;var o=''+l.getOrder(),g=''+l.getGrowFactor(),s=''+l.getShrinkFactor(),b=l.getBaseSize().toLowerCase(),m=l.getMinHeight(),M=l.getMaxHeight(),c=l.getMinWidth(),d=l.getMaxWidth();if(typeof o!=='undefined'){a.setStyle(r,l,"order",o);}if(typeof g!=='undefined'){a.setStyle(r,l,"flex-grow",g);}if(typeof s!=='undefined'){a.setStyle(r,l,"flex-shrink",s);}if(typeof b!=='undefined'){a.setStyle(r,l,"flex-basis",b);}if(typeof m!=='undefined'){a.setStyle(r,l,"min-height",m);}if(typeof M!=='undefined'){a.setStyle(r,l,"max-height",M);}if(typeof c!=='undefined'){a.setStyle(r,l,"min-width",c);}if(typeof d!=='undefined'){a.setStyle(r,l,"max-width",d);}};
a.setStyle=function(r,l,p,v){if(typeof(v)==="string"){v=v.replace(/([a-z])([A-Z])/g,"$1-$2").toLowerCase();}a.writeStyle(r,l,p,v);};
a.writeStyle=function(r,l,p,v){if(D.browser.internet_explorer&&(p==="flex-basis"||p==="flex-preferred-size")){if(l.getParent()){if(l.getParent().getParent().getDirection().indexOf("Row")>-1){p="width";}else{p="height";}}}if(r){if(v==="0"||v){r.addStyle(p,v);}}else{if(l.$().length){if(v!=="0"&&!v){l.$().css(p,null);}else{l.$().css(p,v);}}else{if(l.getParent()){if(v!=="0"&&!v){l.getParent().$().css(p,null);}else{l.getParent().$().css(p,v);}}}}};
return a;},true);
sap.ui.predefine('sap/m/FlexItemData',['./FlexBoxStylingHelper','./library','sap/ui/core/LayoutData'],function(F,l,L){"use strict";var B=l.BackgroundDesign;var a=l.FlexAlignSelf;
var b=L.extend("sap.m.FlexItemData",{metadata:{library:"sap.m",properties:{alignSelf:{type:"sap.m.FlexAlignSelf",group:"Misc",defaultValue:a.Auto},order:{type:"int",group:"Misc",defaultValue:0},growFactor:{type:"float",group:"Misc",defaultValue:0},shrinkFactor:{type:"float",group:"Misc",defaultValue:1},baseSize:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"auto"},minHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},maxHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},minWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},styleClass:{type:"string",group:"Misc",defaultValue:''},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:B.Transparent}}}});
b.prototype.setAlignSelf=function(v){var o=this.getAlignSelf();this.setProperty("alignSelf",v,true);this.$().removeClass("sapMFlexItemAlign"+o).addClass("sapMFlexItemAlign"+this.getAlignSelf());return this;};
b.prototype.setOrder=function(v){this.setProperty("order",v,true);F.setStyle(null,this,"order",this.getOrder());return this;};
b.prototype.setGrowFactor=function(v){this.setProperty("growFactor",v,true);F.setStyle(null,this,"flex-grow",this.getGrowFactor());return this;};
b.prototype.setShrinkFactor=function(v){this.setProperty("shrinkFactor",v,true);F.setStyle(null,this,"flex-shrink",this.getShrinkFactor());return this;};
b.prototype.setBaseSize=function(v){this.setProperty("baseSize",v,true);F.setStyle(null,this,"flex-basis",this.getBaseSize());return this;};
b.prototype.setMinHeight=function(v){this.setProperty("minHeight",v,true);this.$().css("min-height",this.getMinHeight());return this;};
b.prototype.setMaxHeight=function(v){this.setProperty("maxHeight",v,true);this.$().css("max-height",this.getMaxHeight());return this;};
b.prototype.setMinWidth=function(v){this.setProperty("minWidth",v,true);this.$().css("min-width",this.getMinWidth());return this;};
b.prototype.setMaxWidth=function(v){this.setProperty("maxWidth",v,true);this.$().css("max-width",this.getMaxWidth());return this;};
b.prototype.setBackgroundDesign=function(v){var o=this.getBackgroundDesign();this.setProperty("backgroundDesign",v,true);this.$().removeClass("sapMFlexBoxBG"+o).addClass("sapMFlexBoxBG"+this.getBackgroundDesign());return this;};
b.prototype.setStyleClass=function(v){var o=this.getStyleClass();this.setProperty("styleClass",v,true);this.$().removeClass(o).addClass(this.getStyleClass());return this;};
return b;});
sap.ui.predefine('sap/m/FormattedText',['./library','sap/ui/core/Control','./FormattedTextAnchorGenerator','./FormattedTextRenderer',"sap/base/Log","sap/base/security/URLWhitelist","sap/base/security/sanitizeHTML"],function(l,C,F,a,L,U,s){"use strict";var b=l.LinkConversion;
var c=C.extend("sap.m.FormattedText",{metadata:{library:"sap.m",properties:{htmlText:{type:"string",group:"Misc",defaultValue:""},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},convertLinksToAnchorTags:{type:"sap.m.LinkConversion",group:"Behavior",defaultValue:b.None},convertedLinksDefaultTarget:{type:"string",group:"Behavior",defaultValue:"_blank"},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}}}});
var _={ATTRIBS:{'style':1,'class':1,'a::href':1,'a::target':1},ELEMENTS:{'a':{cssClass:'sapMLnk'},'abbr':1,'blockquote':1,'br':1,'cite':1,'code':1,'em':1,'h1':{cssClass:'sapMTitle sapMTitleStyleH1'},'h2':{cssClass:'sapMTitle sapMTitleStyleH2'},'h3':{cssClass:'sapMTitle sapMTitleStyleH3'},'h4':{cssClass:'sapMTitle sapMTitleStyleH4'},'h5':{cssClass:'sapMTitle sapMTitleStyleH5'},'h6':{cssClass:'sapMTitle sapMTitleStyleH6'},'p':1,'pre':1,'strong':1,'span':1,'u':1,'dl':1,'dt':1,'dd':1,'ol':1,'ul':1,'li':1}},d={ATTRIBS:{'a::href':1,'a::target':1},ELEMENTS:{'a':{cssClass:'sapMLnk'},'em':1,'strong':1,'u':1}};c.prototype._renderingRules=_;
c.prototype.init=function(){};
function S(t,f){var w;var g,v,h=t==="a";var j=this._renderingRules.ELEMENTS[t].cssClass||"";for(var i=0;i<f.length;i+=2){g=f[i];v=f[i+1];if(!this._renderingRules.ATTRIBS[g]&&!this._renderingRules.ATTRIBS[t+"::"+g]){w='FormattedText: <'+t+'> with attribute ['+g+'="'+v+'"] is not allowed';L.warning(w,this);f[i+1]=null;continue;}if(g=="href"){if(!U.validate(v)){L.warning("FormattedText: incorrect href attribute:"+v,this);f[i+1]="#";h=false;}}if(g=="target"){h=false;}if(j&&g.toLowerCase()=="class"){f[i+1]=j+" "+v;j="";}}if(h){f.push("target");f.push("_blank");}if(j){f.push("class");f.push(j);}return f;}
function p(t,f){if(this._renderingRules.ELEMENTS[t]){return S.call(this,t,f);}else{var w='<'+t+'> is not allowed';L.warning(w,this);}}
function e(t){return s(t,{tagPolicy:p.bind(this),uriRewriter:function(u){if(U.validate(u)){return u;}}});}
function o(E){var n=window.open();n.opener=null;n.location=E.currentTarget.href;E.preventDefault();}
c.prototype.onAfterRendering=function(){this.$().find('a[target="_blank"]').on("click",o);};
c.prototype._getDisplayHtml=function(){var t=this.getHtmlText(),A=this.getConvertLinksToAnchorTags();if(A===l.LinkConversion.None){return t;}t=F.generateAnchors(t,A,this.getConvertedLinksDefaultTarget());return e.call(this,t);};
c.prototype.setHtmlText=function(t){return this.setProperty("htmlText",e.call(this,t));};
c.prototype._setUseLimitedRenderingRules=function(f){this._renderingRules=f?d:_;};
return c;});
sap.ui.predefine('sap/m/FormattedTextAnchorGenerator',["sap/ui/base/Metadata","sap/m/library","sap/base/security/URLWhitelist"],function(M,l,U){"use strict";var L=l.LinkConversion;var A=M.createClass("sap.m.FormattedTextAnchorGenerator",{});var c=/(\b(https?|ftp):\/\/[-A-Z0-9+&@#\/%?=~_|!:,.;()$]*[-A-Z0-9+&@#\/%=~_|])/gim;var W=/(www\.[^\s><]+(\b|$))/gim;var d="//";var D=/<(?:"[^"]*"['"]*|'[^']*'['"]*|[^'">])+(?!\/\s\*)>/gim;var E=/<a[^>]*>([^<]+)<\/a>/gim;var e=[D,E];
A.generateAnchors=function(t,s,T){if(s===L.ProtocolOnly){t=A._createAnchors(t,c,T);}if(s===L.All){t=A._createAnchors(t,c,T);t=A._createAnchors(t,W,T,d);}return t;};
A._createPositionObject=function(i,a){return{iStartPos:i,iEndPos:i+a};};
A._isNested=function(f,s){return f.iStartPos<s.iStartPos&&f.iEndPos>s.iEndPos;};
A._isAllowed=function(b,C){return b.some(function(B){return A._isNested(B,C);});};
A._shouldBeProcessed=function(u,C,b){return U.validate(u)&&!A._isAllowed(b,C);};
A._scanForEntitiesToSkip=function(r,t){var a=[],C;while((C=r.exec(t))!==null){a.push(A._createPositionObject(C.index,C[0].length));}return a;};
A._getEntitiesToSkipWhileSearchingForLinks=function(t){return e.map(function(s){return A._scanForEntitiesToSkip(s,t);}).reduce(function(a,b){return a.concat(b);});};
A._createAnchors=function(t,r,T,p){var a=A._getEntitiesToSkipWhileSearchingForLinks(t),C;p=p||'';C=function(P){var o=A._createPositionObject(arguments[3],P.length);if(!A._shouldBeProcessed(P,o,a)){return P;}return"<a href=\""+p+P+"\" target=\""+T+"\">"+P+"</a>";};return t.replace(r,C);};
return A;},false);
sap.ui.predefine('sap/m/FormattedTextRenderer',[],function(){"use strict";var F={};
F.render=function(r,c){var w=c.getWidth();var h=c.getHeight();r.write("<div");r.writeControlData(c);r.addClass("sapMFT");if(w){r.addClass("sapMFTOverflowWidth");}if(h){r.addClass("sapMFTOverflowHeight");}r.writeClasses();if(c.getTooltip_AsString()){r.writeAttributeEscaped("title",c.getTooltip_AsString());}r.addStyle("width",w||null);r.addStyle("height",h||null);r.writeStyles();r.write(">");r.write(c._getDisplayHtml());r.write("</div>");};
return F;},true);
sap.ui.predefine('sap/m/GenericTag',["sap/ui/core/Control","sap/ui/events/KeyCodes",'./library',"sap/ui/core/library","sap/ui/core/Icon","./GenericTagRenderer"],function(C,K,l,c,I){"use strict";var G=l.GenericTagDesign,a=l.GenericTagValueState,V=c.ValueState,b={Error:"sap-icon://message-error",Warning:"sap-icon://message-warning",Success:"sap-icon://message-success",Information:"sap-icon://message-information"};
var d=C.extend("sap.m.GenericTag",{metadata:{library:"sap.m",interfaces:["sap.m.IOverflowToolbarContent"],properties:{text:{type:"string",defaultValue:""},status:{type:"sap.ui.core.ValueState",defaultValue:V.None},design:{type:"sap.m.GenericTagDesign",defaultValue:G.Full},valueState:{type:"sap.m.GenericTagValueState",defaultValue:a.None}},defaultAggregation:"value",aggregations:{value:{type:"sap.m.ObjectNumber",multiple:false},_statusIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_errorIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{press:{}}}});
d.CLASSNAME_OVERFLOW_TOOLBAR="sapMGenericTagOverflowToolbar";
d.prototype.setStatus=function(s){this.setProperty("status",s,false);this._getStatusIcon().setSrc(s!==V.None?b[s]:null);return this;};
d.prototype._getStatusIcon=function(){var s=this.getAggregation("_statusIcon");if(!s){s=new I(this.getId()+"-statusIcon").addStyleClass("sapMGenericTagIcon");this.setAggregation("_statusIcon",s);}return s;};
d.prototype._getErrorIcon=function(){var e=this.getAggregation("_errorIcon");if(!e){e=new I(this.getId()+"-errorIcon",{src:b[V.Error]}).addStyleClass("sapMGenericTagErrorIcon");this.setAggregation("_errorIcon",e);}return e;};
d.prototype.ontouchstart=function(){this._toggleActiveGenericTag(true);};
d.prototype.ontouchend=function(){this._toggleActiveGenericTag(false);};
d.prototype.ontouchcancel=function(){this._toggleActiveGenericTag(false);};
d.prototype.onkeydown=function(e){if(e.which===K.SPACE||e.which===K.ENTER){this._toggleActiveGenericTag(true);}if(e.which===K.ENTER){this.firePress();}};
d.prototype.onkeyup=function(e){if(e.which===K.SPACE||e.which===K.ENTER){this._toggleActiveGenericTag(false);}if(e.which===K.SPACE){this.firePress();}};
d.prototype.onclick=function(){this.firePress();};
d.prototype.onfocusout=function(){this._toggleActiveGenericTag(false);};
d.prototype._toggleActiveGenericTag=function(t){this.toggleStyleClass("sapMGenericTagActive",t);};
d.prototype._onBeforeEnterOverflow=function(o){o.addStyleClass(d.CLASSNAME_OVERFLOW_TOOLBAR);};
d.prototype._onAfterExitOverflow=function(o){o.removeStyleClass(d.CLASSNAME_OVERFLOW_TOOLBAR);};
d.prototype.getOverflowToolbarConfig=function(){var o={canOverflow:true};o.onBeforeEnterOverflow=this._onBeforeEnterOverflow;o.onAfterExitOverflow=this._onAfterExitOverflow;return o;};
return d;});
sap.ui.predefine('sap/m/GenericTagRenderer',["./library","sap/ui/core/library"],function(l,c){"use strict";var G=l.GenericTagDesign,a=l.GenericTagValueState,V=c.ValueState,C=sap.ui.getCore(),b={};
b.render=function(r,o){var L=this._getAriaLabelledBy(o),R=C.getLibraryResourceBundle("sap.m");r.openStart("div");r.class("sapMGenericTag");r.attr("id",o.getId());r.attr("tabindex",0);r.controlData(o);r.class("sapMGenericTag"+o.getStatus());r.accessibilityState(o,{role:"button",roledescription:R.getText("GENERICTAG_ROLEDESCRIPTION"),labelledBy:L.join(" ")});r.openEnd();r.openStart("div");r.class("sapMGenericTagWrap");r.openEnd();this.renderElements(r,o);r.close("div");r.close("div");};
b.renderElements=function(r,o){var s=o.getDesign()===G.StatusIconHidden,S=o.getValueState()===a.Error,v=o.getValue();if(!s&&o.getStatus()!==V.None){r.renderControl(o._getStatusIcon());}this.renderText(r,o);if(S){r.renderControl(o._getErrorIcon());}else if(v){r.renderControl(v.addStyleClass("sapMGenericTagValue"));}this.renderHiddenARIAElement(r,o);};
b.renderText=function(r,o){r.openStart("span");r.class("sapMGenericTagText");r.attr("id",o.getId()+"-text");r.openEnd();r.text(o.getText());r.close("span");};
b.renderHiddenARIAElement=function(r,o){if(o.getStatus()===V.None){return;}r.openStart("span");r.class("sapUiInvisibleText");r.attr("id",o.getId()+"-status");r.attr("aria-hidden","true");r.openEnd();r.write(this._getGenericTagStatusText(o));r.close("span");};
b._getAriaLabelledBy=function(o){var L=[],i=o.getId();if(o.getStatus()!==V.None){L.push(i+"-status");}L.push(i+"-text");L.push(o.getValueState()===a.Error?i+"-errorIcon":this._getTagValueId(o));return L;};
b._getGenericTagStatusText=function(o){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),R=r.getText("GENERICTAG_ROLEDESCRIPTION"),A;switch(o.getStatus()){case V.Error:A=r.getText("GENERICTAG_ARIA_VALUE_STATE_ERROR");break;case V.Warning:A=r.getText("GENERICTAG_ARIA_VALUE_STATE_WARNING");break;case V.Success:A=r.getText("GENERICTAG_ARIA_VALUE_STATE_SUCCESS");break;case V.Information:A=r.getText("GENERICTAG_ARIA_VALUE_STATE_INFORMATION");break;default:}return R+" "+A;};
b._getTagValueId=function(o){var v=o.getValue();return v?v.getId():"";};
return b;},true);
sap.ui.predefine('sap/m/GenericTile',['./library','sap/ui/core/Control','sap/m/Text','sap/ui/core/HTML','sap/ui/core/Icon','sap/ui/core/IconPool','sap/m/Button','sap/m/GenericTileRenderer','sap/m/GenericTileLineModeRenderer','sap/ui/Device','sap/ui/core/ResizeHandler',"sap/base/strings/camelize","sap/base/util/deepEqual","sap/ui/events/PseudoEvents","sap/ui/thirdparty/jquery"],function(l,C,T,H,I,a,B,G,L,D,R,c,d,P,q){"use strict";var b=l.GenericTileScope,e=l.LoadState,F=l.FrameType,S=l.Size,f=l.GenericTileMode,g=l.TileSizeBehavior,W=l.WrappingType;var h="GenericTileDeviceSet";
var j=C.extend("sap.m.GenericTile",{
metadata:{library:"sap.m",properties:{mode:{type:"sap.m.GenericTileMode",group:"Appearance",defaultValue:f.ContentMode},header:{type:"string",group:"Appearance",defaultValue:null},subheader:{type:"string",group:"Appearance",defaultValue:null},failedText:{type:"string",group:"Appearance",defaultValue:null},size:{type:"sap.m.Size",group:"Misc",defaultValue:S.Auto},frameType:{type:"sap.m.FrameType",group:"Misc",defaultValue:F.OneByOne},backgroundImage:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},headerImage:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},state:{type:"sap.m.LoadState",group:"Misc",defaultValue:e.Loaded},imageDescription:{type:"string",group:"Accessibility",defaultValue:null},scope:{type:"sap.m.GenericTileScope",group:"Misc",defaultValue:b.Display},sizeBehavior:{type:"sap.m.TileSizeBehavior",defaultValue:g.Responsive},ariaLabel:{type:"string",group:"Accessibility",defaultValue:null},wrappingType:{type:"sap.m.WrappingType",group:"Appearance",defaultValue:W.Normal}},defaultAggregation:"tileContent",aggregations:{tileContent:{type:"sap.m.TileContent",multiple:true,bindable:"bindable"},icon:{type:"sap.ui.core.Control",multiple:false},_titleText:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_failedMessageText:{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{press:{parameters:{scope:{type:"sap.m.GenericTileScope"},action:{type:"string"},domRef:{type:"any"}}}}},
renderer:function(r,o){if(o.getMode()===l.GenericTileMode.LineMode){L.render(r,o);}else{G.render(r,o);}}
});
j._Action={Press:"Press",Remove:"Remove"};j.LINEMODE_SIBLING_PROPERTIES=["state","subheader","header","scope"];
j.prototype.init=function(){this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(!D.media.hasRangeSet(h)){D.media.initRangeSet(h,[450],"px",["small","large"]);}this._oTitle=new T(this.getId()+"-title");this._oTitle.addStyleClass("sapMGTTitle");this._oTitle.cacheLineHeight=false;this.setAggregation("_titleText",this._oTitle,true);this._oSubTitle=new T(this.getId()+"-subTitle");this._oSubTitle.cacheLineHeight=false;this.addDependent(this._oSubTitle);this._sFailedToLoad=this._oRb.getText("INFOTILE_CANNOT_LOAD_TILE");this._sLoading=this._oRb.getText("INFOTILE_LOADING");this._oFailedText=new T(this.getId()+"-failed-txt",{maxLines:2});this._oFailedText.cacheLineHeight=false;this._oFailedText.addStyleClass("sapMGTFailed");this.setAggregation("_failedMessageText",this._oFailedText,true);this._oWarningIcon=new I(this.getId()+"-warn-icon",{src:"sap-icon://notification",size:"1.375rem"});this._oWarningIcon.addStyleClass("sapMGTFtrFldIcnMrk");this._oBusy=new H(this.getId()+"-overlay");this._oBusy.setBusyIndicatorDelay(0);this._bTilePress=true;this._bThemeApplied=true;if(!sap.ui.getCore().isInitialized()){this._bThemeApplied=false;sap.ui.getCore().attachInit(this._handleCoreInitialized.bind(this));}else{this._handleCoreInitialized();}};
j.prototype.setWrappingType=function(w){this.setProperty("wrappingType",w,true);this._oTitle.setWrappingType(w);this._oFailedText.setWrappingType(w);this._oSubTitle.setWrappingType(w);return this;};
j.prototype.setSubheader=function(s){this.setProperty("subheader",s);this._oSubTitle.setText(s);return this;};
j.prototype._handleCoreInitialized=function(){this._bThemeApplied=sap.ui.getCore().isThemeApplied();if(!this._bThemeApplied){sap.ui.getCore().attachThemeChanged(this._handleThemeApplied,this);}};
j.prototype._handleThemeApplied=function(){this._bThemeApplied=true;this._oTitle.clampHeight();sap.ui.getCore().detachThemeChanged(this._handleThemeApplied,this);};
j.prototype._initScopeContent=function(t){switch(this.getScope()){case l.GenericTileScope.Actions:if(this.getState&&this.getState()===l.LoadState.Disabled){break;}this._oMoreIcon=this._oMoreIcon||a.createControlByURI({id:this.getId()+"-action-more",size:"1rem",useIconTooltip:false,src:"sap-icon://overflow"}).addStyleClass("sapMPointer").addStyleClass(t+"MoreIcon");this._oRemoveButton=this._oRemoveButton||new B({id:this.getId()+"-action-remove",icon:"sap-icon://decline",tooltip:this._oRb.getText("GENERICTILE_REMOVEBUTTON_TEXT")}).addStyleClass("sapUiSizeCompact").addStyleClass(t+"RemoveButton");this._oRemoveButton._bExcludeFromTabChain=true;break;default:}};
j.prototype.exit=function(){if(this._sParentResizeListenerId){R.deregister(this._sResizeListenerId);this._sParentResizeListenerId=null;}D.media.detachHandler(this._handleMediaChange,this,h);if(this._$RootNode){this._$RootNode.off(this._getAnimationEvents());this._$RootNode=null;}this._clearAnimationUpdateQueue();this._oWarningIcon.destroy();if(this._oImage){this._oImage.destroy();}this._oBusy.destroy();if(this._oMoreIcon){this._oMoreIcon.destroy();}if(this._oRemoveButton){this._oRemoveButton.destroy();}};
j.prototype.onBeforeRendering=function(){var s=!!this.getSubheader();if(this.getMode()===l.GenericTileMode.HeaderMode){this._applyHeaderMode(s);}else{this._applyContentMode(s);}var t=this.getTileContent().length;for(var i=0;i<t;i++){this.getTileContent()[i].setDisabled(this.getState()===l.LoadState.Disabled);}this._initScopeContent("sapMGT");this._generateFailedText();this.$().unbind("mouseenter");this.$().unbind("mouseleave");if(this._sParentResizeListenerId){R.deregister(this._sResizeListenerId);this._sParentResizeListenerId=null;}D.media.detachHandler(this._handleMediaChange,this,h);if(this._$RootNode){this._$RootNode.off(this._getAnimationEvents());}if(this.getFrameType()===l.FrameType.Auto){this.setProperty("frameType",l.FrameType.OneByOne,true);}};
j.prototype.onAfterRendering=function(){this._setupResizeClassHandler();this.$().bind("mouseenter",this._updateAriaAndTitle.bind(this));this.$().bind("mouseleave",this._removeTooltipFromControl.bind(this));var m=this.getMode();if(m===l.GenericTileMode.LineMode&&this._isScreenLarge()){this.$().parent().addClass("sapMGTLineModeContainer");this._updateHoverStyle(true);if(this.getParent()instanceof C){this._sParentResizeListenerId=R.register(this.getParent(),this._handleResize.bind(this));}else{this._sParentResizeListenerId=R.register(this.$().parent(),this._handleResize.bind(this));}}if(m===l.GenericTileMode.LineMode&&this._bUpdateLineTileSiblings){this._updateLineTileSiblings();this._bUpdateLineTileSiblings=false;}if(m===l.GenericTileMode.LineMode){D.media.attachHandler(this._handleMediaChange,this,h);}};
j.prototype._handleResize=function(){if(this.getMode()===l.GenericTileMode.LineMode&&this._isScreenLarge()&&this.getParent()){this._queueAnimationEnd();}};
j.prototype._setupResizeClassHandler=function(){var i=function(){if(this.getSizeBehavior()===g.Small||window.matchMedia("(max-width: 374px)").matches){this.$().addClass("sapMTileSmallPhone");}else{this.$().removeClass("sapMTileSmallPhone");}}.bind(this);q(window).resize(i);i();};
j.prototype._isCompact=function(){return q("body").hasClass("sapUiSizeCompact")||this.$().is(".sapUiSizeCompact")||this.$().closest(".sapUiSizeCompact").length>0;};
j.prototype._calculateStyleData=function(){this.$("lineBreak").remove();if(!this._isScreenLarge()||!this.getDomRef()||this.$().is(":hidden")){return null;}var $=this.$(),E=this.$("endMarker"),s=this.$("startMarker");if(E.length===0||s.length===0){return null;}var k=this._getLineCount(),m,n,o=Math.ceil(L._getCSSPixelValue(this,"margin-top")),p,A=this.$().parent().innerWidth(),r=Math.ceil(L._getCSSPixelValue(this,"min-height")),t=L._getCSSPixelValue(this,"line-height"),u=this.$().is(":not(:first-child)")&&k>1,v=q("<span><br /></span>"),i=0,w=sap.ui.getCore().getConfiguration().getRTL(),x=E.position();if(u){v.attr("id",this.getId()+"-lineBreak");$.prepend(v);k=this._getLineCount();x=E.position();}var y={rtl:w,lineBreak:u,startOffset:s.offset(),endOffset:E.offset(),availableWidth:A,lines:[]};var z;if(D.browser.msie||D.browser.edge){z=v.find("br").position();}else{z=v.position();}var J=z;if(!(D.browser.mozilla||D.browser.msie||D.browser.edge)&&z.left<x.left){J=x;}y.positionLeft=u?z.left:$.position().left;y.positionRight=u?$.width()-J.left:y.availableWidth-$.position().left;if(!u&&k>1){y.positionRight=s.parent().innerWidth()-(s.position().left+s.width());}for(i;i<k;i++){if(u&&i===0){continue;}if(k===1){m=w?y.availableWidth-y.positionLeft:y.positionLeft;p=$.width();}else if(i===k-1){m=0;p=w?$.width()-x.left:x.left;}else if(u&&i===1){m=0;p=A;}else{m=0;p=A;}n=i*t+o;y.lines.push({offset:{x:m,y:n},width:p,height:r});}return y;};
j.prototype._getStyleData=function(){var s=this._calculateStyleData();if(!d(this._oStyleData,s)){delete this._oStyleData;this._oStyleData=s;return true;}return false;};
j.prototype._getAnimationEvents=function(){return"transitionend.sapMGT$id animationend.sapMGT$id".replace(/\$id/g,c(this.getId()));};
j.prototype._updateHoverStyle=function(i){if(!this._getStyleData()&&!i){return;}this._clearAnimationUpdateQueue();this._cHoverStyleUpdates=-1;this._oAnimationEndCallIds={};if(this._oStyleData&&this._oStyleData.lineBreak&&this.getUIArea()){this._$RootNode=q(this.getUIArea().getRootNode());this._$RootNode.on(this._getAnimationEvents(),this._queueAnimationEnd.bind(this));}this._queueAnimationEnd();};
j.prototype._queueAnimationEnd=function(E){if(E){var t=q(E.target);if(t.is(".sapMGT, .sapMGT *")){return false;}}if(typeof this._cHoverStyleUpdates!=="number"){this._cHoverStyleUpdates=-1;}if(!this._oAnimationEndCallIds){this._oAnimationEndCallIds={};}this._cHoverStyleUpdates++;this._oAnimationEndCallIds[this._cHoverStyleUpdates]=setTimeout(this._handleAnimationEnd.bind(this,this._cHoverStyleUpdates),10);};
j.prototype._handleAnimationEnd=function(i){delete this._oAnimationEndCallIds[i];if(this._cHoverStyleUpdates===i){this._getStyleData();L._updateHoverStyle.call(this);}};
j.prototype._clearAnimationUpdateQueue=function(){for(var k in this._oAnimationEndCallIds){clearTimeout(this._oAnimationEndCallIds[k]);delete this._oAnimationEndCallIds[k];}};
j.prototype._getLineCount=function(){var o=this.getDomRef().getBoundingClientRect(),i=L._getCSSPixelValue(this,"line-height");return Math.round(o.height/i);};
j.prototype.getBoundingRects=function(){var p=this.$().offset();if(this.getMode()===l.GenericTileMode.LineMode&&this._isScreenLarge()){this._getStyleData();var r=[],s,o;this.$().find(".sapMGTLineStyleHelper").each(function(){s=q(this);o=s.offset();r.push({offset:{x:o.left,y:o.top},width:s.width(),height:s.height()});});return r;}else{return[{offset:{x:p.left,y:p.top},width:this.$().width(),height:this.$().height()}];}};
j.prototype._updateLineTileSiblings=function(){var p=this.getParent();if(this.getMode()===l.GenericTileMode.LineMode&&this._isScreenLarge()&&p){var i=p.indexOfAggregation(this.sParentAggregationName,this);var s=p.getAggregation(this.sParentAggregationName).splice(i+1);for(i=0;i<s.length;i++){var o=s[i];if(o instanceof l.GenericTile&&o.getMode()===l.GenericTileMode.LineMode){o._updateHoverStyle();}}}};
j.prototype.ontouchstart=function(){if(this.$("hover-overlay").length>0){this.$("hover-overlay").addClass("sapMGTPressActive");}if(this.getMode()===l.GenericTileMode.LineMode){this.addStyleClass("sapMGTLineModePress");}};
j.prototype.ontouchcancel=function(){if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive");}};
j.prototype.ontouchend=function(){if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive");}if(this.getMode()===l.GenericTileMode.LineMode){this.removeStyleClass("sapMGTLineModePress");}};
j.prototype.ontap=function(i){var p;if(this._bTilePress&&this.getState()!==l.LoadState.Disabled){this.$().focus();p=this._getEventParams(i);this.firePress(p);i.preventDefault();}};
j.prototype.onkeydown=function(i){if(P.events.sapselect.fnCheck(i)&&this.getState()!==l.LoadState.Disabled){if(this.$("hover-overlay").length>0){this.$("hover-overlay").addClass("sapMGTPressActive");}i.preventDefault();}};
j.prototype._updateAriaLabel=function(){var A=this._getAriaText(),t=this.$(),i=false;if(t.attr("aria-label")!==A){t.attr("aria-label",A);i=true;}return i;};
j.prototype.onkeyup=function(i){var p,k=false,s=this.getScope(),A=s===l.GenericTileScope.Actions;if(A&&(P.events.sapdelete.fnCheck(i)||P.events.sapbackspace.fnCheck(i))){p={scope:s,action:j._Action.Remove,domRef:this._oRemoveButton.getPopupAnchorDomRef()};k=true;}if(P.events.sapselect.fnCheck(i)&&this.getState()!==l.LoadState.Disabled){if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive");}p=this._getEventParams(i);k=true;}if(k){this.firePress(p);i.preventDefault();}this._updateAriaLabel();};
j.prototype.setProperty=function(p){C.prototype.setProperty.apply(this,arguments);if(this.getMode()===l.GenericTileMode.LineMode&&j.LINEMODE_SIBLING_PROPERTIES.indexOf(p)!==-1){this._bUpdateLineTileSiblings=true;}return this;};
j.prototype.getHeader=function(){return this._oTitle.getText();};
j.prototype.setHeader=function(t){this._oTitle.setText(t);return this;};
j.prototype.setHeaderImage=function(u){var v=!d(this.getHeaderImage(),u);if(v){if(this._oImage){this._oImage.destroy();this._oImage=undefined;}if(u){this._oImage=a.createControlByURI({id:this.getId()+"-icon-image",src:u},l.Image);this._oImage.addStyleClass("sapMGTHdrIconImage");}}return this.setProperty("headerImage",u);};
j.prototype._applyHeaderMode=function(s){if(s){this._oTitle.setMaxLines(4);}else{this._oTitle.setMaxLines(5);}this._changeTileContentContentVisibility(false);};
j.prototype._applyContentMode=function(s){if(s){this._oTitle.setMaxLines(2);}else{this._oTitle.setMaxLines(3);}this._changeTileContentContentVisibility(true);};
j.prototype._changeTileContentContentVisibility=function(v){var t;t=this.getTileContent();for(var i=0;i<t.length;i++){t[i].setRenderContent(v);}};
j.prototype._getHeaderAriaAndTooltipText=function(){var t="";var i=true;if(this.getHeader()){t+=this.getHeader();i=false;}if(this.getSubheader()){t+=(i?"":"\n")+this.getSubheader();i=false;}if(this.getImageDescription()){t+=(i?"":"\n")+this.getImageDescription();}return t;};
j.prototype._getContentAriaAndTooltipText=function(){var t="";var k=true;var m=this.getTileContent();for(var i=0;i<m.length;i++){if(q.isFunction(m[i]._getAriaAndTooltipText)){t+=(k?"":"\n")+m[i]._getAriaAndTooltipText();}else if(m[i].getTooltip_AsString()){t+=(k?"":"\n")+m[i].getTooltip_AsString();}k=false;}return t;};
j.prototype._getAriaAndTooltipText=function(){var A=(this.getTooltip_AsString()&&!this._isTooltipSuppressed())?this.getTooltip_AsString():(this._getHeaderAriaAndTooltipText()+"\n"+this._getContentAriaAndTooltipText());switch(this.getState()){case l.LoadState.Disabled:return"";case l.LoadState.Loading:return A+"\n"+this._sLoading;case l.LoadState.Failed:return A+"\n"+this._oFailedText.getText();default:if(q.trim(A).length===0){return"";}else{return A;}}};
j.prototype._getAriaText=function(){var A=this.getTooltip_Text();var s=this.getAriaLabel();if(!A||this._isTooltipSuppressed()){A=this._getAriaAndTooltipText();}if(this.getScope()===l.GenericTileScope.Actions){A=this._oRb.getText("GENERICTILE_ACTIONS_ARIA_TEXT")+" "+A;}if(s){A=s+" "+A;}return A;};
j.prototype._getTooltipText=function(){var t=this.getTooltip_Text();if(this._isTooltipSuppressed()===true){t=null;}return t;};
j.prototype._checkFooter=function(t,i){var s=i.getState();var A=this.getScope()===l.GenericTileScope.Actions||this._bShowActionsView===true;if(s===l.LoadState.Failed||A&&s!==l.LoadState.Disabled){t.setRenderFooter(false);}else{t.setRenderFooter(true);}};
j.prototype._generateFailedText=function(){var s=this.getFailedText();var i=s?s:this._sFailedToLoad;this._oFailedText.setText(i);this._oFailedText.setTooltip(i);};
j.prototype._isTooltipSuppressed=function(){var t=this.getTooltip_Text();if(t&&t.length>0&&q.trim(t).length===0){return true;}else{return false;}};
j.prototype._isHeaderTextTruncated=function(){var o,m,$,w;if(this.getMode()===l.GenericTileMode.LineMode){$=this.$("hdr-text");if($.length>0){w=Math.ceil($[0].getBoundingClientRect().width);return($[0]&&w<$[0].scrollWidth);}else{return false;}}else{o=this.getAggregation("_titleText").getDomRef("inner");m=this.getAggregation("_titleText").getClampHeight(o);return(m<o.scrollHeight);}};
j.prototype._isSubheaderTextTruncated=function(){var s;if(this.getMode()===l.GenericTileMode.LineMode){s=this.$("subHdr-text");}else{s=this.$("subTitle");}if(s.length>0){var w=Math.ceil(s[0].getBoundingClientRect().width);return(s[0]&&w<s[0].scrollWidth);}else{return false;}};
j.prototype._setTooltipFromControl=function(){var t="";var i=true;var k=this.getTileContent();if(this._oTitle.getText()){t=this._oTitle.getText();i=false;}if(this.getSubheader()){t+=(i?"":"\n")+this.getSubheader();i=false;}if(this.getScope()!==l.GenericTileScope.Actions&&this.getMode()!==l.GenericTileMode.LineMode){if(k[0]&&k[0].getTooltip_AsString()&&k[0].getTooltip_AsString()!==""){t+=(i?"":"\n")+k[0].getTooltip_AsString();i=false;}if(this.getFrameType()==="TwoByOne"&&k[1]&&k[1].getTooltip_AsString()&&k[1].getTooltip_AsString()!==""){t+=(i?"":"\n")+k[1].getTooltip_AsString();}}if(t&&!this._getTooltipText()&&!this._isTooltipSuppressed()){this.$().attr("title",t.trim());this._bTooltipFromControl=true;}};
j.prototype._updateAriaAndTitle=function(){var A=this._getAriaAndTooltipText();var s=this._getAriaText();var t=this.$();if(t.attr("title")!==A){t.attr("aria-label",s);}if(this.getScope()===l.GenericTileScope.Actions){t.find('*:not(.sapMGTRemoveButton)').removeAttr("aria-label").removeAttr("title").unbind("mouseenter");}else{t.find('*').removeAttr("aria-label").removeAttr("title").unbind("mouseenter");}this._setTooltipFromControl();};
j.prototype._removeTooltipFromControl=function(){if(this._bTooltipFromControl){this.$().removeAttr("title");this._bTooltipFromControl=false;}};
j.prototype._isScreenLarge=function(){return this._getCurrentMediaContainerRange(h).name==="large";};
j.prototype._getEventParams=function(E){var p,A=j._Action.Press,s=this.getScope(),o=this.getDomRef();if(s===l.GenericTileScope.Actions&&E.target.id.indexOf("-action-remove")>-1){A=j._Action.Remove;o=this._oRemoveButton.getPopupAnchorDomRef();}else if(s===l.GenericTileScope.Actions){o=this._oMoreIcon.getDomRef();}p={scope:s,action:A,domRef:o};return p;};
j.prototype._handleMediaChange=function(){this._bUpdateLineTileSiblings=true;this.invalidate();};
j.prototype.setPressEnabled=function(v){this._bTilePress=v;};
j.prototype.showActionsView=function(v){if(this._bShowActionsView!==v){this._bShowActionsView=v;this.invalidate();}};
return j;});
sap.ui.predefine('sap/m/GenericTileLineModeRenderer',["sap/m/library","sap/base/security/encodeCSS","sap/ui/thirdparty/jquery"],function(l,e,q){"use strict";var G=l.GenericTileScope;var L=l.LoadState;var a={};
a.render=function(r,c){var t=c._getTooltipText(),i=c._isScreenLarge(),A=c._getAriaText(),s=e("sapMGTScope"+c.getScope()),h=c.hasListeners("press");this._bRTL=sap.ui.getCore().getConfiguration().getRTL();r.write("<span");r.writeControlData(c);r.writeAttributeEscaped("aria-label",A);if(h){r.writeAttribute("role","button");}else{r.writeAttribute("role","presentation");}r.addClass("sapMGT");r.addClass(s);r.addClass("sapMGTLineMode");this._writeDirection(r);if(t){r.writeAttributeEscaped("title",t);}var S=c.getState();if(S!==L.Disabled){r.addClass("sapMPointer");r.writeAttribute("tabindex","0");}else{r.addClass("sapMGTDisabled");}if(S===L.Failed){r.addClass("sapMGTFailed");}r.writeClasses();r.write(">");if(i){r.write("<div");r.writeAttribute("id",c.getId()+"-startMarker");r.addClass("sapMGTStartMarker");r.writeClasses();r.write("></div>");this._renderFailedIcon(r,c);this._renderHeader(r,c);if(c.getSubheader()){this._renderSubheader(r,c);}r.write("<div");r.writeAttribute("id",c.getId()+"-endMarker");r.addClass("sapMGTEndMarker");r.writeClasses();r.write(">");if(c.getScope()===G.Actions){this._renderActionsScope(r,c);}r.write("</div>");r.write("<div");r.writeAttribute("id",c.getId()+"-styleHelper");r.addClass("sapMGTStyleHelper");r.writeClasses();r.write("></div>");}else{if(c.getState()!==L.Disabled){this._renderFocusDiv(r,c);}r.write("<div");r.writeAttribute("id",c.getId()+"-touchArea");r.addClass("sapMGTTouchArea");r.writeClasses();r.write(">");this._renderFailedIcon(r,c);r.write("<span");r.writeAttribute("id",c.getId()+"-lineModeHelpContainer");r.addClass("sapMGTLineModeHelpContainer");r.writeClasses();r.write(">");this._renderHeader(r,c);if(c.getSubheader()){this._renderSubheader(r,c);}r.write("</span>");if(c.getScope()===G.Actions){this._renderActionsScope(r,c);}r.write("</div>");}r.write("</span>");};
a._writeDirection=function(r){if(this._bRTL){r.writeAttribute("dir","rtl");}};
a._renderFailedIcon=function(r,c){if(c.getState()===L.Failed){if(c._isCompact()){c._oWarningIcon.setSize("1.25rem");}else{c._oWarningIcon.setSize("1.375rem");}r.renderControl(c._oWarningIcon.addStyleClass("sapMGTLineModeFailedIcon"));}};
a._renderHeader=function(r,c){r.write("<span");this._writeDirection(r);r.addClass("sapMGTHdrTxt");r.writeClasses();r.writeAttribute("id",c.getId()+"-hdr-text");r.write(">");r.writeEscaped(c._oTitle.getText());r.write("</span>");};
a._renderSubheader=function(r,c){r.write("<span");this._writeDirection(r);r.addClass("sapMGTSubHdrTxt");r.writeClasses();r.writeAttribute("id",c.getId()+"-subHdr-text");r.write(">");r.writeEscaped(c._oSubTitle.getText());r.write("</span>");};
a._renderActionsScope=function(r,c){if(c.getState()!==L.Disabled){r.write("<span");r.writeAttribute("id",c.getId()+"-actions");r.addClass("sapMGTActionsContainer");r.writeClasses();r.write(">");r.renderControl(c._oMoreIcon);r.renderControl(c._oRemoveButton);r.write("</span>");}};
a._updateHoverStyle=function(){var s=this.$("styleHelper"),o,i=0,h="";s.empty();if(!this._oStyleData||this.$().is(":hidden")){return;}if(this._oStyleData.rtl){s.css("right",-this._oStyleData.positionRight);}else{s.css("left",-this._oStyleData.positionLeft);}for(i;i<this._oStyleData.lines.length;i++){o=this._oStyleData.lines[i];var r=q("<div class='sapMGTLineStyleHelper'><div class='sapMGTLineStyleHelperInner' /></div>");if(this._oStyleData.rtl){r.css("right",o.offset.x+"px");}else{r.css("left",o.offset.x+"px");}r.css({top:o.offset.y+"px",width:o.width+"px",height:o.height});h+=q.trim(r.get(0).outerHTML);}s.html(h);};
a._renderFocusDiv=function(r,c){r.write("<div");r.writeAttribute("id",c.getId()+"-focus");r.addClass("sapMGTFocusDiv");r.writeClasses();r.write(">");r.write("</div>");};
a._getCSSPixelValue=function(o,p){var O=o instanceof q?o:o.$(),m=(O.css(p)||"").match(/([^a-zA-Z\%]*)(.*)/),v=parseFloat(m[1]),u=m[2];return(u==="px")?v:v*16;};
return a;},true);
sap.ui.predefine('sap/m/GenericTileRenderer',["sap/m/library","sap/base/security/encodeCSS"],function(l,e){"use strict";var G=l.GenericTileMode;var a=l.GenericTileScope;var L=l.LoadState;var b={};
b.render=function(r,c){var t=c._getTooltipText();var A=c._getAriaText();A="GenericTile"+"\n"+A;var h=c.getHeaderImage();var H=c.hasListeners("press");var s=c.getState();var S=c.getScope();var d=e("sapMGTState"+s);var f=e("sapMGTScope"+S);r.write("<div");r.writeControlData(c);if(t){r.writeAttributeEscaped("title",t);}r.addClass("sapMGT");r.addClass(d);r.addClass(f);if(S!==a.Actions&&c._bShowActionsView){r.addClass("sapMGTScopeActions");}r.addClass(c.getFrameType());if(H){r.writeAttribute("role","button");}else{r.writeAttribute("role","presentation");}r.writeAttributeEscaped("aria-label",A);if(s!==L.Disabled){r.addClass("sapMPointer");r.writeAttribute("tabindex","0");}if(c.getBackgroundImage()){r.write(" style='background-image:url(");r.writeEscaped(c.getBackgroundImage());r.write(");'");r.addClass("sapMGTBackgroundImage");}if(c.getMode()===G.HeaderMode){r.addClass("sapMGTHeaderMode");}r.writeClasses();r.write(">");r.write("<div");r.addClass("sapMGTHdrContent");r.addClass(c.getFrameType());if(t){r.writeAttributeEscaped("title",t);}r.writeClasses();r.write(">");if(h){r.renderControl(c._oImage);}this._renderHeader(r,c);if(c.getSubheader()){this._renderSubheader(r,c);}r.write("</div>");r.write("<div");r.addClass("sapMGTContent");r.writeClasses();r.writeAttribute("id",c.getId()+"-content");r.write(">");var T=c.getTileContent();var g=T.length;for(var i=0;i<g;i++){c._checkFooter(T[i],c);r.renderControl(T[i]);}r.write("</div>");if(s!==L.Loaded){this._renderStateOverlay(r,c,t);}if(s!==L.Disabled){this._renderHoverOverlay(r,c);this._renderFocusDiv(r,c);}if(S===a.Actions){this._renderActionsScope(r,c);}r.write("</div>");};
b._renderFocusDiv=function(r,c){r.write("<div");r.addClass("sapMGTFocusDiv");r.writeClasses();r.writeAttribute("id",c.getId()+"-focus");r.write(">");r.write("</div>");};
b._renderStateOverlay=function(r,c,t){var s=c.getState();r.write("<div");r.addClass("sapMGTOverlay");r.writeClasses();r.writeAttribute("id",c.getId()+"-overlay");if(t){r.writeAttributeEscaped("title",t);}r.write(">");switch(s){case L.Loading:c._oBusy.setBusy(s==L.Loading);r.renderControl(c._oBusy);break;case L.Failed:r.write("<div");r.writeAttribute("id",c.getId()+"-failed-ftr");r.addClass("sapMGenericTileFtrFld");r.writeClasses();r.write(">");r.write("<div");r.writeAttribute("id",c.getId()+"-failed-icon");r.addClass("sapMGenericTileFtrFldIcn");r.writeClasses();r.write(">");r.renderControl(c._oWarningIcon);r.write("</div>");if(c.getScope()!==a.Actions&&!c._bShowActionsView){r.write("<div");r.writeAttribute("id",c.getId()+"-failed-text");r.addClass("sapMGenericTileFtrFldTxt");r.writeClasses();r.write(">");r.renderControl(c.getAggregation("_failedMessageText"));r.write("</div>");}r.write("</div>");break;default:}r.write("</div>");};
b._renderActionsScope=function(r,c){if(c.getState()!==L.Disabled){r.renderControl(c._oRemoveButton);r.renderControl(c._oMoreIcon);}};
b._renderHoverOverlay=function(r,c){r.write("<div");if(c.getBackgroundImage()){r.addClass("sapMGTWithImageHoverOverlay");}else{r.addClass("sapMGTWithoutImageHoverOverlay");}r.writeClasses();r.writeAttribute("id",c.getId()+"-hover-overlay");r.write(">");r.write("</div>");};
b._renderHeader=function(r,c){r.write("<div");r.addClass("sapMGTHdrTxt");r.writeClasses();r.writeAttribute("id",c.getId()+"-hdr-text");r.write(">");r.renderControl(c._oTitle);r.write("</div>");};
b._renderSubheader=function(r,c){r.write("<div");r.addClass("sapMGTSubHdrTxt");r.writeClasses();r.writeAttribute("id",c.getId()+"-subHdr-text");r.write(">");r.renderControl(c._oSubTitle);r.write("</div>");};
return b;},true);
sap.ui.predefine('sap/m/GroupHeaderListItem',["sap/ui/core/library","./library","./ListItemBase","./GroupHeaderListItemRenderer"],function(c,l,L,G){"use strict";var a=l.ListMode;var T=c.TextDirection;
var b=L.extend("sap.m.GroupHeaderListItem",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Data",defaultValue:null},count:{type:"string",group:"Data",defaultValue:null},upperCase:{type:"boolean",group:"Appearance",defaultValue:false},titleTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit}}}});
b.prototype.getMode=function(){return a.None;};
b.prototype.shouldClearLastValue=function(){return true;};
b.prototype.getTable=function(){var p=this.getParent();if(p&&p.isA("sap.m.Table")){return p;}};
b.prototype.onBeforeRendering=function(){var t=this.getTable();if(t){t.getColumns().forEach(function(C){C.clearLastValue();});this.TagName="tr";}};
b.prototype.getAccessibilityType=function(B){var t=this.getTable()?"ROW":"OPTION";return B.getText("LIST_ITEM_GROUP_HEADER")+" "+B.getText("ACC_CTR_TYPE_"+t);};
b.prototype.getContentAnnouncement=function(){return this.getTitle();};
b.prototype.getGroupAnnouncement=function(){};
return b;});
sap.ui.predefine('sap/m/GroupHeaderListItemRenderer',["sap/ui/core/library","sap/ui/core/Renderer","./ListItemBaseRenderer"],function(c,R,L){"use strict";var T=c.TextDirection;var G=R.extend(L);
G.renderType=function(r,l){var t=l.getTable();t&&r.write('<td class="sapMListTblNavCol">');L.renderType.apply(this,arguments);t&&r.write('</td>');};
G.renderCounter=function(r,l){};
G.renderLIAttributes=function(r,l){r.addClass("sapMGHLI");if(l.getUpperCase()){r.addClass("sapMGHLIUpperCase");}};
G.renderLIContentWrapper=function(r,l){var t=l.getTable();if(t){r.write('<td class="sapMGHLICell"');r.writeAttribute("colspan",t.getColSpan());r.write(">");}L.renderLIContentWrapper.apply(this,arguments);if(t){r.write("</td>");}};
G.renderLIContent=function(r,l){var t=l.getTitleTextDirection();r.write("<span class='sapMGHLITitle'");if(t!=T.Inherit){r.writeAttribute("dir",t.toLowerCase());}r.write(">");r.writeEscaped(l.getTitle());r.write("</span>");var C=l.getCount()||l.getCounter();if(C){r.write("<span class='sapMGHLICounter'>");r.writeEscaped(" ("+C+")");r.write("</span>");}};
G.addLegacyOutlineClass=function(r,l){if(!l.getTable()){L.addLegacyOutlineClass.apply(this,arguments);}};
G.getAriaRole=function(l){if(l.getTable()){return"row";}return L.getAriaRole.apply(this,arguments);};
return G;},true);
sap.ui.predefine('sap/m/GrowingEnablement',['sap/ui/base/Object','sap/ui/core/format/NumberFormat','sap/m/library','sap/ui/model/ChangeReason','sap/ui/base/ManagedObjectMetadata','sap/ui/core/HTML',"sap/base/security/encodeXML"],function(B,N,l,C,M,H,e){"use strict";var L=l.ListType;var a=l.ListGrowingDirection;
var G=B.extend("sap.m.GrowingEnablement",{
constructor:function(c){B.apply(this);this._oControl=c;this._oControl.bUseExtendedChangeDetection=true;this._oControl.addDelegate(this);var r=this._oControl.getItems(true).length;this._iRenderedDataItems=r;this._iLimit=r;this._bLoading=false;this._sGroupingPath="";this._bDataRequested=false;this._oContainerDomRef=null;this._iLastItemsCount=0;this._iTriggerTimer=0;this._aChunk=[];this._oRM=null;},
destroy:function(){if(this._oTrigger){this._oTrigger.destroy();this._oTrigger=null;}if(this._oScrollDelegate){this._oScrollDelegate.setGrowingList(null);this._oScrollDelegate=null;}if(this._oRM){this._oRM.destroy();this._oRM=null;}this._oControl.$("triggerList").remove();this._oControl.bUseExtendedChangeDetection=false;this._oControl.removeDelegate(this);this._oContainerDomRef=null;this._oControl=null;},
render:function(r){r.write("<div");r.addClass("sapMListUl");r.addClass("sapMGrowingList");r.writeAttribute("id",this._oControl.getId()+"-triggerList");r.addStyle("display","none");r.writeClasses();r.writeStyles();r.write(">");r.renderControl(this._getTrigger());r.write("</div>");},
onAfterRendering:function(){var c=this._oControl;if(c.getGrowingScrollToLoad()){var s=l.getScrollDelegate(c);if(s){this._oScrollDelegate=s;s.setGrowingList(this.onScrollToLoad.bind(this),c.getGrowingDirection());}}else if(this._oScrollDelegate){this._oScrollDelegate.setGrowingList(null);this._oScrollDelegate=null;}if(!this._bLoading){this._updateTriggerDelayed(false);}},
setTriggerText:function(t){this._oControl.$("triggerText").text(t);},
reset:function(){this._iLimit=0;},
shouldReset:function(c){var m=C;return c==m.Sort||c==m.Filter||c==m.Context;},
getInfo:function(){return{total:this._oControl.getMaxItemsCount(),actual:this._iRenderedDataItems};},
onScrollToLoad:function(){var t=this._oControl.getDomRef("triggerList");if(this._bLoading||!t||t.style.display!="none"){return;}if(this._oControl.getGrowingDirection()==a.Upwards){var s=this._oScrollDelegate;this._oScrollPosition={left:s.getScrollLeft(),top:s.getScrollHeight()};}this.requestNewPage();},
requestNewPage:function(){if(!this._oControl||this._bLoading){return;}var b=this._oControl.getBinding("items");if(b&&!b.isLengthFinal()||this._iLimit<this._oControl.getMaxItemsCount()){if(this._oControl.getMetadata().hasProperty("enableBusyIndicator")){this._bParentEnableBusyIndicator=this._oControl.getEnableBusyIndicator();this._oControl.setEnableBusyIndicator(false);}this._iLimit+=this._oControl.getGrowingThreshold();this._updateTriggerDelayed(true);this.updateItems("Growing");}},
_onBeforePageLoaded:function(c){this._bLoading=true;this._oControl.onBeforePageLoaded(this.getInfo(),c);},
_onAfterPageLoaded:function(c){this._bLoading=false;this._updateTriggerDelayed(false);this._oControl.onAfterPageLoaded(this.getInfo(),c);if(this._oControl.setEnableBusyIndicator){this._oControl.setEnableBusyIndicator(this._bParentEnableBusyIndicator);}},
_getTrigger:function(){var t=this._oControl.getId()+"-trigger",T=this._oControl.getGrowingTriggerText();T=T||sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LOAD_MORE_DATA");this._oControl.addNavSection(t);if(this._oTrigger){this.setTriggerText(T);return this._oTrigger;}this._oTrigger=new sap.m.CustomListItem({id:t,busyIndicatorDelay:0,type:L.Active,content:new H({content:'<div class="sapMGrowingListTrigger">'+'<div class="sapMSLITitleDiv sapMGrowingListTriggerText">'+'<span class="sapMSLITitle" id="'+t+'Text">'+e(T)+'</span>'+'</div>'+'<div class="sapMGrowingListDescription sapMSLIDescription" id="'+t+'Info"></div>'+'</div>'})}).setParent(this._oControl,null,true).attachPress(this.requestNewPage,this).addEventDelegate({onsapenter:function(E){this.requestNewPage();E.preventDefault();},onsapspace:function(E){this.requestNewPage();E.preventDefault();},onAfterRendering:function(E){this._oTrigger.$().attr({"tabindex":0,"role":"button","aria-labelledby":t+"Text"+" "+t+"Info"});}},this);this._oTrigger.getList=function(){};this._oTrigger.TagName="div";return this._oTrigger;},
_getListItemInfo:function(){this._iLastItemsCount=this._oControl.getItems(true).length;return("[ "+this._iRenderedDataItems+" / "+N.getFloatInstance().format(this._oControl.getMaxItemsCount())+" ]");},
_getGroupingPath:function(b){var s=b.aSorters||[];var S=s[0]||{};return(S.fnGroup)?S.sPath||"":"";},
_getDomIndex:function(i){if(typeof i!="number"){return i;}if(this._oControl.hasPopin&&this._oControl.hasPopin()){return(i*2);}return i;},
_getHasScrollbars:function(){if(!this._oScrollDelegate){return false;}if(this._iRenderedDataItems>=40){return true;}return this._oScrollDelegate.getMaxScrollTop()>this._oControl.getDomRef("triggerList").clientHeight;},
destroyListItems:function(s){this._oControl.destroyItems(s);this._iRenderedDataItems=0;this._aChunk=[];},
addListItem:function(c,b,s){var o=this._oControl,d=b.binding,i=this.createListItem(c,b);if(d.isGrouped()){var I=o.getItems(true),f=I[I.length-1],m=b.model,g=d.getGroup(i.getBindingContext(m));if(f&&f.isGroupHeader()){o.removeAggregation("items",f,true);this._fnAppendGroupItem=this.appendGroupItem.bind(this,g,f,s);f=I[I.length-1];}if(!f||g.key!==d.getGroup(f.getBindingContext(m)).key){var h=(b.groupHeaderFactory)?b.groupHeaderFactory(g):null;if(o.getGrowingDirection()==a.Upwards){this.applyPendingGroupItem();this._fnAppendGroupItem=this.appendGroupItem.bind(this,g,h,s);}else{this.appendGroupItem(g,h,s);}}}o.addAggregation("items",i,s);if(s){this._aChunk.push(i);}},
applyPendingGroupItem:function(){if(this._fnAppendGroupItem){this._fnAppendGroupItem();this._fnAppendGroupItem=undefined;}},
appendGroupItem:function(g,o,s){o=this._oControl.addItemGroup(g,o,s);if(s){this._aChunk.push(o);}},
createListItem:function(c,b){this._iRenderedDataItems++;var i=b.factory(M.uid("clone"),c);return i.setBindingContext(c,b.model);},
updateItemsBindingContext:function(b,m){if(!b.length){return;}var I=this._oControl.getItems(true);for(var i=0,c=0,o;i<I.length;i++){o=I[i];if(!o.isGroupHeader()){o.setBindingContext(b[c++],m);}}},
applyChunk:function(I,d){this.applyPendingGroupItem();var b=this._aChunk.length;if(!b){return;}if(this._oControl.getGrowingDirection()==a.Upwards){this._aChunk.reverse();if(I===true){I=0;}else if(typeof I=="number"){I=this._iRenderedDataItems-b-I;}}d=d||this._oContainerDomRef;this._oRM=this._oRM||sap.ui.getCore().createRenderManager();for(var i=0;i<b;i++){this._oRM.renderControl(this._aChunk[i]);}this._oRM.flush(d,false,this._getDomIndex(I));this._aChunk=[];},
addListItems:function(c,b,s){for(var i=0;i<c.length;i++){this.addListItem(c[i],b,s);}},
rebuildListItems:function(c,b,s){this.destroyListItems(s);this.addListItems(c,b,s);if(s){var h=this._oContainerDomRef.contains(document.activeElement);this.applyChunk(false);h&&this._oControl.focus();}else{this.applyPendingGroupItem();}},
insertListItem:function(c,b,i){var I=this.createListItem(c,b);this._oControl.insertAggregation("items",I,i,true);this._aChunk.push(I);},
deleteListItem:function(i){this._oControl.getItems(true)[i].destroy(true);this._iRenderedDataItems--;},
refreshItems:function(c){if(!this._bDataRequested){this._bDataRequested=true;this._onBeforePageLoaded(c);}if(!this._iLimit||this.shouldReset(c)||!this._oControl.getItems(true).length){this._iLimit=this._oControl.getGrowingThreshold();}this._oControl.getBinding("items").getContexts(0,this._iLimit);},
updateItems:function(c){var o=this._oControl,b=o.getBinding("items"),d=o.getBindingInfo("items"),I=o.getItems(true);if(!this._iLimit||this.shouldReset(c)||!I.length){this._iLimit=o.getGrowingThreshold();}if(this._bDataRequested){this._bDataRequested=false;}else{this._onBeforePageLoaded(c);}var f=b.getContexts(0,this._iLimit)||[];if(f.dataRequested){this._bDataRequested=true;if(f.diff&&!f.diff.length){return;}}this._oContainerDomRef=o.getItemsContainerDomRef();var D=f.diff,F=false,v;if(!f.length){this.destroyListItems();}else if(!this._oContainerDomRef){this.rebuildListItems(f,d);}else if(!D||!I.length&&D.length){this.rebuildListItems(f,d,true);}else if(b.isGrouped()||o.checkGrowingFromScratch()){if(this._sGroupingPath!=this._getGroupingPath(b)){F=true;}else{for(var i=0;i<D.length;i++){var g=D[i],h=f[g.index];if(g.type=="delete"){F=true;break;}else if(g.index!=this._iRenderedDataItems){F=true;break;}else{this.addListItem(h,d,true);v=true;}}}}else{if(this._sGroupingPath){o.removeGroupHeaders(true);}v=-1;var j=-1;for(var i=0;i<D.length;i++){var g=D[i],k=g.index,h=f[k];if(g.type=="delete"){if(v!=-1){this.applyChunk(v);j=-1;v=-1;}this.deleteListItem(k);}else{if(v==-1){v=k;}else if(j>-1&&k!=j+1){this.applyChunk(v);v=k;}this.insertListItem(h,d,k);j=k;}}}if(F){this.rebuildListItems(f,d,true);}else if(this._oContainerDomRef&&D){this.updateItemsBindingContext(f,d.model);this.applyChunk(v);}this._oContainerDomRef=null;this._sGroupingPath=this._getGroupingPath(b);if(!this._bDataRequested){this._onAfterPageLoaded(c);}},
_updateTriggerDelayed:function(b){if(this._oControl.getGrowingScrollToLoad()){this._iTriggerTimer&&window.cancelAnimationFrame(this._iTriggerTimer);this._iTriggerTimer=window.requestAnimationFrame(this._updateTrigger.bind(this,b));}else{this._updateTrigger(b);}},
_updateTrigger:function(b){var t=this._oTrigger,c=this._oControl;if(!t||!c||!c.shouldRenderItems()||!c.getDomRef()){return;}var o=c.getBinding("items");if(!o){return;}t.setBusy(b);t.$().toggleClass("sapMGrowingListBusyIndicatorVisible",b);if(b){t.setActive(false);c.$("triggerList").css("display","");}else{var i=c.getItems(true),I=i.length,d=o.getLength()||0,f=o.isLengthFinal(),h=c.getGrowingScrollToLoad(),T=t.getDomRef();if(T&&T.contains(document.activeElement)){(i[this._iLastItemsCount]||c).focus();}if(!I||!this._iLimit||(f&&this._iLimit>=d)||(h&&this._getHasScrollbars())){c.$("triggerList").css("display","none");}else{if(f){c.$("triggerInfo").css("display","block").text(this._getListItemInfo());}t.$().removeClass("sapMGrowingListBusyIndicatorVisible");c.$("triggerList").css("display","");}if(h&&this._oScrollPosition===undefined&&c.getGrowingDirection()==a.Upwards){this._oScrollPosition={left:0,top:0};}if(I>0&&this._oScrollPosition){var s=this._oScrollDelegate,S=this._oScrollPosition;s.scrollTo(S.left,s.getScrollHeight()-S.top);this._oScrollPosition=null;}}}
});
return G;});
sap.ui.predefine('sap/m/GrowingList',['./List','./library','./GrowingListRenderer'],function(L,l,G){"use strict";
var a=L.extend("sap.m.GrowingList",{metadata:{deprecated:true,library:"sap.m",properties:{threshold:{type:"int",group:"Misc",defaultValue:20},triggerText:{type:"string",group:"Appearance",defaultValue:null},scrollToLoad:{type:"boolean",group:"Behavior",defaultValue:false}}}});
a.prototype._isIncompatible=function(){return sap.ui.getCore().getConfiguration().getCompatibilityVersion("sapMGrowingList").compareTo("1.16")>=0;};
a.prototype.init=function(){L.prototype.init.call(this);if(!this._isIncompatible()){this.setGrowing();}};
a.prototype.setGrowing=function(){return L.prototype.setGrowing.call(this,true);};
!(function(g,o){["Threshold","TriggerText","ScrollToLoad"].forEach(function(p){g["set"+p]=o["setGrowing"+p];g["get"+p]=o["getGrowing"+p];});}(a.prototype,L.prototype));return a;});
sap.ui.predefine('sap/m/GrowingListRenderer',['./ListRenderer','sap/ui/core/Renderer',"sap/base/Log"],function(L,R,a){"use strict";var G=R.extend(L);
G.render=function(r,c){if(c._isIncompatible()){a.warning("Does not render sap.m.GrowingList#"+c.getId()+" when compatibility version is 1.16 or higher. Instead use sap.m.List/Table control with growing feature!");}else{L.render.call(this,r,c);}};
return G;},true);
sap.ui.predefine('sap/m/HBox',['./FlexBox','./library','./HBoxRenderer'],function(F,l,H){"use strict";
var a=F.extend("sap.m.HBox",{metadata:{library:"sap.m",designtime:"sap/m/designtime/HBox.designtime"}});
return a;});
sap.ui.predefine('sap/m/HBoxRenderer',['./FlexBoxRenderer'],function(F){"use strict";var H={};
H.render=function(r,c){F.render.apply(this,[r,c]);};
return H;},true);
sap.ui.predefine('sap/m/HeaderContainer',['./library','sap/ui/core/Control','sap/ui/Device','sap/ui/core/delegate/ItemNavigation','sap/ui/core/library','sap/ui/core/IntervalTrigger','sap/ui/base/ManagedObject','sap/ui/core/Icon','./HeaderContainerRenderer',"sap/base/Log","sap/ui/events/PseudoEvents","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/control","sap/ui/dom/jquery/scrollLeftRTL","sap/ui/dom/jquery/scrollRightRTL","sap/ui/dom/jquery/Selectors"],function(l,C,D,I,c,a,M,b,H,L,P,q){"use strict";var O=c.Orientation;
var d=C.extend("sap.m.HeaderContainerItemContainer",{
metadata:{defaultAggregation:"item",properties:{position:{type:"int",defaultValue:null},setSize:{type:"int",defaultValue:null},ariaLabelledBy:{type:"string",defaultValue:null}},aggregations:{item:{type:"sap.ui.core.Control",multiple:false}}},
renderer:function(r,o){var i=o.getAggregation("item");if(!i||!i.getVisible()){return;}r.write("<div");r.writeControlData(o);r.addClass("sapMHdrCntrItemCntr");r.addClass("sapMHrdrCntrInner");r.writeAttribute("aria-setsize",o.getSetSize());r.writeAttribute("aria-posinset",o.getPosition());r.writeAttribute("role","listitem");if(o.getAriaLabelledBy()){r.writeAttributeEscaped("aria-labelledby",o.getAriaLabelledBy());}r.writeClasses();r.write(">");r.renderControl(i);r.write("</div>");}
});
var e=C.extend("sap.m.HeaderContainer",{metadata:{interfaces:["sap.m.ObjectHeaderContainer"],library:"sap.m",properties:{scrollStep:{type:"int",defaultValue:300,group:"Behavior"},scrollStepByItem:{type:"int",defaultValue:1,group:"Behavior"},scrollTime:{type:"int",defaultValue:500,group:"Behavior"},showOverflowItem:{type:"boolean",defaultValue:true,group:"Behavior"},showDividers:{type:"boolean",defaultValue:true,group:"Appearance"},orientation:{type:"sap.ui.core.Orientation",defaultValue:O.Horizontal,group:"Appearance"},backgroundDesign:{type:"sap.m.BackgroundDesign",defaultValue:l.BackgroundDesign.Transparent,group:"Appearance"},width:{type:"sap.ui.core.CSSSize",group:"Appearance"},height:{type:"sap.ui.core.CSSSize",group:"Appearance"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true},_scrollContainer:{type:"sap.m.ScrollContainer",multiple:false,visibility:"hidden"},_prevButton:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_nextButton:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}}});
e.prototype.init=function(){this._aItemEnd=[];this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oScrollCntr=new l.ScrollContainer(this.getId()+"-scrl-cntnr",{width:"100%",height:"100%",horizontal:!D.system.desktop});this.setAggregation("_scrollContainer",this._oScrollCntr,true);if(D.system.desktop){this._oArrowPrev=new l.Button({id:this.getId()+"-scrl-prev-button",type:l.ButtonType.Transparent,tooltip:this._oRb.getText("HEADERCONTAINER_BUTTON_PREV_SECTION"),press:function(E){E.cancelBubble();this._scroll(this._getScrollValue(false),this.getScrollTime());}.bind(this)}).addStyleClass("sapMHdrCntrBtn").addStyleClass("sapMHdrCntrLeft");this._oArrowPrev._bExcludeFromTabChain=true;this.setAggregation("_prevButton",this._oArrowPrev,true);this._oArrowNext=new l.Button({id:this.getId()+"-scrl-next-button",type:l.ButtonType.Transparent,tooltip:this._oRb.getText("HEADERCONTAINER_BUTTON_NEXT_SECTION"),press:function(E){E.cancelBubble();this._scroll(this._getScrollValue(true),this.getScrollTime());}.bind(this)}).addStyleClass("sapMHdrCntrBtn").addStyleClass("sapMHdrCntrRight");this._oArrowNext._bExcludeFromTabChain=true;this.setAggregation("_nextButton",this._oArrowNext,true);}else if(D.system.phone||D.system.tablet){this._oArrowPrev=new b({id:this.getId()+"-scrl-prev-button"}).addStyleClass("sapMHdrCntrBtn").addStyleClass("sapMHdrCntrLeft");this.setAggregation("_prevButton",this._oArrowPrev,true);this._oArrowNext=new b({id:this.getId()+"-scrl-next-button"}).addStyleClass("sapMHdrCntrBtn").addStyleClass("sapMHdrCntrRight");this.setAggregation("_nextButton",this._oArrowNext,true);}this._oScrollCntr.addDelegate({onAfterRendering:function(){if(D.system.desktop){var f=this._oScrollCntr.getDomRef("scroll");var F=this._oScrollCntr.$("scroll");var g=F.find(".sapMHrdrCntrInner").attr("tabindex","0");if(!this._oItemNavigation){this._oItemNavigation=new I();this.addDelegate(this._oItemNavigation);this._oItemNavigation.attachEvent(I.Events.BorderReached,this._handleBorderReached,this);this._oItemNavigation.attachEvent(I.Events.AfterFocus,this._handleBorderReached,this);this._oItemNavigation.attachEvent(I.Events.BeforeFocus,this._handleBeforeFocus,this);if(D.browser.msie||D.browser.edge){this._oItemNavigation.attachEvent(I.Events.FocusAgain,this._handleFocusAgain,this);}}this._oItemNavigation.setRootDomRef(f);this._oItemNavigation.setItemDomRefs(g);this._oItemNavigation.setTabIndex0();this._oItemNavigation.setCycling(false);}}.bind(this)});a.addListener(this._checkOverflow,this);};
e.prototype.onBeforeRendering=function(){if(!this.getHeight()){L.warning("No height provided",this);}if(!this.getWidth()){L.warning("No width provided",this);}if(D.system.desktop){this._oArrowPrev.setIcon(this.getOrientation()===O.Horizontal?"sap-icon://slim-arrow-left":"sap-icon://slim-arrow-up");this._oArrowNext.setIcon(this.getOrientation()===O.Horizontal?"sap-icon://slim-arrow-right":"sap-icon://slim-arrow-down");}else if(D.system.phone||D.system.tablet){this._oArrowPrev.setSrc(this.getOrientation()===O.Horizontal?"sap-icon://slim-arrow-left":"sap-icon://slim-arrow-up");this._oArrowNext.setSrc(this.getOrientation()===O.Horizontal?"sap-icon://slim-arrow-right":"sap-icon://slim-arrow-down");}};
e.prototype.onAfterRendering=function(){this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._checkOverflow();};
e.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();this._oItemNavigation=null;}a.removeListener(this._checkOverflow,this);};
e.prototype.onsaptabnext=function(E){var f=this.$().find(":focusable");var t=f.index(E.target);var n=f.eq(t+1).get(0);var F=this._getParentCell(E.target);var T;if(n){T=this._getParentCell(n);}if((F&&T&&F.id!==T.id)||(n&&n.id===this.getId()+"-after")||(n&&n.id===this.getId()+"-scrl-prev-button")||(n&&n.id===this.getId()+"-scrl-next-button")){var o=f.last().get(0);if(o){this._bIgnoreFocusIn=true;o.focus();}}};
e.prototype.onsaptabprevious=function(E){this.$().find(".sapMHdrCntrItemCntr").css("border-color","");var f=this.$().find(":focusable");var t=f.index(E.target);var p=f.eq(t-1).get(0);var F=this._getParentCell(E.target);var T;if(p){T=this._getParentCell(p);}if(!T||F&&F.id!==T.id){var s=this.$().attr("tabindex");this.$().attr("tabindex","0");this.$().focus();if(!s){this.$().removeAttr("tabindex");}else{this.$().attr("tabindex",s);}}};
e.prototype.setOrientation=function(v){this.setProperty("orientation",v);if(v===O.Horizontal&&!D.system.desktop){this._oScrollCntr.setHorizontal(true);this._oScrollCntr.setVertical(false);}else if(!D.system.desktop){this._oScrollCntr.setHorizontal(false);this._oScrollCntr.setVertical(true);}return this;};
e.prototype.validateAggregation=function(A,o,m){return this._callMethodInManagedObject("validateAggregation",A,o,m);};
e.prototype.getAggregation=function(A,o,s){return this._callMethodInManagedObject("getAggregation",A,o,s);};
e.prototype.setAggregation=function(A,o,s){return this._callMethodInManagedObject("setAggregation",A,o,s);};
e.prototype.indexOfAggregation=function(A,o){return this._callMethodInManagedObject("indexOfAggregation",A,o);};
e.prototype.insertAggregation=function(A,o,i,s){return this._callMethodInManagedObject("insertAggregation",A,o,i,s);};
e.prototype.addAggregation=function(A,o,s){return this._callMethodInManagedObject("addAggregation",A,o,s);};
e.prototype.removeAggregation=function(A,o,s){return this._callMethodInManagedObject("removeAggregation",A,o,s);};
e.prototype.removeAllAggregation=function(A,s){return this._callMethodInManagedObject("removeAllAggregation",A,s);};
e.prototype.destroyAggregation=function(A,s){return this._callMethodInManagedObject("destroyAggregation",A,s);};
e.prototype._setScrollInProcess=function(v){this.bScrollInProcess=v;};
e.prototype._scroll=function(i,f){this._setScrollInProcess(true);setTimeout(this._setScrollInProcess.bind(this,false),f+300);if(this.getOrientation()===O.Horizontal){this._hScroll(i,f);}else{this._vScroll(i,f);}};
e.prototype._vScroll=function(f,g){var o=this._oScrollCntr.getDomRef(),s=o.scrollTop,S=o.scrollHeight,i=s+f,h=o.clientHeight,p=parseFloat(this.$("scroll-area").css("padding-top")),r;if(i<=0){r=this._calculateRemainingScrolling(f,g,s);this.$("scroll-area").css("transition","padding "+r+"s");this.$().removeClass("sapMHrdrTopPadding");}else if(i+h+p>=S){r=this._calculateRemainingScrolling(f,g,S-h-s);this.$("scroll-area").css("transition","padding "+r+"s");if(h+f>S&&h!==S){this.$().removeClass("sapMHrdrBottomPadding");this.$().addClass("sapMHrdrTopPadding");}else{this.$().removeClass("sapMHrdrBottomPadding");}}else{this.$("scroll-area").css("transition","padding "+g/1000+"s");}this._oScrollCntr.scrollTo(0,i,g);};
e.prototype._hScroll=function(f,g){var o=this._oScrollCntr.getDomRef();var s,S,i,h,p,r;if(!this._bRtl){S=o.scrollLeft;h=o.scrollWidth;i=o.clientWidth+(D.browser.msie?1:0);s=S+f;p=parseFloat(this.$("scroll-area").css("padding-left"));if(s<=0){r=this._calculateRemainingScrolling(f,g,S);this.$("scroll-area").css("transition","padding "+r+"s");this.$().removeClass("sapMHrdrLeftPadding");}else if(s+o.clientWidth+p>=h){r=this._calculateRemainingScrolling(f,g,h-i-S);this.$("scroll-area").css("transition","padding "+r+"s");if(i+f>h&&i!==h){this.$().removeClass("sapMHrdrRightPadding");this.$().addClass("sapMHrdrLeftPadding");}else{this.$().removeClass("sapMHrdrRightPadding");}}else{this.$("scroll-area").css("transition","padding "+g/1000+"s");}this._oScrollCntr.scrollTo(s,0,g);}else{s=q(o).scrollRightRTL()+f;this._oScrollCntr.scrollTo((s>0)?s:0,0,g);}};
e.prototype._collectItemSize=function(){var s=0,f=this._filterVisibleItems(),F=this.getOrientation()===O.Horizontal?"outerWidth":"outerHeight";this._aItemEnd=[];f.forEach(function(o,i){s+=o.$().parent()[F](true);this._aItemEnd[i]=s;},this);};
e.prototype._getScrollValue=function(f){if(!this._oScrollCntr){return 0;}var h=this.getOrientation()===O.Horizontal,$=this._oScrollCntr.$(),g=this.$("prev-button-container"),j=this.$("next-button-container"),s=h?$[0].scrollLeft:$[0].scrollTop,t=0,S=0,m,n=this._filterVisibleItems();var G=function(k){var S=0,B=0;var p=10;if(this._bRtl&&h){if(!g.is(":visible")){B=g.width();}if(!j.is(":visible")){B=j.width();}}for(var i=0;i<n.length&&i<k;i++){S+=o(n[i]);}return S!==0?S+p-B:0;}.bind(this);var o=function(k){return h?k.$().parent().outerWidth(true):k.$().parent().outerHeight(true);};var E=function(){var S=this._getSize(true),p,A=0;for(var i=t;i<n.length;i++){if(!n[i].$().is(":visible")){p=o(n[i])+G(i)-S-s;for(var k=t;k<n.length&&k<i;k++){if(m+A>p){break;}t++;A+=o(n[k]);}m+=A;break;}}}.bind(this);if(this.getScrollStepByItem()>0){s=h&&this._bRtl?$.scrollRightRTL():s;for(var i=0;i<n.length;i++){S+=o(n[i]);if(S>=s){t=i;break;}}t=(f?1:-1)*this.getScrollStepByItem()+t;if(t<0){t=0;}if(t>=n.length){t=n.length-1;}m=G(t)-s;if(f&&!this.getShowOverflowItem()){E();}return m;}return f?this.getScrollStep():-this.getScrollStep();};
e.prototype._calculateRemainingScrolling=function(f,g,h){return Math.abs(h*g/(1000*f));};
e.prototype._checkOverflow=function(){if(this.getOrientation()===O.Horizontal){this._checkHOverflow();}else{this._checkVOverflow();}};
e.prototype._filterVisibleItems=function(){return this.getContent().filter(function(i){return i.getVisible();});};
e.prototype._getFirstItemOffset=function(t){var f=this._filterVisibleItems()[0],$=f&&f.$(),g=$&&$.parent(),F=g&&g[0]&&g[0][t];return F||0;};
e.prototype._checkVOverflow=function(){var B=this._oScrollCntr.getDomRef(),o,$;if(B){var f=this._getFirstItemOffset("offsetTop");var s=Math.ceil(B.scrollTop);var S=false;var g=false;var r=B.scrollHeight;var h=B.clientHeight;if(Math.abs(r-h)===1){r=h;}if(s>f){S=true;}if((r>h)&&(s+h<r)){g=true;}g=this._checkForOverflowItem(g);$=this.$("prev-button-container");o=$.is(":visible");if(o&&!S){$.hide();this.$().removeClass("sapMHrdrTopPadding");}if(!o&&S){$.show();this.$().addClass("sapMHrdrTopPadding");}$=this.$("next-button-container");var i=$.is(":visible");if(i&&!g){$.hide();this.$().removeClass("sapMHrdrBottomPadding");}if(!i&&g){$.show();this.$().addClass("sapMHrdrBottomPadding");}}};
e.prototype._checkHOverflow=function(){var B=this._oScrollCntr.getDomRef(),$;if(B){var f=this._getFirstItemOffset("offsetLeft");var s=Math.ceil(B.scrollLeft);var S=false;var g=false;var r=B.scrollWidth;var h=B.clientWidth;if(Math.abs(r-h)===1){r=h;}if(this._bRtl){var i=q(B).scrollLeftRTL();if(i>((D.browser.msie||D.browser.edge)?1:0)){g=true;}}else if(s>f){S=true;}if(r-5>h){if(this._bRtl){if(q(B).scrollRightRTL()>1){S=true;}}else if(s+h<r){g=true;}}$=this.$("prev-button-container");g=this._checkForOverflowItem(g);var o=$.is(":visible");if(o&&!S){$.hide();this.$().removeClass("sapMHrdrLeftPadding");}if(!o&&S){$.show();this.$().addClass("sapMHrdrLeftPadding");}$=this.$("next-button-container");var j=$.is(":visible");if(j&&!g){$.hide();this.$().removeClass("sapMHrdrRightPadding");}if(!j&&g){$.show();this.$().addClass("sapMHrdrRightPadding");}}};
e.prototype._getSize=function(A){var $=this._oScrollCntr.$(),h=this.getOrientation()===O.Horizontal,f=this.$("next-button-container"),g=!f.is(":visible")&&A,F=h?"width":"height";return $[F]()-(g?f[F]():0);};
e.prototype._checkForOverflowItem=function(s){if(this._oScrollCntr&&!this.getShowOverflowItem()){var $=this._oScrollCntr.$(),h=this.getOrientation()===O.Horizontal,S=!h?$[0].scrollTop:(this._bRtl?$.scrollRightRTL():$[0].scrollLeft),f=h?"width":"height",g=this._getSize(s),j=this._filterVisibleItems();this._collectItemSize();this._aItemEnd.forEach(function(E,i){var k=j[i].$(),m=k.parent(),v=k.is(":visible");if(s&&E>S+g){if(i===0||this._aItemEnd[i-1]<=S){m.css(f,"auto");k.show();}else if(v){m[f](m[f]());k.hide();s=true;}}else{if(!v){m.css(f,"auto");k.show();}}},this);}return s;};
e.prototype._handleBorderReached=function(E){if(D.browser.msie&&this.bScrollInProcess){return;}var i=E.getParameter("index");if(i===0){this._scroll(this._getScrollValue(false),this.getScrollTime());}else if(i===this._filterVisibleItems().length-1){this._scroll(this._getScrollValue(true),this.getScrollTime());}};
e.prototype._handleFocusAgain=function(E){E.getParameter("event").preventDefault();};
e.prototype._handleBeforeFocus=function(E){var o=E.getParameter("event");if(q(o.target).hasClass("sapMHdrCntrItemCntr")||q(o.target).hasClass("sapMScrollContScroll")||P.events.sapprevious.fnCheck(o)||P.events.sapnext.fnCheck(o)){this.$().find(".sapMHdrCntrItemCntr").css("border-color","");}else{this.$().find(".sapMHdrCntrItemCntr").css("border-color","transparent");}};
e.prototype._unWrapHeaderContainerItemContainer=function(w){if(w instanceof d){w=w.getItem();}else if(Array.isArray(w)){for(var i=0;i<w.length;i++){if(w[i]instanceof d){w[i]=w[i].getItem();}}}return w;};
e._AGGREGATION_FUNCTIONS=["validateAggregation","validateAggregation","getAggregation","setAggregation","indexOfAggregation","removeAggregation"];e._AGGREGATION_FUNCTIONS_FOR_INSERT=["insertAggregation","addAggregation"];
e.prototype._callMethodInManagedObject=function(f,A){var g=Array.prototype.slice.call(arguments);if(A==="content"){var o=g[2];g[1]="content";if(o instanceof C){if(((e._AGGREGATION_FUNCTIONS?Array.prototype.indexOf.call(e._AGGREGATION_FUNCTIONS,f):-1))>-1&&o.getParent()instanceof d){g[2]=o.getParent();}else if(((e._AGGREGATION_FUNCTIONS_FOR_INSERT?Array.prototype.indexOf.call(e._AGGREGATION_FUNCTIONS_FOR_INSERT,f):-1))>-1){g[2]=new d({item:o});}}var r=this._oScrollCntr[f].apply(this._oScrollCntr,g.slice(1));if(f!=="removeAllAggregation"){var h=this._oScrollCntr.getContent();var j=this.getAriaLabelledBy();for(var i=0;i<h.length;i++){var k=h[i];k.setPosition(i+1);k.setSetSize(h.length);k.setAriaLabelledBy(j[i]);}}return this._unWrapHeaderContainerItemContainer(r);}else{return M.prototype[f].apply(this,g.slice(1));}};
e.prototype._getParentCell=function(o){return q(o).parents(".sapMHrdrCntrInner").andSelf(".sapMHrdrCntrInner").get(0);};
e.prototype.onfocusin=function(E){if(this._bIgnoreFocusIn){this._bIgnoreFocusIn=false;return;}if(E.target.id===this.getId()+"-after"){this._restoreLastFocused();}};
e.prototype._restoreLastFocused=function(){if(!this._oItemNavigation){return;}var n=this._oItemNavigation.getItemDomRefs();var i=this._oItemNavigation.getFocusedIndex();var $=q(n[i]);var r=$.control(0)||{};var t=r.getTabbables?r.getTabbables():$.find(":sapTabbable");t.eq(-1).add($).eq(-1).focus();};
return e;});
sap.ui.predefine('sap/m/HeaderContainerRenderer',['sap/ui/core/library',"sap/base/security/encodeCSS"],function(c,e){"use strict";var O=c.Orientation;var H={};
H.render=function(r,C){var t=C.getTooltip_AsString();var o=C.getOrientation();if(o){o=e(o);}var b=e("sapMHdrCntrBG"+C.getBackgroundDesign());r.write("<div");r.writeControlData(C);if(t&&(typeof t==="string")){r.writeAttributeEscaped("title",t);}r.addClass("sapMHdrCntr");r.addClass(o);if(C.getShowDividers()){r.addClass("sapMHrdrCntrDvdrs");}r.writeClasses();if(C.getHeight()){r.addStyle("height",C.getHeight());}else{r.addStyle("height",(C.getOrientation()===O.Horizontal)?"auto":"100%");}if(C.getWidth()){r.addStyle("width",C.getWidth());}else{r.addStyle("width",(C.getOrientation()===O.Horizontal)?"100%":"auto");}r.writeStyles();var d="";var a=C.getContent();for(var i=0;a&&i<a.length;i++){d+=a[i].getId()+" ";}r.writeAttribute("aria-labelledby",d);r.write(">");r.write("<div");r.writeAttributeEscaped("id",C.getId()+"-scroll-area");r.addClass("sapMHdrCntrCntr");r.addClass(o);r.addClass(b);r.writeClasses();r.write(">");r.renderControl(C.getAggregation("_scrollContainer"));r.write("</div>");var B=C.getAggregation("_prevButton");if(B){r.write("<div");r.writeAttributeEscaped("id",C.getId()+"-prev-button-container");r.addClass("sapMHdrCntrBtnCntr");r.addClass("sapMHdrCntrLeft");r.addClass(o);r.writeClasses();r.write(">");r.renderControl(B);r.write("</div>");}B=C.getAggregation("_nextButton");if(B){r.write("<div");r.writeAttributeEscaped("id",C.getId()+"-next-button-container");r.addClass("sapMHdrCntrBtnCntr");r.addClass("sapMHdrCntrRight");r.addClass(o);r.writeClasses();r.write(">");r.renderControl(B);r.write("</div>");}r.write("<div");r.writeAttribute("id",C.getId()+"-after");r.writeAttribute("tabindex","0");r.write("></div>");r.write("</div>");};
return H;},true);
sap.ui.predefine('sap/m/HyphenationSupport',["sap/ui/core/Core","./library","sap/ui/core/hyphenation/Hyphenation","sap/base/Log"],function(C,l,H,L){"use strict";var W=l.WrappingType;
function i(o){if(!o.isA("sap.m.IHyphenation")){L.error("[UI5 Hyphenation] The given control does not implement interface sap.m.IHyphenation and can not use HyphenationSupport mixin.");return false;}return true;}
function a(o,k){var t=o.getTextsToBeHyphenated();if(typeof t!=="object"){L.error("[UI5 Hyphenation] The result of getTextsToBeHyphenated method is not a map object.",o.getId());return false;}if(Object.keys(t).indexOf(k)<0){L.error("[UI5 Hyphenation] The key "+k+" is not found in the result of getTextsToBeHyphenated method.",o.getId());return false;}return true;}
function s(D,n){n=n||"";var f=D.childNodes;if(f.length===1&&f[0].nodeType===window.Node.TEXT_NODE){f[0].nodeValue=n;}else{D.textContent=n;}}
function d(t,T){var D=[];Object.keys(t).forEach(function(k){if(!(k in T&&t[k]===T[k])){D.push(k);}});return D;}
function b(){var f=C.getConfiguration().getHyphenation(),o=H.getInstance();if(f==="native"||f==="disable"){return false;}if(f==="thirdparty"){return true;}return o.isLanguageSupported()&&!o.canUseNativeHyphenation()&&o.canUseThirdPartyHyphenation();}
function c(o){var f=C.getConfiguration().getHyphenation();if(f==='disable'){return false;}if(o.getWrappingType()===W.Hyphenated&&!o.getWrapping()){L.warning("[UI5 Hyphenation] The property wrappingType=Hyphenated will not take effect unless wrapping=true.",o.getId());}return o.getWrapping()&&o.getWrappingType()===W.Hyphenated;}
function h(o){if(!c(o)||!b()){o._mHyphenatedTexts={};o._mUnhyphenatedTexts={};return;}var t=o.getTextsToBeHyphenated(),f=d(t,o._mUnhyphenatedTexts);if(f.length>0){o._mUnhyphenatedTexts=t;f.forEach(function(k){delete o._mHyphenatedTexts[k];});var g=H.getInstance();if(!g.isLanguageInitialized()){g.initialize().then(function(){var D=o.isActive()?o.getDomRefsForHyphenatedTexts():null,n=false;f.forEach(function(k){o._mHyphenatedTexts[k]=g.hyphenate(t[k]);if(D&&k in D){s(D[k],o._mHyphenatedTexts[k]);}else{n=true;}});if(n){o.invalidate();}});}else{f.forEach(function(k){o._mHyphenatedTexts[k]=g.hyphenate(t[k]);});}}}
var e={};
e.mixInto=function(o){if(!i(o)){return;}var I=o.init;o.init=function(f){var r=I.apply(this,arguments);this._mHyphenatedTexts={};this._mUnhyphenatedTexts={};return r;};var O=o.onBeforeRendering;o.onBeforeRendering=function(){var r=O.apply(this,arguments);h(this);return r;};};
e.writeHyphenationClass=function(r,o){if(!i(o)){return;}if(c(o)&&!b()){r.class("sapUiHyphenation");}};
e.getTextForRender=function(o,k){if(!i(o)){return null;}if(!a(o,k)){return null;}var t=o.getTextsToBeHyphenated();if(c(o)&&b()){if(t[k]!==o._mUnhyphenatedTexts[k]){h(o);}if(k in o._mHyphenatedTexts){return o._mHyphenatedTexts[k];}}return t[k];};
return e;});
sap.ui.predefine('sap/m/IconTabBar',['./library','sap/ui/core/Control','sap/ui/base/ManagedObject','./IconTabBarRenderer',"sap/ui/thirdparty/jquery"],function(l,C,M,I,q){"use strict";var a=l.IconTabHeaderMode;var B=l.BackgroundDesign;var b=l.IconTabDensityMode;
var c=C.extend("sap.m.IconTabBar",{metadata:{interfaces:["sap.m.ObjectHeaderContainer"],library:"sap.m",properties:{showSelection:{type:"boolean",group:"Misc",defaultValue:true,deprecated:true},expandable:{type:"boolean",group:"Misc",defaultValue:true},expanded:{type:"boolean",group:"Misc",defaultValue:true},selectedKey:{type:"string",group:"Data",defaultValue:null},upperCase:{type:"boolean",group:"Appearance",defaultValue:false},stretchContentHeight:{type:"boolean",group:"Appearance",defaultValue:false},applyContentPadding:{type:"boolean",group:"Appearance",defaultValue:true},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:B.Solid},headerMode:{type:"sap.m.IconTabHeaderMode",group:"Appearance",defaultValue:a.Standard},showOverflowSelectList:{type:"boolean",group:"Appearance",defaultValue:false},headerBackgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:B.Solid},enableTabReordering:{type:"boolean",group:"Behavior",defaultValue:false},tabDensityMode:{type:"sap.m.IconTabDensityMode",group:"Appearance",defaultValue:b.Cozy}},aggregations:{items:{type:"sap.m.IconTab",multiple:true,singularName:"item",forwarding:{getter:"_getIconTabHeader",aggregation:"items",forwardBinding:true}},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},_header:{type:"sap.m.IconTabHeader",multiple:false,visibility:"hidden"}},events:{select:{parameters:{item:{type:"sap.m.IconTabFilter"},key:{type:"string"},selectedItem:{type:"sap.m.IconTabFilter"},selectedKey:{type:"string"}}},expand:{parameters:{expand:{type:"boolean"},collapse:{type:"boolean"}}}},designtime:"sap/m/designtime/IconTabBar.designtime"}});
c.prototype.setExpanded=function(e){this.setProperty("expanded",e,true);if(this.$().length){this._toggleExpandCollapse(e);}return this;};
c.prototype.setExpandable=function(e){this.setProperty("expandable",e,true);return this;};
c.prototype.setHeaderMode=function(m){this.setProperty("headerMode",m,true);this._getIconTabHeader().setMode(m);return this;};
c.prototype.setTabDensityMode=function(m){this.setProperty("tabDensityMode",m);this._getIconTabHeader().setTabDensityMode(m);return this;};
c.prototype.setHeaderBackgroundDesign=function(h){this.setProperty("headerBackgroundDesign",h,true);this._getIconTabHeader().setBackgroundDesign(h);return this;};
c.prototype.setShowOverflowSelectList=function(v){this.setProperty("showOverflowSelectList",v,true);this._getIconTabHeader().setShowOverflowSelectList(v);return this;};
c.prototype.setEnableTabReordering=function(v){this.setProperty("enableTabReordering",v,true);this._getIconTabHeader().setEnableTabReordering(v);return this;};
c.prototype._rerenderContent=function(o){var $=this.$("content");if(o&&($.length>0)){var r=sap.ui.getCore().createRenderManager();for(var i=0;i<o.length;i++){r.renderControl(o[i]);}r.flush($[0]);r.destroy();}};
c.prototype._toggleExpandCollapse=function(e){var $=this.$("content");var s=this._getIconTabHeader().oSelectedItem;if(e===undefined){e=!this.getExpanded();}if(s){s.$().toggleClass("sapMITBSelected",e);s.$().attr({'aria-expanded':e});if(e){s.$().attr({'aria-selected':e});}else{s.$().removeAttr('aria-selected');}}this._iAnimationCounter=(this._iAnimationCounter===undefined?1:++this._iAnimationCounter);if(e){if(s){if(this.$("content").children().length===0){var S=s.getContent();if(S.length>0){this._rerenderContent(S);}else{this._rerenderContent(this.getContent());}}$.stop(true,true).slideDown('400',q.proxy(this.onTransitionEnded,this,e));this.$("containerContent").toggleClass("sapMITBContentClosed",!e);}}else{this.$("contentArrow").hide();$.stop(true,true).slideUp('400',q.proxy(this.onTransitionEnded,this,e));}if(!e||s){this.setProperty("expanded",e,true);}this.fireExpand({expand:e,collapse:!e});return this;};
c.prototype.onTransitionEnded=function(e){var $=this.$("content"),d=this.$("containerContent"),f=this.$("contentArrow");if(this._iAnimationCounter===1){d.toggleClass("sapMITBContentClosed",!e);if(e){f.show();$.css("display","block");}else{f.hide();$.css("display","none");}}this._iAnimationCounter=(this._iAnimationCounter>0?--this._iAnimationCounter:0);return this;};
c.prototype._getIconTabHeader=function(){var o=this.getAggregation("_header");if(!o){o=new sap.m.IconTabHeader(this.getId()+"--header",{});this.setAggregation("_header",o,true);}return o;};
c.prototype.setShowSelection=function(v){this._getIconTabHeader().setShowSelection(v);return this;};
c.prototype.getShowSelection=function(){return this._getIconTabHeader().getShowSelection();};
c.prototype.setSelectedKey=function(v){this._getIconTabHeader().setSelectedKey(v);return this;};
c.prototype.getSelectedKey=function(){return this._getIconTabHeader().getSelectedKey();};
c.prototype.setSelectedItem=function(i,A){return this._getIconTabHeader().setSelectedItem(i,A);};
return c;});
sap.ui.predefine('sap/m/IconTabBarDragAndDropUtil',['sap/ui/core/dnd/DragInfo','sap/ui/core/dnd/DropInfo',"sap/ui/events/KeyCodes"],function(D,a,K){"use strict";var I="Before",b="insertBefore",c="insertAfter",i,d="IconTabReorder";var e={_insertControl:function(i,$,f){if(i===c){$.insertAfter(f);}else{$.insertBefore(f);}},handleDrop:function(f,s,o,g,h){var B=f.indexOfItem(o),j=f.indexOfItem(g),$=o.$(),k=g.$(),A=0,r=sap.ui.getCore().getConfiguration().getRTL(),l=s===I;if(r&&!h){if(l){A=B<j?j:j+1;i=c;}else{A=B<j?j-1:j;i=b;}}else{if(l){A=B<j?j-1:j;i=b;}else{A=B<j?j:j+1;i=c;}}e._insertControl(i,$,k);e._handleConfigurationAfterDragAndDrop.call(f,o,A);},_updateAccessibilityInfo:function(){var o=this.getItems(),A=1,f;o.forEach(function(g){f=g.getDomRef();if(f&&f.getAttribute("aria-posinset")!==null){f.setAttribute("aria-posinset",A++);}});},_handleConfigurationAfterDragAndDrop:function(o,f){this.removeAggregation('items',o,true);this.insertAggregation('items',o,f,true);e._updateAccessibilityInfo.call(this);},_decreaseDropIndex:function(B){if(B===0){i=c;return B;}i=b;return B-1;},_increaseDropIndex:function(B,C){if(B===C-1){i=b;return B;}i=c;return B+1;},moveItem:function(o,k){var $=o.$(),f=this.getItems(),B=this.indexOfItem(o),r=sap.ui.getCore().getConfiguration().getRTL(),n,g,h=K;switch(k){case h.HOME:n=0;i=b;break;case h.END:n=f.length-1;i=c;break;case h.ARROW_LEFT:if(r){n=e._increaseDropIndex(B,f.length);}else{n=e._decreaseDropIndex(B);}break;case h.ARROW_RIGHT:if(r){n=e._decreaseDropIndex(B);}else{n=e._increaseDropIndex(B,f.length);}break;case h.ARROW_DOWN:n=e._increaseDropIndex(B,f.length);break;case h.ARROW_UP:n=e._decreaseDropIndex(B);break;default:return;}g=f[n].$();e._insertControl(i,$,g);e._handleConfigurationAfterDragAndDrop.call(this,o,n);return true;},getDraggedDroppedItemsFromList:function(f,o,g){var h,j,s,k,l;l=o._tabFilter?o._tabFilter.getId():o.getId();k=g._tabFilter?g._tabFilter.getId():g.getId();if(!f&&!o&&!g){return;}f.forEach(function(m){s=m._tabFilter.getId();if(!s){return;}if(s===k){h=m;}if(s===l){j=m;}});return{oDraggedControlFromList:j,oDroppedControlFromList:h};},setDragDropAggregations:function(f,s){var o=f._iconTabHeader?f._iconTabHeader:f;var g=o.getId();f.addDragDropConfig(new D({sourceAggregation:"items",groupName:d+g}));f.addDragDropConfig(new a({targetAggregation:"items",dropPosition:"Between",dropLayout:s,drop:f._handleDragAndDrop.bind(f),groupName:d+g}));}};return e;});
sap.ui.predefine('sap/m/IconTabBarRenderer',[],function(){"use strict";var I={};I._aAllIconColors=['sapMITBFilterCritical','sapMITBFilterPositive','sapMITBFilterNegative','sapMITBFilterDefault'];
I.render=function(r,c){var C=c.getContent(),h=c._getIconTabHeader();r.write("<div ");r.writeControlData(c);r.addClass("sapMITB");if(c.getStretchContentHeight()){r.addClass("sapMITBStretch");}if(!c.getApplyContentPadding()){r.addClass("sapMITBNoContentPadding");}r.addClass("sapMITBBackgroundDesign"+c.getBackgroundDesign());r.writeClasses();r.write(">");if(!c._bHideHeader){r.renderControl(h);}r.write("<div id='"+c.getId()+"-containerContent' ");r.addClass("sapMITBContainerContent");if(!c.getExpanded()){r.addClass("sapMITBContentClosed");}r.writeClasses();r.write(">");r.write("<div id='"+c.getId()+"-content' class='sapMITBContent' role='tabpanel' ");if(!c.getExpanded()){r.write("style='display: none'");}if(h.oSelectedItem){r.writeAttribute('aria-labelledby',h.oSelectedItem.getId());}r.write(">");if(c.getExpanded()){if(h.oSelectedItem&&h.oSelectedItem.getContent()){var o=h.oSelectedItem.getContent();if(o.length>0){C=o;}}if(C.length>0){for(var i=0;i<C.length;i++){r.renderControl(C[i]);}}}r.write("</div>");r.write("</div>");r.write("</div>");};
return I;},true);
sap.ui.predefine('sap/m/IconTabBarSelectList',['./library','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','./IconTabBarDragAndDropUtil','./IconTabBarSelectListRenderer',"sap/ui/thirdparty/jquery"],function(l,C,I,a,b,q){"use strict";
var c=C.extend("sap.m.IconTabBarSelectList",{metadata:{library:"sap.m",aggregations:{items:{type:"sap.m.IconTabFilter",multiple:true,singularName:"item",dnd:true}},events:{selectionChange:{parameters:{selectedItem:{type:"sap.m.IconTabFilter"}}}}}});
c.prototype.init=function(){this._itemNavigation=new I();this._itemNavigation.setCycling(false);this.addEventDelegate(this._itemNavigation);this._itemNavigation.setPageSize(10);};
c.prototype.exit=function(){if(this._itemNavigation){this._itemNavigation.destroy();this._itemNavigation=null;}};
c.prototype.onAfterRendering=function(){this._initItemNavigation();};
c.prototype._setsDragAndConfiguration=function(){if(!this._iconTabHeader.getEnableTabReordering()&&this.getDragDropConfig().length){this.destroyDragDropConfig();}else if(this._iconTabHeader.getEnableTabReordering()&&!this.getDragDropConfig().length){a.setDragDropAggregations(this,"Vertical");}};
c.prototype.onBeforeRendering=function(){if(!this._iconTabHeader){return;}this._setsDragAndConfiguration();};
c.prototype._initItemNavigation=function(){var d,e=this.getItems(),f=[];for(var i=0;i<e.length;i++){d=e[i];f.push(d.getDomRef());}this._itemNavigation.setRootDomRef(this.getDomRef());this._itemNavigation.setItemDomRefs(f);};
c.prototype.getVisibleItems=function(){var d=this.getItems(),v=[],e;for(var i=0;i<d.length;i++){e=d[i];if(e.getVisible()){v.push(e);}}return v;};
c.prototype.setSelectedItem=function(i){if(this._selectedItem){this._deselectItem(this._selectedItem);}if(i){this._selectItem(i);}this._selectedItem=i;};
c.prototype.getSelectedItem=function(){return this._selectedItem;};
c.prototype._deselectItem=function(i){var $=i.$();if($){$.removeClass('sapMITBSelectItemSelected');$.removeAttr('aria-selected');}};
c.prototype._selectItem=function(i){var $=i.$();if($){$.addClass('sapMITBSelectItemSelected');$.attr('aria-selected',true);}};
c.prototype.ontap=function(e){var $=q(e.target);if(!$.hasClass('sapMITBSelectItem')){$=$.parent(".sapMITBSelectItem");}var s=sap.ui.getCore().byId($[0].id);if(s&&s.getEnabled()){e.preventDefault();if(s!=this.getSelectedItem()){this._selectItem(s);this.fireSelectionChange({selectedItem:s});}}if(this._iconTabHeader){this._iconTabHeader._closeOverflow();}};
c.prototype.onsapenter=c.prototype.ontap;c.prototype.onsapspace=c.prototype.ontap;
c.prototype.checkIconOnly=function(d){var e,f=d.length;for(var i=0;i<f;i++){e=d[i];if(e.getText()||e.getCount()){return false;}}return true;};
c.prototype._handleDragAndDrop=function(e){var d=e.getParameter("dropPosition"),D=e.getParameter("draggedControl"),o=e.getParameter("droppedControl"),f=D.getParent().getMetadata().getName()==="sap.m.IconTabHeader",g;if(f){g=a.getDraggedDroppedItemsFromList(this.getAggregation("items"),D,o);this._handleDropOfListAndHeaderItems(d,g.oDraggedControlFromList,g.oDroppedControlFromList,D,o._tabFilter);}else{this._handleDropOfListAndHeaderItems(d,D,o,D._tabFilter,o._tabFilter);}this._initItemNavigation();D.$().focus();};
c.prototype._handleDropOfListAndHeaderItems=function(d,D,o,e,f,i){a.handleDrop(this,d,D,o,true);a.handleDrop(this._iconTabHeader,d,e,f,true);this._iconTabHeader._initItemNavigation();};
c.prototype.ondragrearranging=function(e){if(!this._iconTabHeader.getEnableTabReordering()){return;}var t=e.srcControl,k=e.keyCode;a.moveItem.call(this,t,k);this._initItemNavigation();t.$().focus();this._iconTabHeader._moveTab(t._tabFilter,k);};
c.prototype.onsaphomemodifiers=c.prototype.ondragrearranging;c.prototype.onsapendmodifiers=c.prototype.ondragrearranging;c.prototype.onsapincreasemodifiers=c.prototype.ondragrearranging;c.prototype.onsapdecreasemodifiers=c.prototype.ondragrearranging;return c;});
sap.ui.predefine('sap/m/IconTabBarSelectListRenderer',[],function(){'use strict';var I={};
I.render=function(r,c){var i,a,b=c.getVisibleItems(),d=b.length,e=c._iconTabHeader,f=true;if(e){e._checkTextOnly(b);f=e._bTextOnly;c._bIconOnly=c.checkIconOnly(b);}r.write('<ul');r.writeAttribute('role','listbox');r.writeControlData(c);r.addClass('sapMITBSelectList');if(f){r.addClass('sapMITBSelectListTextOnly');}r.writeClasses();r.write('>');for(i=0;i<d;i++){a=b[i];a.renderInSelectList(r,c,i,d);}r.write('</ul>');};
return I;},true);
sap.ui.predefine('sap/m/IconTabFilter',['./library','sap/ui/core/Item','sap/ui/core/Renderer','sap/ui/core/IconPool','sap/ui/core/InvisibleText','sap/ui/core/library','sap/ui/core/Control'],function(l,I,R,a,b,c,C){"use strict";var T=c.TextAlign;var d=c.TextDirection;var e=l.ImageHelper;var f=l.IconTabFilterDesign;var g=c.IconColor;
var h=I.extend("sap.m.IconTabFilter",{metadata:{interfaces:["sap.m.IconTab","sap.ui.core.PopupInterface"],library:"sap.m",designtime:"sap/m/designtime/IconTabFilter.designtime",properties:{count:{type:"string",group:"Data",defaultValue:''},showAll:{type:"boolean",group:"Misc",defaultValue:false},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:''},iconColor:{type:"sap.ui.core.IconColor",group:"Appearance",defaultValue:g.Default},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true},visible:{type:"boolean",group:"Behavior",defaultValue:true},design:{type:"sap.m.IconTabFilterDesign",group:"Appearance",defaultValue:f.Vertical}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});
h._aAllIconColors=['sapMITBFilterCritical','sapMITBFilterPositive','sapMITBFilterNegative','sapMITBFilterDefault','sapMITBFilterNeutral'];
h.prototype._getImageControl=function(i,p,j){var P={src:this.getIcon(),densityAware:this.getIconDensityAware(),useIconTooltip:false};if(P.src){this._oImageControl=e.getImageControl(this.getId()+"-icon",this._oImageControl,p,P,i,j);}else if(this._oImageControl){this._oImageControl.destroy();this._oImageControl=null;}return this._oImageControl;};
h.prototype.exit=function(E){if(this._oImageControl){this._oImageControl.destroy();}if(I.prototype.exit){I.prototype.exit.call(this,E);}if(this._invisibleText){this._invisibleText.destroy();this._invisibleText=null;}};
h.prototype.invalidate=function(){var i=this.getParent(),o,O;if(!i){return;}o=i.getParent();if(!(o instanceof sap.m.IconTabBar)){i.invalidate();return;}O=o.getParent();if(O instanceof sap.m.ObjectHeader){O.invalidate();}else{o.invalidate();}};
h.prototype.setProperty=function(p,v,s){switch(p){case'enabled':case'textDirection':case'text':case'count':case'showAll':case'icon':case'iconColor':case'iconDensityAware':case'design':if(this.getProperty(p)===v){return this;}C.prototype.setProperty.call(this,p,v,true);if(!s){var i=this.getParent();if(i instanceof sap.m.IconTabHeader){i.invalidate();}}break;default:C.prototype.setProperty.apply(this,arguments);break;}return this;};
h.prototype._getNonEmptyKey=function(){var k=this.getKey();if(k){return k;}return this.getId();};
h.prototype.render=function(r,v,i){var t=this;if(!t.getVisible()){return;}var j=this.getParent(),k=j.getParent(),m=k instanceof sap.m.IconTabBar,n=sap.ui.getCore().getLibraryResourceBundle('sap.m'),o='role="tab"',p=t.getId(),q=t.getCount(),s=t.getText(),u=t.getIcon(),w=t.getDesign(),x=t.getIconColor(),y=x==='Positive'||x==='Critical'||x==='Negative',z=w===f.Horizontal,A=m&&k.getUpperCase(),B=j._bTextOnly,D=j._bInLine||j.isInlineMode();if(m){o+=' aria-controls="'+k.sId+'-content" ';}if(s.length||q!==''||u){o+='aria-labelledby="';var E=[];if(q!==''){E.push(p+'-count');}if(s.length){E.push(p+'-text');}if(u){E.push(p+'-icon');}if(y){E.push(p+'-iconColor');}o+=E.join(' ');o+='"';}r.write('<div '+o+' ');if(v!==undefined&&i!==undefined){r.writeAccessibilityState({posinset:v+1,setsize:i});}r.writeElementData(t);r.addClass('sapMITBItem');if(!q){r.addClass('sapMITBItemNoCount');}if(z){r.addClass('sapMITBHorizontal');}else{r.addClass('sapMITBVertical');}if(t.getShowAll()){r.addClass('sapMITBAll');}else{r.addClass('sapMITBFilter');r.addClass('sapMITBFilter'+x);}if(!t.getEnabled()){r.addClass('sapMITBDisabled');r.writeAttribute('aria-disabled',true);}r.writeAttribute('aria-selected',false);var F=t.getTooltip_AsString();if(F){r.writeAttributeEscaped('title',F);}r.writeClasses();r.write('>');if(!D){r.write('<div id="'+p+'-tab" class="sapMITBTab">');if(!t.getShowAll()||!u){if(y){r.write('<div id="'+p+'-iconColor" style="display: none;">'+n.getText('ICONTABBAR_ICONCOLOR_'+x.toUpperCase())+'</div>');}r.renderControl(t._getImageControl(['sapMITBFilterIcon','sapMITBFilter'+x],j,h._aAllIconColors));}if(!t.getShowAll()&&!u&&!B){r.write('<span class="sapMITBFilterNoIcon"> </span>');}if(z&&!t.getShowAll()){r.write('</div>');r.write('<div class="sapMITBHorizontalWrapper">');}r.write('<span id="'+p+'-count" ');r.addClass('sapMITBCount');r.writeClasses();r.write('>');if(q===''&&z){r.write('&nbsp;');}else{r.writeEscaped(q);}r.write('</span>');if(!z){r.write('</div>');}}if(s.length){r.write('<div id="'+p+'-text" ');r.addClass('sapMITBText');if(A){r.addClass('sapMITBTextUpperCase');}if(D){r.writeAttribute('dir','ltr');}r.writeClasses();r.write('>');r.writeEscaped(j._getDisplayText(t));r.write('</div>');}if(!D&&z){r.write('</div>');}r.write('<div class="sapMITBContentArrow"></div>');r.write('</div>');};
h.prototype.renderInSelectList=function(r,s,v,i){var t=this;if(this._invisibleText){this._invisibleText.destroy();this._invisibleText=null;}if(!t.getVisible()){return;}var j=true,k,m=s._iconTabHeader,n=sap.ui.getCore().getLibraryResourceBundle('sap.m');if(m){j=m._bTextOnly;k=s._bIconOnly;}r.write('<li');r.writeElementData(t);r.writeAttribute('tabindex','-1');r.writeAttribute('role','option');if(v!==undefined&&i!==undefined){r.writeAttribute('aria-posinset',v+1);r.writeAttribute('aria-setsize',i);}var o=t.getTooltip_AsString();if(o){r.writeAttributeEscaped('title',o);}if(!t.getEnabled()){r.addClass('sapMITBDisabled');r.writeAttribute('aria-disabled',true);}r.addClass('sapMITBSelectItem');if(s.getSelectedItem()==t){r.addClass('sapMITBSelectItemSelected');r.writeAttribute('aria-selected',true);}var p=t.getIconColor();r.addClass('sapMITBFilter'+p);r.writeClasses();var q=t.getId(),u=p=='Positive'||p=='Critical'||p=='Negative';var w=' aria-labelledby="';if(!k){w+=q+'-text ';}if(!j&&t.getIcon()){w+=q+'-icon ';}if(u){this._invisibleText=new b({text:n.getText('ICONTABBAR_ICONCOLOR_'+p.toUpperCase())});w+=this._invisibleText.getId();}w+='"';r.write(w+'>');if(this._invisibleText){r.renderControl(this._invisibleText);}if(!j){this._renderIcon(r);}if(!k){this._renderText(r);}r.write('</li>');};
h.prototype._renderIcon=function(r){var i=this.getIcon();if(i){var j=a.getIconInfo(i);var k=['sapMITBSelectItemIcon'];if(j&&!j.suppressMirroring){k.push('sapUiIconMirrorInRTL');}r.writeIcon(i,k,{id:this.getId()+'-icon','aria-hidden':true});}else{r.write('<span class="sapUiIcon"></span>');}};
h.prototype._renderText=function(r){var t=this.getText(),i=this.getCount(),j=sap.ui.getCore().getConfiguration().getRTL(),k=this.getTextDirection();r.write('<span');r.writeAttribute('id',this.getId()+'-text');r.writeAttribute('dir','ltr');r.addClass('sapMText');r.addClass('sapMTextNoWrap');r.addClass('sapMITBText');r.writeClasses();if(k!==d.Inherit){r.writeAttribute('dir',k.toLowerCase());}var m=R.getTextAlign(T.Begin,k);if(m){r.addStyle('text-align',m);r.writeStyles();}if(i){if(j){t='('+i+') '+t;}else{t+=' ('+i+')';}}r.write('>');r.writeEscaped(t);r.write('</span>');};
return h;});
sap.ui.predefine('sap/m/IconTabHeader',['./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/delegate/ItemNavigation','sap/ui/core/IconPool','sap/ui/core/delegate/ScrollEnablement','./IconTabBarSelectList','./Button','./ResponsivePopover','./IconTabFilter','sap/ui/Device','sap/ui/core/ResizeHandler','sap/ui/core/Icon','./IconTabBarDragAndDropUtil','./IconTabHeaderRenderer',"sap/ui/thirdparty/jquery","sap/base/Log"],function(l,C,E,I,a,S,b,B,R,c,D,d,e,f,g,q,L){"use strict";var t=l.touch;var h=l.ImageHelper;var P=l.PlacementType;var j=l.ButtonType;var k=l.BackgroundDesign;var m=l.IconTabHeaderMode;var n=l.IconTabDensityMode;
var o=C.extend("sap.m.IconTabHeader",{metadata:{library:"sap.m",properties:{showSelection:{type:"boolean",group:"Misc",defaultValue:true,deprecated:true},selectedKey:{type:"string",group:"Data",defaultValue:null},visible:{type:"boolean",group:"Behavior",defaultValue:true},mode:{type:"sap.m.IconTabHeaderMode",group:"Appearance",defaultValue:m.Standard},showOverflowSelectList:{type:"boolean",group:"Appearance",defaultValue:false},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:k.Solid},enableTabReordering:{type:"boolean",group:"Behavior",defaultValue:false},tabDensityMode:{type:"sap.m.IconTabDensityMode",group:"Appearance",defaultValue:n.Cozy}},aggregations:{items:{type:"sap.m.IconTab",multiple:true,singularName:"item",dnd:{draggable:true,droppable:true,layout:"Horizontal"}},_overflowButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},events:{select:{parameters:{item:{type:"sap.m.IconTabFilter"},key:{type:"string"}}}}}});
E.apply(o.prototype,[true]);o.SCROLL_STEP=264;
o.prototype.init=function(){this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._iCurrentScrollLeft=0;this.startScrollX=0;this.startTouchX=0;this._scrollable=null;this._aTabKeys=[];this._oItemNavigation=new I().setCycling(false);this._oItemNavigation.attachEvent(I.Events.FocusLeave,this._onItemNavigationFocusLeave,this);this._oItemNavigation.attachEvent(I.Events.AfterFocus,this._onItemNavigationAfterFocus,this);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]});this.addDelegate(this._oItemNavigation);this._oScroller=new S(this,this.getId()+"-head",{horizontal:true,vertical:false,nonTouchScrolling:true});};
o.prototype.isTouchScrollingDisabled=function(){return this.getShowOverflowSelectList()&&this.getParent().getMetadata().getName()=='sap.tnt.ToolHeader';};
o.prototype._getSelectList=function(){var i=this;if(!this._oSelectList){this._oSelectList=new b({selectionChange:function(p){var T=p.getParameter('selectedItem');i.setSelectedItem(T._tabFilter);}});this._oSelectList._iconTabHeader=this;}return this._oSelectList;};
o.prototype._getOverflowButton=function(){var O=this.getAggregation("_overflowButton");if(!O){O=new B({id:this.getId()+'-overflow',icon:"sap-icon://slim-arrow-down",type:j.Transparent,press:this._overflowButtonPress.bind(this)});O.addEventDelegate(this._onOverflowButtonEventDelegate);this.setAggregation("_overflowButton",O);}return O;};
o.prototype._overflowButtonPress=function(i){if(!this._oPopover){this._oPopover=new R({showArrow:false,showHeader:false,placement:P.Vertical,offsetX:0,offsetY:0}).addStyleClass('sapMITBPopover');if(D.system.phone){this._oPopover._oControl.addButton(this._createPopoverCloseButton());}this.addDependent(this._oPopover);this._oPopover._oControl._adaptPositionParams=function(){var p=q("body").hasClass("sapUiSizeCompact");this._arrowOffset=0;if(p){this._offsets=["0 0","0 0","0 2","0 0"];}else{this._offsets=["0 0","0 0","0 3","0 0"];}this._myPositions=["end bottom","begin top","end top","end top"];this._atPositions=["end top","end top","end bottom","begin top"];};}var s=this._getSelectList();this._setSelectListItems();this._oPopover.removeAllContent();this._oPopover.addContent(s);this._oPopover.setInitialFocus(s.getSelectedItem());this._oPopover.openBy(this._getOverflowButton());};
o.prototype._createPopoverCloseButton=function(){var i=this;var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");return new B({text:r.getText("SELECT_CANCEL_BUTTON"),press:function(){i._closeOverflow();}});};
o.prototype._closeOverflow=function(){if(!D.system.desktop){this._oPopover.close();}if(this.oSelectedItem){this.oSelectedItem.$().focus();}};
o.prototype._setSelectListItems=function(){if(!this.getShowOverflowSelectList()){return;}var s,T,p=this._getSelectList(),r=this.getTabFilters();p.destroyItems();for(var i=0;i<r.length;i++){T=r[i];s=T.clone();s._tabFilter=T;p.addItem(s);if(T==this.oSelectedItem){p.setSelectedItem(s);}}};
o.prototype._findSelectItem=function(T){var s=this._getSelectList(),p=s.getItems(),r;for(var i=0;i<p.length;i++){r=p[i];if(r._tabFilter==T){return r;}}};
o.prototype._onItemNavigationFocusLeave=function(){if(!this.oSelectedItem){return;}var p=this.getItems();var r=-1;var s;for(var i=0;i<p.length;i++){s=p[i];if(s instanceof c==false){continue;}r++;if(this.oSelectedItem==s){break;}}this._oItemNavigation.setFocusedIndex(r);};
o.prototype._onItemNavigationAfterFocus=function(i){var H=this.getDomRef("head"),p=i.getParameter("index"),$=i.getParameter('event');if($.keyCode===undefined){return;}this._iCurrentScrollLeft=H.scrollLeft;this._checkOverflow();if(p!==null&&p!==undefined){this._scrollIntoView(this.getTabFilters()[p],0);}};
o.prototype.getTabFilters=function(){var i=this.getItems();var T=[];i.forEach(function(p){if(p instanceof c){T.push(p);}});return T;};
o.prototype.exit=function(){if(this._oArrowLeft){this._oArrowLeft.destroy();}if(this._oArrowRight){this._oArrowRight.destroy();}if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._sResizeListenerId){d.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._aTabKeys){this._aTabKeys=null;}if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}};
o.prototype._handleOnLongDragOver=function(){if(!this._oPopover||!this._oPopover.isOpen()){this._overflowButtonPress();}};
o.prototype._handleOnDragOver=function(i){this._getOverflowButton().addStyleClass("sapMBtnDragOver");i.preventDefault();};
o.prototype._handleOnDrop=function(){this._getOverflowButton().removeStyleClass("sapMBtnDragOver");};
o.prototype._handleOnDragLeave=function(){this._getOverflowButton().removeStyleClass("sapMBtnDragOver");};
o.prototype._setsDragAndDropConfigurations=function(){if(!this.getEnableTabReordering()&&this.getDragDropConfig().length){this.destroyDragDropConfig();}else if(this.getEnableTabReordering()&&!this.getDragDropConfig().length){f.setDragDropAggregations(this,"Horizontal");}};
o.prototype.onBeforeRendering=function(){var p=this.getItems(),s=this.getSelectedKey(),i=0,r=this.getParent(),u=r instanceof sap.m.IconTabBar,v=r&&r.getMetadata().getName()=='sap.tnt.ToolHeader';this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._onOverflowButtonEventDelegate={onlongdragover:this._handleOnLongDragOver.bind(this),ondragover:this._handleOnDragOver.bind(this),ondragleave:this._handleOnDragLeave.bind(this),ondrop:this._handleOnDrop.bind(this)};if(this._sResizeListenerId){d.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(p.length>0){if(!this.oSelectedItem||s&&s!==this.oSelectedItem._getNonEmptyKey()){if(s){for(;i<p.length;i++){if(!(p[i]instanceof sap.m.IconTabSeparator)&&p[i]._getNonEmptyKey()===s){this.oSelectedItem=p[i];break;}}}if(!this.oSelectedItem&&(u||!s)){for(i=0;i<p.length;i++){if(!(p[i]instanceof sap.m.IconTabSeparator)&&p[i].getVisible()){this.oSelectedItem=p[i];break;}}}}if(!v&&this.oSelectedItem&&!this.oSelectedItem.getVisible()){for(i=0;i<p.length;i++){if(!(p[i]instanceof sap.m.IconTabSeparator)&&p[i].getVisible()){this.oSelectedItem=p[i];break;}}}if(this.oSelectedItem){this.setProperty("selectedKey",this.oSelectedItem._getNonEmptyKey(),true);}}this._isTouchScrollingDisabled=this.isTouchScrollingDisabled();this._oScroller.setHorizontal(!this._isTouchScrollingDisabled&&(!this.getEnableTabReordering()||!D.system.desktop));this._setsDragAndDropConfigurations();};
o.prototype.setSelectedKey=function(K){var p=this.getTabFilters(),i=0,r=this.getParent(),s=r instanceof sap.m.IconTabBar,u;if(p.length>0){K=K||p[0]._getNonEmptyKey();}if(this.$().length){for(;i<p.length;i++){if(p[i]._getNonEmptyKey()===K){this.setSelectedItem(p[i],true);u=true;break;}}if(!u&&!s&&K){this.setSelectedItem(null);}}this.setProperty("selectedKey",K,true);return this;};
o.prototype.setSelectedItem=function(i,A){if(!i){if(this.oSelectedItem){this.oSelectedItem.$().removeClass("sapMITBSelected");this.oSelectedItem=null;}return this;}if(!i.getEnabled()){return this;}if(this.getShowOverflowSelectList()){var s=this._findSelectItem(i);if(s){this._getSelectList().setSelectedItem(s);}}var p=this.getParent();var r=p instanceof sap.m.IconTabBar;var u=false;if(i.getContent().length===0&&this.oSelectedItem&&this.oSelectedItem.getContent().length===0){u=true;}if(this.oSelectedItem&&this.oSelectedItem.getVisible()&&(!A&&r&&p.getExpandable()||this.oSelectedItem!==i)){this.oSelectedItem.$().removeClass("sapMITBSelected").attr('aria-selected',false).removeAttr('aria-expanded');}if(i.getVisible()){if(this.oSelectedItem===i){if(!A&&r&&p.getExpandable()){p._toggleExpandCollapse();}}else{if(r){p.$("content").attr('aria-labelledby',i.sId);}this.oSelectedItem=i;this.setProperty("selectedKey",this.oSelectedItem._getNonEmptyKey(),true);if(!r){this.oSelectedItem.$().addClass("sapMITBSelected").attr({'aria-selected':true});}if(r&&(p.getExpandable()||p.getExpanded())){this.oSelectedItem.$().addClass("sapMITBSelected").attr({'aria-selected':true});var v=this.oSelectedItem.getContent();if(v.length>0){p._rerenderContent(v);}else{if(!u){p._rerenderContent(p.getContent());}}if(!A&&p.getExpandable()&&!p.getExpanded()){p._toggleExpandCollapse(true);}}}if(this.oSelectedItem.$().length>0){this._scrollIntoView(i,500);}else{this._scrollAfterRendering=true;}}this.oSelectedItem=i;var w=this.oSelectedItem._getNonEmptyKey();this.setProperty("selectedKey",w,true);if(r){p.setProperty("selectedKey",w,true);}if(!A){if(r){p.fireSelect({selectedItem:this.oSelectedItem,selectedKey:w,item:this.oSelectedItem,key:w});}else{this.fireSelect({selectedItem:this.oSelectedItem,selectedKey:w,item:this.oSelectedItem,key:w});}}return this;};
o.prototype.getVisibleTabFilters=function(){var p=this.getTabFilters(),v=[],r;for(var i=0;i<p.length;i++){r=p[i];if(r.getVisible()){v.push(r);}}return v;};
o.prototype._getFirstVisibleItem=function(p){for(var i=0;i<p.length;i++){if(p[i].getVisible()){return p[i];}}return null;};
o.prototype._initItemNavigation=function(){var i=this,H=this.getDomRef("head"),p=this.getItems(),T=[],s=-1;p.forEach(function(r){if(r instanceof c){var u=i.getFocusDomRef(r);q(u).attr("tabindex","-1");T.push(u);if(r===i.oSelectedItem){s=T.indexOf(u);}}});if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.FocusLeave,this._onItemNavigationFocusLeave,this);this._oItemNavigation.attachEvent(I.Events.AfterFocus,this._onItemNavigationAfterFocus,this);this.addDelegate(this._oItemNavigation);}this._oItemNavigation.setRootDomRef(H);this._oItemNavigation.setItemDomRefs(T);this._oItemNavigation.setPageSize(T.length);this._oItemNavigation.setSelectedIndex(s);};
o.prototype.onThemeChanged=function(){this._applyTabDensityMode();};
o.prototype._applyTabDensityMode=function(){var T=this.getTabDensityMode();this.$().removeClass("sapUiSizeCompact");switch(T){case n.Compact:this.$().addClass("sapUiSizeCompact");break;case n.Inherit:if(this.$().closest(".sapUiSizeCompact").length){this.$().addClass("sapUiSizeCompact");}break;}};
o.prototype.onAfterRendering=function(){this._applyTabDensityMode();if(this._oScroller){this._oScroller.setIconTabBar(this,q.proxy(this._afterIscroll,this),q.proxy(this._scrollPreparation,this));}var p=this.getParent();var i=p instanceof sap.m.IconTabBar;if(this.oSelectedItem&&(!i||i&&p.getExpanded())){this.oSelectedItem.$().addClass("sapMITBSelected").attr({'aria-selected':true});}setTimeout(this["_checkOverflow"].bind(this),350);if(this.oSelectedItem){this._scrollIntoView(this.oSelectedItem,500);}this._initItemNavigation();if(this.getShowOverflowSelectList()){this.$('overflow').attr('tabindex',-1);}this._sResizeListenerId=d.register(this.getDomRef(),q.proxy(this._fnResize,this));this._bCheckIfIntoView=true;};
o.prototype.destroyItems=function(){this.oSelectedItem=null;this._aTabKeys=[];this.destroyAggregation("items");};
o.prototype.addItem=function(i){if(!(i instanceof sap.m.IconTabSeparator)){var K=i.getKey();if(this._aTabKeys.indexOf(K)!==-1){L.warning("sap.m.IconTabHeader: duplicate key '"+K+"' inside the IconTabFilter. Please use unique keys.");}this._aTabKeys.push(K);}this.addAggregation("items",i);};
o.prototype.insertItem=function(i,p){if(!(i instanceof sap.m.IconTabSeparator)){var K=i.getKey();if(this._aTabKeys.indexOf(K)!==-1){L.warning("sap.m.IconTabHeader: duplicate key '"+K+"' inside the IconTabFilter. Please use unique keys.");}this._aTabKeys.push(K);}this.insertAggregation("items",i,p);};
o.prototype.removeAllItems=function(){this._aTabKeys=[];return this.removeAllAggregation("items");};
o.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(i&&!(i instanceof sap.m.IconTabSeparator)){var K=i.getKey();this._aTabKeys.splice(this._aTabKeys.indexOf(K),1);}return i;};
o.prototype.updateAggregation=function(){this.oSelectedItem=null;return C.prototype.updateAggregation.apply(this,arguments);};
o.prototype.removeAggregation=function(A,O,s){var i=this.getTabFilters();var p=C.prototype.removeAggregation.apply(this,arguments);if(s){return p;}if(p&&p==this.oSelectedItem&&A=='items'){var r=(i?Array.prototype.indexOf.call(i,p):-1);i=this.getTabFilters();r=Math.max(0,Math.min(r,i.length-1));var u=i[r];if(u){this.setSelectedItem(u,true);}else{var v=this.getParent();if(v instanceof sap.m.IconTabBar&&v.getExpanded()){v.$("content").children().remove();}}}return p;};
o.prototype.removeAllAggregation=function(A,s){if(A=='items'){var i=this.getParent();if(i instanceof sap.m.IconTabBar&&i.getExpanded()){i.$("content").children().remove();}}return C.prototype.removeAllAggregation.apply(this,arguments);};
o.prototype._getDisplayText=function(i){var T=i.getText();if(this.isInlineMode()){var s=i.getCount();if(s){if(this._bRtl){T='('+s+') '+T;}else{T+=' ('+s+')';}}}return T;};
o.prototype.isInlineMode=function(){return this._bTextOnly&&this.getMode()==m.Inline;};
o.prototype._checkTextOnly=function(p){if(p.length>0){for(var i=0;i<p.length;i++){if(!(p[i]instanceof sap.m.IconTabSeparator)){if(p[i].getIcon()){this._bTextOnly=false;return false;}}}}this._bTextOnly=true;return true;};
o.prototype._checkNoText=function(p){if(p.length>0){for(var i=0;i<p.length;i++){if(!(p[i]instanceof sap.m.IconTabSeparator)){if(p[i].getText().length>0){return false;}}}}return true;};
o.prototype._checkInLine=function(p){var r;if(p.length>0){for(var i=0;i<p.length;i++){r=p[i];if(!(r instanceof sap.m.IconTabSeparator)){if(r.getIcon()||r.getCount()){this._bInLine=false;return false;}}}}this._bInLine=true;return true;};
o.prototype._checkScrolling=function(H){var $=this.$();var s=false;var i=this.getDomRef("scrollContainer");var p=this.getDomRef("head");if(p&&i){if(p.offsetWidth>i.offsetWidth){s=true;}}if(this._scrollable!==s){$.toggleClass("sapMITBScrollable",s);$.toggleClass("sapMITBNotScrollable",!s);this._scrollable=s;}this._setTabsVisibility();return s;};
o.prototype._getScrollingArrow=function(N){var s=a.getIconURI("slim-arrow-"+N);var p={src:s,useIconTooltip:false};var i=this._bTextOnly?"TextOnly":"";var r="sapMITBArrowScrollLeft"+i;var u="sapMITBArrowScrollRight"+i;var v=["sapMITBArrowScroll",r,"sapMITHVerticallyCenteredArrow"];var w=["sapMITBArrowScroll",u,"sapMITHVerticallyCenteredArrow"];if(this._bInLine||this.isInlineMode()){v.push('sapMITBArrowScrollLeftInLine');w.push('sapMITBArrowScrollRightInLine');}if(N==="left"){if(!this._oArrowLeft){this._oArrowLeft=h.getImageControl(this.getId()+"-arrowScrollLeft",this._oArrowLeft,this,p,v);}return this._oArrowLeft;}if(N==="right"){if(!this._oArrowRight){this._oArrowRight=h.getImageControl(this.getId()+"-arrowScrollRight",this._oArrowRight,this,p,w);}return this._oArrowRight;}};
o.prototype._checkOverflow=function(){if(this.bIsDestroyed){return;}var i=this.getDomRef("head");var $=this.$();if(this._checkScrolling(i)&&i){var s=false;var p=false;var r=this.getDomRef("scrollContainer");var u=this.getDomRef("head");if(this._oScroller.getScrollLeft()>0){s=true;}if((this._oScroller.getScrollLeft()+r.offsetWidth)<u.offsetWidth){p=true;}if((p!=this._bPreviousScrollForward)||(s!=this._bPreviousScrollBack)){this._bPreviousScrollForward=p;this._bPreviousScrollBack=s;$.toggleClass("sapMITBScrollBack",s);$.toggleClass("sapMITBNoScrollBack",!s);$.toggleClass("sapMITBScrollForward",p);$.toggleClass("sapMITBNoScrollForward",!p);}}else{this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;}};
o.prototype._handleActivation=function(i){var T=i.target.id,p=i.srcControl,s,$=q(i.target);if(p instanceof B){return;}var r=q(document.getElementById(T));if(r.parents()&&Array.prototype.indexOf.call(r.parents(),this.$("content")[0])>-1){}else{if(T){var u=this.getId();i.preventDefault();if(T==u+"-arrowScrollLeft"&&D.system.desktop){var v=this._oScroller.getScrollLeft()-o.SCROLL_STEP;if(v<0){v=0;}this._scrollPreparation();setTimeout(this._oScroller["scrollTo"].bind(this._oScroller,v,0,500),0);setTimeout(this["_afterIscroll"].bind(this),500);}else if(T==u+"-arrowScrollRight"&&D.system.desktop){var v=this._oScroller.getScrollLeft()+o.SCROLL_STEP;var w=this.$("scrollContainer").width();var H=this.$("head").width();if(v>(H-w)){v=H-w;}this._scrollPreparation();setTimeout(this._oScroller["scrollTo"].bind(this._oScroller,v,0,500),0);setTimeout(this["_afterIscroll"].bind(this),500);}else{if($.hasClass('sapMITBFilterIcon')||$.hasClass('sapMITBCount')||$.hasClass('sapMITBText')||$.hasClass('sapMITBTab')||$.hasClass('sapMITBContentArrow')||$.hasClass('sapMITBSep')||$.hasClass('sapMITBSepIcon')){s=i.srcControl.getId().replace(/-icon$/,"");p=sap.ui.getCore().byId(s);if(p.getMetadata().isInstanceOf("sap.m.IconTab")&&!(p instanceof sap.m.IconTabSeparator)){this.setSelectedItem(p);}}else if(p.getMetadata().isInstanceOf("sap.m.IconTab")&&!(p instanceof sap.m.IconTabSeparator)){this.setSelectedItem(p);}}}else{if(p.getMetadata().isInstanceOf("sap.m.IconTab")&&!(p instanceof sap.m.IconTabSeparator)){this.setSelectedItem(p);}}}};
o.prototype._scrollIntoView=function(i,p){if(this.bIsDestroyed){return;}var $=i.$(),s,N,r;if($.length>0){var u=this.$('head');var H=u.innerWidth()-u.width();var v=$.outerWidth(true);var w=$.position().left-H/2;s=this._oScroller.getScrollLeft();r=this.$("scrollContainer").width();N=0;if(w-s<0||w-s>r-v){if(w-s<0){N+=w;}else{N+=Math.min(w,w+v-r);N=Math.round(N);}this._scrollPreparation();this._iCurrentScrollLeft=N;setTimeout(this._oScroller["scrollTo"].bind(this._oScroller,N,0,p),0);setTimeout(this["_afterIscroll"].bind(this),p);}}return this;};
o.prototype._scroll=function(i,p){this._scrollPreparation();var r=this.getDomRef("head");var s=r.scrollLeft;var u=D.browser.msie||D.browser.edge;if(!u&&this._bRtl){i=-i;}var v=s+i;q(r).stop(true,true).animate({scrollLeft:v},p,q.proxy(this._adjustAndShowArrow,this));this._iCurrentScrollLeft=v;};
o.prototype._adjustAndShowArrow=function(){this._$bar&&this._$bar.toggleClass("sapMITBScrolling",false);this._$bar=null;if(D.system.desktop){this._checkOverflow();}};
o.prototype._scrollPreparation=function(){if(!this._$bar){this._$bar=this.$().toggleClass("sapMITBScrolling",true);}};
o.prototype._afterIscroll=function(){this._checkOverflow();this._adjustAndShowArrow();this._setTabsVisibility();};
o.prototype._fnResize=function(){this._checkOverflow();if(this.oSelectedItem&&this._bCheckIfIntoView){this._scrollIntoView(this.oSelectedItem,0);if(!this._isTouchScrollingDisabled){this._bCheckIfIntoView=false;}}this._setTabsVisibility();};
o.prototype._setTabsVisibility=function(){if(!this._isTouchScrollingDisabled){return;}var T=this.getItems(),p,$,H,i;for(i=0;i<T.length;i++){p=T[i];$=p.$();if(!$.hasClass('sapMITBSelected')&&!this._isTabIntoView($)){$.addClass('sapMITBFilterHidden');}else{H=true;$.removeClass('sapMITBFilterHidden');}}if(!H){for(i=0;i<T.length;i++){p=T[i];$=p.$();if(this._isTabIntoView($,true)){$.removeClass('sapMITBFilterHidden');break;}}}this._moveVisibleTabs();};
o.prototype._isTabIntoView=function($,s){if(!$.length){return false;}var i=this._oScroller.getScrollLeft(),p=this.$("scrollContainer").width(),r=this.$('head'),H=r.innerWidth()-r.width(),u=$.css('padding-left'),v=$.width()+parseFloat(u),w=Math.ceil($.position().left-H/2);if(w-i<0||(!s&&(w+v-i>p))){return false;}return true;};
o.prototype._moveVisibleTabs=function(){if(!this._oScroller){return;}var s=this._oScroller.getScrollLeft(),$=this.$('head'),H=$.innerWidth()-$.width(),i=this.$().find('.sapMITBFilter:not(.sapMITBFilterHidden)').first(),p,r;if(!i.length){return;}r=i.position().left-H/2;if(!this._bRtl&&r-s>2){p=s-r;$.css('transform','translate('+p+'px)');}else{$.css('transform','');}return true;};
o.prototype.getFocusDomRef=function(F){var T=F||this.oSelectedItem;if(!T){return null;}return T.getDomRef();};
o.prototype.applyFocusInfo=function(F){if(F.focusDomRef){q(F.focusDomRef).focus();}};
o.prototype.ontouchstart=function(i){var T=i.targetTouches[0];this._iActiveTouch=T.identifier;this._iTouchStartPageX=T.pageX;this._iTouchStartPageY=T.pageY;this._iTouchDragX=0;this._iTouchDragY=0;var $=q(i.target);if($.hasClass('sapMITBArrowScroll')){i.preventDefault();}};
o.prototype.ontouchmove=function(i){if(this._iActiveTouch===undefined){return;}var T=t.find(i.changedTouches,this._iActiveTouch);if(!T||T.pageX===this._iTouchStartPageX){return;}this._iTouchDragX+=Math.abs(this._iTouchStartPageX-T.pageX);this._iTouchDragY+=Math.abs(this._iTouchStartPageY-T.pageY);this._iTouchStartPageX=T.pageX;this._iTouchStartPageY=T.pageY;};
o.prototype.ontouchend=function(i){if(this._iActiveTouch===undefined){return;}var M=D.system.desktop?5:15;if((this._scrollable&&this._iTouchDragX>M)||this._iTouchDragY>M){return;}var p=0;var r=1;var s;if(i.which===s||i.which===p||i.which===r){this._handleActivation(i);}this._iActiveTouch=undefined;};
o.prototype.ontouchcancel=o.prototype.ontouchend;
o.prototype.onsapselect=function(i){this._handleActivation(i);};
o.prototype._handleDragAndDrop=function(i){var s=i.getParameter("dropPosition"),p=i.getParameter("draggedControl"),r=i.getParameter("droppedControl"),u=p.getParent().getMetadata().getName()==="sap.m.IconTabBarSelectList";if(u){this._handleDragAndDropBetweenHeaderAndList(s,r,p);}else{f.handleDrop(this,s,p,r,false);}this._initItemNavigation();p.$().focus();};
o.prototype._handleDragAndDropBetweenHeaderAndList=function(s,i,p){var r=this._getSelectList(),u=f.getDraggedDroppedItemsFromList(r.getAggregation("items"),p,i);if(!u){return;}f.handleDrop(this,s,p._tabFilter,i,false);f.handleDrop(r,s,p,u.oDroppedControlFromList,false);r._initItemNavigation();};
o.prototype._moveTab=function(T,K){var r=f.moveItem.call(this,T,K);this._initItemNavigation();if(r){this._scrollIntoView(T,0);}};
o.prototype.ondragrearranging=function(i){if(!this.getEnableTabReordering()){return;}var T=i.srcControl;this._moveTab(T,i.keyCode);T.$().focus();};
o.prototype.onsaphomemodifiers=o.prototype.ondragrearranging;o.prototype.onsapendmodifiers=o.prototype.ondragrearranging;o.prototype.onsapincreasemodifiers=o.prototype.ondragrearranging;o.prototype.onsapdecreasemodifiers=o.prototype.ondragrearranging;return o;});
sap.ui.predefine('sap/m/IconTabHeaderRenderer',['sap/m/library','sap/ui/Device'],function(l,D){"use strict";var I=l.IconTabFilterDesign;var a={};
a.render=function(r,c){if(!c.getVisible()){return;}var b=c.getItems(),d=b.length,v=c.getVisibleTabFilters(),V=v.length,e=0,t=c._checkTextOnly(b),n=c._checkNoText(b),f=c._checkInLine(b)||c.isInlineMode(),s=c.getShowOverflowSelectList(),o,g,h;var j=c.getParent();var u=j&&j instanceof sap.m.IconTabBar&&j.getUpperCase();r.write("<div role='tablist' ");r.addClass("sapMITH");r.addClass("sapContrastPlus");r.addClass("sapMITHBackgroundDesign"+c.getBackgroundDesign());if(s){r.addClass("sapMITHOverflowList");}if(c._scrollable){r.addClass("sapMITBScrollable");if(c._bPreviousScrollForward){r.addClass("sapMITBScrollForward");}else{r.addClass("sapMITBNoScrollForward");}if(c._bPreviousScrollBack){r.addClass("sapMITBScrollBack");}else{r.addClass("sapMITBNoScrollBack");}}else{r.addClass("sapMITBNotScrollable");}if(u){r.addClass("sapMITBTextUpperCase");}r.writeControlData(c);r.writeClasses();r.write(">");r.renderControl(c._getScrollingArrow("left"));var A=D.browser.msie?"aria-hidden='true'":"";r.write("<div id='"+c.getId()+"-scrollContainer' "+A+" class='sapMITBScrollContainer'>");r.write("<div id='"+c.getId()+"-head' "+A);r.addClass("sapMITBHead");if(t){r.addClass("sapMITBTextOnly");}if(n){r.addClass("sapMITBNoText");}if(f){r.addClass("sapMITBInLine");}r.writeClasses();r.write(">");for(var i=0;i<d;i++){o=b[i];o.render(r,e,V);if(o instanceof sap.m.IconTabFilter){g=o.getDesign()===I.Horizontal;if(g){h=true;}if(o.getVisible()){e++;}}}r.write("</div>");r.write("</div>");r.renderControl(c._getScrollingArrow("right"));if(s){var O=c._getOverflowButton();if(f){O.addStyleClass('sapMBtnInline');}else if(t){O.addStyleClass('sapMBtnTextOnly');}else if(n||h){O.addStyleClass('sapMBtnNoText');}O.addStyleClass("sapMITHVerticallyCenteredArrow");r.renderControl(O);}r.write("</div>");};
return a;},true);
sap.ui.predefine('sap/m/IconTabSeparator',['./library','sap/ui/core/Element','sap/ui/core/Item'],function(l,E,I){"use strict";var a=l.ImageHelper;
var b=E.extend("sap.m.IconTabSeparator",{metadata:{interfaces:["sap.m.IconTab"],library:"sap.m",designtime:"sap/m/designtime/IconTabSeparator.designtime",properties:{icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:''},visible:{type:"boolean",group:"Behavior",defaultValue:true},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true}}}});
b.prototype._getImageControl=function(c,p){var P={src:this.getIcon(),densityAware:this.getIconDensityAware(),useIconTooltip:false};this._oImageControl=a.getImageControl(this.getId()+"-icon",this._oImageControl,p,P,c);return this._oImageControl;};
b.prototype.exit=function(e){if(this._oImageControl){this._oImageControl.destroy();}if(I.prototype.exit){I.prototype.exit.call(this,e);}};
b.prototype.render=function(r){if(!this.getVisible()){return;}var i=this.getIcon(),c=this.getParent(),d=sap.ui.getCore().getLibraryResourceBundle('sap.m'),e='';if(i){e+='role="img" aria-label="'+d.getText("ICONTABBAR_NEXTSTEP")+'"';}else{e+='role="separator"';}r.write('<div '+e+' ');r.writeElementData(this);r.addClass("sapMITBItem");r.addClass("sapMITBSep");if(!i){r.addClass("sapMITBSepLine");}r.writeClasses();r.write(">");if(i){r.renderControl(this._getImageControl(['sapMITBSepIcon'],c));}r.write("</div>");};
b.prototype.renderInSelectList=function(r,s){};
return b;});
sap.ui.predefine('sap/m/Image',['./library','sap/ui/core/Control','sap/ui/base/DataType','./ImageRenderer',"sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/base/security/encodeCSS"],function(l,C,D,I,K,q,e){"use strict";var a=l.ImageMode;
var b=C.extend("sap.m.Image",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",designtime:"sap/m/designtime/Image.designtime",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},decorative:{type:"boolean",group:"Accessibility",defaultValue:true},alt:{type:"string",group:"Accessibility",defaultValue:null},useMap:{type:"string",group:"Misc",defaultValue:null},densityAware:{type:"boolean",group:"Misc",defaultValue:false},activeSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:""},mode:{type:"sap.m.ImageMode",group:"Misc",defaultValue:"Image"},backgroundSize:{type:"string",group:"Appearance",defaultValue:"cover"},backgroundPosition:{type:"string",group:"Appearance",defaultValue:"initial"},backgroundRepeat:{type:"string",group:"Appearance",defaultValue:"no-repeat"}},aggregations:{detailBox:{type:'sap.m.LightBox',multiple:false,bindable:"bindable"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{tap:{},press:{},load:{},error:{}}}});
b._currentDevicePixelRatio=(function(){var r=(window.devicePixelRatio===undefined?1:window.devicePixelRatio);if(r<=1){r=1;}else{r*=2;r=Math.round(r);r/=2;}if(r>2){r=2;}return r;}());
b.prototype.onload=function(E){var w,h;if(!this._defaultEventTriggered){this._defaultEventTriggered=true;}this._bVersion2Tried=false;var d=this.$(),o=d[0];if(this.getMode()===a.Background){d.css("background-image","url(\""+e(this._oImage.src)+"\")");}if(!this._isWidthOrHeightSet()){if(this._iLoadImageDensity>1){w=Math.round(o.getBoundingClientRect().width);h=Math.round(o.getBoundingClientRect().height);if((w===o.naturalWidth)&&(h===o.naturalHeight)){d.width(w/this._iLoadImageDensity);}}}d.removeClass("sapMNoImg");this.fireLoad();};
b.prototype.onerror=function(E){if(!this._defaultEventTriggered){this._defaultEventTriggered=true;}var $=this.$(),m=this.getMode(),s=(m===a.Image)?this._getDomImg().attr("src"):this._oImage.src,d=b._currentDevicePixelRatio,c=this._isActiveState?this.getActiveSrc():this.getSrc();$.addClass("sapMNoImg");if(!s||this._iLoadImageDensity===1){if(this.getAlt()&&!this.getDecorative()){$.removeClass("sapMNoImg");}this.fireError();return;}if(d===2||d<1){this._iLoadImageDensity=1;this._updateDomSrc(this._generateSrcByDensity(c,1));}else if(d===1.5){if(this._bVersion2Tried){setTimeout(q.proxy(function(){this._iLoadImageDensity=1;this._updateDomSrc(this._generateSrcByDensity(c,1));},this),0);}else{setTimeout(q.proxy(function(){this._iLoadImageDensity=2;this._updateDomSrc(this._generateSrcByDensity(c,2));this._bVersion2Tried=true;},this),0);}}};
b.prototype.setDetailBox=function(L){var c=this.getDetailBox();if(L){if(L===c){return this;}if(c){this.detachPress(this._fnLightBoxOpen,c);}this._fnLightBoxOpen=L.open;this.attachPress(this._fnLightBoxOpen,L);}else if(this._fnLightBoxOpen){this.detachPress(this._fnLightBoxOpen,c);this._fnLightBoxOpen=null;}return this.setAggregation("detailBox",L);};
b.prototype.clone=function(){var c=C.prototype.clone.apply(this,arguments),o=c.getDetailBox();if(o){c.detachPress(this._fnLightBoxOpen,this.getDetailBox());c._fnLightBoxOpen=o.open;c.attachPress(c._fnLightBoxOpen,o);}return c;};
b.prototype.onBeforeRendering=function(){this._defaultEventTriggered=false;if(this.getMode()==a.Image){var d=this.getDetailBox()?this.$().find(".sapMImg"):this.$();d.off("load").off("error");}};
b.prototype.onAfterRendering=function(){var d=this.getDetailBox()?this.$().find(".sapMImg"):this.$(),m=this.getMode(),o;if(m===a.Image){d.on("load",q.proxy(this.onload,this));d.on("error",q.proxy(this.onerror,this));o=d[0];}if(m===a.Background){o=this._oImage;}if(o&&o.complete&&!this._defaultEventTriggered){if(o.naturalWidth>0){this.onload({});}else{this.onerror({});}}};
b.prototype.exit=function(){if(this._oImage){q(this._oImage).off("load",this.onload).off("error",this.onerror);this._oImage=null;}else{this.$().off("load",this.onload).off("error",this.onerror);}if(this._fnLightBoxOpen){this._fnLightBoxOpen=null;}};
b.prototype.ontouchstart=function(E){if(E.srcControl.mEventRegistry["press"]||E.srcControl.mEventRegistry["tap"]){E.setMarked();}if(E.targetTouches.length===1&&this.getActiveSrc()){this._updateDomSrc(this._getDensityAwareActiveSrc());this._isActiveState=true;}};
b.prototype.ontouchend=function(E){if(E.targetTouches.length===0&&this.getActiveSrc()){this._isActiveState=false;this._updateDomSrc(this._getDensityAwareSrc());this.$().removeClass("sapMNoImg");}};
b.prototype.setSrc=function(s){if(s===this.getSrc()){return this;}this.setProperty("src",s,true);var d=this.getDomRef();if(d){this._updateDomSrc(this._getDensityAwareSrc());}return this;};
b.prototype.setActiveSrc=function(A){if(!A){A="";}return this.setProperty("activeSrc",A,true);};
b.prototype.attachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);C.prototype.attachEvent.apply(this,arguments);if(this.hasListeners("press")){this.$().attr("tabindex","0");this.$().attr("role","button");}return this;};
b.prototype.detachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);C.prototype.detachEvent.apply(this,arguments);if(!this.hasListeners("press")){this.$().removeAttr("tabindex");if(this.getDecorative()){this.$().attr("role","presentation");}else{this.$().removeAttr("role");}}return this;};
b.prototype.ontap=function(E){this.fireTap({});this.firePress({});};
b.prototype.onkeyup=function(E){if(E.which===K.SPACE||E.which===K.ENTER){this.firePress({});E.stopPropagation();}};
b.prototype._updateDomSrc=function(s){var d=this.$(),m=this.getMode();if(d.length){if(m===a.Image){this._getDomImg().attr("src",s);}else{d.addClass("sapMNoImg");q(this._oImage).attr("src",s);}}};
b.prototype._getDomImg=function(){var d=this.$();return this.getDetailBox()?d.children("img"):d;};
b.prototype._preLoadImage=function(s){if(this.getMode()!==a.Background){return;}var $=q(this._oImage);if(!this._oImage){this._oImage=new window.Image();$=q(this._oImage);$.on("load",q.proxy(this.onload,this)).on("error",q.proxy(this.onerror,this));}this._oImage.src=s;};
b.prototype._isWidthOrHeightSet=function(){return(this.getWidth()&&this.getWidth()!=='')||(this.getHeight()&&this.getHeight()!=='');};
b.prototype._getDensityAwareSrc=function(){var s=this.getSrc(),c=this.getDensityAware(),d=c?b._currentDevicePixelRatio:1;this._iLoadImageDensity=d;if(d===1){return s;}return this._generateSrcByDensity(s,d);};
b.prototype._getDensityAwareActiveSrc=function(){var A=this.getActiveSrc(),c=this.getDensityAware(),d=c?b._currentDevicePixelRatio:1;this._iLoadImageDensity=d;if(d===1){return A;}return this._generateSrcByDensity(A,d);};
b.prototype._generateSrcByDensity=function(s,d){if(!s){return"";}if(this._isDataUri(s)){this._iLoadImageDensity=1;return s;}if(d===1){return s;}var L=s.lastIndexOf("."),c=s.lastIndexOf("/"),n=s.substring(0,L),E=s.substring(L);if(L===-1||(c>L)){return s+"@"+d;}n=n+"@"+d;return n+E;};
b.prototype._isDataUri=function(s){return s?s.indexOf("data:")===0:false;};
b.prototype._isValidBackgroundSizeValue=function(v){var w=/\s+/g;v=q.trim(v).replace(w," ");return i(v.split(" "),["auto","cover","contain","initial"])||D.getType("sap.ui.core.CSSSizeShortHand").isValid(v);};
b.prototype._isValidBackgroundPositionValue=function(v){var w=/\s+/g;v=q.trim(v).replace(w," ");return i(v.split(" "),["left","right","top","center","bottom","initial"])||D.getType("sap.ui.core.CSSSizeShortHand").isValid(v);};
b.prototype.getAccessibilityInfo=function(){var h=this.hasListeners("press");if(this.getDecorative()&&!this.getUseMap()&&!h){return null;}return{role:h?"button":"img",type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText(h?"ACC_CTR_TYPE_BUTTON":"ACC_CTR_TYPE_IMAGE"),description:this.getAlt()||this.getTooltip_AsString()||"",focusable:h};};
b.prototype.getFormDoNotAdjustWidth=function(){return true;};
function i(t,r){function c(T){return r.indexOf(T)<0;}return t&&r&&!t.some(c);}
return b;});
sap.ui.predefine('sap/m/ImageContent',['./library','sap/ui/core/Control','sap/m/Image','sap/ui/core/IconPool','sap/ui/Device','./ImageContentRenderer',"sap/ui/events/KeyCodes"],function(l,C,I,a,D,b,K){"use strict";
var c=C.extend("sap.m.ImageContent",{metadata:{library:"sap.m",properties:{src:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},description:{type:"string",group:"Accessibility",defaultValue:null}},defaultAggregation:"_content",aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{press:{}}}});
c.prototype.onBeforeRendering=function(){var i,u,d;i=this.getAggregation("_content");u=this.getSrc();d=this.getDescription();if(!i||u!==i.getSrc()||d!==i.getAlt()){if(i){i.destroy();i=null;}i=a.createControlByURI({id:this.getId()+"-icon-image",src:u,alt:d,decorative:true},I);this.setAggregation("_content",i,true);this._setPointerOnImage();}if(d){this.setTooltip(d.trim());}};
c.prototype._setPointerOnImage=function(){var i=this.getAggregation("_content");if(i&&this.hasListeners("press")){i.addStyleClass("sapMPointer");}else if(i&&i.hasStyleClass("sapMPointer")){i.removeStyleClass("sapMPointer");}};
c.prototype.ontap=function(e){if(D.browser.msie){this.$().focus();}this.firePress();};
c.prototype.onkeydown=function(e){if(e.which===K.ENTER||e.which===K.SPACE){this.firePress();e.preventDefault();}};
c.prototype.attachEvent=function(e,d,f,g){C.prototype.attachEvent.call(this,e,d,f,g);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapMPointer");this._setPointerOnImage();}return this;};
c.prototype.detachEvent=function(e,f,d){C.prototype.detachEvent.call(this,e,f,d);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapMPointer");this._setPointerOnImage();}return this;};
c.prototype.getAltText=function(){var o=this.getAggregation("_content");if(o&&o.getAlt()!==""){return o.getAlt();}else if(o&&o.getAccessibilityInfo()){return o.getAccessibilityInfo().description;}else{return"";}};
return c;});
sap.ui.predefine('sap/m/ImageContentRenderer',[],function(){"use strict";var I={};
I.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapMImageContent");var t=c.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}if(c.hasListeners("press")){r.addClass("sapMPointer");r.writeAttribute("tabindex","0");}r.writeClasses();r.write(">");var C=c.getAggregation("_content");if(C){C.addStyleClass("sapMImageContentImageIcon");r.renderControl(C);}r.write("</div>");};
return I;},true);
sap.ui.predefine('sap/m/ImageRenderer',['sap/m/library',"sap/base/security/encodeCSS"],function(l,e){"use strict";var I=l.ImageMode;var a={};
a.render=function(r,i){var m=i.getMode(),b=i.getAlt(),t=i.getTooltip_AsString(),h=i.hasListeners("press"),L=i.getDetailBox(),u=i.getUseMap(),c=i.getAriaLabelledBy(),d=i.getAriaDescribedBy();if(L){r.write("<span class=\"sapMLightBoxImage\"");r.writeControlData(i);r.write(">");r.write("<span class=\"sapMLightBoxMagnifyingGlass\"></span>");}r.write(m===I.Image?"<img":"<span");if(!L){r.writeControlData(i);}if(!i.getDecorative()&&c&&c.length>0){r.writeAttributeEscaped("aria-labelledby",c.join(" "));}if(!i.getDecorative()&&d&&d.length>0){r.writeAttributeEscaped("aria-describedby",d.join(" "));}if(m===I.Image){r.writeAttributeEscaped("src",i._getDensityAwareSrc());}else{i._preLoadImage(i._getDensityAwareSrc());if(i._isValidBackgroundSizeValue(i.getBackgroundSize())){r.addStyle("background-size",i.getBackgroundSize());}if(i._isValidBackgroundPositionValue(i.getBackgroundPosition())){r.addStyle("background-position",i.getBackgroundPosition());}r.addStyle("background-repeat",e(i.getBackgroundRepeat()));}r.addClass("sapMImg");if(i.hasListeners("press")||i.hasListeners("tap")){r.addClass("sapMPointer");}if(u||!i.getDecorative()||h){r.addClass("sapMImgFocusable");}r.writeClasses();if(u){if(!(u.startsWith("#"))){u="#"+u;}r.writeAttributeEscaped("useMap",u);}if(i.getDecorative()&&!u&&!h){r.writeAttribute("role","presentation");r.writeAttribute("aria-hidden","true");r.write(" alt=''");}else{if(b||t){r.writeAttributeEscaped("alt",b||t);}}if(b||t){r.writeAttributeEscaped("aria-label",b||t);}if(t){r.writeAttributeEscaped("title",t);}if(h){r.writeAttribute("role","button");r.writeAttribute("tabIndex",0);}if(i.getWidth()&&i.getWidth()!=''){r.addStyle("width",i.getWidth());}if(i.getHeight()&&i.getHeight()!=''){r.addStyle("height",i.getHeight());}r.writeStyles();r.write(" />");if(L){r.write("</span>");}};
return a;},true);
sap.ui.predefine('sap/m/Input',['./InputBase','./Popover','sap/ui/core/Item','./ColumnListItem','./Table','./library','sap/ui/core/IconPool','sap/ui/Device','sap/ui/core/Control','./SuggestionsPopover',"sap/ui/dom/containsOrEquals","sap/base/assert","sap/base/util/deepEqual","./InputRenderer","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/selectText"],function(I,P,a,C,T,l,b,D,c,S,d,e,f,g,q){"use strict";var L=l.ListType;var h=l.InputTextFormatMode;var j=l.InputType;
var k=I.extend("sap.m.Input",{metadata:{library:"sap.m",properties:{type:{type:"sap.m.InputType",group:"Data",defaultValue:j.Text},maxLength:{type:"int",group:"Behavior",defaultValue:0},dateFormat:{type:"string",group:"Misc",defaultValue:'YYYY-MM-dd',deprecated:true},showValueHelp:{type:"boolean",group:"Behavior",defaultValue:false},showSuggestion:{type:"boolean",group:"Behavior",defaultValue:false},valueHelpOnly:{type:"boolean",group:"Behavior",defaultValue:false},filterSuggests:{type:"boolean",group:"Behavior",defaultValue:true},maxSuggestionWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},startSuggestion:{type:"int",group:"Behavior",defaultValue:1},showTableSuggestionValueHelp:{type:"boolean",group:"Behavior",defaultValue:true},description:{type:"string",group:"Misc",defaultValue:null},fieldWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'50%'},valueLiveUpdate:{type:"boolean",group:"Behavior",defaultValue:false},selectedKey:{type:"string",group:"Data",defaultValue:""},textFormatMode:{type:"sap.m.InputTextFormatMode",group:"Misc",defaultValue:h.Value},textFormatter:{type:"any",group:"Misc",defaultValue:""},suggestionRowValidator:{type:"any",group:"Misc",defaultValue:""},enableSuggestionsHighlighting:{type:"boolean",group:"Behavior",defaultValue:true},autocomplete:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"suggestionItems",aggregations:{suggestionItems:{type:"sap.ui.core.Item",multiple:true,singularName:"suggestionItem"},suggestionColumns:{type:"sap.m.Column",multiple:true,singularName:"suggestionColumn",bindable:"bindable",forwarding:{getter:"_getSuggestionsTable",aggregation:"columns"}},suggestionRows:{type:"sap.m.ColumnListItem",multiple:true,singularName:"suggestionRow",bindable:"bindable",forwarding:{getter:"_getSuggestionsTable",aggregation:"items"}},_suggestionPopup:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_valueHelpIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false},selectedRow:{type:"sap.m.ColumnListItem",multiple:false}},events:{liveChange:{parameters:{value:{type:"string"},escPressed:{type:"boolean"},previousValue:{type:"string"}}},valueHelpRequest:{parameters:{fromSuggestions:{type:"boolean"}}},suggest:{parameters:{suggestValue:{type:"string"},suggestionColumns:{type:"sap.m.ListBase"}}},suggestionItemSelected:{parameters:{selectedItem:{type:"sap.ui.core.Item"},selectedRow:{type:"sap.m.ColumnListItem"}}},submit:{parameters:{value:{type:"string"}}}},designtime:"sap/m/designtime/Input.designtime"}});
b.insertFontFaceStyle();
k.prototype.init=function(){I.prototype.init.call(this);this._fnFilter=S._DEFAULTFILTER;this._bUseDialog=D.system.phone;this._bFullScreen=D.system.phone;this._iSetCount=0;this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");};
k.prototype.exit=function(){I.prototype.exit.call(this);this._deregisterEvents();this.cancelPendingSuggest();if(this._iRefreshListTimeout){clearTimeout(this._iRefreshListTimeout);this._iRefreshListTimeout=null;}if(this._oSuggPopover){this._oSuggPopover.destroy();this._oSuggPopover=null;}};
k.prototype.onBeforeRendering=function(){var s=this.getSelectedKey(),i=this.getShowValueHelp()&&this.getEnabled()&&this.getEditable(),E=this.getAggregation("_endIcon")||[],o=E[0],p;I.prototype.onBeforeRendering.call(this);this._deregisterEvents();if(s){this.setSelectedKey(s);}if(this.getShowSuggestion()){if(this.getShowTableSuggestionValueHelp()){this._oSuggPopover._addShowMoreButton();}else{this._oSuggPopover._removeShowMoreButton();}p=this._oSuggPopover._oPopupInput;if(p){p.setType(this.getType());}}if(i){o=this._getValueHelpIcon();o.setProperty("visible",true,true);}else{if(o){o.setProperty("visible",false,true);}}};
k.prototype.onAfterRendering=function(){I.prototype.onAfterRendering.call(this);if(this._bUseDialog&&this.getEditable()&&this.getEnabled()){this.$().on("click",q.proxy(function(E){if(this._onclick){this._onclick(E);}if(this.getShowSuggestion()&&this._oSuggPopover&&E.target.id!=this.getId()+"-vhi"){this._oSuggPopover._oPopover.open();}},this));}};
k.prototype._getDisplayText=function(i){var t=this.getTextFormatter();if(t){return t(i);}var s=i.getText(),K=i.getKey(),m=this.getTextFormatMode();switch(m){case h.Key:return K;case h.ValueKey:return s+' ('+K+')';case h.KeyValue:return'('+K+') '+s;default:return s;}};
k.prototype._onValueUpdated=function(n){if(this._bSelectingItem||n===this._sSelectedValue){return;}var K=this.getSelectedKey(),H;if(K===''){return;}if(this._hasTabularSuggestions()){H=this._oSuggPopover._oSuggestionTable&&!!this._oSuggPopover._oSuggestionTable.getSelectedItem();}else{H=this._oSuggPopover._oList&&!!this._oSuggPopover._oList.getSelectedItem();}if(H){return;}this.setProperty("selectedKey",'',true);this.setAssociation("selectedRow",null,true);this.setAssociation("selectedItem",null,true);this.fireSuggestionItemSelected({selectedItem:null,selectedRow:null});};
k.prototype._updateSelectionFromList=function(){if(this._iPopupListSelectedIndex<0){return false;}var s=this._oSuggPopover._oList.getSelectedItem();if(s){if(this._hasTabularSuggestions()){this.setSelectionRow(s,true);}else{this.setSelectionItem(s._oItem,true);}}return true;};
k.prototype.setSelectionItem=function(i,m){this._bSelectingItem=true;if(!i){this.setAssociation("selectedItem",null,true);return;}var n=this._iSetCount,N;this.setAssociation("selectedItem",i,true);this.setProperty("selectedKey",i.getKey(),true);if(m){this.fireSuggestionItemSelected({selectedItem:i});}if(n!==this._iSetCount){N=this.getValue();}else{N=this._getDisplayText(i);}this._sSelectedValue=N;this.updateInputField(N);this._iPopupListSelectedIndex=-1;if(!(this._bUseDialog&&this instanceof sap.m.MultiInput&&this._isMultiLineMode)){this._closeSuggestionPopup();}this._bSelectingItem=false;};
k.prototype.setSelectedItem=function(i){if(typeof i==="string"){i=sap.ui.getCore().byId(i);}if(i!==null&&!(i instanceof a)){return this;}this.setSelectionItem(i);return this;};
k.prototype.setSelectedKey=function(K){K=this.validateProperty("selectedKey",K);this.setProperty("selectedKey",K,true);if(this._hasTabularSuggestions()){return this;}if(!K){this.setSelectionItem();return this;}var i=this.getSuggestionItemByKey(K);this.setSelectionItem(i);return this;};
k.prototype.getSuggestionItemByKey=function(K){var m=this.getSuggestionItems()||[],o,i;for(i=0;i<m.length;i++){o=m[i];if(o.getKey()===K){return o;}}};
k.prototype.setSelectionRow=function(o,i){if(!o){this.setAssociation("selectedRow",null,true);return;}this._bSelectingItem=true;var m,s=this.getSuggestionRowValidator();if(s){m=s(o);if(!(m instanceof a)){m=null;}}var n=this._iSetCount,K="",N;this.setAssociation("selectedRow",o,true);if(m){K=m.getKey();}this.setProperty("selectedKey",K,true);if(i){this.fireSuggestionItemSelected({selectedRow:o});}if(n!==this._iSetCount){N=this.getValue();}else{if(m){N=this._getDisplayText(m);}else{N=this._fnRowResultFilter?this._fnRowResultFilter(o):S._DEFAULTRESULT_TABULAR(o);}}this._sSelectedValue=N;this.updateInputField(N);this._iPopupListSelectedIndex=-1;if(!(this._bUseDialog&&this instanceof sap.m.MultiInput&&this._isMultiLineMode)){this._closeSuggestionPopup();}this._bSelectingItem=false;};
k.prototype.setSelectedRow=function(o){if(typeof o==="string"){o=sap.ui.getCore().byId(o);}if(o!==null&&!(o instanceof C)){return this;}this.setSelectionRow(o);return this;};
k.prototype._getValueHelpIcon=function(){var t=this,E=this.getAggregation("_endIcon")||[],v=E[0];if(!v){v=this.addEndIcon({id:this.getId()+"-vhi",src:b.getIconURI("value-help"),useIconTooltip:false,noTabStop:true,press:function(o){if(!t.getValueHelpOnly()){var p=this.getParent(),$;if(D.support.touch){$=p.$('inner');$.attr('readonly','readonly');p.focus();$.removeAttr('readonly');}else{p.focus();}t.bValueHelpRequested=true;t.fireValueHelpRequest({fromSuggestions:false});}}});}return v;};
k.prototype._fireValueHelpRequestForValueHelpOnly=function(){if(this.getEnabled()&&this.getEditable()&&this.getShowValueHelp()&&this.getValueHelpOnly()){if(D.system.phone){this.focus();}this.fireValueHelpRequest({fromSuggestions:false});}};
k.prototype.ontap=function(E){I.prototype.ontap.call(this,E);this._fireValueHelpRequestForValueHelpOnly();};
k.prototype.setWidth=function(w){return I.prototype.setWidth.call(this,w||"100%");};
k.prototype.getWidth=function(){return this.getProperty("width")||"100%";};
k.prototype.setFilterFunction=function(F){if(F===null||F===undefined){this._fnFilter=S._DEFAULTFILTER;return this;}e(typeof(F)==="function","Input.setFilterFunction: first argument fnFilter must be a function on "+this);this._fnFilter=F;return this;};
k.prototype.setRowResultFunction=function(F){var s;if(F===null||F===undefined){this._fnRowResultFilter=S._DEFAULTRESULT_TABULAR;return this;}e(typeof(F)==="function","Input.setRowResultFunction: first argument fnFilter must be a function on "+this);this._fnRowResultFilter=F;s=this.getSelectedRow();if(s){this.setSelectedRow(s);}return this;};
k.prototype.closeSuggestions=function(){this._closeSuggestionPopup();};
k.prototype._doSelect=function(s,E){if(D.support.touch){return;}var o=this._$input[0];if(o){var r=this._$input;o.focus();r.selectText(s?s:0,E?E:r.val().length);}return this;};
k.prototype._isSuggestionItemSelectable=function(i){return i.getVisible()&&(this._hasTabularSuggestions()||i.getType()!==L.Inactive);};
k.prototype._isIncrementalType=function(){var t=this.getType();if(t==="Number"||t==="Date"||t==="Datetime"||t==="Month"||t==="Time"||t==="Week"){return true;}return false;};
k.prototype.onsapescape=function(E){var i;if(this._oSuggPopover&&this._oSuggPopover._oPopover.isOpen()){E.originalEvent._sapui_handledByControl=true;this._iPopupListSelectedIndex=-1;this._closeSuggestionPopup();if(this._sBeforeSuggest!==undefined){if(this._sBeforeSuggest!==this.getValue()){i=this._lastValue;this.setValue(this._sBeforeSuggest);this._lastValue=i;}this._sBeforeSuggest=undefined;}return;}if(this.getValueLiveUpdate()){this.setProperty("value",this._lastValue,true);}if(I.prototype.onsapescape){I.prototype.onsapescape.apply(this,arguments);}};
k.prototype.onsapenter=function(E){this.cancelPendingSuggest();if(this._oSuggPopover&&this._oSuggPopover._oPopover.isOpen()){if(!this._updateSelectionFromList()){this._closeSuggestionPopup();}}if(I.prototype.onsapenter){I.prototype.onsapenter.apply(this,arguments);}if(this.getEnabled()&&this.getEditable()&&!(this.getValueHelpOnly()&&this.getShowValueHelp())){this.fireSubmit({value:this.getValue()});}};
k.prototype.onsapfocusleave=function(E){var s=this._oSuggPopover,p=s&&s._oPopover,F=E.relatedControlId&&sap.ui.getCore().byId(E.relatedControlId),o=F&&F.getFocusDomRef(),i=p&&o&&d(p.getDomRef(),o);if(p instanceof P){if(i){this._bPopupHasFocus=true;if(D.system.desktop&&f(p.getFocusDomRef(),o)){this.focus();}}else{if(this.getDOMValue()===this._sSelectedSuggViaKeyboard){this._sSelectedSuggViaKeyboard=null;}}}if(!i&&(!s||!s._sProposedItemText)){I.prototype.onsapfocusleave.apply(this,arguments);}this.bValueHelpRequested=false;};
k.prototype.onmousedown=function(E){var p=this._oSuggPopover&&this._oSuggPopover._oPopover;if((p instanceof P)&&p.isOpen()){E.stopPropagation();}};
k.prototype._deregisterEvents=function(){if(this._oSuggPopover){this._oSuggPopover._deregisterResize();}if(this._bUseDialog&&this._oSuggPopover&&this._oSuggPopover._oPopover){this.$().off("click");}};
k.prototype.updateSuggestionItems=function(){this._bSuspendInvalidate=true;this.updateAggregation("suggestionItems");this._synchronizeSuggestions();this._bSuspendInvalidate=false;return this;};
k.prototype.invalidate=function(){if(!this._bSuspendInvalidate){c.prototype.invalidate.apply(this,arguments);}};
k.prototype.cancelPendingSuggest=function(){if(this._iSuggestDelay){clearTimeout(this._iSuggestDelay);this._iSuggestDelay=null;}};
k.prototype._triggerSuggest=function(v){this.cancelPendingSuggest();this._bShouldRefreshListItems=true;if(!v){v="";}if(v.length>=this.getStartSuggestion()){this._iSuggestDelay=setTimeout(function(){if(this._sPrevSuggValue!==v){this._bBindingUpdated=false;this.fireSuggest({suggestValue:v});if(!this._bBindingUpdated){this._refreshItemsDelayed();}this._sPrevSuggValue=v;}}.bind(this),300);}else if(this._bUseDialog){if(this._oSuggPopover._oList instanceof T){this._oSuggPopover._oList.addStyleClass("sapMInputSuggestionTableHidden");}else if(this._oSuggPopover._oList&&this._oSuggPopover._oList.destroyItems){this._oSuggPopover._oList.destroyItems();}}else if(this._oSuggPopover&&this._oSuggPopover._oPopover.isOpen()){setTimeout(function(){var n=this.getDOMValue()||'';if(n<this.getStartSuggestion()){this._iPopupListSelectedIndex=-1;this._closeSuggestionPopup();}}.bind(this),0);}};
(function(){
k.prototype.setShowSuggestion=function(v){this.setProperty("showSuggestion",v,true);this._iPopupListSelectedIndex=-1;if(v){this._oSuggPopover=this._getSuggestionsPopover();}else{this._oSuggPopover&&this._oSuggPopover._destroySuggestionPopup();}return this;};
k.prototype.setShowTableSuggestionValueHelp=function(v){this.setProperty("showTableSuggestionValueHelp",v,true);if(!(this._oSuggPopover&&this._oSuggPopover._oPopover)){return this;}if(v){this._oSuggPopover._addShowMoreButton();}else{this._oSuggPopover._removeShowMoreButton();}return this;};
k.prototype.oninput=function(E){I.prototype.oninput.call(this,E);if(E.isMarked("invalid")){return;}var v=this.getDOMValue();if(this.getValueLiveUpdate()){this.setProperty("value",v,true);this._onValueUpdated(v);}this.fireLiveChange({value:v,newValue:v});if(this.getShowSuggestion()&&!this._bUseDialog){this._triggerSuggest(v);}};
k.prototype.getValue=function(){return this.getDomRef("inner")&&this._$input?this.getDOMValue():this.getProperty("value");};
k.prototype._refreshItemsDelayed=function(){clearTimeout(this._iRefreshListTimeout);this._iRefreshListTimeout=setTimeout(function(){if(this._oSuggPopover){this._oSuggPopover._refreshListItems();}}.bind(this),0);};
k.prototype.addSuggestionItem=function(i){this.addAggregation("suggestionItems",i,true);if(this._oSuggPopover){this._synchronizeSuggestions();this._oSuggPopover._createSuggestionPopupContent();}return this;};
k.prototype.insertSuggestionItem=function(i,m){this.insertAggregation("suggestionItems",m,i,true);if(this._oSuggPopover){this._synchronizeSuggestions();this._oSuggPopover._createSuggestionPopupContent();}return this;};
k.prototype.removeSuggestionItem=function(i){var r=this.removeAggregation("suggestionItems",i,true);this._synchronizeSuggestions();return r;};
k.prototype.removeAllSuggestionItems=function(){var r=this.removeAllAggregation("suggestionItems",true);this._synchronizeSuggestions();return r;};
k.prototype.destroySuggestionItems=function(){this.destroyAggregation("suggestionItems",true);this._synchronizeSuggestions();return this;};
k.prototype.addSuggestionRow=function(i){i.setType(L.Active);this.addAggregation("suggestionRows",i);this._synchronizeSuggestions();this._oSuggPopover._createSuggestionPopupContent();return this;};
k.prototype.insertSuggestionRow=function(i,m){i.setType(L.Active);this.insertAggregation("suggestionRows",i,m);this._synchronizeSuggestions();this._oSuggPopover._createSuggestionPopupContent();return this;};
k.prototype.removeSuggestionRow=function(i){var r=this.removeAggregation("suggestionRows",i);this._synchronizeSuggestions();return r;};
k.prototype.removeAllSuggestionRows=function(){var r=this.removeAllAggregation("suggestionRows");this._synchronizeSuggestions();return r;};
k.prototype.destroySuggestionRows=function(){this.destroyAggregation("suggestionRows");this._synchronizeSuggestions();return this;};
k.prototype.bindAggregation=function(){if(arguments[0]==="suggestionRows"||arguments[0]==="suggestionColumns"||arguments[0]==="suggestionItems"){this._getSuggestionsPopover()._createSuggestionPopupContent(arguments[0]==="suggestionRows"||arguments[0]==="suggestionColumns");this._bBindingUpdated=true;}return I.prototype.bindAggregation.apply(this,arguments);};
k.prototype._closeSuggestionPopup=function(){if(this._oSuggPopover){this._bShouldRefreshListItems=false;this.cancelPendingSuggest();this._oSuggPopover._oPopover.close();if(!this._bUseDialog&&this.$().hasClass("sapMInputFocused")){this.openValueStateMessage();}this.$("SuggDescr").text("");this.$("inner").removeAttr("aria-haspopup");this.$("inner").removeAttr("aria-activedescendant");this._sPrevSuggValue=null;}};
k.prototype._synchronizeSuggestions=function(){this._bShouldRefreshListItems=true;this._refreshItemsDelayed();if(!this.getDomRef()||(this._oSuggestionPopup&&this._oSuggestionPopup.isOpen())){return;}this._synchronizeSelection();};
k.prototype._synchronizeSelection=function(){var s=this.getSelectedKey();if(!s){return;}if(this.getValue()&&!this.getSelectedItem()&&!this.getSelectedRow()){return;}this.setSelectedKey(s);};
})();
k.prototype.onfocusin=function(E){I.prototype.onfocusin.apply(this,arguments);this.$().addClass("sapMInputFocused");if(!this._bUseDialog&&this._oSuggPopover&&this._oSuggPopover._oPopover&&this._oSuggPopover._oPopover.isOpen()){this.closeValueStateMessage();}if(!this._bPopupHasFocus&&!this.getStartSuggestion()&&!this.getValue()){this._triggerSuggest(this.getValue());}this._bPopupHasFocus=undefined;this._sPrevSuggValue=null;};
k.prototype.onsapshow=function(E){if(!this.getEnabled()||!this.getEditable()||!this.getShowValueHelp()){return;}this.bValueHelpRequested=true;this.fireValueHelpRequest({fromSuggestions:false});E.preventDefault();E.stopPropagation();};
k.prototype.onsaphide=k.prototype.onsapshow;
k.prototype.onsapselect=function(E){this._fireValueHelpRequestForValueHelpOnly();};
k.prototype.onfocusout=function(E){I.prototype.onfocusout.apply(this,arguments);this.$().removeClass("sapMInputFocused");this.closeValueStateMessage(this);};
k.prototype._hasTabularSuggestions=function(){return!!(this.getAggregation("suggestionColumns")&&this.getAggregation("suggestionColumns").length);};
k.prototype._getSuggestionsTable=function(){return this._getSuggestionsPopover()._getSuggestionsTable();};
k.prototype.clone=function(){var i=c.prototype.clone.apply(this,arguments),m;m=this.getBindingInfo("suggestionColumns");if(m){i.bindAggregation("suggestionColumns",q.extend({},m));}m=this.getBindingInfo("suggestionRows");if(m){i.bindAggregation("suggestionRows",q.extend({},m));}i.setRowResultFunction(this._fnRowResultFilter);return i;};
k.prototype.setValue=function(v){this._iSetCount++;I.prototype.setValue.call(this,v);this._onValueUpdated(v);return this;};
k.prototype.setDOMValue=function(v){this._$input.val(v);};
k.prototype.getDOMValue=function(){return this._$input.val();};
k.prototype.updateInputField=function(n){if(this._oSuggPopover&&this._oSuggPopover._oPopover.isOpen()&&this._bUseDialog){this._oSuggPopover._oPopupInput.setValue(n);this._oSuggPopover._oPopupInput._doSelect();}else{n=this._getInputValue(n);this.setDOMValue(n);this.onChange(null,null,n);}};
k.prototype.getAccessibilityInfo=function(){var i=I.prototype.getAccessibilityInfo.apply(this,arguments);i.description=((i.description||"")+" "+this.getDescription()).trim();return i;};
k.prototype.preventChangeOnFocusLeave=function(E){return this.bFocusoutDueRendering||this.bValueHelpRequested;};
k.prototype._getSuggestionsPopover=function(){if(!this._oSuggPopover){this._oSuggPopover=new S(this);this._oSuggPopover._createSuggestionPopup();this._oSuggestionPopup=this._oSuggPopover._oPopover;}return this._oSuggPopover;};
return k;});
sap.ui.predefine('sap/m/InputBase',['./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','./delegate/ValueStateMessage','sap/ui/core/message/MessageMixin','sap/ui/core/library','sap/ui/Device','./InputBaseRenderer','sap/base/Log',"sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/cursorPos","sap/ui/dom/jquery/getSelectedText","sap/ui/dom/jquery/selectText"],function(l,C,E,I,V,M,c,D,a,b,K,q){"use strict";var T=c.TextDirection;var d=c.TextAlign;var f=c.ValueState;
var g=C.extend("sap.m.InputBase",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{value:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:f.None},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueStateText:{type:"string",group:"Misc",defaultValue:null},showValueStateMessage:{type:"boolean",group:"Misc",defaultValue:true},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:d.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},required:{type:"boolean",group:"Misc",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"string"}}}},aggregations:{_endIcon:{type:"sap.ui.core.Icon",multiple:true,visibility:"hidden"},_beginIcon:{type:"sap.ui.core.Icon",multiple:true,visibility:"hidden"}},designtime:"sap/m/designtime/InputBase.designtime"}});
E.call(g.prototype);I.insertFontFaceStyle();M.call(g.prototype);g.ICON_PRESSED_CSS_CLASS="sapMInputBaseIconPressed";g.ICON_CSS_CLASS="sapMInputBaseIcon";g.prototype.bShowLabelAsPlaceholder=!D.support.input.placeholder;
g.prototype.handleInput=function(e){if(this._bIgnoreNextInput){this._bIgnoreNextInput=false;e.setMarked("invalid");return;}this._bIgnoreNextInput=false;if(!this.getEditable()){e.setMarked("invalid");return;}if(document.activeElement!==e.target&&D.browser.msie&&this.getValue()===this._lastValue){e.setMarked("invalid");return;}this._bCheckDomValue=true;};
g.prototype._getPlaceholder=function(){return this.getPlaceholder();};
g.prototype._getInputValue=function(v){v=(v===undefined)?this.$("inner").val()||"":v.toString();if(this.getMaxLength&&this.getMaxLength()>0){v=v.substring(0,this.getMaxLength());}return v;};
g.prototype._getInputElementTagName=function(){if(!this._sInputTagElementName){this._sInputTagElementName=this._$input&&this._$input.get(0)&&this._$input.get(0).tagName;}return this._sInputTagElementName;};
g.prototype.init=function(){this._lastValue="";this.bRenderingPhase=false;this.bFocusoutDueRendering=false;this._oValueStateMessage=new V(this);};
g.prototype.onBeforeRendering=function(){if(D.browser.msie&&D.browser.version>9&&!/^[\x00-\x7F]*$/.test(this.getValue())){this._bIgnoreNextInput=true;}if(this._bCheckDomValue&&!this.bRenderingPhase){this._sDomValue=this._getInputValue();}this.bRenderingPhase=true;};
g.prototype.onAfterRendering=function(){if(this._bCheckDomValue&&this._sDomValue!==this._getInputValue()){this.$("inner").val(this._sDomValue);}this._bCheckDomValue=false;this.bRenderingPhase=false;};
g.prototype.exit=function(){if(this._oValueStateMessage){this._oValueStateMessage.destroy();}this._oValueStateMessage=null;};
g.prototype.ontouchstart=function(e){e.setMarked();};
g.prototype.onfocusin=function(e){this._bIgnoreNextInput=!this.bShowLabelAsPlaceholder&&D.browser.msie&&D.browser.version>9&&!!this.getPlaceholder()&&!this._getInputValue()&&this._getInputElementTagName()==="INPUT";this.$().toggleClass("sapMFocus",true);this.openValueStateMessage();};
g.prototype.onfocusout=function(e){this.bFocusoutDueRendering=this.bRenderingPhase;this.$().toggleClass("sapMFocus",false);if(this.bRenderingPhase){return;}this.closeValueStateMessage();};
g.prototype.onsapfocusleave=function(e){if(!this.preventChangeOnFocusLeave(e)){this.onChange(e);}};
g.prototype.preventChangeOnFocusLeave=function(e){return this.bFocusoutDueRendering;};
g.prototype.getChangeEventParams=function(){return{};};
g.prototype.ontap=function(e){return;};
g.prototype.onChange=function(e,p,n){p=p||this.getChangeEventParams();if(!this.getEditable()||!this.getEnabled()){return;}var v=this._getInputValue(n);if(v!==this._lastValue){this.setValue(v);v=this.getValue();this._lastValue=v;this.fireChangeEvent(v,p);return true;}else{this._bCheckDomValue=false;}};
g.prototype.fireChangeEvent=function(v,p){var o=q.extend({value:v,newValue:v},p);this.fireChange(o);};
g.prototype.onValueRevertedByEscape=function(v,p){this.fireEvent("liveChange",{value:v,escPressed:true,previousValue:p,newValue:v});};
g.prototype.onsapenter=function(e){this.onChange(e);};
g.prototype.onsapescape=function(e){var v=this._getInputValue();if(v!==this._lastValue){e.setMarked();e.preventDefault();this.updateDomValue(this._lastValue);this.onValueRevertedByEscape(this._lastValue,v);}};
g.prototype.oninput=function(e){this.handleInput(e);};
g.prototype.onkeydown=function(e){if(this.getDomRef("inner").getAttribute("readonly")&&e.keyCode==K.BACKSPACE){e.preventDefault();}};
g.prototype.oncut=function(e){};
g.prototype.selectText=function(s,S){this.$("inner").selectText(s,S);return this;};
g.prototype.getSelectedText=function(){return this.$("inner").getSelectedText();};
g.prototype.setProperty=function(p,v,s){if(p=="value"){this._bCheckDomValue=false;}return C.prototype.setProperty.apply(this,arguments);};
g.prototype.getFocusInfo=function(){var F=C.prototype.getFocusInfo.call(this),o=this.getFocusDomRef();q.extend(F,{cursorPos:0,selectionStart:0,selectionEnd:0});if(o){F.cursorPos=q(o).cursorPos();try{F.selectionStart=o.selectionStart;F.selectionEnd=o.selectionEnd;}catch(e){}}return F;};
g.prototype.applyFocusInfo=function(F){C.prototype.applyFocusInfo.call(this,F);this.$("inner").cursorPos(F.cursorPos);this.selectText(F.selectionStart,F.selectionEnd);return this;};
g.prototype.bindToInputEvent=function(e){if(this._oInputEventDelegate){this.removeEventDelegate(this._oInputEventDelegate);}this._oInputEventDelegate={oninput:e};return this.addEventDelegate(this._oInputEventDelegate);};
g.prototype.updateDomValue=function(v){if(!this.isActive()){return this;}v=this._getInputValue(v);if(this._getInputValue()!==v){this.$("inner").val(v);this._bCheckDomValue=true;}return this;};
g.prototype.closeValueStateMessage=function(){if(this._oValueStateMessage){this._oValueStateMessage.close();}};
g.prototype.getDomRefForValueStateMessage=function(){return this.getDomRef("content");};
g.prototype.getPopupAnchorDomRef=function(){return this.getDomRef();};
g.prototype.iOpenMessagePopupDuration=0;
g.prototype.getValueStateMessageId=function(){return this.getId()+"-message";};
g.prototype.getLabels=function(){var L=this.getAriaLabelledBy().map(function(s){return sap.ui.getCore().byId(s);});var o=sap.ui.require("sap/ui/core/LabelEnablement");if(o){L=L.concat(o.getReferencingLabels(this).map(function(s){return sap.ui.getCore().byId(s);}));}return L;};
g.prototype.openValueStateMessage=function(){if(this._oValueStateMessage&&this.shouldValueStateMessageBeOpened()){this._oValueStateMessage.open();}};
g.prototype.updateValueStateClasses=function(v,o){var $=this.$("content"),m=f;if(o!==m.None){$.removeClass("sapMInputBaseContentWrapperState sapMInputBaseContentWrapper"+o);}if(v!==m.None){$.addClass("sapMInputBaseContentWrapperState sapMInputBaseContentWrapper"+v);}};
g.prototype.shouldValueStateMessageBeOpened=function(){return(this.getValueState()!==f.None)&&this.getEditable()&&this.getEnabled()&&this.getShowValueStateMessage();};
g.prototype._calculateSpaceForTokenizer=function(){if(this.getDomRef()){var i=this.getDomRef().offsetWidth;var e=this.getAggregation("_endIcon").concat(this.getAggregation("_beginIcon")),h,s=e.reduce(function(A,m){h=m&&m.getDomRef()?m.getDomRef().offsetWidth:0;return A+h;},0);var o=this.$().find(".sapMInputBaseInner"),j=["min-width","padding-right","padding-left"],k=j.reduce(function(A,p){return A+(parseInt(o.css(p))||0);},0);return i-(s+k)+"px";}else{return null;}};
g.prototype.setValueState=function(v){var o=this.getValueState();this.setProperty("valueState",v,true);v=this.getValueState();if(v===o){return this;}var e=this.getDomRef();if(!e){return this;}var i=this.$("inner"),m=f;if(v===m.Error){i.attr("aria-invalid","true");}else{i.removeAttr("aria-invalid");}this.updateValueStateClasses(v,o);if(i[0]===document.activeElement){if(v===m.None){this.closeValueStateMessage();}else{this.openValueStateMessage();}}return this;};
g.prototype.setValueStateText=function(t){this.setProperty("valueStateText",t,true);this.$("message").text(this.getValueStateText());return this;};
g.prototype.setValue=function(v){v=this.validateProperty("value",v);v=this._getInputValue(v);this.updateDomValue(v);if(v!==this.getProperty("value")){this._lastValue=v;}this.setProperty("value",v,true);return this;};
g.prototype.getFocusDomRef=function(){return this.getDomRef("inner");};
g.prototype.getIdForLabel=function(){return this.getId()+"-inner";};
g.prototype.setTooltip=function(t){var o=this.getDomRef();this._refreshTooltipBaseDelegate(t);this.setAggregation("tooltip",t,true);if(!o){return this;}var s=this.getTooltip_AsString();if(s){o.setAttribute("title",s);}else{o.removeAttribute("title");}if(sap.ui.getCore().getConfiguration().getAccessibility()){var e=this.getDomRef("describedby"),A=this.getRenderer().getDescribedByAnnouncement(this),h=this.getId()+"-describedby",i="aria-describedby",F=this.getFocusDomRef(),j=F.getAttribute(i);if(!e&&A){e=document.createElement("span");e.id=h;e.setAttribute("aria-hidden","true");e.className="sapUiInvisibleText";if(this.getAriaDescribedBy){F.setAttribute(i,(this.getAriaDescribedBy().join(" ")+" "+h).trim());}else{F.setAttribute(i,h);}o.appendChild(e);}else if(e&&!A){e.parentNode.removeChild(e);var k=e.id;if(j&&k){F.setAttribute(i,j.replace(k,"").trim());}}if(e){e.textContent=A;}}return this;};
g.prototype.getAccessibilityInfo=function(){var r=this.getRequired()?'Required':'',R=this.getRenderer();return{role:R.getAriaRole(this),type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_INPUT"),description:[this.getValue()||"",R.getLabelledByAnnouncement(this),R.getDescribedByAnnouncement(this),r].join(" ").trim(),focusable:this.getEnabled(),enabled:this.getEnabled(),editable:this.getEnabled()&&this.getEditable()};};
g.prototype._addIcon=function(i,o){if(["begin","end"].indexOf(i)===-1){b.error('icon position is not "begin", neither "end", please check again the passed setting');return null;}var e=I.createControlByURI(o).addStyleClass(g.ICON_CSS_CLASS);this.addAggregation("_"+i+"Icon",e);return e;};
g.prototype.addBeginIcon=function(i){return this._addIcon("begin",i);};
g.prototype.addEndIcon=function(i){return this._addIcon("end",i);};
Object.defineProperty(g.prototype,"_$input",{get:function(){return this.$("inner");}});return g;});
sap.ui.predefine('sap/m/InputBaseRenderer',['sap/ui/core/Renderer','sap/ui/core/library','sap/ui/Device'],function(R,c,D){"use strict";var T=c.TextDirection;var V=c.ValueState;var I={};
I.render=function(r,C){var v=C.getValueState(),t=C.getTextDirection(),s=R.getTextAlign(C.getTextAlign(),t),a=sap.ui.getCore().getConfiguration().getAccessibility(),b=C.getAggregation("_beginIcon")||[],e=C.getAggregation("_endIcon")||[],d,f;r.write("<div");r.writeControlData(C);this.addOuterStyles(r,C);this.addControlWidth(r,C);r.writeStyles();r.addClass("sapMInputBase");this.addPaddingClass(r,C);this.addCursorClass(r,C);this.addOuterClasses(r,C);if(!C.getEnabled()){r.addClass("sapMInputBaseDisabled");}if(!C.getEditable()){r.addClass("sapMInputBaseReadonly");}r.writeClasses();this.writeOuterAttributes(r,C);var g=C.getTooltip_AsString();if(g){r.writeAttributeEscaped("title",g);}r.write(">");r.write('<div ');r.writeAttribute("id",C.getId()+"-content");r.addClass("sapMInputBaseContentWrapper");if(!C.getEnabled()){r.addClass("sapMInputBaseDisabledWrapper");}else if(!C.getEditable()){r.addClass("sapMInputBaseReadonlyWrapper");}if(v!==V.None){this.addValueStateClasses(r,C);}if(b.length){d=b.filter(function(i){return i.getVisible();});d.length&&r.addClass("sapMInputBaseHasBeginIcons");}if(e.length){f=e.filter(function(i){return i.getVisible();});f.length&&r.addClass("sapMInputBaseHasEndIcons");}r.writeClasses();this.addWrapperStyles(r,C);r.writeStyles();r.write('>');if(b.length){this.writeIcons(r,b);}r.write("<div");r.addClass("sapMInputBaseDynamicContent");r.writeClasses();r.write(">");this.prependInnerContent(r,C);this.openInputTag(r,C);this.writeInnerId(r,C);if(C.getName()){r.writeAttributeEscaped("name",C.getName());}if(!C.bShowLabelAsPlaceholder&&C._getPlaceholder()){r.writeAttributeEscaped("placeholder",C._getPlaceholder());}if(C.getMaxLength&&C.getMaxLength()>0){r.writeAttribute("maxlength",C.getMaxLength());}if(!C.getEnabled()){r.writeAttribute("disabled","disabled");}else if(!C.getEditable()){r.writeAttribute("readonly","readonly");}if(t!=T.Inherit){r.writeAttribute("dir",t.toLowerCase());}this.writeInnerValue(r,C);if(a){this.writeAccessibilityState(r,C);}if(D.browser.mozilla){if(g){r.writeAttributeEscaped("x-moz-errormessage",g);}else{r.writeAttribute("x-moz-errormessage"," ");}}this.writeInnerAttributes(r,C);r.addClass("sapMInputBaseInner");this.addInnerClasses(r,C);r.writeClasses();if(s){r.addStyle("text-align",s);}this.addInnerStyles(r,C);r.writeStyles();r.write(">");this.writeInnerContent(r,C);this.closeInputTag(r,C);r.write("</div>");if(e.length){this.writeIcons(r,e);}r.write('</div>');this.writeDecorations(r,C);if(a){this.renderAriaLabelledBy(r,C);this.renderAriaDescribedBy(r,C);}r.write("</div>");};
I.getAriaRole=function(C){return"textbox";};
I.getAriaLabelledBy=function(C){if(this.getLabelledByAnnouncement(C)){return C.getId()+"-labelledby";}};
I.getLabelledByAnnouncement=function(C){return C._getPlaceholder()||"";};
I.renderAriaLabelledBy=function(r,C){var a=this.getLabelledByAnnouncement(C);if(a){r.write("<span");r.writeAttribute("id",C.getId()+"-labelledby");r.writeAttribute("aria-hidden","true");r.addClass("sapUiInvisibleText");r.writeClasses();r.write(">");r.writeEscaped(a.trim());r.write("</span>");}};
I.getAriaDescribedBy=function(C){if(this.getDescribedByAnnouncement(C)){return C.getId()+"-describedby";}};
I.getDescribedByAnnouncement=function(C){return C.getTooltip_AsString()||"";};
I.renderAriaDescribedBy=function(r,C){var a=this.getDescribedByAnnouncement(C);if(a){r.write("<span");r.writeAttribute("id",C.getId()+"-describedby");r.writeAttribute("aria-hidden","true");r.addClass("sapUiInvisibleText");r.writeClasses();r.write(">");r.writeEscaped(a.trim());r.write("</span>");}};
I.getAccessibilityState=function(C){var a=this.getAriaLabelledBy(C),A=this.getAriaDescribedBy(C),r=this.getAriaRole(C),m={};if(r){m.role=r;}if(C.getValueState()===V.Error){m.invalid=true;}if(a){m.labelledby={value:a.trim(),append:true};}if(A){m.describedby={value:A.trim(),append:true};}return m;};
I.writeAccessibilityState=function(r,C){r.writeAccessibilityState(C,this.getAccessibilityState(C));};
I.openInputTag=function(r,C){r.write("<input");};
I.writeInnerValue=function(r,C){r.writeAttributeEscaped("value",C.getValue());};
I.addCursorClass=function(r,C){};
I.addPaddingClass=function(r,C){r.addClass("sapMInputBaseHeightMargin");};
I.addOuterStyles=function(r,C){};
I.addControlWidth=function(r,C){if(C.getWidth()){r.addStyle("width",C.getWidth());}else{r.addClass("sapMInputBaseNoWidth");}};
I.addOuterClasses=function(r,C){};
I.writeOuterAttributes=function(r,C){};
I.addInnerStyles=function(r,C){};
I.addWrapperStyles=function(r,C){r.addStyle("width","100%");};
I.addInnerClasses=function(r,C){};
I.writeInnerAttributes=function(r,C){};
I.prependInnerContent=function(r,C){};
I.writeInnerContent=function(r,C){};
I.writeIcons=function(r,i){r.write("<div");r.writeAttribute("tabindex","-1");r.addClass("sapMInputBaseIconContainer");r.writeClasses();r.write(">");i.forEach(function(o){r.renderControl(o);});r.write("</div>");};
I.writeDecorations=function(r,C){};
I.closeInputTag=function(r,C){};
I.addPlaceholderStyles=function(r,C){};
I.addPlaceholderClasses=function(r,C){};
I.addValueStateClasses=function(r,C){r.addClass("sapMInputBaseContentWrapperState");r.addClass("sapMInputBaseContentWrapper"+C.getValueState());};
I.writeInnerId=function(r,C){r.writeAttribute("id",C.getId()+"-inner");};
return I;},true);
sap.ui.predefine('sap/m/InputListItem',["sap/ui/core/library","./library","./ListItemBase","./InputListItemRenderer"],function(c,l,L,I){"use strict";var T=c.TextDirection;
var a=L.extend("sap.m.InputListItem",{metadata:{library:"sap.m",properties:{label:{type:"string",group:"Misc",defaultValue:null},labelTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",bindable:"bindable"}},designtime:"sap/m/designtime/InputListItem.designtime"}});
a.prototype.getContentAnnouncement=function(){var A=this.getLabel();this.getContent().forEach(function(C){A+=L.getAccessibilityText(C)+" ";});return A;};
return a;});
sap.ui.predefine('sap/m/InputListItemRenderer',["sap/ui/core/library","sap/ui/core/Renderer","./ListItemBaseRenderer"],function(c,R,L){"use strict";var T=c.TextDirection;var I=R.extend(L);
I.renderLIAttributes=function(r,l){r.addClass("sapMILI");};
I.renderLIContent=function(r,l){var s=l.getLabel();if(s){var a=l.getId()+"-label",b=l.getLabelTextDirection();r.write('<span id="'+a+'" class="sapMILILabel"');if(b!==T.Inherit){r.writeAttribute("dir",b.toLowerCase());}r.write('>');r.writeEscaped(s);r.write('</span>');}r.write('<div class="sapMILIDiv sapMILI-CTX">');l.getContent().forEach(function(C){if(a&&C.addAriaLabelledBy&&C.getAriaLabelledBy().indexOf(a)==-1){C.addAssociation("ariaLabelledBy",a,true);}r.renderControl(C);});r.write('</div>');};
return I;},true);
sap.ui.predefine('sap/m/InputRenderer',['sap/ui/core/InvisibleText','sap/ui/core/Renderer','./InputBaseRenderer','sap/m/library'],function(I,R,a,l){"use strict";var b=l.InputType;var c=R.extend(a);
c.addOuterClasses=function(r,C){r.addClass("sapMInput");if(C.getDescription()){r.addClass("sapMInputWithDescription");}};
c.writeInnerAttributes=function(r,C){r.writeAttribute("type",C.getType().toLowerCase());if(C.getType()==b.Number){r.writeAttribute("step","any");}if(C.getType()==b.Number&&sap.ui.getCore().getConfiguration().getRTL()){r.writeAttribute("dir","ltr");r.addStyle("text-align","right");}if(C.getShowSuggestion()){r.writeAttribute("autocomplete","off");}if((!C.getEnabled()&&C.getType()=="Password")||(C.getShowSuggestion()&&C._bUseDialog)||(C.getValueHelpOnly()&&C.getEnabled()&&C.getEditable()&&C.getShowValueHelp())){r.writeAttribute("readonly","readonly");}};
c.addInnerClasses=function(r,C){};
c.writeDescription=function(r,C){r.write("<div");r.addClass("sapMInputDescriptionWrapper");r.addStyle("max-width","calc(100% - "+C.getFieldWidth()+")");r.writeClasses();r.writeStyles();r.write(">");r.write("<span");r.writeAttribute("id",C.getId()+"-descr");r.addClass("sapMInputDescriptionText");r.writeClasses();r.write(">");r.writeEscaped(C.getDescription());r.write("</span>");r.write("</div>");};
c.writeDecorations=function(r,C){if(C.getDescription()){this.writeDescription(r,C);}if(sap.ui.getCore().getConfiguration().getAccessibility()){if(C.getShowSuggestion()&&C.getEnabled()&&C.getEditable()){r.write("<span id=\""+C.getId()+"-SuggDescr\" class=\"sapUiPseudoInvisibleText\" role=\"status\" aria-live=\"polite\"></span>");}}};
c.addWrapperStyles=function(r,C){r.addStyle("width",C.getDescription()?C.getFieldWidth():"100%");};
c.getAriaLabelledBy=function(C){var d=a.getAriaLabelledBy.call(this,C)||"";if(C.getDescription()){d=d+" "+C.getId()+"-Descr";}return d;};
c.getAriaDescribedBy=function(C){var A=a.getAriaDescribedBy.apply(this,arguments);function d(s){A=A?A+" "+s:s;}if(C.getShowValueHelp()&&C.getEnabled()&&C.getEditable()){d(I.getStaticId("sap.m","INPUT_VALUEHELP"));if(C.getValueHelpOnly()){d(I.getStaticId("sap.m","INPUT_DISABLED"));}}if(C.getShowSuggestion()&&C.getEnabled()&&C.getEditable()){d(C.getId()+"-SuggDescr");}return A;};
c.getAriaRole=function(C){return"";};
c.getAccessibilityState=function(C){var A=a.getAccessibilityState.apply(this,arguments);if(C.getShowSuggestion()&&C.getEnabled()&&C.getEditable()){A.autocomplete="list";}return A;};
return c;},true);
sap.ui.predefine('sap/m/InstanceManager',["sap/base/assert","sap/base/Log","sap/ui/thirdparty/jquery"],function(a,L,q){"use strict";var I={};var r={},e=[];var p="_POPOVER_",d="_DIALOG_",l="_LIGHTBOX_";
I.addInstance=function(c,i){a(c,"In sap.m.InstanceManager.addInstance method, the parameter sCategoryId can't be null or empty string");a(i instanceof Object,"In sap.m.InstanceManager.addInstance method, the parameter oInstance should be an object");if(!r[c]){r[c]=[];}if(r[c].indexOf(i)===-1){r[c].push(i);}return this;};
I.removeInstance=function(c,o){var C=r[c],i;a(c,"In sap.m.InstanceManager.removeInstance method, the parameter sCategoryId can't be null or empty string");a(o instanceof Object,"In sap.m.InstanceManager.removeInstance method, the parameter oInstance should be an object");if(!C){L.warning("Can't remove control from a non-managed category id: "+c);return null;}i=C.indexOf(o);return(i===-1)?null:C.splice(i,1);};
I.getInstancesByCategoryId=function(c){a(c,"In sap.m.InstanceManager.getInstancesByCategoryId method, the parameter sCategoryId can't be null or empty string");return r[c]||e;};
I.isInstanceManaged=function(c,i){a(c,"In sap.m.InstanceManager.isInstanceManaged method, the parameter sCategoryId can't be null or empty string");a(i instanceof Object,"In sap.m.InstanceManager.isInstanceManaged method, the parameter oInstance should be an object");var C=r[c];if(!C||!i){return false;}return C.indexOf(i)!==-1;};
I.isCategoryEmpty=function(c){a(c,"In sap.m.InstanceManager.isCategoryEmpty method, the parameter sCategoryId can't be null or empty string");var C=r[c];return!C||C.length===0;};
I.addPopoverInstance=function(P){if(typeof P.close==="function"){I.addInstance(p,P);}else{L.warning("In method addPopoverInstance: the parameter doesn't have a close method and can't be managed.");}return this;};
I.addDialogInstance=function(D){if(typeof D.close==="function"){I.addInstance(d,D);}else{L.warning("In method addDialogInstance: the parameter doesn't have a close method and can't be managed.");}return this;};
I.addLightBoxInstance=function(o){if(typeof o.close==="function"){I.addInstance(l,o);}else{L.warning("In method addLightBoxInstance: the parameter doesn't have a close method and can't be managed.");}return this;};
I.removePopoverInstance=function(P){return I.removeInstance(p,P);};
I.removeDialogInstance=function(D){return I.removeInstance(d,D);};
I.removeLightBoxInstance=function(o){return I.removeInstance(l,o);};
I.hasOpenPopover=function(){return!I.isCategoryEmpty(p);};
I.hasOpenDialog=function(){return!I.isCategoryEmpty(d);};
I.hasOpenLightBox=function(){return!I.isCategoryEmpty(l);};
I.isDialogOpen=function(D){return I.isInstanceManaged(d,D);};
I.isPopoverOpen=function(P){return I.isInstanceManaged(p,P);};
I.isLightBoxOpen=function(o){return I.isInstanceManaged(l,o);};
I.getOpenPopovers=function(){return I.getInstancesByCategoryId(p);};
I.getOpenDialogs=function(){return I.getInstancesByCategoryId(d);};
I.getOpenLightBoxes=function(){return I.getInstancesByCategoryId(l);};
I.closeAllPopovers=function(){var b=I.getOpenPopovers(),i;for(i=0;i<b.length;i++){b[i].close();}return this;};
I.closeAllDialogs=function(c){var D,b=[],f=I.getOpenDialogs(),g,i;for(i=0;i<f.length;i++){g=f[i];if(c){D=new q.Deferred().done();b.push(D);g.attachEvent("afterClose",(function(h){return function(){h.resolve();};}(D)));}g.close();}if(c){q.when.apply(this,b).then(c);}return this;};
I.closeAllLightBoxes=function(){var i=I.getOpenLightBoxes(),b=i.length,c;for(c=0;c<b;c+=1){i[c].close();}return this;};
return I;},true);
sap.ui.predefine('sap/m/Label',['./library','sap/ui/core/Control','sap/ui/core/LabelEnablement','sap/m/HyphenationSupport','sap/ui/core/library','./LabelRenderer',"sap/base/Log","sap/base/security/encodeXML"],function(l,C,L,H,c,a,b,e){"use strict";var T=c.TextDirection;var d=c.TextAlign;var f=l.LabelDesign;var V=c.VerticalAlign;var W=l.WrappingType;
var g=C.extend("sap.m.Label",{metadata:{interfaces:["sap.ui.core.Label","sap.ui.core.IShrinkable","sap.m.IOverflowToolbarContent","sap.m.IHyphenation"],library:"sap.m",properties:{design:{type:"sap.m.LabelDesign",group:"Appearance",defaultValue:f.Standard},text:{type:"string",group:"Misc",defaultValue:null},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:d.Begin},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},required:{type:"boolean",group:"Misc",defaultValue:false},displayOnly:{type:"boolean",group:"Appearance",defaultValue:false},wrapping:{type:"boolean",group:"Appearance",defaultValue:false},wrappingType:{type:"sap.m.WrappingType",group:"Appearance",defaultValue:W.Normal},vAlign:{type:"sap.ui.core.VerticalAlign",group:"Appearance",defaultValue:V.Inherit}},associations:{labelFor:{type:"sap.ui.core.Control",multiple:false}},designtime:"sap/m/designtime/Label.designtime"}});
g.prototype.setText=function(t){var v=this.getText();if(v!==t){this.setProperty("text",t,true);this.$("bdi").html(e(H.getTextForRender(this,"main")));if(t){this.$().removeClass("sapMLabelNoText");}else{this.$().addClass("sapMLabelNoText");}}return this;};
g.prototype.setTooltip=function(t){var v=this.getTooltip();if(v!==t){this.setAggregation("tooltip",t,true);this.$().attr("title",this.getTooltip());}return this;};
g.prototype.setDisplayOnly=function(h){if(typeof h!=="boolean"){b.error("DisplayOnly property should be boolean. The new value will not be set");return this;}this.$().toggleClass("sapMLabelDisplayOnly",h);return C.prototype.setProperty.call(this,"displayOnly",h);};
g.prototype.getAccessibilityInfo=function(){return{description:this.getText()};};
g.prototype.getOverflowToolbarConfig=function(){var o={canOverflow:true,propsUnrelatedToSize:["design","required","displayOnly"]};function h(j){var k=j&&j.getLayoutData();if(i(k,"sap/m/OverflowToolbarLayoutData")){return k.getGroup();}}o.onBeforeEnterOverflow=function(j){var I=false,t,s,k,m,n;t=j.getParent();if(!i(t,"sap/m/OverflowToolbar")){return;}s=j.getLabelFor();k=s&&sap.ui.getCore().byId(s);if(!k||(t.indexOfContent(k)<0)){return;}m=h(j);n=h(k);I=m&&(m===n);j.toggleStyleClass("sapMLabelMediumMarginTop",I,true);};o.onAfterExitOverflow=function(j){j.toggleStyleClass("sapMLabelMediumMarginTop",false,true);};return o;};
g.prototype.getTextsToBeHyphenated=function(){return{"main":this.getText()};};
g.prototype.getDomRefsForHyphenatedTexts=function(){return{"main":this.$("bdi")[0]};};
L.enrich(g.prototype);H.mixInto(g.prototype);
function i(o,m){if(o&&m){var h=sap.ui.require(m);return(typeof h==='function')&&(o instanceof h);}}
return g;});
sap.ui.predefine('sap/m/LabelRenderer',['sap/ui/core/Renderer','sap/m/library','sap/ui/core/library','sap/m/HyphenationSupport'],function(R,l,c,H){"use strict";var T=c.TextDirection;var L=l.LabelDesign;var a={};
a.render=function(b,o){var r=a,t=o.getTextDirection(),s=o.getTextAlign(),w=o.getWidth(),d=o.getText(),e=o.getTooltip_AsString(),f=o.getLabelForRendering(),h=f?"label":"span",D=o.isDisplayOnly(),v=o.getVAlign();b.openStart(h);b.controlData(o);b.class("sapMLabel");b.class("sapUiSelectable");if(o.isWrapping()){b.class("sapMLabelWrapped");}if(o.getDesign()==L.Bold){b.style("font-weight","bold");}if(o.isRequired()){b.class("sapMLabelRequired");}if(f){sap.ui.core.LabelEnablement.writeLabelForAttribute(b,o);}else if(o.getParent()instanceof sap.m.Toolbar){b.class("sapMLabelTBHeader");}if(t!==T.Inherit){b.attr("dir",t.toLowerCase());}if(w){b.style("width",w);}else{b.class("sapMLabelMaxWidth");}if(s){s=r.getTextAlign(s,t);if(s){b.style("text-align",s);}}if(d==""){b.class("sapMLabelNoText");}if(D){b.class("sapMLabelDisplayOnly");}if(v!=sap.ui.core.VerticalAlign.Inherit){b.style("vertical-align",v.toLowerCase());}H.writeHyphenationClass(b,o);if(e){b.attr("title",e);}b.openEnd();b.openStart("bdi");b.attr("id",o.getId()+"-bdi");b.openEnd();if(d){d=H.getTextForRender(o,"main");b.text(d);}b.close("bdi");b.close(h);if(!f&&o.isDisplayOnly&&o.isDisplayOnly()){b.openStart("span");b.attr("id",o.getId()+"-colon");b.class("sapUiPseudoInvisibleText");b.openEnd();b.text(":");b.close("span");}};
a.getTextAlign=R.getTextAlign;return a;},true);
sap.ui.predefine('sap/m/LightBox',['./library','sap/ui/core/Control','sap/ui/core/Popup','sap/m/Text','sap/m/Button','sap/ui/core/ResizeHandler','sap/ui/Device','sap/ui/core/Icon','sap/ui/layout/VerticalLayout','./InstanceManager','sap/ui/core/InvisibleText','sap/ui/core/library','./LightBoxRenderer',"sap/ui/thirdparty/jquery"],function(l,C,P,T,B,R,D,I,V,a,b,c,L,q){'use strict';var O=c.OpenState;var d=c.TextAlign;var e=l.ButtonType;var f=l.LightBoxLoadingStates;
var g=C.extend('sap.m.LightBox',{metadata:{interfaces:['sap.ui.core.PopupInterface'],library:'sap.m',aggregations:{imageContent:{type:'sap.m.LightBoxItem',multiple:true,bindable:"bindable"},_closeButton:{type:'sap.m.Button',multiple:false,visibility:'hidden'},_errorIcon:{type:'sap.ui.core.Icon',multiple:false,visibility:'hidden'},_errorTitle:{type:'sap.m.Text',multiple:false,visibility:'hidden'},_errorSubtitle:{type:'sap.m.Text',multiple:false,visibility:'hidden'},_verticalLayout:{type:'sap.ui.layout.VerticalLayout',multiple:false,visibility:'hidden'},_invisiblePopupText:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"},_busy:{type:"sap.m.BusyIndicator",multiple:false,visibility:"hidden"}},events:{},defaultAggregation:'imageContent',designtime:"sap/m/designtime/LightBox.designtime"}});
g.prototype.init=function(){this._createPopup();this._width=0;this._height=0;this._isRendering=true;this._resizeListenerId=null;this._$lightBox=null;this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._closeButtonText=this._rb.getText("LIGHTBOX_CLOSE_BUTTON");if(sap.ui.getCore().getConfiguration().getAccessibility()){this.setAggregation("_invisiblePopupText",new b());}};
g.prototype.onBeforeRendering=function(){var i=this._getImageContent(),n=i._getNativeImage(),s=i.getImageSrc(),S=i._getImageState();this._createErrorControls();if(n.getAttribute('src')!==s){n.src=s;}if(this._resizeListenerId){D.resize.detachHandler(this._onResizeHandler);R.deregister(this._resizeListenerId);this._resizeListenerId=null;}switch(S){case f.Loading:this._timeoutId=setTimeout(function(){i._setImageState(f.TimeOutError);},10000);break;case f.Loaded:clearTimeout(this._timeoutId);this._calculateSizes(n);break;case f.Error:clearTimeout(this._timeoutId);break;default:break;}var o=this.getAggregation('_invisiblePopupText');if(i&&o){o.setText(this._rb.getText("LIGHTBOX_ARIA_ENLARGED",i.getTitle()));}this._isRendering=true;};
g.prototype.onAfterRendering=function(){this._isRendering=false;this._$lightBox=this.$();if(!this._resizeListenerId){this._onResizeHandler=this._onResize.bind(this);D.resize.attachHandler(this._onResizeHandler);this._resizeListenerId=R.register(this,this._onResizeHandler);}};
g.prototype.forceInvalidate=C.prototype.invalidate;
g.prototype.invalidate=function(o){var i=this._getImageContent();if(this.isOpen()){if(i&&i.getImageSrc()){this.forceInvalidate(o);}else{this.close();}}return this;};
g.prototype.exit=function(){if(this._oPopup){this._oPopup.detachOpened(this._fnOpened,this);this._oPopup.detachClosed(this._fnClosed,this);this._oPopup.destroy();this._oPopup=null;}if(this._resizeListenerId){D.resize.detachHandler(this._onResizeHandler);R.deregister(this._resizeListenerId);this._resizeListenerId=null;}a.removeLightBoxInstance(this);};
g.prototype.open=function(){var i=this._getImageContent();this._oPopup.setContent(this);if(i&&i.getImageSrc()){this._oPopup.open(300,'center center','center center',document.body,null);a.addLightBoxInstance(this);}return this;};
g.prototype.isOpen=function(){if(this._oPopup&&this._oPopup.isOpen()){return true;}return false;};
g.prototype.close=function(){if(this._resizeListenerId){D.resize.detachHandler(this._onResizeHandler);R.deregister(this._resizeListenerId);this._resizeListenerId=null;}this._oPopup.close();a.removeLightBoxInstance(this);return this;};
g.prototype._getCloseButton=function(){var i=this.getAggregation('_closeButton');if(!i){i=new B({id:this.getId()+'-closeButton',text:this._closeButtonText,type:e.Transparent,press:function(){this.close();}.bind(this)});this.setAggregation('_closeButton',i,true);}return i;};
g.prototype._getBusyIndicator=function(){var i=this.getAggregation("_busy");if(!i){i=new sap.m.BusyIndicator();this.setAggregation("_busy",i,true);}return i;};
g.prototype._imageStateChanged=function(n){var s=n===f.Loaded||n===f.Error;if(s&&!this._isRendering){this.rerender();}};
g.prototype._createPopup=function(){this._oPopup=new P(this,true,true);this._oPopup.attachOpened(this._fnOpened,this);this._oPopup.attachClosed(this._fnClosed,this);};
g.prototype._fnOpened=function(){var t=this;t._onResize();q('#sap-ui-blocklayer-popup').on("click",function(){t.close();});};
g.prototype._fnClosed=function(){q('#sap-ui-blocklayer-popup').off("click");};
g.prototype._createErrorControls=function(){var r=this._rb;var i;var j;if(this._getImageContent()._getImageState()===f.TimeOutError){i=r.getText('LIGHTBOX_IMAGE_TIMED_OUT');j=r.getText('LIGHTBOX_IMAGE_TIMED_OUT_DETAILS');}else{i=r.getText('LIGHTBOX_IMAGE_ERROR');j=r.getText('LIGHTBOX_IMAGE_ERROR_DETAILS');}if(!this.getAggregation('_verticalLayout')){var k=new T({text:i,textAlign:d.Center}).addStyleClass("sapMLightBoxErrorTitle"),m=new T({text:j,textAlign:d.Center}).addStyleClass("sapMLightBoxErrorSubtitle"),n=new I({src:"sap-icon://picture"}).addStyleClass("sapMLightBoxErrorIcon");this.setAggregation('_verticalLayout',new V({content:[n,k,m]}).addStyleClass('sapMLightBoxVerticalLayout'));}};
g.prototype._onResize=function(){var m=h()/2+'px',t=m,i=m,j='',k='',o=this._getImageContent(),n=this.getDomRef(),p,r,s=h(),u=2;if(o._getImageState()===f.Loaded){this._calculateSizes(o._getNativeImage());p=this._width;r=this._height;this._$lightBox.width(p);this._$lightBox.height(r);}else{p=n.clientWidth;r=n.clientHeight;}if(window.innerWidth>p+s){i='50%';k=Math.round(-p/2);}if(window.innerHeight>r+s){t='50%';j=Math.round(-r/2);}if(sap.ui.getCore().getConfiguration().getTheme()==='sap_hcb'){j-=u;k-=u;}this._$lightBox.css({'top':t,'margin-top':j,'left':i,'margin-left':k});};
g.prototype._calculateSizes=function(i){var F=this._calculateFooterHeightInPx(),j=288-F,k=this._getImageContent().getAggregation("_image"),m;this._setImageSize(k,i.naturalWidth,i.naturalHeight);this._calculateAndSetLightBoxSize(k);m=this._pxToNumber(k.getHeight());this.toggleStyleClass('sapMLightBoxMinSize',(m<j));this._isBusy=false;};
g.prototype._calculateFooterHeightInPx=function(){var i=this.$().parents().hasClass('sapUiSizeCompact');var s=this._getImageContent().getSubtitle();var j=2.5;if(!i){j+=0.5;}if(s){j+=1.5;}return j*16;};
g.prototype._calculateAndSetLightBoxSize=function(i){var j,k,m=(20*16),n=(18*16),F=this._calculateFooterHeightInPx();j=this._pxToNumber(i.getHeight());k=this._pxToNumber(i.getWidth());this._width=Math.max(m,k);this._height=Math.max(n,j+F);this._isLightBoxBiggerThanMinDimensions=(k>=m)&&(j>=(n-F));};
g.prototype._setImageSize=function(i,j,k){var m=this._calculateFooterHeightInPx(),n=this._getDimensions(j,k,m),w=n.width+'px',o=n.height+'px',p=i.getDomRef();i.setProperty('width',w,true);i.setProperty('height',o,true);if(p){p.style.width=w;p.style.height=o;}};
g.prototype._getDimensions=function(i,j,k){var m=20*16,n=18*16,$=q(window),w=$.height(),o=$.width(),p=h(),r=Math.max(o-p,m),s=Math.max(w-p,n),t;s-=k;if(j<=s){if(i<=r){}else{j*=r/i;i=r;}}else{if(i<=r){i*=s/j;j=s;}else{t=Math.max(i/r,j/s);i/=t;j/=t;}}return{width:Math.round(i),height:Math.round(j)};};
g.prototype._pxToNumber=function(s){return(s.substring(0,(s.length-2)))*1;};
g.prototype._getImageContent=function(){var r=this.getAggregation('imageContent');return r&&r[0];};
function h(){var s=D.system;if(s.desktop){return 4*16;}if(s.tablet){return 2*16;}return 0;}
g.prototype.onsapescape=function(E){var i=this._oPopup.getOpenState();if(i!==O.CLOSED&&i!==O.CLOSING){this.close();E.stopPropagation();}};
return g;});
sap.ui.predefine('sap/m/LightBoxItem',['./library','sap/ui/core/Element','./Image','./Text','sap/ui/core/library'],function(l,E,I,T,c){"use strict";var O=c.OpenState;var L=l.LightBoxLoadingStates;
var a=E.extend("sap.m.LightBoxItem",{metadata:{library:"sap.m",properties:{imageSrc:{type:'sap.ui.core.URI',group:'Appearance',multiple:false,defaultValue:''},alt:{type:'string',group:'Appearance',multiple:false,defaultValue:''},title:{type:'string',group:'Appearance',multiple:false,defaultValue:''},subtitle:{type:'string',group:'Appearance',multiple:false,defaultValue:''}},aggregations:{_image:{type:'sap.m.Image',multiple:false,visibility:'hidden'},_title:{type:'sap.m.Text',multiple:false,visibility:'hidden'},_subtitle:{type:'sap.m.Text',multiple:false,visibility:'hidden'}}}});
a.prototype.init=function(){this._createNativeImage();this.setAggregation('_image',new I({decorative:false,densityAware:false}),true);this.setAggregation('_title',new T({wrapping:false}),true);this.setAggregation('_subtitle',new T({wrapping:false}),true);};
a.prototype._createNativeImage=function(){var t=this;this._imageState=L.Loading;this._oImage=new window.Image();this._oImage.onload=function(e){if(this.complete&&t._imageState===L.Loading){t._setImageState(L.Loaded);}};this._oImage.onerror=function(e){t._setImageState(L.Error);};};
a.prototype.exit=function(){this._oImage=null;};
a.prototype._setImageState=function(i){if(i!==this._imageState){this._imageState=i;if(this.getParent()){this.getParent()._imageStateChanged(i);}}};
a.prototype._getImageState=function(){return this._imageState;};
a.prototype._getNativeImage=function(){return this._oImage;};
a.prototype.setImageSrc=function(i){var o=this.getAggregation("_image"),b=this.getParent();if(this.getImageSrc()===i){return this;}this._imageState=L.Loading;if(b&&b._oPopup.getOpenState()===O.OPEN){this._oImage.src=i;}this.setProperty("imageSrc",i,false);o.setSrc(i);return this;};
a.prototype.setAlt=function(b){var i=this.getAggregation("_image");this.setProperty("alt",b,false);i.setAlt(b);return this;};
a.prototype.setTitle=function(t){var o=this.getAggregation("_title");this.setProperty("title",t,false);o.setText(t);return this;};
a.prototype.setSubtitle=function(s){var b=this.getAggregation("_subtitle");this.setProperty("subtitle",s,false);b.setText(s);return this;};
return a;});
sap.ui.predefine('sap/m/LightBoxRenderer',["sap/m/library"],function(l){'use strict';var L=l.LightBoxLoadingStates;var a={};var c='sapMLightBox';var b='sapMLightBoxTwoLines';var d='sapMLightBoxImageContainer';var e='sapMLightBoxImageContainerTwoHeaders';var f='sapMLightBoxError';var g='sapMLightBoxErrorContainer';var h='sapMLightBoxErrorContainerTwoHeaders';var i='sapMLightBoxFooter';var j='sapContrast';var k='sapContrastPlus';var m='sapMLightBoxTitleSection';var n='sapMLightBoxTitle';var o='sapMLightBoxSubtitle';var p='sapMLightBoxFooterTwoLines';var q='sapMLightBoxTopCornersRadius';
a.render=function(r,C){var s=C._getImageContent();var t=s._getImageState();var u=C.getAggregation('_invisiblePopupText');r.write('<div');r.writeControlData(C);r.addClass(c);if(s.getSubtitle()){r.addClass(b);}if(C._isLightBoxBiggerThanMinDimensions){r.addClass(q);}if(t!==L.Error){r.addStyle('width',C._width+'px');r.addStyle('height',C._height+'px');}else{r.addClass(f);}r.writeAccessibilityState({role:'dialog',labelledby:u&&u.getId()});r.writeClasses();r.writeStyles();r.write('>');r.renderControl(u);if(t===L.Loading){this.renderBusyState(r,C);}else if(t===L.TimeOutError||t===L.Error){this.renderError(r,C);}else{this.renderImage(r,C);}this.renderFooter(r,C,s);r.write('</div>');C._isRendering=false;};
a.renderImage=function(r,C){var s=C._getImageContent();if(s.getSubtitle()){r.write('<div class="'+e+'">');}else{r.write('<div class="'+d+'">');}r.renderControl(s.getAggregation('_image'));r.write('</div>');};
a.renderError=function(r,C){var s=C._getImageContent(),v=C.getAggregation('_verticalLayout');if(s.getSubtitle()){r.write('<div class="'+h+'">');}else{r.write('<div class="'+g+'">');}r.renderControl(v);r.write('</div>');};
a.renderBusyState=function(r,C){r.renderControl(C._getBusyIndicator());};
a.renderFooter=function(r,C,I){var t=I.getAggregation("_title"),s=I.getAggregation("_subtitle");r.write('<div');r.addClass(i);r.addClass(j);r.addClass(k);if(I.getSubtitle()){r.addClass(p);}r.writeClasses();r.write('>');r.write('<div class="'+m+'">');if(t){r.renderControl(t.addStyleClass(n));}if(s&&s.getText()){r.renderControl(s.addStyleClass(o));}r.write('</div>');r.renderControl(C._getCloseButton());r.write('</div>');};
return a;},true);
sap.ui.predefine('sap/m/Link',['./library','sap/ui/core/Control','sap/ui/core/InvisibleText','sap/ui/core/EnabledPropagator','sap/ui/core/LabelEnablement','sap/ui/core/library','sap/ui/Device','./LinkRenderer',"sap/ui/events/KeyCodes","sap/base/Log","sap/base/security/URLWhitelist"],function(l,C,I,E,L,c,D,a,K,b,U){"use strict";var T=c.TextDirection;var d=c.TextAlign;
var e=C.extend("sap.m.Link",{metadata:{interfaces:["sap.ui.core.IShrinkable","sap.ui.core.IFormContent"],library:"sap.m",designtime:"sap/m/designtime/Link.designtime",properties:{text:{type:"string",group:"Data",defaultValue:''},enabled:{type:"boolean",group:"Behavior",defaultValue:true},target:{type:"string",group:"Behavior",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},href:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},validateUrl:{type:"boolean",group:"Data",defaultValue:false},wrapping:{type:"boolean",group:"Appearance",defaultValue:false},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:d.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},subtle:{type:"boolean",group:"Behavior",defaultValue:false},emphasized:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{allowPreventDefault:true,parameters:{ctrlKey:{type:"boolean"},metaKey:{type:"boolean"}}}},dnd:{draggable:true,droppable:false}}});
E.call(e.prototype);
e.prototype.onBeforeRendering=function(){};
e.prototype.onsapspace=function(o){if(this.getEnabled()||this.getHref()){o.setMarked();o.preventDefault();}};
e.prototype.onkeyup=function(o){if(o.which===K.SPACE){this._handlePress(o);if(this.getHref()&&!o.isDefaultPrevented()){o.preventDefault();o.setMarked();var f=document.createEvent('MouseEvents');f.initEvent('click',false,true);this.getDomRef().dispatchEvent(f);}}};
e.prototype._handlePress=function(o){if(this.getEnabled()){o.setMarked();if(!this.firePress({ctrlKey:!!o.ctrlKey,metaKey:!!o.metaKey})||!this.getHref()){o.preventDefault();}}else{o.preventDefault();}};
e.prototype.onsapenter=e.prototype._handlePress;if(D.support.touch){e.prototype.ontap=e.prototype._handlePress;}else{e.prototype.onclick=e.prototype._handlePress;}
e.prototype.ontouchstart=function(o){if(this.getEnabled()){o.setMarked();}};
e.prototype.setText=function(t){var $=this.$();this.setProperty("text",t,true);t=this.getProperty("text");if(this.writeText){this.writeText(t);}else{$.text(t);}if(t){$.attr("tabindex","0");}else{$.attr("tabindex","-1");}return this;};
e.prototype.setHref=function(u){var i=this._isHrefValid(u);this.setProperty("href",u,true);if(!i){this.$().removeAttr("href");b.warning(this+": The href tag of the link was not set since it's not valid.");return this;}if(this.getEnabled()){u=this.getProperty("href");if(!u){this.$().removeAttr("href");}else{this.$().attr("href",u);}}return this;};
e.prototype.setSubtle=function(s){this.setProperty("subtle",s,true);var $=this.$();if($.length){$.toggleClass("sapMLnkSubtle",s);if(s){e._addToDescribedBy($,this._sAriaLinkSubtleId);}else{e._removeFromDescribedBy($,this._sAriaLinkSubtleId);}}if(s&&!e.prototype._sAriaLinkSubtleId){e.prototype._sAriaLinkSubtleId=I.getStaticId("sap.m","LINK_SUBTLE");}return this;};
e.prototype.setEmphasized=function(f){this.setProperty("emphasized",f,true);var $=this.$();if($.length){$.toggleClass("sapMLnkEmphasized",f);if(f){e._addToDescribedBy($,this._sAriaLinkEmphasizedId);}else{e._removeFromDescribedBy($,this._sAriaLinkEmphasizedId);}}if(f&&!e.prototype._sAriaLinkEmphasizedId){e.prototype._sAriaLinkEmphasizedId=I.getStaticId("sap.m","LINK_EMPHASIZED");}return this;};
e.prototype.setWrapping=function(w){this.setProperty("wrapping",w,true);this.$().toggleClass("sapMLnkWrapping",w);return this;};
e.prototype.setEnabled=function(f){f=this.validateProperty("enabled",f);if(f!==this.getProperty("enabled")){this.setProperty("enabled",f,true);var $=this.$();$.toggleClass("sapMLnkDsbl",!f);if(f){$.attr("disabled",false);if(this.getText()){$.attr("tabindex","0");}else{$.attr("tabindex","-1");}$.removeAttr("aria-disabled");if(this.getHref()){$.attr("href",this.getHref());}}else{$.attr("disabled",true);$.attr("aria-disabled",true);$.removeAttr("href");}}return this;};
e.prototype.setWidth=function(w){this.setProperty("width",w,true);this.$().toggleClass("sapMLnkMaxWidth",!w);this.$().css("width",w);return this;};
e.prototype.setTarget=function(t){this.setProperty("target",t,true);if(!t){this.$().removeAttr("target");}else{this.$().attr("target",t);}return this;};
e.prototype._isHrefValid=function(u){return this.getValidateUrl()?U.validate(u):true;};
e._addToDescribedBy=function($,i){var A=$.attr("aria-describedby");if(A){$.attr("aria-describedby",A+" "+i);}else{$.attr("aria-describedby",i);}};
e._removeFromDescribedBy=function($,i){var A=$.attr("aria-describedby");if(A&&A.indexOf(i)!==-1){A=A.replace(i,'');if(A.length>1){$.attr("aria-describedby",A);}else{$.removeAttr("aria-describedby");}}};
e.prototype.getAccessibilityInfo=function(){return{role:"link",type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_LINK"),description:this.getText()||this.getHref()||"",focusable:this.getEnabled(),enabled:this.getEnabled()};};
e.prototype.getFormDoNotAdjustWidth=function(){return true;};
e.prototype._getTabindex=function(){return this.getText()?"0":"-1";};
e.prototype._determineSelfReferencePresence=function(){var A=this.getAriaLabelledBy(),B=D.browser.msie,f=A.indexOf(this.getId())!==-1,h=L.getReferencingLabels(this).length>0,p=this.getParent(),g=!!(p&&p.enhanceAccessibilityState);return!B&&!f&&(A.length>0||h||g);};
return e;});
sap.ui.predefine('sap/m/LinkRenderer',['sap/ui/core/Renderer','sap/ui/core/library'],function(R,c){"use strict";var T=c.TextDirection;var L={};
L.render=function(r,C){var t=C.getTextDirection(),s=R.getTextAlign(C.getTextAlign(),t),S=C._determineSelfReferencePresence(),a={role:'link',labelledby:S?{value:C.getId(),append:true}:undefined},h=C.getHref(),i=h&&C._isHrefValid(h),e=C.getEnabled();r.write("<a");r.writeControlData(C);r.addClass("sapMLnk");if(C.getSubtle()){r.addClass("sapMLnkSubtle");if(a.describedby){a.describedby+=" "+C._sAriaLinkSubtleId;}else{a.describedby=C._sAriaLinkSubtleId;}}if(C.getEmphasized()){r.addClass("sapMLnkEmphasized");if(a.describedby){a.describedby+=" "+C._sAriaLinkEmphasizedId;}else{a.describedby=C._sAriaLinkEmphasizedId;}}if(!e){r.addClass("sapMLnkDsbl");r.writeAttribute("disabled","true");}else{r.writeAttribute("tabIndex",C._getTabindex());}if(C.getWrapping()){r.addClass("sapMLnkWrapping");}if(C.getTooltip_AsString()){r.writeAttributeEscaped("title",C.getTooltip_AsString());}if(i&&e){r.writeAttributeEscaped("href",h);}if(C.getTarget()){r.writeAttributeEscaped("target",C.getTarget());}if(C.getWidth()){r.addStyle("width",C.getWidth());}else{r.addClass("sapMLnkMaxWidth");}if(s){r.addStyle("text-align",s);}if(t!==T.Inherit){r.writeAttribute("dir",t.toLowerCase());}r.writeAccessibilityState(C,a);r.writeClasses();r.writeStyles();r.write(">");if(this.writeText){this.writeText(r,C);}else{this.renderText(r,C);}r.write("</a>");};
L.renderText=function(r,C){r.writeEscaped(C.getText());};
return L;},true);
sap.ui.predefine('sap/m/List',["./library","./ListBase","./ListRenderer"],function(l,L,a){"use strict";var B=l.BackgroundDesign;
var b=L.extend("sap.m.List",{metadata:{library:"sap.m",properties:{backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:B.Solid}}}});
return b;});
sap.ui.predefine('sap/m/ListBase',["sap/ui/events/KeyCodes","sap/ui/Device","sap/ui/core/Control","sap/ui/core/InvisibleText","sap/ui/core/LabelEnablement","sap/ui/core/delegate/ItemNavigation","./library","./InstanceManager","./GrowingEnablement","./GroupHeaderListItem","./ListItemBase","./ListBaseRenderer","sap/base/strings/capitalize","sap/ui/thirdparty/jquery","sap/base/Log","sap/ui/dom/jquery/control","sap/ui/dom/jquery/Selectors","sap/ui/dom/jquery/Aria"],function(K,D,C,I,L,a,l,b,G,c,d,f,g,q,h){"use strict";var j=l.ListType;var k=l.ListKeyboardMode;var m=l.ListGrowingDirection;var S=l.SwipeDirection;var n=l.ListSeparators;var o=l.ListMode;var p=l.ListHeaderDesign;var r=l.Sticky;
var s=C.extend("sap.m.ListBase",{metadata:{library:"sap.m",dnd:true,properties:{inset:{type:"boolean",group:"Appearance",defaultValue:false},headerText:{type:"string",group:"Misc",defaultValue:null},headerDesign:{type:"sap.m.ListHeaderDesign",group:"Appearance",defaultValue:p.Standard,deprecated:true},footerText:{type:"string",group:"Misc",defaultValue:null},mode:{type:"sap.m.ListMode",group:"Behavior",defaultValue:o.None},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},includeItemInSelection:{type:"boolean",group:"Behavior",defaultValue:false},showUnread:{type:"boolean",group:"Misc",defaultValue:false},noDataText:{type:"string",group:"Misc",defaultValue:null},showNoData:{type:"boolean",group:"Misc",defaultValue:true},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:true},modeAnimationOn:{type:"boolean",group:"Misc",defaultValue:true},showSeparators:{type:"sap.m.ListSeparators",group:"Appearance",defaultValue:n.All},swipeDirection:{type:"sap.m.SwipeDirection",group:"Misc",defaultValue:S.Both},growing:{type:"boolean",group:"Behavior",defaultValue:false},growingThreshold:{type:"int",group:"Misc",defaultValue:20},growingTriggerText:{type:"string",group:"Appearance",defaultValue:null},growingScrollToLoad:{type:"boolean",group:"Behavior",defaultValue:false},growingDirection:{type:"sap.m.ListGrowingDirection",group:"Behavior",defaultValue:m.Downwards},rememberSelections:{type:"boolean",group:"Behavior",defaultValue:true},keyboardMode:{type:"sap.m.ListKeyboardMode",group:"Behavior",defaultValue:k.Navigation},sticky:{type:"sap.m.Sticky[]",group:"Appearance"}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.ListItemBase",multiple:true,singularName:"item",bindable:"bindable",selector:"#{id} .sapMListItems",dnd:true},swipeContent:{type:"sap.ui.core.Control",multiple:false},headerToolbar:{type:"sap.m.Toolbar",multiple:false},infoToolbar:{type:"sap.m.Toolbar",multiple:false},contextMenu:{type:"sap.ui.core.IContextMenu",multiple:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{deprecated:true,parameters:{listItem:{type:"sap.m.ListItemBase"}}},selectionChange:{parameters:{listItem:{type:"sap.m.ListItemBase"},listItems:{type:"sap.m.ListItemBase[]"},selected:{type:"boolean"},selectAll:{type:"boolean"}}},"delete":{parameters:{listItem:{type:"sap.m.ListItemBase"}}},swipe:{allowPreventDefault:true,parameters:{listItem:{type:"sap.m.ListItemBase"},swipeContent:{type:"sap.ui.core.Control"},srcControl:{type:"sap.ui.core.Control"}}},growingStarted:{deprecated:true,parameters:{actual:{type:"int"},total:{type:"int"}}},growingFinished:{deprecated:true,parameters:{actual:{type:"int"},total:{type:"int"}}},updateStarted:{parameters:{reason:{type:"string"},actual:{type:"int"},total:{type:"int"}}},updateFinished:{parameters:{reason:{type:"string"},actual:{type:"int"},total:{type:"int"}}},itemPress:{parameters:{listItem:{type:"sap.m.ListItemBase"},srcControl:{type:"sap.ui.core.Control"}}},beforeOpenContextMenu:{allowPreventDefault:true,parameters:{listItem:{type:"sap.m.ListItemBase"}}}},designtime:"sap/m/designtime/ListBase.designtime"}});
s.prototype.bAnnounceDetails=true;
s.getInvisibleText=function(){return this.oInvisibleText||(this.oInvisibleText=new I().toStatic());};
s.prototype.sNavItemClass="sapMLIB";
s.prototype.init=function(){this._aNavSections=[];this._aSelectedPaths=[];this._iItemNeedsHighlight=0;this.data("sap-ui-fastnavgroup","true",true);};
s.prototype.onBeforeRendering=function(){this._bRendering=true;this._bActiveItem=false;this._aNavSections=[];this._removeSwipeContent();};
s.prototype.onAfterRendering=function(){this._bRendering=false;this._sLastMode=this.getMode();if(D.system.desktop){this._bItemNavigationInvalidated=true;}};
s.prototype.exit=function(){this._oSelectedItem=null;this._aNavSections=[];this._aSelectedPaths=[];this._destroyGrowingDelegate();this._destroyItemNavigation();};
s.prototype.refreshItems=function(R){if(this._oGrowingDelegate){this._oGrowingDelegate.refreshItems(R);}else{if(!this._bReceivingData){this._updateStarted(R);this._bReceivingData=true;}this.refreshAggregation("items");}};
s.prototype.updateItems=function(R){if(this._oGrowingDelegate){this._oGrowingDelegate.updateItems(R);}else{if(this._bReceivingData){this._bReceivingData=false;}else{this._updateStarted(R);}this.updateAggregation("items");this._updateFinished();}};
s.prototype.setBindingContext=function(e,M){var i=(this.getBindingInfo("items")||{}).model;if(i===M){this._resetItemsBinding();}return C.prototype.setBindingContext.apply(this,arguments);};
s.prototype._bindAggregation=function(N,B){function e(B,E,H){B.events=B.events||{};if(!B.events[E]){B.events[E]=H;}else{var O=B.events[E];B.events[E]=function(){H.apply(this,arguments);O.apply(this,arguments);};}}if(N==="items"){this._resetItemsBinding();e(B,"dataRequested",this._onBindingDataRequestedListener.bind(this));e(B,"dataReceived",this._onBindingDataReceivedListener.bind(this));}C.prototype._bindAggregation.call(this,N,B);};
s.prototype._onBindingDataRequestedListener=function(e){this._showBusyIndicator();if(this._dataReceivedHandlerId!=null){clearTimeout(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}};
s.prototype._onBindingDataReceivedListener=function(e){if(this._dataReceivedHandlerId!=null){clearTimeout(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}this._dataReceivedHandlerId=setTimeout(function(){this._hideBusyIndicator();delete this._dataReceivedHandlerId;}.bind(this),0);};
s.prototype.destroyItems=function(e){if(!this.getItems(true).length){return this;}this._oSelectedItem=null;this.destroyAggregation("items","KeepDom");if(!e){this.invalidate();}return this;};
s.prototype.removeAllItems=function(A){this._oSelectedItem=null;return this.removeAllAggregation("items");};
s.prototype.removeItem=function(i){var e=this.removeAggregation("items",i);if(e&&e===this._oSelectedItem){this._oSelectedItem=null;}return e;};
s.prototype.getItems=function(R){if(R){return this.mAggregations["items"]||[];}return this.getAggregation("items",[]);};
s.prototype.getId=function(e){var i=this.sId;return e?i+"-"+e:i;};
s.prototype.setGrowing=function(e){e=!!e;if(this.getGrowing()!=e){this.setProperty("growing",e,!e);if(e){this._oGrowingDelegate=new G(this);}else if(this._oGrowingDelegate){this._oGrowingDelegate.destroy();this._oGrowingDelegate=null;}}return this;};
s.prototype.setGrowingThreshold=function(t){return this.setProperty("growingThreshold",t,true);};
s.prototype.setEnableBusyIndicator=function(e){this.setProperty("enableBusyIndicator",e,true);if(!this.getEnableBusyIndicator()){this._hideBusyIndicator();}return this;};
s.prototype.setNoDataText=function(N){this.setProperty("noDataText",N,true);this.$("nodata-text").text(this.getNoDataText());return this;};
s.prototype.getNoDataText=function(e){if(e&&this._bBusy){return"";}var N=this.getProperty("noDataText");N=N||sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_NO_DATA");return N;};
s.prototype.getSelectedItem=function(){var e=this.getItems(true);for(var i=0;i<e.length;i++){if(e[i].getSelected()){return e[i];}}return null;};
s.prototype.setSelectedItem=function(e,i,F){if(this.indexOfItem(e)<0){h.warning("setSelectedItem is called without valid ListItem parameter on "+this);return;}if(this._bSelectionMode){e.setSelected((i===undefined)?true:!!i);F&&this._fireSelectionChangeEvent([e]);}};
s.prototype.getSelectedItems=function(){return this.getItems(true).filter(function(i){return i.getSelected();});};
s.prototype.setSelectedItemById=function(i,e){var t=sap.ui.getCore().byId(i);return this.setSelectedItem(t,e);};
s.prototype.getSelectedContexts=function(A){var B=this.getBindingInfo("items"),M=(B||{}).model,e=this.getModel(M);if(!B||!e){return[];}if(A&&this.getRememberSelections()){return this._aSelectedPaths.map(function(P){return e.getContext(P);});}return this.getSelectedItems().map(function(i){return i.getBindingContext(M);});};
s.prototype.removeSelections=function(A,F,e){var i=[];this._oSelectedItem=null;A&&(this._aSelectedPaths=[]);this.getItems(true).forEach(function(t){if(!t.getSelected()){return;}if(e&&t.isSelectedBoundTwoWay()){return;}t.setSelected(false,true);i.push(t);!A&&this._updateSelectedPaths(t);},this);if(F&&i.length){this._fireSelectionChangeEvent(i);}return this;};
s.prototype.selectAll=function(F){if(this.getMode()!="MultiSelect"){return this;}var e=[];this.getItems(true).forEach(function(i){if(!i.getSelected()){i.setSelected(true,true);e.push(i);this._updateSelectedPaths(i);}},this);if(F&&e.length){this._fireSelectionChangeEvent(e,F);}return this;};
s.prototype.getLastMode=function(M){return this._sLastMode;};
s.prototype.setMode=function(M){M=this.validateProperty("mode",M);var O=this.getMode();if(O==M){return this;}this._bSelectionMode=M.indexOf("Select")>-1;if(!this._bSelectionMode){this.removeSelections(true);}else{var e=this.getSelectedItems();if(e.length>1){this.removeSelections(true);}else if(O===o.MultiSelect){this._oSelectedItem=e[0];}}return this.setProperty("mode",M);};
s.prototype.getGrowingInfo=function(){return this._oGrowingDelegate?this._oGrowingDelegate.getInfo():null;};
s.prototype.setRememberSelections=function(R){this.setProperty("rememberSelections",R,true);!this.getRememberSelections()&&(this._aSelectedPaths=[]);return this;};
s.prototype.setSelectedContextPaths=function(e){this._aSelectedPaths=e||[];};
s.prototype.getSelectedContextPaths=function(A){if(!A||(A&&this.getRememberSelections())){return this._aSelectedPaths.slice(0);}return this.getSelectedItems().map(function(i){return i.getBindingContextPath();});};
s.prototype.isAllSelectableSelected=function(){if(this.getMode()!=o.MultiSelect){return false;}var i=this.getItems(true),e=this.getSelectedItems().length,t=i.filter(function(u){return u.isSelectable();}).length;return(i.length>0)&&(e==t);};
s.prototype.getVisibleItems=function(){return this.getItems(true).filter(function(i){return i.getVisible();});};
s.prototype.getActiveItem=function(){return this._bActiveItem;};
s.prototype.onItemDOMUpdate=function(e){if(!this._bRendering&&this.bOutput){this._startItemNavigation(true);}};
s.prototype.onItemActiveChange=function(e,A){this._bActiveItem=A;};
s.prototype.onItemHighlightChange=function(i,N){this._iItemNeedsHighlight+=(N?1:-1);if(this._iItemNeedsHighlight==1&&N){this.$("listUl").addClass("sapMListHighlight");}else if(this._iItemNeedsHighlight==0){this.$("listUl").removeClass("sapMListHighlight");}};
s.prototype.onItemSelectedChange=function(e,i){if(this.getMode()==o.MultiSelect){this._updateSelectedPaths(e,i);return;}if(i){this._aSelectedPaths=[];this._oSelectedItem&&this._oSelectedItem.setSelected(false,true);this._oSelectedItem=e;}else if(this._oSelectedItem===e){this._oSelectedItem=null;}this._updateSelectedPaths(e,i);};
s.prototype.getItemsContainerDomRef=function(){return this.getDomRef("listUl");};
s.prototype.checkGrowingFromScratch=function(){};
s.prototype.onBeforePageLoaded=function(e,i){this._fireUpdateStarted(i,e);this.fireGrowingStarted(e);};
s.prototype.onAfterPageLoaded=function(e,i){this._fireUpdateFinished(e);this.fireGrowingFinished(e);};
s.prototype.addNavSection=function(i){this._aNavSections.push(i);return i;};
s.prototype.getMaxItemsCount=function(){var B=this.getBinding("items");if(B&&B.getLength){return B.getLength()||0;}return this.getItems(true).length;};
s.prototype.shouldRenderItems=function(){return true;};
s.prototype._resetItemsBinding=function(){if(this.isBound("items")){this._bUpdating=false;this._bReceivingData=false;this.removeSelections(true,false,true);this._oGrowingDelegate&&this._oGrowingDelegate.reset();this._hideBusyIndicator();if(this._oItemNavigation){this._oItemNavigation.iFocusedIndex=-1;}}};
s.prototype._updateStarted=function(R){if(!this._bReceivingData&&!this._bUpdating){this._bUpdating=true;this._fireUpdateStarted(R);}};
s.prototype._fireUpdateStarted=function(R,i){this._sUpdateReason=g(R||"Refresh");this.fireUpdateStarted({reason:this._sUpdateReason,actual:i?i.actual:this.getItems(true).length,total:i?i.total:this.getMaxItemsCount()});};
s.prototype.onThemeChanged=function(){if(this._oGrowingDelegate){this._oGrowingDelegate._updateTrigger();}};
s.prototype._updateFinished=function(){if(!this._bReceivingData&&this._bUpdating){this._fireUpdateFinished();this._bUpdating=false;}};
s.prototype._fireUpdateFinished=function(i){this._hideBusyIndicator();setTimeout(function(){this._bItemNavigationInvalidated=true;this.fireUpdateFinished({reason:this._sUpdateReason,actual:i?i.actual:this.getItems(true).length,total:i?i.total:this.getMaxItemsCount()});}.bind(this),0);};
s.prototype._showBusyIndicator=function(){if(this.getEnableBusyIndicator()&&!this.getBusy()&&!this._bBusy){this._bBusy=true;this._sBusyTimer=setTimeout(function(){this.$("nodata-text").text("");}.bind(this),this.getBusyIndicatorDelay());this.setBusy(true,"listUl");}};
s.prototype._hideBusyIndicator=function(){if(this._bBusy){this._bBusy=false;this.setBusy(false,"listUl");clearTimeout(this._sBusyTimer);if(!this.getItems(true).length){this.$("nodata-text").text(this.getNoDataText());}}};
s.prototype.onItemBindingContextSet=function(i){if(!this._bSelectionMode||!this.getRememberSelections()||!this.isBound("items")){return;}if(i.isSelectedBoundTwoWay()){return;}var P=i.getBindingContextPath();if(P){var e=(this._aSelectedPaths.indexOf(P)>-1);i.setSelected(e);}};
s.prototype.onItemInserted=function(i,e){if(e){this.onItemSelectedChange(i,true);}if(!this._bSelectionMode||!this._aSelectedPaths.length||!this.getRememberSelections()||!this.isBound("items")||i.isSelectedBoundTwoWay()||i.getSelected()){return;}var P=i.getBindingContextPath();if(P&&this._aSelectedPaths.indexOf(P)>-1){i.setSelected(true);}};
s.prototype.onItemSelect=function(e,i){if(this.getMode()==o.MultiSelect){this._fireSelectionChangeEvent([e]);}else if(this._bSelectionMode&&i){this._fireSelectionChangeEvent([e]);}};
s.prototype._fireSelectionChangeEvent=function(e,i){var t=e&&e[0];if(!t){return;}this.fireSelectionChange({listItem:t,listItems:e,selected:t.getSelected(),selectAll:!!i});this.fireSelect({listItem:t});};
s.prototype.onItemDelete=function(e){this.fireDelete({listItem:e});};
s.prototype.onItemPress=function(e,i){if(e.getType()==j.Inactive){return;}setTimeout(function(){this.fireItemPress({listItem:e,srcControl:i});}.bind(this),0);};
s.prototype._updateSelectedPaths=function(i,e){if(!this.getRememberSelections()||!this.isBound("items")){return;}var P=i.getBindingContextPath();if(!P){return;}e=(e===undefined)?i.getSelected():e;var t=this._aSelectedPaths.indexOf(P);if(e){t<0&&this._aSelectedPaths.push(P);}else{t>-1&&this._aSelectedPaths.splice(t,1);}};
s.prototype._destroyGrowingDelegate=function(){if(this._oGrowingDelegate){this._oGrowingDelegate.destroy();this._oGrowingDelegate=null;}};
s.prototype._destroyItemNavigation=function(){if(this._oItemNavigation){this.removeEventDelegate(this._oItemNavigation);this._oItemNavigation.destroy();this._oItemNavigation=null;}};
s.prototype._getTouchBlocker=function(){return this.$().children();};
s.prototype._getSwipeContainer=function(){return this._$swipeContainer||(this._$swipeContainer=q("<div>",{"id":this.getId("swp"),"class":"sapMListSwp"}));};
s.prototype._setSwipePosition=function(){if(this._isSwipeActive){return this._getSwipeContainer().css("top",this._swipedItem.$().position().top);}};
s.prototype._renderSwipeContent=function(){var $=this._swipedItem.$(),e=this._getSwipeContainer();this.$().prepend(e.css({top:$.position().top,height:$.outerHeight(true)}));if(this._bRerenderSwipeContent){this._bRerenderSwipeContent=false;var i=sap.ui.getCore().createRenderManager();i.render(this.getSwipeContent(),e.empty()[0]);i.destroy();}return this;};
s.prototype._swipeIn=function(){var t=this,$=t._getTouchBlocker(),i=t._getSwipeContainer();t._isSwipeActive=true;t._renderSwipeContent();b.addDialogInstance(t);window.document.activeElement.blur();q(window).on("resize.swp",function(){t._setSwipePosition();});$.css("pointer-events","none").on("touchstart.swp mousedown.swp",function(e){if(!i[0].firstChild.contains(e.target)){e.preventDefault();e.stopPropagation();}});i.bind("webkitAnimationEnd animationend",function(){q(this).unbind("webkitAnimationEnd animationend");i.css("opacity",1).focus();$.parent().on("touchend.swp touchcancel.swp mouseup.swp",function(e){if(!i[0].firstChild.contains(e.target)){t.swipeOut();}});}).removeClass("sapMListSwpOutAnim").addClass("sapMListSwpInAnim");};
s.prototype._onSwipeOut=function(e){this._getSwipeContainer().css("opacity",0).remove();q(window).off("resize.swp");this._getTouchBlocker().css("pointer-events","auto").off("touchstart.swp mousedown.swp");if(typeof e=="function"){e.call(this,this._swipedItem,this.getSwipeContent());}this._isSwipeActive=false;b.removeDialogInstance(this);};
s.prototype.swipeOut=function(e){if(!this._isSwipeActive){return this;}var t=this,$=this._getSwipeContainer();this._getTouchBlocker().parent().off("touchend.swp touchend.swp touchcancel.swp mouseup.swp");$.bind("webkitAnimationEnd animationend",function(){q(this).unbind("webkitAnimationEnd animationend");t._onSwipeOut(e);}).removeClass("sapMListSwpInAnim").addClass("sapMListSwpOutAnim");return this;};
s.prototype._removeSwipeContent=function(){if(this._isSwipeActive){this.swipeOut()._onSwipeOut();}};
s.prototype.close=s.prototype._removeSwipeContent;
s.prototype._onSwipe=function(e){var i=this.getSwipeContent(),t=e.srcControl;if(i&&t&&!this._isSwipeActive&&this!==t&&!this._eventHandledByControl&&D.support.touch){for(var u=t;u&&!(u instanceof d);u=u.oParent);if(u instanceof d){this._swipedItem=u;this.fireSwipe({listItem:this._swipedItem,swipeContent:i,srcControl:t},true)&&this._swipeIn();}}};
s.prototype.ontouchstart=function(e){this._eventHandledByControl=e.isMarked();};
s.prototype.onswipeleft=function(e){var i=sap.ui.getCore().getConfiguration().getRTL()?"RightToLeft":"LeftToRight";if(this.getSwipeDirection()!=i){this._onSwipe(e);}};
s.prototype.onswiperight=function(e){var i=sap.ui.getCore().getConfiguration().getRTL()?"LeftToRight":"RightToLeft";if(this.getSwipeDirection()!=i){this._onSwipe(e);}};
s.prototype.setSwipeDirection=function(e){return this.setProperty("swipeDirection",e,true);};
s.prototype.getSwipedItem=function(){return(this._isSwipeActive?this._swipedItem:null);};
s.prototype.setSwipeContent=function(e){this._bRerenderSwipeContent=true;this.toggleStyleClass("sapMListSwipable",!!e);return this.setAggregation("swipeContent",e,!this._isSwipeActive);};
s.prototype.invalidate=function(O){if(O&&O===this.getSwipeContent()){this._bRerenderSwipeContent=true;this._isSwipeActive&&this._renderSwipeContent();return;}return C.prototype.invalidate.apply(this,arguments);};
s.prototype.addItemGroup=function(e,H,i){H=H||new c({title:e.text||e.key});H._bGroupHeader=true;this.addAggregation("items",H,i);return H;};
s.prototype.removeGroupHeaders=function(e){this.getItems(true).forEach(function(i){if(i.isGroupHeader()){i.destroy(e);}});};
s.prototype.getAccessibilityType=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_LIST");};
s.prototype.getAccessibilityStates=function(){if(!this.getItems(true).length){return"";}var e="",M=o,i=this.getMode(),B=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(L.isRequired(this)){e+=B.getText("LIST_REQUIRED")+" ";}if(i==M.MultiSelect){e+=B.getText("LIST_MULTISELECTABLE")+" ";}else if(i==M.Delete){e+=B.getText("LIST_DELETABLE")+" ";}else if(i!=M.None){e+=B.getText("LIST_SELECTABLE")+" ";}if(this.isGrouped()){e+=B.getText("LIST_GROUPED")+" ";}return e;};
s.prototype.getAccessibilityDescription=function(){var e="";var H=this.getHeaderToolbar();if(H){var t=H.getTitleControl();if(t){e+=t.getText()+" ";}}else{e+=this.getHeaderText()+" ";}e+=this.getAccessibilityStates()+" ";return e;};
s.prototype.getAccessibilityInfo=function(){return{description:this.getAccessibilityDescription().trim(),focusable:true};};
s.prototype.getAccessbilityPosition=function(i){var e=0,t=this.getVisibleItems(),P=t.indexOf(i)+1,B=this.getBinding("items");if(this.getGrowing()&&this.getGrowingScrollToLoad()&&B&&B.isLengthFinal()){e=B.getLength();if(B.isGrouped()){e+=t.filter(function(i){return i.isGroupHeader()&&i.getVisible();}).length;}}else{e=t.length;}return{setSize:e,posInset:P};};
s.prototype.onItemFocusIn=function(i,F){this._handleStickyItemFocus(i.getDomRef());if(i!==F){return;}if(!sap.ui.getCore().getConfiguration().getAccessibility()){return;}var e=i.getDomRef(),P=this.getAccessbilityPosition(i);if(!i.getContentAnnouncement){this.getNavigationRoot().setAttribute("aria-activedescendant",e.id);e.setAttribute("aria-posinset",P.posInset);e.setAttribute("aria-setsize",P.setSize);}else{var A=i.getAccessibilityInfo(),B=sap.ui.getCore().getLibraryResourceBundle("sap.m"),t=A.type+" ";t+=B.getText("LIST_ITEM_POSITION",[P.posInset,P.setSize])+" ";t+=A.description;this.updateInvisibleText(t,e);return t;}};
s.prototype.updateInvisibleText=function(t,i,P){var e=s.getInvisibleText(),F=q(i||document.activeElement);if(this.bAnnounceDetails){this.bAnnounceDetails=false;t=this.getAccessibilityInfo().description+" "+t;}e.setText(t.trim());F.addAriaLabelledBy(e.getId(),P);window.setTimeout(function(){F.removeAriaLabelledBy(e.getId());},0);};
s.prototype.getNavigationRoot=function(){return this.getDomRef("listUl");};
s.prototype.getFocusDomRef=function(){return this.getNavigationRoot();};
s.prototype._startItemNavigation=function(i){if(!D.system.desktop){return;}var e=this.getKeyboardMode(),t=k;if(e==t.Edit&&!this.getItems(true).length){return;}var N=this.getNavigationRoot();var T=(e==t.Edit)?-1:0;if(i&&!N.contains(document.activeElement)){this._bItemNavigationInvalidated=true;if(!N.getAttribute("tabindex")){N.tabIndex=T;}return;}if(!this._oItemNavigation){this._oItemNavigation=new a();this._oItemNavigation.setCycling(false);this.addEventDelegate(this._oItemNavigation);this._setItemNavigationTabIndex(T);this._oItemNavigation.setTableMode(true,true).setColumns(1);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"]});}this._oItemNavigation.setPageSize(this.getGrowingThreshold());this._oItemNavigation.setRootDomRef(N);this.setNavigationItems(this._oItemNavigation,N);this._bItemNavigationInvalidated=false;};
s.prototype.setNavigationItems=function(i,N){var e=q(N).children(".sapMLIB").get();i.setItemDomRefs(e);if(i.getFocusedIndex()==-1){if(this.getGrowing()&&this.getGrowingDirection()==m.Upwards){i.setFocusedIndex(e.length-1);}else{i.setFocusedIndex(0);}}};
s.prototype.getItemNavigation=function(){return this._oItemNavigation;};
s.prototype._setItemNavigationTabIndex=function(t){if(this._oItemNavigation){this._oItemNavigation.iActiveTabIndex=t;this._oItemNavigation.iTabIndex=t;}};
s.prototype.setKeyboardMode=function(e){this.setProperty("keyboardMode",e,true);if(this.isActive()){var t=(e==k.Edit)?-1:0;this.$("nodata").prop("tabIndex",~t);this.$("listUl").prop("tabIndex",t);this.$("after").prop("tabIndex",t);this._setItemNavigationTabIndex(t);}return this;};
s.prototype.setItemFocusable=function(e){if(!this._oItemNavigation){return;}var i=this._oItemNavigation.getItemDomRefs();var t=i.indexOf(e.getDomRef());if(t>=0){this._oItemNavigation.setFocusedIndex(t);}};
s.prototype.forwardTab=function(F){this._bIgnoreFocusIn=true;this.$(F?"after":"before").focus();};
s.prototype.onsaptabnext=function(e){if(e.isMarked()||this.getKeyboardMode()==k.Edit){return;}if(e.target.id==this.getId("nodata")){this.forwardTab(true);e.setMarked();}};
s.prototype.onsaptabprevious=function(e){if(e.isMarked()||this.getKeyboardMode()==k.Edit){return;}var t=e.target.id;if(t==this.getId("nodata")){this.forwardTab(false);}else if(t==this.getId("trigger")){this.focusPrevious();e.preventDefault();}};
s.prototype._navToSection=function(F){var t;var i=0;var e=F?1:-1;var u=this._aNavSections.length;this._aNavSections.some(function(w,x){var y=(w?window.document.getElementById(w):null);if(y&&y.contains(document.activeElement)){i=x;return true;}});var v=this.getItemsContainerDomRef();var $=q(document.getElementById(this._aNavSections[i]));if($[0]===v&&this._oItemNavigation){$.data("redirect",this._oItemNavigation.getFocusedIndex());}this._aNavSections.some(function(){i=(i+e+u)%u;t=q(document.getElementById(this._aNavSections[i]));if(t[0]===v&&this._oItemNavigation){var R=t.data("redirect");var w=this._oItemNavigation.getItemDomRefs();var T=w[R]||v.children[0];t=q(T);}if(t.is(":focusable")){t.focus();return true;}},this);return t;};
s.prototype.onsapshow=function(e){if(e.isMarked()||e.which==K.F4||e.target.id!=this.getId("trigger")&&!q(e.target).hasClass(this.sNavItemClass)){return;}if(this._navToSection(true)){e.preventDefault();e.setMarked();}};
s.prototype.onsaphide=function(e){if(e.isMarked()||e.target.id!=this.getId("trigger")&&!q(e.target).hasClass(this.sNavItemClass)){return;}if(this._navToSection(false)){e.preventDefault();e.setMarked();}};
s.prototype.onkeydown=function(e){var i=(e.which==K.A)&&(e.metaKey||e.ctrlKey);if(e.isMarked()||!i||!q(e.target).hasClass(this.sNavItemClass)){return;}e.preventDefault();if(this.getMode()!==o.MultiSelect){return;}if(this.isAllSelectableSelected()){this.removeSelections(false,true);}else{this.selectAll(true);}e.setMarked();};
s.prototype.onmousedown=function(e){if(this._bItemNavigationInvalidated){this._startItemNavigation();}};
s.prototype.focusPrevious=function(){if(!this._oItemNavigation){return;}var N=this._oItemNavigation.getItemDomRefs();var i=this._oItemNavigation.getFocusedIndex();var $=q(N[i]);var R=$.control(0)||{};var t=R.getTabbables?R.getTabbables():$.find(":sapTabbable");var F=t.eq(-1).add($).eq(-1);this.bAnnounceDetails=true;F.focus();};
s.prototype.onfocusin=function(e){if(this._bIgnoreFocusIn){this._bIgnoreFocusIn=false;e.stopImmediatePropagation(true);return;}if(this._bItemNavigationInvalidated){this._startItemNavigation();}var t=e.target;if(t.id==this.getId("nodata")){this.updateInvisibleText(this.getNoDataText(),t);}if(e.isMarked()||!this._oItemNavigation||this.getKeyboardMode()==k.Edit||t.id!=this.getId("after")){return;}this.focusPrevious();e.setMarked();};
s.prototype.onsapfocusleave=function(e){if(this._oItemNavigation&&!this.bAnnounceDetails&&!this.getNavigationRoot().contains(document.activeElement)){this.bAnnounceDetails=true;}};
s.prototype.onItemArrowUpDown=function(e,E){var i=this.getItems(true),t=i.indexOf(e)+(E.type=="sapup"?-1:1),u=i[t];if(u&&u.isGroupHeader()){u=i[t+(E.type=="sapup"?-1:1)];}if(!u){return;}var T=u.getTabbables(),F=e.getTabbables().index(E.target),$=T.eq(T[F]?F:-1);$[0]?$.focus():u.focus();E.preventDefault();E.setMarked();};
s.prototype.onItemContextMenu=function(e,E){var i=this.getContextMenu();if(!i){return;}var t=this.fireBeforeOpenContextMenu({listItem:e,column:sap.ui.getCore().byId(q(E.target).closest(".sapMListTblCell",this.getNavigationRoot()).attr("data-sap-ui-column"))});if(t){E.setMarked();E.preventDefault();var B,u=this.getBindingInfo("items");if(u){B=e.getBindingContext(u.model);i.setBindingContext(B);}i.openAsContextMenu(E,e);}};
s.prototype.isGrouped=function(){var B=this.getBinding("items");return B&&B.isGrouped();};
s.prototype.setContextMenu=function(e){this.setAggregation("contextMenu",e,true);};
s.prototype.destroyContextMenu=function(){this.destroyAggregation("contextMenu",true);};
s.getStickyBrowserSupport=function(){var B=D.browser;return(B.safari||B.chrome||(B.firefox&&B.version>=59)||(B.edge&&B.version>=16));};
s.prototype.getStickyStyleValue=function(){var e=this.getSticky();if(!e||!e.length||!s.getStickyBrowserSupport()){return(this._iStickyValue=0);}var i=0,H=this.getHeaderText(),t=this.getHeaderToolbar(),u=H||(t&&t.getVisible()),v=this.getInfoToolbar(),w=v&&v.getVisible(),x=false;if(this.isA("sap.m.Table")){x=this.getColumns().some(function(y){return y.getVisible()&&y.getHeader();});}e.forEach(function(y){if(y===r.HeaderToolbar&&u){i+=1;}else if(y===r.InfoToolbar&&w){i+=2;}else if(y===r.ColumnHeaders&&x){i+=4;}});return(this._iStickyValue=i);};
s.prototype._handleStickyItemFocus=function(i){if(!this._iStickyValue||this._sLastFocusedStickyItemId===i.id){return;}var e=l.getScrollDelegate(this,true);if(!e){return;}var t=0,T=0,u=0,v=0,H=0,w=0;if(this._iStickyValue&4){var x=this.getDomRef("tblHeader").firstChild;var y=x.getBoundingClientRect();T=parseInt(y.bottom);t=parseInt(y.height);}if(this._iStickyValue&2){var z=this.getDomRef().querySelector(".sapMListInfoTBarContainer");if(z){var A=z.getBoundingClientRect();v=parseInt(A.bottom);u=parseInt(A.height);}}if(this._iStickyValue&1){var B=this.getDomRef().querySelector(".sapMListHdr");if(B){var E=B.getBoundingClientRect();w=parseInt(E.bottom);H=parseInt(E.height);}}var F=Math.round(i.getBoundingClientRect().top);if(T>F||v>F||w>F){window.requestAnimationFrame(function(){e.scrollToElement(i,0,[0,-t-u-H]);});}this._sLastFocusedStickyItemId=i.id;};
s.prototype.setHeaderToolbar=function(H){return this._setToolbar("headerToolbar",H);};
s.prototype.setInfoToolbar=function(i){return this._setToolbar("infoToolbar",i);};
s.prototype._setToolbar=function(A,t){var O=this.getAggregation(A);if(O){O.detachEvent("_change",this._onToolbarPropertyChanged,this);}this.setAggregation(A,t);if(t){t.attachEvent("_change",this._onToolbarPropertyChanged,this);}return this;};
s.prototype._onToolbarPropertyChanged=function(e){if(e.getParameter("name")!=="visible"){return;}var O=this._iStickyValue,N=this.getStickyStyleValue();if(O!==N){var i=this.getDomRef();if(i){var t=i.classList;t.toggle("sapMSticky",!!N);t.remove("sapMSticky"+O);t.toggle("sapMSticky"+N,!!N);}}};
return s;});
sap.ui.predefine('sap/m/ListBaseRenderer',["sap/m/library","sap/ui/Device","./ListItemBaseRenderer"],function(l,D,L){"use strict";var a=l.ListGrowingDirection;var b=l.ListKeyboardMode;var T=l.ToolbarDesign;var c={};c.ModeOrder={None:0,Delete:1,MultiSelect:-1,SingleSelect:1,SingleSelectLeft:-1,SingleSelectMaster:0};
c.render=function(r,C){r.write("<div");r.addClass("sapMList");r.writeControlData(C);if(C.getInset()){r.addClass("sapMListInsetBG");}if(C.getWidth()){r.addStyle("width",C.getWidth());}if(C.getBackgroundDesign){r.addClass("sapMListBG"+C.getBackgroundDesign());}var t=C.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}this.renderContainerAttributes(r,C);r.writeStyles();r.writeClasses();r.write(">");var h=C.getHeaderText();var H=C.getHeaderToolbar();if(H){H.setDesign(T.Transparent,true);H.addStyleClass("sapMListHdr");H.addStyleClass("sapMListHdrTBar");H.addStyleClass("sapMTBHeader-CTX");r.renderControl(H);}else if(h){r.write("<header class='sapMListHdr sapMListHdrText'");r.writeAttribute("id",C.getId("header"));r.write(">");r.writeEscaped(h);r.write("</header>");}var I=C.getInfoToolbar();if(I){I.setDesign(T.Info,true);I.addStyleClass("sapMListInfoTBar");r.write("<div class='sapMListInfoTBarContainer'>");r.renderControl(I);r.write("</div>");}var d=C.getItems(),s=C.getShowNoData(),R=C.shouldRenderItems()&&d.length,e=C.getKeyboardMode()==b.Edit?-1:0,u=C.getGrowingDirection()==a.Upwards&&C.getGrowing();if(u){this.renderGrowing(r,C);}if(R||s){this.renderDummyArea(r,C,"before",-1);}this.renderListStartAttributes(r,C);r.writeAccessibilityState(C,this.getAccessibilityState(C));r.addClass("sapMListUl");if(C._iItemNeedsHighlight){r.addClass("sapMListHighlight");}r.writeAttribute("id",C.getId("listUl"));if(R||s){r.writeAttribute("tabindex",e);}r.addClass("sapMListShowSeparators"+C.getShowSeparators());r.addClass("sapMListMode"+C.getMode());r.writeClasses();r.writeStyles();r.write(">");this.renderListHeadAttributes(r,C);if(R){if(u){d.reverse();}for(var i=0;i<d.length;i++){r.renderControl(d[i]);}}if(!R&&s){this.renderNoData(r,C);}this.renderListEndAttributes(r,C);if(R||s){this.renderDummyArea(r,C,"after",e);}if(!u){this.renderGrowing(r,C);}if(C.getFooterText()){r.write("<footer class='sapMListFtr'");r.writeAttribute("id",C.getId("footer"));r.write(">");r.writeEscaped(C.getFooterText());r.write("</footer>");}r.write("</div>");};
c.renderContainerAttributes=function(r,C){var s=C.getStickyStyleValue();if(s){r.addClass("sapMSticky");r.addClass("sapMSticky"+s);}};
c.renderListHeadAttributes=function(r,C){};
c.renderListStartAttributes=function(r,C){r.write("<ul");r.addClass("sapMListItems");C.addNavSection(C.getId("listUl"));};
c.getAriaRole=function(C){return"listbox";};
c.getAriaLabelledBy=function(C){};
c.getAriaDescribedBy=function(C){if(C.getFooterText()){return C.getId("footer");}};
c.getAccessibilityState=function(C){var r=this.getAriaRole(C);return{role:r,multiselectable:(r&&C._bSelectionMode)?C.getMode()=="MultiSelect":undefined,labelledby:{value:this.getAriaLabelledBy(C),append:true},describedby:{value:this.getAriaDescribedBy(C),append:true}};};
c.renderListEndAttributes=function(r,C){r.write("</ul>");};
c.renderNoData=function(r,C){r.write("<li");r.writeAttribute("tabindex",C.getKeyboardMode()==b.Navigation?-1:0);r.writeAttribute("id",C.getId("nodata"));r.addClass("sapMLIB sapMListNoData sapMLIBTypeInactive");L.addFocusableClasses.call(L,r);r.writeClasses();r.write(">");r.write("<div");r.addClass("sapMListNoDataText");r.writeAttribute("id",C.getId("nodata-text"));r.writeClasses();r.write(">");r.writeEscaped(C.getNoDataText(true));r.write("</div>");r.write("</li>");};
c.renderDummyArea=function(r,C,A,t){r.write("<div");r.writeAttribute("id",C.getId(A));r.writeAttribute("tabindex",t);if(D.system.desktop){r.addClass("sapMListDummyArea").writeClasses();}r.write("></div>");};
c.renderGrowing=function(r,C){var g=C._oGrowingDelegate;if(!g){return;}g.render(r);};
return c;},true);
sap.ui.predefine('sap/m/ListItemBase',["sap/ui/base/DataType","sap/ui/events/KeyCodes","sap/ui/model/BindingMode","sap/ui/Device","sap/ui/core/library","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/Icon","./library","./Button","./CheckBox","./RadioButton","./ListItemBaseRenderer","sap/base/strings/capitalize","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/Selectors"],function(D,K,B,a,c,C,I,b,l,d,e,R,L,f,q){"use strict";var g=l.ListKeyboardMode;var h=l.ListMode;var i=l.ListType;var j=l.ButtonType;var M=c.MessageType;
var k=C.extend("sap.m.ListItemBase",{metadata:{library:"sap.m",properties:{type:{type:"sap.m.ListType",group:"Misc",defaultValue:i.Inactive},visible:{type:"boolean",group:"Appearance",defaultValue:true},unread:{type:"boolean",group:"Misc",defaultValue:false},selected:{type:"boolean",defaultValue:false},counter:{type:"int",group:"Misc",defaultValue:null},highlight:{type:"string",group:"Appearance",defaultValue:"None"},highlightText:{type:"string",group:"Misc",defaultValue:""}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{tap:{deprecated:true},detailTap:{deprecated:true},press:{},detailPress:{}},designtime:"sap/m/designtime/ListItemBase.designtime"}});
k.getAccessibilityText=function(o,m){if(!o||!o.getVisible||!o.getVisible()){return"";}var A;if(o.getAccessibilityInfo){A=o.getAccessibilityInfo();}if(!A||!o.getAccessibilityInfo){A=this.getDefaultAccessibilityInfo(o.getDomRef());}A=q.extend({type:"",description:"",children:[]},A);var n=sap.ui.getCore().getLibraryResourceBundle("sap.m"),t=A.type+" "+A.description+" ",T=o.getTooltip_AsString();if(A.enabled===false){t+=n.getText("CONTROL_DISABLED")+" ";}if(A.editable===false){t+=n.getText("CONTROL_READONLY")+" ";}if(!A.type&&T&&t.indexOf(T)==-1){t=T+" "+t;}A.children.forEach(function(p){t+=k.getAccessibilityText(p)+" ";});t=t.trim();if(m&&!t){t=n.getText("CONTROL_EMPTY");}return t;};
k.getDefaultAccessibilityInfo=function(o){if(!o){return null;}var N=window.Node,m=window.NodeFilter,t=document.createTreeWalker(o,m.SHOW_TEXT+m.SHOW_ELEMENT,function(n){if(n.type===N.ELEMENT_NODE){if(n.classList.contains("sapUiInvisibleText")){return m.FILTER_SKIP;}if(n.getAttribute("aria-hidden")=="true"||n.style.visibility=="hidden"||n.style.display=="none"){return m.FILTER_REJECT;}return m.FILTER_SKIP;}return m.FILTER_ACCEPT;},false);var T=[];while(t.nextNode()){var n=t.currentNode;if(n.nodeType===N.TEXT_NODE){var s=(n.nodeValue||"").trim();if(s){T.push(s);}}}return{description:T.join(" ")};};
k.prototype.DetailIconURI=I.getIconURI("edit");k.prototype.DeleteIconURI=I.getIconURI("sys-cancel");k.prototype.NavigationIconURI=I.getIconURI("slim-arrow-right");k.prototype.TagName="li";
k.prototype.init=function(){this._active=false;this._bGroupHeader=false;this._bNeedsHighlight=false;};
k.prototype.onAfterRendering=function(){this.informList("DOMUpdate",true);this._checkHighlight();};
k.prototype.invalidate=function(){if(!this.bOutput){return;}C.prototype.invalidate.apply(this,arguments);};
k.prototype.getBindingContextPath=function(m){var o=this.getList();if(o&&!m){m=(o.getBindingInfo("items")||{}).model;}var n=this.getBindingContext(m);if(n){return n.getPath();}};
k.prototype.isSelectedBoundTwoWay=function(){var o=this.getBinding("selected");if(o&&o.getBindingMode()==B.TwoWay){return true;}};
k.prototype.getList=function(){var p=this.getParent();if(p&&p.isA("sap.m.ListBase")){return p;}};
k.prototype.getListProperty=function(p,F){var o=this.getList();if(o){p=f(p);return o["get"+p]();}return F;};
k.prototype.informList=function(E,p,P){var o=this.getList();if(o){var m="onItem"+E;if(o[m]){o[m](this,p,P);}}};
k.prototype.informSelectedChange=function(s){var o=this.getList();if(o){o.onItemSelectedChange(this,s);this.bSelectedDelayed=undefined;}else{this.bSelectedDelayed=s;}};
k.prototype.getAccessibilityType=function(o){return o.getText("ACC_CTR_TYPE_OPTION");};
k.prototype.getGroupAnnouncement=function(){return this.$().prevAll(".sapMGHLI:first").text();};
k.prototype.getAccessibilityDescription=function(o){var O=[],t=this.getType(),H=this.getHighlight(),T=this.getTooltip_AsString();if(this.getSelected()){O.push(o.getText("LIST_ITEM_SELECTED"));}if(H!==M.None){var s=this.getHighlightText();if(H in M&&!s){s=o.getText("LIST_ITEM_STATE_"+H.toUpperCase());}O.push(s);}if(this.getUnread()&&this.getListProperty("showUnread")){O.push(o.getText("LIST_ITEM_UNREAD"));}if(this.getCounter()){O.push(o.getText("LIST_ITEM_COUNTER",this.getCounter()));}if(t==i.Navigation){O.push(o.getText("LIST_ITEM_NAVIGATION"));}else{if(t==i.Detail||t==i.DetailAndActive){O.push(o.getText("LIST_ITEM_DETAIL"));}if(t==i.Active||t==i.DetailAndActive){O.push(o.getText("LIST_ITEM_ACTIVE"));}}O.push(this.getGroupAnnouncement()||"");if(this.getContentAnnouncement){O.push((this.getContentAnnouncement(o)||"").trim());}if(T){O.push(T);}return O.join(" ");};
k.prototype.getAccessibilityInfo=function(){var o=sap.ui.getCore().getLibraryResourceBundle("sap.m");return{type:this.getAccessibilityType(o),description:this.getAccessibilityDescription(o),focusable:true};};
k.prototype.getMode=function(){return this.getListProperty("mode","");};
k.prototype.updateAccessibilityState=function(A){var t=this.$();if(!t.length){return;}var $=t.parent().children(".sapMLIB");t.attr(q.extend({"aria-setsize":$.length,"aria-posinset":$.index(t)+1},A));};
k.prototype.getDeleteControl=function(m){if(!m||this._oDeleteControl){return this._oDeleteControl;}this._oDeleteControl=new d({id:this.getId()+"-imgDel",icon:this.DeleteIconURI,type:j.Transparent,tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_ITEM_DELETE")}).addStyleClass("sapMLIBIconDel sapMLIBSelectD").setParent(this,null,true).attachPress(function(E){this.informList("Delete");},this);this._oDeleteControl._bExcludeFromTabChain=true;return this._oDeleteControl;};
k.prototype.getDetailControl=function(m){if(!m||this._oDetailControl){return this._oDetailControl;}this._oDetailControl=new d({id:this.getId()+"-imgDet",icon:this.DetailIconURI,type:j.Transparent,tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_ITEM_EDIT")}).addStyleClass("sapMLIBType sapMLIBIconDet").setParent(this,null,true).attachPress(function(){this.fireDetailTap();this.fireDetailPress();},this);this._oDetailControl._bExcludeFromTabChain=true;return this._oDetailControl;};
k.prototype.getNavigationControl=function(m){if(!m||this._oNavigationControl){return this._oNavigationControl;}this._oNavigationControl=new b({id:this.getId()+"-imgNav",src:this.NavigationIconURI,useIconTooltip:false,noTabStop:true}).setParent(this,null,true).addStyleClass("sapMLIBType sapMLIBImgNav");return this._oNavigationControl;};
k.prototype.getSingleSelectControl=function(m){if(!m||this._oSingleSelectControl){m&&this._oSingleSelectControl.setSelected(this.getSelected());return this._oSingleSelectControl;}this._oSingleSelectControl=new R({id:this.getId()+"-selectSingle",groupName:this.getListProperty("id")+"_selectGroup",activeHandling:false,selected:this.getSelected()}).addStyleClass("sapMLIBSelectS").setParent(this,null,true).setTabIndex(-1).attachSelect(function(E){var s=E.getParameter("selected");this.setSelected(s);this.informList("Select",s);},this);return this._oSingleSelectControl;};
k.prototype.getMultiSelectControl=function(m){if(!m||this._oMultiSelectControl){m&&this._oMultiSelectControl.setSelected(this.getSelected());return this._oMultiSelectControl;}this._oMultiSelectControl=new e({id:this.getId()+"-selectMulti",activeHandling:false,selected:this.getSelected()}).addStyleClass("sapMLIBSelectM").setParent(this,null,true).setTabIndex(-1).attachSelect(function(E){var s=E.getParameter("selected");this.setSelected(s);this.informList("Select",s);},this);return this._oMultiSelectControl;};
k.prototype.getModeControl=function(m){var s=this.getMode();if(!s||s==h.None){return;}if(s==h.Delete){return this.getDeleteControl(m);}if(s==h.MultiSelect){return this.getMultiSelectControl(m);}return this.getSingleSelectControl(m);};
k.prototype.getTypeControl=function(m){var t=this.getType();if(t==i.Detail||t==i.DetailAndActive){return this.getDetailControl(m);}if(t==i.Navigation){return this.getNavigationControl(m);}};
k.prototype.destroyControls=function(m){m.forEach(function(s){s="_o"+s+"Control";if(this[s]){this[s].destroy("KeepDom");this[s]=null;}},this);};
k.prototype.isActionable=function(){return this.isIncludedIntoSelection()||(this.getType()!=i.Inactive&&this.getType()!=i.Detail);};
k.prototype.exit=function(){this._oLastFocused=null;this._checkHighlight(false);this.setActive(false);this.destroyControls(["Delete","SingleSelect","MultiSelect","Detail","Navigation"]);};
k.prototype.setHighlight=function(v){if(v==null){v=M.None;}else if(!D.getType("sap.ui.core.MessageType").isValid(v)&&!D.getType("sap.ui.core.IndicationColor").isValid(v)){throw new Error('"'+v+'" is not a value of the enums sap.ui.core.MessageType or sap.ui.core.IndicationColor for property "highlight" of '+this);}return this.setProperty("highlight",v);};
k.prototype.isSelectable=function(){var m=this.getMode();return!(m==h.None||m==h.Delete);};
k.prototype.getSelected=function(){if(this.isSelectable()){return this.getProperty("selected");}return false;};
k.prototype.isSelected=k.prototype.getSelected;
k.prototype.setSelected=function(s,m){s=this.validateProperty("selected",s);if(!this.isSelectable()||s==this.getSelected()){return this;}if(!m){this.informSelectedChange(s);}var S=this.getModeControl();if(S){S.setSelected(s);}this.updateSelectedDOM(s,this.$());this.setProperty("selected",s,true);return this;};
k.prototype.updateSelectedDOM=function(s,t){t.toggleClass("sapMLIBSelected",s);t.attr("aria-selected",s);};
k.prototype.setParent=function(p){C.prototype.setParent.apply(this,arguments);if(!p){this._bGroupHeader=false;return;}this.informList("Inserted",this.bSelectedDelayed);return this;};
k.prototype.setBindingContext=function(){C.prototype.setBindingContext.apply(this,arguments);this.informList("BindingContextSet");return this;};
k.prototype.isGroupHeader=function(){return this._bGroupHeader;};
k.prototype.isIncludedIntoSelection=function(){if(!this.isSelectable()){return false;}var m=this.getMode();return m==h.SingleSelectMaster||(this.getListProperty("includeItemInSelection")&&(m==h.SingleSelectLeft||m==h.SingleSelect||m==h.MultiSelect));};
k.prototype._checkHighlight=function(n){if(n==undefined){n=(this.getVisible()&&this.getHighlight()!=M.None);}if(this._bNeedsHighlight!=n){this._bNeedsHighlight=n;this.informList("HighlightChange",n);}};
k.prototype.hasActiveType=function(){var t=this.getType();return(t==i.Active||t==i.Navigation||t==i.DetailAndActive);};
k.prototype.setActive=function(A){if(A==this._active){return this;}if(A&&this.getListProperty("activeItem")){return this;}var t=this.$();this._active=A;this._activeHandling(t);if(this.getType()==i.Navigation){this._activeHandlingNav(t);}if(A){this._activeHandlingInheritor(t);}else{this._inactiveHandlingInheritor(t);}this.informList("ActiveChange",A);};
k.detectTextSelection=function(o){var s=window.getSelection(),t=s.toString().replace("\n","");return t&&q.contains(o,s.focusNode);};
k.prototype.ontap=function(E){if(this._eventHandledByControl){return E.setMarked();}if(k.detectTextSelection(this.getDomRef())){return;}if(this.isIncludedIntoSelection()){if(this.getMode()==h.MultiSelect){this.setSelected(!this.getSelected());this.informList("Select",this.getSelected());}else if(!this.getSelected()){this.setSelected(true);this.informList("Select",true);}}else if(this.hasActiveType()){window.clearTimeout(this._timeoutIdStart);window.clearTimeout(this._timeoutIdEnd);this.setActive(true);if(a.os.ios){this.focus();}setTimeout(function(){this.setActive(false);}.bind(this),180);setTimeout(function(){this.fireTap();this.firePress();}.bind(this),0);}this.informList("Press",E.srcControl);};
k.prototype.ontouchstart=function(E){this._eventHandledByControl=E.isMarked();var t=E.targetTouches[0];this._touchedY=t.clientY;this._touchedX=t.clientX;if(this._eventHandledByControl||E.touches.length!=1||!this.hasActiveType()){return;}this._timeoutIdStart=setTimeout(function(){this.setActive(true);}.bind(this),100);};
k.prototype.ontouchmove=function(E){if((this._active||this._timeoutIdStart)&&(Math.abs(this._touchedY-E.targetTouches[0].clientY)>10||Math.abs(this._touchedX-E.targetTouches[0].clientX)>10)){clearTimeout(this._timeoutIdStart);this._timeoutIdStart=null;this._timeoutIdEnd=null;this.setActive(false);}};
k.prototype.ontouchend=function(E){if(E.targetTouches.length==0&&this.hasActiveType()){this._timeoutIdEnd=setTimeout(function(){this.setActive(false);}.bind(this),100);}};
k.prototype.ontouchcancel=k.prototype.ontouchend;
k.prototype._activeHandlingNav=function(){};
k.prototype._activeHandlingInheritor=function(){};
k.prototype._inactiveHandlingInheritor=function(){};
k.prototype._activeHandling=function(t){t.toggleClass("sapMLIBActive",this._active);if(a.system.desktop&&this.isActionable()){t.toggleClass("sapMLIBHoverable",!this._active);}};
k.prototype.onsapspace=function(E){if(E.srcControl!==this){return;}E.preventDefault();if(E.isMarked()||!this.isSelectable()){return;}if(this.getMode()==h.MultiSelect){this.setSelected(!this.getSelected());this.informList("Select",this.getSelected());}else if(!this.getSelected()){this.setSelected(true);this.informList("Select",true);}E.setMarked();};
k.prototype.onsapenter=function(E){var o=this.getList();if(E.isMarked()||!o){return;}if(E.srcControl!==this&&o.getKeyboardMode()==g.Edit){o.setKeyboardMode(g.Navigation);this._switchFocus(E);return;}if(E.srcControl!==this){return;}if(this.isIncludedIntoSelection()){this.onsapspace(E);}else if(this.hasActiveType()){E.setMarked();this.setActive(true);setTimeout(function(){this.setActive(false);}.bind(this),180);setTimeout(function(){this.fireTap();this.firePress();}.bind(this),0);}o.onItemPress(this,E.srcControl);};
k.prototype.onsapdelete=function(E){if(E.isMarked()||E.srcControl!==this||this.getMode()!=h.Delete){return;}this.informList("Delete");E.preventDefault();E.setMarked();};
k.prototype._switchFocus=function(E){var o=this.getList();if(!o){return;}var t=this.getTabbables();if(E.srcControl!==this){o._iLastFocusPosOfItem=t.index(E.target);this.focus();}else if(t.length){var F=o._iLastFocusPosOfItem||0;F=t[F]?F:-1;t.eq(F).focus();}E.preventDefault();E.setMarked();};
k.prototype.onkeydown=function(E){if(E.isMarked()){return;}if(E.which==K.F7){this._switchFocus(E);return;}if(E.which==K.F2){if(E.srcControl===this&&this.getType().indexOf("Detail")==0&&this.hasListeners("detailPress")||this.hasListeners("detailTap")){this.fireDetailTap();this.fireDetailPress();E.preventDefault();E.setMarked();}else{var o=this.getList();if(o){this.$().prop("tabIndex",-1);o.setKeyboardMode(o.getKeyboardMode()==g.Edit?g.Navigation:g.Edit);this._switchFocus(E);}}}};
k.prototype.getTabbables=function(){return this.$().find(":sapTabbable");};
k.prototype.onsaptabnext=function(E){var o=this.getList();if(!o||E.isMarked()||o.getKeyboardMode()==g.Edit){return;}var m=this.getTabbables().get(-1)||this.getDomRef();if(E.target===m){o.forwardTab(true);E.setMarked();}};
k.prototype.onsaptabprevious=function(E){var o=this.getList();if(!o||E.isMarked()||o.getKeyboardMode()==g.Edit){return;}if(E.target===this.getDomRef()){o.forwardTab(false);E.setMarked();}};
k.prototype.onfocusin=function(E){var o=this.getList();if(!o||E.isMarked()){return;}this.informList("FocusIn",E.srcControl);if(E.srcControl===this){return;}if(o.getKeyboardMode()==g.Edit||!q(E.target).is(":sapFocusable")){return;}setTimeout(o["setItemFocusable"].bind(o,this),0);E.setMarked();};
k.prototype.onsapup=function(E){if(E.isMarked()||E.srcControl===this||this.getListProperty("keyboardMode")===g.Navigation){return;}this.informList("ArrowUpDown",E);};
k.prototype.oncontextmenu=function(E){if(this._bGroupHeader){return;}if(q(document.activeElement).is(":focusable")&&document.activeElement!==this.getDomRef()&&E.srcControl!==this.getModeControl()){return;}this.informList("ContextMenu",E);};
k.prototype.onsapdown=k.prototype.onsapup;return k;});
sap.ui.predefine('sap/m/ListItemBaseRenderer',["./library","sap/ui/Device","sap/ui/core/InvisibleText"],function(l,D,I){"use strict";var L=l.ListType;var a=l.ListMode;var b={};
b.renderInvisible=function(r,o){this.openItemTag(r,o);r.writeInvisiblePlaceholderData(o);r.write(">");this.closeItemTag(r,o);};
b.renderHighlight=function(r,o){var h=o.getHighlight();if(h=="None"){return;}r.write("<div");r.addClass("sapMLIBHighlight");r.addClass("sapMLIBHighlight"+h);r.writeClasses();r.write("></div>");};
b.isModeMatched=function(m,o){var O=(sap.ui.require("sap/m/ListBaseRenderer")||{}).ModeOrder||{};return O[m]==o;};
b.renderMode=function(r,o,O){var m=o.getMode();if(!this.isModeMatched(m,O)){return;}var M=o.getModeControl(true);if(M){this.renderModeContent(r,o,M);}};
b.renderModeContent=function(r,o,m){this.decorateMode(m,o);r.renderControl(m);};
b.decorateMode=function(m,o){m.removeStyleClass("sapMLIBSelectAnimation sapMLIBUnselectAnimation");if(!sap.ui.getCore().getConfiguration().getAnimation()||!o.getListProperty("modeAnimationOn")){return;}var M=o.getMode(),s=o.getListProperty("lastMode");if(!s||s==M){return;}if(M==a.None){m.addStyleClass("sapMLIBUnselectAnimation");}else{m.addStyleClass("sapMLIBSelectAnimation");}};
b.renderCounter=function(r,o){var c=o.getCounter();if(c){this.renderCounterContent(r,o,c);}};
b.renderCounterContent=function(r,o,c){r.write("<div");r.writeAttribute("id",o.getId()+"-counter");var A=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_ITEM_COUNTER",c);r.writeAttribute("aria-label",A);r.addClass("sapMLIBCounter");r.writeClasses();r.write(">");r.write(c);r.write("</div>");};
b.renderType=function(r,o){var t=o.getTypeControl(true);if(t){r.renderControl(t);}};
b.openItemTag=function(r,o){r.write("<"+o.TagName);};
b.closeItemTag=function(r,o){r.write("</"+o.TagName+">");};
b.renderTabIndex=function(r,o){r.writeAttribute("tabindex","-1");};
b.renderTooltip=function(r,o){var t=o.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}};
b.addFocusableClasses=function(r,o){if(D.system.desktop){r.addClass("sapMLIBFocusable");this.addLegacyOutlineClass(r,o);}};
b.addLegacyOutlineClass=function(r,o){if(D.browser.msie||D.browser.edge){r.addClass("sapMLIBLegacyOutline");}};
b.getAriaAnnouncement=function(k,B){return I.getStaticId("sap.m",B||"LIST_ITEM_"+k.toUpperCase());};
b.getAriaRole=function(o){return"option";};
b.getAriaLabelledBy=function(o){if(!o.getContentAnnouncement&&o.getAriaLabelledBy().length){return o.getId();}};
b.getAriaDescribedBy=function(o){if(o.getContentAnnouncement){return"";}var d=[],t=o.getType();if(o.getListProperty("showUnread")&&o.getUnread()){d.push(this.getAriaAnnouncement("unread"));}if(o.getMode()==a.Delete){d.push(this.getAriaAnnouncement("delete"));}if(t==L.Navigation){d.push(this.getAriaAnnouncement("navigation"));}else{if(t==L.Detail||t==L.DetailAndActive){d.push(this.getAriaAnnouncement("detail"));}if(t==L.Active||t==L.DetailAndActive){d.push(this.getAriaAnnouncement("active"));}}return d.join(" ");};
b.getAccessibilityState=function(o){var A=this.getAriaLabelledBy(o),s=this.getAriaDescribedBy(o),m={role:this.getAriaRole(o)};if(o.isSelectable()){m.selected=o.getProperty("selected");}if(A){m.labelledby={value:A.trim(),append:true};}if(s){m.describedby={value:s.trim(),append:true};}return m;};
b.renderLIContent=function(r,o){};
b.renderLIAttributes=function(r,o){};
b.renderContentFormer=function(r,o){this.renderHighlight(r,o);this.renderMode(r,o,-1);};
b.renderContentLatter=function(r,o){this.renderCounter(r,o);this.renderType(r,o);this.renderMode(r,o,1);};
b.renderLIContentWrapper=function(r,o){r.write('<div class="sapMLIBContent"');r.writeAttribute("id",o.getId()+"-content");r.write(">");this.renderLIContent(r,o);r.write('</div>');};
b.render=function(r,o){if(!o.getVisible()){this.renderInvisible(r,o);return false;}this.openItemTag(r,o);r.writeControlData(o);r.addClass("sapMLIB");r.addClass("sapMLIB-CTX");r.addClass("sapMLIBShowSeparator");r.addClass("sapMLIBType"+o.getType());if(D.system.desktop&&o.isActionable()){r.addClass("sapMLIBActionable");r.addClass("sapMLIBHoverable");}if(o.getSelected()){r.addClass("sapMLIBSelected");}if(o.getListProperty("showUnread")&&o.getUnread()){r.addClass("sapMLIBUnread");}this.addFocusableClasses(r,o);this.renderTooltip(r,o);this.renderTabIndex(r,o);if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAccessibilityState(o,this.getAccessibilityState(o));}this.renderLIAttributes(r,o);r.writeClasses();r.writeStyles();r.write(">");this.renderContentFormer(r,o);this.renderLIContentWrapper(r,o);this.renderContentLatter(r,o);this.closeItemTag(r,o);};
return b;},true);
sap.ui.predefine('sap/m/ListRenderer',["sap/ui/core/Renderer","./ListBaseRenderer"],function(R,L){"use strict";var a=R.extend(L);return a;},true);
sap.ui.predefine('sap/m/MaskEnabler',['sap/ui/core/Control','./InputBase','sap/ui/Device','sap/ui/core/library',"sap/ui/events/KeyCodes","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/cursorPos"],function(C,I,D,c,K,L,q){"use strict";var T=c.TextDirection;var M=function(){var E='^';this.init=M.init=function(){I.prototype.init.call(this);this._iCaretTimeoutId=null;this._iUserInputStartPosition=null;this._iMaskLength=null;this._sOldInputValue=null;this._oRules=null;this._oTempValue=null;this._bSkipSetupMaskVariables=null;this._setDefaultRules();this._setupMaskVariables();};this.exit=M.exit=function(){this._iCaretTimeoutId=null;this._iUserInputStartPosition=null;this._iMaskLength=null;this._sOldInputValue=null;this._oRules=null;this._oTempValue=null;this._bSkipSetupMaskVariables=null;};this.onBeforeRendering=function(){if(this._isMaskEnabled()){var v=this._validateDependencies();if(v){L.warning("Invalid mask input: "+v);}}I.prototype.onBeforeRendering.apply(this,arguments);};this.onAfterRendering=function(){I.prototype.onAfterRendering.apply(this,arguments);};this.onfocusin=M.onfocusin=function(e){this._sOldInputValue=this._getInputValue();I.prototype.onfocusin.apply(this,arguments);if(this._isMaskEnabled()){if(!this._oTempValue.differsFromOriginal()||!this._isValidInput(this._sOldInputValue)){this._applyMask();}this._positionCaret(true);}};this.onfocusout=function(e){if(this._isMaskEnabled()){this.bFocusoutDueRendering=this.bRenderingPhase;this.$().toggleClass("sapMFocus",false);q(document).off('.sapMIBtouchstart');if(this.bRenderingPhase){return;}this.closeValueStateMessage();this._inputCompletedHandler();}else{this._inputCompletedHandlerNoMask();I.prototype.onfocusout.apply(this,arguments);}};this.oninput=function(e){if(this._isChromeOnAndroid()){this._onInputForAndroidHandler(e);return;}I.prototype.oninput.apply(this,arguments);if(this._isMaskEnabled()){this._applyMask();this._positionCaret(false);}};this.onkeypress=function(e){if(this._isMaskEnabled()){this._keyPressHandler(e);}};this.onkeydown=M.onkeydown=function(e){if(this._isMaskEnabled()){var k=this._parseKeyBoardEvent(e);I.prototype.onkeydown.apply(this,arguments);this._keyDownHandler(e,k);}else{var k=this._parseKeyBoardEvent(e);if(k.bEnter){this._inputCompletedHandlerNoMask();}I.prototype.onkeydown.apply(this,arguments);}};this.onsapenter=function(e){};this.onsapfocusleave=function(e){};this.setValue=M.setValue=function(v){v=this.validateProperty('value',v);I.prototype.setValue.call(this,v);this._sOldInputValue=v;if(this._isMaskEnabled()){if(!this._oTempValue){this._setupMaskVariables();}if(this._oTempValue._aInitial.join('')!==v){this._applyRules(v);}}return this;};this.addAggregation=function(A,o,s){if(A==="rules"){if(!this._validateRegexAgainstPlaceHolderSymbol(o)){return this;}this._removeRuleWithSymbol(o.getMaskFormatSymbol());C.prototype.addAggregation.apply(this,arguments);if(!this._bSkipSetupMaskVariables){this._setupMaskVariables();}return this;}return C.prototype.addAggregation.apply(this,arguments);};this.insertAggregation=function(A,o,i,s){if(A==="rules"){if(!this._validateRegexAgainstPlaceHolderSymbol(o)){return this;}this._removeRuleWithSymbol(o.getMaskFormatSymbol());C.prototype.insertAggregation.apply(this,arguments);this._setupMaskVariables();return this;}return C.prototype.insertAggregation.apply(this,arguments);};this._validateRegexAgainstPlaceHolderSymbol=function(r){if(new RegExp(r.getRegex()).test(this.getPlaceholderSymbol())){L.error("Rejecting input mask rule because it includes the currently set placeholder symbol.");return false;}return true;};this.setPlaceholderSymbol=function(s){var S;if(!/^.$/i.test(s)){L.error("Invalid placeholder symbol string given");return this;}S=this.getRules().some(function(r){return new RegExp(r.getRegex()).test(s);});if(S){L.error("Rejecting placeholder symbol because it is included as a regex in an existing mask input rule.");}else{this.setProperty("placeholderSymbol",s);this._setupMaskVariables();}return this;};this.setMask=function(m){if(!m){var e="Setting an empty mask is pointless. Make sure you set it with a non-empty value.";L.warning(e);return this;}this.setProperty("mask",m,true);this._setupMaskVariables();return this;};this._isCharAllowed=function(s,i){return this._oRules.applyCharAt(s,i);};this._feedReplaceChar=function(s,p,d){return s;};this._inputCompletedHandlerNoMask=function(){var v=this._getInputValue();if(this._sOldInputValue!==v){I.prototype.setValue.call(this,this._getAlteredUserInputValue?this._getAlteredUserInputValue(v):v);this._sOldInputValue=v;if(this.onChange&&!this.onChange({value:v})){this.fireChangeEvent(v);}}};var a=function(d){this._aInitial=d.slice(0);this._aContent=d;};a.prototype.setCharAt=function(s,p){this._aContent[p]=s;};a.prototype.charAt=function(p){return this._aContent[p];};a.prototype.toString=function(){return this._aContent.join('');};a.prototype.differsFromOriginal=function(){return this.differsFrom(this._aInitial);};a.prototype.differsFrom=function(v){var i=0;if(v.length!==this._aContent.length){return true;}for(;i<v.length;i++){if(v[i]!==this._aContent[i]){return true;}}return false;};a.prototype.getSize=function(){return this._aContent.length;};var b=function(r){this._aRules=r;};b.prototype.nextTo=function(i){if(typeof i==="undefined"){i=-1;}do{i++;}while(i<this._aRules.length&&!this._aRules[i]);return i;};b.prototype.previousTo=function(i){do{i--;}while(!this._aRules[i]&&i>0);return i;};b.prototype.hasRuleAt=function(i){return!!this._aRules[i];};b.prototype.applyCharAt=function(s,i){return this._aRules[i].test(s);};this._setDefaultRules=function(){this._bSkipSetupMaskVariables=true;this.addRule(new sap.m.MaskInputRule({maskFormatSymbol:"a",regex:"[A-Za-z]"}),true);this.addRule(new sap.m.MaskInputRule({maskFormatSymbol:"9",regex:"[0-9]"}),true);this._bSkipSetupMaskVariables=false;};this._validateDependencies=function(){var p=this.getPlaceholderSymbol(),r=this.getRules(),m=[],e=[];if(!this.getMask()){e.push("Empty mask");}if(r.length){m=[];r.every(function(R){var s=R.getMaskFormatSymbol(),d=s!==p,f;f=!m.some(function(S){return s===S;});m.push(s);if(!d){e.push("Placeholder symbol is the  same as the existing rule's mask format symbol");}if(!f){e.push("Duplicated rule's maskFormatSymbol ["+s+"]");}return d&&f;});}return e.length?e.join(". "):null;};this._removeRuleWithSymbol=function(s){var S=this._findRuleBySymbol(s,this.getRules());if(S){this.removeAggregation('rules',S.oRule);S.oRule.destroy();}};this._findRuleBySymbol=function(m,r){var R=null;if(typeof m!=="string"||m.length!==1){L.error(m+" is not a valid mask rule symbol");return null;}q.each(r,function(i,o){if(o.getMaskFormatSymbol()===m){R={oRule:o,iIndex:i};return false;}});return R;};this._getTextSelection=function(){var _=q(this.getFocusDomRef());if(!_&&(_.length===0||_.is(":hidden"))){return{};}return{iFrom:_[0].selectionStart,iTo:_[0].selectionEnd,bHasSelection:(_[0].selectionEnd-_[0].selectionStart!==0)};};this._setCursorPosition=function(p){if(p<0){p=0;}q(this.getFocusDomRef()).cursorPos(p);return this;};this._getCursorPosition=function(){return q(this.getFocusDomRef()).cursorPos();};this._setupMaskVariables=function(){var r=this.getRules(),m=this.getMask(),s=this._getSkipIndexes(m),d=this._getMaskArray(m,s),p=this.getPlaceholderSymbol(),i=this._buildMaskValueArray(d,p,r,s),t=this._buildRules(d,r,s);this._oTempValue=new a(i);this._iMaskLength=t.length;this._oRules=new b(t);this._iUserInputStartPosition=this._oRules.nextTo();};this._getMaskArray=function(m,s){var l=Array.isArray(s)?s.length:0,d=(m)?m.split(""):[],i;for(i=0;i<l;i++){d.splice(s[i],1);}return d;};this._getSkipIndexes=function(m){var l=(m)?m.length:0,i,s=[],p=0,d=false;for(i=0;i<l;i++){if(m[i]===E&&!d){s.push(i-p);d=true;p++;}else{d=false;}}return s;};this._applyMask=function(){var m=this._getInputValue();if(!this.getEditable()){return;}this._applyAndUpdate(m);};this._resetTempValue=function(f,t){var i,p=this.getPlaceholderSymbol();if(typeof f==="undefined"||f===null){f=0;t=this._oTempValue.getSize()-1;}for(i=f;i<=t;i++){if(this._oRules.hasRuleAt(i)){this._oTempValue.setCharAt(p,i);}}};this._applyAndUpdate=function(m){this._applyRules(m);this.updateDomValue(this._oTempValue.toString());};this._findFirstPlaceholderPosition=function(){return this._oTempValue.toString().indexOf(this.getPlaceholderSymbol());};this._applyRules=function(i){var s,d=0,m,p=this.getPlaceholderSymbol(),e;if(this._oTempValue.toString()===i){return;}for(m=0;m<this._iMaskLength;m++){if(this._oRules.hasRuleAt(m)){this._oTempValue.setCharAt(p,m);e=false;if(i.length){do{s=i.charAt(d);d++;if(this._oRules.applyCharAt(s,m)){this._oTempValue.setCharAt(s,m);e=true;}}while(!e&&(d<i.length));}if(!e){this._resetTempValue(m+1,this._iMaskLength-1);break;}}else{if(this._oTempValue.charAt(m)===i.charAt(d)){d++;}}}};this._keyPressHandler=function(e,k){var s,p,d;if(!this.getEditable()){return;}k=k||this._parseKeyBoardEvent(e);if(k.bCtrlKey||k.bAltKey||k.bMetaKey||k.bBeforeSpace){return;}s=this._getTextSelection();if(!k.bEnter&&!k.bShiftLeftOrRightArrow&&!k.bHome&&!k.bEnd&&!(k.bShift&&k.bDelete)&&!(k.bCtrlKey&&k.bInsert)&&!(k.bShift&&k.bInsert)){if(s.bHasSelection){this._resetTempValue(s.iFrom,s.iTo-1);this.updateDomValue(this._oTempValue.toString());this._setCursorPosition(Math.max(this._iUserInputStartPosition,s.iFrom));}p=this._oRules.nextTo(s.iFrom-1);if(p<this._iMaskLength){d=this._feedReplaceChar(k.sChar,p,this._getInputValue());this._feedNextString(d,p);}e.preventDefault();}};this.oncut=function(e){var s=this._getTextSelection(),m=this._getMinBrowserDelay(),B=s.iFrom,i=s.iTo;I.prototype.oncut(e);if(!s.bHasSelection||!this._isMaskEnabled()){return;}i=i-1;this._resetTempValue(B,i);setTimeout(function updateDomAndCursor(v,p,o){this._oTempValue._aContent=o;this.updateDomValue(v);setTimeout(this._setCursorPosition.bind(this,p),m);}.bind(this,this._oTempValue.toString(),Math.max(this._iUserInputStartPosition,B),this._oTempValue._aContent.slice(0)),m);};this._keyDownHandler=function(e,k){var d,s,i,n,k=k||this._parseKeyBoardEvent(e);if(!this.getEditable()){return;}if(!k.bShift&&(k.bArrowRight||k.bArrowLeft)){i=this._getCursorPosition();s=this._getTextSelection();d=this._determineArrowKeyDirection(k,s);if(this._isRtlMode()&&s.bHasSelection){n=this._determineRtlCaretPositionFromSelection(d);}else{n=this._oRules[d](i);}if(this._isWebkitProblematicCase()){n=this._fixWebkitBorderPositions(n,d);}this._setCursorPosition(n);e.preventDefault();}else if(k.bEscape){this._applyAndUpdate(this._sOldInputValue);this._positionCaret(true);e.preventDefault();}else if(k.bEnter){this._inputCompletedHandler(e);}else if((k.bCtrlKey&&k.bInsert)||(k.bShift&&k.bInsert)){I.prototype.onkeydown.apply(this,arguments);}else if((!k.bShift&&k.bDelete)||k.bBackspace){this._revertKey(k);e.preventDefault();}else if(this._isChromeOnAndroid()){this._oKeyDownStateAndroid={sValue:this._oTempValue.toString(),iCursorPosition:this._getCursorPosition(),oSelection:this._getTextSelection()};}};this._revertKey=function(k,s){s=s||this._getTextSelection();var B=s.iFrom,e=s.iTo;if(!s.bHasSelection){if(k.bBackspace){B=this._oRules.previousTo(B);}}if(k.bBackspace||(k.bDelete&&s.bHasSelection)){e=e-1;}this._resetTempValue(B,e);this.updateDomValue(this._oTempValue.toString());this._setCursorPosition(Math.max(this._iUserInputStartPosition,B));};this._feedNextString=function(n,p){var N,A=false,d=n.split(""),s;while(d.length){s=d.splice(0,1)[0];if(this._oRules.applyCharAt(s,p)){A=true;this._oTempValue.setCharAt(s,p);p=this._oRules.nextTo(p);}}if(A){N=p;this.updateDomValue(this._oTempValue.toString());this._setCursorPosition(N);}};this._inputCompletedHandler=function(){var n=this._getInputValue(),t,v,e,d;if(this._oTempValue.differsFrom(n)){this._applyAndUpdate(n);}t=this._oTempValue.differsFromOriginal();v=t?this._oTempValue.toString():"";e=!this._sOldInputValue||!this.getValue();d=!n;if(e&&(d||!t)){this.updateDomValue("");return;}if(this._sOldInputValue!==this._oTempValue.toString()){I.prototype.setValue.call(this,this._getAlteredUserInputValue?this._getAlteredUserInputValue(v):v);this._sOldInputValue=v;if(this.onChange&&!this.onChange({value:v})){this.fireChangeEvent(v);}}};this._buildMaskValueArray=function(m,p,r,s){return m.map(function(d,i){var n=s.indexOf(i)===-1,R=this._findRuleBySymbol(d,r);return(n&&R)?p:d;},this);};this._buildRules=function(m,r,s){var t=[],S,l=m.length,i=0;for(;i<l;i++){if(s.indexOf(i)===-1){S=this._findRuleBySymbol(m[i],r);t.push(S?new RegExp(S.oRule.getRegex()):null);}else{t.push(null);}}return t;};this._parseKeyBoardEvent=function(e){var p=e.which||e.keyCode,k=K,A=p===k.ARROW_RIGHT,d=p===k.ARROW_LEFT,s=e.shiftKey;return{iCode:p,sChar:String.fromCharCode(p),bCtrlKey:e.ctrlKey,bAltKey:e.altKey,bMetaKey:e.metaKey,bShift:s,bInsert:p===K.INSERT,bBackspace:p===k.BACKSPACE,bDelete:p===k.DELETE,bEscape:p===k.ESCAPE,bEnter:p===k.ENTER,bIphoneEscape:(D.system.phone&&D.os.ios&&p===127),bArrowRight:A,bArrowLeft:d,bHome:p===K.HOME,bEnd:p===K.END,bShiftLeftOrRightArrow:s&&(d||A),bBeforeSpace:p<k.SPACE};};this._positionCaret=function(s){var m=this.getMask(),i=this._getMinBrowserDelay(),e;clearTimeout(this._iCaretTimeoutId);e=this._findFirstPlaceholderPosition();if(e<0){e=m.length;}this._iCaretTimeoutId=setTimeout(function(){if(this.getFocusDomRef()!==document.activeElement){return;}if(s&&(e===(m.length))){this.selectText(0,e);}else{this._setCursorPosition(e);}}.bind(this),i);};this._getMinBrowserDelay=function(){return!D.browser.msie?4:50;};this._isValidInput=function(s){var l=s.length,i=0,d;for(;i<l;i++){d=s[i];if(this._oRules.hasRuleAt(i)&&(!this._oRules.applyCharAt(d,i)&&d!==this.getPlaceholderSymbol())){return false;}if(!this._oRules.hasRuleAt(i)&&d!==this._oTempValue.charAt(i)){return false;}}return true;};this._isRtlChar=function(s){var l='A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02B8\u0300-\u0590\u0800-\u1FFF'+'\u2C00-\uFB1C\uFDFE-\uFE6F\uFEFD-\uFFFF',r='\u0591-\u07FF\uFB1D-\uFDFD\uFE70-\uFEFC',d=new RegExp('^[^'+l+']*['+r+']');return d.test(s);};this._fixWebkitBorderPositions=function(i,d){var t=this._oTempValue.toString().length;if(d==='nextTo'){if(i===0||i===t||i===1){i=0;}else if(i===t+1){i=1;}}else{if(i===0||i===t-1){i=t;}else if(i===-1||i===t){i=t-1;}}return i;};this._containsRtlChars=function(){var t=this._oTempValue.toString(),d=false;for(var i=0;i<t.length;i++){d=this._isRtlChar(t[i]);}return d;};this._isRtlMode=function(){return sap.ui.getCore().getConfiguration().getRTL()||(this.getTextDirection()===T.RTL);};this._isWebkitProblematicCase=function(){return D.browser.webkit&&this._isRtlMode()&&!this._containsRtlChars();};this._determineArrowKeyDirection=function(k,s){var d;if(!this._isRtlMode()||!this._containsRtlChars()||s.bHasSelection){if(k.bArrowRight){d='nextTo';}else{d='previousTo';}}else{if(k.bArrowRight){d='previousTo';}else{d='nextTo';}}return d;};this._determineRtlCaretPositionFromSelection=function(d,w){var n,s=this._getTextSelection();if(w){if(d==='nextTo'){if(!this._containsRtlChars()){n=s.iFrom;}else{n=s.iTo;}}else{if(!this._containsRtlChars()){n=s.iTo;}else{n=s.iFrom;}}}else{if(d==='nextTo'){if(!this._containsRtlChars()){n=s.iTo;}else{n=s.iFrom;}}else{if(!this._containsRtlChars()){n=s.iFrom;}else{n=s.iTo;}}}return n;};this._onInputForAndroidHandler=function(e){var k;if(!this._oKeyDownStateAndroid){return;}k=this._buildKeyboardEventInfo(this._oKeyDownStateAndroid.sValue,this._getInputValue(),this._oKeyDownStateAndroid.oSelection);this.updateDomValue(this._oKeyDownStateAndroid.sValue);setTimeout(function(i,o,d){this._setCursorPosition(o.iCursorPosition);if(d.bBackspace){this._revertKey(d,o.oSelection);if(o.oSelection.bHasSelection&&d.sChar){this._keyPressHandler(i,d);}}else{this._keyPressHandler(i,d);}}.bind(this,e,this._oKeyDownStateAndroid,k),0);delete this._oKeyDownStateAndroid;e.preventDefault();};this._buildKeyboardEventInfo=function(o,n,O){var N="",i,r={},d;if(!o&&!n){return{};}if(o&&n&&n.length<o.length){r.bBackspace=true;}for(i=0;i<n.length;i++){d=O.bHasSelection&&O.iFrom===i;if(d||o[i]!==n[i]){N=n[i];break;}}r.sChar=N;return r;};this._isChromeOnAndroid=function(){return D.browser.chrome&&D.os.android;};};return M;},true);
sap.ui.predefine('sap/m/MaskInput',['./InputBase','./MaskEnabler','./MaskInputRenderer'],function(I,M,a){"use strict";
var b=I.extend("sap.m.MaskInput",{metadata:{library:"sap.m",properties:{placeholderSymbol:{type:"string",group:"Misc",defaultValue:"_"},mask:{type:"string",group:"Misc",defaultValue:null}},aggregations:{rules:{type:"sap.m.MaskInputRule",multiple:true,singularName:"rule"}},dnd:{draggable:false,droppable:true}}});
M.call(b.prototype);
b.prototype._isMaskEnabled=function(){return true;};
return b;});
sap.ui.predefine('sap/m/MaskInputRenderer',['sap/ui/core/Renderer','./InputBaseRenderer'],function(R,I){"use strict";var M=R.extend(I);
M.getLabelledByAnnouncement=function(c){var m=c.getMask(),p=c.getPlaceholder()||"",t=c.getTooltip_AsString()||"",r,s,a="";if(m&&m.length){r=sap.ui.getCore().getLibraryResourceBundle("sap.m");s=r.getText("MASKINPUT_SCREENREADER_TAG");if(t){t=" "+t+" ";}if(p){p=" "+p+" ";}a=s+p+t;return a;}return I.getLabelledByAnnouncement.apply(this,arguments);};
M.getDescribedByAnnouncement=function(c){var m=c.getMask(),s=c.getPlaceholderSymbol(),r,a="";if(m.length&&s){r=sap.ui.getCore().getLibraryResourceBundle("sap.m");a=r.getText("MASKINPUT_SCREENREADER_DESCRIPTION",[s,m]);return jQuery.trim(a);}return I.getDescribedByAnnouncement.apply(this,arguments);};
return M;},true);
sap.ui.predefine('sap/m/MaskInputRule',['sap/ui/core/Element',"sap/base/Log"],function(E,L){"use strict";
var M=E.extend("sap.m.MaskInputRule",{metadata:{library:"sap.m",properties:{maskFormatSymbol:{type:"string",group:"Misc",defaultValue:"*"},regex:{type:"string",group:"Misc",defaultValue:"[a-zA-Z0-9]"}}}});
M.prototype.setMaskFormatSymbol=function(n){var i=v.call(this,n);if(i){this.setProperty("maskFormatSymbol",n);}return this;};
M.prototype.setRegex=function(n){var i=a.call(this,n);if(i){this.setProperty("regex",n);}return this;};
M.prototype.toString=function(){return this.getMaskFormatSymbol()+":"+this.getRegex();};
function v(n){if(/^.$/i.test(n)){return true;}L.error("The mask format symbol '"+n+"' is not valid");return false;}
function a(r){if(/.+/i.test(r)){return true;}L.error("The regex value '"+r+"' is not valid");return false;}
return M;});
sap.ui.predefine('sap/m/Menu',['./library','sap/ui/core/Control','./Button','./Dialog','./NavContainer','./List','./Page','./MenuListItem','sap/ui/unified/Menu','sap/ui/unified/MenuItem','sap/ui/Device','sap/ui/core/EnabledPropagator','sap/ui/core/CustomData',"sap/ui/thirdparty/jquery"],function(l,C,B,D,N,L,P,M,U,a,b,E,c,q){"use strict";var d=l.ListType;var e=l.ListMode;
var f=C.extend("sap.m.Menu",{metadata:{interfaces:["sap.ui.core.IContextMenu"],library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MenuItem",multiple:true,singularName:"item",bindable:"bindable"},_dialog:{type:"sap.m.Dialog",multiple:false,visibility:"hidden"},_menu:{type:"sap.ui.unified.Menu",multiple:false,visibility:"hidden"}},events:{itemSelected:{parameters:{item:{type:"sap.m.MenuItem"}}},closed:{}}}});
E.call(f.prototype);f.UNIFIED_MENU_ITEMS_ID_SUFFIX='-unifiedmenu';f.UNFIFIED_MENU_ITEMS_PROPS=a.getMetadata().getAllProperties();f.LIST_ITEMS_ID_SUFFIX='-menuinnerlist';f.MENU_LIST_ITEMS_PROPS=M.getMetadata().getAllProperties();
f.prototype.init=function(){if(b.system.phone){this._initDialog();}this._bIsInitialized=false;};
f.prototype.exit=function(){if(this._navContainerId){this._navContainerId=null;}if(this._bIsInitialized){this._bIsInitialized=null;}if(this._getMenu()&&this._getMenu().getPopup()){this._getMenu().getPopup().detachClosed(this._menuClosed,this);}};
f.prototype.invalidate=function(){};
f.prototype.setTitle=function(t){var n=this._getNavContainer();this.setProperty("title",t,true);if(n&&n.getPages().length){n.getPages()[0].setTitle(t);}return this;};
f.prototype.openBy=function(o,w,s,i,O){if(b.system.phone){this._openDialog();}else{if(!this._bIsInitialized){this._initAllMenuItems();this._bIsInitialized=true;}var j=sap.ui.core.Popup.Dock;if(!s){s=j.BeginTop;}if(!i){i=j.BeginBottom;}if(!O){O="0 -2";}this._getMenu().open(w,o,s,i,o,O);}};
f.prototype.close=function(){if(b.system.phone){this._getDialog().close();}else{this._getVisualParent().close();}};
f.prototype._initDialog=function(){var o=new D({showHeader:false,stretch:true,content:this._initNavContainer(),buttons:[this._initCloseButton()]});o.addStyleClass("sapMRespMenuDialog");o.removeStyleClass("sapUiPopupWithPadding");this.setAggregation("_dialog",o,true);};
f.prototype._getDialog=function(){return this.getAggregation("_dialog");};
f.prototype._openDialog=function(){if(!this._bIsInitialized){this._initAllPages();this._bIsInitialized=true;}this._getNavContainer().to(this._getNavContainer().getPages()[0]);this._getDialog().open();};
f.prototype._initAllMenuItems=function(){this._initMenuForItems(this.getItems());};
f.prototype._setCustomEnhanceAccStateFunction=function(i){this._fnEnhanceUnifiedMenuAccState=i;};
f.prototype._initMenuForItems=function(i,p){var m=new U();m._setCustomEnhanceAccStateFunction(this._fnEnhanceUnifiedMenuAccState);m.isCozy=this._isMenuCozy.bind(this,m);this.addStyleClass('sapMMenu');m.aCustomStyleClasses=this.aCustomStyleClasses;m.mCustomStyleClassMap=this.mCustomStyleClassMap;i.forEach(function(I){this._addVisualMenuItemFromItem(I,m);}.bind(this));if(p){p.setSubmenu(m);}else{m.getPopup().attachClosed(this._menuClosed,this);this.setAggregation('_menu',m,true);}m.attachItemSelect(this._handleMenuItemSelect,this);};
f.prototype._menuClosed=function(){this.fireClosed();};
f.prototype._getMenu=function(){return this.getAggregation("_menu");};
f.prototype._initCloseButton=function(){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");return new B({text:r.getText("MENU_CLOSE"),press:g.bind(this)});};
function g(){this._getDialog().close();}
f.prototype._initNavContainer=function(){var n=new N();this._navContainerId=n.getId();return n;};
f.prototype._getNavContainer=function(){return sap.ui.getCore().byId(this._navContainerId);};
f.prototype._initAllPages=function(){this._initPageForParent(this);};
f.prototype._initPageForParent=function(p){var i=p.getItems(),j=p instanceof f,s=j?p.getTitle():p.getText(),o=new L({mode:e.None}),k=new P({title:s,showNavButton:!j,content:o});if(!j){this._setBackButtonTooltipForPageWithParent(p,k);}k.attachNavButtonPress(function(){this._getNavContainer().back();},this);this._getNavContainer().addPage(k);i.forEach(function(I){this._addListItemFromItem(I,k);},this);this._updateListInset(o);o.attachEvent("itemPress",this._handleListItemPress,this);return k;};
f.prototype._handleListItemPress=function(o){var i=o.getParameter("listItem"),m=sap.ui.getCore().byId(i.getMenuItem()),p=m._getVisualChild();if(p){this._getNavContainer().to(p);}else{this._getDialog().close();this.fireItemSelected({item:m});}m.firePress();};
f.prototype._setBackButtonTooltipForPageWithParent=function(p,o){var i=p.getParent(),r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),s;s=i instanceof f?i.getTitle():i.getText();s=r.getText("MENU_PAGE_BACK_BUTTON")+" "+s;o.setNavButtonTooltip(s);};
f.prototype._createMenuListItemFromItem=function(i){return new M({id:this._generateListItemId(i.getId()),type:d.Active,icon:i.getIcon(),title:i.getText(),startsSection:i.getStartsSection(),menuItem:i,tooltip:i.getTooltip(),visible:i.getVisible()});};
f.prototype._createVisualMenuItemFromItem=function(i){var u=new a({id:this._generateUnifiedMenuItemId(i.getId()),icon:i.getIcon(),text:i.getText(),startsSection:i.getStartsSection(),tooltip:i.getTooltip(),visible:i.getVisible(),enabled:i.getEnabled()}),j=i.getCustomData();j.forEach(function(o){u.addCustomData(new c({key:o.getKey(),value:o.getValue()}));});return u;};
f.prototype._addVisualMenuItemFromItem=function(i,m,I){var o=this._createVisualMenuItemFromItem(i);i._setVisualParent(m);i._setVisualControl(o);var j=['aggregationChanged','propertyChanged'];j.forEach(function(s){var k='_on'+s.slice(0,1).toUpperCase()+s.slice(1);i.attachEvent(s,this[k],this);},this);if(i.getItems().length!==0){this._initMenuForItems(i.getItems(),o);i._setVisualChild(i.getItems()[0]._getVisualParent());}if(I===undefined){m.addItem(o);}else{m.insertItem(o,I);}};
f.prototype._addListItemFromItem=function(i,p,I){var m=this._createMenuListItemFromItem(i),o=p.getContent()[0];i._setVisualParent(p);i._setVisualControl(m);var j=['aggregationChanged','propertyChanged'];j.forEach(function(s){var k='_on'+s.slice(0,1).toUpperCase()+s.slice(1);i.attachEvent(s,this[k],this);},this);if(i.getItems().length!==0){this._initPageForParent(i);i._setVisualChild(i.getItems()[0]._getVisualParent());}if(I===undefined){o.addItem(m);}else{o.insertItem(m,I);}o.rerender();};
f.prototype._connectVisualItem=function(i,o,I){if(!o||sap.ui.getCore().byId(i._getVisualControl())){return;}if(b.system.phone){this._addListItemFromItem(i,o,I);var j=o.getContent()[0];this._updateListInset(j);}else{this._addVisualMenuItemFromItem(i,o,I);}};
f.prototype._updateListInset=function(o){var H=false,I="sapMListIcons",j=o.getItems();for(var i=0;i<j.length;i++){if(j[i].getIcon()){H=true;break;}}if(H){o.addStyleClass(I);}else{o.removeStyleClass(I);}};
f.prototype._handleMenuItemSelect=function(o){var u=o.getParameter("item"),m;if(!u){return;}m=this._findMenuItemByUnfdMenuItem(u);if(m&&!m.getItems().length){this.fireItemSelected({item:m});}if(m){m.firePress();}};
f.prototype._generateListItemId=function(m){return m+f.LIST_ITEMS_ID_SUFFIX;};
f.prototype._generateUnifiedMenuItemId=function(m){return m+f.UNIFIED_MENU_ITEMS_ID_SUFFIX;};
f.prototype._findMenuItemByUnfdMenuItem=function(u){var j=[],o=u,I,k,i;do{j.push(o.getId());o=o.getParent().getParent();}while(o instanceof a);I=this.getItems();do{k=j.pop();for(i=0;i<I.length;i++){if(I[i]._getVisualControl()===k){if(j.length===0){return I[i];}else{I=I[i].getItems();break;}}}}while(j.length);return null;};
f.prototype._isMenuCozy=function(m){if(!m.bCozySupported){return false;}if(m.hasStyleClass("sapUiSizeCozy")){return true;}if(h(m.oOpenerRef)){return true;}return false;};
function h(r){if(!r){return false;}r=r.$?r.$():q(r);var $=r.closest(".sapUiSizeCompact,.sapUiSizeCondensed,.sapUiSizeCozy");return(!$.hasClass("sapUiSizeCompact")&&!$.hasClass("sapUiSizeCondensed"))||$.hasClass("sapUiSizeCozy");}
f.prototype.addAggregation=function(A,o,s){C.prototype.addAggregation.apply(this,arguments);if(A==="items"){this._connectVisualItem(o,this._getVisualParent());}return this;};
f.prototype.insertAggregation=function(A,o,i,s){C.prototype.insertAggregation.apply(this,arguments);if(A==="items"){this._connectVisualItem(o,this._getVisualParent(),i);}return this;};
f.prototype.removeAggregation=function(A,o,s){var i=C.prototype.removeAggregation.apply(this,arguments);if(A==="items"){this._removeVisualItem(i);}return i;};
f.prototype.removeAllAggregation=function(A,s){var I=C.prototype.removeAllAggregation.apply(this,arguments);if(A==="items"){for(var i=0;i<I.length;i++){this._removeVisualItem(I[i]);}}return I;};
f.prototype._removeVisualItem=function(i,p){var v=sap.ui.getCore().byId(i._getVisualControl()),m;if(v){m=v.getParent();m.removeItem(v);if(b.system.phone){this._removeSubPageForItem(i);if(m.getItems().length===0){if(p){p._setVisualChild(null);sap.ui.getCore().byId(p._getVisualControl()).rerender();}}if(m){m.rerender();}}}};
f.prototype.destroyAggregation=function(A,s){if(A==="items"){for(var i=0;i<this.getItems().length;i++){this._removeVisualItem(this.getItems()[i]);}}return C.prototype.destroyAggregation.apply(this,arguments);};
f.prototype._removeSubPageForItem=function(I,s){var S;if(!s){for(var i=0;i<I.getItems().length;i++){this._removeSubPageForItem(I.getItems()[i]);}}if(I._getVisualChild()){S=sap.ui.getCore().byId(I._getVisualChild());if(this._getNavContainer()&&S){this._getNavContainer().removePage(S);}!!S&&S.destroy();}};
f.prototype._getVisualParent=function(){var n=this._getNavContainer(),m=this._getMenu();if(n&&n.getPages().length){return n.getPages()[0];}else{return m;}};
f.prototype._onPropertyChanged=function(o){var p=o.getParameter("propertyKey"),i=o.getParameter("propertyValue"),t=b.system.phone?f.MENU_LIST_ITEMS_PROPS:f.UNFIFIED_MENU_ITEMS_PROPS,G=b.system.phone?this._generateListItemId:this._generateUnifiedMenuItemId,T;if(b.system.phone&&p==='text'){p='title';}if(!t[p]){return;}T=G(o.getSource().getId());if(T){sap.ui.getCore().byId(T).setProperty(p,i);if(b.system.phone&&this._getDialog().isOpen()){this._getDialog().close();}}};
f.prototype._onAggregationChanged=function(o){var A=o.getParameter("aggregationName");switch(A){case'items':this._onItemsAggregationChanged(o);break;}};
f.prototype._onItemsAggregationChanged=function(o){var I=o.getSource(),m=o.getParameter("methodName"),j=o.getParameter("methodParams"),k;if(m==="add"||m==="insert"){if(m==="insert"){k=j.index;}this._addOrInsertItem(I,j.item,k);}if(m==="remove"){this._removeVisualItem(j.item,I);}if(m==="removeall"){for(var i=0;i<j.items.length;i++){this._removeVisualItem(j.items[i],I);}}if(m==="destroy"){this._destroyItem(I);}};
f.prototype._addOrInsertItem=function(p,n,i){var o;if(p._getVisualChild()){this._connectVisualItem(n,sap.ui.getCore().byId(p._getVisualChild()),i);}else{if(b.system.phone){this._initPageForParent(p);p._setVisualChild(p.getItems()[0]._getVisualParent());o=sap.ui.getCore().byId(p._getVisualControl());o.rerender();}else{this._initMenuForItems(p.getItems(),sap.ui.getCore().byId(p._getVisualControl()));p._setVisualChild(p.getItems()[0]._getVisualParent());}}};
f.prototype._destroyItem=function(i){var v=sap.ui.getCore().byId(i._getVisualControl());if(v&&v.setMenuItem){v.setMenuItem(null);}this._removeSubPageForItem(i,true);i._setVisualChild(null);if(v&&v.setMenuItem){v.rerender();v.setMenuItem(i);}};
f.prototype.getDomRefId=function(){if(b.system.phone){return this._getDialog().getId();}else{return this._getMenu().getId();}};
f.prototype.openAsContextMenu=function(o,O){if(b.system.phone){this._openDialog();}else{if(!this._bIsInitialized){this._initAllMenuItems();this._bIsInitialized=true;}this._getMenu().openAsContextMenu(o,O);}};
["addStyleClass","removeStyleClass","toggleStyleClass"].forEach(function(m){f.prototype[m]=function(s,S){var o=this._getDialog();C.prototype[m].apply(this,arguments);if(o){o[m].apply(o,arguments);}return this;};});return f;});
sap.ui.predefine('sap/m/MenuButton',['./library','sap/ui/core/Control','./Button','./SplitButton','sap/ui/Device','sap/ui/core/EnabledPropagator','sap/ui/core/library','sap/ui/core/Popup','sap/ui/core/LabelEnablement','sap/m/Menu',"./MenuButtonRenderer"],function(l,C,B,S,D,E,c,P,L,M,a){"use strict";var b=l.MenuButtonMode;var T=c.TextDirection;var d=l.ButtonType;var e=P.Dock;var n=["buttonMode","useDefaultActionOnly","width","menuPosition"];
var f=C.extend("sap.m.MenuButton",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:null},type:{type:"sap.m.ButtonType",group:"Appearance",defaultValue:d.Default},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},activeIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},buttonMode:{type:"sap.m.MenuButtonMode",group:"Misc",defaultValue:b.Regular},menuPosition:{type:"sap.ui.core.Popup.Dock",group:"Misc",defaultValue:e.BeginBottom},useDefaultActionOnly:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{menu:{type:"sap.m.Menu",multiple:false,singularName:"menu"},_button:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{defaultAction:{}},defaultAggregation:"menu",designtime:"sap/m/designtime/MenuButton.designtime",dnd:{draggable:true,droppable:false}}});
E.call(f.prototype);
f.prototype.init=function(){this._initButtonControl();};
f.prototype.exit=function(){if(this._sDefaultText){this._sDefaultText=null;}if(this._sDefaultIcon){this._sDefaultIcon=null;}if(this._iInitialTextBtnContentWidth){this._iInitialTextBtnContentWidth=null;}if(this._lastActionItemId){this._lastActionItemId=null;}if(this.getMenu()){this.getMenu().detachClosed(this._menuClosed,this);}};
f.prototype.onBeforeRendering=function(){if(!this._sDefaultText){this._sDefaultText=this.getText();}if(!this._sDefaultIcon){this._sDefaultIcon=this.getIcon();}this._updateButtonControl();this._attachMenuEvents();};
f.prototype._needsWidth=function(){return this._isSplitButton()&&this.getWidth()==="";};
f.prototype._getTextBtnContentDomRef=function(){return this._getButtonControl()._getTextButton().getDomRef("content");};
f.prototype.onAfterRendering=function(){if(this._needsWidth()&&sap.ui.getCore().isThemeApplied()&&this._getTextBtnContentDomRef()&&this._getInitialTextBtnWidth()>0){this._getTextBtnContentDomRef().style.width=this._getInitialTextBtnWidth()+'px';}this._setAriaHasPopup();};
f.prototype.onThemeChanged=function(o){if(this._needsWidth()&&this.getDomRef()&&!this._iInitialTextBtnContentWidth&&this._getTextBtnContentDomRef()&&this._getInitialTextBtnWidth()>0){this._getTextBtnContentDomRef().style.width=this._getInitialTextBtnWidth()+'px';}};
f.prototype._getInitialTextBtnWidth=function(){if(!this._iInitialTextBtnContentWidth){this._iInitialTextBtnContentWidth=Math.ceil(this._getTextBtnContentDomRef().getBoundingClientRect().width);}return this._iInitialTextBtnContentWidth;};
f.prototype._setAriaHasPopup=function(){if(this._isSplitButton()){this._getButtonControl()._getArrowButton().$().attr("aria-haspopup","true");}else{this._getButtonControl().$().attr("aria-haspopup","true");}};
f.prototype.setButtonMode=function(m){var t=this.getTooltip();C.prototype.setProperty.call(this,"buttonMode",m,true);this._getButtonControl().destroy();this._initButtonControl();for(var k in this.mProperties){if(this.mProperties.hasOwnProperty(k)&&n.indexOf(k)<0){this._getButtonControl().setProperty(k,this.mProperties[k],true);}}if(t){this._getButtonControl().setTooltip(t);}if(!this._isSplitButton()&&this._sDefaultText){this.setText(this._sDefaultText);}else if(!this.getUseDefaultActionOnly()&&this._getLastSelectedItem()){this.setText(sap.ui.getCore().byId(this._getLastSelectedItem()).getText());}if(!this._isSplitButton()&&this._sDefaultIcon){this.setIcon(this._sDefaultIcon);}else if(!this.getUseDefaultActionOnly()&&this._getLastSelectedItem()){this.setIcon(sap.ui.getCore().byId(this._getLastSelectedItem()).getIcon());}this.invalidate();return this;};
f.prototype._initButton=function(){var o=new B(this.getId()+"-internalBtn",{width:"100%"});o.attachPress(this._handleButtonPress,this);return o;};
f.prototype._initSplitButton=function(){var o=new S(this.getId()+"-internalSplitBtn",{width:"100%"});o.attachPress(this._handleActionPress,this);o.attachArrowPress(this._handleButtonPress,this);return o;};
f.prototype._initButtonControl=function(){var o;if(this._isSplitButton()){o=this._initSplitButton();}else{o=this._initButton();}this.setAggregation("_button",o,true);};
f.prototype._updateButtonControl=function(){this._getButtonControl().setText(this.getText());};
f.prototype._getButtonControl=function(){return this.getAggregation("_button");};
f.prototype._handleButtonPress=function(w){var m=this.getMenu(),o={zero:"0 0",plus2_right:"0 +2",minus2_right:"0 -2",plus2_left:"+2 0",minus2_left:"-2 0"};if(this._bPopupOpen){this.getMenu().close();return;}if(!m){return;}if(!m.getTitle()){m.setTitle(this.getText());}var p=[this,w];switch(this.getMenuPosition()){case e.BeginTop:p.push(e.BeginBottom,e.BeginTop,o.plus2_right);break;case e.BeginCenter:p.push(e.BeginCenter,e.BeginCenter,o.zero);break;case e.LeftTop:p.push(e.RightBottom,e.LeftBottom,o.plus2_left);break;case e.LeftCenter:p.push(e.RightCenter,e.LeftCenter,o.plus2_left);break;case e.LeftBottom:p.push(e.RightTop,e.LeftTop,o.plus2_left);break;case e.CenterTop:p.push(e.CenterBottom,e.CenterTop,o.plus2_left);break;case e.CenterCenter:p.push(e.CenterCenter,e.CenterCenter,o.zero);break;case e.CenterBottom:p.push(e.CenterTop,e.CenterBottom,o.minus2_right);break;case e.RightTop:p.push(e.LeftBottom,e.RightBottom,o.minus2_left);break;case e.RightCenter:p.push(e.LeftCenter,e.RightCenter,o.minus2_left);break;case e.RightBottom:p.push(e.LeftTop,e.RightTop,o.minus2_left);break;case e.EndTop:p.push(e.EndBottom,e.EndTop,o.plus2_right);break;case e.EndCenter:p.push(e.EndCenter,e.EndCenter,o.zero);break;case e.EndBottom:p.push(e.EndTop,e.EndBottom,o.minus2_right);break;default:case e.BeginBottom:p.push(e.BeginTop,e.BeginBottom,o.minus2_right);break;}M.prototype.openBy.apply(m,p);this._writeAriaAttributes();if(this._isSplitButton()&&!D.system.phone){this._getButtonControl().setArrowState(true);}};
f.prototype._handleActionPress=function(){var s=this._getLastSelectedItem(),o;if(!this.getUseDefaultActionOnly()&&s){o=sap.ui.getCore().byId(s);this.getMenu().fireItemSelected({item:o});}else{this.fireDefaultAction();}};
f.prototype._menuClosed=function(){if(this._isSplitButton()){this._getButtonControl().setArrowState(false);}this.$().removeAttr("aria-controls");};
f.prototype._menuItemSelected=function(o){var m=o.getParameter("item");this.fireEvent("_menuItemSelected",{item:m});this._bPopupOpen=false;if(!this._isSplitButton()||this.getUseDefaultActionOnly()||!m){return;}this._lastActionItemId=m.getId();!!this._sDefaultText&&this.setText(m.getText());!!this._sDefaultIcon&&this.setIcon(m.getIcon());};
f.prototype._getLastSelectedItem=function(){return this._lastActionItemId;};
f.prototype._attachMenuEvents=function(){if(this.getMenu()){this.getMenu().attachClosed(this._menuClosed,this);this.getMenu().attachItemSelected(this._menuItemSelected,this);}};
f.prototype._isSplitButton=function(){return this.getButtonMode()===b.Split;};
f.prototype.setProperty=function(p,v,s){function i(t){var g=[d.Up,d.Back,d.Unstyled];return g.indexOf(t)!==-1;}if(p==="type"&&i(v)){return this;}if(p==='text'){this._sDefaultText=v;}switch(p){case'activeIcon':case'iconDensityAware':case'textDirection':case'enabled':this._getButtonControl().setProperty(p,v);break;}return C.prototype.setProperty.apply(this,arguments);};
f.prototype.setTooltip=function(t){this._getButtonControl().setTooltip(t);return C.prototype.setTooltip.apply(this,arguments);};
f.prototype.setText=function(v){B.prototype.setProperty.call(this,'text',v);this._getButtonControl().setText(v);return this;};
f.prototype.setType=function(v){B.prototype.setProperty.call(this,'type',v);this._getButtonControl().setType(v);return this;};
f.prototype.setIcon=function(v){B.prototype.setProperty.call(this,'icon',v);this._getButtonControl().setIcon(v);return this;};
f.prototype.getFocusDomRef=function(){return this._getButtonControl().getDomRef();};
f.prototype.onsapup=function(o){this.openMenuByKeyboard();};
f.prototype.onsapdown=function(o){this.openMenuByKeyboard();};
f.prototype.onsapupmodifiers=function(o){this.openMenuByKeyboard();};
f.prototype.onsapdownmodifiers=function(o){this.openMenuByKeyboard();};
f.prototype.onsapshow=function(o){this.openMenuByKeyboard();!!o&&o.preventDefault();};
f.prototype.ontouchstart=function(){this._bPopupOpen=this.getMenu()&&this.getMenu()._getMenu()&&this.getMenu()._getMenu().getPopup().isOpen();};
f.prototype.openMenuByKeyboard=function(){if(!this._isSplitButton()){this._handleButtonPress(true);}};
f.prototype._writeAriaAttributes=function(){if(this.getMenu()){this.$().attr("aria-controls",this.getMenu().getDomRefId());}};
f.prototype.getIdForLabel=function(){return this.getId()+"-internalBtn";};
f.prototype._ensureBackwardsReference=function(){var i=this._getButtonControl(),I=i.getAriaLabelledBy(),r=L.getReferencingLabels(this);r.forEach(function(s){if(I&&I.indexOf(s)===-1){i.addAriaLabelledBy(s);}});return this;};
return f;});
sap.ui.predefine('sap/m/MenuButtonRenderer',[],function(){"use strict";var M={};M.CSS_CLASS="sapMMenuBtn";
M.render=function(r,m){var w=m.getWidth();r.write("<div");r.writeControlData(m);r.addClass(M.CSS_CLASS);r.addClass(M.CSS_CLASS+m.getButtonMode());r.writeClasses();if(w!=""){r.addStyle("width",w);}r.writeStyles();r.write(">");m._ensureBackwardsReference();r.renderControl(m._getButtonControl());r.write("</div>");};
return M;},true);
sap.ui.predefine('sap/m/MenuItem',['./library','sap/ui/core/Item'],function(l,I){"use strict";
var M=I.extend("sap.m.MenuItem",{metadata:{library:"sap.m",properties:{icon:{type:"string",group:"Appearance",defaultValue:null},visible:{type:"boolean",group:"Appearance",defaultValue:true},startsSection:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MenuItem",multiple:true,singularName:"item",bindable:"bindable"}},events:{press:{},propertyChanged:{parameters:{propertyKey:{type:"string"},propertyValue:{type:"any"}}},aggregationChanged:{parameters:{aggregationName:{type:"String"},methodName:{type:"String"},methodParams:{type:"Object"}}}}}});
M.prototype.exit=function(){if(this._sVisualChild){this._sVisualChild=null;}if(this._sVisualParent){this._sVisualParent=null;}if(this._sVisualControl){this._sVisualControl=null;}};
M.prototype.setProperty=function(p,P){I.prototype.setProperty.apply(this,arguments);this.fireEvent("propertyChanged",{propertyKey:p,propertyValue:P});};
M.prototype.addAggregation=function(a,o,s){I.prototype.addAggregation.apply(this,arguments);this.fireEvent("aggregationChanged",{aggregationName:a,methodName:"add",methodParams:{item:o}});return this;};
M.prototype.insertAggregation=function(a,o,i,s){I.prototype.insertAggregation.apply(this,arguments);this.fireEvent("aggregationChanged",{aggregationName:a,methodName:"insert",methodParams:{item:o,index:i}});return this;};
M.prototype.removeAggregation=function(a,o,s){var O=I.prototype.removeAggregation.apply(this,arguments);this.fireEvent("aggregationChanged",{aggregationName:a,methodName:"remove",methodParams:{item:O}});return O;};
M.prototype.removeAllAggregation=function(a,s){var o=I.prototype.removeAllAggregation.apply(this,arguments);this.fireEvent("aggregationChanged",{aggregationName:a,methodName:"removeall",methodParams:{items:o}});return o;};
M.prototype.destroyAggregation=function(a,s){this.fireEvent("aggregationChanged",{aggregationName:a,methodName:"destroy"});return I.prototype.destroyAggregation.apply(this,arguments);};
M.prototype.destroy=function(){var v=sap.ui.getCore().byId(this._getVisualControl());if(v){v.destroy();}return I.prototype.destroy.apply(this,arguments);};
M.prototype._setVisualChild=function(c){this._setInternalRef(c,"_sVisualChild");};
M.prototype._setVisualParent=function(c){this._setInternalRef(c,"_sVisualParent");};
M.prototype._setVisualControl=function(c){this._setInternalRef(c,"_sVisualControl");};
M.prototype._setInternalRef=function(c,i){if(!c||typeof c==="string"){this[i]=c;}else if(c.getId){this[i]=c.getId();}};
M.prototype._getVisualChild=function(){return this._sVisualChild;};
M.prototype._getVisualParent=function(){return this._sVisualParent;};
M.prototype._getVisualControl=function(){return this._sVisualControl;};
return M;});
sap.ui.predefine('sap/m/MenuListItem',['./ListItemBase','./library','sap/ui/core/IconPool','sap/ui/core/library','./MenuListItemRenderer'],function(L,l,I,c,M){"use strict";var T=c.TextDirection;
var a=L.extend("sap.m.MenuListItem",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},titleTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},startsSection:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{menuItem:{type:"sap.m.MenuItem",multiple:false}}}});
a.prototype.exit=function(){if(this._image){this._image.destroy();}if(this._imageRightArrow){this._imageRightArrow.destroy();}L.prototype.exit.apply(this,arguments);};
a.prototype._getImage=function(i,s,S,b){var o=this._image;if(o){o.setSrc(S);if(o instanceof sap.m.Image){o.setDensityAware(b);}}else{o=I.createControlByURI({id:i,src:S,densityAware:b,useIconTooltip:false},sap.m.Image).setParent(this,null,true);}if(o instanceof sap.m.Image){o.addStyleClass(s,true);}else{o.addStyleClass(s+"Icon",true);}this._image=o;return this._image;};
a.prototype._getIconArrowRight=function(){if(!this._imageRightArrow){this._imageRightArrow=I.createControlByURI({id:this.getId()+"-arrowRight",src:"sap-icon://slim-arrow-right",useIconTooltip:false},sap.m.Image).setParent(this,null,true);this._imageRightArrow.addStyleClass("sapMMenuLIArrowRightIcon",true);}return this._imageRightArrow;};
a.prototype._hasSubItems=function(){return!!(this.getMenuItem()&&sap.ui.getCore().byId(this.getMenuItem()).getItems().length);};
return a;});
sap.ui.predefine('sap/m/MenuListItemRenderer',['./ListItemBaseRenderer','sap/ui/core/Renderer','sap/m/library','sap/ui/core/library'],function(L,R,l,c){"use strict";var T=c.TextDirection;var a=l.ListType;var M=R.extend(L);
M.openItemTag=function(r,o){if(o.getStartsSection()){r.write("<li ");r.write("role=\"separator\" ");r.write("class=\"sapUiMnuDiv\"><div class=\"sapUiMnuDivL\"></div><hr><div class=\"sapUiMnuDivR\"></div></li>");}L.openItemTag(r,o);};
M.renderLIAttributes=function(r,o){r.addClass("sapMSLI");if(o.getIcon()){r.addClass("sapMSLIIcon");}if(o.getType()==a.Detail||o.getType()==a.DetailAndActive){r.addClass("sapMSLIDetail");}if(o._hasSubItems()){r.addClass("sapMMenuLIHasChildren");}};
M.renderLIContent=function(r,o){var t=o.getTitleTextDirection();if(o.getIcon()){r.renderControl(o._getImage((o.getId()+"-img"),"sapMMenuLIImgThumb",o.getIcon(),o.getIconDensityAware()));}r.write("<div");r.addClass("sapMSLIDiv");r.addClass("sapMSLITitleDiv");r.writeClasses();r.write(">");if(o._bNoFlex){r.write('<div class="sapMLIBNoFlex">');}r.write("<div");r.addClass("sapMSLITitleOnly");r.writeClasses();if(t!==T.Inherit){r.writeAttribute("dir",t.toLowerCase());}r.write(">");r.writeEscaped(o.getTitle());r.write("</div>");if(o._bNoFlex){r.write('</div>');}r.write("</div>");if(o._hasSubItems()){r.renderControl(o._getIconArrowRight());}};
return M;},true);
sap.ui.predefine('sap/m/MessageBox',['./Button','./Dialog','./Text','./FormattedText','./Link','./VBox','sap/ui/core/IconPool','sap/ui/core/ElementMetadata','sap/ui/core/library','sap/ui/core/Control','sap/m/library',"sap/ui/thirdparty/jquery",'sap/ui/core/theming/Parameters'],function(B,D,T,F,L,V,I,E,c,C,l,q,P){"use strict";var a=l.DialogType;var b=c.TextDirection;var M={};M.Action={OK:"OK",CANCEL:"CANCEL",YES:"YES",NO:"NO",ABORT:"ABORT",RETRY:"RETRY",IGNORE:"IGNORE",CLOSE:"CLOSE",DELETE:"DELETE"};M.Icon={NONE:undefined,INFORMATION:"INFORMATION",WARNING:"WARNING",ERROR:"ERROR",SUCCESS:"SUCCESS",QUESTION:"QUESTION"};(function(){var A=M.Action,d=M.Icon,e=P.get("_sap_m_Message_Box_Information_Icon")==="true",s=e?"message-information":"hint",m={"INFORMATION":"sapMMessageBoxInfo","WARNING":"sapMMessageBoxWarning","ERROR":"sapMMessageBoxError","SUCCESS":"sapMMessageBoxSuccess","QUESTION":"sapMMessageBoxQuestion","STANDARD":"sapMMessageBoxStandard"},f={"INFORMATION":I.getIconURI(s),"WARNING":I.getIconURI("message-warning"),"ERROR":I.getIconURI("message-error"),"SUCCESS":I.getIconURI("message-success"),"QUESTION":I.getIconURI("question-mark")};var _=function(){if(M._rb!==sap.ui.getCore().getLibraryResourceBundle("sap.m")){M._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");}};
M.show=function(v,o){var g,h,j,r=null,k=[],i,n,t,p,u,w,x,y={id:E.uid("mbox"),initialFocus:null,textDirection:b.Inherit,verticalScrolling:true,horizontalScrolling:true,details:"",contentWidth:null};_();if(typeof o==="string"||arguments.length>2){n=arguments[1];t=arguments[2];p=arguments[3];u=arguments[4];w=arguments[5];x=arguments[6];o={icon:n,title:t,actions:p,onClose:u,id:w,styleClass:x};}if(o&&o.hasOwnProperty("details")){y.icon=d.INFORMATION;y.actions=[A.OK,A.CANCEL];o=q.extend({},y,o);}o=q.extend({},y,o);if(typeof o.actions!=="undefined"&&!Array.isArray(o.actions)){o.actions=[o.actions];}if(!o.actions||o.actions.length===0){o.actions=[A.OK];}function z(N){var O;if(M.Action.hasOwnProperty(N)){O=M._rb.getText("MSGBOX_"+N);}var Q=new B({id:E.uid("mbox-btn-"),text:O||N,press:function(){r=N;g.close();}});return Q;}for(i=0;i<o.actions.length;i++){k.push(z(o.actions[i]));}function G(o,h){var N,S,O=new V({items:[h]});if(!o.details){return O;}if(typeof o.details=='object'){o.details="<pre>"+JSON.stringify(o.details,null,'\t').replace(/{/gi,"\\{")+"</pre>";}N=new F().setVisible(false).setHtmlText(o.details);S=new L({text:M._rb.getText("MSGBOX_LINK_TITLE"),press:function(){var Q=g.getInitialFocus();g.addAriaLabelledBy(N);N.setVisible(true);S.setVisible(false);if(Q&&Q!==S.getId()){g._setInitialFocus();}else{k[0].focus();}}});S.addStyleClass("sapMMessageBoxLinkText");N.addStyleClass("sapMMessageBoxDetails");O.addItem(S);O.addItem(N);return O;}function H(){if(typeof o.onClose==="function"){o.onClose(r);}g.detachAfterClose(H);g.destroy();}function J(){var i=0;var N=null;if(o.initialFocus){if(o.initialFocus instanceof C){N=o.initialFocus;}if(typeof o.initialFocus==="string"){for(i=0;i<k.length;i++){if(M.Action.hasOwnProperty(o.initialFocus)){if(M._rb.getText("MSGBOX_"+o.initialFocus).toLowerCase()===k[i].getText().toLowerCase()){N=k[i];break;}}else{if(o.initialFocus.toLowerCase()===k[i].getText().toLowerCase()){N=k[i];break;}}}}}return N;}if(typeof(v)==="string"){j=new T({textDirection:o.textDirection}).setText(v).addStyleClass("sapMMsgBoxText");h=j;}else if(v instanceof C){j=v.addStyleClass("sapMMsgBoxText");}if(o&&o.hasOwnProperty("details")&&o.details!==""){j=G(o,j);}function K(){if(sap.ui.getCore().getConfiguration().getAccessibility()){g.$().attr("role","alertdialog");}}g=new D({id:o.id,type:a.Message,title:o.title,content:j,icon:f[o.icon],initialFocus:J(),verticalScrolling:o.verticalScrolling,horizontalScrolling:o.horizontalScrolling,afterOpen:K,afterClose:H,buttons:k,ariaLabelledBy:h?h.getId():undefined,contentWidth:o.contentWidth});if(m[o.icon]){g.addStyleClass(m[o.icon]);}else{g.addStyleClass(m.STANDARD);}if(o.styleClass){g.addStyleClass(o.styleClass);}g.open();};
M.alert=function(v,o){_();var g={icon:d.NONE,title:M._rb.getText("MSGBOX_TITLE_ALERT"),actions:A.OK,id:E.uid("alert"),initialFocus:null},h,t,i,S;if(typeof o==="function"||arguments.length>2){h=arguments[1];t=arguments[2];i=arguments[3];S=arguments[4];o={onClose:h,title:t,id:i,styleClass:S};}o=q.extend({},g,o);return M.show(v,o);};
M.confirm=function(v,o){_();var g={icon:d.QUESTION,title:M._rb.getText("MSGBOX_TITLE_CONFIRM"),actions:[A.OK,A.CANCEL],id:E.uid("confirm"),initialFocus:null},h,t,i,S;if(typeof o==="function"||arguments.length>2){h=arguments[1];t=arguments[2];i=arguments[3];S=arguments[4];o={onClose:h,title:t,id:i,styleClass:S};}o=q.extend({},g,o);return M.show(v,o);};
M.error=function(v,o){_();var g={icon:d.ERROR,title:M._rb.getText("MSGBOX_TITLE_ERROR"),actions:[A.CLOSE],id:E.uid("error"),initialFocus:null};o=q.extend({},g,o);return M.show(v,o);};
M.information=function(v,o){_();var g={icon:d.INFORMATION,title:M._rb.getText("MSGBOX_TITLE_INFO"),actions:[A.OK],id:E.uid("info"),initialFocus:null};o=q.extend({},g,o);return M.show(v,o);};
M.warning=function(v,o){_();var g={icon:d.WARNING,title:M._rb.getText("MSGBOX_TITLE_WARNING"),actions:[A.OK],id:E.uid("warning"),initialFocus:null};o=q.extend({},g,o);return M.show(v,o);};
M.success=function(v,o){_();var g={icon:d.SUCCESS,title:M._rb.getText("MSGBOX_TITLE_SUCCESS"),actions:[A.OK],id:E.uid("success"),initialFocus:null};o=q.extend({},g,o);return M.show(v,o);};
}());return M;},true);
sap.ui.predefine('sap/m/MessageItem',["./library","sap/ui/core/Item","sap/ui/core/library","sap/base/Log","sap/base/security/sanitizeHTML"],function(l,I,c,L,s){"use strict";var M=c.MessageType;
var a=I.extend("sap.m.MessageItem",{metadata:{library:"sap.m",properties:{type:{type:"sap.ui.core.MessageType",group:"Appearance",defaultValue:M.Error},title:{type:"string",group:"Appearance",defaultValue:""},subtitle:{type:"string",group:"Misc",defaultValue:null},description:{type:"string",group:"Appearance",defaultValue:""},markupDescription:{type:"boolean",group:"Appearance",defaultValue:false},longtextUrl:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:null},counter:{type:"int",group:"Misc",defaultValue:null},groupName:{type:"string",group:"Misc",defaultValue:""},activeTitle:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"link",aggregations:{link:{type:"sap.m.Link",multiple:false,singularName:"link"}}}});
a.prototype.setProperty=function(p,v,S){var P=this.getParent(),t=this.getType().toLowerCase(),b=["description","type","groupName"],u=function(n,i){if(i._oMessagePopoverItem.getId()===this.getId()&&i.getMetadata().getProperty(n)){i.setProperty(n,v);}};if(b.indexOf(p)===-1&&P&&("_bItemsChanged"in P)&&!P._bItemsChanged){P._oLists&&P._oLists.all&&P._oLists.all.getItems&&P._oLists.all.getItems().forEach(u.bind(this,p));P._oLists&&P._oLists[t]&&P._oLists[t].getItems&&P._oLists[t].getItems().forEach(u.bind(this,p));}if(typeof this._updatePropertiesFn==="function"){this._updatePropertiesFn();}return I.prototype.setProperty.apply(this,arguments);};
a.prototype._updateProperties=function(b){this._updatePropertiesFn=b;};
a.prototype.setDescription=function(d){if(typeof d==='undefined'){d='';}if(this.getMarkupDescription()){d=s(d);}this.setProperty("description",d,true);return this;};
a.prototype.setType=function(t){if(t===M.None){t=M.Information;L.warning("The provided None type is handled and rendered as Information type");}return this.setProperty("type",t,true);};
return a;});
sap.ui.predefine('sap/m/MessageListItem',["sap/ui/core/library","sap/ui/core/InvisibleText","./library",'./StandardListItem','./Link',"./MessageListItemRenderer"],function(c,I,l,S,L,M){"use strict";var a=c.MessageType;
var b=S.extend("sap.m.MessageListItem",{metadata:{library:"sap.m",properties:{activeTitle:{type:"boolean",group:"Misc",defaultValue:false},messageType:{type:"sap.ui.core.MessageType",group:"Appearance",defaultValue:a.Error}},aggregations:{link:{type:"sap.m.Link",group:"Misc",multiple:false},linkAriaDescribedBy:{type:"sap.ui.core.Control",group:"Misc",multiple:false}},events:{activeTitlePress:{}}}});
b.prototype.setActiveTitle=function(A){this.setProperty("activeTitle",A);var o=this.getLink();if(!o&&A){o=new L({press:[this.fireActiveTitlePress,this]});this.setLink(o);}return this;};
b.prototype.onBeforeRendering=function(){S.prototype.onBeforeRendering.apply(this,arguments);var o=this.getLink(),d;if(!o){return;}if(!o.getAriaDescribedBy().length){d=this._getLinkAriaDescribedBy();o.setProperty("text",this.getTitle(),true);o.addAssociation('ariaDescribedBy',d.getId(),true);this.setAggregation("linkAriaDescribedBy",d,true);}};
b.prototype._getLinkAriaDescribedBy=function(){var A=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("MESSAGE_VIEW_LINK_FOCUS_TEXT",[this.getMessageType()]);return new I(this.getId()+"-link",{text:A});};
b.prototype.onkeydown=function(e){if(this.getActiveTitle()&&e.altKey&&e.key==='Enter'){this.fireActiveTitlePress(this);}};
b.prototype.getContentAnnouncement=function(B){var A=S.prototype.getContentAnnouncement.apply(this,arguments),s,m;if(this.getActiveTitle()){m=B.getText("MESSAGEVIEW_BUTTON_TOOLTIP_"+this.getMessageType().toUpperCase());s=B.getText("MESSAGE_LIST_ITEM_FOCUS_TEXT",[m]);A+=" ".concat(s);}return A;};
return b;});
sap.ui.predefine('sap/m/MessageListItemRenderer',["./StandardListItemRenderer","sap/ui/core/Renderer"],function(S,R){"use strict";var M=R.extend(S);
M.renderTitle=function(r,c){if(c.getActiveTitle()){r.renderControl(c.getLink());r.renderControl(c.getLinkAriaDescribedBy());}else{S.renderTitle.apply(this,arguments);}};
return M;},true);
sap.ui.predefine('sap/m/MessagePage',['./library','sap/ui/core/library','sap/ui/core/Control','sap/ui/core/IconPool','sap/m/Text','sap/m/Image','sap/m/Button','sap/m/Title','sap/m/FormattedText','./MessagePageRenderer',"sap/ui/thirdparty/jquery"],function(l,c,C,I,T,a,B,b,F,M,q){"use strict";var d=c.TextAlign;var e=c.TextDirection;var f=l.ButtonType;var g=l.BarDesign;
var h=C.extend("sap.m.MessagePage",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:"No matching items found."},description:{type:"string",group:"Misc",defaultValue:"Check the filter settings."},title:{type:"string",group:"Misc",defaultValue:null},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},showNavButton:{type:"boolean",group:"Appearance",defaultValue:false},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:"sap-icon://documents"},iconAlt:{type:"string",group:"Misc",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:e.Inherit},enableFormattedText:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{customText:{type:"sap.m.Link",multiple:false},customDescription:{type:"sap.m.Link",multiple:false},buttons:{type:"sap.m.Button",multiple:true},_internalHeader:{type:"sap.m.Bar",multiple:false,visibility:"hidden"},_formattedText:{type:"sap.m.FormattedText",multiple:false,visibility:"hidden"},_text:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_description:{type:"sap.m.Text",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{navButtonPress:{}},designtime:"sap/m/designtime/MessagePage.designtime"}});
h.prototype.init=function(){var o=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oTitle=null;this._oNavButton=new B(this.getId()+"-navButton",{type:f.Back,press:q.proxy(function(){this.fireNavButtonPress();},this)});this.setAggregation("_internalHeader",new sap.m.Bar(this.getId()+"-intHeader",{design:g.Header}));this.setProperty("text",o.getText("MESSAGE_PAGE_TEXT"),true);this.setProperty("description",o.getText("MESSAGE_PAGE_DESCRIPTION"),true);};
h.prototype.exit=function(){if(this._oNavButton){this._oNavButton.destroy();this._oNavButton=null;}if(this._oIconControl){this._oIconControl.destroy();this._oIconControl=null;}};
h.prototype.setTitle=function(t){this.setProperty("title",t,true);if(!this._oTitle){this._oTitle=new b(this.getId()+"-title");this._getInternalHeader().addContentMiddle(this._oTitle);}this._oTitle.setText(t);return this;};
h.prototype.setText=function(t){this.setProperty("text",t,true);var o=this.getAggregation("_text");o&&o.setText(t);return this;};
h.prototype.setDescription=function(D){this.setProperty("description",D,true);var o=this.getAggregation("_formattedText"),i=this.getAggregation("_description");o&&o.setHtmlText(D);i&&i.setText(D);return this;};
h.prototype.setShowNavButton=function(s){this.setProperty("showNavButton",s,true);var H=this._getInternalHeader();if(s){H.addContentLeft(this._oNavButton);}else{H.removeAllContentLeft();}return this;};
h.prototype.setTextDirection=function(t){this.setProperty("textDirection",t,true);var D=this.getDomRef();if(D){if(t===e.Inherit){D.removeAttribute("dir");}else{D.dir=t.toLowerCase();}}return this;};
h.prototype.setIcon=function(i){var v=this.getIcon()||"";i=i||"";if(v!==i){var s=!!v&&!!i&&I.isIconURI(i)===I.isIconURI(v);this.setProperty("icon",i,s);if(s&&this._oIconControl){this._oIconControl.setSrc(i);}}return this;};
h.prototype.setEnableFormattedText=function(E){var o;if(E){o=this._getFormattedText();o.setHtmlText(this.getDescription());}return this.setProperty("enableFormattedText",E);};
h.prototype._getIconControl=function(){if(this._oIconControl){this._oIconControl.destroy();this._oIconControl=null;}this._oIconControl=I.createControlByURI({id:this.getId()+"-pageIcon",src:this.getIcon(),height:"8rem",width:"8rem",useIconTooltip:true,decorative:false,alt:this.getIconAlt()},a).addStyleClass("sapMMessagePageIcon");return this._oIconControl;};
h.prototype._getText=function(){if(this.getAggregation("customText")){return this.getAggregation("customText");}if(!this.getAggregation("_text")){var t=new T(this.getId()+"-text",{id:this.getId()+"-customText",text:this.getText(),textAlign:d.Center,textDirection:this.getTextDirection()});this.setAggregation("_text",t);}return this.getAggregation("_text");};
h.prototype._getDescription=function(){if(this.getAggregation("customDescription")){return this.getAggregation("customDescription");}if(this.getEnableFormattedText()){return this._getFormattedText();}if(!this.getAggregation("_description")){var D=new T(this.getId()+"-description",{id:this.getId()+"-customDescription",text:this.getDescription(),textAlign:d.Center,textDirection:this.getTextDirection()});this.setAggregation("_description",D);}return this.getAggregation("_description");};
h.prototype._getAnyHeader=function(){return this._getInternalHeader();};
h.prototype._getInternalHeader=function(){return this.getAggregation("_internalHeader");};
h.prototype._getFormattedText=function(){var o=this.getAggregation("_formattedText");if(!o){o=new F(this.getId()+"-formattedText");this.setAggregation("_formattedText",o);}return o;};
return h;});
sap.ui.predefine('sap/m/MessagePageRenderer',['sap/ui/core/library'],function(c){"use strict";var T=c.TextDirection;var M={};
M.render=function(r,m){this.startOpeningDiv(r,m);this.renderHeader(r,m);this.startInnerDivs(r);this.renderContent(r,m);this.endInnerDivs(r);this.endOpeningDiv(r);};
M.startOpeningDiv=function(r,m){r.write("<div");r.writeControlData(m);r.addClass("sapMMessagePage");r.writeClasses();if(m.getTextDirection()!=T.Inherit){r.writeAttribute("dir",m.getTextDirection().toLowerCase());}r.write(">");};
M.renderHeader=function(r,m){if(m.getShowHeader()){r.renderControl(m.getAggregation("_internalHeader"));}};
M.startInnerDivs=function(r){r.write("<div");r.addClass("sapMMessagePageInner");r.writeClasses();r.write(">");r.write("<div");r.addClass("sapMMessagePageContentWrapper");r.writeClasses();r.write(">");};
M.renderContent=function(r,m){if(m.getIcon()){r.renderControl(m._getIconControl());}r.renderControl(m._getText().addStyleClass("sapMMessagePageMainText"));r.renderControl(m._getDescription().addStyleClass("sapMMessagePageDescription"));this.renderButtons(r,m);};
M.renderButtons=function(r,m){var b=m.getButtons();if(b.length>0){r.write("<div");r.addClass("sapMMessagePageButtonsWrapper");r.writeClasses();r.write(">");for(var i=0;i<b.length;i++){r.renderControl(b[i]);}r.write("</div>");}};
M.endInnerDivs=function(r){r.write("</div>");r.write("</div>");};
M.endOpeningDiv=function(r){r.write("</div>");};
return M;},true);
sap.ui.predefine('sap/m/MessagePopover',["./ResponsivePopover","./Button","./Toolbar","./Bar","sap/ui/core/Control","sap/ui/core/IconPool","./semantic/SemanticPage","./Popover","./MessageView","sap/ui/Device","./MessagePopoverRenderer","sap/base/Log","sap/ui/thirdparty/jquery"],function(R,B,T,a,C,I,S,P,M,D,b,L,q){"use strict";
var c=C.extend("sap.m.MessagePopover",{metadata:{library:"sap.m",properties:{asyncDescriptionHandler:{type:"any",group:"Behavior",defaultValue:null},asyncURLHandler:{type:"any",group:"Behavior",defaultValue:null},placement:{type:"sap.m.VerticalPlacementType",group:"Behavior",defaultValue:"Vertical"},initiallyExpanded:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MessageItem",altTypes:["sap.m.MessagePopoverItem"],multiple:true,singularName:"item"},headerButton:{type:"sap.m.Button",multiple:false,forwarding:{idSuffix:"-messageView",aggregation:"headerButton"}}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},afterClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},itemSelect:{parameters:{item:{type:"sap.m.MessagePopoverItem"},messageTypeFilter:{type:"sap.ui.core.MessageType"}}},listSelect:{parameters:{messageTypeFilter:{type:"sap.ui.core.MessageType"}}},longtextLoaded:{},urlValidated:{},activeTitlePress:{parameters:{item:{type:"sap.m.MessageItem"}}}}}});
function d(n){return n.charAt(0).toUpperCase()+n.slice(1);}
var e="sapMMsgPopover",f="320px",g="440px",h={back:I.getIconURI("nav-back"),close:I.getIconURI("decline"),information:I.getIconURI("message-information"),warning:I.getIconURI("message-warning"),error:I.getIconURI("message-error"),success:I.getIconURI("message-success")},A=["asyncDescriptionHandler","asyncURLHandler"],i={asyncDescriptionHandler:function(j){var l=j.item.getLongtextUrl();if(l){q.ajax({type:"GET",url:l,success:function(k){j.item.setDescription(k);j.promise.resolve();},error:function(){var E="A request has failed for long text data. URL: "+l;L.error(E);j.promise.reject(E);}});}}};
c.setDefaultHandlers=function(m){A.forEach(function(F){if(m.hasOwnProperty(F)){i[F]=m[F];}});};
c.prototype.init=function(){var t=this;var p;this._oOpenByControl=null;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oMessageView=this._initMessageView();this._oMessageView.addEventDelegate({onBeforeRendering:function(){var s=t._oMessageView._oSegmentedButton.getVisible(),j=!t.getInitiallyExpanded()||s;t._oMessageView._oSegmentedButton.setVisible(j);t._oMessageView._listPage.setShowHeader(true);}});this._insertCloseBtn(this._oMessageView._oListHeader);this._insertCloseBtn(this._oMessageView._oDetailsHeader);this._oMessageView._oSegmentedButton.attachEvent("select",this._onSegButtonSelect,this);this._oPopover=new R(this.getId()+"-messagePopover",{showHeader:false,contentWidth:g,contentHeight:f,placement:this.getPlacement(),showCloseButton:false,verticalScrolling:false,horizontalScrolling:false,modal:false,afterOpen:function(E){t.fireAfterOpen({openBy:E.getParameter("openBy")});},afterClose:function(E){t._oMessageView._navContainer.backToTop();t.fireAfterClose({openBy:E.getParameter("openBy")});},beforeOpen:function(E){t.fireBeforeOpen({openBy:E.getParameter("openBy")});},beforeClose:function(E){t.fireBeforeClose({openBy:E.getParameter("openBy")});}}).addStyleClass(e);this._oPopover.addContent(this._oMessageView);this._oPopover.addAssociation("ariaLabelledBy",this.getId()+"-messageView-HeadingDescr",true);p=this._oPopover.getAggregation("_popup");p.oPopup.setAutoClose(false);p.addEventDelegate({onBeforeRendering:this.onBeforeRenderingPopover,onAfterRendering:this.onAfterRenderingPopover},this);if(D.system.phone){this._oPopover.setBeginButton(new B({text:this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE"),press:this.close.bind(this)}));}A.forEach(function(F){if(i.hasOwnProperty(F)){this['set'+d(F)](i[F]);}},this);};
c.prototype.onBeforeRendering=function(){if(this.getDependents().indexOf(this._oPopover)===-1){this.addDependent(this._oPopover);}};
c.prototype.onBeforeRenderingPopover=function(){if(this._bItemsChanged){var j=this.getItems();var t=this;this._oMessageView.destroyItems();j.forEach(function(k){k._updateProperties(function(){t._bItemsChanged=true;});this._oMessageView.addItem(k.clone("","",{cloneChildren:true,cloneBinding:true}));},this);this._bItemsChanged=false;}this._setInitialFocus();if(this._oOpenByControl&&!this._oOpenByControl.getVisible()){this._oPopover.close();}};
c.prototype.onAfterRenderingPopover=function(){if(this._oPopover._oControl._sFocusControlId){this._oPopover._oControl._sFocusControlId=null;}};
c.prototype.exit=function(){this._oResourceBundle=null;this._oOpenByControl=null;if(this._oMessageView){this._oMessageView.destroy();this._oMessageView=null;}if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}};
c.prototype.openBy=function(o){var r=this._oPopover.getAggregation("_popup"),p=o.getParent();this._oOpenByControl=o;if(r instanceof P){if((p instanceof T||p instanceof a||p instanceof S)){r._minDimensions={width:400,height:128};r.setShowArrow(false);r.setResizable(true);}else{r.setShowArrow(true);}}if(this._oPopover){this._restoreExpansionDefaults();this._oPopover.openBy(o);}return this;};
c.prototype.close=function(){if(this._oPopover){this._oPopover.close();}return this;};
c.prototype.isOpen=function(){return this._oPopover.isOpen();};
c.prototype.toggle=function(o){if(this.isOpen()){this.close();}else{this.openBy(o);}return this;};
c.prototype.setPlacement=function(p){this.setProperty("placement",p,true);this._oPopover.setPlacement(p);return this;};
c.prototype.getDomRef=function(s){return this._oPopover&&this._oPopover.getAggregation("_popup").getDomRef(s);};
c.prototype._initMessageView=function(){var t=this,m;m=new M(this.getId()+"-messageView",{activeTitlePress:function(E){if(sap.ui.Device.system.phone){t.close();}t.fireActiveTitlePress({item:E.getParameter("item")});},listSelect:function(E){t.fireListSelect({messageTypeFilter:E.getParameter('messageTypeFilter')});},itemSelect:function(E){t.fireItemSelect({messageTypeFilter:E.getParameter('messageTypeFilter'),item:E.getParameter('item')});},longtextLoaded:function(){t.fireLongtextLoaded();},urlValidated:function(){t.fireUrlValidated();}});m._makeAutomaticBinding=function(){var j=t.getItems();if(!t.getBindingInfo("items")&&!j.length){this._bindToMessageModel();}};return m;};
c.prototype._onSegButtonSelect=function(){if(this.isOpen()&&!this.getInitiallyExpanded()&&this._oPopover.hasStyleClass(e+"-init")){this._expandMsgPopover();}};
c.prototype._restoreExpansionDefaults=function(){if(!this.getInitiallyExpanded()){this._collapseMsgPopover();this._oMessageView._oSegmentedButton.setSelectedButton("none");}else{this._expandMsgPopover();}};
c.prototype._expandMsgPopover=function(){var s,H=f,s=this._oPopover.$("cont").css("height");if(this.getInitiallyExpanded()&&s!=="0px"){H=parseFloat(s)?s:H;}this._oPopover.setContentHeight(H).removeStyleClass(e+"-init");};
c.prototype._collapseMsgPopover=function(){this._oPopover.addStyleClass(e+"-init").setContentHeight("auto");};
c.prototype._insertCloseBtn=function(o){var s=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE"),j=new B({icon:h["close"],visible:!D.system.phone,tooltip:s,press:this.close.bind(this)}).addStyleClass(e+"CloseBtn");o.insertContent(j,3,true);};
c.prototype._setInitialFocus=function(){if(this._oMessageView._isListPage()&&this.getInitiallyExpanded()){this._oPopover.setInitialFocus(this._oMessageView._oLists[this._sCurrentList||'all']);}};
c.prototype.setAsyncDescriptionHandler=function(j){this.setProperty('asyncDescriptionHandler',j,true);this._oMessageView.setProperty('asyncDescriptionHandler',j,true);return this;};
c.prototype.setAsyncURLHandler=function(j){this.setProperty('asyncURLHandler',j,true);this._oMessageView.setProperty('asyncURLHandler',j,true);return this;};
c.prototype.setModel=function(m,n){this._oMessageView.setModel(m,n);return C.prototype.setModel.apply(this,arguments);};
["invalidate","addStyleClass","removeStyleClass","toggleStyleClass","hasStyleClass","getBusyIndicatorDelay","setBusyIndicatorDelay","getVisible","setVisible","getBusy","setBusy"].forEach(function(n){c.prototype[n]=function(){if(this._oPopover&&this._oPopover[n]){var p=this._oPopover;var r=p[n].apply(p,arguments);return r===p?this:r;}};});["setModel","bindAggregation","setAggregation","insertAggregation","addAggregation","removeAggregation","removeAllAggregation","destroyAggregation"].forEach(function(F){c.prototype["_"+F+"Old"]=c.prototype[F];c.prototype[F]=function(){var r=c.prototype["_"+F+"Old"].apply(this,arguments);this._bItemsChanged=true;if(this._oPopover){this._oPopover.invalidate();}if(["removeAggregation","removeAllAggregation"].indexOf(F)!==-1){return r;}return this;};});return c;});
sap.ui.predefine('sap/m/MessagePopoverItem',["./library","./MessageItem"],function(l,M){"use strict";
var a=M.extend("sap.m.MessagePopoverItem",{});
return a;});
sap.ui.predefine('sap/m/MessagePopoverRenderer',[],function(){"use strict";var M={};
M.render=function(r,c){};
return M;},true);
sap.ui.predefine('sap/m/MessageStrip',["./library","sap/ui/core/Control","./MessageStripUtilities","./Text","./Link","./FormattedText","sap/ui/core/library","./MessageStripRenderer","sap/base/Log"],function(l,C,M,T,L,F,c,a,b){"use strict";var d=c.MessageType;
var e=C.extend("sap.m.MessageStrip",{metadata:{library:"sap.m",designtime:"sap/m/designtime/MessageStrip.designtime",properties:{text:{type:"string",group:"Appearance",defaultValue:""},type:{type:"sap.ui.core.MessageType",group:"Appearance",defaultValue:d.Information},customIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},showIcon:{type:"boolean",group:"Appearance",defaultValue:false},showCloseButton:{type:"boolean",group:"Appearance",defaultValue:false},enableFormattedText:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"link",aggregations:{link:{type:"sap.m.Link",multiple:false,singularName:"link"},_formattedText:{type:"sap.m.FormattedText",multiple:false,visibility:"hidden"},_text:{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{close:{}}}});
e.prototype.init=function(){this.data("sap-ui-fastnavgroup","true",true);this.setAggregation("_text",new T());};
e.prototype.setText=function(t){var f=this.getAggregation("_formattedText");if(f){f.setHtmlText(t);}this.getAggregation("_text").setText(t);return this.setProperty("text",t);};
e.prototype.setType=function(t){if(t===d.None){b.warning(M.MESSAGES.TYPE_NOT_SUPPORTED);t=d.Information;}return this.setProperty("type",t);};
e.prototype.setEnableFormattedText=function(E){var f=this.getAggregation("_formattedText");if(E){if(!f){f=new F();f._setUseLimitedRenderingRules(true);this.setAggregation("_formattedText",f);}f.setHtmlText(this.getText());}return this.setProperty("enableFormattedText",E);};
e.prototype.setAggregation=function(n,o,s){if(n==="link"&&o instanceof L){o.addAriaLabelledBy(this.getId());}C.prototype.setAggregation.call(this,n,o,s);return this;};
e.prototype.ontap=M.handleMSCloseButtonInteraction;e.prototype.onsapenter=M.handleMSCloseButtonInteraction;e.prototype.onsapspace=M.handleMSCloseButtonInteraction;
e.prototype.ontouchmove=function(E){E.setMarked();};
e.prototype.close=function(){var f=function(){this.fireClose();this.setVisible(false);}.bind(this);if(!sap.ui.getCore().getConfiguration().getAnimation()){f();return;}M.closeTransitionWithCSS.call(this,f);};
return e;});
sap.ui.predefine('sap/m/MessageStripRenderer',["./MessageStripUtilities"],function(M){"use strict";var a={};
a.render=function(r,c){this.startMessageStrip(r,c);this.renderAriaTypeText(r,c);if(c.getShowIcon()){this.renderIcon(r,c);}this.renderTextAndLink(r,c);if(c.getShowCloseButton()){this.renderCloseButton(r);}this.endMessageStrip(r);};
a.startMessageStrip=function(r,c){r.write("<div");r.addClass(M.CLASSES.ROOT);r.addClass(M.CLASSES.ROOT+c.getType());r.writeControlData(c);r.writeClasses();r.writeAttribute(M.ATTRIBUTES.CLOSABLE,c.getShowCloseButton());r.writeAccessibilityState(c,M.getAccessibilityState.call(c));r.write(">");};
a.renderAriaTypeText=function(r,c){r.write("<span class='sapUiPseudoInvisibleText'>");r.write(M.getAriaTypeText.call(c));r.write("</span>");};
a.renderIcon=function(r,c){r.write("<div class='"+M.CLASSES.ICON+"'>");r.writeIcon(M.getIconURI.call(c),null,{"title":null});r.write("</div>");};
a.renderTextAndLink=function(r,c){var f=c.getAggregation("_formattedText");r.write("<div class='"+M.CLASSES.MESSAGE+"'>");if(c.getEnableFormattedText()&&f){r.renderControl(f);}else{r.renderControl(c.getAggregation("_text"));}r.renderControl(c.getLink());r.write("</div>");};
a.renderCloseButton=function(r){r.write("<button");r.writeAttribute("class",M.CLASSES.CLOSE_BUTTON);r.writeAttribute("title",sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("MESSAGE_STRIP_CLOSE_BUTTON"));r.write("></button>");};
a.endMessageStrip=function(r){r.write("</div>");};
return a;},true);
sap.ui.predefine('sap/m/MessageStripUtilities',function(){"use strict";var M={};M.MESSAGES={TYPE_NOT_SUPPORTED:"Value 'sap.ui.core.MessageType.None' for property 'type' is not supported."+"Defaulting to 'sap.ui.core.MessageType.Information'"};M.CLASSES={ROOT:"sapMMsgStrip",ICON:"sapMMsgStripIcon",MESSAGE:"sapMMsgStripMessage",CLOSE_BUTTON:"sapMMsgStripCloseButton",CLOSING_TRANSITION:"sapMMsgStripClosing"};M.ATTRIBUTES={CLOSABLE:"data-sap-ui-ms-closable"};M.RESOURCE_BUNDLE=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core");
M.getIconURI=function(){var t=this.getType(),c=this.getCustomIcon(),i="sap-icon://message-"+t.toLowerCase();return c||i;};
M.getAriaTypeText=function(){var b="MESSAGE_STRIP_"+this.getType().toUpperCase(),a=M.RESOURCE_BUNDLE.getText(b);if(this.getShowCloseButton()){a+=" "+M.RESOURCE_BUNDLE.getText("MESSAGE_STRIP_CLOSABLE");}return a;};
M.handleMSCloseButtonInteraction=function(e){if(M.isMSCloseButtonPressed(e.target)){this.close();}};
M.isMSCloseButtonPressed=function(t){return t.className.indexOf(M.CLASSES.CLOSE_BUTTON)!==-1||t.parentNode.className.indexOf(M.CLASSES.CLOSE_BUTTON)!==-1;};
M.closeTransitionWithCSS=function(c){this.$().addClass(M.CLASSES.CLOSING_TRANSITION).one("webkitTransitionEnd transitionend",c);};
M.getAccessibilityState=function(){return{role:"alert",live:"assertive",labelledby:this.getId()};};
return M;});
sap.ui.predefine('sap/m/MessageToast',['./InstanceManager','sap/ui/core/Popup','sap/ui/core/library','sap/ui/core/Control','sap/ui/Device',"sap/base/Log","sap/ui/thirdparty/jquery"],function(I,P,c,C,D,L,q){"use strict";var a=c.Dock;var d=c.CSSSize;var M={};var O="0 -64",e="sapMMessageToast",E="sapUiSelectable",B="sapContrast",f="sapContrastPlus";M._mSettings={duration:3000,width:"15em",my:"center bottom",at:"center bottom",of:document.defaultView,offset:"0 0",collision:"fit fit",onClose:null,animationTimingFunction:"ease",animationDuration:1000,autoClose:true,closeOnBrowserNavigation:true};M._aPopups=[];M._iOpenedPopups=0;M._bBoundedEvents=false;
M._validateSettings=function(s){M._isFiniteInteger(s.duration);M._validateWidth(s.width);M._validateDockPosition(s.my);M._validateDockPosition(s.at);M._validateOf(s.of);M._validateOffset(s.offset);M._validateCollision(s.collision);M._validateOnClose(s.onClose);M._validateAutoClose(s.autoClose);M._validateAnimationTimingFunction(s.animationTimingFunction);M._isFiniteInteger(s.animationDuration);};
M._isFiniteInteger=function(N){if(typeof N!=="number"||!isFinite(N)||!(Math.floor(N)===N)||N<=0){L.error('"iNumber" needs to be a finite positive nonzero integer on '+M+"._isFiniteInteger");}};
M._validateWidth=function(w){if(!d.isValid(w)){L.error(w+' is not of type '+'"sap.ui.core.CSSSize" for property "width" on '+M+"._validateWidth");}};
M._validateDockPosition=function(s){if(!a.isValid(s)){L.error('"'+s+'"'+' is not of type '+'"sap.ui.core.Popup.Dock" on '+M+"._validateDockPosition");}};
M._validateOf=function(v){if(!(v instanceof q)&&!(v&&v.nodeType===1)&&!(v instanceof C)&&v!==window){L.error('"of" needs to be an instance of sap.ui.core.Control or an Element or a jQuery object or the window on '+M+"._validateOf");}};
M._validateOffset=function(o){if(typeof o!=="string"){L.error(o+' is of type '+typeof o+', expected "string" for property "offset" on '+M+"._validateOffset");}};
M._validateCollision=function(s){var r=/^(fit|flip|none|flipfit|flipflip|flip flip|flip fit|fitflip|fitfit|fit fit|fit flip)$/i;if(!r.test(s)){L.error('"collision" needs to be a single value “fit”, “flip”, or “none”, or a pair for horizontal and vertical e.g. "fit flip”, "fit none", "flipfit" on '+M+"._validateOffset");}};
M._validateOnClose=function(b){if(typeof b!=="function"&&b!==null){L.error('"onClose" should be a function or null on '+M+"._validateOnClose");}};
M._validateAutoClose=function(b){if(typeof b!=="boolean"){L.error('"autoClose" should be a boolean on '+M+"._validateAutoClose");}};
M._validateAnimationTimingFunction=function(t){var r=/^(ease|linear|ease-in|ease-out|ease-in-out)$/i;if(!r.test(t)){L.error('"animationTimingFunction" should be a string, expected values: '+"ease, linear, ease-in, ease-out, ease-in-out on "+M+"._validateAnimationTimingFunction");}};
function h(o){for(var p=["my","at","of","offset"],i=0;i<p.length;i++){if(o[p[i]]!==undefined){return false;}}return true;}
function g(s){var m=document.createElement("div");m.className=e+" "+E+" "+B+" "+f;if(sap.ui.getCore().getConfiguration().getAccessibility()){m.setAttribute("role","alert");m.setAttribute("aria-label"," ");}m.style.width=s.width;m.appendChild(document.createTextNode(s.message));return m;}
function n(o){if(o){if(h(o)){o.offset=O;}if(o.of&&o.of.nodeType===9){o.of=document.defaultView;}}else{o={offset:O};}return o;}
M._handleResizeEvent=function(){if(D.system.phone||D.system.tablet){M._resetPosition(M._aPopups);}setTimeout(M["_applyPositions"].bind(M,M._aPopups),0);};
M._handleMouseDownEvent=function(o){var i=o.target.hasAttribute("class")&&o.target.getAttribute("class").indexOf(e)!==-1;if(i||o.isMarked("delayedMouseEvent")){return;}M._aPopups.forEach(function(p){p&&p.__bAutoClose&&p.close();});};
M._resetPosition=function(p){for(var i=0,m;i<p.length;i++){m=p[i]&&p[i].getContent();if(m){m.style.visibility="hidden";m.style.left=0;}}};
M._applyPositions=function(p){for(var i=0,o,m;i<p.length;i++){o=p[i];if(o){m=o._oPosition;if(D.system.phone||D.system.tablet){setTimeout(M["_applyPosition"].bind(M,o,m),0);}else{o.setPosition(m.my,m.at,m.of,m.offset);}}}};
M._applyPosition=function(p,m){m=m||p._oPosition;var o=p.getContent();p.setPosition(m.my,m.at,m.of,m.offset);o.style.visibility="visible";};
M._setCloseAnimation=function(m,i,b,s){var j="opacity "+s.animationTimingFunction+" "+s.animationDuration+"ms",t="webkitTransitionEnd."+e+" transitionend."+e;if(sap.ui.getCore().getConfiguration().getAnimation()&&s.animationDuration>0){m[0].style.webkitTransition=j;m[0].style.transition=j;m[0].style.opacity=0;m.on(t,function handleMTTransitionEnd(){m.off(t);b();});}else{b();}};
M.show=function(m,o){var t=M,s=q.extend({},M._mSettings,{message:m}),p=new P(),i,b,j="mousedown."+e+" touchstart."+e,k,l;o=n(o);q.extend(s,o);M._validateSettings(s);b=g(s);i=M._aPopups.push(p)-1;p.setContent(b);p.setPosition(s.my,s.at,s.of,s.offset,s.collision);p.setAnimations(function fnMessageToastOpen($,v,w){w();},function fnMessageToastClose($,v,w){t._setCloseAnimation($,v,w,s);});p.setShadow(false);p.__bAutoClose=s.autoClose;if(s.closeOnBrowserNavigation){I.addPopoverInstance(p);}if(!M._bBoundedEvents){q(window).on("resize."+e,M._handleResizeEvent.bind(M));q(document).on(j,M._handleMouseDownEvent.bind(M));M._bBoundedEvents=true;}p.open();M._iOpenedPopups++;function r(){I.removePopoverInstance(t._aPopups[i]);q(t._aPopups[i].getContent()).remove();t._aPopups[i].detachClosed(r);t._aPopups[i].destroy();t._aPopups[i]=null;t._iOpenedPopups--;if(t._iOpenedPopups===0){t._aPopups=[];q(window).off("resize."+e);q(document).off(j);t._bBoundedEvents=false;}if(typeof s.onClose==="function"){s.onClose.call(t);}}p.attachClosed(r);k=setTimeout(p["close"].bind(p),s.duration);function u(){clearTimeout(k);k=null;function v(){l=setTimeout(p["close"].bind(p),s.duration);p.getContent().removeEventListener("mouseleave",v);}p.getContent().addEventListener("mouseleave",v);clearTimeout(l);l=null;}p.getContent().addEventListener("touchstart",u);p.getContent().addEventListener("mouseover",u);if(D.system.desktop){p.getContent().addEventListener("mouseleave",function(){k=setTimeout(p["close"].bind(p),s.duration);});}};
M.toString=function(){return"sap.m.MessageToast";};
return M;},true);
sap.ui.predefine('sap/m/MessageView',["jquery.sap.global","sap/ui/core/Control","sap/ui/core/CustomData","sap/ui/core/IconPool","sap/ui/core/HTML","sap/ui/core/Icon","./Button","./Toolbar","./ToolbarSpacer","./List","./MessageListItem","./library","./Text","./SegmentedButton","./Page","./NavContainer","./Link","./MessageItem","./GroupHeaderListItem","sap/ui/core/library","sap/ui/base/ManagedObject","./MessageViewRenderer","sap/ui/events/KeyCodes","sap/base/Log","sap/base/security/URLWhitelist","sap/ui/thirdparty/caja-html-sanitizer"],function(q,C,a,I,H,b,B,T,c,L,M,l,d,S,P,N,e,f,G,g,h,j,K,k,U){"use strict";var V=g.ValueState;var m=g.MessageType;var n=l.ListType;
var o=C.extend("sap.m.MessageView",{metadata:{library:"sap.m",properties:{asyncDescriptionHandler:{type:"any",group:"Behavior",defaultValue:null},asyncURLHandler:{type:"any",group:"Behavior",defaultValue:null},groupItems:{type:"boolean",group:"Behavior",defaultValue:false},showDetailsPageHeader:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MessageItem",multiple:true,singularName:"item"},headerButton:{type:"sap.m.Button",multiple:false},_navContainer:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},itemSelect:{parameters:{item:{type:"sap.m.MessageItem"},messageTypeFilter:{type:"sap.ui.core.MessageType"}}},listSelect:{parameters:{messageTypeFilter:{type:"sap.ui.core.MessageType"}}},longtextLoaded:{},urlValidated:{},activeTitlePress:{parameters:{item:{type:"sap.m.MessageItem"}}}}}});
var p="sapMMsgView";var r={back:I.getIconURI("nav-back"),close:I.getIconURI("decline"),information:I.getIconURI("message-information"),warning:I.getIconURI("message-warning"),error:I.getIconURI("message-error"),success:I.getIconURI("message-success")};var s=["all","error","warning","success","information"];var A=["asyncDescriptionHandler","asyncURLHandler"];var D={asyncDescriptionHandler:function(i){var t=i.item.getLongtextUrl();if(t){q.ajax({type:"GET",url:t,success:function(u){i.item.setDescription(u);i.promise.resolve();},error:function(){var E="A request has failed for long text data. URL: "+t;k.error(E);i.promise.reject(E);}});}}};
o.setDefaultHandlers=function(i){A.forEach(function(F){if(i.hasOwnProperty(F)){D[F]=i[F];}});};
o.prototype.init=function(){var t=this;this._bHasHeaderButton=false;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._createNavigationPages();this._createLists();A.forEach(function(F){if(D.hasOwnProperty(F)){t.setProperty(F,D[F]);}});};
o.prototype._afterNavigate=function(){setTimeout(this["_restoreFocus"].bind(this),0);};
o.prototype._restoreFocus=function(){if(this._isListPage()&&this.getItems().length){this._oLists[this._sCurrentList||'all'].focus();}else if(this._oBackButton){this._oBackButton.focus();}};
o.prototype.onBeforeRendering=function(){var i,t=this.getItems();this._clearLists();this._detailsPage.setShowHeader(this.getShowDetailsPageHeader());if(this.getGroupItems()){i=this._groupItems(t);this._fillGroupedLists(i);}else{this._fillLists(t);}var u=this.getHeaderButton();if(u){this._bHasHeaderButton=true;this._oListHeader.insertContent(u,2);}this._clearSegmentedButton();this._fillSegmentedButton();this._fnFilterList(this._getCurrentMessageTypeFilter()||"all");if(t.length===1&&this._oLists.all.getItems()[0].getType()===n.Navigation){this._fnHandleForwardNavigation(this._oLists.all.getItems()[0],"show");this._navContainer._pageStack[this._navContainer._pageStack.length-1].transition="slide";}this._makeAutomaticBinding();};
o.prototype._fillGroupedLists=function(i){var t=Object.keys(i),u=t.indexOf(""),v,w;if(u!==-1){v=i[""];w=Object.keys(v);w.forEach(function(x){var y=v[x];this._fillLists(y);delete i[""];t.splice(u,1);},this);}t.forEach(function(x){this._fillListsWithGroups(x,i[x]);},this);};
o.prototype._fillListsWithGroups=function(i,t){var u=Object.keys(t),v=new G({title:i}),w;this._oLists["all"].addAggregation("items",v,true);u.forEach(function(x){this._oLists[x.toLowerCase()].addAggregation("items",v.clone(),true);w=t[x];this._fillLists(w);},this);};
o.prototype.exit=function(){if(this._oLists){this._destroyLists();}if(this._oMessageItemTemplate){this._oMessageItemTemplate.destroy();}this._oResourceBundle=null;this._oListHeader=null;this._oDetailsHeader=null;this._oSegmentedButton=null;this._oBackButton=null;this._navContainer=null;this._listPage=null;this._detailsPage=null;this._sCurrentList=null;};
o.prototype._makeAutomaticBinding=function(){var i=this.getItems();if(!this.getBindingInfo("items")&&!i.length){this._bindToMessageModel();}};
o.prototype._bindToMessageModel=function(){var t=this;this.setModel(sap.ui.getCore().getMessageManager().getMessageModel(),"message");this._oMessageItemTemplate=new f({type:"{message>type}",title:"{message>message}",description:"{message>description}",longtextUrl:"{message>longtextUrl}"});this.bindAggregation("items",{path:"message>/",template:t._oMessageItemTemplate});};
o.prototype._groupItems=function(i){var t={},u,v;i.forEach(function(w){u=w.getGroupName();v=w.getType();t[u]=t[u]||{};var x=t[u];if(x[v]){x[v].push(w);}else{x[v]=[w];}});return t;};
o.prototype._onkeypress=function(E){if(E.shiftKey&&E.keyCode==K.ENTER){this.navigateBack();}};
o.prototype._getListHeader=function(){return this._oListHeader||this._createListHeader();};
o.prototype._getDetailsHeader=function(){return this._oDetailsHeader||this._createDetailsHeader();};
o.prototype._createListHeader=function(){var i=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE");var t=this.getId()+"-CloseBtnDescr";var u=new H(t,{content:"<span id=\""+t+"\" style=\"display: none;\">"+i+"</span>"});var v=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_HEADING");var w=this.getId()+"-HeadingDescr";var x=new H(w,{content:"<span id=\""+w+"\" style=\"display: none;\" role=\"heading\">"+v+"</span>"});this._oSegmentedButton=new S(this.getId()+"-segmented",{}).addStyleClass("sapMSegmentedButtonNoAutoWidth");this._oListHeader=new T({content:[this._oSegmentedButton,new c(),u,x]});return this._oListHeader;};
o.prototype._createDetailsHeader=function(){var i=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE");var t=this.getId()+"-CloseBtnDetDescr";var u=new H(t,{content:"<span id=\""+t+"\" style=\"display: none;\">"+i+"</span>"});var v=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_BACK_BUTTON_TOOLTIP");var w=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_BACK_BUTTON");var x=this.getId()+"-BackBtnDetDescr";var y=new H(x,{content:"<span id=\""+x+"\" style=\"display: none;\">"+w+"</span>"});this._oBackButton=new B({icon:r["back"],press:this.navigateBack.bind(this),ariaLabelledBy:y,tooltip:v}).addStyleClass(p+"BackBtn");this._oDetailsHeader=new T({content:[this._oBackButton,new c(),u,y]});return this._oDetailsHeader;};
o.prototype._createNavigationPages=function(){this._listPage=new P(this.getId()+"listPage",{customHeader:this._getListHeader()});this._detailsPage=new P(this.getId()+"-detailsPage",{customHeader:this._getDetailsHeader()});this._detailsPage.addEventDelegate({onclick:function(E){var t=E.target;if(t.nodeName.toUpperCase()==="A"&&(t.className.indexOf("sapMMsgPopoverItemDisabledLink")!==-1||t.className.indexOf("sapMMsgPopoverItemPendingLink")!==-1)){E.preventDefault();}}});this._navContainer=new N(this.getId()+"-navContainer",{initialPage:this.getId()+"listPage",pages:[this._listPage,this._detailsPage],afterNavigate:this._afterNavigate.bind(this)});this.setAggregation("_navContainer",this._navContainer);return this;};
o.prototype._createLists=function(){this._oLists={};s.forEach(function(i){this._oLists[i]=new L({itemPress:this._fnHandleItemPress.bind(this),visible:false});this._listPage.addAggregation("content",this._oLists[i],true);},this);return this;};
o.prototype._clearLists=function(){s.forEach(function(i){if(this._oLists[i]){this._oLists[i].destroyAggregation("items",true);}},this);return this;};
o.prototype._destroyLists=function(){s.forEach(function(i){this._oLists[i]=null;},this);this._oLists=null;};
o.prototype._fillLists=function(i){i.forEach(function(t){var u=this._mapItemToListItem(t),v=this._mapItemToListItem(t);this._oLists["all"].addAggregation("items",u,true);this._oLists[t.getType().toLowerCase()].addAggregation("items",v,true);},this);};
o.prototype._mapItemToListItem=function(i){if(!i){return null;}var t=i.getType(),u=this,v=this._getItemType(i),w=new M({title:h.escapeSettingsValue(i.getTitle()),description:h.escapeSettingsValue(i.getSubtitle()),counter:i.getCounter(),icon:this._mapIcon(t),infoState:this._mapInfoState(t),info:"\r",type:v,messageType:i.getType(),activeTitle:i.getActiveTitle(),activeTitlePress:function(){u.fireActiveTitlePress({item:i});}}).addStyleClass(p+"Item").addStyleClass(p+"Item"+t).toggleStyleClass(p+"ItemActive",i.getActiveTitle());if(v!==n.Navigation){w.addEventDelegate({onAfterRendering:function(){var x=w.getDomRef().querySelector(".sapMSLITitleDiv > div");if(x.offsetWidth<x.scrollWidth){w.setType(n.Navigation);if(this.getItems().length===1){this._fnHandleForwardNavigation(w,"show");}}}},this);}w._oMessageItem=i;return w;};
o.prototype._mapInfoState=function(t){if(!t){return null;}switch(t){case m.Warning:return V.Warning;case m.Error:return V.Error;case m.Success:return V.Success;case m.Information:case m.None:return V.None;default:k.warning("The provided MessageType is not mapped to a specific ValueState",t);return null;}};
o.prototype._mapIcon=function(i){if(!i){return null;}return r[i.toLowerCase()];};
o.prototype._getItemType=function(i){return(i.getDescription()||i.getMarkupDescription()||i.getLongtextUrl())?n.Navigation:n.Inactive;};
o.prototype._clearSegmentedButton=function(){if(this._oSegmentedButton){this._oSegmentedButton.destroyAggregation("buttons",true);}return this;};
o.prototype._fillSegmentedButton=function(){var t=this;var i=function(w){return function(){t._fnFilterList(w);};};s.forEach(function(w){var x=this._oLists[w],y=w=="all"?"MESSAGEPOPOVER_ALL":"MESSAGEVIEW_BUTTON_TOOLTIP_"+w.toUpperCase(),z=x.getItems().filter(function(F){return(F instanceof M);}).length,E;if(z>0){E=new B(this.getId()+"-"+w,{text:w=="all"?this._oResourceBundle.getText(y):z,tooltip:this._oResourceBundle.getText(y),icon:r[w],press:i(w)}).addStyleClass(p+"Btn"+w.charAt(0).toUpperCase()+w.slice(1));this._oSegmentedButton.addButton(E,true);}},this);var u=this._oSegmentedButton.getButtons().length>2;this._oSegmentedButton.setVisible(u);if(!u){this._oSegmentedButton.setSelectedButton(this._oSegmentedButton.getButtons()[0]);this._fnFilterList('all');}var v=u||this._bHasHeaderButton;this._listPage.setShowHeader(v);return this;};
o.prototype._setIcon=function(i,t){this._previousIconTypeClass=p+"DescIcon"+i.getType();this._oMessageIcon=new b({src:t.getIcon()}).addStyleClass(p+"DescIcon").addStyleClass(this._previousIconTypeClass);this._detailsPage.addContent(this._oMessageIcon);};
o.prototype._setTitle=function(i,t){var u=i.getActiveTitle(),v,w=this,x=h.escapeSettingsValue(i.getTitle()),y=this.getId()+"MessageTitleText";if(u){v=new e(y,{text:x,ariaDescribedBy:t.getId()+"-link",press:function(){w.fireActiveTitlePress({item:i});}});}else{v=new d(y,{text:x});}v.addStyleClass("sapMMsgViewTitleText");this._detailsPage.addAggregation("content",v);};
o.prototype._setDescription=function(i){var t=i.getLink();this._oLastSelectedItem=i;if(i.getMarkupDescription()){this._oMessageDescriptionText=new H(this.getId()+"MarkupDescription",{content:"<div class='sapMMsgViewDescriptionText'>"+h.escapeSettingsValue(i.getDescription())+"</div>"});}else{this._oMessageDescriptionText=new d(this.getId()+"MessageDescriptionText",{text:h.escapeSettingsValue(i.getDescription())}).addStyleClass("sapMMsgViewDescriptionText");}this._detailsPage.addContent(this._oMessageDescriptionText);if(t){var u=this._createLinkCopy(t);this._detailsPage.addContent(u);u.addStyleClass("sapMMsgViewDescriptionLink");}};
o.prototype._createLinkCopy=function(i){var t,u=i.clone("","",{cloneChildren:false,cloneBindings:false}),v=i.getCustomData()||[];t=Object.keys(i.getMetadata().getProperties());t.forEach(function(w){u.setProperty(w,i.getProperty(w));});u.destroyCustomData();v.forEach(function(w){var x=new a({key:w.getKey(),value:w.getValue()});u.addCustomData(x);});return u;};
o.prototype._iNextValidationTaskId=0;
o.prototype._validateURL=function(u){if(U.validate(u)){return u;}k.warning("You have entered invalid URL");return"";};
o.prototype._queueValidation=function(i){var t=this.getAsyncURLHandler();var v=++this._iNextValidationTaskId;var u={};var w=new window.Promise(function(x,y){u.resolve=x;u.reject=y;var z={url:i,id:v,promise:u};t(z);});w.id=v;return w;};
o.prototype._getTagPolicy=function(){var t=this,i;var u=html.makeTagPolicy(this._validateURL());return function customTagPolicy(v,w){var x,y=false;if(v.toUpperCase()==="A"){for(i=0;i<w.length;){if(w[i]==="href"){y=true;x=w[i+1];w.splice(0,2);continue;}i+=2;}}w=u(v,w);if(y&&typeof t.getAsyncURLHandler()==="function"){w=w||[];var z="sapMMsgViewItemDisabledLink sapMMsgViewItemPendingLink";var E=w.indexOf("class");if(E>-1){w[E+1]+=z;}else{w.unshift(z);w.unshift("class");}var F=w.indexOf("id");if(F>-1){w.splice(F+1,1);w.splice(F,1);}var J=t._queueValidation(x);w.push("href");w.push(x);w.push("target");w.push("_blank");w.push("id");w.push("sap-ui-"+t.getId()+"-link-under-validation-"+J.id);J.then(function(O){var $=q(document.getElementById("sap-ui-"+t.getId()+"-link-under-validation-"+O.id));if(O.allowed){k.info("Allow link "+x);}else{k.info("Disallow link "+x);}$.removeClass("sapMMsgViewItemPendingLink");$.toggleClass("sapMMsgViewItemDisabledLink",!O.allowed);t.fireUrlValidated();}).catch(function(){k.warning("Async URL validation could not be performed.");});}return w;};};
o.prototype._sanitizeDescription=function(i){var t=i.getDescription();if(i.getMarkupDescription()){var u=this._getTagPolicy();t=html.sanitizeWithPolicy(t,u);}i.setDescription(t);this._setDescription(i);};
o.prototype._fnHandleForwardNavigation=function(i,t){var u=i._oMessageItem,v=this._detailsPage.getContent()||[],w=this.getAsyncDescriptionHandler();this._previousIconTypeClass=this._previousIconTypeClass||"";this.fireItemSelect({item:u,messageTypeFilter:this._getCurrentMessageTypeFilter()});this._clearDetailsPage.call(this,v);if(typeof w==="function"&&!!u.getLongtextUrl()){u.setMarkupDescription(true);var x={};var y=new window.Promise(function(E,F){x.resolve=E;x.reject=F;});var z=function(){this._detailsPage.setBusy(false);this._navigateToDetails.call(this,u,i,t,true);}.bind(this);y.then(z).catch(function(){k.warning("Async description loading could not be performed.");z();});this._navContainer.to(this._detailsPage);this._detailsPage.setBusy(true);w({promise:x,item:u});}else{this._navigateToDetails.call(this,u,i,t,false);}this._listPage.$().attr("aria-hidden","true");};
o.prototype._fnHandleItemPress=function(E){this._fnHandleForwardNavigation(E.getParameter("listItem"),"slide");};
o.prototype._navigateToDetails=function(i,t,u,v){this._setTitle(i,t);this._sanitizeDescription(i);this._setIcon(i,t);this._detailsPage.rerender();this.fireLongtextLoaded();if(!v){this._navContainer.to(this._detailsPage,u);}};
o.prototype._clearDetailsPage=function(i){i.forEach(function(t){t.destroy();},this);};
o.prototype.navigateBack=function(){this._listPage.$().removeAttr("aria-hidden");this._navContainer.back();};
o.prototype._fnFilterList=function(i){s.forEach(function(t){if(t!=i&&this._oLists[t].getVisible()){this._oLists[t].setVisible(false);}},this);this._sCurrentList=i;this._oLists[i].setVisible(true);this.fireListSelect({messageTypeFilter:this._getCurrentMessageTypeFilter()});};
o.prototype._getCurrentMessageTypeFilter=function(){return this._sCurrentList=="all"?"":this._sCurrentList;};
o.prototype._isListPage=function(){return this._navContainer.getCurrentPage()==this._listPage;};
return o;});
sap.ui.predefine('sap/m/MessageViewRenderer',function(){"use strict";var M={};var C="sapMMsgView";
M.render=function(r,c){r.write("<div");r.writeControlData(c);r.writeStyles();r.addClass(C);r.writeClasses();r.write(">");r.renderControl(c._navContainer);r.write("</div>");};
return M;},true);
sap.ui.predefine('sap/m/MultiComboBox',['./InputBase','./ComboBoxTextField','./ComboBoxBase','./Input','./Tokenizer','./Token','./ToggleButton','./List','./Popover','./GroupHeaderListItem','./library','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','sap/ui/core/library','sap/ui/Device','sap/ui/core/Item','sap/ui/core/SeparatorItem','sap/ui/core/ResizeHandler','./MultiComboBoxRenderer',"sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/base/util/deepEqual","sap/base/assert","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/cursorPos","sap/ui/dom/jquery/control"],function(I,C,a,b,T,c,d,L,P,G,l,E,e,f,D,g,S,R,M,h,K,j,k,m,q){"use strict";var n=l.ListType;var o=l.ListMode;var V=f.ValueState;var O=f.OpenState;var p=l.PlacementType;
var r=a.extend("sap.m.MultiComboBox",{metadata:{library:"sap.m",designtime:"sap/m/designtime/MultiComboBox.designtime",properties:{selectedKeys:{type:"string[]",group:"Data",defaultValue:[]}},associations:{selectedItems:{type:"sap.ui.core.Item",multiple:true,singularName:"selectedItem"}},events:{selectionChange:{parameters:{changedItem:{type:"sap.ui.core.Item"},selected:{type:"boolean"}}},selectionFinish:{parameters:{selectedItems:{type:"sap.ui.core.Item[]"}}}}}});
e.insertFontFaceStyle();E.apply(r.prototype,[true]);
r.prototype.open=function(){this._bPickerIsOpening=true;a.prototype.open.apply(this,arguments);};
r.prototype.onsapend=function(i){sap.m.Tokenizer.prototype.onsapend.apply(this._oTokenizer,arguments);};
r.prototype.onsaphome=function(i){sap.m.Tokenizer.prototype.onsaphome.apply(this._oTokenizer,arguments);};
r.prototype.onsapdown=function(i){if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();i.preventDefault();var s=this.getSelectableItems();var t=s[0];if(t&&this.isOpen()){this.getListItem(t).focus();return;}if(this._oTokenizer.getSelectedTokens().length){return;}this._oTraversalItem=this._getNextTraversalItem();if(this._oTraversalItem){this.updateDomValue(this._oTraversalItem.getText());this.selectText(0,this.getValue().length);}};
r.prototype.onsapup=function(i){if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();i.preventDefault();if(this._oTokenizer.getSelectedTokens().length){return;}this._oTraversalItem=this._getPreviousTraversalItem();if(this._oTraversalItem){this.updateDomValue(this._oTraversalItem.getText());this.selectText(0,this.getValue().length);}};
r.prototype.onsapshow=function(i){var s=this.getList(),t=this.getPicker(),u=this.getSelectableItems(),v=this.getSelectedItems(),w,x=s.getItemNavigation(),y,z;z=q(document.activeElement).control()[0];if(z instanceof sap.m.Token){w=this._getItemByToken(z);}else{w=v.length?this._getItemByListItem(this.getList().getSelectedItems()[0]):u[0];}y=this.getItems().indexOf(w);if(x){x.setSelectedIndex(y);}else{this._bListItemNavigationInvalidated=true;this._iInitialItemFocus=y;}t.setInitialFocus(s);a.prototype.onsapshow.apply(this,arguments);};
r.prototype.onsaphide=r.prototype.onsapshow;
r.prototype._selectItemByKey=function(s){var v,t,u,i,w,x=this.isOpen();if(!this.getEnabled()||!this.getEditable()){return;}if(s){s.setMarked();}v=this._getUnselectedItems(x?"":this.getValue());for(i=0;i<v.length;i++){if(v[i].getText().toUpperCase()===this.getValue().toUpperCase()){u=v[i];w=true;break;}}if(w){t={item:u,id:u.getId(),key:u.getKey(),fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true,listItemUpdated:false};this._bPreventValueRemove=false;if(this.getValue()===""||(typeof this.getValue()==="string"&&u.getText().toLowerCase().startsWith(this.getValue().toLowerCase()))){if(this.getListItem(u).isSelected()){this.setValue('');}else{this.setSelection(t);}}}else{if(this.isPickerDialog()){this._showAlreadySelectedVisualEffect();}this._bPreventValueRemove=true;this._showWrongValueVisualEffect();}if(s){this.close();}};
r.prototype.onsapenter=function(i){I.prototype.onsapenter.apply(this,arguments);this._showAlreadySelectedVisualEffect();if(this.getValue()){this._selectItemByKey(i);}};
r.prototype.onsaptabnext=function(i){var s=this.getValue();if(s){var t=this._getUnselectedItemsStartingText(s);if(t.length===1){this._selectItemByKey(i);}else{this._showWrongValueVisualEffect();}}};
r.prototype.onsapfocusleave=function(i){var s=this.getAggregation("picker"),t=this.isPlatformTablet(),u=sap.ui.getCore().byId(i.relatedControlId),F=u&&u.getFocusDomRef(),v=this.getValue();if(!this._bPickerIsOpening&&(!s||!s.getFocusDomRef()||!F||!q.contains(s.getFocusDomRef(),F))){this.setValue(null);if(v){this.fireChangeEvent("",{value:v});}if(!(u instanceof c||i.srcControl instanceof c)){this._oTokenizer.scrollToEnd();}if(!q.contains(this.getDomRef(),document.activeElement)){this._oTokenizer._useCollapsedMode(true);}}if(s&&F){if(j(s.getFocusDomRef(),F)&&!t&&!this.isPickerDialog()){this.focus();}}};
r.prototype.onfocusin=function(i){var s=this.getPicker();var t=false;var u=s.getFocusDomRef();var v=s.oPopup.getOpenState()===O.CLOSING;var w=this.getPickerType()==="Dropdown";if(w){t=u&&q.contains(u,i.relatedTarget);}if(this.getEditable()){this._oTokenizer._useCollapsedMode(false);this._oTokenizer.scrollToEnd();}if(i.target===this.getFocusDomRef()){this.getEditable()&&this.addStyleClass("sapMFocus");!v&&t&&this.handleInputValidation(i,false);}if(i.target===this.getOpenArea()&&w&&!this.isPlatformTablet()){this.focus();}if(!this.isOpen()&&this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}};
r.prototype._handleItemTap=function(i){var t=q(i.target).control(0);if(!t.isA("sap.m.CheckBox")&&!t.isA("sap.m.GroupHeaderListItem")){this._bCheckBoxClicked=false;if(this.isOpen()&&!this._isListInSuggestMode()){this.close();}}};
r.prototype._handleItemPress=function(i){if(this.isOpen()&&this._isListInSuggestMode()&&this.getPicker().oPopup.getOpenState()!==O.CLOSING){this.clearFilter();var s=this._getLastSelectedItem();if(s){this.getListItem(s).focus();}}};
r.prototype._handleSelectionLiveChange=function(i){var s=i.getParameter("listItem");var t=i.getParameter("selected");var N=this._getItemByListItem(s);var u=this.isPickerDialog()?this.getPickerTextField():this;if(s.getType()==="Inactive"){return;}k(N,"The corresponding mapped item was not found on "+this);if(!N){return;}var v={item:N,id:N.getId(),key:N.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:true};if(t){this.fireChangeEvent(N.getText());this.setSelection(v);}else{this.fireChangeEvent(N.getText());this.removeSelection(v);}if(this._bCheckBoxClicked){u.setValue(this._sOldInput);if(this.isOpen()&&this.getPicker().oPopup.getOpenState()!==O.CLOSING){s.focus();}}else{this._bCheckBoxClicked=true;this.setValue("");this.close();}};
r.prototype.onkeydown=function(i){a.prototype.onkeydown.apply(this,arguments);if(!this.getEnabled()||!this.getEditable()){return;}this._bIsPasteEvent=(i.ctrlKey||i.metaKey)&&(i.which===K.V);if(this.getValue().length===0&&(i.ctrlKey||i.metaKey)&&(i.which===K.A)&&this._hasTokens()){this._oTokenizer.focus();this._oTokenizer.selectAllTokens(true);i.preventDefault();}if(this.isPickerDialog()){this._sOldValue=this.getPickerTextField().getValue();this._iOldCursorPos=q(this.getFocusDomRef()).cursorPos();}this._bDoTypeAhead=(i.which!==K.BACKSPACE)&&(i.which!==K.DELETE);};
r.prototype.oninput=function(i){a.prototype.oninput.apply(this,arguments);var s=i.srcControl,t=this.getPickerTextField();if(this.isPickerDialog()&&t.getValueState()===V.Error){t.setValueState(V.None);}if(!this.getEnabled()||!this.getEditable()){return;}if(this._bIsPasteEvent){s.updateDomValue(this._sOldValue||"");return;}this.handleInputValidation(i,this.isComposingCharacter());if(this.isOpen()){setTimeout(this._highlightList.bind(this,this._sOldInput));}};
r.prototype.filterItems=function(i){var F=this.fnFilter?this.fnFilter:a.DEFAULT_TEXT_FILTER;var s=[];var t=false;var u=[];i.items.forEach(function(v){if(v.isA("sap.ui.core.SeparatorItem")){u.push({separator:v});this.getListItem(v).setVisible(false);t=true;return;}var w=!!F(i.value,v,"getText");if(i.value===""){w=true;if(!this.bOpenedByKeyboardOrButton&&!this.isPickerDialog()){return;}}if(t&&w){this.getListItem(u[u.length-1].separator).setVisible(true);}var x=this.getListItem(v);if(x){x.setVisible(w);w&&s.push(v);}},this);return s;};
r.prototype.onkeyup=function(i){if(!this.getEnabled()||!this.getEditable()){return;}this._sOldValue=this.getValue();this._iOldCursorPos=q(this.getFocusDomRef()).cursorPos();};
r.prototype._showWrongValueVisualEffect=function(){var i=this.getPickerTextField(),s=this.isPickerDialog()?i.getValueState():this.getValueState(),t=this._oRbC.getText("VALUE_STATE_ERROR");if(s===V.Error){return;}if(this.isPickerDialog()){i.setValueState(V.Error);i.setValueStateText(t);setTimeout(i["setValueState"].bind(i,s),1000);}else{this.setValueState(V.Error);this.setValueStateText(t);setTimeout(this["setValueState"].bind(this,s),1000);}};
r.prototype._showAlreadySelectedVisualEffect=function(){var i=this.isPickerDialog(),s=this.getPickerTextField(),v=i?s.getValueState():this.getValueState(),t=this.getValue().toLowerCase(),u=this.getSelectedItems().map(function(w){return w.getText().toLowerCase();}),A=this._oRbM.getText("VALUE_STATE_ERROR_ALREADY_SELECTED");if(u.indexOf(t)>-1&&v!==V.Error){if(i){s.setValueState(V.Error);s.setValueStateText(A);s.selectText(0,this.getValue().length);}else{this.setValueState(V.Error);this.setValueStateText(A);this.selectText(0,this.getValue().length);}}else{i?s.setValueState(V.None):this.setValueState(V.None);}};
r.prototype._getReadOnlyPopover=function(){if(!this._oReadOnlyPopover){this._oReadOnlyPopover=this._createReadOnlyPopover();}return this._oReadOnlyPopover;};
r.prototype._createReadOnlyPopover=function(){return new P({showArrow:true,placement:p.Auto,showHeader:false,contentMinWidth:"auto"}).addStyleClass("sapMMultiComboBoxReadOnlyPopover");};
r.prototype.createPicker=function(s){var i=this.getAggregation("picker");if(i){return i;}i=this["create"+s]();this.setAggregation("picker",i,true);var t=this.getRenderer(),u=t.CSS_CLASS_MULTICOMBOBOX;i.setHorizontalScrolling(false).addStyleClass(t.CSS_CLASS_COMBOBOXBASE+"Picker").addStyleClass(u+"Picker").addStyleClass(u+"Picker-CTX").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this).addContent(this.getList());return i;};
r.prototype.createPickerTextField=function(){var t=this;return new b({submit:function(i){var v=this.getValue();if(v){t.setValue(v);t._selectItemByKey();this.setValue(t._sOldInput);}}}).addEventDelegate({onfocusout:this._handleInputFocusOut},this);};
r.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);var i=this.getItems();var s=this.getList();if(s){this._synchronizeSelectedItemAndKey(i);s.destroyItems();this._clearTokenizer();this._fillList(i);if(s.getItemNavigation()){this._iFocusedIndex=s.getItemNavigation().getFocusedIndex();}this.setEditable(this.getEditable());}this._deregisterResizeHandler();};
r.prototype._registerResizeHandler=function(){k(!this._iResizeHandlerId,"Resize handler already registered");this._iResizeHandlerId=R.register(this,this._onResize.bind(this));};
r.prototype._deregisterResizeHandler=function(){if(this._iResizeHandlerId){R.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null;}};
r.prototype._onResize=function(){this._oTokenizer.setMaxWidth(this._calculateSpaceForTokenizer());};
r.prototype.onBeforeRenderingPicker=function(){var i=this["_onBeforeRendering"+this.getPickerType()];if(i){i.call(this);}};
r.prototype.onAfterRenderingPicker=function(){var i=this["_onAfterRendering"+this.getPickerType()];if(i){i.call(this);}};
r.prototype.onBeforeOpen=function(){var i=this["_onBeforeOpen"+this.getPickerType()];this.addStyleClass(I.ICON_PRESSED_CSS_CLASS);this._resetCurrentItem();this.addContent();this._aInitiallySelectedItems=this.getSelectedItems();if(i){i.call(this);}};
r.prototype.onAfterOpen=function(){var i=this.getFocusDomRef();i&&i.setAttribute("aria-expanded","true");this._bPickerIsOpening=false;if(!this.isPlatformTablet()){this.getPicker().setInitialFocus(this);}this.closeValueStateMessage();};
r.prototype.onBeforeClose=function(){a.prototype.onBeforeClose.apply(this,arguments);};
r.prototype.onAfterClose=function(){var u=!q.contains(this.getDomRef(),document.activeElement)||this.isPickerDialog(),i=this.getFocusDomRef();i&&i.setAttribute("aria-expanded","false");this.removeStyleClass(I.ICON_PRESSED_CSS_CLASS);this.clearFilter();!this.isComposingCharacter()&&!this._bPreventValueRemove&&this.setValue("");this._sOldValue="";this._sOldInput="";if(this.isPickerDialog()){this._showAlreadySelectedVisualEffect();this.getPickerTextField().setValue("");this._getFilterSelectedButton()&&this._getFilterSelectedButton().setPressed(false);}this.fireSelectionFinish({selectedItems:this.getSelectedItems()});this._oTokenizer._useCollapsedMode(u);if(this.getValueState()==V.Error&&document.activeElement===this.getFocusDomRef()){this.selectText(0,this.getValue().length);this.openValueStateMessage();}};
r.prototype._onBeforeOpenDialog=function(){};
r.prototype._onBeforeOpenDropdown=function(){var i=this.getPicker(),s=this.getDomRef(),w;if(s&&i){w=(s.offsetWidth/parseFloat(l.BaseFontSize))+"rem";i.setContentMinWidth(w);}};
r.prototype._decoratePopover=function(i){var t=this;i.open=function(){return this.openBy(t);};};
r.prototype.createDropdown=function(){var i=new P(this.getDropdownSettings());i.setInitialFocus(this);this._decoratePopover(i);return i;};
r.prototype.createDialog=function(){var i=a.prototype.createDialog.apply(this,arguments),s=this._createFilterSelectedButton();i.getSubHeader().addContent(s);return i;};
r.prototype._createFilterSelectedButton=function(){var i=e.getIconURI("multiselect-all"),s=this.getRenderer(),t=this;return new d({icon:i,press:t._filterSelectedItems.bind(this)}).addStyleClass(s.CSS_CLASS_MULTICOMBOBOX+"ToggleButton");};
r.prototype._getFilterSelectedButton=function(){return this.getPicker().getSubHeader().getContent()[1];};
r.prototype._filterSelectedItems=function(i,F){var s=i.oSource,t,u,v=this.getPickerTextField()?this.getPickerTextField().getValue():"",w=(s&&s.getPressed&&s.getPressed())||F,x=this.getVisibleItems(),y=this.getItems(),z=this.getSelectedItems(),A=null;if(w){x.forEach(function(B){u=z.indexOf(B)>-1?true:false;t=this.getListItem(B);if(!t){return;}if(t.isA("sap.m.GroupHeaderListItem")){t.setVisible(false);A=t;}else{t.setVisible(u);if(u&&A){A.setVisible(true);}}},this);}else{this.filterItems({value:v,items:y});}};
r.prototype.revertSelection=function(){this.setSelectedItems(this._aInitiallySelectedItems);};
r.prototype.createList=function(){var i=this.getRenderer();this._oList=new L({width:"100%",mode:o.MultiSelect,includeItemInSelection:true,rememberSelections:false}).addStyleClass(i.CSS_CLASS_COMBOBOXBASE+"List").addStyleClass(i.CSS_CLASS_MULTICOMBOBOX+"List").attachBrowserEvent("tap",this._handleItemTap,this).attachSelectionChange(this._handleSelectionLiveChange,this).attachItemPress(this._handleItemPress,this);this._oList.addEventDelegate({onAfterRendering:this.onAfterRenderingList,onfocusin:this.onFocusinList},this);};
r.prototype.setSelection=function(i){if(i.item&&this.isItemSelected(i.item)){return;}if(!i.item){return;}if(!i.listItemUpdated&&this.getListItem(i.item)){this.getList().setSelectedItem(this.getListItem(i.item),true);}var t=new sap.m.Token({key:i.key});t.setText(i.item.getText());t.setTooltip(i.item.getText());i.item.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token",t);this._oTokenizer.addToken(t);this.$().toggleClass("sapMMultiComboBoxHasToken",this._hasTokens());this.setValue('');this.addAssociation("selectedItems",i.item,i.suppressInvalidate);var s=this.getKeys(this.getSelectedItems());this.setProperty("selectedKeys",s,i.suppressInvalidate);if(i.fireChangeEvent){this.fireSelectionChange({changedItem:i.item,selected:true});}if(i.fireFinishEvent){if(!this.isOpen()){this.fireSelectionFinish({selectedItems:this.getSelectedItems()});}}};
r.prototype.removeSelection=function(i){if(i.item&&!this.isItemSelected(i.item)){return;}if(!i.item){return;}this.removeAssociation("selectedItems",i.item,i.suppressInvalidate);var s=this.getKeys(this.getSelectedItems());this.setProperty("selectedKeys",s,i.suppressInvalidate);if(!i.listItemUpdated&&this.getListItem(i.item)){this.getList().setSelectedItem(this.getListItem(i.item),false);}if(!i.tokenUpdated){var t=this._getTokenByItem(i.item);i.item.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token",null);this._oTokenizer.removeToken(t);}this.$().toggleClass("sapMMultiComboBoxHasToken",this._hasTokens());if(i.fireChangeEvent){this.fireSelectionChange({changedItem:i.item,selected:false});}if(i.fireFinishEvent){if(!this.isOpen()){this.fireSelectionFinish({selectedItems:this.getSelectedItems()});}}};
r.prototype._synchronizeSelectedItemAndKey=function(s){if(!s.length){m.info("Info: _synchronizeSelectedItemAndKey() the MultiComboBox control does not contain any item on ",this);return;}var t=this.getSelectedKeys()||this._aCustomerKeys;var u=this.getKeys(this.getSelectedItems());if(t.length){for(var i=0,v=null,w=null,x=null,y=t.length;i<y;i++){v=t[i];if(u.indexOf(v)>-1){if(this._aCustomerKeys.length&&(x=this._aCustomerKeys.indexOf(v))>-1){this._aCustomerKeys.splice(x,1);}continue;}w=this.getItemByKey(""+v);if(w){if(this._aCustomerKeys.length&&(x=this._aCustomerKeys.indexOf(v))>-1){this._aCustomerKeys.splice(x,1);}this.setSelection({item:w,id:w.getId(),key:w.getKey(),fireChangeEvent:false,suppressInvalidate:true,listItemUpdated:false});}}return;}};
r.prototype._getTokenByItem=function(i){return i?i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token"):null;};
r.prototype.updateItems=function(s){var i,t,u=this.getSelectedKeys();var U=a.prototype.updateItems.apply(this,arguments);t=this.getSelectedItems();i=(t.length===u.length)&&t.every(function(v){return v&&v.getKey&&u.indexOf(v.getKey())>-1;});if(!i){t=u.map(this.getItemByKey,this);this.setSelectedItems(t);}return U;};
r.prototype._getSelectedItemsOf=function(s){for(var i=0,t=s.length,u=[];i<t;i++){if(this.getListItem(s[i]).isSelected()){u.push(s[i]);}}return u;};
r.prototype._getLastSelectedItem=function(){var t=this._oTokenizer.getTokens();var i=t.length?t[t.length-1]:null;if(!i){return null;}return this._getItemByToken(i);};
r.prototype._getOrderedSelectedItems=function(){var s=[];for(var i=0,t=this._oTokenizer.getTokens(),u=t.length;i<u;i++){s[i]=this._getItemByToken(t[i]);}return s;};
r.prototype._getFocusedListItem=function(){if(!document.activeElement){return null;}var F=sap.ui.getCore().byId(document.activeElement.id);if(this.getList()&&h(this.getList().getFocusDomRef(),F.getFocusDomRef())){return F;}return null;};
r.prototype._getFocusedItem=function(){var i=this._getFocusedListItem();return this._getItemByListItem(i);};
r.prototype._isRangeSelectionSet=function(i){var $=i.getDomRef();return $.indexOf(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"ItemRangeSelection")>-1?true:false;};
r.prototype._hasTokens=function(){return this._oTokenizer.getTokens().length>0;};
r.prototype._getCurrentItem=function(){if(!this._oCurrentItem){return this._getFocusedItem();}return this._oCurrentItem;};
r.prototype._setCurrentItem=function(i){this._oCurrentItem=i;};
r.prototype._resetCurrentItem=function(){this._oCurrentItem=null;};
r.prototype._decorateListItem=function(i){i.addDelegate({onkeyup:function(s){var t=null;if(s.which==K.SPACE&&this.isOpen()&&this._isListInSuggestMode()){this.open();t=this._getLastSelectedItem();if(t){this.getListItem(t).focus();}return;}},onkeydown:function(s){var t=null,u=null;if(s.shiftKey&&s.which==K.ARROW_DOWN){u=this._getCurrentItem();t=this._getNextVisibleItemOf(u);}if(s.shiftKey&&s.which==K.ARROW_UP){u=this._getCurrentItem();t=this._getPreviousVisibleItemOf(u);}if(s.shiftKey&&s.which===K.SPACE){u=this._getCurrentItem();this._selectPreviousItemsOf(u);}if(t&&t!==u){if(this.getListItem(u).isSelected()){this.setSelection({item:t,id:t.getId(),key:t.getKey(),fireChangeEvent:true,suppressInvalidate:true});this._setCurrentItem(t);}else{this.removeSelection({item:t,id:t.getId(),key:t.getKey(),fireChangeEvent:true,suppressInvalidate:true});this._setCurrentItem(t);}return;}this._resetCurrentItem();if((s.ctrlKey||s.metaKey)&&s.which==K.A){s.setMarked();s.preventDefault();var v=this.getSelectableItems();var w=this._getSelectedItemsOf(v);if(w.length!==v.length){v.forEach(function(t){this.setSelection({item:t,id:t.getId(),key:t.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false});},this);}else{v.forEach(function(t){this.removeSelection({item:t,id:t.getId(),key:t.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false});},this);}}}},true,this);i.addEventDelegate({onsapbackspace:function(s){s.preventDefault();},onsapshow:function(s){s.setMarked();if(this.isOpen()){this.close();return;}if(this.hasContent()){this.open();}},onsaphide:function(s){this.onsapshow(s);},onsapenter:function(s){s.setMarked();this.close();},onsaphome:function(s){s.setMarked();s.preventDefault();var v=this.getSelectableItems();var t=v[0];this.getListItem(t).focus();},onsapend:function(s){s.setMarked();s.preventDefault();var v=this.getSelectableItems();var t=v[v.length-1];this.getListItem(t).focus();},onsapup:function(s){s.setMarked();s.preventDefault();var v=this.getSelectableItems();var t=v[0];var u=q(document.activeElement).control()[0];if(u===this.getListItem(t)){this.focus();s.stopPropagation(true);}},onfocusin:function(s){this.addStyleClass(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Focused");},onfocusout:function(s){this.removeStyleClass(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Focused");},onsapfocusleave:function(s){var t=this.getAggregation("picker");var u=sap.ui.getCore().byId(s.relatedControlId);if(t&&u&&j(t.getFocusDomRef(),u.getFocusDomRef())){if(s.srcControl){s.srcControl.focus();}}}},this);if(D.support.touch){i.addEventDelegate({ontouchstart:function(s){s.setMark("cancelAutoClose");}});}};
r.prototype._handleInputFocusOut=function(){var i=this.isPickerDialog()?this.getPickerTextField():this,u=this._sOldInput||this._sOldValue||"";i.updateDomValue(u);};
r.prototype._handleIndicatorPress=function(i){this._filterSelectedItems(i,true);this.focus();if(this.getEditable()){this.getPicker().open();}else{this._getReadOnlyPopover().openBy(this._oTokenizer._oIndicator);}if(this.isPickerDialog()){this._getFilterSelectedButton().setPressed(true);this.bOpenedByKeyboardOrButton=true;}else{setTimeout(this._oTokenizer["scrollToEnd"].bind(this._oTokenizer),0);}};
r.prototype._createTokenizer=function(){var t=new sap.m.Tokenizer({tokens:[]}).attachTokenChange(this._handleTokenChange,this);t._setAdjustable(true);t._handleNMoreIndicatorPress(this._handleIndicatorPress.bind(this));t.setParent(this);t.addEventDelegate({onAfterRendering:this._onAfterRenderingTokenizer,onfocusin:function(i){if(this.getEditable()&&q(i.target).hasClass("sapMToken")){t._useCollapsedMode(false);}}},this);return t;};
r.prototype._onAfterRenderingTokenizer=function(){setTimeout(this._oTokenizer["scrollToEnd"].bind(this._oTokenizer),0);};
r.prototype._handleTokenChange=function(i){var t=i.getParameter("type");var s=i.getParameter("token");var u=null;if(t!==sap.m.Tokenizer.TokenChangeType.Removed&&t!==sap.m.Tokenizer.TokenChangeType.Added){return;}if(t===sap.m.Tokenizer.TokenChangeType.Removed){u=(s&&this._getItemByToken(s));if(u&&this.isItemSelected(u)){this.removeSelection({item:u,id:u.getId(),key:u.getKey(),tokenUpdated:true,fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true});!this.isPickerDialog()&&this.focus();this.fireChangeEvent("");}}};
r.prototype.onAfterRenderingList=function(){var i=this.getList();if(this._iFocusedIndex!=null&&i.getItems().length>this._iFocusedIndex){i.getItems()[this._iFocusedIndex].focus();this._iFocusedIndex=null;}};
r.prototype._highlightList=function(v){var i=[],s=[],t,u;this._oList.getItems().forEach(function(w){u=w.getDomRef();if(u){i.push({ref:u.getElementsByClassName("sapMSLITitleOnly")[0],text:w.getTitle()});t=u.querySelector(".sapMSLIInfo");if(t&&w.getInfo){s.push({ref:t,text:w.getInfo()});}}});this.highLightList(v,i);this.highLightList(v,s);};
r.prototype.onFocusinList=function(){if(this._bListItemNavigationInvalidated){this.getList().getItemNavigation().setSelectedIndex(this._iInitialItemFocus);this._bListItemNavigationInvalidated=false;}};
r.prototype.onAfterRendering=function(){a.prototype.onAfterRendering.apply(this,arguments);this._oTokenizer.setMaxWidth(this._calculateSpaceForTokenizer());this._registerResizeHandler();};
r.prototype.onfocusout=function(i){this.isOpen()&&this._handleInputFocusOut();this.removeStyleClass("sapMFocus");if(this.getValueState()===V.Error&&this.getValueStateText()===this._oRbM.getText("VALUE_STATE_ERROR_ALREADY_SELECTED")){this.setValueState(V.None);}a.prototype.onfocusout.apply(this,arguments);};
r.prototype.onpaste=function(i){var s;if(window.clipboardData){s=window.clipboardData.getData("Text");}else{s=i.originalEvent.clipboardData.getData('text/plain');}var t=this._oTokenizer._parseString(s);if(t&&t.length>0){this.getSelectableItems().forEach(function(u){if(t.indexOf(u.getText())>-1){this.setSelection({item:u,id:u.getId(),key:u.getKey(),fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true,listItemUpdated:false});}},this);}};
r.prototype.onsapbackspace=function(i){this._showAlreadySelectedVisualEffect();if(!this.getEnabled()||!this.getEditable()){i.preventDefault();return;}if(this.getCursorPosition()>0||this.getValue().length>0){return;}sap.m.Tokenizer.prototype.onsapbackspace.apply(this._oTokenizer,arguments);i.preventDefault();};
r.prototype.onsapdelete=function(i){this._showAlreadySelectedVisualEffect();if(!this.getEnabled()||!this.getEditable()){return;}if(this.getValue()&&!this._isCompleteTextSelected()){return;}sap.m.Tokenizer.prototype.onsapdelete.apply(this._oTokenizer,arguments);};
r.prototype.onsapnext=function(i){if(i.isMarked()){return;}var F=q(document.activeElement).control()[0];if(!F){return;}if(F===this._oTokenizer||this._oTokenizer.$().find(F.$()).length>0&&this.getEditable()){this.focus();}};
r.prototype.onsapprevious=function(i){if(this.getCursorPosition()===0&&!this._isCompleteTextSelected()){if(i.srcControl===this){sap.m.Tokenizer.prototype.onsapprevious.apply(this._oTokenizer,arguments);}}};
r.prototype.ontap=function(i){a.prototype.ontap.apply(this,arguments);var s=this.getOpenArea();if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();if(this.isPickerDialog()&&s.contains(i.target)){this.open();}};
r.prototype.getOpenArea=function(){if(this.isPickerDialog()){return this.getDomRef();}else{return a.prototype.getOpenArea.apply(this,arguments);}};
r.prototype._getItemsStartingWithPerTerm=function(t,i){var s=[],u=i?this.getEnabledItems():this.getSelectableItems(),F=this.fnFilter?this.fnFilter:a.DEFAULT_TEXT_FILTER;u.forEach(function(v){if(F(t,v,"getText")){s.push(v);}},this);return s;};
r.prototype._getItemsStartingWith=function(t,i){var s=[],u=i?this.getEnabledItems():this.getSelectableItems();u.forEach(function(v){if(typeof t==="string"&&t!==""&&v.getText().toLowerCase().startsWith(t.toLowerCase())){s.push(v);}},this);return s;};
r.prototype._getUnselectedItemsStartingText=function(t){var i=[];this._getUnselectedItems().forEach(function(s){if(typeof t==="string"&&t!==""&&s.getText().toLowerCase().startsWith(t.toLowerCase())){i.push(s);}},this);return i;};
r.prototype.getCursorPosition=function(){return this._$input.cursorPos();};
r.prototype._isCompleteTextSelected=function(){if(!this.getValue().length){return false;}var i=this._$input[0];if(i.selectionStart!==0||i.selectionEnd!==this.getValue().length){return false;}return true;};
r.prototype._selectPreviousItemsOf=function(i){var s;do{s=true;var t=this._getPreviousVisibleItemOf(i);if(t){var u=this.getListItem(t);if(u){s=this.getListItem(t).getSelected();}}this.setSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true});i=t;}while(!s);};
r.prototype._getNextVisibleItemOf=function(i){var s=this.getSelectableItems();var t=s.indexOf(i)+1;if(t<=0||t>s.length-1){return null;}return s[t];};
r.prototype._getPreviousVisibleItemOf=function(i){var s=this.getSelectableItems();var t=s.indexOf(i)-1;if(t<0){return null;}return s[t];};
r.prototype._getNextUnselectedItemOf=function(i){var s=this._getUnselectedItems();var t=s.indexOf(i)+1;if(t<=0||t>s.length-1){return null;}return s[t];};
r.prototype._getPreviousUnselectedItemOf=function(i){var s=this._getUnselectedItems();var t=s.indexOf(i)-1;if(t<0){return null;}return s[t];};
r.prototype._getNextTraversalItem=function(){var v=this.getValue();var i=v?this._getItemsStartingWithPerTerm(v):[];var s=this._getUnselectedItems();if(i.indexOf(this._oTraversalItem)>-1&&this._oTraversalItem.getText()===this.getValue()){return this._getNextUnselectedItemOf(this._oTraversalItem);}if(i.length&&i[0].getText()===this.getValue()){return this._getNextUnselectedItemOf(i[0]);}return i.length?i[0]:s[0];};
r.prototype._getPreviousTraversalItem=function(){var v=this.getValue();var i=v?this._getItemsStartingWithPerTerm(v):[];if(i.indexOf(this._oTraversalItem)>-1&&this._oTraversalItem.getText()===this.getValue()){return this._getPreviousUnselectedItemOf(this._oTraversalItem);}if(i.length&&i[i.length-1].getText()===this.getValue()){return this._getPreviousUnselectedItemOf(i[i.length-1]);}if(i.length){return i[i.length-1];}else{var s=this._getUnselectedItems();if(s.length>0){return s[s.length-1];}else{return null;}}};
r.prototype.setSelectedItems=function(i){this.removeAllSelectedItems();if(!i||!i.length){return this;}if(!Array.isArray(i)){m.warning("Warning: setSelectedItems() has to be an array of sap.ui.core.Item instances or of valid sap.ui.core.Item IDs",this);return this;}i.forEach(function(s){if(!(s instanceof g)&&(typeof s!=="string")){m.warning("Warning: setSelectedItems() has to be an array of sap.ui.core.Item instances or of valid sap.ui.core.Item IDs",this);return;}if(typeof s==="string"){s=sap.ui.getCore().byId(s);}this.setSelection({item:s?s:null,id:s?s.getId():"",key:s?s.getKey():"",suppressInvalidate:true});},this);return this;};
r.prototype.addSelectedItem=function(i){if(!i){return this;}if(typeof i==="string"){i=sap.ui.getCore().byId(i);}this.setSelection({item:i?i:null,id:i?i.getId():"",key:i?i.getKey():"",fireChangeEvent:false,suppressInvalidate:true});return this;};
r.prototype.removeSelectedItem=function(i){if(!i){return null;}if(typeof i==="string"){i=sap.ui.getCore().byId(i);}if(!this.isItemSelected(i)){return null;}this.removeSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:false,suppressInvalidate:true});return i;};
r.prototype.removeAllSelectedItems=function(){var i=[];var s=this.getAssociation("selectedItems",[]);s.forEach(function(t){var u=this.removeSelectedItem(t);if(u){i.push(u.getId());}},this);return i;};
r.prototype.removeSelectedKeys=function(i){var s=[],t;if(!i||!i.length||!Array.isArray(i)){return s;}var u;i.forEach(function(v){u=this.getItemByKey(v);if(u){this.removeSelection({item:u?u:null,id:u?u.getId():"",key:u?u.getKey():"",fireChangeEvent:false,suppressInvalidate:true});s.push(u);}if(this._aCustomerKeys.length&&(t=this._aCustomerKeys.indexOf(v))>-1){this._aCustomerKeys.splice(t,1);}},this);return s;};
r.prototype.setSelectedKeys=function(i){this.removeAllSelectedItems();this._aCustomerKeys=[];this.addSelectedKeys(i);return this;};
r.prototype.addSelectedKeys=function(i){i=this.validateProperty("selectedKeys",i);i.forEach(function(s){var t=this.getItemByKey(s);if(t){this.addSelectedItem(t);}else if(s!=null){this._aCustomerKeys.push(s);}},this);return this;};
r.prototype.getSelectedKeys=function(){var i=this.getSelectedItems()||[],s=[];i.forEach(function(t){s.push(t.getKey());},this);if(this._aCustomerKeys.length){s=s.concat(this._aCustomerKeys);}return s;};
r.prototype._getUnselectedItems=function(){return q(this.getSelectableItems()).not(this.getSelectedItems()).get();};
r.prototype.getSelectedItems=function(){var i=[],s=this.getAssociation("selectedItems")||[];s.forEach(function(t){var u=sap.ui.getCore().byId(t);if(u){i.push(u);}},this);return i;};
r.prototype.getWidth=function(){return this.getProperty("width")||"100%";};
r.prototype.setEditable=function(i){var s=this.getList();a.prototype.setEditable.apply(this,arguments);this._oTokenizer.setEditable(i);if(i){s.setMode(o.MultiSelect);this.getPicker().addContent(s);}else{s.setMode(o.None);this._getReadOnlyPopover().addContent(s);}return this;};
r.prototype._mapItemToListItem=function(i){var s,t,u,A;var v=this.getRenderer();if(!i){return null;}A=(i.getAdditionalText&&this.getShowSecondaryValues())?i.getAdditionalText():"";if(i.isA("sap.ui.core.SeparatorItem")){s=this._mapSeparatorItemToGroupHeader(i);i.data(v.CSS_CLASS_COMBOBOXBASE+"ListItem",s);s.addStyleClass(v.CSS_CLASS_MULTICOMBOBOX+"NonInteractiveItem");this._decorateListItem(s);return s;}t=v.CSS_CLASS_MULTICOMBOBOX+"Item";u=(this.isItemSelected(i))?t+"Selected":"";s=new sap.m.StandardListItem({type:n.Active,info:A,visible:i.getEnabled()}).addStyleClass(t+" "+u);s.setTooltip(i.getTooltip());i.data(v.CSS_CLASS_COMBOBOXBASE+"ListItem",s);s.setTitle(i.getText());if(u){var w=new sap.m.Token({key:i.getKey()});w.setText(i.getText());w.setTooltip(i.getText());i.data(v.CSS_CLASS_COMBOBOXBASE+"Token",w);this._oTokenizer.addToken(w,true);}this.setSelectable(i,i.getEnabled());this._decorateListItem(s);return s;};
r.prototype._findMappedItem=function(s,t){for(var i=0,t=t||this.getItems(),u=t.length;i<u;i++){if(this.getListItem(t[i])===s){return t[i];}}return null;};
r.prototype.setSelectable=function(i,s){if(this.indexOfItem(i)<0){return;}i._bSelectable=s;var t=this.getListItem(i);if(t){t.setVisible(s);}var u=this._getTokenByItem(i);if(u){u.setVisible(s);}};
r.prototype._fillList=function(s){if(!s){return null;}if(!this._oListItemEnterEventDelegate){this._oListItemEnterEventDelegate={onsapenter:function(v){if(v.srcControl.isSelected()){v.setMarked();}}};}for(var i=0,t,u=s.length;i<u;i++){t=this._mapItemToListItem(s[i]);t.removeEventDelegate(this._oListItemEnterEventDelegate);t.addDelegate(this._oListItemEnterEventDelegate,true,this,true);this.getList().addAggregation("items",t,true);if(this.isItemSelected(s[i])){this.getList().setSelectedItem(t,true);}}};
r.prototype.handleInputValidation=function(i,s){var v=i.target.value,t=this._sOldInput&&this._sOldInput.length>v.length,u=this.isValueValid(v),w,x,y;var z=i.srcControl;if(!u&&v!==""&&!s){this._handleFieldValidationState(z);return;}y=this._getItemsStartingWith(v,true);!s&&this._handleTypeAhead(v,y,z);w=this.getEnabledItems();if(this.isPickerDialog()){x=this._getFilterSelectedButton();if(x!=null&&x.getPressed()){x.setPressed(false);}}if(t){w=this.getItems();}this.filterItems({value:v,items:w});this._sOldInput=v;if((!this.getValue()||!u)&&!this.bOpenedByKeyboardOrButton&&!this.isPickerDialog()){this.close();}else{this.open();}};
r.prototype.isValueValid=function(v){var s=this._getItemsStartingWith(v,true);var i=this._getItemsStartingWithPerTerm(v,true);return s.length||i.length;};
r.prototype._handleTypeAhead=function(v,i,s){var t=this.getSelectedItems();var u=i.filter(function(w){if(w.isA("sap.ui.core.SeparatorItem")){return false;}return t.indexOf(w)===-1;});if(this._bDoTypeAhead&&u.length){s.updateDomValue(u[0].getText());if(document.activeElement===s.getFocusDomRef()){s.selectText(v.length,s.getValue().length);}}};
r.prototype._handleFieldValidationState=function(i){if(this._sOldInput&&this.isValueValid(this._sOldInput)){i.updateDomValue(this._sOldInput);}else if(this._sOldValue&&this.isValueValid(this._sOldValue)){i.updateDomValue(this._sOldValue);}else{i.updateDomValue("");}if(this._iOldCursorPos){q(i.getFocusDomRef()).cursorPos(this._iOldCursorPos);}this._showWrongValueVisualEffect();};
r.prototype.init=function(){this.createList();a.prototype.init.apply(this,arguments);this._bListItemNavigationInvalidated=false;this._iInitialItemFocus=-1;this._bCheckBoxClicked=true;this._bPreventValueRemove=false;this._oTokenizer=this._createTokenizer();this._aCustomerKeys=[];this._aInitiallySelectedItems=[];this._oRbM=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oRbC=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core");};
r.prototype.clearSelection=function(){this.removeAllSelectedItems();};
r.prototype.insertItem=function(i,s){this.insertAggregation("items",i,s,true);if(i){i.attachEvent("_change",this.onItemChange,this);}if(this.getList()){this.getList().insertItem(this._mapItemToListItem(i),s);}return this;};
r.prototype.addItemGroup=function(i,H,s){H=H||new S({text:i.text||i.key});this.addAggregation("items",H,s);return H;};
r.prototype._mapSeparatorItemToGroupHeader=function(s){return new G({title:s.getText()});};
r.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(this.getList()){this.getList().removeItem(i&&this.getListItem(i));}this.removeSelection({item:i,id:i?i.getId():"",key:i?i.getKey():"",fireChangeEvent:false,suppressInvalidate:true,listItemUpdated:true});return i;};
r.prototype.isItemSelected=function(i){return this.getSelectedItems().indexOf(i)>-1;};
r.prototype._clearTokenizer=function(){this._oTokenizer.destroyAggregation("tokens",true);};
r.prototype.exit=function(){a.prototype.exit.apply(this,arguments);this._deregisterResizeHandler();if(this.getList()){this.getList().destroy();this._oList=null;}if(this._oTokenizer){this._oTokenizer.destroy();this._oTokenizer=null;}};
r.prototype.destroyItems=function(){this.destroyAggregation("items");if(this.getList()){this.getList().destroyItems();}this._oTokenizer.destroyTokens();return this;};
r.prototype.removeAllItems=function(){var i=this.removeAllAggregation("items");this.removeAllSelectedItems();if(this.getList()){this.getList().removeAllItems();}return i;};
r.prototype._getItemByToken=function(t){return this._getItemBy(t,"Token");};
r.prototype.getAccessibilityInfo=function(){var t=this.getSelectedItems().map(function(s){return s.getText();}).join(" ");var i=a.prototype.getAccessibilityInfo.apply(this,arguments);i.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_MULTICOMBO");i.description=((i.description||"")+" "+t).trim();return i;};
return r;});
sap.ui.predefine('sap/m/MultiComboBoxRenderer',['./ComboBoxBaseRenderer','./ComboBoxTextFieldRenderer','sap/ui/core/Renderer','sap/ui/Device'],function(C,a,R,D){"use strict";var M=R.extend(C);M.CSS_CLASS_MULTICOMBOBOX="sapMMultiComboBox";
M.addOuterClasses=function(r,c){C.addOuterClasses.apply(this,arguments);r.addClass(M.CSS_CLASS_MULTICOMBOBOX);if(c._hasTokens()){r.addClass("sapMMultiComboBoxHasToken");}};
M.getAriaDescribedBy=function(c){var A=a.getAriaDescribedBy.apply(this,arguments),i=c._oTokenizer&&c._oTokenizer.getTokensInfoId();return(A||"")+" "+i;};
M.prependInnerContent=function(r,c){r.renderControl(c._oTokenizer);};
return M;},true);
sap.ui.predefine('sap/m/MultiEditField',["sap/ui/core/XMLComposite","./library","sap/ui/core/Item"],function(X,l,I){"use strict";
var M=X.extend("sap.m.MultiEditField",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{selectedItem:{type:"sap.ui.core.Item",group:"Data",defaultValue:null,invalidate:true},showValueHelp:{type:"boolean",group:"Behavior",defaultValue:true,invalidate:true},nullable:{type:"boolean",group:"Behavior",defaultValue:true,invalidate:true},required:{type:"boolean",group:"Behavior",defaultValue:false,invalidate:true}},aggregations:{items:{type:"sap.ui.core.Item",multiple:true,bindable:"bindable"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{selectedItem:{type:"sap.ui.core.Item"}}}}}});
M.prototype.init=function(){if(!M.prototype._oRb){M.prototype._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");}var k=new I({key:"keep",text:"< "+this._oRb.getText("MULTI_EDIT_KEEP_TEXT")+" >"}),b=new I({key:"blank",text:"< "+this._oRb.getText("MULTI_EDIT_BLANK_TEXT")+" >"}),n=new I({key:"new",text:"< "+this._oRb.getText("MULTI_EDIT_NEW_TEXT")+" >"});this._getKeepAll=function(){return k;};this._getBlank=function(){return b;};this._getValueHelp=function(){return n;};this.byId("select").getParent=this.getParent.bind(this);this._oLastSelectedItem=this._getKeepAll();};
M.prototype.onBeforeRendering=function(){this.insertAggregation("items",this._getKeepAll(),0,true);if(this.getNullable()){this.insertAggregation("items",this._getBlank(),1,true);}else{this.removeAggregation("items",this._getBlank(),true);}if(this.getShowValueHelp()){this.insertAggregation("items",this._getValueHelp(),this.getNullable()?2:1,true);}else{this.removeAggregation("items",this._getValueHelp(),true);}var s=this.getSelectedItem();if(s){s=this._getInternalItem(s);this.byId("select").setSelectedItem(s);}};
M.prototype.setSelectedItem=function(s){var i=this._getExternalItem(s)||s;var o;if(i&&this.indexOfItem(i)>=0&&!this._isSpecialValueItem(i)){o=this._getInternalItem(s);if(o){this.byId("select").setSelectedItem(o);}this._oLastSelectedItem=i;return this.setProperty("selectedItem",i);}return this;};
M.prototype.exit=function(){this._getKeepAll().destroy();this._getBlank().destroy();this._getValueHelp().destroy();var i=this.byId("itemTemplate");if(i){i.destroy();}};
M.prototype.getFormDoNotAdjustWidth=function(){return true;};
M.prototype.isBlankSelected=function(){return this._getExternalItem(this.byId("select").getSelectedItem())===this._getBlank();};
M.prototype.isKeepExistingSelected=function(){return this._getExternalItem(this.byId("select").getSelectedItem())===this._getKeepAll();};
M.prototype._isSpecialValueItem=function(i){return i===this._getKeepAll()||i===this._getBlank()||i===this._getValueHelp();};
M.prototype._handleSelectionChange=function(e){var i=this._getExternalItem(e.getParameter("selectedItem"));if(i&&!this._isSpecialValueItem(i)){this.fireChange({selectedItem:i});}else if(i===this._getValueHelp()){this.fireEvent("_valueHelpRequest");}if(i!==this._getValueHelp()){this._oLastSelectedItem=i;this.setProperty("selectedItem",i,true);}};
M.prototype.resetSelection=function(){this.byId("select").setSelectedItem(this._getInternalItem(this._oLastSelectedItem));};
M.prototype._getExternalItem=function(i){var a=this.byId("select").indexOfItem(i);if(a>=0){return this.getItems()[a];}return null;};
M.prototype._getInternalItem=function(i){var a=this.indexOfItem(i);if(a>=0){return this.byId("select").getItems()[a];}return null;};
M.prototype._getInternalDomRef=function(){var s=this.byId("select");return s&&s.getDomRef();};
M.prototype._getInternalUIArea=function(){return this.byId("select").getUIArea();};
return M;});
sap.ui.predefine('sap/m/MultiInput',['./Input','./Tokenizer','./Token','./library','sap/ui/core/EnabledPropagator','sap/ui/base/ManagedObjectMetadata','sap/ui/Device','./Popover','./Button','./ToggleButton','./List','./Title','./Bar','./Toolbar','sap/ui/core/ResizeHandler','sap/ui/core/IconPool','./MultiInputRenderer',"sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/cursorPos","sap/ui/dom/jquery/control"],function(I,T,a,l,E,M,D,P,B,b,L,c,d,f,R,g,h,j,K,q){"use strict";var k=l.PlacementType,m=l.ListMode;
var n=I.extend("sap.m.MultiInput",{metadata:{library:"sap.m",designtime:"sap/m/designtime/MultiInput.designtime",properties:{enableMultiLineMode:{type:"boolean",group:"Behavior",defaultValue:false},maxTokens:{type:"int",group:"Behavior"}},aggregations:{tokens:{type:"sap.m.Token",multiple:true,singularName:"token"},tokenizer:{type:"sap.m.Tokenizer",multiple:false,visibility:"hidden"}},events:{tokenChange:{parameters:{type:{type:"string"},token:{type:"sap.m.Token"},tokens:{type:"sap.m.Token[]"},addedTokens:{type:"sap.m.Token[]"},removedTokens:{type:"sap.m.Token[]"}}},tokenUpdate:{allowPreventDefault:true,parameters:{type:{type:"string"},addedTokens:{type:"sap.m.Token[]"},removedTokens:{type:"sap.m.Token[]"}}}}}});
E.apply(n.prototype,[true]);var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");
n.prototype.init=function(){this._bShowListWithTokens=false;I.prototype.init.call(this);this._bIsValidating=false;this._tokenizer=new T();this._tokenizer._setAdjustable(true);this.setAggregation("tokenizer",this._tokenizer);this._tokenizer.attachTokenChange(this._onTokenChange,this);this._tokenizer.attachTokenUpdate(this._onTokenUpdate,this);this._tokenizer._handleNMoreIndicatorPress(this._handleIndicatorPress.bind(this));this._tokenizer.addEventDelegate({onThemeChanged:this._handleInnerVisibility.bind(this)},this);this.setShowValueHelp(true);this.setShowSuggestion(true);this.attachSuggestionItemSelected(this._onSuggestionItemSelected,this);this.attachLiveChange(this._onLiveChange,this);this.attachValueHelpRequest(function(){this._bValueHelpOpen=true;},this);this._getValueHelpIcon().setProperty("visible",true,true);this._modifySuggestionPicker();};
n.prototype.exit=function(){I.prototype.exit.call(this);if(this._oSelectedItemPicker){this._oSelectedItemPicker.destroy();this._oSelectedItemPicker=null;}if(this._oSelectedItemsList){this._oSelectedItemsList.destroy();this._oSelectedItemsList=null;}if(this._getReadOnlyPopover()){var o=this._getReadOnlyPopover();o.destroy();o=null;}this._deregisterResizeHandler();};
n.prototype.onAfterRendering=function(){this._tokenizer.scrollToEnd();this._registerResizeHandler();this._tokenizer.setMaxWidth(this._calculateSpaceForTokenizer());this._handleInnerVisibility();I.prototype.onAfterRendering.apply(this,arguments);};
n.prototype._handleInnerVisibility=function(){var H=this._tokenizer._hasMoreIndicator();this[H?"_setValueInvisible":"_setValueVisible"].call(this);};
n.prototype.oninput=function(e){I.prototype.oninput.call(this,e);this._manageListsVisibility(false);this._getSelectedItemsPicker().close();};
n.prototype._registerResizeHandler=function(){if(!this._iResizeHandlerId){this._iResizeHandlerId=R.register(this,this._onResize.bind(this));}};
n.prototype._deregisterResizeHandler=function(){if(this._iResizeHandlerId){R.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null;}};
n.prototype._onResize=function(){this._deregisterResizeHandler();this._tokenizer.setMaxWidth(this._calculateSpaceForTokenizer());this._handleInnerVisibility();this._registerResizeHandler();};
n.prototype._onTokenChange=function(e){this.fireTokenChange(e.getParameters());this.invalidate();var F=j(this.getDomRef(),document.activeElement);if(e.getParameter("type")==="tokensChanged"&&e.getParameter("removedTokens").length>0&&F){this.focus();}if(e.getParameter("type")==="removed"){this._tokenizer._useCollapsedMode(false);this.focus();}};
n.prototype._onTokenUpdate=function(e){var i=this.fireTokenUpdate(e.getParameters());if(!i){e.preventDefault();}else{this.invalidate();}if(this._bUseDialog){this._fillList();this._manageListsVisibility(true);}};
n.prototype._onSuggestionItemSelected=function(e){var i=null,t=null,o=this,O=this._tokenizer.getTokens().length;if(this.getMaxTokens()&&O>=this.getMaxTokens()||this._bValueHelpOpen){return;}if(this._hasTabularSuggestions()){i=e.getParameter("selectedRow");}else{i=e.getParameter("selectedItem");if(i){t=new a({text:i.getText(),key:i.getKey()});}}if(i){var p=this.getValue();this._tokenizer._addValidateToken({text:p,token:t,suggestionObject:i,validationCallback:function(v){if(v){o.setValue("");}}});}if(this._bUseDialog){var N=this._tokenizer.getTokens().length;if(O<N){this.setValue("");}if(this._getSuggestionsList()instanceof sap.m.Table){this._getSuggestionsList().addStyleClass("sapMInputSuggestionTableHidden");}else{this._getSuggestionsList().destroyItems();}var s=this._oSuggestionPopup.getScrollDelegate();if(s){s.scrollTo(0,0,0);}this._oSuggPopover._oPopupInput.focus();}};
n.prototype._onLiveChange=function(e){this._tokenizer._removeSelectedTokens();};
n.prototype._setValueInvisible=function(){this.$("inner").css("opacity","0");};
n.prototype._setValueVisible=function(){this.$("inner").css("opacity","1");};
n.prototype.setEnableMultiLineMode=function(e){return this.setProperty("enableMultiLineMode",e,true);};
n.prototype.onmousedown=function(e){if(e.target==this.getDomRef('content')){e.preventDefault();e.stopPropagation();}};
n.prototype._openMultiLineOnDesktop=function(){};
n.prototype.openMultiLine=function(){};
n.prototype.closeMultiLine=function(){};
n.prototype.getScrollDelegate=function(){return this._tokenizer._oScroller;};
n.prototype.onBeforeRendering=function(){var t=this.getAggregation("tokenizer");if(t){t.toggleStyleClass("sapMTokenizerEmpty",t.getTokens().length===0);}I.prototype.onBeforeRendering.apply(this,arguments);this._deregisterResizeHandler();};
n.prototype.addValidator=function(v){this._tokenizer.addValidator(v);};
n.prototype.removeValidator=function(v){this._tokenizer.removeValidator(v);};
n.prototype.removeAllValidators=function(){this._tokenizer.removeAllValidators();};
n.prototype.onsapnext=function(e){if(e.isMarked()){return;}var F=q(document.activeElement).control()[0];if(!F){return;}if(this._tokenizer===F||this._tokenizer.$().find(F.$()).length>0){this._scrollAndFocus();}};
n.prototype.onsapbackspace=function(e){if(this.getCursorPosition()>0||!this.getEditable()||this.getValue().length>0){return;}T.prototype.onsapbackspace.apply(this._tokenizer,arguments);e.preventDefault();e.stopPropagation();};
n.prototype.onsapdelete=function(e){if(!this.getEditable()){return;}if(this.getValue()&&!this._completeTextIsSelected()){return;}T.prototype.onsapdelete.apply(this._tokenizer,arguments);};
n.prototype.onkeydown=function(e){if(e.which===K.TAB){this._tokenizer._changeAllTokensSelection(false);}if((e.ctrlKey||e.metaKey)&&e.which===K.A){if(this._tokenizer.getTokens().length>0){this._tokenizer.focus();this._tokenizer._changeAllTokensSelection(true);e.preventDefault();}}if((e.ctrlKey||e.metaKey)&&(e.which===K.C||e.which===K.INSERT)){this._tokenizer._copy();}if(((e.ctrlKey||e.metaKey)&&e.which===K.X)||(e.shiftKey&&e.which===K.DELETE)){if(this.getEditable()){this._tokenizer._cut();}else{this._tokenizer._copy();}}};
n.prototype.onpaste=function(e){var o,i,v=[],A=[];if(this.getValueHelpOnly()){return;}if(window.clipboardData){o=window.clipboardData.getData("Text");}else{o=e.originalEvent.clipboardData.getData('text/plain');}var s=this._tokenizer._parseString(o);if(s.length<=1){return;}setTimeout(function(){if(s){if(this.fireEvent("_validateOnPaste",{texts:s},true)){var p="";for(i=0;i<s.length;i++){if(s[i]){var t=this._convertTextToToken(s[i],true);if(t){v.push(t);}else{p=s[i];}}}this.updateDomValue(p);for(i=0;i<v.length;i++){if(this._tokenizer._addUniqueToken(v[i])){A.push(v[i]);}}if(A.length>0){this.fireTokenUpdate({addedTokens:A,removedTokens:[],type:T.TokenUpdateType.Added});}}if(A.length){this.cancelPendingSuggest();}}}.bind(this),0);};
n.prototype._convertTextToToken=function(t,C){var e=null,i=null,o=null,O=this._tokenizer.getTokens().length;if(!this.getEditable()){return null;}t=t.trim();if(!t){return null;}if(this._getIsSuggestionPopupOpen()||C){if(this._hasTabularSuggestions()){i=this._oSuggestionTable._oSelectedItem;}else{i=this._getSuggestionItem(t);}}if(i&&i.getText&&i.getKey){o=new a({text:i.getText(),key:i.getKey()});}var p=this;e=this._tokenizer._validateToken({text:t,token:o,suggestionObject:i,validationCallback:function(v){p._bIsValidating=false;if(v){p.setValue("");if(p._bUseDialog&&p._isMultiLineMode&&p._oSuggestionTable.getItems().length===0){var N=p._tokenizer.getTokens().length;if(O<N){p._oSuggPopover._oPopupInput.setValue("");}p._setAllTokenVisible();}}}});return e;};
n.prototype.onsapprevious=function(e){if(this._getIsSuggestionPopupOpen()){return;}if(this.getCursorPosition()===0){if(e.srcControl===this){T.prototype.onsapprevious.apply(this._tokenizer,arguments);e.preventDefault();}}};
n.prototype._scrollAndFocus=function(){this._tokenizer.scrollToEnd();this.$().find("input").focus();};
n.prototype.onsaphome=function(e){if(this._tokenizer._checkFocus()){T.prototype.onsaphome.apply(this._tokenizer,arguments);}};
n.prototype.onsapend=function(e){if(this._tokenizer._checkFocus()){T.prototype.onsapend.apply(this._tokenizer,arguments);e.preventDefault();}};
n.prototype.onsapenter=function(e){if(I.prototype.onsapenter){I.prototype.onsapenter.apply(this,arguments);}var v=true;if(this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()){if(this._hasTabularSuggestions()){v=!this._oSuggestionTable.getSelectedItem();}else{v=!this._getSuggestionsList().getSelectedItem();}}if(v){this._validateCurrentText();}this.focus();};
n.prototype._checkFocus=function(){return this.getDomRef()&&j(this.getDomRef(),document.activeElement);};
n.prototype.onsapfocusleave=function(e){var p=this._oSuggestionPopup,s=this._oSelectedItemPicker,N=false,i=false,o=this._checkFocus(),t,F;if(p instanceof sap.m.Popover){if(e.relatedControlId){t=sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef();N=j(p.getFocusDomRef(),t);i=j(this._tokenizer.getFocusDomRef(),t);if(s){F=j(s.getFocusDomRef(),t);}}}if(!i&&!N){this._tokenizer.scrollToEnd();}I.prototype.onsapfocusleave.apply(this,arguments);if(this._bIsValidating||this._bValueHelpOpen){return;}if(!this._bUseDialog&&!N&&e.relatedControlId!==this.getId()&&e.relatedControlId!==this._tokenizer.getId()){this._validateCurrentText(true);}if(!this._bUseDialog&&this.getEditable()){if(o||N){return;}}if(!F&&!i){this._tokenizer._useCollapsedMode(true);}if(this._oReadOnlyPopover&&this._oReadOnlyPopover.isOpen()&&!i){this._oReadOnlyPopover.close();}this._handleInnerVisibility();};
n.prototype._onDialogClose=function(){this._validateCurrentText();this.setAggregation("tokenizer",this._tokenizer);this._tokenizer.setReverseTokens(false);this._tokenizer.invalidate();};
n.prototype.ontap=function(e){if(document.activeElement===this._$input[0]||document.activeElement===this._tokenizer.getDomRef()){this._tokenizer.selectAllTokens(false);}if(e&&e.isMarked("tokenDeletePress")){return;}I.prototype.ontap.apply(this,arguments);};
n.prototype._onclick=function(e){};
n.prototype.onfocusin=function(e){this._bValueHelpOpen=false;if(e.target===this.getFocusDomRef()){I.prototype.onfocusin.apply(this,arguments);}if(this.getEditable()&&(!e.target.classList.contains("sapMInputValHelp")&&!e.target.classList.contains("sapMInputValHelpInner"))){if(this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()){return;}this._tokenizer._useCollapsedMode(false);this._setValueVisible();this._tokenizer.scrollToEnd();}};
n.prototype.onsapescape=function(e){this._tokenizer.selectAllTokens(false);this.selectText(0,0);I.prototype.onsapescape.apply(this,arguments);};
n.prototype._validateCurrentText=function(e){var t=this.getValue();if(!t||!this.getEditable()){return;}t=t.trim();if(!t){return;}var i=null;if(e||this._getIsSuggestionPopupOpen()){if(this._hasTabularSuggestions()){i=this._oSuggestionTable._oSelectedItem;}else{i=this._getSuggestionItem(t,e);}}var o=null;if(i&&i.getText&&i.getKey){o=new a({text:i.getText(),key:i.getKey()});}var p=this;if(!this.getMaxTokens()||this.getTokens().length<this.getMaxTokens()){this._bIsValidating=true;this._tokenizer._addValidateToken({text:t,token:o,suggestionObject:i,validationCallback:function(v){p._bIsValidating=false;if(v){p.setValue("");}}});}};
n.prototype.getCursorPosition=function(){return this._$input.cursorPos();};
n.prototype._completeTextIsSelected=function(){var i=this._$input[0];if(i.selectionStart!==0){return false;}if(i.selectionEnd!==this.getValue().length){return false;}return true;};
n.prototype._getIsSuggestionPopupOpen=function(){return this._oSuggPopover&&this._oSuggPopover._oPopover.isOpen();};
n.prototype.setEditable=function(e){e=this.validateProperty("editable",e);var t=this._getTokensList();if(e===this.getEditable()){return this;}if(I.prototype.setEditable){I.prototype.setEditable.apply(this,arguments);}this._tokenizer.setEditable(e);if(e){if(this._bUseDialog){this._oSuggPopover._oPopover.addContent(t);}else{this._getSelectedItemsPicker().addContent(t);}t.setMode(m.MultiSelect);}else{t.setMode(m.None);this._getReadOnlyPopover().addContent(t);}return this;};
n.prototype._findItem=function(t,e,o,G){if(!t){return;}if(!(e&&e.length)){return;}t=t.toLowerCase();var p=e.length;for(var i=0;i<p;i++){var s=e[i];var u=G(s);if(!u){continue;}u=u.toLowerCase();if(u===t){return s;}if(!o&&u.indexOf(t)===0){return s;}}};
n.prototype._getSuggestionItem=function(t,e){var o=null;var p=null;if(this._hasTabularSuggestions()){o=this.getSuggestionRows();p=this._findItem(t,o,e,function(s){var u=s.getCells();var v=null;if(u){var i;for(i=0;i<u.length;i++){if(u[i].getText){v=u[i].getText();break;}}}return v;});}else{o=this.getSuggestionItems();p=this._findItem(t,o,e,function(p){return p.getText();});}return p;};
n.getMetadata().forwardAggregation("tokens",{getter:function(){return this._tokenizer;},aggregation:"tokens",forwardBinding:true});
n.prototype.clone=function(){var C,t;this.detachSuggestionItemSelected(this._onSuggestionItemSelected,this);this.detachLiveChange(this._onLiveChange,this);this._tokenizer.detachTokenChange(this._onTokenChange,this);this._tokenizer.detachTokenUpdate(this._onTokenUpdate,this);C=I.prototype.clone.apply(this,arguments);C.destroyAggregation("tokenizer");C._tokenizer=null;t=this._tokenizer.clone();C._tokenizer=t;C.setAggregation("tokenizer",t,true);this._tokenizer.attachTokenChange(this._onTokenChange,this);this._tokenizer.attachTokenUpdate(this._onTokenUpdate,this);C._tokenizer.attachTokenChange(C._onTokenChange,C);C._tokenizer.attachTokenUpdate(C._onTokenUpdate,C);C._tokenizer._handleNMoreIndicatorPress(C._handleIndicatorPress.bind(C));this.attachSuggestionItemSelected(this._onSuggestionItemSelected,this);this.attachLiveChange(this._onLiveChange,this);return C;};
n.prototype.getPopupAnchorDomRef=function(){return this.getDomRef("content");};
n.prototype.setTokens=function(t){var v,V=[],i;if(Array.isArray(t)){for(i=0;i<t.length;i++){v=this.validateAggregation("tokens",t[i],true);M.addAPIParentInfoBegin(t[i],this,"tokens");V.push(v);}this._tokenizer.setTokens(V);for(i=0;i<t.length;i++){M.addAPIParentInfoEnd(t[i]);}}else{throw new Error("\""+t+"\" is of type "+typeof t+", expected array for aggregation tokens of "+this);}return this;};
n.TokenChangeType={Added:"added",Removed:"removed",RemovedAll:"removedAll",TokensChanged:"tokensChanged"};n.WaitForAsyncValidation="sap.m.Tokenizer.WaitForAsyncValidation";n.prototype.getDomRefForValueStateMessage=n.prototype.getPopupAnchorDomRef;
n.prototype.updateInputField=function(N){I.prototype.updateInputField.call(this,N);this.setDOMValue('');};
n.prototype.getAccessibilityInfo=function(){var t=this.getTokens().map(function(o){return o.getText();}).join(" ");var i=I.prototype.getAccessibilityInfo.apply(this,arguments);i.type=r.getText("ACC_CTR_TYPE_MULTIINPUT");i.description=((i.description||"")+" "+t).trim();return i;};
n.prototype._modifySuggestionPicker=function(){var t=this;if(!this._bUseDialog){return;}this._bShowSelectedButton=this._createFilterSelectedButton();this._oSuggPopover._oPopover.addContent(this._getTokensList());this._oSuggPopover._oPopover.attachBeforeOpen(function(){t._manageListsVisibility(t._bShowListWithTokens);t._fillList();t._updatePickerHeaderTitle();}).attachAfterClose(function(){t._tokenizer._useCollapsedMode(true);t._bShowListWithTokens=false;});this._oSuggPopover._oPopover.getCustomHeader().removeAllContentMiddle();this._oSuggPopover._oPopover.destroyCustomHeader(true);this._oSuggPopover._oPopover.setCustomHeader(new d({contentMiddle:[new c()],contentRight:new B({icon:g.getIconURI("decline"),press:function(){t._oSuggPopover._oPopover.close();}})}));this._oSuggPopover._oPopover.setSubHeader(new f({content:[this._oSuggPopover._oPopupInput,this._bShowSelectedButton]}));this._oSuggPopover._oPopupInput.onsapenter=function(e){t._validateCurrentText();t._setValueInvisible();t.onChange(e,null,this.getValue());};this._oSuggPopover._oPopupInput.attachLiveChange(function(){if(t._bShowListWithTokens){t._filterTokens(this.getValue());}t._manageListsVisibility(t._bShowListWithTokens);});};
n.prototype._createFilterSelectedButton=function(){var i=g.getIconURI("multiselect-all"),t=this;return new b({icon:i,press:function(e){t._bShowListWithTokens=e.getSource().getPressed();t._manageListsVisibility(t._bShowListWithTokens);}});};
n.prototype._onBeforeOpenTokensPicker=function(){var p=this._getSelectedItemsPicker(),o=this.getDomRef(),w;this._setValueInvisible();this._fillList();if(o&&p){w=(o.offsetWidth/parseFloat(l.BaseFontSize))+"rem";p.setContentMinWidth(w);}};
n.prototype._onAfterCloseTokensPicker=function(){if(this._oSuggPopover&&!this.getValue()){this._tokenizer._useCollapsedMode(true);this._setValueInvisible();}};
n.prototype.getDialogTitle=function(){var p=this._oSuggPopover._oPopover,H=p&&p.getCustomHeader();if(H){return H.getContentMiddle()[0];}return null;};
n.prototype._updatePickerHeaderTitle=function(){var o,e;e=this.getLabels();if(e.length){o=e[0];if(o&&(typeof o.getText==="function")){this.getDialogTitle().setText(o.getText());}}else{this.getDialogTitle().setText(r.getText("COMBOBOX_PICKER_TITLE"));}};
n.prototype._openSelectedItemsPicker=function(){if(this._bUseDialog){this._oSuggPopover._oPopover.open();}else{var p=this._getSelectedItemsPicker();if(p){p.open();}}this._manageListsVisibility(true);this._setValueVisible();return this;};
n.prototype._getTokensList=function(){if(!this._oSelectedItemsList){this._oSelectedItemsList=this._createTokensList();}return this._oSelectedItemsList;};
n.prototype._getSuggestionsList=function(){return this._oSuggPopover&&this._oSuggPopover._oList;};
n.prototype._createTokensList=function(){return new L({width:"auto",mode:m.MultiSelect,includeItemInSelection:true,rememberSelections:false}).attachBrowserEvent("tap",this._handleItemTap,this).attachSelectionChange(this._handleSelectionLiveChange,this);};
n.prototype._filterTokens=function(v){this._getTokensList().getItems().forEach(function(i){if(i.getTitle().toLowerCase().indexOf(v)>-1){i.setVisible(true);}else{i.setVisible(false);}});};
n.prototype._manageListsVisibility=function(s){this._getTokensList().setVisible(s);this._getSuggestionsList()&&this._getSuggestionsList().setVisible(!s);if(this._bUseDialog){this._bShowSelectedButton.setPressed(s);}};
n.prototype._mapTokenToListItem=function(t){if(!t){return null;}var o=new sap.m.StandardListItem({selected:true,title:t.getText()});o.data("key",t.getKey());o.data("text",t.getText());o.data("tokenId",t.getId());return o;};
n.prototype._fillList=function(){var t=this.getTokens(),o;if(!t){return;}this._getTokensList().removeAllItems();for(var i=0,e=t.length;i<e;i++){var p=t[i],o=this._mapTokenToListItem(p);this._getTokensList().addItem(o);}};
n.prototype._handleIndicatorPress=function(){this._bShowListWithTokens=true;if(this.getEditable()){this._openSelectedItemsPicker();}else{this._fillList();this._getReadOnlyPopover().openBy(this._tokenizer._oIndicator[0]);}};
n.prototype._handleItemTap=function(e){if(q(e.target).hasClass("sapMCbMark")){return;}if(this._bUseDialog){this._oSuggPopover._oPopover.close();}else if(this._oReadOnlyPopover&&this._oReadOnlyPopover.isOpen()){this._oReadOnlyPopover.close();}else{this._getSelectedItemsPicker().close();}};
n.prototype._handleSelectionLiveChange=function(e){var o=e.getParameter("listItem"),i=e.getParameter("selected");this._syncTokensWithSelection(o,i);};
n.prototype._syncTokensWithSelection=function(i,s){if(s){var t=new a({text:i.data("text"),key:i.data("key")});i.data("tokenId",t.getId());this.addToken(t);this.fireTokenUpdate({addedTokens:[t],removedTokens:[],type:T.TokenUpdateType.Added});}else{var S=i.data("tokenId");this.getTokens().some(function(t){if(t.getId()===S){this._tokenizer._onTokenDelete(t);return true;}}.bind(this));}};
n.prototype._getSelectedItemsPicker=function(){if(this._oSelectedItemPicker){return this._oSelectedItemPicker;}this._oSelectedItemPicker=this._createDropdown();if(!this._bUseDialog){this._oSelectedItemPicker.setHorizontalScrolling(false).attachBeforeOpen(this._onBeforeOpenTokensPicker,this).attachAfterClose(this._onAfterCloseTokensPicker,this).addContent(this._getTokensList());}return this._oSelectedItemPicker;};
n.prototype._createDropdown=function(){var o=new P(this._getDropdownSettings());o.setInitialFocus(this);this._decoratePopover(o);return o;};
n.prototype._getReadOnlyPopover=function(){if(!this._oReadOnlyPopover){this._oReadOnlyPopover=this._createReadOnlyPopover();}return this._oReadOnlyPopover;};
n.prototype._createReadOnlyPopover=function(){return new P({showArrow:true,placement:k.Auto,showHeader:false,contentMinWidth:"auto"}).addStyleClass("sapMMultiInputReadOnlyPopover").setInitialFocus(this);};
n.prototype._decoratePopover=function(p){var t=this;p.open=function(){return this.openBy(t);};};
n.prototype._getDropdownSettings=function(){return{showArrow:false,showHeader:false,placement:k.VerticalPreferredBottom,offsetX:0,offsetY:0,bounce:false};};
return n;});
sap.ui.predefine('sap/m/MultiInputRenderer',['./InputRenderer','sap/ui/core/Renderer'],function(I,R){"use strict";var M=R.extend(I);
M.prependInnerContent=function(r,c){r.renderControl(c._tokenizer);};
M.addOuterClasses=function(r,c){I.addOuterClasses.apply(this,arguments);r.addClass("sapMMultiInput");if(c.getTokens().length>0){r.addClass("sapMMultiInputHasTokens");}};
M.getAriaDescribedBy=function(c){var a=I.getAriaDescribedBy.apply(this,arguments),i=c.getAggregation("tokenizer")&&c.getAggregation("tokenizer").getTokensInfoId();if(a){a=a+" "+i;}else{a=i;}return a;};
return M;},true);
sap.ui.predefine('sap/m/NavContainer',['./library','sap/ui/core/Control','sap/ui/core/RenderManager','sap/ui/Device','./NavContainerRenderer',"sap/ui/thirdparty/jquery","sap/base/Log","sap/ui/dom/jquery/Focusable"],function(a,C,R,D,N,q,L){"use strict";
var b=C.extend("sap.m.NavContainer",{metadata:{library:"sap.m",properties:{autoFocus:{type:"boolean",group:"Behavior",defaultValue:true},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},visible:{type:"boolean",group:"Appearance",defaultValue:true},defaultTransitionName:{type:"string",group:"Appearance",defaultValue:"slide"}},defaultAggregation:"pages",aggregations:{pages:{type:"sap.ui.core.Control",multiple:true,singularName:"page"}},associations:{initialPage:{type:"sap.ui.core.Control",multiple:false}},events:{navigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}}}}});
var u=sap.ui.getCore().getConfiguration().getAnimation(),g=function(d){return u?d:0;},h=function(c){return!!(c&&c.getParent());};
b.prototype.init=function(){this._pageStack=[];this._aQueue=[];this._mVisitedPages={};this._mFocusObject={};this._iTransitionsCompleted=0;this._bNeverRendered=true;this._bNavigating=false;this._bRenderingInProgress=false;};
b.prototype.exit=function(){this._mFocusObject=null;};
b.prototype.onBeforeRendering=function(){var p=this.getCurrentPage();if(this._bNeverRendered&&p){var c=p.getId();if(!this._mVisitedPages[c]){this._mVisitedPages[c]=true;var n={from:null,fromId:null,to:p,toId:c,firstTime:true,isTo:false,isBack:false,isBackToPage:false,isBackToTop:false,direction:"initial"};var e=q.Event("BeforeFirstShow",n);e.srcControl=this;e.data=this._oToDataBeforeRendering||{};e.backData={};p._handleEvent(e);e=q.Event("BeforeShow",n);e.srcControl=this;e.data=this._oToDataBeforeRendering||{};e.backData={};p._handleEvent(e);}}};
b.prototype.onAfterRendering=function(){var p=this.getCurrentPage(),f,n,c,e;if(this._bNeverRendered&&p){this._bNeverRendered=false;delete this._bNeverRendered;c=p.getId();if(!this._isInsideAPopup()&&this.getAutoFocus()){f=b._applyAutoFocusTo(c);if(f){this._mFocusObject[c]=f;}}n={from:null,fromId:null,to:p,toId:c,firstTime:true,isTo:false,isBack:false,isBackToTop:false,isBackToPage:false,direction:"initial"};e=q.Event("AfterShow",n);e.srcControl=this;e.data=this._oToDataBeforeRendering||{};e.backData={};p._handleEvent(e);}};
b.prototype._getActualInitialPage=function(){var p=this.getInitialPage();if(p){var c=sap.ui.getCore().byId(p);if(c){return c;}else{L.error("NavContainer: control with ID '"+p+"' was set as 'initialPage' but was not found as a DIRECT child of this NavContainer (number of current children: "+this.getPages().length+").");}}var d=this.getPages();return(d.length>0?d[0]:null);};
b.prototype.getPage=function(p){var P=this.getPages();for(var i=0;i<P.length;i++){if(P[i]&&(P[i].getId()==p)){return P[i];}}return null;};
b.prototype._ensurePageStackInitialized=function(d){if(this._pageStack.length===0){var p=this._getActualInitialPage();if(p){this._pageStack.push({id:p.getId(),isInitial:true,data:d||{}});}}return this._pageStack;};
b.prototype.getCurrentPage=function(){var s=this._ensurePageStackInitialized();if(s.length>=1){return this.getPage(s[s.length-1].id);}else{L.warning(this+": page stack is empty but should have been initialized - application failed to provide a page to display");return undefined;}};
b.prototype.getPreviousPage=function(){var s=this._ensurePageStackInitialized();if(s.length>1){return this.getPage(s[s.length-2].id);}else if(s.length==1){return undefined;}else{L.warning(this+": page stack is empty but should have been initialized - application failed to provide a page to display");}};
b.prototype.currentPageIsTopPage=function(){var s=this._ensurePageStackInitialized();return(s.length===1);};
b.prototype.insertPreviousPage=function(p,t,d){var s=this._ensurePageStackInitialized();if(this._pageStack.length>0){var i=s.length-1;var c={id:p,transition:t,data:d};if(i===0){c.isInitial=true;delete s[s.length-1].isInitial;}s.splice(i,0,c);}else{L.warning(this+": insertPreviousPage called with empty page stack; ignoring");}return this;};
b._applyAutoFocusTo=function(i){var f=q(document.getElementById(i)).firstFocusableDomRef();if(f){f.focus();}return f;};
b.prototype._applyAutoFocus=function(n){var p=n.toId,d,c=n.isBack||n.isBackToPage||n.isBackToTop;if(!n.bFocusInsideFromPage){return;}if(c){d=this._mFocusObject!=null?this._mFocusObject[p]:null;if(d){d.focus();}else{b._applyAutoFocusTo(p);}}else if(n.isTo){b._applyAutoFocusTo(p);}};
b.prototype._afterTransitionCallback=function(n,d,B){var e=q.Event("AfterShow",n);e.data=d||{};e.backData=B||{};e.srcControl=this;n.to._handleEvent(e);e=q.Event("AfterHide",n);e.srcControl=this;n.from._handleEvent(e);this._iTransitionsCompleted++;this._bNavigating=false;if(this.getAutoFocus()){this._applyAutoFocus(n);}this.fireAfterNavigate(n);L.info(this+": _afterTransitionCallback called, to: "+n.toId);if(n.to.hasStyleClass("sapMNavItemHidden")){L.warning(this.toString()+": target page '"+n.toId+"' still has CSS class 'sapMNavItemHidden' after transition. This should not be the case, please check the preceding log statements.");n.to.removeStyleClass("sapMNavItemHidden");}this._dequeueNavigation();};
b.prototype._dequeueNavigation=function(){var n=this._aQueue.shift();if(typeof n==="function"){n();}};
b.prototype._isInPageStack=function(p){return this._pageStack.some(function(P){return P.id===p;});};
b.prototype._safeBackToPage=function(p,t,d,T){var c;if(!this.getPage(p)){return this;}c=this.getCurrentPage();if(c&&c.getId()===p){return this;}if(this._isInPageStack(p)){return this.backToPage(p,d,T);}else{d=d||{};d.safeBackToPage=true;return this.to(p,t,d,T);}};
b.prototype._isFocusInControl=function(c){return q(document.activeElement).closest(c.$()).length>0;};
b.prototype.to=function(p,t,d,T,f){if(p instanceof C){p=p.getId();}if(typeof(t)!=="string"){T=d;d=t;}t=t||this.getDefaultTransitionName();T=T||{};d=d||{};var F={id:p,transition:t,data:d};this._ensurePageStackInitialized(d);if(this._bNavigating){L.info(this.toString()+": Cannot navigate to page "+p+" because another navigation is already in progress. - navigation will be executed after the previous one");this._aQueue.push(q.proxy(function(){this.to(p,t,d,T,true);},this));return this;}if(this._bNeverRendered){this._oToDataBeforeRendering=d;}var o=this.getCurrentPage();if(o&&(o.getId()===p)){L.warning(this.toString()+": Cannot navigate to page "+p+" because this is the current page.");if(f){this._dequeueNavigation();}if(this._pageStack.length===1){this._pageStack[0].transition=F.transition;}return this;}var c=this.getPage(p);if(c){if(!o){L.warning("Navigation triggered to page with ID '"+p+"', but the current page is not known/aggregated by "+this);return this;}var n={from:o,fromId:o.getId(),to:c,toId:p,firstTime:!this._mVisitedPages[p],isTo:true,isBack:false,isBackToTop:false,isBackToPage:false,direction:"to",bFocusInsideFromPage:this._isFocusInControl(o)};if(n.bFocusInsideFromPage){this._mFocusObject[o.getId()]=document.activeElement;}var e=this.fireNavigate(n);if(e){a.closeKeyboard();var E=q.Event("BeforeHide",n);E.srcControl=this;o._handleEvent(E);if(!this._mVisitedPages[p]){E=q.Event("BeforeFirstShow",n);E.srcControl=this;E.data=d||{};E.backData={};c._handleEvent(E);}E=q.Event("BeforeShow",n);E.srcControl=this;E.data=d||{};E.backData={};c._handleEvent(E);this._pageStack.push(F);L.info(this.toString()+": navigating to page '"+p+"': "+c.toString());this._mVisitedPages[p]=true;if(!this.getDomRef()){L.info("'Hidden' 'to' navigation in not-rendered NavContainer "+this.toString());if(this._bRenderingInProgress){setTimeout(this.invalidate.bind(this),0);}return this;}var i;if(!(i=c.getDomRef())||i.parentNode!=this.getDomRef()||R.isPreservedContent(i)){c.addStyleClass("sapMNavItemRendering");L.debug("Rendering 'to' page '"+c.toString()+"' for 'to' navigation");var r=sap.ui.getCore().createRenderManager();r.render(c,this.getDomRef());r.destroy();c.addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemRendering");}var j=b.transitions[t]||b.transitions["slide"];var k=this._iTransitionsCompleted;var l=this;window.setTimeout(function(){if(l&&(l._iTransitionsCompleted<k+1)){L.warning("Transition '"+t+"' 'to' was triggered five seconds ago, but has not yet invoked the end-of-transition callback.");}},g(5000));this._bNavigating=true;var s=(d.safeBackToPage||T.safeBackToPage)?"back":"to";j[s].call(this,o,c,q.proxy(function(){this._afterTransitionCallback(n,d);},this),T);}else{L.info("Navigation to page with ID '"+p+"' has been aborted by the application");}}else{L.warning("Navigation triggered to page with ID '"+p+"', but this page is not known/aggregated by "+this);}return this;};
b.prototype.back=function(c,t){this._backTo("back",c,t);return this;};
b.prototype.backToPage=function(p,c,t){this._backTo("backToPage",c,t,p);return this;};
b.prototype.backToTop=function(c,t){this._backTo("backToTop",c,t);return this;};
b.prototype._backTo=function(t,c,T,r){if(this._bNavigating){L.warning(this.toString()+": Cannot navigate back because another navigation is already in progress. - navigation will be executed after the previous one");this._aQueue.push(q.proxy(function(){this._backTo(t,c,T,r);},this));return this;}if(this._pageStack.length<=1){if(this._pageStack.length===1&&!this._pageStack[0].isInitial){throw new Error("Initial page not found on the stack. How did this happen?");}return this;}else{if(r instanceof C){r=r.getId();}var f=this._pageStack[this._pageStack.length-1];var d=f.transition;var F=this.getPage(f.id);var o;var e;if(t==="backToTop"){o=this._getActualInitialPage();e=null;}else if(t==="backToPage"){var i=this._findClosestPreviousPageInfo(r);if(!i){L.error(this.toString()+": Cannot navigate backToPage('"+r+"') because target page was not found among the previous pages.");return this;}o=sap.ui.getCore().byId(i.id);if(!o){L.error(this.toString()+": Cannot navigate backToPage('"+r+"') because target page does not exist anymore.");return this;}e=i.data;}else{o=this.getPreviousPage();e=this._pageStack[this._pageStack.length-2].data;}if(!o){L.error("NavContainer back navigation: target page is not defined or not aggregated by this NavContainer. Aborting navigation.");return;}var j=o.getId();c=c||{};T=T||{};var n={from:F,fromId:F.getId(),to:o,toId:j,firstTime:!this._mVisitedPages[j],isTo:false,isBack:(t==="back"),isBackToPage:(t==="backToPage"),isBackToTop:(t==="backToTop"),direction:t,bFocusInsideFromPage:this._isFocusInControl(F)};var k=this.fireNavigate(n);if(k){a.closeKeyboard();var E=q.Event("BeforeHide",n);E.srcControl=this;F._handleEvent(E);if(!this._mVisitedPages[j]){E=q.Event("BeforeFirstShow",n);E.srcControl=this;E.backData=c||{};E.data={};o._handleEvent(E);}E=q.Event("BeforeShow",n);E.srcControl=this;E.backData=c||{};E.data=e||{};o._handleEvent(E);this._pageStack.pop();L.info(this.toString()+": navigating back to page "+o.toString());this._mVisitedPages[j]=true;if(t==="backToTop"){this._pageStack=[];L.info(this.toString()+": navigating back to top");this.getCurrentPage();}else if(t==="backToPage"){var p=[],l;while(this._pageStack[this._pageStack.length-1].id!==r){l=this._pageStack.pop();p.push(l.id);}L.info(this.toString()+": navigating back to specific page "+o.toString()+" across the pages: "+p.join(", "));}if(!this.getDomRef()){L.info("'Hidden' back navigation in not-rendered NavContainer "+this.toString());return this;}var m=b.transitions[d]||b.transitions["slide"];var s=this._iTransitionsCompleted;var v=this;window.setTimeout(function(){if(v&&(v._iTransitionsCompleted<s+1)){L.warning("Transition '"+d+"' 'back' was triggered five seconds ago, but has not yet invoked the end-of-transition callback.");}},g(5000));this._bNavigating=true;var w;if(!(w=o.getDomRef())||w.parentNode!=this.getDomRef()||R.isPreservedContent(w)){o.addStyleClass("sapMNavItemRendering");L.debug("Rendering 'to' page '"+o.toString()+"' for back navigation");var x=sap.ui.getCore().createRenderManager();var y=this.$().children().index(F.getDomRef());x.renderControl(o);x.flush(this.getDomRef(),false,y);x.destroy();o.addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemRendering");}if(F.getId()===o.getId()){L.info("Transition is skipped when navigating back to the same page instance"+o.toString());this._afterTransitionCallback(n,e,c);return this;}m.back.call(this,F,o,q.proxy(function(){this._afterTransitionCallback(n,e,c);},this),T);}}return this;};
b.prototype._findClosestPreviousPageInfo=function(r){for(var i=this._pageStack.length-2;i>=0;i--){var c=this._pageStack[i];if(c.id===r){return c;}}return null;};
b.transitions=b.transitions||{};b.transitions["show"]={to:function(f,t,c){t.removeStyleClass("sapMNavItemHidden");f&&f.addStyleClass("sapMNavItemHidden");c();},back:function(f,t,c){t.removeStyleClass("sapMNavItemHidden");f&&f.addStyleClass("sapMNavItemHidden");c();}};b.transitions["slide"]={to:function(f,t,c){f.addStyleClass("sapMNavItemCenter");window.setTimeout(function(){t.addStyleClass("sapMNavItemRight");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).unbind("webkitTransitionEnd transitionend");if(!o){o=true;}else{T=false;if(h(t)){t.removeStyleClass("sapMNavItemSliding").removeStyleClass("sapMNavItemCenter");}if(h(f)){f.removeStyleClass("sapMNavItemSliding").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemLeft");}c();}};f.$().bind("webkitTransitionEnd transitionend",A);t.$().bind("webkitTransitionEnd transitionend",A);t.addStyleClass("sapMNavItemSliding").addStyleClass("sapMNavItemCenter").removeStyleClass("sapMNavItemRight");f.addStyleClass("sapMNavItemSliding").removeStyleClass("sapMNavItemCenter").addStyleClass("sapMNavItemLeft");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(400));},g(60));},0);},back:function(f,t,c){t.addStyleClass("sapMNavItemLeft");t.removeStyleClass("sapMNavItemHidden");f.addStyleClass("sapMNavItemCenter");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).unbind("webkitTransitionEnd transitionend");if(!o){o=true;}else{T=false;if(h(t)){t.removeStyleClass("sapMNavItemSliding").removeStyleClass("sapMNavItemCenter");}if(h(f)){f.removeStyleClass("sapMNavItemSliding").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemRight");}c();}};f.$().bind("webkitTransitionEnd transitionend",A);t.$().bind("webkitTransitionEnd transitionend",A);if(D.browser.webkit){window.setTimeout(function(){t.$().css("box-shadow","0em 1px 0em rgba(128, 128, 1280, 0.1)");window.setTimeout(function(){t.$().css("box-shadow","");},g(50));},0);}t.addStyleClass("sapMNavItemSliding").addStyleClass("sapMNavItemCenter").removeStyleClass("sapMNavItemLeft");f.addStyleClass("sapMNavItemSliding").removeStyleClass("sapMNavItemCenter").addStyleClass("sapMNavItemRight");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(400));},g(100));}};b.transitions["fade"]={to:function(f,t,c){t.addStyleClass("sapMNavItemTransparent");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var A=null;var T=true;A=function(){q(this).unbind("webkitTransitionEnd transitionend");T=false;if(h(f)){f.addStyleClass("sapMNavItemHidden");}if(h(t)){t.removeStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemOpaque");}c();};t.$().bind("webkitTransitionEnd transitionend",A);t.addStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemTransparent").addStyleClass("sapMNavItemOpaque");window.setTimeout(function(){if(T){A.apply(t.$());}},g(600));},g(10));},back:function(f,t,c){f.addStyleClass("sapMNavItemOpaque");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var A=null;var T=true;A=function(){q(this).unbind("webkitTransitionEnd transitionend");T=false;if(h(f)){f.removeStyleClass("sapMNavItemFading").addStyleClass("sapMNavItemHidden");f.removeStyleClass("sapMNavItemTransparent");}c();};f.$().bind("webkitTransitionEnd transitionend",A);f.addStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemOpaque");f.addStyleClass("sapMNavItemTransparent");window.setTimeout(function(){if(T){A.apply(t.$());}},g(600));},g(10));}};b.transitions["flip"]={to:function(f,t,c){var d=this;window.setTimeout(function(){d.$().addClass("sapMNavFlip");t.addStyleClass("sapMNavItemFlipNext");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).unbind("webkitTransitionEnd transitionend");if(!o){o=true;}else{T=false;if(h(t)){t.removeStyleClass("sapMNavItemFlipping");}if(h(f)){f.removeStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemFlipPrevious");}d.$().removeClass("sapMNavFlip");c();}};f.$().bind("webkitTransitionEnd transitionend",A);t.$().bind("webkitTransitionEnd transitionend",A);t.addStyleClass("sapMNavItemFlipping").removeStyleClass("sapMNavItemFlipNext");f.addStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemFlipPrevious");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(600));},g(60));},0);},back:function(f,t,c){var d=this;d.$().addClass("sapMNavFlip");t.addStyleClass("sapMNavItemFlipPrevious");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).unbind("webkitTransitionEnd transitionend");if(!o){o=true;}else{T=false;if(h(t)){t.removeStyleClass("sapMNavItemFlipping");}if(h(f)){f.removeStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemFlipNext");}d.$().removeClass("sapMNavFlip");c();}};f.$().bind("webkitTransitionEnd transitionend",A);t.$().bind("webkitTransitionEnd transitionend",A);t.addStyleClass("sapMNavItemFlipping").removeStyleClass("sapMNavItemFlipPrevious");f.addStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemFlipNext");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(600));},g(60));}};b.transitions["door"]={to:function(f,t,c){var d=this;window.setTimeout(function(){d.$().addClass("sapMNavDoor");t.addStyleClass("sapMNavItemDoorInNext");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).unbind("webkitAnimationEnd animationend");if(!o){o=true;}else{T=false;if(h(t)){t.removeStyleClass("sapMNavItemDooring").removeStyleClass("sapMNavItemDoorInNext");}if(h(f)){f.removeStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemDoorInPrevious");}d.$().removeClass("sapMNavDoor");c();}};f.$().bind("webkitAnimationEnd animationend",A);t.$().bind("webkitAnimationEnd animationend",A);t.addStyleClass("sapMNavItemDooring");f.addStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemDoorInPrevious");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(1000));},g(60));},0);},back:function(f,t,c){var d=this;d.$().addClass("sapMNavDoor");t.addStyleClass("sapMNavItemDoorOutNext");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).unbind("webkitAnimationEnd animationend");if(!o){o=true;}else{T=false;if(h(t)){t.removeStyleClass("sapMNavItemDooring").removeStyleClass("sapMNavItemDoorOutNext");}if(h(f)){f.removeStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemDoorOutPrevious");}d.$().removeClass("sapMNavDoor");c();}};f.$().bind("webkitAnimationEnd animationend",A);t.$().bind("webkitAnimationEnd animationend",A);t.addStyleClass("sapMNavItemDooring");f.addStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemDoorOutPrevious");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(1000));},g(60));}};
b.prototype.addCustomTransition=function(n,t,B){if(b.transitions[n]){L.warning("Transition with name "+n+" already exists in "+this+". It is now being replaced by custom transition.");}b.transitions[n]={to:t,back:B};return this;};
b.addCustomTransition=b.prototype.addCustomTransition;b.prototype.forceInvalidation=b.prototype.invalidate;
b.prototype.invalidate=function(s){if(s==this){}else if(!s){this.forceInvalidation();}else if(s instanceof C){var I=false,p=this.getPages(),l=p.length;for(var i=0;i<l;i++){if(p[i]===s){I=true;break;}}if((!I||s===this.getCurrentPage())&&!this._isInsideAPopup()){this.forceInvalidation();}}else{this.forceInvalidation();}};
b.prototype._isInsideAPopup=function(){var s;s=function(c){if(!c){return false;}if(c.getMetadata().isInstanceOf("sap.ui.core.PopupInterface")){return true;}return s(c.getParent());};return s(this);};
b.prototype.removePage=function(p){var P;if(typeof(p)=="number"){P=this.getPages()[p];}else if(typeof(p)=="string"){P=sap.ui.getCore().byId(p);}else{P=p;}P=this.removeAggregation("pages",P,P!==this.getCurrentPage());this._onPageRemoved(P);return P;};
b.prototype._onPageRemoved=function(p){if(!p){return;}p.$().remove();p.removeStyleClass("sapMNavItemHidden");p.removeStyleClass("sapMNavItem");var s=this._ensurePageStackInitialized();this._pageStack=s.filter(function(P){return p.getId()!==P.id;});};
b.prototype.removeAllPages=function(){var p=this.getPages();if(!p){return[];}for(var i=0;i<p.length;i++){this._onPageRemoved(p[i]);}return this.removeAllAggregation("pages");};
b.prototype.addPage=function(p){var P=this.getPages();if(P.indexOf(p)>-1){return this;}this.addAggregation("pages",p,true);p.addStyleClass("sapMNavItem");var i=P.length;if(i===0&&this.getPages().length===1){this._fireAdaptableContentChange(p);if(this.getDomRef()){this._ensurePageStackInitialized();this.rerender();}}return this;};
b.prototype.insertPage=function(p,i){var P=this.getPages().length;this.insertAggregation("pages",p,i,true);p.addStyleClass("sapMNavItem");if(P===0&&this.getPages().length===1){this._fireAdaptableContentChange(p);if(this.getDomRef()){this._ensurePageStackInitialized();this.rerender();}}return this;};
b.prototype._getAdaptableContent=function(){return this.getCurrentPage();};
b.prototype._fireAdaptableContentChange=function(p){if(p&&this.mEventRegistry["_adaptableContentChange"]){this.fireEvent("_adaptableContentChange",{"parent":this,"adaptableContent":p});}};
return b;});
sap.ui.predefine('sap/m/NavContainerRenderer',[],function(){"use strict";var N={};
N.render=function(r,c){c._bRenderingInProgress=true;if(!c.getVisible()){return;}r.write("<div");r.writeControlData(c);r.addClass("sapMNav");if(c.getWidth()){r.addStyle("width",c.getWidth());}var h=c.getHeight();if(h&&h!="100%"){r.addStyle("height",h);}if(this.renderAttributes){this.renderAttributes(r,c);}r.writeClasses();r.writeStyles();var t=c.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}r.write(">");if(this.renderBeforeContent){this.renderBeforeContent(r,c);}var C=c.getCurrentPage();if(C){C.removeStyleClass("sapMNavItemHidden");r.renderControl(C);}r.write("</div>");c._bRenderingInProgress=false;};
return N;},true);
sap.ui.predefine('sap/m/NewsContent',['./library','sap/ui/core/Control','sap/m/Text','sap/ui/Device','./NewsContentRenderer',"sap/ui/events/KeyCodes"],function(l,C,T,D,N,K){"use strict";
var a=C.extend("sap.m.NewsContent",{metadata:{library:"sap.m",designtime:"sap/m/designtime/NewsContent.designtime",properties:{"size":{type:"sap.m.Size",group:"Misc",defaultValue:"Auto"},"contentText":{type:"string",group:"Misc",defaultValue:null},"subheader":{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"_contentText",aggregations:{"_contentText":{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{"press":{}}}});
a.prototype.init=function(){this._oContentText=new T(this.getId()+"-content-text",{maxLines:2});this._oContentText.cacheLineHeight=false;this.setAggregation("_contentText",this._oContentText,true);this.setTooltip("{AltText}");};
a.prototype.onBeforeRendering=function(){this._setPointerOnContentText();this.$().unbind("mouseenter");this.$().unbind("mouseleave");};
a.prototype.onAfterRendering=function(){this.$().bind("mouseenter",this._addTooltip.bind(this));this.$().bind("mouseleave",this._removeTooltip.bind(this));};
a.prototype._addTooltip=function(){this.$().attr("title",this.getTooltip_AsString());};
a.prototype._removeTooltip=function(){this.$().attr("title",null);};
a.prototype._setPointerOnContentText=function(){var t=this.getAggregation("_contentText");if(t&&this.hasListeners("press")){t.addStyleClass("sapMPointer");}else if(t&&t.hasStyleClass("sapMPointer")){t.removeStyleClass("sapMPointer");}};
a.prototype.getAltText=function(){var A="";var i=true;if(this.getAggregation("_contentText").getText()){A+=this.getAggregation("_contentText").getText();i=false;}if(this.getSubheader()){if(i){A+=""+this.getSubheader();}else{A+="\n"+this.getSubheader();}}return A;};
a.prototype.getTooltip_AsString=function(){var t=this.getTooltip();var s=this.getAltText();if(typeof t==="string"||t instanceof String){s=t.split("{AltText}").join(s).split("((AltText))").join(s);return s;}if(t){return t;}else{return"";}};
a.prototype.setContentText=function(t){this._oContentText.setText(t);return this.setProperty("contentText",t,true);};
a.prototype.ontap=function(e){if(D.browser.msie){this.$().focus();}this.firePress();};
a.prototype.onkeydown=function(e){if(e.which===K.ENTER||e.which===K.SPACE){this.firePress();e.preventDefault();}};
a.prototype.attachEvent=function(e,d,f,b){C.prototype.attachEvent.call(this,e,d,f,b);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapMPointer");this._setPointerOnContentText();}return this;};
a.prototype.detachEvent=function(e,f,b){C.prototype.detachEvent.call(this,e,f,b);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapMPointer");this._setPointerOnContentText();}return this;};
return a;});
sap.ui.predefine('sap/m/NewsContentRenderer',[],function(){"use strict";var N={};
N.render=function(r,c){var s=c.getSubheader();var t=c.getTooltip_AsString();if(typeof t!=="string"){t="";}r.write("<div");r.writeControlData(c);r.writeAttribute("role","presentation");r.writeAttributeEscaped("aria-label",t);r.addClass("sapMNwC");if(c.hasListeners("press")){r.addClass("sapMPointer");r.writeAttribute("tabindex","0");}r.writeClasses();r.write(">");r.write("<div");r.addClass("sapMNwCCTxt");r.writeClasses();r.write(">");r.renderControl(c._oContentText);r.write("</div>");r.write("<div");r.writeAttribute("id",c.getId()+"-subheader");r.addClass("sapMNwCSbh");r.writeClasses();r.write(">");r.writeEscaped(s);r.write("</div>");r.write("</div>");};
return N;},true);
sap.ui.predefine('sap/m/NotificationListBase',['./library','sap/ui/core/Control','./ListItemBase','./Text','./Image','./OverflowToolbar','sap/ui/core/Icon','sap/ui/core/library','sap/ui/core/Element'],function(l,C,L,T,I,O,a,c,E){'use strict';var P=c.Priority;
var N=L.extend('sap.m.NotificationListBase',{metadata:{library:'sap.m',properties:{priority:{type:'sap.ui.core.Priority',group:'Appearance',defaultValue:P.None},title:{type:'string',group:'Appearance',defaultValue:''},datetime:{type:'string',group:'Appearance',defaultValue:''},showButtons:{type:'boolean',group:'Behavior',defaultValue:true},showCloseButton:{type:'boolean',group:'Behavior',defaultValue:true},authorName:{type:'string',group:'Appearance',defaultValue:''},authorPicture:{type:'sap.ui.core.URI',multiple:false}},aggregations:{buttons:{type:'sap.m.Button',multiple:true},_headerTitle:{type:'sap.m.Text',multiple:false,visibility:"hidden"},_dateTime:{type:'sap.m.Text',multiple:false,visibility:'hidden'},_authorName:{type:'sap.m.Text',multiple:false,visibility:"hidden"},_authorImage:{type:'sap.ui.core.Control',multiple:false,visibility:"hidden"},_overflowToolbar:{type:'sap.m.OverflowToolbar',multiple:false,visibility:"hidden"},_closeButton:{type:'sap.m.Button',multiple:false,visibility:"hidden"},_collapseButton:{type:'sap.m.Button',multiple:false,visibility:"hidden"}},events:{close:{}}}});
N.prototype.init=function(){this.setAggregation('_overflowToolbar',new O());};
N.prototype.setTitle=function(t){var r=this.setProperty('title',t);this._getHeaderTitle().setText(t);return r;};
N.prototype.setDatetime=function(d){var r=this.setProperty('datetime',d);this._getDateTimeText().setText(d);return r;};
N.prototype.setAuthorName=function(b){var r=this.setProperty('authorName',b);this._getAuthorName().setText(b);return r;};
N.prototype.close=function(){var p=this.getParent();this.fireClose();if(p&&p instanceof E){var d={onAfterRendering:function(){p.focus();p.removeEventDelegate(d);}};p.addEventDelegate(d);}};
N.prototype.clone=function(){var b=C.prototype.clone.apply(this,arguments);b.destroyAggregation('_overflowToolbar');var o=this.getAggregation('_overflowToolbar');b.setAggregation("_overflowToolbar",o.clone(),true);return b;};
N.getMetadata().forwardAggregation("buttons",{getter:function(){return this.getAggregation('_overflowToolbar');},aggregation:"content",forwardBinding:true});
N.prototype._getHeaderTitle=function(){var t=this.getAggregation("_headerTitle");if(!t){t=new T({id:this.getId()+'-title',text:this.getTitle(),maxLines:2});this.setAggregation("_headerTitle",t,true);}return t;};
N.prototype._getDateTimeText=function(){var d=this.getAggregation('_dateTime');if(!d){d=new T({id:this.getId()+'-datetime',text:this.getDatetime()}).addStyleClass('sapMNLI-Datetime');this.setAggregation('_dateTime',d,true);}return d;};
N.prototype._getAuthorName=function(){var b=this.getAggregation('_authorName');if(!b){b=new T({text:this.getAuthorName()}).addStyleClass('sapMNLI-Text');this.setAggregation('_authorName',b,true);}return b;};
N.prototype._getAuthorImage=function(){var b=this.getAggregation('_authorImage');if(!b){var d=this.getAuthorPicture();var e=this.getAuthorName();if(i(d)){b=new a({src:d,alt:e});}else{b=new I({src:d,alt:e});}this.setAggregation('_authorImage',b,true);}return b;};
N.prototype._getToolbar=function(){var t=this.getAggregation("_overflowToolbar");if(!t){t=new O();this.setAggregation("_overflowToolbar",t,true);}return t;};
function i(s){if(!s){return false;}var r=window.URI.parse(s);return(r.protocol&&r.protocol=='sap-icon');}
return N;});
sap.ui.predefine('sap/m/NotificationListGroup',['./library','./NotificationListBase','sap/ui/core/InvisibleText','./ListItemBase','sap/ui/core/IconPool','sap/ui/core/library','sap/ui/Device','sap/m/Button','./NotificationListGroupRenderer',"sap/ui/events/KeyCodes"],function(l,N,I,L,a,c,D,B,b,K){'use strict';var P=c.Priority;var d=l.ButtonType;
var e=N.extend('sap.m.NotificationListGroup',{metadata:{library:'sap.m',properties:{collapsed:{type:'boolean',group:'Behavior',defaultValue:false},autoPriority:{type:'boolean',group:'Behavior',defaultValue:true},showEmptyGroup:{type:'boolean',group:'Behavior',defaultValue:false},enableCollapseButtonWhenEmpty:{type:'boolean',group:'Behavior',defaultValue:false}},defaultAggregation:'items',aggregations:{items:{type:'sap.m.NotificationListItem',multiple:true,singularName:'item'},_ariaDetailsText:{type:'sap.ui.core.InvisibleText',multiple:false,visibility:'hidden'}},events:{onCollapse:{parameters:{collapsed:{type:'boolean'}}}}}});
e.prototype.init=function(){N.prototype.init.call(this);var r=sap.ui.getCore().getLibraryResourceBundle('sap.m');this._closeText=r.getText('NOTIFICATION_LIST_BASE_CLOSE');var _=new B(this.getId()+'-closeButton',{type:d.Transparent,icon:a.getIconURI('decline'),tooltip:this._closeText,press:function(){this.close();}.bind(this)});this.setAggregation('_closeButton',_,true);var g=new B({type:d.Transparent,press:function(){this.setCollapsed(!this.getCollapsed());}.bind(this)});this.setAggregation('_collapseButton',g,true);this._maxNumberReached=false;this._ariaLabbeledByIds='';this.setAggregation('_ariaDetailsText',new I());this._resourceBundle=sap.ui.getCore().getLibraryResourceBundle('sap.m');};
e.prototype.setCollapsed=function(g){this._toggleCollapsed();this.setProperty('collapsed',g,true);this.fireOnCollapse({collapsed:g});return this;};
e.prototype.getPriority=function(){if(!this.getAutoPriority()){return this.getProperty('priority');}var n=this.getAggregation('items');var p=P.None;if(n){n.forEach(function(i){p=f(p,i.getPriority());});}else{p=this.getProperty('priority');}return p;};
e.prototype.getUnread=function(){var n=this.getItems();if(n.length){return n.some(function(i){return i.getUnread();});}return this.getProperty('unread');};
e.prototype.onBeforeRendering=function(){var n=this.getItems();var g=n.length;var h=this.getAggregation('_collapseButton');this._maxNumberOfNotifications=D.system.desktop?400:100;h.setEnabled(this._getCollapseButtonEnabled(),true);this._maxNumberReached=g>this._maxNumberOfNotifications;n.forEach(function(i){i.addEventDelegate({onfocusin:this._notificationFocusHandler},this);i.addEventDelegate({onkeydown:this._notificationNavigationHandler},this);}.bind(this));this._updateAccessibilityInfo();this._updateCollapseButtonText(this.getCollapsed());this._maxNumberOfNotificationsTitle=this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_MAX_NOTIFICATIONS_TITLE',g-this._maxNumberOfNotifications);this._maxNumberOfNotificationsBody=this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_MAX_NOTIFICATIONS_BODY');};
e.prototype._getHeaderTitle=function(){var t=N.prototype._getHeaderTitle.call(this);t.addStyleClass('sapMNLG-Title');if(this.getUnread()){t.addStyleClass('sapMNLGTitleUnread');}return t;};
e.prototype._getDateTimeText=function(){var g=N.prototype._getDateTimeText.call(this);g.setTextAlign('End');return g;};
e.prototype._toggleCollapsed=function(){var n=!this.getCollapsed();this._updateCollapseButtonText(n);this.$().toggleClass('sapMNLG-Collapsed',n);this.$().toggleClass('sapMNLG-NoNotifications',this._getVisibleItemsCount()<=0);};
e.prototype._getVisibleItemsCount=function(){var i=this.getItems();var r=0;i.forEach(function(g){if(g.getVisible()){r+=1;}});return r;};
e.prototype._getCollapseButtonEnabled=function(){if(this._getVisibleItemsCount()>0){return true;}return this.getEnableCollapseButtonWhenEmpty();};
e.prototype._notificationFocusHandler=function(g){L.prototype.onfocusin.call(this,g);var t=g.srcControl;if(t.getMetadata().getName()!='sap.m.NotificationListItem'){return;}var n=t.getParent();var v=n.getItems().filter(function(j){return j.getVisible();});var h=v.indexOf(t);var i=t.getDomRef();i.setAttribute('aria-posinset',h+1);i.setAttribute('aria-setsize',v.length);};
e.prototype._notificationNavigationHandler=function(g){L.prototype.onkeydown.call(this,g);var t=g.srcControl;if(t.getMetadata().getName()!='sap.m.NotificationListItem'){return;}var n=t.getParent();var h=n.indexOfItem(t);switch(g.which){case K.ARROW_UP:if(h==0){return;}var p=h-1;n.getItems()[p].focus();break;case K.ARROW_DOWN:var i=h+1;if(i==n.getItems().length){return;}n.getItems()[i].focus();break;default:return;}};
e.prototype._updateAccessibilityInfo=function(){var g=this.getAuthorName();var i=this._resourceBundle.getText('NOTIFICATION_LIST_ITEM_DATETIME_PRIORITY',[this.getDatetime(),this.getPriority()]);var u=this.getUnread()?this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_UNREAD'):this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_READ');var h='';var j=this.getAggregation('_ariaDetailsText');if(g){h+=this._resourceBundle.getText('NOTIFICATION_LIST_ITEM_CREATED_BY')+' '+g+' ';}h+=i+' '+u;j.setText(h);this._ariaLabbeledByIds=this._getHeaderTitle().getId()+' '+j.getId();};
e.prototype._updateCollapseButtonText=function(g){var h=g?this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_EXPAND'):this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_COLLAPSE');this.getAggregation('_collapseButton').setText(h,true);};
function f(g,s){if(g==s){return g;}if((g=='None')){return s;}if((g=='Low')&&(s!='None')){return s;}if((g=='Medium')&&(s!='None'&&s!='Low')){return s;}return g;}
return e;});
sap.ui.predefine('sap/m/NotificationListGroupRenderer',["sap/ui/core/library"],function(c){'use strict';var P=c.Priority;var N={};var a='sapMNLG';var b='sapMNLB';var d='sapMLIB';var e='sapMNLB-AuthorPicture';var f='sapMNLG-GroupHeader';var g='sapMNLB-Header';var h='sapMNLG-Header';var i='sapMNLG-Body';var j='sapMNLB-SubHeader';var k='sapMNLG-SubHeader';var l='sapMNLB-CloseButton';var m='sapMNLB-Priority';var n='sapMNLG-Details';var o='sapMNLB-Bullet';var p='sapMNLG-Description';var q='sapMNLG-Collapsed';var r='sapMNLGNoHdrFooter';var s='sapMNLG-MaxNotifications';var t='sapMNLG-NoNotifications';
N.render=function(R,C){if(C.getVisible()){var v=C._getVisibleItemsCount();var _=C.getShowEmptyGroup()||(v>0);R.write('<li');R.addClass(a);R.addClass(b);R.addClass(d);if(!_){R.addClass(r);}if(C.getCollapsed()){R.addClass(q);}if(v==0){R.addClass(t);}R.writeClasses();R.writeControlData(C);R.writeAttribute('tabindex','0');R.writeAccessibilityState(C,{labelledby:C._ariaLabbeledByIds});R.write('>');if(_){R.write('<div');R.addClass(f);R.writeClasses();R.write('>');this.renderHeader(R,C);this.renderSubHeader(R,C);R.write('</div>');this.renderBody(R,C);}R.write('</li>');}else{this.renderInvisibleItem(R,C);}};
N.renderHeader=function(R,C){R.write('<div');R.addClass(g);R.addClass(h);R.writeClasses();R.write('>');this.renderInvisibleInfoText(R,C);this.renderPriorityArea(R,C);this.renderCloseButton(R,C);this.renderTitle(R,C);this.renderDetails(R,C);R.write('</div>');};
N.renderTitle=function(R,C){R.renderControl(C._getHeaderTitle());};
N.renderCloseButton=function(R,C){if(C.getShowCloseButton()){R.renderControl(C.getAggregation('_closeButton').addStyleClass(l));}};
N.renderAuthorPicture=function(R,C){if(!C.getAuthorPicture()){return;}R.write('<div');R.addClass(e);R.writeClasses();R.write('>');R.renderControl(C._getAuthorImage());R.write('</div>');};
N.renderDetails=function(R,C){R.write('<div class="'+n+'">');this.renderAuthorPicture(R,C);R.write('<div class="'+p+'">');this.renderAuthorName(R,C);if(C.getAuthorName()!=""&&C.getDatetime()!=""){R.write('<span class="'+o+'">&#x00B7</span>');}this.renderDatetime(R,C);R.write('</div></div>');};
N.renderInvisibleInfoText=function(R,C){R.renderControl(C.getAggregation('_ariaDetailsText'));};
N.renderAuthorName=function(R,C){R.renderControl(C._getAuthorName());};
N.renderSubHeader=function(R,C){var u=C.getButtons();R.write('<div');R.addClass(k);R.addClass(j);R.writeClasses();R.write('>');this.renderPriorityArea(R,C);this.renderCollapseGroupButton(R,C);if(u&&u.length&&C.getShowButtons()){R.renderControl(C.getAggregation('_overflowToolbar'));}R.write('</div>');};
N.renderPriorityArea=function(R,C){R.write('<div');var u='';var v=C.getPriority();switch(v){case(P.Low):u='sapMNLB-Low';break;case(P.Medium):u='sapMNLB-Medium';break;case(P.High):u='sapMNLB-High';break;default:u='sapMNLB-None';break;}R.addClass(m);R.addClass(u);R.writeClasses();R.write('>');R.write('</div>');};
N.renderCollapseGroupButton=function(R,C){R.renderControl(C.getAggregation('_collapseButton'));};
N.renderInvisibleItem=function(R,C){R.write("<li");R.writeInvisiblePlaceholderData(C);R.write(">");R.write("</li>");};
N.renderBody=function(R,C){R.write('<ul class='+i+'>');this.renderNotifications(R,C);if(C._maxNumberReached){this.renderMaxNumberReachedMessage(R,C);}R.write('</ul>');};
N.renderDatetime=function(R,C){R.renderControl(C._getDateTimeText());};
N.renderNotifications=function(R,C){var u=C.getItems();var v=u.length;if(v){for(var w=0;w<C._maxNumberOfNotifications;w++){R.renderControl(u[w]);}}};
N.renderMaxNumberReachedMessage=function(R,C){var u='<span>'+C._maxNumberOfNotificationsTitle+'</span> <br>'+C._maxNumberOfNotificationsBody;R.write('<div');R.addClass(s);R.writeClasses();R.write('>');R.write(u);R.write('</div>');};
return N;},true);
sap.ui.predefine('sap/m/NotificationListItem',['./library','sap/ui/Device','./NotificationListBase','sap/ui/core/InvisibleText','sap/ui/core/IconPool','sap/ui/core/ResizeHandler','sap/m/Button','./NotificationListItemRenderer'],function(l,D,N,I,a,R,B,b){'use strict';var c=l.ButtonType;
var d=N.extend('sap.m.NotificationListItem',{metadata:{library:'sap.m',properties:{description:{type:'string',group:'Appearance',defaultValue:''},truncate:{type:'boolean',group:'Appearance',defaultValue:true},hideShowMoreButton:{type:'boolean',group:'Appearance',defaultValue:false}},aggregations:{processingMessage:{type:'sap.m.MessageStrip',multiple:false},_bodyText:{type:'sap.m.Text',multiple:false,visibility:"hidden"}}}});
d.prototype.init=function(){N.prototype.init.call(this);var r=sap.ui.getCore().getLibraryResourceBundle('sap.m');this._expandText=r.getText('NOTIFICATION_LIST_ITEM_SHOW_MORE');this._collapseText=r.getText('NOTIFICATION_LIST_ITEM_SHOW_LESS');this._closeText=r.getText('NOTIFICATION_LIST_BASE_CLOSE');this.setType('Active');var _=new B(this.getId()+'-closeButton',{type:c.Transparent,icon:a.getIconURI('decline'),tooltip:this._closeText,press:function(){this.close();}.bind(this)});this.setAggregation("_closeButton",_,true);var e=new B({type:c.Transparent,text:this.getTruncate()?this._expandText:this._collapseText,id:this.getId()+'-expandCollapseButton',press:function(){this._deregisterResize();this.setProperty("truncate",!this.getTruncate(),true);e.setText(this.getTruncate()?this._expandText:this._collapseText);this.$().find('.sapMNLI-Header').toggleClass('sapMNLI-TitleWrapper--is-expanded');this.$().find('.sapMNLI-TextWrapper').toggleClass('sapMNLI-TextWrapper--is-expanded',this.getDescription());this._registerResize();}.bind(this)});this.setAggregation("_collapseButton",e,true);this._ariaDetailsText=new I({id:this.getId()+'-info'}).toStatic();};
d.prototype.setDescription=function(e){var r=this.setProperty('description',e);this._getDescriptionText().setText(e);return r;};
d.prototype.setDatetime=function(e){var r=N.prototype.setDatetime.call(this,e);this._updateAriaAdditionalInfo();return r;};
d.prototype.setUnread=function(u){var r=this.setProperty('unread',u,true);var t=this.getAggregation('_headerTitle');if(t){t.toggleStyleClass('sapMNLI-Unread',this.getUnread());}return r;};
d.prototype.setPriority=function(p,s){var r=this.setProperty('priority',p,s);this._updateAriaAdditionalInfo();return r;};
d.prototype.setAuthorPicture=function(e,s){var r=this.setProperty('authorPicture',e,s);this._getAuthorImage().setSrc(e);return r;};
d.prototype.onBeforeRendering=function(){this._updateAriaAdditionalInfo();this._deregisterResize();};
d.prototype.onAfterRendering=function(){this._registerResize();};
d.prototype.onfocusin=function(e){if(!D.browser.msie){return;}var t=e.target;if(t!==this.getDomRef()&&!t.classList.contains('sapMBtn')){e.preventDefault();e.stopImmediatePropagation();this.focus();}};
d.prototype.exit=function(){this._deregisterResize();if(this._ariaDetailsText){this._ariaDetailsText.destroy();this._ariaDetailsText=null;}};
d.prototype._getDescriptionText=function(){var e=this.getAggregation('_bodyText');if(!e){e=new sap.m.Text({id:this.getId()+'-body',text:this.getDescription(),maxLines:2}).addStyleClass('sapMNLI-Text');this.setAggregation("_bodyText",e,true);}return e;};
d.prototype._activeHandling=function(){this.$().toggleClass("sapMNLIActive",this._active);};
d.prototype._updateAriaAdditionalInfo=function(){var r=sap.ui.getCore().getLibraryResourceBundle('sap.m');var e=this.getUnread()?r.getText('NOTIFICATION_LIST_ITEM_UNREAD'):r.getText('NOTIFICATION_LIST_ITEM_READ');var f=r.getText('NOTIFICATION_LIST_ITEM_DATETIME_PRIORITY',[this.getDatetime(),this.getPriority()]);var g=this.getAuthorName();var h=e+' ';if(g){h+=r.getText('NOTIFICATION_LIST_ITEM_CREATED_BY')+' '+this.getAuthorName()+' ';}h+=f;this._ariaDetailsText.setText(h);};
d.prototype._canTruncate=function(){var t=this.getDomRef('title').offsetHeight;var e=this.getDomRef('title').parentElement.offsetHeight;var f;var g;if(this._getDescriptionText().getText()){f=this.getDomRef("body").offsetHeight;g=this.getDomRef("body").parentElement.offsetHeight;}return f>g||t>e;};
d.prototype._showHideTruncateButton=function(){var n=this.getDomRef(),C=sap.ui.getCore();if(!n){return;}if(this._canTruncate()&&(!this.getHideShowMoreButton())){this.getDomRef('expandCollapseButton').classList.remove('sapMNLI-CollapseButtonHide');if(this.getTruncate()){this.getAggregation('_collapseButton').setText(this._expandText);n.querySelector('.sapMNLI-Header').classList.remove('sapMNLI-TitleWrapper--is-expanded');if(this.getDescription()){n.querySelector('.sapMNLI-TextWrapper').classList.remove('sapMNLI-TextWrapper--is-expanded');}}else{this.getAggregation('_collapseButton').setText(this._collapseText);this.$().find('.sapMNLI-TextWrapper').toggleClass('sapMNLI-TextWrapper--is-expanded',this.getDescription());n.querySelector('.sapMNLI-Header').classList.add('sapMNLI-TitleWrapper--is-expanded');}}else{this.getDomRef('expandCollapseButton').classList.add('sapMNLI-CollapseButtonHide');}if(this.getDescription()){n.querySelector('.sapMNLI-TextWrapper').classList.remove('sapMNLI-TextWrapper--initial-overwrite');}if(this.getTitle()){n.querySelector('.sapMNLI-Header').classList.remove('sapMNLI-TitleWrapper--initial-overwrite');}C.detachThemeChanged(this._showHideTruncateButton,this);};
d.prototype._deregisterResize=function(){if(this._sNotificationResizeHandler){R.deregister(this._sNotificationResizeHandler);this._sNotificationResizeHandler=null;}};
d.prototype._registerResize=function(){var t=this;var n=this.getDomRef();if(!n){return;}t._resizeNotification();this._sNotificationResizeHandler=R.register(n,function(){t._resizeNotification();});};
d.prototype._resizeNotification=function(){var n=this.getDomRef();var e=sap.ui.getCore();if(n.offsetWidth>=640){n.classList.add('sapMNLI-LSize');}else{n.classList.remove('sapMNLI-LSize');}if(this._getDescriptionText().getText()){n.querySelector('.sapMNLI-TextWrapper').classList.remove('sapMNLI-TextWrapper--is-expanded');n.querySelector('.sapMNLI-TextWrapper').classList.add('sapMNLI-TextWrapper--initial-overwrite');}n.querySelector('.sapMNLI-Header').classList.remove('sapMNLI-TitleWrapper--is-expanded');n.querySelector('.sapMNLI-Header').classList.add('sapMNLI-TitleWrapper--initial-overwrite');if(e.isThemeApplied()){this._showHideTruncateButton();}else{e.attachThemeChanged(this._showHideTruncateButton,this);}};
return d;});
sap.ui.predefine('sap/m/NotificationListItemRenderer',["sap/ui/core/library"],function(c){'use strict';var P=c.Priority;var N={};var a='sapMNLI';var b='sapMNLB';var d='sapMNLI-TextWrapper';var e='sapMLIB';var f='sapMNLB-AuthorPicture';var g='sapMNLB-Priority';var h='sapMNLB-Header';var i='sapMNLI-Header';var j='sapMNLI-Body';var k='sapMNLI-Description';var l='sapMNLI-Details';var m='sapMNLB-Bullet';var n='sapMNLB-Footer';var o='sapMNLI-Footer';var p='sapMNLI-No-Footer';var q='sapMNLB-CloseButton';var r='sapMNLI-CollapseButton';var s='sapMNLI-TitleWrapper--initial-overwrite';var t='sapMNLI-TextWrapper--initial-overwrite';
N.render=function(R,C){if(C.getVisible()){var v=C.getId();var w=(v+'-title')+' '+(v+'-body')+' '+(v+'-info');R.write('<li');R.addClass(a);R.addClass(b);R.addClass(e);R.writeControlData(C);R.writeAttribute('tabindex','0');R.writeAccessibilityState(C,{role:"listitem",labelledby:w});R.writeClasses();R.write('>');this.renderPriorityArea(R,C);this.renderMessageStrip(R,C);this.renderHeader(R,C);this.renderBody(R,C);this.renderFooter(R,C);R.write('</li>');}else{this.renderInvisibleItem(R,C);}};
N.renderPriorityArea=function(R,C){R.write('<div');var v='';switch(C.getPriority()){case(P.Low):v='sapMNLB-Low';break;case(P.Medium):v='sapMNLB-Medium';break;case(P.High):v='sapMNLB-High';break;default:v='sapMNLB-None';break;}R.addClass(g);R.addClass(v);R.writeClasses();R.write('>');R.write('</div>');};
N.renderMessageStrip=function(R,C){R.renderControl(C.getProcessingMessage());};
N.renderAuthorPicture=function(R,C){if(!C.getAuthorPicture()){return;}R.write('<div');R.addClass(f);R.writeClasses();R.write('>');R.renderControl(C._getAuthorImage());R.write('</div>');};
N.renderCloseButton=function(R,C){if(C.getShowCloseButton()){R.renderControl(C.getAggregation('_closeButton').addStyleClass(q));}};
N.renderCollapseButton=function(R,C){R.renderControl(C.getAggregation('_collapseButton').addStyleClass(r));};
N.renderHeader=function(R,C){R.write('<div');R.addClass(h);R.addClass(i);R.addClass(s);if(u(C)){R.addClass(p);}R.writeClasses();R.write('>');this.renderCloseButton(R,C);this.renderTitle(R,C);R.write('</div>');};
N.renderTitle=function(R,C){R.renderControl(C._getHeaderTitle());};
N.renderBody=function(R,C){if(!C._getDescriptionText().getText()&&!C.getAuthorName()&&!C.getDatetime()&&!C.getAuthorPicture()){return;}R.write('<div');R.addClass(j);if(u(C)){R.addClass(p);}R.writeClasses();R.write('>');this.renderAuthorPicture(R,C);R.write('<div class='+k+'>');this.renderDescription(R,C);this.renderDetails(R,C);R.write('</div>');this.renderAriaText(R,C);R.write('</div>');};
N.renderDescription=function(R,C){if(!C._getDescriptionText().getText()){return;}R.write('<div');R.addClass(d);R.addClass(t);R.writeClasses();R.write('>');R.renderControl(C._getDescriptionText());R.write('</div>');};
N.renderDetails=function(R,C){if(!C.getAuthorName()&&!C.getDatetime()){return;}R.write('<div class="'+l+'">');this.renderAuthorName(R,C);if(C.getAuthorName()){R.write('<span class="'+m+'">&#x00B7</span>');}this.renderDatetime(R,C);R.write('</div>');};
N.renderDatetime=function(R,C){R.renderControl(C._getDateTimeText());};
N.renderAuthorName=function(R,C){R.renderControl(C._getAuthorName());};
N.renderAriaText=function(R,C){R.renderControl(C._ariaDetailsText);};
N.renderFooter=function(R,C){var B=C.getButtons();R.write('<div');R.addClass(o);R.addClass(n);R.writeClasses();R.write('>');this.renderCollapseButton(R,C);if(B&&B.length&&C.getShowButtons()){R.renderControl(C.getAggregation('_overflowToolbar'));}R.write('</div>');};
N.renderInvisibleItem=function(R,C){R.write("<li");R.writeInvisiblePlaceholderData(C);R.write(">");R.write("</li>");};
function u(C){return C.getHideShowMoreButton()&&(!C.getShowButtons()||!C.getButtons());}
return N;},true);
sap.ui.predefine('sap/m/NumericContent',['./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/m/Image','./NumericContentRenderer',"sap/ui/events/KeyCodes","sap/base/util/deepEqual"],function(l,C,I,a,N,K,d){"use strict";
var b=C.extend("sap.m.NumericContent",{metadata:{library:"sap.m",properties:{"animateTextChange":{type:"boolean",group:"Behavior",defaultValue:true},"formatterValue":{type:"boolean",group:"Data",defaultValue:false},"icon":{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},"iconDescription":{type:"string",group:"Accessibility",defaultValue:null},"indicator":{type:"sap.m.DeviationIndicator",group:"Appearance",defaultValue:"None"},"nullifyValue":{type:"boolean",group:"Behavior",defaultValue:true},"scale":{type:"string",group:"Appearance",defaultValue:null},"size":{type:"sap.m.Size",group:"Appearance",defaultValue:"Auto"},"truncateValueTo":{type:"int",group:"Appearance",defaultValue:4},"value":{type:"string",group:"Data",defaultValue:null},"valueColor":{type:"sap.m.ValueColor",group:"Appearance",defaultValue:"Neutral"},"width":{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},"withMargin":{type:"boolean",group:"Appearance",defaultValue:true},"state":{type:"sap.m.LoadState",group:"Behavior",defaultValue:"Loaded"}},events:{"press":{}}}});
b.prototype.init=function(){this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.setTooltip("{AltText}");};
b.prototype.onBeforeRendering=function(){this.$().unbind("mouseenter");this.$().unbind("mouseleave");};
b.prototype.onAfterRendering=function(){this.$().bind("mouseenter",this._addTooltip.bind(this));this.$().bind("mouseleave",this._removeTooltip.bind(this));if(l.LoadState.Loaded==this.getState()||this.getAnimateTextChange()){jQuery(document.getElementById(this.getId())).animate({opacity:"1"},1000);}};
b.prototype._addTooltip=function(){this.$().attr("title",this.getTooltip_AsString());};
b.prototype._removeTooltip=function(){this.$().attr("title",null);};
b.prototype.exit=function(){if(this._oIcon){this._oIcon.destroy();}};
b.prototype.getAltText=function(){var v=this.getValue();var s=this.getScale();var e;var m=this._rb.getText(("SEMANTIC_COLOR_"+this.getValueColor()).toUpperCase());var A="";if(this.getNullifyValue()){e="0";}else{e="";}if(this.getIconDescription()){A=A.concat(this.getIconDescription());A=A.concat("\n");}if(v){A=A.concat(v+s);}else{A=A.concat(e);}A=A.concat("\n");if(this.getIndicator()&&this.getIndicator()!==l.DeviationIndicator.None){A=A.concat(this._rb.getText(("NUMERICCONTENT_DEVIATION_"+this.getIndicator()).toUpperCase()));A=A.concat("\n");}A=A.concat(m);return A;};
b.prototype.getTooltip_AsString=function(){var t=this.getTooltip();var T=this.getAltText();if(typeof t==="string"||t instanceof String){T=t.split("{AltText}").join(T).split("((AltText))").join(T);return T;}if(t){return t;}else{return"";}};
b.prototype.setIcon=function(u){var v=!d(this.getIcon(),u);if(v){if(this._oIcon){this._oIcon.destroy();this._oIcon=undefined;}if(u){this._oIcon=I.createControlByURI({id:this.getId()+"-icon-image",src:u},a);}}this._setPointerOnIcon();return this.setProperty("icon",u);};
b.prototype._setPointerOnIcon=function(){if(this._oIcon&&this.hasListeners("press")){this._oIcon.addStyleClass("sapMPointer");}else if(this._oIcon&&this._oIcon.hasStyleClass("sapMPointer")){this._oIcon.removeStyleClass("sapMPointer");}};
b.prototype.ontap=function(e){this.$().focus();this.firePress();e.preventDefault();};
b.prototype.onkeyup=function(e){if(e.which===K.ENTER||e.which===K.SPACE){this.firePress();e.preventDefault();}};
b.prototype.onkeydown=function(e){if(e.which===K.SPACE){e.preventDefault();}};
b.prototype.attachEvent=function(e,c,f,g){C.prototype.attachEvent.call(this,e,c,f,g);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapMPointer");this._setPointerOnIcon();}return this;};
b.prototype.detachEvent=function(e,f,c){C.prototype.detachEvent.call(this,e,f,c);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapMPointer");this._setPointerOnIcon();}return this;};
b.prototype._parseFormattedValue=function(v){var t=v.replace(String.fromCharCode(8206),"").replace(String.fromCharCode(8207),"");return{scale:t.replace(/[+-., \d]*(.*)$/g,"$1").trim().replace(/\.$/,""),value:t.replace(/([+-., \d]*).*$/g,"$1").trim()};};
return b;});
sap.ui.predefine('sap/m/ObjectAttribute',['./library','sap/ui/core/Control','sap/ui/core/library','sap/m/Text','./ObjectAttributeRenderer',"sap/base/Log"],function(l,C,c,T,O,L){"use strict";var a=c.TextDirection;
var b=C.extend("sap.m.ObjectAttribute",{metadata:{library:"sap.m",designtime:"sap/m/designtime/ObjectAttribute.designtime",properties:{title:{type:"string",group:"Misc",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null},active:{type:"boolean",group:"Misc",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:a.Inherit}},aggregations:{customContent:{type:"sap.ui.core.Control",multiple:false},_textControl:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{press:{parameters:{domRef:{type:"string"}}}},dnd:{draggable:true,droppable:false}}});
b.prototype.init=function(){this.setAggregation('_text