# Module.mk for the proofx module
# Copyright (c) 2005 Rene Brun and Fons Rademakers
#
# Author: Gerardo Ganis  12/12/2005

MODNAME      := proofx
MODDIR       := $(ROOT_SRCDIR)/proof/$(MODNAME)
MODDIRS      := $(MODDIR)/src
MODDIRI      := $(MODDIR)/inc

PROOFXDIR    := $(MODDIR)
PROOFXDIRS   := $(PROOFXDIR)/src
PROOFXDIRI   := $(PROOFXDIR)/inc

##### libProofx #####
PROOFXL      := $(MODDIRI)/LinkDef.h
PROOFXDS     := $(call stripsrc,$(MODDIRS)/G__Proofx.cxx)
PROOFXDO     := $(PROOFXDS:.cxx=.o)
PROOFXDH     := $(PROOFXDS:.cxx=.h)

ifeq ($(PLATFORM),win32)
PROOFXH      := $(MODDIRI)/TXProofMgr.h $(MODDIRI)/TXSlave.h \
                $(MODDIRI)/TXSocket.h $(MODDIRI)/TXSocketHandler.h \
                $(MODDIRI)/TXHandler.h
PROOFXS      := $(MODDIRS)/TXProofMgr.cxx $(MODDIRS)/TXSlave.cxx \
                $(MODDIRS)/TXSocket.cxx $(MODDIRS)/TXSocketHandler.cxx \
                $(MODDIRS)/TXHandler.cxx
else
PROOFXH      := $(filter-out $(MODDIRI)/LinkDef%,$(wildcard $(MODDIRI)/*.h))
PROOFXS      := $(filter-out $(MODDIRS)/G__%,$(wildcard $(MODDIRS)/*.cxx))
endif
PROOFXO      := $(call stripsrc,$(PROOFXS:.cxx=.o))

PROOFXDEP    := $(PROOFXO:.o=.d) $(PROOFXDO:.o=.d)

PROOFXLIB    := $(LPATH)/libProofx.$(SOEXT)
PROOFXMAP    := $(PROOFXLIB:.$(SOEXT)=.rootmap)

ifeq ($(HASXRD),yes)
# used in the main Makefile
PROOFXH_REL  := $(patsubst $(MODDIRI)/%.h,include/%.h,$(PROOFXH))
ALLHDRS      += $(PROOFXH_REL)
ALLLIBS      += $(PROOFXLIB)
ALLMAPS      += $(PROOFXMAP)
ifeq ($(CXXMODULES),yes)
  CXXMODULES_HEADERS := $(patsubst include/%,header \"%\"\\n,$(PROOFXH_REL))
  CXXMODULES_MODULEMAP_CONTENTS += module Proof_$(MODNAME) { \\n
  CXXMODULES_MODULEMAP_CONTENTS += $(CXXMODULES_HEADERS)
  CXXMODULES_MODULEMAP_CONTENTS += "export \* \\n"
  CXXMODULES_MODULEMAP_CONTENTS += link \"$(PROOFXLIB)\" \\n
  CXXMODULES_MODULEMAP_CONTENTS += } \\n
endif

# include all dependency files
INCLUDEFILES += $(PROOFXDEP)
endif

# When using an external XROOTD distribution XROOTDDIRI and XROOTDDIRL
# are undefined and have to point to the specified inc and lib dirs.
ifneq ($(XRDINCDIR),)
ifeq ($(XROOTDDIRI),)
XROOTDDIRI   := $(XRDINCDIR)
endif
endif
ifneq ($(XRDLIBDIR),)
ifeq ($(XROOTDDIRL),)
XROOTDDIRL   := $(XRDLIBDIR)
endif
endif

# Xrootd includes
PROOFXINCEXTRA := $(PROOFXDIRI:%=-I%)
PROOFXINCEXTRA += $(XROOTDDIRI:%=-I%)
PROOFXINCEXTRA += $(PROOFDDIRI:%=-I%)
ifeq ($(XRDINCPRIVATE),yes)
PROOFXINCEXTRA += -I$(XRDINCDIR)/private
else
ifeq ($(XRDINCPRIVATE),proof)
PROOFXINCEXTRA += -Iproof/xrdinc
endif
endif

# Xrootd client libs
ifeq ($(PLATFORM),win32)
PROOFXLIBEXTRA += $(XROOTDDIRL)/libXrdClient.lib
else
ifeq ($(HASXRDUTILS),no)
PROOFXLIBEXTRA += $(XROOTDDIRL) -lXrdOuc -lXrdSys -lXrdNet \
                  -lpthread
# Starting from Jul 2010 XrdNet has been split in two libs:
#    XrdNet and XrdNetUtil
# both are needed
XRDNETUTIL     :=
ifneq ($(XRDVERSION),)
XRDNETUTIL     := $(shell if test $(XRDVERSION) -gt 20100729; then \
                             echo "yes"; \
                          fi)
endif
ifeq ($(XRDNETUTIL),yes)
PROOFXLIBEXTRA += -lXrdNetUtil
endif
else
PROOFXLIBEXTRA += $(XROOTDDIRL) -lXrdUtils
endif
ifeq ($(BUILDXRDCLT),yes)
PROOFXLIBEXTRA += -L$(LPATH) -lXrdClient
else
PROOFXLIBEXTRA += $(XROOTDDIRL) -lXrdClient
endif

endif

##### local rules #####
.PHONY:         all-$(MODNAME) clean-$(MODNAME) distclean-$(MODNAME)

include/%.h:    $(PROOFXDIRI)/%.h $(XROOTDMAKE)
		cp $< $@

$(PROOFXLIB):   $(PROOFXO) $(PROOFXDO) $(XPCONNO) $(ORDER_) $(MAINLIBS) \
                $(PROOFXLIBDEP) $(XRDPROOFXD)
		@$(MAKELIB) $(PLATFORM) $(LD) "$(LDFLAGS)" \
		   "$(SOFLAGS)" libProofx.$(SOEXT) $@ \
		   "$(PROOFXO) $(XPCONNO) $(PROOFXDO)" \
		   "$(PROOFXLIBEXTRA)"

$(call pcmrule,PROOFX)
	$(noop)

$(PROOFXDS):    $(PROOFXH) $(PROOFXL) $(XROOTDMAKE) $(ROOTCLINGEXE) $(call pcmdep,PROOFX)
		$(MAKEDIR)
		@echo "Generating dictionary $@..."
		$(ROOTCLINGSTAGE2) -f $@ $(call dictModule,PROOFX) -c $(PROOFXINCEXTRA) $(PROOFXH) $(PROOFXL)

$(PROOFXMAP):   $(PROOFXH) $(PROOFXL) $(XROOTDMAKE) $(ROOTCLINGEXE) $(call pcmdep,PROOFX)
		$(MAKEDIR)
		@echo "Generating rootmap $@..."
		$(ROOTCLINGSTAGE2) -r $(PROOFXDS) $(call dictModule,PROOFX) -c $(PROOFXINCEXTRA) $(PROOFXH) $(PROOFXL)

all-$(MODNAME): $(PROOFXLIB)

clean-$(MODNAME):
		@rm -f $(PROOFXO) $(PROOFXDO)

clean::         clean-$(MODNAME)

distclean-$(MODNAME): clean-$(MODNAME)
		@rm -f $(PROOFXDEP) $(PROOFXDS) $(PROOFXDH) $(PROOFXLIB) $(PROOFXMAP)

distclean::     distclean-$(MODNAME)

##### extra rules ######
$(PROOFXO) $(PROOFXDO): $(XROOTDMAKE) $(XRDHDRS)

ifeq ($(PLATFORM),win32)
$(PROOFXO) $(PROOFXDO): CXXFLAGS += $(PROOFXINCEXTRA) $(EXTRA_XRDFLAGS)
else
ifneq ($(ICC_GE_9),)
# remove when xrootd has moved from strstream.h -> sstream.
$(PROOFXO) $(PROOFXDO): CXXFLAGS += -Wno-deprecated $(PROOFXINCEXTRA) $(EXTRA_XRDFLAGS)
else
ifneq ($(GCC_MAJOR),)
ifneq ($(GCC_MAJOR),2)
# remove when xrootd has moved from strstream.h -> sstream.
$(PROOFXO) $(PROOFXDO): CXXFLAGS += -Wno-deprecated $(PROOFXINCEXTRA) $(EXTRA_XRDFLAGS)
else
$(PROOFXO) $(PROOFXDO): CXXFLAGS += $(PROOFXINCEXTRA) $(EXTRA_XRDFLAGS)
endif
else
$(PROOFXO) $(PROOFXDO): CXXFLAGS += $(PROOFXINCEXTRA) $(EXTRA_XRDFLAGS)
endif
endif
endif
