/*-
 * $Id: rr-client.c,v 1.31 2002/08/15 16:21:41 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#include <librr/rr.h>
#include <profiles/rot13/rot13.h>
#include <profiles/null_echo/echo.h>

#include <string.h>

static void
do_tests (RRConnection *connection)
{
	RRNullEcho *echo;
	GError *err = NULL;
	gchar buffer[80];
	const gchar *message = RR_BEEP_MIME_HEADER "<data>Foo Bar Baz</data>\r\n";

	if ((echo = (RRNullEcho *)rr_connection_start (connection, NULL,
						    RR_TYPE_NULL_ECHO, 
						    NULL, &err)) == NULL)
		g_error ("rr_connection_start failed: %s\n", err->message);

	if (!rr_null_echo_trip (echo, 
				message, strlen (message) + 1, 
				buffer,  strlen (message) + 1, 
				&err)) 
		g_error ("rr_null_echo_trip: %s\n", err->message);

	if (memcmp (message, buffer, strlen (message)) != 0)
		g_error ("EEEK, data missmatch\n");
	else
		g_print ("The string was successfully transferred\n");

	if (!rr_channel_close (RR_CHANNEL (echo), 200, "sv", "Foo", &err))
		g_error ("rr_channel_close: %s\n", err->message);
		
	g_object_unref (G_OBJECT (echo));
}

static gpointer
my_thread (gpointer data)
{
	RRConnection *connection = RR_CONNECTION (data);
	for (;;)
		do_tests (connection);
	return NULL;
}


static RRConnection *
init_connection (const gchar *hostname, gint port)
{
	RRProfileRegistry *profreg;
	RRConnection *conn;
	GError *error = NULL;
	gint use_rot13 = TRUE;

	/* Tell roadrunner which profiles we want to support */
	profreg = rr_profile_registry_new ();
	rr_profile_registry_add_profile (profreg, RR_TYPE_ROT13, NULL);
	rr_profile_registry_add_profile (profreg, RR_TYPE_NULL_ECHO, NULL);

	/* Create a connection object */
	if ((conn = rr_tcp_connection_new (profreg, hostname, port, 
					   &error)) == NULL)
		g_error ("connection failed: %s\n", error->message);

	/* Check if the remote peer supports the profiles we need */
	g_assert (rr_connection_peer_supports_profile (conn, RR_TYPE_ROT13));
	g_assert (rr_connection_peer_supports_profile (conn, RR_TYPE_NULL_ECHO));

	if (use_rot13 && !rr_rot13_start (conn, &error))
	    g_error ("rr_rot13_start failed: %s\n", error->message);

	return conn;
}

int
main (gint argc, gchar **argv)
{
	RRConnection *connection;
	GThread *t1, *t2, *t3;
	GError *error = NULL;

	if (!rr_init (&argc, &argv, &error))
		g_error ("rr_init failed: %s\n", error->message);

	connection = init_connection ("localhost", 10289);

	t1 = g_thread_create (my_thread, connection, TRUE, NULL);
	t2 = g_thread_create (my_thread, connection, TRUE, NULL);
	t3 = g_thread_create (my_thread, connection, TRUE, NULL);

	g_thread_join (t1);
	g_thread_join (t2);
	g_thread_join (t3);

	if (!rr_connection_disconnect (connection, &error))
		g_error ("rr_connection_disconnect failed: %s\n", 
			 error->message);

	if (!rr_exit (&error))
		g_error ("rr_exit failed: %s\n", error->message);
		
	return 0;
}
