/*-
 * $Id: rot13-filter.h,v 1.3 2002/05/11 17:54:01 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#ifndef __RR_ROT13_FILTER_H__
#define __RR_ROT13_FILTER_H__

typedef struct _RRRot13Filter RRRot13Filter;
typedef struct _RRRot13FilterClass RRRot13FilterClass;

#include <librr/rr-filter.h>

G_BEGIN_DECLS

#define RR_TYPE_ROT13_FILTER (rr_rot13_filter_get_type ())
#define RR_ROT13_FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), RR_TYPE_ROT13_FILTER, RRRot13Filter))
#define RR_ROT13_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RR_TYPE_ROT13_FILTER, RRRot13FilterClass))
#define RR_IS_ROT13_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), RR_TYPE_ROT13_FILTER))
#define RR_IS_ROT13_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RR_TYPE_ROT13_FILTER))
#define RR_ROT13_FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RR_TYPE_ROT13_FILTER, RRRot13FilterClass))

struct _RRRot13Filter {
	RRFilter parent_object;
	gboolean decrypt_read;
	gboolean encrypt_write;
};

struct _RRRot13FilterClass {
	RRFilterClass parent_class;
};

GType rr_rot13_filter_get_type (void);
	
RRRot13Filter *rr_rot13_filter_new (void);

G_END_DECLS

#endif /* __RR_ROT13_FILTER_H__ */
