/*-
 * $Id: rot13-filter.c,v 1.4 2002/05/11 17:54:01 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#include <librr/rr.h>
#include "rot13-filter.h"

static GIOStatus rot13_filter_read (RRFilter *filter, guint8 *data, 
				    gsize len, gsize *read, 
				    GSList *stack, GError **error);

static GIOStatus rot13_filter_write (RRFilter *filter, guint8 *data, 
				     gsize len, gsize *written, 
				     GSList *stack, GError **error);

static void
rr_rot13_filter_init (GObject *object)
{
}

static void
rr_rot13_filter_class_init (GObjectClass *klass)
{
	RRFilterClass *filter_class = (RRFilterClass *)klass;

	filter_class->read = rot13_filter_read;
	filter_class->write = rot13_filter_write;
}

GType 
rr_rot13_filter_get_type (void)
{
	static GType rr_type = 0;

	if (!rr_type) {
		static GTypeInfo type_info = {
			sizeof (RRRot13FilterClass),
			NULL,
			NULL,
			(GClassInitFunc) rr_rot13_filter_class_init,
			NULL,
			NULL,
			sizeof (RRRot13Filter),
			16,
			(GInstanceInitFunc) rr_rot13_filter_init
		};
		rr_type = g_type_register_static (RR_TYPE_FILTER, "RRRot13Filter", 
						  &type_info, 0);
	}
	return rr_type;
}

static void
apply_rot13 (guint8 *data, gsize len)
{
	guint8 *ptr = data, *end = data + len, cap;

	while (ptr != end) {
		cap = *ptr & 32;
		*ptr &= ~cap;
		*ptr = ((*ptr >= 'A') && (*ptr <= 'Z') ? 
			((*ptr - 'A' + 13) % 26 + 'A') : 
			*ptr) | cap;
		ptr++;
	}
}

static GIOStatus
rot13_filter_read (RRFilter *filter, guint8 *data, gsize len, gsize *read,
		GSList *stack, GError **error)
{
	RRRot13Filter *rot13filter = RR_ROT13_FILTER (filter);
	GIOStatus status;
	
	/* Call the other writers in the stack */
	status = rr_filterstack_read_next (stack, data, len, read, error);

	if (rot13filter->decrypt_read)
		apply_rot13 (data, *read);

	return status;
}

static GIOStatus
rot13_filter_write (RRFilter *filter, guint8 *data, gsize len, 
		  gsize *written, GSList *stack, GError **error)
{
	RRRot13Filter *rot13filter = RR_ROT13_FILTER (filter);

	if (rot13filter->encrypt_write)
		apply_rot13 (data, len);

	/* Call the other writers in the stack */
	return rr_filterstack_write_next (stack, data, len, written, error);
}

RRRot13Filter *
rr_rot13_filter_new ()
{
	return g_object_new (RR_TYPE_ROT13_FILTER, NULL);
}
