/*-
 * $Id: rr-tcplistener.h,v 1.3 2002/05/11 17:54:01 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#ifndef __RR_TCPLISTENER_H__
#define __RR_TCPLISTENER_H__

typedef struct _RRTCPListener RRTCPListener;
typedef struct _RRTCPListenerClass RRTCPListenerClass;

#include <librr/rr-listener.h>

G_BEGIN_DECLS

#define RR_TYPE_TCP_LISTENER (rr_tcp_listener_get_type ())
#define RR_TCP_LISTENER(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), RR_TYPE_TCP_LISTENER, RRTCPListener))
#define RR_TCP_LISTENER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RR_TYPE_TCP_LISTENER, RRTCPListenerClass))
#define RR_IS_TCP_LISTENER(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), RR_TYPE_TCP_LISTENER))
#define RR_IS_TCP_LISTENER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RR_TYPE_TCP_LISTENER))
#define RR_TCP_LISTENER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RR_TYPE_TCP_LISTENER, RRTCPListenerClass))

struct _RRTCPListener {
	RRListener parent_object;

	GIOChannel *iochannel;

	GStaticMutex in_active;
	guint in_event;

	GStaticMutex err_active;
	guint err_event;
};

struct _RRTCPListenerClass {
	RRListenerClass parent_class;
};

GType rr_tcp_listener_get_type (void);

RRListener *rr_tcp_listener_new (RRProfileRegistry *profreg,
				 const gchar *hostname, gint port, 
				 GError **error);

gboolean rr_tcp_listener_listen (RRTCPListener *listener,
				const gchar *hostname, gint port, 
				 GError **error);

G_END_DECLS

#endif /* __RR_TCPLISTENER_H__ */
