/*-
 * $Id: rr-tcpfilter.h,v 1.2 2002/05/11 17:54:01 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#ifndef __RR_TCP_FILTER_H__
#define __RR_TCP_FILTER_H__

typedef struct _RRTCPFilter RRTCPFilter;
typedef struct _RRTCPFilterClass RRTCPFilterClass;

#include <librr/rr-filter.h>

G_BEGIN_DECLS

#define RR_TYPE_TCP_FILTER (rr_tcp_filter_get_type ())
#define RR_TCP_FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), RR_TYPE_TCP_FILTER, RRTCPFilter))
#define RR_TCP_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RR_TYPE_TCP_FILTER, RRTCPFilterClass))
#define RR_IS_TCP_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), RR_TYPE_TCP_FILTER))
#define RR_IS_TCP_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RR_TYPE_TCP_FILTER))
#define RR_TCP_FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RR_TYPE_TCP_FILTER, RRTCPFilterClass))

struct _RRTCPFilter {
	RRFilter parent_object;

	GIOChannel *iochannel;
};

struct _RRTCPFilterClass {
	RRFilterClass parent_class;
};

GType rr_tcp_filter_get_type (void);
	
RRTCPFilter *rr_tcp_filter_new (void);

void rr_tcp_filter_set_iochannel (RRTCPFilter *tcpfilter, 
				  GIOChannel *iochannel);

G_END_DECLS

#endif /* __RR_TCP_FILTER_H__ */
