/*-
 * $Id: rr.h,v 1.31 2002/12/12 14:59:53 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#ifndef __RR_H__
#define __RR_H__

#include <librr/rr-debug.h>
#include <librr/rr-workpool.h>
#include <librr/rr-beeperror.h>
#include <librr/rr-connection.h>
#include <librr/rr-frame.h>
#include <librr/rr-filter.h>
#include <librr/rr-filterstack.h>
#include <librr/rr-framefactory.h>
#include <librr/rr-channel.h>
#include <librr/rr-profileregistry.h>
#include <librr/rr-manager.h>
#include <librr/rr-mime.h>
#include <librr/tcp/rr-tcpconnection.h>
#include <librr/tcp/rr-tcplistener.h>
#include <librr/tcp/rr-frame-seq.h>
#include <librr/message/rr-message.h>
#include <librr/message/rr-message-close.h>
#include <librr/message/rr-message-error.h>
#include <librr/message/rr-message-start.h>
#include <librr/message/rr-message-startrpy.h>
#include <librr/message/rr-message-static.h>
#include <librr/message/rr-greeting.h>

#define RR_ERROR (rr_error_quark ())

typedef enum
{
	RR_ERROR_OTHER,
	RR_ERROR_GETHOSTBYNAME,
	RR_ERROR_CONNECT,
	RR_ERROR_NOT_READY,
	RR_ERROR_DISCONNECTED,
	RR_ERROR_BIND,
	RR_ERROR_LISTEN,
	RR_ERROR_SOCKET
} RRError;

GQuark rr_error_quark (void);
gboolean rr_init      (gint *argc, gchar ***argv, GError **error);
gboolean rr_exit      (GError **error);
gboolean rr_quit      (GError **error);
gboolean rr_wait_until_done (GError **error);

void rr_set_max_work_threads (int max);
gint rr_get_max_work_threads (void);

void rr_main_work_pool_push (RRWPGroup gid, GFunc func, 
			     gpointer data, gpointer user_data);

void rr_main_work_pool_join (RRWPGroup gid);

GMainContext *rr_get_main_context (void);

#endif /* __RR_H__ */
