/*-
 * $Id: rr-workpool.h,v 1.4 2002/05/11 17:54:01 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#ifndef __RR_WORKPOOL_H__
#define __RR_WORKPOOL_H__

typedef struct _RRWorkPool RRWorkPool;
typedef struct _RRWorkPoolClass RRWorkPoolClass;

#define RRWPGROUP(x) ((RRWPGroup)x)

#include <glib-object.h>

typedef guint RRWPGroup;

G_BEGIN_DECLS

struct _RRWorkPool {
	gint max_threads;
	gint num_threads;
	GSList *work;
	GSList *active;
	GMutex *mutex;
	GCond  *add_cond;
	GCond  *remove_cond;
	gboolean shutdown;
};

RRWorkPool *rr_work_pool_new  (gint max_threads);
void        rr_work_pool_free (RRWorkPool *pool);

void rr_work_pool_push (RRWorkPool *pool,
			RRWPGroup gid, GFunc func, 
			gpointer data, gpointer user_data);

void rr_work_pool_join (RRWorkPool *pool, RRWPGroup gid);

G_END_DECLS

#endif /* __RR_WORKPOOL_H__ */
