#ifndef __RR_PROFILE_REGISTRY_H__
#define __RR_PROFILE_REGISTRY_H__

typedef struct _RRProfileRegistry RRProfileRegistry;
typedef struct _RRProfileRegistryClass RRProfileRegistryClass;

#include <glib-object.h>
#include <librr/rr-channel.h>

G_BEGIN_DECLS

#define RR_TYPE_PROFILE_REGISTRY (rr_profile_registry_get_type ())
#define RR_PROFILE_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), RR_TYPE_PROFILE_REGISTRY, RRProfileRegistry))
#define RR_PROFILE_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RR_TYPE_PROFILE_REGISTRY, RRProfileRegistryClass))
#define RR_IS_PROFILE_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), RR_TYPE_PROFILE_REGISTRY))
#define RR_IS_PROFILE_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RR_TYPE_PROFILE_REGISTRY))
#define RR_PROFILE_REGISTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RR_TYPE_PROFILE_REGISTRY, RRProfileRegistryClass))

struct _RRProfileRegistry {
	GObject parent_object;
	GHashTable *profiles_by_uri;
	GHashTable *config_by_type;
	GStaticRWLock rwlock;
};

struct _RRProfileRegistryClass {
	GObjectClass parent_class;
};

GType rr_profile_registry_get_type (void);

gboolean rr_profile_registry_add_profile (RRProfileRegistry *profreg, 
					  GType type, gpointer global_config);

gboolean rr_profile_registry_remove_profile (RRProfileRegistry *profreg,
					     GType type);

GType rr_profile_registry_lookup_by_uri (RRProfileRegistry *profreg,
					 const gchar *uri);

gpointer rr_profile_registry_get_global_config (RRProfileRegistry *profreg,
						GType type);

RRProfileRegistry *rr_profile_registry_dup (RRProfileRegistry *profreg);

RRProfileRegistry *rr_profile_registry_new (void);

G_END_DECLS

#endif /* __RR_PROFILE_REGISTRY_H__ */


